/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.compare;

import java.util.ResourceBundle;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.CompareUI;
import org.eclipse.compare.CompareViewerSwitchingPane;
import org.eclipse.compare.structuremergeviewer.ICompareInput;
import org.eclipse.jdt.internal.ui.compare.JavaCompareUtilities;
import org.eclipse.jdt.internal.ui.compare.ResizableDialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.help.WorkbenchHelp;

class CompareDialog
extends ResizableDialog {
    private CompareViewerSwitchingPane fContentPane;
    private CompareConfiguration fCompareConfiguration = new CompareConfiguration();
    private ICompareInput fInput;

    CompareDialog(Shell parent, ResourceBundle bundle) {
        super(parent, bundle);
        this.fCompareConfiguration.setLeftEditable(false);
        this.fCompareConfiguration.setRightEditable(false);
    }

    void compare(ICompareInput input) {
        this.fInput = input;
        this.fCompareConfiguration.setLeftLabel(this.fInput.getLeft().getName());
        this.fCompareConfiguration.setLeftImage(this.fInput.getLeft().getImage());
        this.fCompareConfiguration.setRightLabel(this.fInput.getRight().getName());
        this.fCompareConfiguration.setRightImage(this.fInput.getRight().getImage());
        if (this.fContentPane != null) {
            this.fContentPane.setInput((Object)this.fInput);
        }
        this.open();
    }

    protected synchronized Control createDialogArea(Composite parent2) {
        Composite parent = (Composite)super.createDialogArea(parent2);
        this.getShell().setText(JavaCompareUtilities.getString(this.fBundle, "title"));
        this.fContentPane = new ViewerSwitchingPane(parent, 0x800800);
        this.fContentPane.setLayoutData((Object)new GridData(1808));
        if (this.fInput != null) {
            this.fContentPane.setInput((Object)this.fInput);
        }
        CompareDialog.applyDialogFont((Control)parent);
        return parent;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        String buttonLabel = JavaCompareUtilities.getString(this.fBundle, "buttonLabel", IDialogConstants.OK_LABEL);
        this.createButton(parent, 1, buttonLabel, false);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        WorkbenchHelp.setHelp((Control)newShell, (String)"org.eclipse.jdt.ui.compare_dialog_context");
    }

    class ViewerSwitchingPane
    extends CompareViewerSwitchingPane {
        ViewerSwitchingPane(Composite parent, int style) {
            super(parent, style, false);
        }

        protected Viewer getViewer(Viewer oldViewer, Object input) {
            if (input instanceof ICompareInput) {
                return CompareUI.findContentViewer((Viewer)oldViewer, (ICompareInput)((ICompareInput)input), (Composite)this, (CompareConfiguration)CompareDialog.this.fCompareConfiguration);
            }
            return null;
        }

        public void setImage(Image image) {
        }
    }
}

