/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.compare;

import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.ResourceBundle;
import org.eclipse.compare.EditionSelectionDialog;
import org.eclipse.compare.IStreamContentAccessor;
import org.eclipse.compare.ITypedElement;
import org.eclipse.compare.structuremergeviewer.DocumentRangeNode;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IParent;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.ImportDeclaration;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.PackageDeclaration;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.dom.NodeFinder;
import org.eclipse.jdt.internal.corext.dom.OldASTRewrite;
import org.eclipse.jdt.internal.corext.textmanipulation.TextBuffer;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.compare.CompareMessages;
import org.eclipse.jdt.internal.ui.compare.JavaCompareUtilities;
import org.eclipse.jdt.internal.ui.compare.JavaHistoryAction;
import org.eclipse.jdt.internal.ui.compare.JavaNode;
import org.eclipse.jdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.jdt.internal.ui.util.ExceptionHandler;
import org.eclipse.jdt.ui.IWorkingCopyManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.util.Assert;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;

public class JavaAddElementFromHistory
extends JavaHistoryAction {
    private static final String BUNDLE_NAME = "org.eclipse.jdt.internal.ui.compare.AddFromHistoryAction";
    static /* synthetic */ Class class$org$eclipse$jdt$core$dom$BodyDeclaration;
    static /* synthetic */ Class class$org$eclipse$jdt$core$dom$MethodDeclaration;

    public JavaAddElementFromHistory() {
        super(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(ISelection selection) {
        String errorTitle = CompareMessages.getString("AddFromHistory.title");
        String errorMessage = CompareMessages.getString("AddFromHistory.internalErrorMessage");
        Shell shell = this.getShell();
        ICompilationUnit cu = null;
        IMember parent = null;
        IMember input = null;
        if (selection.isEmpty()) {
            JavaEditor editor = this.getEditor();
            if (editor != null) {
                IEditorInput editorInput = editor.getEditorInput();
                IWorkingCopyManager manager = JavaPlugin.getDefault().getWorkingCopyManager();
                if (manager != null) {
                    cu = manager.getWorkingCopy(editorInput);
                    parent = cu;
                }
            }
        } else {
            Object o;
            input = this.getEditionElement(selection);
            if (input != null) {
                cu = input.getCompilationUnit();
                if (input != null) {
                    parent = input;
                    input = null;
                }
            } else if (selection instanceof IStructuredSelection && (o = ((IStructuredSelection)selection).getFirstElement()) instanceof ICompilationUnit) {
                cu = (ICompilationUnit)o;
                parent = cu;
            }
        }
        if (parent == null || cu == null) {
            String invalidSelectionMessage = CompareMessages.getString("AddFromHistory.invalidSelectionMessage");
            MessageDialog.openInformation((Shell)shell, (String)errorTitle, (String)invalidSelectionMessage);
            return;
        }
        IFile file = this.getFile(parent);
        if (file == null) {
            MessageDialog.openError((Shell)shell, (String)errorTitle, (String)errorMessage);
            return;
        }
        boolean inEditor = this.beingEdited(file);
        if (inEditor) {
            parent = (IParent)this.getWorkingCopy((IJavaElement)parent);
            if (input != null) {
                input = (IMember)this.getWorkingCopy((IJavaElement)input);
            }
        }
        TextBuffer buffer = null;
        try {
            buffer = TextBuffer.acquire(file);
            if (!buffer.makeCommittable(shell).isOK()) {
                return;
            }
            JavaHistoryAction.JavaTextBufferNode target = new JavaHistoryAction.JavaTextBufferNode(this, buffer, inEditor);
            ITypedElement[] editions = this.buildEditions(target, file);
            ResourceBundle bundle = ResourceBundle.getBundle(BUNDLE_NAME);
            EditionSelectionDialog d = new EditionSelectionDialog(shell, bundle);
            d.setAddMode(true);
            d.setHelpContextId("org.eclipse.jdt.ui.add_element_from_history_dialog_context");
            ITypedElement selected = d.selectEdition((ITypedElement)target, editions, (Object)parent);
            if (selected == null) {
                return;
            }
            ICompilationUnit cu2 = cu;
            if (parent instanceof IMember) {
                cu2 = parent.getCompilationUnit();
            }
            CompilationUnit root = JavaAddElementFromHistory.parsePartialCompilationUnit(cu2, 0, false);
            OldASTRewrite rewriter = new OldASTRewrite((ASTNode)root);
            List list = null;
            int pos = this.getIndex(root, input, list);
            ITypedElement[] results = d.getSelection();
            for (int i = 0; i < results.length; ++i) {
                ASTNode newNode = this.createASTNode(rewriter, results[i], buffer.getLineDelimiter());
                if (newNode == null) {
                    MessageDialog.openError((Shell)shell, (String)errorTitle, (String)errorMessage);
                    return;
                }
                if (newNode instanceof PackageDeclaration) {
                    root.setPackage((PackageDeclaration)newNode);
                } else if (newNode instanceof ImportDeclaration) {
                    root.imports().add(newNode);
                } else {
                    if (list == null && (list = this.getContainerList((IParent)parent, root)) == null) {
                        MessageDialog.openError((Shell)shell, (String)errorTitle, (String)errorMessage);
                        return;
                    }
                    if (pos < 0 || pos >= list.size()) {
                        if (newNode instanceof BodyDeclaration) {
                            pos = ASTNodes.getInsertionIndex((BodyDeclaration)newNode, list);
                            list.add(pos, newNode);
                        } else {
                            list.add(newNode);
                        }
                    } else {
                        list.add(pos + 1, newNode);
                    }
                }
                rewriter.markAsInserted(newNode);
            }
            this.applyChanges(rewriter, buffer, shell, inEditor);
        }
        catch (InvocationTargetException ex) {
            ExceptionHandler.handle(ex, shell, errorTitle, errorMessage);
        }
        catch (InterruptedException ex) {
            Assert.isTrue((boolean)false);
        }
        catch (CoreException ex) {
            ExceptionHandler.handle(ex, shell, errorTitle, errorMessage);
        }
        finally {
            if (buffer != null) {
                TextBuffer.release(buffer);
            }
        }
    }

    private ASTNode createASTNode(OldASTRewrite rewriter, ITypedElement element, String delimiter) throws CoreException {
        int type;
        String content;
        if (element instanceof IStreamContentAccessor && (content = JavaCompareUtilities.readString((IStreamContentAccessor)element)) != null && (content = JavaAddElementFromHistory.trimTextBlock(content, delimiter)) != null && (type = this.getPlaceHolderType(element)) != -1) {
            return rewriter.createStringPlaceholder(content, type);
        }
        return null;
    }

    private List getContainerList(IParent container, CompilationUnit root) throws JavaModelException {
        if (container instanceof ICompilationUnit) {
            return root.types();
        }
        if (container instanceof IType) {
            BodyDeclaration parentNode;
            ISourceRange sourceRange = ((IType)container).getNameRange();
            ASTNode n = NodeFinder.perform((ASTNode)root, sourceRange);
            if (n != null && (parentNode = (BodyDeclaration)ASTNodes.getParent(n, class$org$eclipse$jdt$core$dom$BodyDeclaration == null ? (class$org$eclipse$jdt$core$dom$BodyDeclaration = JavaAddElementFromHistory.class$("org.eclipse.jdt.core.dom.BodyDeclaration")) : class$org$eclipse$jdt$core$dom$BodyDeclaration)) != null) {
                return ((TypeDeclaration)parentNode).bodyDeclarations();
            }
            return null;
        }
        return null;
    }

    private int getPlaceHolderType(ITypedElement element) {
        if (element instanceof DocumentRangeNode) {
            JavaNode jn = (JavaNode)element;
            switch (jn.getTypeCode()) {
                case 1: {
                    return 35;
                }
                case 4: 
                case 5: {
                    return 55;
                }
                case 8: 
                case 9: {
                    return 31;
                }
                case 6: {
                    return 23;
                }
                case 7: {
                    return 28;
                }
                case 2: 
                case 3: {
                    return 26;
                }
                case 0: {
                    return 15;
                }
            }
        }
        return -1;
    }

    private int getIndex(CompilationUnit root, IMember node, List container) throws JavaModelException {
        MethodDeclaration parentNode;
        ISourceRange sourceRange;
        ASTNode n;
        if (node != null && (n = NodeFinder.perform((ASTNode)root, sourceRange = node.getNameRange())) != null && (parentNode = (MethodDeclaration)ASTNodes.getParent(n, class$org$eclipse$jdt$core$dom$MethodDeclaration == null ? (class$org$eclipse$jdt$core$dom$MethodDeclaration = JavaAddElementFromHistory.class$("org.eclipse.jdt.core.dom.MethodDeclaration")) : class$org$eclipse$jdt$core$dom$MethodDeclaration)) != null) {
            return container.indexOf(parentNode);
        }
        return -1;
    }

    protected boolean isEnabled(ISelection selection) {
        Object o;
        if (selection.isEmpty()) {
            JavaEditor editor = this.getEditor();
            if (editor != null) {
                IEditorInput editorInput = editor.getEditorInput();
                IWorkingCopyManager manager = JavaPlugin.getDefault().getWorkingCopyManager();
                return manager.getWorkingCopy(editorInput) != null;
            }
            return false;
        }
        if (selection instanceof IStructuredSelection && (o = ((IStructuredSelection)selection).getFirstElement()) instanceof ICompilationUnit) {
            return true;
        }
        return super.isEnabled(selection);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

