/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.compare;

import java.util.ResourceBundle;
import org.eclipse.compare.EditionSelectionDialog;
import org.eclipse.compare.ITypedElement;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.internal.corext.textmanipulation.TextBuffer;
import org.eclipse.jdt.internal.ui.compare.CompareMessages;
import org.eclipse.jdt.internal.ui.compare.JavaCompareUtilities;
import org.eclipse.jdt.internal.ui.compare.JavaHistoryAction;
import org.eclipse.jdt.internal.ui.util.ExceptionHandler;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Shell;

public class JavaCompareWithEditionAction
extends JavaHistoryAction {
    private static final String BUNDLE_NAME = "org.eclipse.jdt.internal.ui.compare.CompareWithEditionAction";

    public JavaCompareWithEditionAction() {
        super(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(ISelection selection) {
        String errorTitle = CompareMessages.getString("CompareWithHistory.title");
        String errorMessage = CompareMessages.getString("CompareWithHistory.internalErrorMessage");
        IMember input = this.getEditionElement(selection);
        if (input == null) {
            String invalidSelectionMessage = CompareMessages.getString("CompareWithHistory.invalidSelectionMessage");
            MessageDialog.openInformation((Shell)this.getShell(), (String)errorTitle, (String)invalidSelectionMessage);
            return;
        }
        IFile file = this.getFile(input);
        if (file == null) {
            MessageDialog.openError((Shell)this.getShell(), (String)errorTitle, (String)errorMessage);
            return;
        }
        boolean inEditor = this.beingEdited(file);
        if (inEditor) {
            input = (IMember)this.getWorkingCopy((IJavaElement)input);
        }
        TextBuffer buffer = null;
        try {
            buffer = TextBuffer.acquire(file);
            JavaHistoryAction.JavaTextBufferNode target = new JavaHistoryAction.JavaTextBufferNode(this, buffer, inEditor);
            ITypedElement[] editions = this.buildEditions(target, file);
            ResourceBundle bundle = ResourceBundle.getBundle(BUNDLE_NAME);
            EditionSelectionDialog d = new EditionSelectionDialog(this.getShell(), bundle);
            d.setHelpContextId("org.eclipse.jdt.ui.compare_element_with_history_dialog_context");
            d.setCompareMode(true);
            Image image = JavaCompareUtilities.getImage(input);
            d.setEditionTitleImage(image);
            d.selectEdition((ITypedElement)target, editions, (Object)input);
            if (image != null && !image.isDisposed()) {
                image.dispose();
            }
        }
        catch (CoreException ex) {
            ExceptionHandler.handle(ex, this.getShell(), errorTitle, errorMessage);
        }
        finally {
            if (buffer != null) {
                TextBuffer.release(buffer);
            }
        }
    }
}

