/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.java.hover;

import java.io.IOException;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.ILocalVariable;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.ISourceReference;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.codemanipulation.StubUtility;
import org.eclipse.jdt.internal.corext.util.CodeFormatterUtil;
import org.eclipse.jdt.internal.corext.util.Strings;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.text.JavaCodeReader;
import org.eclipse.jdt.internal.ui.text.java.hover.AbstractJavaEditorTextHover;
import org.eclipse.jdt.internal.ui.text.java.hover.SourceViewerInformationControl;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.ITextHoverExtension;
import org.eclipse.jface.text.information.IInformationProviderExtension2;
import org.eclipse.swt.widgets.Shell;

public class JavaSourceHover
extends AbstractJavaEditorTextHover
implements ITextHoverExtension,
IInformationProviderExtension2 {
    protected String getHoverInfo(IJavaElement[] result) {
        int nResults = result.length;
        if (nResults > 1) {
            return null;
        }
        IJavaElement curr = result[0];
        if ((curr instanceof IMember || curr instanceof ILocalVariable) && curr instanceof ISourceReference) {
            try {
                String source = ((ISourceReference)curr).getSource();
                if (source == null) {
                    return null;
                }
                source = this.removeLeadingComments(source);
                String delim = null;
                try {
                    delim = StubUtility.getLineDelimiterUsed(result[0]);
                }
                catch (JavaModelException e) {
                    delim = System.getProperty("line.separator", "\n");
                }
                String[] sourceLines = Strings.convertIntoLines(source);
                String firstLine = sourceLines[0];
                if (!Character.isWhitespace(firstLine.charAt(0))) {
                    sourceLines[0] = "";
                }
                Strings.trimIndentation(sourceLines, CodeFormatterUtil.getTabWidth());
                if (!Character.isWhitespace(firstLine.charAt(0))) {
                    sourceLines[0] = firstLine;
                }
                source = Strings.concatenate(sourceLines, delim);
                return source;
            }
            catch (JavaModelException ex) {
                // empty catch block
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * WARNING - void declaration
     */
    private String removeLeadingComments(String source) {
        void var4_6;
        block13: {
            JavaCodeReader reader = new JavaCodeReader();
            Document document = new Document(source);
            reader.configureForwardReader((IDocument)document, 0, document.getLength(), true, false);
            int c = reader.read();
            while (c != -1 && (c == 13 || c == 10)) {
                c = reader.read();
            }
            int i = reader.getOffset();
            reader.close();
            Object var7_7 = null;
            try {
                if (reader != null) {
                    reader.close();
                }
                break block13;
            }
            catch (IOException ex2) {
                JavaPlugin.log(ex2);
            }
            break block13;
            {
                catch (IOException ex) {
                    i = 0;
                    Object var7_8 = null;
                    try {
                        if (reader != null) {
                            reader.close();
                        }
                        break block13;
                    }
                    catch (IOException ex2) {
                        JavaPlugin.log(ex2);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var7_9 = null;
                try {
                    if (reader != null) {
                        reader.close();
                    }
                }
                catch (IOException ex2) {
                    JavaPlugin.log(ex2);
                }
                throw throwable;
            }
        }
        if (var4_6 < 0) {
            return source;
        }
        return source.substring((int)var4_6);
    }

    public IInformationControlCreator getHoverControlCreator() {
        return new IInformationControlCreator(){

            public IInformationControl createInformationControl(Shell parent) {
                return new SourceViewerInformationControl(parent, JavaSourceHover.this.getTooltipAffordanceString());
            }
        };
    }

    public IInformationControlCreator getInformationPresenterControlCreator() {
        return new IInformationControlCreator(){

            public IInformationControl createInformationControl(Shell parent) {
                int shellStyle = 16;
                int style = 768;
                return new SourceViewerInformationControl(parent, shellStyle, style);
            }
        };
    }
}

