/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal.search;

import java.io.Reader;
import java.text.BreakIterator;
import java.util.Locale;
import java.util.StringTokenizer;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.LowerCaseFilter;
import org.apache.lucene.analysis.TokenStream;
import org.eclipse.core.runtime.Platform;
import org.eclipse.help.internal.base.HelpBasePlugin;
import org.eclipse.help.internal.base.HelpBaseResources;
import org.eclipse.help.internal.search.WordTokenStream;

public class DefaultAnalyzer
extends Analyzer {
    private Locale locale;

    public DefaultAnalyzer(String localeString) {
        int i;
        Locale userLocale = this.getLocale(localeString);
        Locale[] availableLocales = BreakIterator.getAvailableLocales();
        for (int i2 = 0; i2 < availableLocales.length; ++i2) {
            if (!userLocale.equals(availableLocales[i2])) continue;
            this.locale = userLocale;
            break;
        }
        if (this.locale == null && userLocale.getDisplayVariant().length() > 0) {
            Locale countryLocale = new Locale(userLocale.getLanguage(), userLocale.getCountry());
            for (i = 0; i < availableLocales.length; ++i) {
                if (!countryLocale.equals(availableLocales[i])) continue;
                this.locale = countryLocale;
                break;
            }
        }
        if (this.locale == null && userLocale.getCountry().length() > 0) {
            Locale language = new Locale(userLocale.getLanguage(), "");
            for (i = 0; i < availableLocales.length; ++i) {
                if (!language.equals(availableLocales[i])) continue;
                this.locale = language;
                break;
            }
        }
        if (this.locale == null) {
            HelpBasePlugin.logError(HelpBaseResources.getString("ES24", localeString), null);
            this.locale = new Locale("en", "US");
        }
    }

    public final TokenStream tokenStream(String fieldName, Reader reader) {
        return new LowerCaseFilter((TokenStream)new WordTokenStream(fieldName, reader, this.locale));
    }

    private Locale getLocale(String clientLocale) {
        StringTokenizer locales;
        if (clientLocale == null) {
            clientLocale = Platform.getNL();
        }
        if (clientLocale == null) {
            clientLocale = Locale.getDefault().toString();
        }
        if ((locales = new StringTokenizer(clientLocale, "_")).countTokens() == 1) {
            return new Locale(locales.nextToken(), "");
        }
        if (locales.countTokens() == 2) {
            return new Locale(locales.nextToken(), locales.nextToken());
        }
        if (locales.countTokens() == 3) {
            return new Locale(locales.nextToken(), locales.nextToken(), locales.nextToken());
        }
        return Locale.getDefault();
    }
}

