/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.framework.internal.defaultadaptor;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.StringTokenizer;
import org.eclipse.osgi.framework.adaptor.BundleData;
import org.eclipse.osgi.framework.adaptor.BundleOperation;
import org.eclipse.osgi.framework.adaptor.EventPublisher;
import org.eclipse.osgi.framework.adaptor.PermissionStorage;
import org.eclipse.osgi.framework.adaptor.core.AbstractFrameworkAdaptor;
import org.eclipse.osgi.framework.adaptor.core.AdaptorElementFactory;
import org.eclipse.osgi.framework.adaptor.core.AdaptorMsg;
import org.eclipse.osgi.framework.adaptor.core.ReferenceInputStream;
import org.eclipse.osgi.framework.debug.Debug;
import org.eclipse.osgi.framework.internal.defaultadaptor.DefaultBundleData;
import org.eclipse.osgi.framework.internal.defaultadaptor.DefaultElementFactory;
import org.eclipse.osgi.framework.internal.defaultadaptor.DefaultLog;
import org.eclipse.osgi.framework.internal.defaultadaptor.DefaultPermissionStorage;
import org.eclipse.osgi.framework.internal.defaultadaptor.MetaData;
import org.eclipse.osgi.framework.log.FrameworkLog;
import org.eclipse.osgi.internal.resolver.StateImpl;
import org.eclipse.osgi.internal.resolver.StateManager;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.PlatformAdmin;
import org.eclipse.osgi.service.resolver.State;
import org.eclipse.osgi.service.resolver.StateObjectFactory;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.FrameworkEvent;
import org.osgi.framework.ServiceRegistration;

public class DefaultAdaptor
extends AbstractFrameworkAdaptor {
    public static final String METADATA_ADAPTOR_NEXTID = "METADATA_ADAPTOR_NEXTID";
    public static final String METADATA_ADAPTOR_IBSL = "METADATA_ADAPTOR_IBSL";
    public static final String DATA_DIR_NAME = "data";
    public static final String BUNDLE_STORE = "osgi.bundlestore";
    protected AdaptorElementFactory elementFactory;
    protected File bundleStoreRootDir;
    protected File dataRootDir;
    protected String bundleStore = null;
    protected boolean reset = false;
    protected MetaData fwMetadata;
    protected DefaultPermissionStorage permissionStore;
    protected long nextId = 1L;
    protected StateManager stateManager;
    protected FrameworkLog frameworkLog;
    public static final String METADATA_BUNDLE_GEN = "METADATA_BUNDLE_GEN";
    public static final String METADATA_BUNDLE_LOC = "METADATA_BUNDLE_LOC";
    public static final String METADATA_BUNDLE_REF = "METADATA_BUNDLE_REF";
    public static final String METADATA_BUNDLE_NAME = "METADATA_BUNDLE_NAME";
    public static final String METADATA_BUNDLE_NCP = "METADATA_BUNDLE_NCP";
    public static final String METADATA_BUNDLE_ABSL = "METADATA_BUNDLE_ABSL";
    public static final String METADATA_BUNDLE_STATUS = "METADATA_BUNDLE_STATUS";
    public static final String METADATA_BUNDLE_METADATA = "METADATA_BUNDLE_METADATA";

    public DefaultAdaptor(String[] args) {
        if (args != null) {
            for (int i = 0; i < args.length; ++i) {
                String key;
                StringTokenizer tok;
                String arg = args[i];
                if (arg.equalsIgnoreCase("reset")) {
                    this.reset = true;
                    continue;
                }
                if (arg.indexOf("=") == -1 || (tok = new StringTokenizer(args[i], "=")).countTokens() != 2 || !(key = tok.nextToken()).equalsIgnoreCase("bundledir")) continue;
                this.bundleStore = tok.nextToken();
            }
        }
    }

    public void initialize(EventPublisher eventPublisher) {
        super.initialize(eventPublisher);
        this.initBundleStoreRootDir();
        this.frameworkLog = this.createFrameworkLog();
        this.stateManager = this.createStateManager();
    }

    protected StateManager createStateManager() {
        File stateLocation = new File(this.getBundleStoreRootDir(), ".state");
        this.stateManager = new StateManager(stateLocation);
        StateImpl systemState = this.stateManager.getSystemState();
        if (systemState != null) {
            return this.stateManager;
        }
        systemState = this.stateManager.createSystemState();
        BundleData[] installedBundles = this.getInstalledBundles();
        if (installedBundles == null) {
            return this.stateManager;
        }
        StateObjectFactory factory = this.stateManager.getFactory();
        for (int i = 0; i < installedBundles.length; ++i) {
            BundleData toAdd = installedBundles[i];
            try {
                Dictionary manifest = toAdd.getManifest();
                BundleDescription newDescription = factory.createBundleDescription(manifest, toAdd.getLocation(), toAdd.getBundleID());
                systemState.addBundle(newDescription);
                continue;
            }
            catch (BundleException be) {
                // empty catch block
            }
        }
        systemState.resolve();
        return this.stateManager;
    }

    protected void shutdownStateManager() {
        try {
            this.stateManager.shutdown(new File(this.getBundleStoreRootDir(), ".state"));
        }
        catch (IOException e) {
            this.frameworkLog.log(new FrameworkEvent(2, this.context.getBundle(), (Throwable)e));
        }
    }

    protected FrameworkLog createFrameworkLog() {
        return new DefaultLog();
    }

    protected void initBundleStoreRootDir() {
        if (this.bundleStore == null) {
            this.bundleStore = System.getProperty(BUNDLE_STORE);
            if (this.bundleStore == null) {
                this.bundleStore = this.properties.getProperty(BUNDLE_STORE, "bundles");
            }
        }
        this.bundleStoreRootDir = new File(this.bundleStore);
        this.properties.put(BUNDLE_STORE, this.bundleStoreRootDir.getAbsolutePath());
    }

    protected void initDataRootDir() {
        this.dataRootDir = this.getBundleStoreRootDir();
    }

    public File getBundleStoreRootDir() {
        return this.bundleStoreRootDir;
    }

    public File getDataRootDir() {
        if (this.dataRootDir == null) {
            this.initDataRootDir();
        }
        return this.dataRootDir;
    }

    public void initializeStorage() throws IOException {
        boolean makedir = false;
        File bundleStore = this.getBundleStoreRootDir();
        if (bundleStore.exists()) {
            if (this.reset) {
                makedir = true;
                if (!this.rm(bundleStore) && Debug.DEBUG_GENERAL) {
                    Debug.println((String)("Could not remove directory: " + bundleStore.getPath()));
                }
            } else if (!bundleStore.isDirectory()) {
                if (Debug.DEBUG_GENERAL) {
                    Debug.println((String)("Exists but not a directory: " + bundleStore.getPath()));
                }
                throw new IOException(AdaptorMsg.formatter.getString("ADAPTOR_STORAGE_EXCEPTION"));
            }
        } else {
            makedir = true;
        }
        if (makedir && !bundleStore.mkdirs()) {
            if (Debug.DEBUG_GENERAL) {
                Debug.println((String)("Unable to create directory: " + bundleStore.getPath()));
            }
            throw new IOException(AdaptorMsg.formatter.getString("ADAPTOR_STORAGE_EXCEPTION"));
        }
        this.initializeMetadata();
    }

    protected void initializeMetadata() throws IOException {
        this.fwMetadata = new MetaData(this.getMetaDataFile(), "Framework metadata");
        this.fwMetadata.load();
        this.nextId = this.fwMetadata.getLong(METADATA_ADAPTOR_NEXTID, 1L);
        this.initialBundleStartLevel = this.fwMetadata.getInt(METADATA_ADAPTOR_IBSL, 1);
    }

    protected File getMetaDataFile() {
        return new File(this.getBundleStoreRootDir(), ".framework");
    }

    private void compact(File directory) {
        String[] list;
        if (Debug.DEBUG_GENERAL) {
            Debug.println((String)("compact(" + directory.getPath() + ")"));
        }
        if ((list = directory.list()) == null) {
            return;
        }
        int len = list.length;
        for (int i = 0; i < len; ++i) {
            File target;
            if (DATA_DIR_NAME.equals(list[i]) || !(target = new File(directory, list[i])).isDirectory()) continue;
            File delete = new File(target, ".delete");
            if (delete.exists()) {
                if (this.rm(target) || delete.exists()) continue;
                try {
                    FileOutputStream out = new FileOutputStream(delete);
                    out.close();
                }
                catch (IOException e) {
                    if (!Debug.DEBUG_GENERAL) continue;
                    Debug.println((String)("Unable to write " + delete.getPath() + ": " + e.getMessage()));
                }
                continue;
            }
            this.compact(target);
        }
    }

    public void compactStorage() {
        this.compact(this.getBundleStoreRootDir());
    }

    public BundleData[] getInstalledBundles() {
        String[] list = this.getBundleStoreRootDir().list();
        if (list == null) {
            return null;
        }
        ArrayList<DefaultBundleData> bundleDatas = new ArrayList<DefaultBundleData>(list.length);
        for (int i = 0; i < list.length; ++i) {
            try {
                long id = -1L;
                try {
                    id = Long.parseLong(list[i]);
                }
                catch (NumberFormatException nfe) {
                    continue;
                }
                DefaultBundleData data = (DefaultBundleData)this.getElementFactory().createBundleData(this, id);
                this.loadMetaDataFor(data);
                data.initializeExistingBundle();
                if (Debug.DEBUG_GENERAL) {
                    Debug.println((String)("BundleData created: " + data));
                }
                bundleDatas.add(data);
                continue;
            }
            catch (BundleException e) {
                if (!Debug.DEBUG_GENERAL) continue;
                Debug.println((String)("Unable to open Bundle[" + list[i] + "]: " + e.getMessage()));
                Debug.printStackTrace((Throwable)e);
                continue;
            }
            catch (IOException e) {
                if (!Debug.DEBUG_GENERAL) continue;
                Debug.println((String)("Unable to open Bundle[" + list[i] + "]: " + e.getMessage()));
                Debug.printStackTrace((Throwable)e);
            }
        }
        return bundleDatas.toArray(new BundleData[bundleDatas.size()]);
    }

    public BundleOperation installBundle(final String location, final URLConnection source) {
        return new BundleOperation(){
            private DefaultBundleData data;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public BundleData begin() throws BundleException {
                try {
                    InputStream in = source.getInputStream();
                    URL sourceURL = source.getURL();
                    String protocol = sourceURL == null ? null : sourceURL.getProtocol();
                    try {
                        long id;
                        try {
                            id = DefaultAdaptor.this.getNextBundleId();
                        }
                        catch (IOException e) {
                            throw new BundleException(AdaptorMsg.formatter.getString("ADAPTOR_STORAGE_EXCEPTION"), (Throwable)e);
                        }
                        this.data = (DefaultBundleData)DefaultAdaptor.this.getElementFactory().createBundleData(DefaultAdaptor.this, id);
                        this.data.setLocation(location);
                        this.data.setStartLevel(DefaultAdaptor.this.getInitialBundleStartLevel());
                        if (in instanceof ReferenceInputStream) {
                            URL reference = ((ReferenceInputStream)in).getReference();
                            if (!"file".equals(reference.getProtocol())) {
                                throw new BundleException(AdaptorMsg.formatter.getString("ADAPTOR_URL_CREATE_EXCEPTION", (Object)reference));
                            }
                            this.data.setReference(true);
                            this.data.setFileName(reference.getPath());
                            this.data.initializeNewBundle();
                        } else {
                            File genDir = this.data.createGenerationDir();
                            if (!genDir.exists()) {
                                throw new IOException(AdaptorMsg.formatter.getString("ADAPTOR_DIRECTORY_CREATE_EXCEPTION", (Object)genDir.getPath()));
                            }
                            String fileName = DefaultAdaptor.this.mapLocationToName(location);
                            File outFile = new File(genDir, fileName);
                            if ("file".equals(protocol)) {
                                File inFile = new File(source.getURL().getPath());
                                if (inFile.isDirectory()) {
                                    AbstractFrameworkAdaptor.copyDir(inFile, outFile);
                                } else {
                                    AbstractFrameworkAdaptor.readFile(in, outFile);
                                }
                            } else {
                                AbstractFrameworkAdaptor.readFile(in, outFile);
                            }
                            this.data.setReference(false);
                            this.data.setFileName(fileName);
                            this.data.initializeNewBundle();
                        }
                    }
                    finally {
                        try {
                            in.close();
                        }
                        catch (IOException e) {}
                    }
                }
                catch (IOException ioe) {
                    throw new BundleException(AdaptorMsg.formatter.getString("BUNDLE_READ_EXCEPTION"), (Throwable)ioe);
                }
                return this.data;
            }

            public void undo() {
                block7: {
                    File delete;
                    File bundleDir;
                    block6: {
                        if (this.data != null) {
                            try {
                                this.data.close();
                            }
                            catch (IOException e) {
                                if (!Debug.DEBUG_GENERAL) break block6;
                                Debug.println((String)("Unable to close " + this.data + ": " + e.getMessage()));
                            }
                        }
                    }
                    if (this.data != null && !DefaultAdaptor.this.rm(bundleDir = this.data.getBundleStoreDir()) && !(delete = new File(bundleDir, ".delete")).exists()) {
                        try {
                            FileOutputStream out = new FileOutputStream(delete);
                            out.close();
                        }
                        catch (IOException e) {
                            if (!Debug.DEBUG_GENERAL) break block7;
                            Debug.println((String)("Unable to write " + delete.getPath() + ": " + e.getMessage()));
                        }
                    }
                }
            }

            public void commit(boolean postpone) throws BundleException {
                try {
                    this.data.save();
                }
                catch (IOException e) {
                    throw new BundleException(AdaptorMsg.formatter.getString("ADAPTOR_STORAGE_EXCEPTION"), (Throwable)e);
                }
                BundleDescription bundleDescription = DefaultAdaptor.this.stateManager.getFactory().createBundleDescription(this.data.getManifest(), this.data.getLocation(), this.data.getBundleID());
                DefaultAdaptor.this.stateManager.getSystemState().addBundle(bundleDescription);
            }
        };
    }

    public BundleOperation updateBundle(final BundleData bundledata, final URLConnection source) {
        return new BundleOperation(){
            private DefaultBundleData data;
            private DefaultBundleData newData;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public BundleData begin() throws BundleException {
                this.data = (DefaultBundleData)bundledata;
                try {
                    block22: {
                        InputStream in = source.getInputStream();
                        URL sourceURL = source.getURL();
                        String protocol = sourceURL == null ? null : sourceURL.getProtocol();
                        try {
                            if (in instanceof ReferenceInputStream) {
                                ReferenceInputStream refIn = (ReferenceInputStream)in;
                                URL reference = refIn.getReference();
                                if (!"file".equals(reference.getProtocol())) {
                                    throw new BundleException(AdaptorMsg.formatter.getString("ADAPTOR_URL_CREATE_EXCEPTION", (Object)reference));
                                }
                                String path = reference.getPath();
                                if (path.equals(this.data.getFileName())) {
                                    throw new BundleException(AdaptorMsg.formatter.getString("ADAPTOR_SAME_REF_UPDATE", (Object)reference));
                                }
                                try {
                                    this.newData = this.data.nextGeneration(reference.getPath());
                                }
                                catch (IOException e) {
                                    throw new BundleException(AdaptorMsg.formatter.getString("ADAPTOR_STORAGE_EXCEPTION"), (Throwable)e);
                                }
                                File bundleGenerationDir = this.newData.createGenerationDir();
                                if (!bundleGenerationDir.exists()) {
                                    throw new BundleException(AdaptorMsg.formatter.getString("ADAPTOR_DIRECTORY_CREATE_EXCEPTION", (Object)bundleGenerationDir.getPath()));
                                }
                                this.newData.createBaseBundleFile();
                                break block22;
                            }
                            try {
                                this.newData = this.data.nextGeneration(null);
                            }
                            catch (IOException e) {
                                throw new BundleException(AdaptorMsg.formatter.getString("ADAPTOR_STORAGE_EXCEPTION"), (Throwable)e);
                            }
                            File bundleGenerationDir = this.newData.createGenerationDir();
                            if (!bundleGenerationDir.exists()) {
                                throw new BundleException(AdaptorMsg.formatter.getString("ADAPTOR_DIRECTORY_CREATE_EXCEPTION", (Object)bundleGenerationDir.getPath()));
                            }
                            File outFile = this.newData.getBaseFile();
                            if ("file".equals(protocol)) {
                                File inFile = new File(source.getURL().getPath());
                                if (inFile.isDirectory()) {
                                    AbstractFrameworkAdaptor.copyDir(inFile, outFile);
                                } else {
                                    AbstractFrameworkAdaptor.readFile(in, outFile);
                                }
                            } else {
                                AbstractFrameworkAdaptor.readFile(in, outFile);
                            }
                            this.newData.createBaseBundleFile();
                        }
                        finally {
                            try {
                                in.close();
                            }
                            catch (IOException ee) {}
                        }
                    }
                    this.newData.loadFromManifest();
                }
                catch (IOException e) {
                    throw new BundleException(AdaptorMsg.formatter.getString("BUNDLE_READ_EXCEPTION"), (Throwable)e);
                }
                return this.newData;
            }

            public void commit(boolean postpone) throws BundleException {
                File delete;
                try {
                    this.newData.save();
                }
                catch (IOException e) {
                    throw new BundleException(AdaptorMsg.formatter.getString("ADAPTOR_STORAGE_EXCEPTION"), (Throwable)e);
                }
                long bundleId = this.newData.getBundleID();
                StateImpl systemState = DefaultAdaptor.this.stateManager.getSystemState();
                systemState.removeBundle(bundleId);
                BundleDescription newDescription = DefaultAdaptor.this.stateManager.getFactory().createBundleDescription(this.newData.getManifest(), this.newData.getLocation(), bundleId);
                systemState.addBundle(newDescription);
                File originalGenerationDir = this.data.createGenerationDir();
                if (!(!postpone && DefaultAdaptor.this.rm(originalGenerationDir) || (delete = new File(originalGenerationDir, ".delete")).exists())) {
                    try {
                        FileOutputStream out = new FileOutputStream(delete);
                        out.close();
                    }
                    catch (IOException e) {
                        if (Debug.DEBUG_GENERAL) {
                            Debug.println((String)("Unable to write " + delete.getPath() + ": " + e.getMessage()));
                        }
                        DefaultAdaptor.this.eventPublisher.publishFrameworkEvent(2, this.data.getBundle(), (Throwable)e);
                    }
                }
            }

            public void undo() throws BundleException {
                block3: {
                    File delete;
                    File nextGenerationDir;
                    if (this.newData != null && !DefaultAdaptor.this.rm(nextGenerationDir = this.newData.createGenerationDir()) && !(delete = new File(nextGenerationDir, ".delete")).exists()) {
                        try {
                            FileOutputStream out = new FileOutputStream(delete);
                            out.close();
                        }
                        catch (IOException e) {
                            if (!Debug.DEBUG_GENERAL) break block3;
                            Debug.println((String)("Unable to write " + delete.getPath() + ": " + e.getMessage()));
                        }
                    }
                }
            }
        };
    }

    public BundleOperation uninstallBundle(final BundleData bundledata) {
        return new BundleOperation(){
            private DefaultBundleData data;

            public BundleData begin() throws BundleException {
                this.data = (DefaultBundleData)bundledata;
                return bundledata;
            }

            public void commit(boolean postpone) throws BundleException {
                block3: {
                    File delete;
                    File bundleDir = this.data.getBundleStoreDir();
                    if (!(!postpone && DefaultAdaptor.this.rm(bundleDir) || (delete = new File(bundleDir, ".delete")).exists())) {
                        try {
                            FileOutputStream out = new FileOutputStream(delete);
                            out.close();
                        }
                        catch (IOException e) {
                            if (!Debug.DEBUG_GENERAL) break block3;
                            Debug.println((String)("Unable to write " + delete.getPath() + ": " + e.getMessage()));
                        }
                    }
                }
                DefaultAdaptor.this.stateManager.getSystemState().removeBundle(this.data.getBundleID());
            }

            public void undo() throws BundleException {
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PermissionStorage getPermissionStorage() throws IOException {
        if (this.permissionStore == null) {
            DefaultAdaptor defaultAdaptor = this;
            synchronized (defaultAdaptor) {
                if (this.permissionStore == null) {
                    this.permissionStore = new DefaultPermissionStorage(this);
                }
            }
        }
        return this.permissionStore;
    }

    public void frameworkStart(BundleContext context) throws BundleException {
        StateImpl state;
        BundleDescription systemBundle;
        super.frameworkStart(context);
        if (this.frameworkLog == null) {
            this.frameworkLog = this.createFrameworkLog();
        }
        if ((systemBundle = (state = this.stateManager.getSystemState()).getBundle(0L)) == null || !systemBundle.isResolved()) {
            throw new IllegalStateException();
        }
    }

    public void frameworkStop(BundleContext context) throws BundleException {
        this.shutdownStateManager();
        super.frameworkStop(context);
        this.frameworkLog.close();
        this.frameworkLog = null;
    }

    protected ServiceRegistration register(String name, Object service, Bundle bundle) {
        Hashtable properties = new Hashtable(7);
        Dictionary headers = bundle.getHeaders();
        properties.put("service.vendor", headers.get("Bundle-Vendor"));
        properties.put("service.ranking", new Integer(Integer.MAX_VALUE));
        properties.put("service.pid", bundle.getBundleId() + "." + service.getClass().getName());
        return this.context.registerService(name, service, properties);
    }

    protected boolean rm(File file) {
        if (file.exists()) {
            if (file.isDirectory()) {
                String[] list = file.list();
                int len = list.length;
                for (int i = 0; i < len; ++i) {
                    this.rm(new File(file, list[i]));
                }
            }
            if (Debug.DEBUG_GENERAL) {
                if (file.isDirectory()) {
                    Debug.println((String)("rmdir " + file.getPath()));
                } else {
                    Debug.println((String)("rm " + file.getPath()));
                }
            }
            boolean success = file.delete();
            if (Debug.DEBUG_GENERAL && !success) {
                Debug.println((String)"  rm failed!!");
            }
            return success;
        }
        return true;
    }

    public void setInitialBundleStartLevel(int value) {
        super.setInitialBundleStartLevel(value);
        try {
            this.persistInitialBundleStartLevel(value);
        }
        catch (IOException e) {
            this.eventPublisher.publishFrameworkEvent(2, this.context.getBundle(), (Throwable)e);
        }
    }

    protected void persistInitialBundleStartLevel(int value) throws IOException {
        this.fwMetadata.setInt(METADATA_ADAPTOR_IBSL, value);
        this.fwMetadata.save();
    }

    public String mapLocationToName(String location) {
        int end = location.indexOf(63, 0);
        if (end == -1 && (end = location.indexOf(35, 0)) == -1) {
            end = location.length();
        }
        int begin = location.replace('\\', '/').lastIndexOf(47, end);
        int colon = location.lastIndexOf(58, end);
        if (colon > begin) {
            begin = colon;
        }
        return location.substring(begin + 1, end);
    }

    protected void persistNextBundleID(long id) throws IOException {
        this.fwMetadata.setLong(METADATA_ADAPTOR_NEXTID, this.nextId);
        this.fwMetadata.save();
    }

    protected synchronized long getNextBundleId() throws IOException {
        while (this.nextId < Long.MAX_VALUE) {
            long id = this.nextId++;
            File bundleDir = new File(this.getBundleStoreRootDir(), String.valueOf(id));
            if (bundleDir.exists()) continue;
            this.persistNextBundleID(id);
            return id;
        }
        throw new IOException(AdaptorMsg.formatter.getString("ADAPTOR_STORAGE_EXCEPTION"));
    }

    public AdaptorElementFactory getElementFactory() {
        if (this.elementFactory == null) {
            this.elementFactory = new DefaultElementFactory();
        }
        return this.elementFactory;
    }

    public FrameworkLog getFrameworkLog() {
        return this.frameworkLog;
    }

    public State getState() {
        return this.stateManager.getSystemState();
    }

    public PlatformAdmin getPlatformAdmin() {
        return this.stateManager;
    }

    protected void loadMetaDataFor(DefaultBundleData data) throws IOException {
        MetaData bundleMetaData = new MetaData(new File(data.getBundleStoreDir(), ".bundle"), "Bundle metadata");
        bundleMetaData.load();
        data.setLocation(bundleMetaData.get(METADATA_BUNDLE_LOC, null));
        data.setFileName(bundleMetaData.get(METADATA_BUNDLE_NAME, null));
        data.setGeneration(bundleMetaData.getInt(METADATA_BUNDLE_GEN, -1));
        data.setNativePaths(bundleMetaData.get(METADATA_BUNDLE_NCP, null));
        data.setStartLevel(bundleMetaData.getInt(METADATA_BUNDLE_ABSL, 1));
        data.setStatus(bundleMetaData.getInt(METADATA_BUNDLE_STATUS, 0));
        data.setReference(bundleMetaData.getBoolean(METADATA_BUNDLE_REF, false));
        if (data.getGeneration() == -1 || data.getFileName() == null || data.getLocation() == null) {
            throw new IOException(AdaptorMsg.formatter.getString("ADAPTOR_STORAGE_EXCEPTION"));
        }
    }

    public void saveMetaDataFor(DefaultBundleData data) throws IOException {
        MetaData bundleMetadata = new MetaData(new File(data.createBundleStoreDir(), ".bundle"), "Bundle metadata");
        bundleMetadata.load();
        bundleMetadata.set(METADATA_BUNDLE_LOC, data.getLocation());
        bundleMetadata.set(METADATA_BUNDLE_NAME, data.getFileName());
        bundleMetadata.setInt(METADATA_BUNDLE_GEN, data.getGeneration());
        String nativePaths = data.getNativePathsString();
        if (nativePaths != null) {
            bundleMetadata.set(METADATA_BUNDLE_NCP, nativePaths);
        }
        bundleMetadata.setInt(METADATA_BUNDLE_ABSL, data.getStartLevel());
        bundleMetadata.setInt(METADATA_BUNDLE_STATUS, data.getStatus());
        bundleMetadata.setBoolean(METADATA_BUNDLE_REF, data.isReference());
        bundleMetadata.save();
    }
}

