/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui.synchronize;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.ProgressMonitorWrapper;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.ILock;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.core.subscribers.ISubscriberChangeListener;
import org.eclipse.team.core.subscribers.Subscriber;
import org.eclipse.team.core.synchronize.SyncInfo;
import org.eclipse.team.core.synchronize.SyncInfoTree;
import org.eclipse.team.internal.core.Assert;
import org.eclipse.team.internal.core.subscribers.SubscriberSyncInfoCollector;
import org.eclipse.team.internal.ui.Policy;
import org.eclipse.team.internal.ui.synchronize.IRefreshEvent;
import org.eclipse.team.internal.ui.synchronize.IRefreshSubscriberListener;
import org.eclipse.team.internal.ui.synchronize.RefreshChangeListener;
import org.eclipse.team.internal.ui.synchronize.RefreshEvent;
import org.eclipse.team.internal.ui.synchronize.WorkbenchAction;
import org.eclipse.team.ui.synchronize.ISynchronizeManager;
import org.eclipse.team.ui.synchronize.SubscriberParticipant;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.progress.IProgressConstants;
import org.eclipse.ui.progress.UIJob;

public final class RefreshSubscriberJob
extends Job {
    private static final Object FAMILY_ID = new Object();
    private boolean reschedule = false;
    private boolean restartOnCancel = true;
    private static long scheduleDelay;
    private IResource[] resources;
    private SubscriberParticipant participant;
    private String taskName;
    private static List listeners;
    private static final int STARTED = 1;
    private static final int DONE = 2;
    private static final ILock lock;
    private static final IStatus POSTPONED;

    public RefreshSubscriberJob(SubscriberParticipant participant, String jobName, String taskName, IResource[] resources, IRefreshSubscriberListener listener) {
        super(taskName);
        Assert.isNotNull((Object)resources);
        Assert.isNotNull((Object)participant);
        Assert.isNotNull((Object)resources);
        this.resources = resources;
        this.participant = participant;
        this.taskName = jobName;
        this.setPriority(50);
        this.setRefreshInterval(3600L);
        this.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                if (RefreshSubscriberJob.this.shouldReschedule()) {
                    IStatus result = event.getResult();
                    if (result.getSeverity() == 8 && !RefreshSubscriberJob.this.restartOnCancel) {
                        return;
                    }
                    long delay = scheduleDelay;
                    if (result == POSTPONED) {
                        delay = 5000L;
                    }
                    RefreshSubscriberJob.this.schedule(delay);
                    RefreshSubscriberJob.this.restartOnCancel = true;
                }
            }
        });
        if (listener != null) {
            this.initialize(listener);
        }
    }

    public boolean shouldRun() {
        return this.getSubscriber() != null;
    }

    public boolean belongsTo(Object family) {
        if (family instanceof RefreshSubscriberJob) {
            return ((RefreshSubscriberJob)((Object)family)).getSubscriber() == this.getSubscriber();
        }
        if (family instanceof SubscriberParticipant) {
            return family == this.participant;
        }
        return family == RefreshSubscriberJob.getFamily() || family == ISynchronizeManager.FAMILY_SYNCHRONIZE_OPERATION;
    }

    public static Object getFamily() {
        return FAMILY_ID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IStatus run(IProgressMonitor monitor) {
        if (this.shouldReschedule()) {
            if (this.isJobInFamilyRunning(ResourcesPlugin.FAMILY_AUTO_BUILD)) return POSTPONED;
            if (this.isJobInFamilyRunning(ResourcesPlugin.FAMILY_MANUAL_BUILD)) {
                return POSTPONED;
            }
        }
        boolean acquired = false;
        try {
            IStatus status;
            RefreshChangeListener changeListener;
            RefreshEvent event;
            block20: {
                NonblockingProgressMonitor wrappedMonitor;
                IResource[] roots;
                Subscriber subscriber;
                block19: {
                    while (!acquired) {
                        try {
                            acquired = lock.acquire(1000L);
                        }
                        catch (InterruptedException e1) {
                            acquired = false;
                        }
                        Policy.checkCanceled(monitor);
                    }
                    subscriber = this.getSubscriber();
                    roots = this.getResources();
                    if (subscriber == null || roots == null) {
                        IStatus iStatus = Status.OK_STATUS;
                        return iStatus;
                    }
                    SubscriberSyncInfoCollector collector = this.getCollector();
                    event = new RefreshEvent(this.reschedule ? 1 : 2, roots, collector.getSubscriber());
                    changeListener = new RefreshChangeListener(collector);
                    status = null;
                    wrappedMonitor = null;
                    event.setStartTime(System.currentTimeMillis());
                    if (!monitor.isCanceled()) break block19;
                    IStatus iStatus = Status.CANCEL_STATUS;
                    Object var12_16 = null;
                    event.setStopTime(System.currentTimeMillis());
                    subscriber.removeListener((ISubscriberChangeListener)changeListener);
                    monitor.done();
                    if (!acquired) return iStatus;
                    lock.release();
                    return iStatus;
                }
                try {
                    try {
                        subscriber.addListener((ISubscriberChangeListener)changeListener);
                        this.notifyListeners(1, event);
                        monitor.setTaskName(this.getName());
                        wrappedMonitor = new NonblockingProgressMonitor(monitor, this);
                        subscriber.refresh(roots, 2, (IProgressMonitor)wrappedMonitor);
                        this.setProperty(IProgressConstants.KEEPONE_PROPERTY, !this.isJobModal());
                    }
                    catch (OperationCanceledException e2) {
                        status = monitor.isCanceled() ? Status.CANCEL_STATUS : (wrappedMonitor != null && wrappedMonitor.wasBlocking() ? POSTPONED : Status.CANCEL_STATUS);
                        Object var12_18 = null;
                        event.setStopTime(System.currentTimeMillis());
                        subscriber.removeListener((ISubscriberChangeListener)changeListener);
                        monitor.done();
                        break block20;
                    }
                    catch (TeamException e) {
                        status = e.getStatus();
                        Object var12_19 = null;
                        event.setStopTime(System.currentTimeMillis());
                        subscriber.removeListener((ISubscriberChangeListener)changeListener);
                        monitor.done();
                    }
                    Object var12_17 = null;
                    event.setStopTime(System.currentTimeMillis());
                    subscriber.removeListener((ISubscriberChangeListener)changeListener);
                    monitor.done();
                }
                catch (Throwable throwable) {
                    Object var12_20 = null;
                    event.setStopTime(System.currentTimeMillis());
                    subscriber.removeListener((ISubscriberChangeListener)changeListener);
                    monitor.done();
                    throw throwable;
                }
            }
            event.setChanges(changeListener.getChanges());
            if (status == null) {
                status = this.calculateStatus(event);
            }
            event.setStatus(status);
            this.notifyListeners(2, event);
            IStatus iStatus = event.getStatus();
            return iStatus;
        }
        finally {
            if (acquired) {
                lock.release();
            }
        }
    }

    private boolean isJobInFamilyRunning(Object family) {
        Job[] jobs = Platform.getJobManager().find(family);
        if (jobs != null && jobs.length > 0) {
            for (int i = 0; i < jobs.length; ++i) {
                Job job = jobs[i];
                if (job.getState() == 0) continue;
                return true;
            }
        }
        return false;
    }

    private IStatus calculateStatus(IRefreshEvent event) {
        StringBuffer text = new StringBuffer();
        int code = 0;
        SyncInfo[] changes = event.getChanges();
        SubscriberSyncInfoCollector collector = this.getCollector();
        if (collector != null) {
            int numChanges = this.refreshedResourcesContainChanges(event);
            if (numChanges > 0) {
                code = 1;
                if (changes.length > 0) {
                    String numNewChanges = Integer.toString(event.getChanges().length);
                    if (event.getChanges().length == 1) {
                        text.append(Policy.bind("RefreshCompleteDialog.newChangesSingular", new Object[]{this.getName(), numNewChanges}));
                    } else {
                        text.append(Policy.bind("RefreshCompleteDialog.newChangesPlural", new Object[]{this.getName(), numNewChanges}));
                    }
                } else if (numChanges == 1) {
                    text.append(Policy.bind("RefreshCompleteDialog.changesSingular", new Object[]{this.getName(), new Integer(numChanges)}));
                } else {
                    text.append(Policy.bind("RefreshCompleteDialog.changesPlural", new Object[]{this.getName(), new Integer(numChanges)}));
                }
            } else {
                code = 2;
                text.append(Policy.bind("RefreshCompleteDialog.6", this.getName()));
            }
            return new Status(0, "org.eclipse.team.ui", code, text.toString(), null);
        }
        return Status.OK_STATUS;
    }

    private int refreshedResourcesContainChanges(IRefreshEvent event) {
        int numChanges = 0;
        SubscriberSyncInfoCollector collector = this.getCollector();
        if (collector != null) {
            SyncInfoTree set = collector.getSyncInfoSet();
            IResource[] resources = event.getResources();
            for (int i = 0; i < resources.length; ++i) {
                IResource resource = resources[i];
                SyncInfo[] infos = set.getSyncInfos(resource, 2);
                if (infos == null || infos.length <= 0) continue;
                numChanges += infos.length;
            }
        }
        return numChanges;
    }

    private void initialize(final IRefreshSubscriberListener listener) {
        final ActionFactory.IWorkbenchAction[] gotoAction = new ActionFactory.IWorkbenchAction[]{null};
        final WorkbenchAction actionWrapper = new WorkbenchAction(){

            public void run() {
                if (gotoAction[0] != null) {
                    gotoAction[0].run();
                }
            }

            public boolean isEnabled() {
                if (gotoAction[0] != null) {
                    return gotoAction[0].isEnabled();
                }
                return true;
            }

            public String getToolTipText() {
                if (gotoAction[0] != null) {
                    return gotoAction[0].getToolTipText();
                }
                return super.getToolTipText();
            }

            public void dispose() {
                super.dispose();
                if (gotoAction[0] != null) {
                    gotoAction[0].dispose();
                }
            }
        };
        IProgressMonitor group = Platform.getJobManager().createProgressGroup();
        group.beginTask(this.taskName, 100);
        this.setProgressGroup(group, 80);
        this.getCollector().setProgressGroup(group, 20);
        this.setProperty(IProgressConstants.ICON_PROPERTY, this.participant.getImageDescriptor());
        this.setProperty(IProgressConstants.ACTION_PROPERTY, (Object)actionWrapper);
        this.setProperty(IProgressConstants.KEEPONE_PROPERTY, !this.isJobModal());
        IRefreshSubscriberListener autoListener = new IRefreshSubscriberListener(){

            public void refreshStarted(IRefreshEvent event) {
                if (listener != null) {
                    listener.refreshStarted(event);
                }
            }

            public ActionFactory.IWorkbenchAction refreshDone(IRefreshEvent event) {
                if (listener != null) {
                    boolean isModal = RefreshSubscriberJob.this.isJobModal();
                    ActionFactory.IWorkbenchAction runnable = listener.refreshDone(event);
                    if (runnable != null) {
                        if (isModal) {
                            if (runnable != null) {
                                IAction[] r = new IAction[]{runnable};
                                UIJob update = new UIJob(this, "", r){
                                    private final /* synthetic */ IAction[] val$r;
                                    private final /* synthetic */ 3 this$1;
                                    {
                                        this.this$1 = this$1;
                                        this.val$r = val$r;
                                    }

                                    public IStatus runInUIThread(IProgressMonitor monitor) {
                                        this.val$r[0].run();
                                        return Status.OK_STATUS;
                                    }
                                };
                                update.setSystem(true);
                                update.schedule();
                            }
                        } else {
                            gotoAction[0] = runnable;
                            actionWrapper.setEnabled(runnable.isEnabled());
                            actionWrapper.setToolTipText(runnable.getToolTipText());
                            runnable.addPropertyChangeListener(new IPropertyChangeListener(this){
                                private final /* synthetic */ 3 this$1;
                                {
                                    this.this$1 = this$1;
                                }

                                public void propertyChange(PropertyChangeEvent event) {
                                    if (event.getProperty().equals("enabled")) {
                                        Boolean bool = (Boolean)event.getNewValue();
                                        3.access$400(this.this$1).setEnabled(bool.booleanValue());
                                    }
                                }
                            });
                        }
                    }
                    RefreshSubscriberJob.removeRefreshListener(this);
                }
                return null;
            }

            static /* synthetic */ ActionFactory.IWorkbenchAction access$400(3 x0) {
                return x0.actionWrapper;
            }
        };
        if (listener != null) {
            RefreshSubscriberJob.addRefreshListener(autoListener);
        }
    }

    protected IResource[] getResources() {
        return this.resources;
    }

    protected Subscriber getSubscriber() {
        return this.participant.getSubscriber();
    }

    protected SubscriberSyncInfoCollector getCollector() {
        return this.participant.getSubscriberSyncInfoCollector();
    }

    public long getScheduleDelay() {
        return scheduleDelay;
    }

    protected void start() {
        if (this.getState() == 0 && this.shouldReschedule()) {
            this.schedule(this.getScheduleDelay());
        }
    }

    public void setRefreshInterval(long seconds) {
        boolean restart = false;
        if (this.getState() == 1) {
            restart = true;
            this.cancel();
        }
        scheduleDelay = seconds * 1000L;
        if (restart) {
            this.start();
        }
    }

    public long getRefreshInterval() {
        return scheduleDelay / 1000L;
    }

    public void setRestartOnCancel(boolean restartOnCancel) {
        this.restartOnCancel = restartOnCancel;
    }

    public void setReschedule(boolean reschedule) {
        this.reschedule = reschedule;
    }

    public boolean shouldReschedule() {
        return this.reschedule;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addRefreshListener(IRefreshSubscriberListener listener) {
        List list = listeners;
        synchronized (list) {
            if (!listeners.contains(listener)) {
                listeners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeRefreshListener(IRefreshSubscriberListener listener) {
        List list = listeners;
        synchronized (list) {
            listeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyListeners(final int state, final IRefreshEvent event) {
        IRefreshSubscriberListener[] listenerArray;
        List list = listeners;
        synchronized (list) {
            listenerArray = listeners.toArray(new IRefreshSubscriberListener[listeners.size()]);
        }
        for (int i = 0; i < listenerArray.length; ++i) {
            IRefreshSubscriberListener listener = listenerArray[i];
            Notification notification = new Notification(){

                protected void notify(IRefreshSubscriberListener listener) {
                    switch (state) {
                        case 1: {
                            listener.refreshStarted(event);
                            break;
                        }
                        case 2: {
                            listener.refreshDone(event);
                            break;
                        }
                    }
                }
            };
            notification.run(listener);
        }
    }

    private boolean isJobModal() {
        Boolean isModal = (Boolean)this.getProperty(IProgressConstants.PROPERTY_IN_DIALOG);
        if (isModal == null) {
            return false;
        }
        return isModal;
    }

    static {
        listeners = new ArrayList(1);
        lock = Platform.getJobManager().newLock();
        POSTPONED = new Status(8, "org.eclipse.team.ui", 0, "Scheduled refresh postponed due to conflicting operation", null);
    }

    private class NonblockingProgressMonitor
    extends ProgressMonitorWrapper {
        private final RefreshSubscriberJob job;
        private long blockTime;
        private static final int THRESHOLD = 250;
        private boolean wasBlocking = false;

        protected NonblockingProgressMonitor(IProgressMonitor monitor, RefreshSubscriberJob job) {
            super(monitor);
            this.job = job;
        }

        public boolean isCanceled() {
            if (super.isCanceled()) {
                return true;
            }
            if (this.job.shouldReschedule() && this.job.isBlocking()) {
                if (this.blockTime == 0L) {
                    this.blockTime = System.currentTimeMillis();
                } else if (System.currentTimeMillis() - this.blockTime > 250L) {
                    this.wasBlocking = true;
                    return true;
                }
            } else {
                this.blockTime = 0L;
            }
            this.wasBlocking = false;
            return false;
        }

        public boolean wasBlocking() {
            return this.wasBlocking;
        }
    }

    private abstract class Notification
    implements ISafeRunnable {
        private IRefreshSubscriberListener listener;

        private Notification() {
        }

        public void handleException(Throwable exception) {
        }

        public void run(IRefreshSubscriberListener listener) {
            this.listener = listener;
            Platform.run((ISafeRunnable)this);
        }

        public void run() throws Exception {
            this.notify(this.listener);
        }

        protected abstract void notify(IRefreshSubscriberListener var1);
    }
}

