/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.filebuffers;

import java.io.File;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.internal.filebuffers.AbstractFileBuffer;
import org.eclipse.core.internal.filebuffers.FileBuffersMessages;
import org.eclipse.core.internal.filebuffers.FileBuffersPlugin;
import org.eclipse.core.internal.filebuffers.TextFileBufferManager;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public abstract class JavaFileBuffer
extends AbstractFileBuffer {
    protected IPath fLocation;
    protected File fFile;
    protected int fReferenceCount;
    protected boolean fCanBeSaved = false;
    protected IStatus fStatus;
    protected long fSynchronizationStamp = -1L;
    protected int fSynchronizationContextCount;
    protected TextFileBufferManager fManager;

    public JavaFileBuffer(TextFileBufferManager manager) {
        this.fManager = manager;
    }

    protected abstract void addFileBufferContentListeners();

    protected abstract void removeFileBufferContentListeners();

    protected abstract void initializeFileBufferContent(IProgressMonitor var1) throws CoreException;

    protected abstract void commitFileBufferContent(IProgressMonitor var1, boolean var2) throws CoreException;

    private File getFileAtLocation(IPath location) {
        File file = FileBuffers.getSystemFileAtLocation(location);
        return file.exists() ? file : null;
    }

    public void create(IPath location, IProgressMonitor monitor) throws CoreException {
        File file = this.getFileAtLocation(location);
        if (file == null) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.core.filebuffers", 0, FileBuffersMessages.getString("FileBuffer.error.fileDoesNotExist"), null));
        }
        this.fLocation = location;
        this.fFile = file;
        this.initializeFileBufferContent(monitor);
        this.fSynchronizationStamp = this.fFile.lastModified();
        this.addFileBufferContentListeners();
    }

    public void connect() {
        ++this.fReferenceCount;
    }

    public void disconnect() throws CoreException {
        --this.fReferenceCount;
    }

    public boolean isDisposed() {
        return this.fReferenceCount <= 0;
    }

    public IPath getLocation() {
        return this.fLocation;
    }

    public void commit(IProgressMonitor monitor, boolean overwrite) throws CoreException {
        if (!this.isDisposed() && this.fCanBeSaved) {
            this.fManager.fireStateChanging(this);
            try {
                this.commitFileBufferContent(monitor, overwrite);
            }
            catch (CoreException x) {
                this.fManager.fireStateChangeFailed(this);
                throw x;
            }
            catch (RuntimeException x) {
                this.fManager.fireStateChangeFailed(this);
                throw x;
            }
            this.fCanBeSaved = false;
            this.addFileBufferContentListeners();
            this.fManager.fireDirtyStateChanged(this, this.fCanBeSaved);
        }
    }

    public boolean isDirty() {
        return this.fCanBeSaved;
    }

    public boolean isShared() {
        return this.fReferenceCount > 1;
    }

    public void validateState(IProgressMonitor monitor, Object computationContext) throws CoreException {
    }

    public boolean isStateValidated() {
        return true;
    }

    public void resetStateValidation() {
    }

    protected void handleFileMoved(IPath newLocation) {
        this.fManager.fireUnderlyingFileMoved(this, newLocation);
    }

    protected void handleCoreException(CoreException exception) {
        ILog log = FileBuffersPlugin.getDefault().getLog();
        log.log(exception.getStatus());
    }

    public boolean isSynchronized() {
        return this.fSynchronizationStamp == this.fFile.lastModified();
    }

    public long getModificationStamp() {
        return this.fFile.lastModified();
    }

    public void requestSynchronizationContext() {
        ++this.fSynchronizationContextCount;
    }

    public void releaseSynchronizationContext() {
        --this.fSynchronizationContextCount;
    }
}

