/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.runtime.adaptor;

import java.util.Hashtable;
import org.eclipse.core.runtime.adaptor.EclipseAdaptor;
import org.eclipse.core.runtime.adaptor.EclipseAdaptorMsg;
import org.eclipse.core.runtime.adaptor.EclipseBundleData;
import org.eclipse.osgi.framework.internal.core.AbstractBundle;
import org.eclipse.osgi.framework.internal.core.BundleHost;
import org.eclipse.osgi.framework.log.FrameworkLogEntry;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.StateHelper;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class BundleStopper {
    private Hashtable stoppedBundles;
    private BundleDescription[] allToStop = null;

    private void logCycles(Object[][] cycles) {
        if (cycles.length > 0) {
            StringBuffer cycleText = new StringBuffer("[");
            for (int i = 0; i < cycles.length; ++i) {
                cycleText.append('[');
                for (int j = 0; j < cycles[i].length; ++j) {
                    cycleText.append(((BundleDescription)cycles[i][j]).getSymbolicName());
                    cycleText.append(',');
                }
                cycleText.insert(cycleText.length() - 1, ']');
            }
            cycleText.setCharAt(cycleText.length() - 1, ']');
            String message = EclipseAdaptorMsg.formatter.getString("ECLIPSE_BUNDLESTOPPER_CYCLES_FOUND", (Object)cycleText);
            FrameworkLogEntry entry = new FrameworkLogEntry("org.eclipse.osgi", message, 0, null, null);
            EclipseAdaptor.getDefault().getFrameworkLog().log(entry);
        }
    }

    public void stopBundles() {
        this.allToStop = EclipseAdaptor.getDefault().getState().getResolvedBundles();
        StateHelper stateHelper = EclipseAdaptor.getDefault().getPlatformAdmin().getStateHelper();
        Object[][] cycles = stateHelper.sortBundles(this.allToStop);
        this.logCycles(cycles);
        this.stoppedBundles = new Hashtable(this.allToStop.length);
        this.basicStopBundles();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void basicStopBundles() {
        BundleContext context = EclipseAdaptor.getDefault().getContext();
        for (int stoppingIndex = this.allToStop.length - 1; stoppingIndex >= 0; --stoppingIndex) {
            AbstractBundle toStop = (AbstractBundle)context.getBundle(this.allToStop[stoppingIndex].getBundleId());
            try {
                if (toStop.getState() != 32 || !(toStop instanceof BundleHost) || toStop.getBundleId() == 0L || !((EclipseBundleData)toStop.getBundleData()).isAutoStartable()) continue;
                toStop.stop();
                continue;
            }
            catch (Exception e) {
                String message = EclipseAdaptorMsg.formatter.getString("ECLIPSE_BUNDLESTOPPER_ERROR_STOPPING_BUNDLE", (Object)this.allToStop[stoppingIndex].toString());
                FrameworkLogEntry entry = new FrameworkLogEntry("org.eclipse.osgi", message, 0, (Throwable)e, null);
                EclipseAdaptor.getDefault().getFrameworkLog().log(entry);
                continue;
            }
            finally {
                this.stoppedBundles.put(toStop, toStop);
            }
        }
    }

    public boolean isStopped(Bundle bundle) {
        if (this.stoppedBundles == null) {
            return false;
        }
        return this.stoppedBundles.get(bundle) != null;
    }
}

