/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.texteditor;

import java.util.ResourceBundle;
import org.eclipse.jface.text.ITextOperationTarget;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.texteditor.IReadOnlyDependent;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.TextEditorAction;

public class ShiftAction
extends TextEditorAction
implements IReadOnlyDependent {
    private int fOperationCode = -1;
    private ITextOperationTarget fOperationTarget;
    static /* synthetic */ Class class$org$eclipse$jface$text$ITextOperationTarget;

    public ShiftAction(ResourceBundle bundle, String prefix, ITextEditor editor, int operationCode) {
        super(bundle, prefix, editor);
        this.fOperationCode = operationCode;
        this.update();
    }

    public void run() {
        if (this.fOperationCode == -1 || this.fOperationTarget == null) {
            return;
        }
        ITextEditor editor = this.getTextEditor();
        if (editor == null) {
            return;
        }
        if (!this.validateEditorInputState()) {
            return;
        }
        Display display = null;
        IWorkbenchPartSite site = editor.getSite();
        Shell shell = site.getShell();
        if (shell != null && !shell.isDisposed()) {
            display = shell.getDisplay();
        }
        BusyIndicator.showWhile((Display)display, (Runnable)new Runnable(){

            public void run() {
                ShiftAction.this.fOperationTarget.doOperation(ShiftAction.this.fOperationCode);
            }
        });
    }

    public void update() {
        super.update();
        if (!this.isEnabled()) {
            return;
        }
        if (!this.canModifyEditor()) {
            this.setEnabled(false);
            return;
        }
        ITextEditor editor = this.getTextEditor();
        if (this.fOperationTarget == null && editor != null && this.fOperationCode != -1) {
            this.fOperationTarget = (ITextOperationTarget)editor.getAdapter(class$org$eclipse$jface$text$ITextOperationTarget == null ? (class$org$eclipse$jface$text$ITextOperationTarget = ShiftAction.class$("org.eclipse.jface.text.ITextOperationTarget")) : class$org$eclipse$jface$text$ITextOperationTarget);
        }
    }

    protected void updateForTab() {
        super.update();
        if (this.isEnabled()) {
            if (!this.canModifyEditor()) {
                this.setEnabled(false);
                return;
            }
            ITextEditor editor = this.getTextEditor();
            if (this.fOperationTarget == null && editor != null && this.fOperationCode != -1) {
                this.fOperationTarget = (ITextOperationTarget)editor.getAdapter(class$org$eclipse$jface$text$ITextOperationTarget == null ? (class$org$eclipse$jface$text$ITextOperationTarget = ShiftAction.class$("org.eclipse.jface.text.ITextOperationTarget")) : class$org$eclipse$jface$text$ITextOperationTarget);
            }
            boolean isEnabled = this.fOperationTarget != null && this.fOperationTarget.canDoOperation(this.fOperationCode);
            this.setEnabled(isEnabled);
        }
    }

    public void setEditor(ITextEditor editor) {
        super.setEditor(editor);
        this.fOperationTarget = null;
    }

    public boolean isEnabled(boolean isWritable) {
        if (!isWritable) {
            return false;
        }
        ITextEditor editor = this.getTextEditor();
        if (this.fOperationTarget == null && editor != null && this.fOperationCode != -1) {
            this.fOperationTarget = (ITextOperationTarget)editor.getAdapter(class$org$eclipse$jface$text$ITextOperationTarget == null ? (class$org$eclipse$jface$text$ITextOperationTarget = ShiftAction.class$("org.eclipse.jface.text.ITextOperationTarget")) : class$org$eclipse$jface$text$ITextOperationTarget);
        }
        return this.fOperationTarget != null && this.fOperationTarget.canDoOperation(this.fOperationCode);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

