/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ltk.internal.ui.refactoring;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.CompareUI;
import org.eclipse.compare.CompareViewerSwitchingPane;
import org.eclipse.compare.IEncodedStreamContentAccessor;
import org.eclipse.compare.ITypedElement;
import org.eclipse.compare.structuremergeviewer.DiffNode;
import org.eclipse.compare.structuremergeviewer.ICompareInput;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.TextChange;
import org.eclipse.ltk.core.refactoring.TextEditChangeGroup;
import org.eclipse.ltk.internal.ui.refactoring.RefactoringUIMessages;
import org.eclipse.ltk.internal.ui.refactoring.RefactoringUIPlugin;
import org.eclipse.ltk.ui.refactoring.ChangePreviewViewerInput;
import org.eclipse.ltk.ui.refactoring.IChangePreviewViewer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.model.IWorkbenchAdapter;

public class TextChangePreviewViewer
implements IChangePreviewViewer {
    private ComparePreviewer fViewer;
    static /* synthetic */ Class class$org$eclipse$ui$model$IWorkbenchAdapter;

    public static ChangePreviewViewerInput createInput(TextChange change) {
        return new ChangePreviewViewerInput((Change)change);
    }

    public static ChangePreviewViewerInput createInput(Change change, TextEditChangeGroup group, int surroundingLines) {
        TextEditChangeInput result = new TextEditChangeInput(change);
        result.group = group;
        result.surroundingLines = surroundingLines;
        return result;
    }

    public static ChangePreviewViewerInput createInput(Change change, TextEditChangeGroup[] groups, IRegion range) {
        TextEditChangeInput result = new TextEditChangeInput(change);
        result.groups = groups;
        result.range = range;
        return result;
    }

    public void createControl(Composite parent) {
        this.fViewer = new ComparePreviewer(parent);
    }

    public Control getControl() {
        return this.fViewer;
    }

    public void setInput(ChangePreviewViewerInput input) {
        try {
            Change change = input.getChange();
            if (input instanceof TextEditChangeInput) {
                TextEditChangeInput edi = (TextEditChangeInput)input;
                if (edi.group != null && edi.surroundingLines >= 0) {
                    TextEditChangeGroup editChange = edi.group;
                    TextChange textChange = editChange.getTextChange();
                    this.setInput(textChange, textChange.getCurrentContent(editChange.getRegion(), true, 2, (IProgressMonitor)new NullProgressMonitor()), textChange.getPreviewContent(new TextEditChangeGroup[]{editChange}, editChange.getRegion(), true, 2, (IProgressMonitor)new NullProgressMonitor()), textChange.getTextType());
                    return;
                }
                if (edi.groups != null && edi.groups.length > 0 && edi.range != null) {
                    TextChange textChange = edi.groups[0].getTextChange();
                    this.setInput(textChange, textChange.getCurrentContent(edi.range, true, 0, (IProgressMonitor)new NullProgressMonitor()), textChange.getPreviewContent(edi.groups, edi.range, true, 0, (IProgressMonitor)new NullProgressMonitor()), textChange.getTextType());
                    return;
                }
            } else {
                if (change instanceof TextChange) {
                    TextChange textChange = (TextChange)change;
                    this.setInput(textChange, textChange.getCurrentContent((IProgressMonitor)new NullProgressMonitor()), textChange.getPreviewContent((IProgressMonitor)new NullProgressMonitor()), textChange.getTextType());
                    return;
                }
                this.fViewer.setInput(null);
            }
        }
        catch (CoreException e) {
            RefactoringUIPlugin.log(e);
            this.fViewer.setInput(null);
        }
    }

    public void refresh() {
        this.fViewer.getViewer().refresh();
    }

    private void setInput(TextChange change, String left, String right, String type) {
        Object element = change.getModifiedElement();
        if (element instanceof IAdaptable) {
            IWorkbenchAdapter adapter = (IWorkbenchAdapter)((IAdaptable)element).getAdapter(class$org$eclipse$ui$model$IWorkbenchAdapter == null ? (class$org$eclipse$ui$model$IWorkbenchAdapter = TextChangePreviewViewer.class$("org.eclipse.ui.model.IWorkbenchAdapter")) : class$org$eclipse$ui$model$IWorkbenchAdapter);
            if (adapter != null) {
                this.fViewer.setLabel(adapter.getLabel(element));
                this.fViewer.setImageDescriptor(adapter.getImageDescriptor(element));
            } else {
                this.fViewer.setLabel(null);
                this.fViewer.setImageDescriptor(null);
            }
        } else {
            this.fViewer.setLabel(null);
            this.fViewer.setImageDescriptor(null);
        }
        this.fViewer.setInput(new DiffNode((ITypedElement)new CompareElement(left, type), (ITypedElement)new CompareElement(right, type)));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class CompareElement
    implements ITypedElement,
    IEncodedStreamContentAccessor {
        private static final String ENCODING = "UTF-8";
        private String fContent;
        private String fType;

        public CompareElement(String content, String type) {
            this.fContent = content;
            this.fType = type;
        }

        public String getName() {
            return RefactoringUIMessages.getString("ComparePreviewer.element_name");
        }

        public Image getImage() {
            return null;
        }

        public String getType() {
            return this.fType;
        }

        public InputStream getContents() throws CoreException {
            try {
                return new ByteArrayInputStream(this.fContent.getBytes(ENCODING));
            }
            catch (UnsupportedEncodingException e) {
                return new ByteArrayInputStream(this.fContent.getBytes());
            }
        }

        public String getCharset() {
            return ENCODING;
        }
    }

    private static class ComparePreviewer
    extends CompareViewerSwitchingPane {
        private CompareConfiguration fCompareConfiguration = new CompareConfiguration();
        private String fLabel;
        private ImageDescriptor fDescriptor;
        private Image fImage;

        public ComparePreviewer(Composite parent) {
            super(parent, 0x800800, true);
            this.fCompareConfiguration.setLeftEditable(false);
            this.fCompareConfiguration.setLeftLabel(RefactoringUIMessages.getString("ComparePreviewer.original_source"));
            this.fCompareConfiguration.setRightEditable(false);
            this.fCompareConfiguration.setRightLabel(RefactoringUIMessages.getString("ComparePreviewer.refactored_source"));
            this.addDisposeListener(new DisposeListener(this){
                private final /* synthetic */ ComparePreviewer this$0;
                {
                    this.this$0 = this$0;
                }

                public void widgetDisposed(DisposeEvent e) {
                    if (ComparePreviewer.access$000(this.this$0) != null && !ComparePreviewer.access$000(this.this$0).isDisposed()) {
                        ComparePreviewer.access$000(this.this$0).dispose();
                    }
                }
            });
        }

        public void setLabel(String label) {
            this.fLabel = label;
        }

        public void setImageDescriptor(ImageDescriptor imageDescriptor) {
            this.fDescriptor = imageDescriptor;
        }

        protected Viewer getViewer(Viewer oldViewer, Object input) {
            return CompareUI.findContentViewer((Viewer)oldViewer, (ICompareInput)((ICompareInput)input), (Composite)this, (CompareConfiguration)this.fCompareConfiguration);
        }

        public void setText(String text) {
            if (this.fLabel != null) {
                super.setText(this.fLabel);
            } else {
                super.setText(text);
            }
            Image current = null;
            if (this.fDescriptor != null) {
                current = this.fImage;
                this.fImage = this.fDescriptor.createImage();
            } else {
                current = this.fImage;
                this.fImage = null;
            }
            this.setImage(this.fImage);
            if (current != null) {
                current.dispose();
            }
        }

        static /* synthetic */ Image access$000(ComparePreviewer x0) {
            return x0.fImage;
        }
    }

    private static class TextEditChangeInput
    extends ChangePreviewViewerInput {
        TextEditChangeGroup group;
        int surroundingLines;
        TextEditChangeGroup[] groups;
        IRegion range;

        public TextEditChangeInput(Change change) {
            super(change);
        }
    }
}

