/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.JavadocArgumentExpression;
import org.eclipse.jdt.internal.compiler.ast.MessageSend;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.ClassScope;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.ProblemMethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeConstants;

public class JavadocMessageSend
extends MessageSend {
    public int tagSourceStart;
    public int tagSourceEnd;
    public boolean superAccess = false;

    public JavadocMessageSend(char[] name, long pos) {
        this.selector = name;
        this.nameSourcePosition = pos;
        this.sourceStart = (int)(this.nameSourcePosition >>> 32);
        this.sourceEnd = (int)this.nameSourcePosition;
        this.bits |= 0x8000;
    }

    public JavadocMessageSend(char[] name, long pos, JavadocArgumentExpression[] arguments) {
        this(name, pos);
        this.arguments = arguments;
    }

    private TypeBinding internalResolveType(Scope scope) {
        this.constant = NotAConstant;
        this.receiverType = this.receiver == null ? scope.enclosingSourceType() : (scope.kind == 3 ? this.receiver.resolveType((ClassScope)scope) : this.receiver.resolveType((BlockScope)scope));
        TypeBinding[] argumentTypes = TypeConstants.NoParameters;
        if (this.arguments != null) {
            boolean argHasError = false;
            int length = this.arguments.length;
            argumentTypes = new TypeBinding[length];
            for (int i = 0; i < length; ++i) {
                Expression argument = this.arguments[i];
                argumentTypes[i] = scope.kind == 3 ? argument.resolveType((ClassScope)scope) : argument.resolveType((BlockScope)scope);
                if (argumentTypes[i] != null) continue;
                argHasError = true;
            }
            if (argHasError) {
                return null;
            }
        }
        if (this.receiverType == null) {
            return null;
        }
        this.qualifyingType = this.receiverType;
        this.superAccess = scope.enclosingSourceType().isCompatibleWith(this.receiverType);
        if (this.receiverType.isBaseType()) {
            scope.problemReporter().javadocErrorNoMethodFor(this, this.receiverType, argumentTypes, scope.getDeclarationModifiers());
            return null;
        }
        MethodBinding methodBinding = this.binding = this.receiver != null && this.receiver.isThis() ? scope.getImplicitMethod(this.selector, argumentTypes, this) : scope.getMethod(this.receiverType, this.selector, argumentTypes, this);
        if (!this.binding.isValidBinding()) {
            switch (this.binding.problemId()) {
                case 5: 
                case 6: 
                case 7: {
                    MethodBinding closestMatch = ((ProblemMethodBinding)this.binding).closestMatch;
                    if (closestMatch == null) break;
                    this.binding = closestMatch;
                }
            }
        }
        if (!this.binding.isValidBinding()) {
            MethodBinding closestMatch;
            if (this.binding.declaringClass == null) {
                if (this.receiverType instanceof ReferenceBinding) {
                    this.binding.declaringClass = (ReferenceBinding)this.receiverType;
                } else {
                    scope.problemReporter().javadocErrorNoMethodFor(this, this.receiverType, argumentTypes, scope.getDeclarationModifiers());
                    return null;
                }
            }
            scope.problemReporter().javadocInvalidMethod(this, this.binding, scope.getDeclarationModifiers());
            if (this.binding instanceof ProblemMethodBinding && (closestMatch = ((ProblemMethodBinding)this.binding).closestMatch) != null) {
                this.codegenBinding = this.binding = closestMatch;
            }
            this.resolvedType = this.binding == null ? null : this.binding.returnType;
            return this.resolvedType;
        }
        if (this.isMethodUseDeprecated(this.binding, scope)) {
            scope.problemReporter().javadocDeprecatedMethod(this.binding, this, scope.getDeclarationModifiers());
        }
        this.resolvedType = this.binding.returnType;
        return this.resolvedType;
    }

    public boolean isSuperAccess() {
        return this.superAccess;
    }

    public StringBuffer printExpression(int indent, StringBuffer output) {
        if (this.receiver != null) {
            this.receiver.printExpression(0, output);
        }
        output.append('#').append(this.selector).append('(');
        if (this.arguments != null) {
            for (int i = 0; i < this.arguments.length; ++i) {
                if (i > 0) {
                    output.append(", ");
                }
                this.arguments[i].printExpression(0, output);
            }
        }
        return output.append(')');
    }

    public TypeBinding resolveType(BlockScope scope) {
        return this.internalResolveType(scope);
    }

    public TypeBinding resolveType(ClassScope scope) {
        return this.internalResolveType(scope);
    }

    public void traverse(ASTVisitor visitor, BlockScope blockScope) {
        if (visitor.visit(this, blockScope)) {
            if (this.receiver != null) {
                this.receiver.traverse(visitor, blockScope);
            }
            if (this.arguments != null) {
                int argumentsLength = this.arguments.length;
                for (int i = 0; i < argumentsLength; ++i) {
                    this.arguments[i].traverse(visitor, blockScope);
                }
            }
        }
        visitor.endVisit(this, blockScope);
    }
}

