/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.core.sourcelookup.containers;

import java.io.File;
import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.sourcelookup.ISourceContainer;
import org.eclipse.debug.core.sourcelookup.ISourceContainerType;
import org.eclipse.debug.core.sourcelookup.containers.CompositeSourceContainer;
import org.eclipse.debug.core.sourcelookup.containers.LocalFileStorage;

public class DirectorySourceContainer
extends CompositeSourceContainer {
    private File fDirectory;
    private boolean fSubfolders = false;
    public static final String TYPE_ID = DebugPlugin.getUniqueIdentifier() + ".containerType.directory";

    public DirectorySourceContainer(IPath dirPath, boolean subfolders) {
        this(dirPath.toFile(), subfolders);
    }

    public DirectorySourceContainer(File dir, boolean subfolders) {
        this.fDirectory = dir;
        this.fSubfolders = subfolders;
    }

    public String getName() {
        return this.fDirectory.getName();
    }

    public File getDirectory() {
        return this.fDirectory;
    }

    public ISourceContainerType getType() {
        return this.getSourceContainerType(TYPE_ID);
    }

    public Object[] findSourceElements(String name) throws CoreException {
        ArrayList<Object> sources = new ArrayList<Object>();
        File directory = this.getDirectory();
        File file = new File(directory, name);
        if (file.exists() && file.isFile()) {
            sources.add((Object)new LocalFileStorage(file));
        }
        if (this.isFindDuplicates() && this.fSubfolders || sources.isEmpty() && this.fSubfolders) {
            ISourceContainer[] containers = this.getSourceContainers();
            for (int i = 0; i < containers.length; ++i) {
                Object[] objects = containers[i].findSourceElements(name);
                if (objects == null || objects.length == 0) continue;
                if (this.isFindDuplicates()) {
                    for (int j = 0; j < objects.length; ++j) {
                        sources.add(objects[j]);
                    }
                    continue;
                }
                sources.add(objects[0]);
                break;
            }
        }
        if (sources.isEmpty()) {
            return EMPTY;
        }
        return sources.toArray();
    }

    public boolean isComposite() {
        return this.fSubfolders;
    }

    public boolean equals(Object obj) {
        if (obj instanceof DirectorySourceContainer) {
            DirectorySourceContainer container = (DirectorySourceContainer)obj;
            return container.getDirectory().equals(this.getDirectory());
        }
        return false;
    }

    public int hashCode() {
        return this.getDirectory().hashCode();
    }

    protected ISourceContainer[] createSourceContainers() throws CoreException {
        String[] files;
        if (this.isComposite() && (files = this.fDirectory.list()) != null) {
            ArrayList<DirectorySourceContainer> dirs = new ArrayList<DirectorySourceContainer>();
            for (int i = 0; i < files.length; ++i) {
                String name = files[i];
                File file = new File(this.getDirectory(), name);
                if (!file.exists() || !file.isDirectory()) continue;
                dirs.add(new DirectorySourceContainer(file, true));
            }
            ISourceContainer[] containers = dirs.toArray(new ISourceContainer[dirs.size()]);
            for (int i = 0; i < containers.length; ++i) {
                ISourceContainer container = containers[i];
                container.init(this.getDirector());
            }
            return containers;
        }
        return new ISourceContainer[0];
    }
}

