/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.core.syncinfo;

import java.util.Date;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.CVSTag;
import org.eclipse.team.internal.ccvs.core.client.Command;
import org.eclipse.team.internal.ccvs.core.syncinfo.ResourceSyncInfo;
import org.eclipse.team.internal.ccvs.core.util.Assert;

public class MutableResourceSyncInfo
extends ResourceSyncInfo {
    boolean reported;
    boolean changed;

    protected MutableResourceSyncInfo(ResourceSyncInfo info) {
        this.name = info.getName();
        this.setRevision(info.getRevision());
        this.setTag(info.getTag());
        this.permissions = info.getPermissions();
        this.timeStamp = info.getTimeStamp();
        this.isDirectory = info.isDirectory();
        this.keywordMode = info.getKeywordMode();
        this.isDeleted = info.isDeleted();
        if (info.isMergedWithConflicts()) {
            this.setSyncType(3);
        } else if (info.isMerged()) {
            this.setSyncType(2);
        } else {
            this.setSyncType(1);
        }
    }

    public MutableResourceSyncInfo(String name, String revision) {
        Assert.isNotNull(name);
        this.name = name;
        this.setRevision(revision);
        this.reported = false;
        this.changed = false;
    }

    void setResourceInfoType(int type) {
        this.syncType = type;
    }

    public void setRevision(String revision) {
        super.setRevision(revision);
    }

    public void setTimeStamp(Date timeStamp) {
        this.timeStamp = timeStamp;
        this.changed = true;
    }

    public void setTimeStamp(Date timeStamp, boolean clearMerged) {
        this.setTimeStamp(timeStamp);
        if (clearMerged) {
            this.setSyncType(1);
        }
    }

    public void setKeywordMode(Command.KSubstOption keywordMode) {
        this.keywordMode = keywordMode;
        this.changed = true;
    }

    public void setTag(CVSTag tag) {
        super.setTag(tag);
    }

    public void setPermissions(String permissions) {
        this.permissions = permissions;
    }

    public void setDeleted(boolean isDeleted) {
        this.isDeleted = isDeleted;
        this.changed = true;
    }

    public void setAdded() {
        this.setRevision("0");
        this.changed = true;
    }

    public void setMerged() {
        if (this.syncType == 1) {
            this.syncType = 2;
            this.changed = true;
        }
    }

    public boolean needsReporting() {
        return this.changed && !this.reported;
    }

    public void reported() {
        this.reported = true;
    }

    public void setEntryLine(String entryLine) throws CVSException {
        super.setEntryLine(entryLine);
        this.changed = true;
    }
}

