/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.core;

import java.io.IOException;
import java.util.jar.JarEntry;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.update.core.BaseInstallHandler;
import org.eclipse.update.core.ContentReference;
import org.eclipse.update.core.IContentConsumer;
import org.eclipse.update.core.IFeatureContentConsumer;
import org.eclipse.update.core.IFeatureContentProvider;
import org.eclipse.update.core.INonPluginEntry;
import org.eclipse.update.core.IVerificationListener;
import org.eclipse.update.core.IVerificationResult;
import org.eclipse.update.core.IVerifier;
import org.eclipse.update.core.JarContentReference;
import org.eclipse.update.core.Utilities;
import org.eclipse.update.core.model.InstallAbortedException;
import org.eclipse.update.internal.core.Policy;

public class DefaultInstallHandler
extends BaseInstallHandler {
    public void nonPluginDataDownloaded(INonPluginEntry[] nonPluginData, IVerificationListener listener) throws CoreException {
        if (nonPluginData == null || nonPluginData.length == 0) {
            return;
        }
        this.nonPluginEntries = nonPluginData;
        IFeatureContentProvider provider = this.feature.getFeatureContentProvider();
        IVerifier verifier = provider.getVerifier();
        if (verifier == null) {
            return;
        }
        for (int i = 0; i < this.nonPluginEntries.length; ++i) {
            ContentReference[] archives = provider.getNonPluginEntryArchiveReferences(this.nonPluginEntries[i], this.monitor);
            for (int j = 0; j < archives.length; ++j) {
                IVerificationResult result;
                ContentReference archive = archives[j];
                if (!(archives[j] instanceof JarContentReference) && archives[j].getIdentifier().endsWith(".jar")) {
                    try {
                        archive = new JarContentReference(archives[j].getIdentifier(), archives[j].asFile());
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                }
                if ((result = verifier.verify(this.feature, archive, false, this.monitor)) == null) continue;
                this.promptForVerification(result, listener);
            }
        }
    }

    public void completeInstall(IFeatureContentConsumer consumer) throws CoreException {
        if (this.nonPluginEntries == null || this.nonPluginEntries.length == 0) {
            return;
        }
        IFeatureContentProvider provider = this.feature.getFeatureContentProvider();
        for (int i = 0; i < this.nonPluginEntries.length; ++i) {
            ContentReference[] archive = provider.getNonPluginEntryArchiveReferences(this.nonPluginEntries[i], this.monitor);
            IContentConsumer nonPluginConsumer = consumer.open(this.nonPluginEntries[i]);
            for (int j = 0; j < archive.length; ++j) {
                String id = archive[j].getIdentifier();
                if (id.endsWith(".jar")) {
                    try {
                        final String prefix = id.substring(0, id.length() - 4) + "/";
                        JarContentReference jarRef = new JarContentReference("", archive[j].asFile());
                        JarContentReference.ContentSelector selector = new JarContentReference.ContentSelector(){

                            public String defineIdentifier(JarEntry entry) {
                                if (entry == null) {
                                    return null;
                                }
                                return prefix + entry.getName();
                            }
                        };
                        ContentReference[] entries = jarRef.peek(selector, this.monitor);
                        for (int k = 0; k < entries.length; ++k) {
                            nonPluginConsumer.store(entries[k], this.monitor);
                        }
                        continue;
                    }
                    catch (IOException e) {
                        throw Utilities.newCoreException(Policy.bind("JarVerificationService.CancelInstall", id), e);
                    }
                }
                nonPluginConsumer.store(archive[j], this.monitor);
            }
            nonPluginConsumer.close();
        }
    }

    private void promptForVerification(IVerificationResult verificationResult, IVerificationListener listener) throws CoreException {
        if (listener == null) {
            return;
        }
        int result = listener.prompt(verificationResult);
        if (result == 0) {
            Exception e = verificationResult.getVerificationException();
            throw new InstallAbortedException(Policy.bind("JarVerificationService.CancelInstall"), e);
        }
        if (result == 1) {
            throw Utilities.newCoreException(Policy.bind("JarVerificationService.UnsucessfulVerification"), verificationResult.getVerificationException());
        }
    }
}

