/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.viewers;

import java.util.ArrayList;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.util.Assert;
import org.eclipse.jface.util.ListenerList;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.CustomHashtable;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.ICheckable;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Widget;

public class CheckboxTableViewer
extends TableViewer
implements ICheckable {
    private ListenerList checkStateListeners = new ListenerList(3);

    public CheckboxTableViewer(Composite parent) {
        this(parent, 2048);
    }

    public CheckboxTableViewer(Composite parent, int style) {
        this(CheckboxTableViewer.createTable(parent, style));
    }

    public static CheckboxTableViewer newCheckList(Composite parent, int style) {
        Table table = new Table(parent, 0x20 | style);
        return new CheckboxTableViewer(table);
    }

    public CheckboxTableViewer(Table table) {
        super(table);
    }

    public void addCheckStateListener(ICheckStateListener listener) {
        this.checkStateListeners.add(listener);
    }

    protected static Table createTable(Composite parent, int style) {
        Table table = new Table(parent, 0x20 | style);
        new TableColumn(table, 0);
        TableLayout layout = new TableLayout();
        layout.addColumnData(new ColumnWeightData(100));
        table.setLayout((Layout)layout);
        return table;
    }

    private void fireCheckStateChanged(final CheckStateChangedEvent event) {
        Object[] array = this.checkStateListeners.getListeners();
        for (int i = 0; i < array.length; ++i) {
            final ICheckStateListener l = (ICheckStateListener)array[i];
            Platform.run((ISafeRunnable)new SafeRunnable(){

                public void run() {
                    l.checkStateChanged(event);
                }
            });
        }
    }

    public boolean getChecked(Object element) {
        Widget widget = this.findItem(element);
        if (widget instanceof TableItem) {
            return ((TableItem)widget).getChecked();
        }
        return false;
    }

    public Object[] getCheckedElements() {
        TableItem[] children = this.getTable().getItems();
        ArrayList<Object> v = new ArrayList<Object>(children.length);
        for (int i = 0; i < children.length; ++i) {
            TableItem item = children[i];
            if (!item.getChecked()) continue;
            v.add(item.getData());
        }
        return v.toArray();
    }

    public boolean getGrayed(Object element) {
        Widget widget = this.findItem(element);
        if (widget instanceof TableItem) {
            return ((TableItem)widget).getGrayed();
        }
        return false;
    }

    public Object[] getGrayedElements() {
        TableItem[] children = this.getTable().getItems();
        ArrayList<Object> v = new ArrayList<Object>(children.length);
        for (int i = 0; i < children.length; ++i) {
            TableItem item = children[i];
            if (!item.getGrayed()) continue;
            v.add(item.getData());
        }
        return v.toArray();
    }

    public void handleSelect(SelectionEvent event) {
        if (event.detail == 32) {
            super.handleSelect(event);
            TableItem item = (TableItem)event.item;
            Object data = item.getData();
            if (data != null) {
                this.fireCheckStateChanged(new CheckStateChangedEvent(this, data, item.getChecked()));
            }
        } else {
            super.handleSelect(event);
        }
    }

    protected void preservingSelection(Runnable updateCode) {
        Object data;
        TableItem item;
        int i;
        TableItem[] children = this.getTable().getItems();
        CustomHashtable checked = this.newHashtable(children.length * 2 + 1);
        CustomHashtable grayed = this.newHashtable(children.length * 2 + 1);
        for (i = 0; i < children.length; ++i) {
            item = children[i];
            data = item.getData();
            if (data == null) continue;
            if (item.getChecked()) {
                checked.put(data, data);
            }
            if (!item.getGrayed()) continue;
            grayed.put(data, data);
        }
        super.preservingSelection(updateCode);
        children = this.getTable().getItems();
        for (i = 0; i < children.length; ++i) {
            item = children[i];
            data = item.getData();
            if (data == null) continue;
            item.setChecked(checked.containsKey(data));
            item.setGrayed(grayed.containsKey(data));
        }
    }

    public void removeCheckStateListener(ICheckStateListener listener) {
        this.checkStateListeners.remove(listener);
    }

    public void setAllChecked(boolean state) {
        TableItem[] children = this.getTable().getItems();
        for (int i = 0; i < children.length; ++i) {
            TableItem item = children[i];
            item.setChecked(state);
        }
    }

    public void setAllGrayed(boolean state) {
        TableItem[] children = this.getTable().getItems();
        for (int i = 0; i < children.length; ++i) {
            TableItem item = children[i];
            item.setGrayed(state);
        }
    }

    public boolean setChecked(Object element, boolean state) {
        Assert.isNotNull(element);
        Widget widget = this.findItem(element);
        if (widget instanceof TableItem) {
            ((TableItem)widget).setChecked(state);
            return true;
        }
        return false;
    }

    public void setCheckedElements(Object[] elements) {
        this.assertElementsNotNull(elements);
        CustomHashtable set = this.newHashtable(elements.length * 2 + 1);
        for (int i = 0; i < elements.length; ++i) {
            set.put(elements[i], elements[i]);
        }
        TableItem[] items = this.getTable().getItems();
        for (int i = 0; i < items.length; ++i) {
            TableItem item = items[i];
            Object element = item.getData();
            if (element == null) continue;
            boolean check = set.containsKey(element);
            if (item.getChecked() == check) continue;
            item.setChecked(check);
        }
    }

    public boolean setGrayed(Object element, boolean state) {
        Assert.isNotNull(element);
        Widget widget = this.findItem(element);
        if (widget instanceof TableItem) {
            ((TableItem)widget).setGrayed(state);
            return true;
        }
        return false;
    }

    public void setGrayedElements(Object[] elements) {
        this.assertElementsNotNull(elements);
        CustomHashtable set = this.newHashtable(elements.length * 2 + 1);
        for (int i = 0; i < elements.length; ++i) {
            set.put(elements[i], elements[i]);
        }
        TableItem[] items = this.getTable().getItems();
        for (int i = 0; i < items.length; ++i) {
            TableItem item = items[i];
            Object element = item.getData();
            if (element == null) continue;
            boolean gray = set.containsKey(element);
            if (item.getGrayed() == gray) continue;
            item.setGrayed(gray);
        }
    }
}

