/*	$OpenBSD: octmmcreg.h,v 1.3 2017/10/16 14:18:47 visa Exp $	*/

/*
 * Copyright (c) 2016 Visa Hankala
 *
 * Permission to use, copy, modify, and/or distribute this software for any
 * purpose with or without fee is hereby granted, provided that the above
 * copyright notice and this permission notice appear in all copies.
 *
 * THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
 * WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
 * ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
 * ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
 * OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 */

#ifndef _OCTMMCREG_H_
#define _OCTMMCREG_H_

#define MIO_BOOT_CFG				0x00011800000000d0ull

/*
 * MMC registers
 */

#define MIO_EMM_CFG			0x00
#define MIO_EMM_SWITCH			0x48
#define   MIO_EMM_SWITCH_RES_62_63		0xc000000000000000ull
#define   MIO_EMM_SWITCH_BUS_ID			0x3000000000000000ull
#define   MIO_EMM_SWITCH_BUS_ID_SHIFT		60
#define   MIO_EMM_SWITCH_SWITCH_EXE		0x0800000000000000ull
#define   MIO_EMM_SWITCH_SWITCH_ERR0		0x0400000000000000ull
#define   MIO_EMM_SWITCH_SWITCH_ERR1		0x0200000000000000ull
#define   MIO_EMM_SWITCH_SWITCH_ERR2		0x0100000000000000ull
#define   MIO_EMM_SWITCH_RES_49_55		0x00fe000000000000ull
#define   MIO_EMM_SWITCH_HS_TIMING		0x0001000000000000ull
#define   MIO_EMM_SWITCH_HS_TIMING_SHIFT	48
#define   MIO_EMM_SWITCH_RES_43_47		0x0000f80000000000ull
#define   MIO_EMM_SWITCH_BUS_WIDTH		0x0000070000000000ull
#define   MIO_EMM_SWITCH_BUS_WIDTH_SHIFT	40
#define   MIO_EMM_SWITCH_RES_36_39		0x000000f000000000ull
#define   MIO_EMM_SWITCH_POWER_CLASS		0x0000000f00000000ull
#define   MIO_EMM_SWITCH_POWER_CLASS_SHIFT	32
#define   MIO_EMM_SWITCH_CLK_HI			0x00000000ffff0000ull
#define   MIO_EMM_SWITCH_CLK_HI_SHIFT		16
#define   MIO_EMM_SWITCH_CLK_LO			0x000000000000ffffull
#define   MIO_EMM_SWITCH_CLK_LO_SHIFT		0
#define   MIO_EMM_SWITCH_CLK_MAX		0xffffu
#define MIO_EMM_DMA			0x50
#define   MIO_EMM_DMA_RES_62_63			0xc000000000000000ull
#define   MIO_EMM_DMA_BUS_ID			0x3000000000000000ull
#define   MIO_EMM_DMA_BUS_ID_SHIFT		60
#define   MIO_EMM_DMA_DMA_VAL			0x0800000000000000ull
#define   MIO_EMM_DMA_SECTOR			0x0400000000000000ull
#define   MIO_EMM_DMA_DAT_NULL			0x0200000000000000ull
#define   MIO_EMM_DMA_THRES			0x01f8000000000000ull
#define   MIO_EMM_DMA_REL_WR			0x0004000000000000ull
#define   MIO_EMM_DMA_RW			0x0002000000000000ull
#define   MIO_EMM_DMA_MULTI			0x0001000000000000ull
#define   MIO_EMM_DMA_BLOCK_CNT			0x0000ffff00000000ull
#define   MIO_EMM_DMA_BLOCK_CNT_SHIFT		32
#define   MIO_EMM_DMA_CARD_ADDR			0x00000000ffffffffull
#define MIO_EMM_CMD			0x58
#define   MIO_EMM_CMD_RES_62_63			0xc000000000000000ull
#define   MIO_EMM_CMD_BUS_ID			0x3000000000000000ull
#define   MIO_EMM_CMD_BUS_ID_SHIFT		60
#define   MIO_EMM_CMD_CMD_VAL			0x0800000000000000ull
#define   MIO_EMM_CMD_RES_56_58			0x0700000000000000ull
#define   MIO_EMM_CMD_DBUF			0x0080000000000000ull
#define   MIO_EMM_CMD_OFFSET			0x007e000000000000ull
#define   MIO_EMM_CMD_RES_43_48			0x0001f80000000000ull
#define   MIO_EMM_CMD_CTYPE_XOR			0x0000060000000000ull
#define   MIO_EMM_CMD_CTYPE_XOR_SHIFT		41
#define   MIO_EMM_CMD_RTYPE_XOR			0x000001c000000000ull
#define   MIO_EMM_CMD_RTYPE_XOR_SHIFT		38
#define   MIO_EMM_CMD_CMD_IDX			0x0000003f00000000ull
#define   MIO_EMM_CMD_CMD_IDX_SHIFT		32
#define   MIO_EMM_CMD_ARG			0x00000000ffffffffull
#define MIO_EMM_RSP_STS			0x60
#define   MIO_EMM_RSP_STS_RES_62_63		0xc000000000000000ull
#define   MIO_EMM_RSP_STS_BUS_ID		0x3000000000000000ull
#define   MIO_EMM_RSP_STS_CMD_VAL		0x0800000000000000ull
#define   MIO_EMM_RSP_STS_SWITCH_VAL		0x0400000000000000ull
#define   MIO_EMM_RSP_STS_DMA_VAL		0x0200000000000000ull
#define   MIO_EMM_RSP_STS_DMA_PEND		0x0100000000000000ull
#define   MIO_EMM_RSP_STS_RES_29_55		0x00ffffffe0000000ull
#define   MIO_EMM_RSP_STS_DBUF_ERR		0x0000000010000000ull
#define   MIO_EMM_RSP_STS_RES_24_27		0x000000000f000000ull
#define   MIO_EMM_RSP_STS_DBUF			0x0000000000800000ull
#define   MIO_EMM_RSP_STS_DBUF_SHIFT		23
#define   MIO_EMM_RSP_STS_BLK_TIMEOUT		0x0000000000400000ull
#define   MIO_EMM_RSP_STS_BLK_CRC_ERR		0x0000000000200000ull
#define   MIO_EMM_RSP_STS_RSP_BUSY		0x0000000000100000ull
#define   MIO_EMM_RSP_STS_STP_TIMEOUT		0x0000000000080000ull
#define   MIO_EMM_RSP_STS_STP_CRC_ERR		0x0000000000040000ull
#define   MIO_EMM_RSP_STS_STP_BAD_STS		0x0000000000020000ull
#define   MIO_EMM_RSP_STS_STP_VAL		0x0000000000010000ull
#define   MIO_EMM_RSP_STS_RSP_TIMEOUT		0x0000000000008000ull
#define   MIO_EMM_RSP_STS_RSP_CRC_ERR		0x0000000000004000ull
#define   MIO_EMM_RSP_STS_RSP_BAD_STS		0x0000000000002000ull
#define   MIO_EMM_RSP_STS_RSP_VAL		0x0000000000001000ull
#define   MIO_EMM_RSP_STS_RSP_TYPE		0x0000000000000e00ull
#define   MIO_EMM_RSP_STS_CMD_TYPE		0x0000000000000180ull
#define   MIO_EMM_RSP_STS_CMD_IDX		0x000000000000007eull
#define   MIO_EMM_RSP_STS_CMD_IDX_SHIFT		1
#define   MIO_EMM_RSP_STS_CMD_DONE		0x0000000000000001ull
#define MIO_EMM_RSP_LO			0x68
#define MIO_EMM_RSP_HI			0x70
#define MIO_EMM_INT			0x78
#define   MIO_EMM_INT_RES_7_63			0xffffffffffffff80ull
#define   MIO_EMM_INT_SWITCH_ERR		0x0000000000000040ull
#define   MIO_EMM_INT_SWITCH_DONE		0x0000000000000020ull
#define   MIO_EMM_INT_DMA_ERR			0x0000000000000010ull
#define   MIO_EMM_INT_CMD_ERR			0x0000000000000008ull
#define   MIO_EMM_INT_DMA_DONE			0x0000000000000004ull
#define   MIO_EMM_INT_CMD_DONE			0x0000000000000002ull
#define   MIO_EMM_INT_BUF_DONE			0x0000000000000001ull
#define MIO_EMM_INT_EN			0x80
#define MIO_EMM_WDOG			0x88
#define   MIO_EMM_WDOG_CLK_CNT			0x0000000003ffffffull
#define MIO_EMM_SAMPLE			0x90
#define   MIO_EMM_SAMPLE_CMD_CNT		0x0000000003ff0000ull
#define   MIO_EMM_SAMPLE_CMD_CNT_SHIFT		16
#define   MIO_EMM_SAMPLE_DAT_CNT		0x00000000000003ffull
#define   MIO_EMM_SAMPLE_DAT_CNT_SHIFT		0
#define MIO_EMM_STS_MASK		0x98
#define MIO_EMM_RCA			0xa0
#define MIO_EMM_BUF_IDX			0xe0
#define   MIO_EMM_BUF_IDX_RES_17_63		0xfffffffffffe0000ull
#define   MIO_EMM_BUF_IDX_INC			0x0000000000010000ull
#define   MIO_EMM_BUF_IDX_RES_7_15		0x000000000000ff80ull
#define   MIO_EMM_BUF_IDX_BUF_NUM		0x0000000000000040ull
#define   MIO_EMM_BUF_IDX_BUF_NUM_SHIFT		6
#define   MIO_EMM_BUF_IDX_OFFSET		0x000000000000003full
#define MIO_EMM_BUF_DAT			0xe8

/*
 * MMC DMA FIFO registers
 */

/* Size of the register space. */
#define MIO_EMM_DMA_FIFO_REGSIZE	0x20

#define MIO_EMM_DMA_FIFO_CFG		0x00
#define   MIO_EMM_DMA_FIFO_CFG_CLR		0x0000000000010000ull

#define MIO_EMM_DMA_FIFO_ADR		0x10

#define MIO_EMM_DMA_FIFO_CMD		0x18
#define   MIO_EMM_DMA_FIFO_CMD_RW		0x4000000000000000ull
#define   MIO_EMM_DMA_FIFO_CMD_INTDIS		0x1000000000000000ull
#define   MIO_EMM_DMA_FIFO_CMD_SIZE		0x00fffff000000000ull
#define   MIO_EMM_DMA_FIFO_CMD_SIZE_SHIFT	36

/*
 * NAND flash DMA registers
 */

#define MIO_NDF_DMA_CFG			0x00
#define   MIO_NDF_DMA_CFG_EN			0x8000000000000000ull
#define   MIO_NDF_DMA_CFG_RW			0x4000000000000000ull
#define   MIO_NDF_DMA_CFG_CLR			0x2000000000000000ull
#define   MIO_NDF_DMA_CFG_RES_60_60		0x1000000000000000ull
#define   MIO_NDF_DMA_CFG_SWAP32		0x0800000000000000ull
#define   MIO_NDF_DMA_CFG_SWAP16		0x0400000000000000ull
#define   MIO_NDF_DMA_CFG_SWAP8			0x0200000000000000ull
#define   MIO_NDF_DMA_CFG_ENDIAN		0x0100000000000000ull
#define   MIO_NDF_DMA_CFG_SIZE			0x00fffff000000000ull
#define   MIO_NDF_DMA_CFG_SIZE_SHIFT		36
#define   MIO_NDF_DMA_CFG_ADDR			0x0000000fffffffffull
#define MIO_NDF_DMA_ADR			0x08

#endif /* !_OCTMMCREG_H_ */
