/*
 * Namespace munging inspired by an equivalent hack in NetBSD's tree: add
 * the "Fssh_" prefix to every symbol in libssh which doesn't already have
 * it.  This prevents collisions between symbols in libssh and symbols in
 * other libraries or applications which link with libssh, either directly
 * or indirectly (e.g. through PAM loading pam_ssh).
 *
 * A list of symbols which need munging is obtained as follows:
 *
 # nm libssh.a | LC_ALL=C awk '
     /^[0-9a-z]+ [Tt] [A-Za-z_][0-9A-Za-z_]*$/ && $3 !~ /^Fssh_/ {
         printf("#define %-39s Fssh_%s\n", $3, $3)
     }' | unexpand -a | LC_ALL=C sort -u
 *
 * $FreeBSD: stable/10/crypto/openssh/ssh_namespace.h 323124 2017-09-01 22:52:18Z des $
 */

#define Blowfish_decipher			Fssh_Blowfish_decipher
#define Blowfish_encipher			Fssh_Blowfish_encipher
#define Blowfish_expand0state			Fssh_Blowfish_expand0state
#define Blowfish_expandstate			Fssh_Blowfish_expandstate
#define Blowfish_initstate			Fssh_Blowfish_initstate
#define Blowfish_stream2word			Fssh_Blowfish_stream2word
#define _ssh__compat_glob			Fssh__ssh__compat_glob
#define _ssh__compat_globfree			Fssh__ssh__compat_globfree
#define _ssh_compat_realpath			Fssh__ssh_compat_realpath
#define _ssh_exchange_banner			Fssh__ssh_exchange_banner
#define _ssh_host_key_sign			Fssh__ssh_host_key_sign
#define _ssh_host_private_key			Fssh__ssh_host_private_key
#define _ssh_host_public_key			Fssh__ssh_host_public_key
#define _ssh_order_hostkeyalgs			Fssh__ssh_order_hostkeyalgs
#define _ssh_read_banner			Fssh__ssh_read_banner
#define _ssh_send_banner			Fssh__ssh_send_banner
#define _ssh_verify_host_key			Fssh__ssh_verify_host_key
#define a2port					Fssh_a2port
#define a2tun					Fssh_a2tun
#define add_host_to_hostfile			Fssh_add_host_to_hostfile
#define add_p1p1				Fssh_add_p1p1
#define addargs					Fssh_addargs
#define addr_match_cidr_list			Fssh_addr_match_cidr_list
#define addr_match_list				Fssh_addr_match_list
#define addr_netmatch				Fssh_addr_netmatch
#define addr_pton				Fssh_addr_pton
#define addr_pton_cidr				Fssh_addr_pton_cidr
#define ask_permission				Fssh_ask_permission
#define atomicio				Fssh_atomicio
#define atomicio6				Fssh_atomicio6
#define atomiciov				Fssh_atomiciov
#define atomiciov6				Fssh_atomiciov6
#define auth_request_forwarding			Fssh_auth_request_forwarding
#define bandwidth_limit				Fssh_bandwidth_limit
#define bandwidth_limit_init			Fssh_bandwidth_limit_init
#define barrett_reduce				Fssh_barrett_reduce
#define bcrypt_hash				Fssh_bcrypt_hash
#define bcrypt_pbkdf				Fssh_bcrypt_pbkdf
#define bf_ssh1_cipher				Fssh_bf_ssh1_cipher
#define bitmap_clear_bit			Fssh_bitmap_clear_bit
#define bitmap_free				Fssh_bitmap_free
#define bitmap_from_string			Fssh_bitmap_from_string
#define bitmap_nbits				Fssh_bitmap_nbits
#define bitmap_nbytes				Fssh_bitmap_nbytes
#define bitmap_new				Fssh_bitmap_new
#define bitmap_set_bit				Fssh_bitmap_set_bit
#define bitmap_test_bit				Fssh_bitmap_test_bit
#define bitmap_to_string			Fssh_bitmap_to_string
#define bitmap_zero				Fssh_bitmap_zero
#define blf_cbc_decrypt				Fssh_blf_cbc_decrypt
#define blf_cbc_encrypt				Fssh_blf_cbc_encrypt
#define blf_dec					Fssh_blf_dec
#define blf_ecb_decrypt				Fssh_blf_ecb_decrypt
#define blf_ecb_encrypt				Fssh_blf_ecb_encrypt
#define blf_enc					Fssh_blf_enc
#define blf_key					Fssh_blf_key
#define buffer_append				Fssh_buffer_append
#define buffer_append_space			Fssh_buffer_append_space
#define buffer_check_alloc			Fssh_buffer_check_alloc
#define buffer_consume				Fssh_buffer_consume
#define buffer_consume_end			Fssh_buffer_consume_end
#define buffer_consume_end_ret			Fssh_buffer_consume_end_ret
#define buffer_consume_ret			Fssh_buffer_consume_ret
#define buffer_get				Fssh_buffer_get
#define buffer_get_bignum			Fssh_buffer_get_bignum
#define buffer_get_bignum2			Fssh_buffer_get_bignum2
#define buffer_get_bignum2_ret			Fssh_buffer_get_bignum2_ret
#define buffer_get_bignum_ret			Fssh_buffer_get_bignum_ret
#define buffer_get_char				Fssh_buffer_get_char
#define buffer_get_char_ret			Fssh_buffer_get_char_ret
#define buffer_get_cstring			Fssh_buffer_get_cstring
#define buffer_get_cstring_ret			Fssh_buffer_get_cstring_ret
#define buffer_get_ecpoint			Fssh_buffer_get_ecpoint
#define buffer_get_ecpoint_ret			Fssh_buffer_get_ecpoint_ret
#define buffer_get_int				Fssh_buffer_get_int
#define buffer_get_int64			Fssh_buffer_get_int64
#define buffer_get_int64_ret			Fssh_buffer_get_int64_ret
#define buffer_get_int_ret			Fssh_buffer_get_int_ret
#define buffer_get_ret				Fssh_buffer_get_ret
#define buffer_get_short			Fssh_buffer_get_short
#define buffer_get_short_ret			Fssh_buffer_get_short_ret
#define buffer_get_string			Fssh_buffer_get_string
#define buffer_get_string_ptr			Fssh_buffer_get_string_ptr
#define buffer_get_string_ptr_ret		Fssh_buffer_get_string_ptr_ret
#define buffer_get_string_ret			Fssh_buffer_get_string_ret
#define buffer_put_bignum			Fssh_buffer_put_bignum
#define buffer_put_bignum2			Fssh_buffer_put_bignum2
#define buffer_put_bignum2_from_string		Fssh_buffer_put_bignum2_from_string
#define buffer_put_bignum2_ret			Fssh_buffer_put_bignum2_ret
#define buffer_put_bignum_ret			Fssh_buffer_put_bignum_ret
#define buffer_put_char				Fssh_buffer_put_char
#define buffer_put_cstring			Fssh_buffer_put_cstring
#define buffer_put_ecpoint			Fssh_buffer_put_ecpoint
#define buffer_put_ecpoint_ret			Fssh_buffer_put_ecpoint_ret
#define buffer_put_int				Fssh_buffer_put_int
#define buffer_put_int64			Fssh_buffer_put_int64
#define buffer_put_short			Fssh_buffer_put_short
#define buffer_put_string			Fssh_buffer_put_string
#define cert_free				Fssh_cert_free
#define cert_new				Fssh_cert_new
#define chacha_encrypt_bytes			Fssh_chacha_encrypt_bytes
#define chacha_ivsetup				Fssh_chacha_ivsetup
#define chacha_keysetup				Fssh_chacha_keysetup
#define chachapoly_crypt			Fssh_chachapoly_crypt
#define chachapoly_get_length			Fssh_chachapoly_get_length
#define chachapoly_init				Fssh_chachapoly_init
#define chan_ibuf_empty				Fssh_chan_ibuf_empty
#define chan_is_dead				Fssh_chan_is_dead
#define chan_mark_dead				Fssh_chan_mark_dead
#define chan_obuf_empty				Fssh_chan_obuf_empty
#define chan_rcvd_eow				Fssh_chan_rcvd_eow
#define chan_rcvd_ieof				Fssh_chan_rcvd_ieof
#define chan_rcvd_oclose			Fssh_chan_rcvd_oclose
#define chan_read_failed			Fssh_chan_read_failed
#define chan_send_eof2				Fssh_chan_send_eof2
#define chan_send_ieof1				Fssh_chan_send_ieof1
#define chan_send_oclose1			Fssh_chan_send_oclose1
#define chan_shutdown_read			Fssh_chan_shutdown_read
#define chan_shutdown_write			Fssh_chan_shutdown_write
#define chan_write_failed			Fssh_chan_write_failed
#define channel_add_adm_permitted_opens		Fssh_channel_add_adm_permitted_opens
#define channel_add_permitted_opens		Fssh_channel_add_permitted_opens
#define channel_after_select			Fssh_channel_after_select
#define channel_by_id				Fssh_channel_by_id
#define channel_cancel_cleanup			Fssh_channel_cancel_cleanup
#define channel_cancel_lport_listener		Fssh_channel_cancel_lport_listener
#define channel_cancel_rport_listener		Fssh_channel_cancel_rport_listener
#define channel_clear_adm_permitted_opens	Fssh_channel_clear_adm_permitted_opens
#define channel_clear_permitted_opens		Fssh_channel_clear_permitted_opens
#define channel_close_all			Fssh_channel_close_all
#define channel_close_fd			Fssh_channel_close_fd
#define channel_close_fds			Fssh_channel_close_fds
#define channel_connect_by_listen_address	Fssh_channel_connect_by_listen_address
#define channel_connect_by_listen_path		Fssh_channel_connect_by_listen_path
#define channel_connect_stdio_fwd		Fssh_channel_connect_stdio_fwd
#define channel_connect_to_path			Fssh_channel_connect_to_path
#define channel_connect_to_port			Fssh_channel_connect_to_port
#define channel_disable_adm_local_opens		Fssh_channel_disable_adm_local_opens
#define channel_find_open			Fssh_channel_find_open
#define channel_free				Fssh_channel_free
#define channel_free_all			Fssh_channel_free_all
#define channel_fwd_bind_addr			Fssh_channel_fwd_bind_addr
#define channel_handler				Fssh_channel_handler
#define channel_input_close			Fssh_channel_input_close
#define channel_input_close_confirmation	Fssh_channel_input_close_confirmation
#define channel_input_data			Fssh_channel_input_data
#define channel_input_extended_data		Fssh_channel_input_extended_data
#define channel_input_ieof			Fssh_channel_input_ieof
#define channel_input_oclose			Fssh_channel_input_oclose
#define channel_input_open_confirmation		Fssh_channel_input_open_confirmation
#define channel_input_open_failure		Fssh_channel_input_open_failure
#define channel_input_port_forward_request	Fssh_channel_input_port_forward_request
#define channel_input_port_open			Fssh_channel_input_port_open
#define channel_input_status_confirm		Fssh_channel_input_status_confirm
#define channel_input_window_adjust		Fssh_channel_input_window_adjust
#define channel_lookup				Fssh_channel_lookup
#define channel_new				Fssh_channel_new
#define channel_not_very_much_buffered_data	Fssh_channel_not_very_much_buffered_data
#define channel_open_message			Fssh_channel_open_message
#define channel_output_poll			Fssh_channel_output_poll
#define channel_permit_all_opens		Fssh_channel_permit_all_opens
#define channel_post_auth_listener		Fssh_channel_post_auth_listener
#define channel_post_connecting			Fssh_channel_post_connecting
#define channel_post_mux_client			Fssh_channel_post_mux_client
#define channel_post_mux_listener		Fssh_channel_post_mux_listener
#define channel_post_open			Fssh_channel_post_open
#define channel_post_output_drain_13		Fssh_channel_post_output_drain_13
#define channel_post_port_listener		Fssh_channel_post_port_listener
#define channel_post_x11_listener		Fssh_channel_post_x11_listener
#define channel_pre_connecting			Fssh_channel_pre_connecting
#define channel_pre_dynamic			Fssh_channel_pre_dynamic
#define channel_pre_input_draining		Fssh_channel_pre_input_draining
#define channel_pre_listener			Fssh_channel_pre_listener
#define channel_pre_mux_client			Fssh_channel_pre_mux_client
#define channel_pre_open			Fssh_channel_pre_open
#define channel_pre_open_13			Fssh_channel_pre_open_13
#define channel_pre_output_draining		Fssh_channel_pre_output_draining
#define channel_pre_x11_open			Fssh_channel_pre_x11_open
#define channel_pre_x11_open_13			Fssh_channel_pre_x11_open_13
#define channel_prepare_select			Fssh_channel_prepare_select
#define channel_print_adm_permitted_opens	Fssh_channel_print_adm_permitted_opens
#define channel_register_cleanup		Fssh_channel_register_cleanup
#define channel_register_fds			Fssh_channel_register_fds
#define channel_register_filter			Fssh_channel_register_filter
#define channel_register_open_confirm		Fssh_channel_register_open_confirm
#define channel_register_status_confirm		Fssh_channel_register_status_confirm
#define channel_request_remote_forwarding	Fssh_channel_request_remote_forwarding
#define channel_request_rforward_cancel		Fssh_channel_request_rforward_cancel
#define channel_request_start			Fssh_channel_request_start
#define channel_send_open			Fssh_channel_send_open
#define channel_send_window_changes		Fssh_channel_send_window_changes
#define channel_set_af				Fssh_channel_set_af
#define channel_set_fds				Fssh_channel_set_fds
#define channel_set_x11_refuse_time		Fssh_channel_set_x11_refuse_time
#define channel_setup_fwd_listener_streamlocal	Fssh_channel_setup_fwd_listener_streamlocal
#define channel_setup_fwd_listener_tcpip	Fssh_channel_setup_fwd_listener_tcpip
#define channel_setup_local_fwd_listener	Fssh_channel_setup_local_fwd_listener
#define channel_setup_remote_fwd_listener	Fssh_channel_setup_remote_fwd_listener
#define channel_still_open			Fssh_channel_still_open
#define channel_stop_listening			Fssh_channel_stop_listening
#define channel_update_permitted_opens		Fssh_channel_update_permitted_opens
#define check_crc				Fssh_check_crc
#define check_hostkeys_by_key_or_type		Fssh_check_hostkeys_by_key_or_type
#define check_key_in_hostkeys			Fssh_check_key_in_hostkeys
#define choose_dh				Fssh_choose_dh
#define choose_t				Fssh_choose_t
#define chop					Fssh_chop
#define cipher_alg_list				Fssh_cipher_alg_list
#define cipher_authlen				Fssh_cipher_authlen
#define cipher_blocksize			Fssh_cipher_blocksize
#define cipher_by_name				Fssh_cipher_by_name
#define cipher_by_number			Fssh_cipher_by_number
#define cipher_cleanup				Fssh_cipher_cleanup
#define cipher_crypt				Fssh_cipher_crypt
#define cipher_get_keycontext			Fssh_cipher_get_keycontext
#define cipher_get_keyiv			Fssh_cipher_get_keyiv
#define cipher_get_keyiv_len			Fssh_cipher_get_keyiv_len
#define cipher_get_length			Fssh_cipher_get_length
#define cipher_get_number			Fssh_cipher_get_number
#define cipher_init				Fssh_cipher_init
#define cipher_is_cbc				Fssh_cipher_is_cbc
#define cipher_ivlen				Fssh_cipher_ivlen
#define cipher_keylen				Fssh_cipher_keylen
#define cipher_mask_ssh1			Fssh_cipher_mask_ssh1
#define cipher_name				Fssh_cipher_name
#define cipher_number				Fssh_cipher_number
#define cipher_seclen				Fssh_cipher_seclen
#define cipher_set_key_string			Fssh_cipher_set_key_string
#define cipher_set_keycontext			Fssh_cipher_set_keycontext
#define cipher_set_keyiv			Fssh_cipher_set_keyiv
#define cipher_warning_message			Fssh_cipher_warning_message
#define ciphers_valid				Fssh_ciphers_valid
#define cleanhostname				Fssh_cleanhostname
#define cleanup_exit				Fssh_cleanup_exit
#define colon					Fssh_colon
#define compare					Fssh_compare
#define compare_gps				Fssh_compare_gps
#define compat_cipher_proposal			Fssh_compat_cipher_proposal
#define compat_datafellows			Fssh_compat_datafellows
#define compat_kex_proposal			Fssh_compat_kex_proposal
#define compat_pkalg_proposal			Fssh_compat_pkalg_proposal
#define compress_buffer				Fssh_compress_buffer
#define connect_next				Fssh_connect_next
#define connect_to				Fssh_connect_to
#define convtime				Fssh_convtime
#define crypto_hash_sha512			Fssh_crypto_hash_sha512
#define crypto_hashblocks_sha512		Fssh_crypto_hashblocks_sha512
#define crypto_scalarmult_curve25519		Fssh_crypto_scalarmult_curve25519
#define crypto_sign_ed25519			Fssh_crypto_sign_ed25519
#define crypto_sign_ed25519_keypair		Fssh_crypto_sign_ed25519_keypair
#define crypto_sign_ed25519_open		Fssh_crypto_sign_ed25519_open
#define crypto_sign_ed25519_ref_double_scalarmult_vartime Fssh_crypto_sign_ed25519_ref_double_scalarmult_vartime
#define crypto_sign_ed25519_ref_fe25519_add	Fssh_crypto_sign_ed25519_ref_fe25519_add
#define crypto_sign_ed25519_ref_fe25519_cmov	Fssh_crypto_sign_ed25519_ref_fe25519_cmov
#define crypto_sign_ed25519_ref_fe25519_freeze	Fssh_crypto_sign_ed25519_ref_fe25519_freeze
#define crypto_sign_ed25519_ref_fe25519_getparity Fssh_crypto_sign_ed25519_ref_fe25519_getparity
#define crypto_sign_ed25519_ref_fe25519_invert	Fssh_crypto_sign_ed25519_ref_fe25519_invert
#define crypto_sign_ed25519_ref_fe25519_iseq_vartime Fssh_crypto_sign_ed25519_ref_fe25519_iseq_vartime
#define crypto_sign_ed25519_ref_fe25519_iszero	Fssh_crypto_sign_ed25519_ref_fe25519_iszero
#define crypto_sign_ed25519_ref_fe25519_mul	Fssh_crypto_sign_ed25519_ref_fe25519_mul
#define crypto_sign_ed25519_ref_fe25519_neg	Fssh_crypto_sign_ed25519_ref_fe25519_neg
#define crypto_sign_ed25519_ref_fe25519_pack	Fssh_crypto_sign_ed25519_ref_fe25519_pack
#define crypto_sign_ed25519_ref_fe25519_pow2523 Fssh_crypto_sign_ed25519_ref_fe25519_pow2523
#define crypto_sign_ed25519_ref_fe25519_setone	Fssh_crypto_sign_ed25519_ref_fe25519_setone
#define crypto_sign_ed25519_ref_fe25519_setzero Fssh_crypto_sign_ed25519_ref_fe25519_setzero
#define crypto_sign_ed25519_ref_fe25519_square	Fssh_crypto_sign_ed25519_ref_fe25519_square
#define crypto_sign_ed25519_ref_fe25519_sub	Fssh_crypto_sign_ed25519_ref_fe25519_sub
#define crypto_sign_ed25519_ref_fe25519_unpack	Fssh_crypto_sign_ed25519_ref_fe25519_unpack
#define crypto_sign_ed25519_ref_isneutral_vartime Fssh_crypto_sign_ed25519_ref_isneutral_vartime
#define crypto_sign_ed25519_ref_pack		Fssh_crypto_sign_ed25519_ref_pack
#define crypto_sign_ed25519_ref_sc25519_2interleave2 Fssh_crypto_sign_ed25519_ref_sc25519_2interleave2
#define crypto_sign_ed25519_ref_sc25519_add	Fssh_crypto_sign_ed25519_ref_sc25519_add
#define crypto_sign_ed25519_ref_sc25519_from32bytes Fssh_crypto_sign_ed25519_ref_sc25519_from32bytes
#define crypto_sign_ed25519_ref_sc25519_from64bytes Fssh_crypto_sign_ed25519_ref_sc25519_from64bytes
#define crypto_sign_ed25519_ref_sc25519_from_shortsc Fssh_crypto_sign_ed25519_ref_sc25519_from_shortsc
#define crypto_sign_ed25519_ref_sc25519_isshort_vartime Fssh_crypto_sign_ed25519_ref_sc25519_isshort_vartime
#define crypto_sign_ed25519_ref_sc25519_iszero_vartime Fssh_crypto_sign_ed25519_ref_sc25519_iszero_vartime
#define crypto_sign_ed25519_ref_sc25519_lt_vartime Fssh_crypto_sign_ed25519_ref_sc25519_lt_vartime
#define crypto_sign_ed25519_ref_sc25519_mul	Fssh_crypto_sign_ed25519_ref_sc25519_mul
#define crypto_sign_ed25519_ref_sc25519_mul_shortsc Fssh_crypto_sign_ed25519_ref_sc25519_mul_shortsc
#define crypto_sign_ed25519_ref_sc25519_sub_nored Fssh_crypto_sign_ed25519_ref_sc25519_sub_nored
#define crypto_sign_ed25519_ref_sc25519_to32bytes Fssh_crypto_sign_ed25519_ref_sc25519_to32bytes
#define crypto_sign_ed25519_ref_sc25519_window3 Fssh_crypto_sign_ed25519_ref_sc25519_window3
#define crypto_sign_ed25519_ref_sc25519_window5 Fssh_crypto_sign_ed25519_ref_sc25519_window5
#define crypto_sign_ed25519_ref_scalarmult_base Fssh_crypto_sign_ed25519_ref_scalarmult_base
#define crypto_sign_ed25519_ref_shortsc25519_from16bytes Fssh_crypto_sign_ed25519_ref_shortsc25519_from16bytes
#define crypto_sign_ed25519_ref_unpackneg_vartime Fssh_crypto_sign_ed25519_ref_unpackneg_vartime
#define crypto_verify_32			Fssh_crypto_verify_32
#define dbl_p1p1				Fssh_dbl_p1p1
#define deattack_init				Fssh_deattack_init
#define debug					Fssh_debug
#define debug2					Fssh_debug2
#define debug3					Fssh_debug3
#define deny_input_open				Fssh_deny_input_open
#define derive_ssh1_session_id			Fssh_derive_ssh1_session_id
#define detect_attack				Fssh_detect_attack
#define dh_estimate				Fssh_dh_estimate
#define dh_gen_key				Fssh_dh_gen_key
#define dh_new_group				Fssh_dh_new_group
#define dh_new_group1				Fssh_dh_new_group1
#define dh_new_group14				Fssh_dh_new_group14
#define dh_new_group16				Fssh_dh_new_group16
#define dh_new_group18				Fssh_dh_new_group18
#define dh_new_group_asc			Fssh_dh_new_group_asc
#define dh_new_group_fallback			Fssh_dh_new_group_fallback
#define dh_pub_is_valid				Fssh_dh_pub_is_valid
#define dispatch_protocol_error			Fssh_dispatch_protocol_error
#define dispatch_protocol_ignore		Fssh_dispatch_protocol_ignore
#define dns_read_key				Fssh_dns_read_key
#define do_log					Fssh_do_log
#define do_log2					Fssh_do_log2
#define dump_base64				Fssh_dump_base64
#define enable_compat13				Fssh_enable_compat13
#define enable_compat20				Fssh_enable_compat20
#define error					Fssh_error
#define evp_ssh1_3des				Fssh_evp_ssh1_3des
#define evp_ssh1_bf				Fssh_evp_ssh1_bf
#define explicit_bzero				Fssh_explicit_bzero
#define export_dns_rr				Fssh_export_dns_rr
#define fatal					Fssh_fatal
#define filter_proposal				Fssh_filter_proposal
#define fingerprint_b64				Fssh_fingerprint_b64
#define fingerprint_hex				Fssh_fingerprint_hex
#define fmt_scaled				Fssh_fmt_scaled
#define forward_equals				Fssh_forward_equals
#define free_hostkeys				Fssh_free_hostkeys
#define freeargs				Fssh_freeargs
#define freerrset				Fssh_freerrset
#define gen_candidates				Fssh_gen_candidates
#define get_local_ipaddr			Fssh_get_local_ipaddr
#define get_local_name				Fssh_get_local_name
#define get_local_port				Fssh_get_local_port
#define get_peer_ipaddr				Fssh_get_peer_ipaddr
#define get_peer_port				Fssh_get_peer_port
#define get_sock_port				Fssh_get_sock_port
#define get_socket_address			Fssh_get_socket_address
#define get_u16					Fssh_get_u16
#define get_u32					Fssh_get_u32
#define get_u32_le				Fssh_get_u32_le
#define get_u64					Fssh_get_u64
#define getrrsetbyname				Fssh_getrrsetbyname
#define glob0					Fssh_glob0
#define glob2					Fssh_glob2
#define globexp1				Fssh_globexp1
#define globextend				Fssh_globextend
#define host_delete				Fssh_host_delete
#define host_hash				Fssh_host_hash
#define hostfile_read_key			Fssh_hostfile_read_key
#define hostfile_replace_entries		Fssh_hostfile_replace_entries
#define hostkeys_foreach			Fssh_hostkeys_foreach
#define hpdelim					Fssh_hpdelim
#define init_hostkeys				Fssh_init_hostkeys
#define input_kex_c25519_init			Fssh_input_kex_c25519_init
#define input_kex_c25519_reply			Fssh_input_kex_c25519_reply
#define input_kex_dh				Fssh_input_kex_dh
#define input_kex_dh_gex_group			Fssh_input_kex_dh_gex_group
#define input_kex_dh_gex_init			Fssh_input_kex_dh_gex_init
#define input_kex_dh_gex_reply			Fssh_input_kex_dh_gex_reply
#define input_kex_dh_gex_request		Fssh_input_kex_dh_gex_request
#define input_kex_dh_init			Fssh_input_kex_dh_init
#define input_kex_ecdh_init			Fssh_input_kex_ecdh_init
#define input_kex_ecdh_reply			Fssh_input_kex_ecdh_reply
#define iptos2str				Fssh_iptos2str
#define ipv64_normalise_mapped			Fssh_ipv64_normalise_mapped
#define is_key_revoked				Fssh_is_key_revoked
#define kex_alg_list				Fssh_kex_alg_list
#define kex_assemble_names			Fssh_kex_assemble_names
#define kex_buf2prop				Fssh_kex_buf2prop
#define kex_c25519_hash				Fssh_kex_c25519_hash
#define kex_derive_keys				Fssh_kex_derive_keys
#define kex_derive_keys_bn			Fssh_kex_derive_keys_bn
#define kex_dh_hash				Fssh_kex_dh_hash
#define kex_ecdh_hash				Fssh_kex_ecdh_hash
#define kex_free				Fssh_kex_free
#define kex_free_newkeys			Fssh_kex_free_newkeys
#define kex_input_ext_info			Fssh_kex_input_ext_info
#define kex_input_kexinit			Fssh_kex_input_kexinit
#define kex_input_newkeys			Fssh_kex_input_newkeys
#define kex_names_cat				Fssh_kex_names_cat
#define kex_names_valid				Fssh_kex_names_valid
#define kex_new					Fssh_kex_new
#define kex_prop2buf				Fssh_kex_prop2buf
#define kex_prop_free				Fssh_kex_prop_free
#define kex_protocol_error			Fssh_kex_protocol_error
#define kex_send_kexinit			Fssh_kex_send_kexinit
#define kex_send_newkeys			Fssh_kex_send_newkeys
#define kex_setup				Fssh_kex_setup
#define kex_start_rekex				Fssh_kex_start_rekex
#define kexc25519_client			Fssh_kexc25519_client
#define kexc25519_keygen			Fssh_kexc25519_keygen
#define kexc25519_server			Fssh_kexc25519_server
#define kexc25519_shared_key			Fssh_kexc25519_shared_key
#define kexdh_client				Fssh_kexdh_client
#define kexdh_server				Fssh_kexdh_server
#define kexecdh_client				Fssh_kexecdh_client
#define kexecdh_server				Fssh_kexecdh_server
#define kexgex_client				Fssh_kexgex_client
#define kexgex_hash				Fssh_kexgex_hash
#define kexgex_server				Fssh_kexgex_server
#define key_add_private				Fssh_key_add_private
#define key_alg_list				Fssh_key_alg_list
#define key_cert_check_authority		Fssh_key_cert_check_authority
#define key_cert_copy				Fssh_key_cert_copy
#define key_certify				Fssh_key_certify
#define key_demote				Fssh_key_demote
#define key_drop_cert				Fssh_key_drop_cert
#define key_ec_validate_private			Fssh_key_ec_validate_private
#define key_ec_validate_public			Fssh_key_ec_validate_public
#define key_from_blob				Fssh_key_from_blob
#define key_from_private			Fssh_key_from_private
#define key_generate				Fssh_key_generate
#define key_load_cert				Fssh_key_load_cert
#define key_load_file				Fssh_key_load_file
#define key_load_private			Fssh_key_load_private
#define key_load_private_cert			Fssh_key_load_private_cert
#define key_load_private_type			Fssh_key_load_private_type
#define key_load_public				Fssh_key_load_public
#define key_new_private				Fssh_key_new_private
#define key_perm_ok				Fssh_key_perm_ok
#define key_private_deserialize			Fssh_key_private_deserialize
#define key_private_serialize			Fssh_key_private_serialize
#define key_read				Fssh_key_read
#define key_save_private			Fssh_key_save_private
#define key_sign				Fssh_key_sign
#define key_to_blob				Fssh_key_to_blob
#define key_to_certified			Fssh_key_to_certified
#define key_verify				Fssh_key_verify
#define key_write				Fssh_key_write
#define load_hostkeys				Fssh_load_hostkeys
#define log_change_level			Fssh_log_change_level
#define log_facility_name			Fssh_log_facility_name
#define log_facility_number			Fssh_log_facility_number
#define log_init				Fssh_log_init
#define log_is_on_stderr			Fssh_log_is_on_stderr
#define log_level_name				Fssh_log_level_name
#define log_level_number			Fssh_log_level_number
#define log_redirect_stderr_to			Fssh_log_redirect_stderr_to
#define logdie					Fssh_logdie
#define logit					Fssh_logit
#define lookup_key_in_hostkeys_by_type		Fssh_lookup_key_in_hostkeys_by_type
#define lowercase				Fssh_lowercase
#define mac_alg_list				Fssh_mac_alg_list
#define mac_check				Fssh_mac_check
#define mac_clear				Fssh_mac_clear
#define mac_compute				Fssh_mac_compute
#define mac_init				Fssh_mac_init
#define mac_setup				Fssh_mac_setup
#define mac_valid				Fssh_mac_valid
#define match					Fssh_match
#define match_host_and_ip			Fssh_match_host_and_ip
#define match_hostname				Fssh_match_hostname
#define match_list				Fssh_match_list
#define match_maybe_hashed			Fssh_match_maybe_hashed
#define match_pattern				Fssh_match_pattern
#define match_pattern_list			Fssh_match_pattern_list
#define match_user				Fssh_match_user
#define mktemp_proto				Fssh_mktemp_proto
#define mm_choose_dh				Fssh_mm_choose_dh
#define mm_receive_fd				Fssh_mm_receive_fd
#define mm_send_fd				Fssh_mm_send_fd
#define mm_sshkey_sign				Fssh_mm_sshkey_sign
#define monotime				Fssh_monotime
#define monotime_double				Fssh_monotime_double
#define ms_subtract_diff			Fssh_ms_subtract_diff
#define ms_to_timeval				Fssh_ms_to_timeval
#define mult					Fssh_mult
#define mysignal				Fssh_mysignal
#define newkeys_from_blob			Fssh_newkeys_from_blob
#define newkeys_to_blob				Fssh_newkeys_to_blob
#define nh_aux					Fssh_nh_aux
#define nh_final				Fssh_nh_final
#define nh_update				Fssh_nh_update
#define packet_close				Fssh_packet_close
#define packet_disconnect			Fssh_packet_disconnect
#define packet_get_char				Fssh_packet_get_char
#define packet_get_int				Fssh_packet_get_int
#define packet_process_incoming			Fssh_packet_process_incoming
#define packet_read_expect			Fssh_packet_read_expect
#define packet_read_poll_seqnr			Fssh_packet_read_poll_seqnr
#define packet_read_seqnr			Fssh_packet_read_seqnr
#define packet_send_debug			Fssh_packet_send_debug
#define packet_set_connection			Fssh_packet_set_connection
#define packet_write_poll			Fssh_packet_write_poll
#define packet_write_wait			Fssh_packet_write_wait
#define parse_ipqos				Fssh_parse_ipqos
#define parse_prime				Fssh_parse_prime
#define parse_user_host_port			Fssh_parse_user_host_port
#define percent_expand				Fssh_percent_expand
#define permanently_drop_suid			Fssh_permanently_drop_suid
#define permanently_set_uid			Fssh_permanently_set_uid
#define permitopen_port				Fssh_permitopen_port
#define pkcs11_add_provider			Fssh_pkcs11_add_provider
#define pkcs11_del_provider			Fssh_pkcs11_del_provider
#define pkcs11_fetch_keys_filter		Fssh_pkcs11_fetch_keys_filter
#define pkcs11_find				Fssh_pkcs11_find
#define pkcs11_init				Fssh_pkcs11_init
#define pkcs11_provider_finalize		Fssh_pkcs11_provider_finalize
#define pkcs11_provider_unref			Fssh_pkcs11_provider_unref
#define pkcs11_rsa_finish			Fssh_pkcs11_rsa_finish
#define pkcs11_rsa_private_decrypt		Fssh_pkcs11_rsa_private_decrypt
#define pkcs11_rsa_private_encrypt		Fssh_pkcs11_rsa_private_encrypt
#define pkcs11_terminate			Fssh_pkcs11_terminate
#define plain_key_blob				Fssh_plain_key_blob
#define platform_pledge_agent			Fssh_platform_pledge_agent
#define platform_pledge_mux			Fssh_platform_pledge_mux
#define platform_pledge_sftp_server		Fssh_platform_pledge_sftp_server
#define pledge					Fssh_pledge
#define poly1305_auth				Fssh_poly1305_auth
#define poly64					Fssh_poly64
#define poly_hash				Fssh_poly_hash
#define port_open_helper			Fssh_port_open_helper
#define prime_test				Fssh_prime_test
#define proto_spec				Fssh_proto_spec
#define put_bitmap				Fssh_put_bitmap
#define put_host_port				Fssh_put_host_port
#define put_u16					Fssh_put_u16
#define put_u32					Fssh_put_u32
#define put_u32_le				Fssh_put_u32_le
#define put_u64					Fssh_put_u64
#define pwcopy					Fssh_pwcopy
#define qfileout				Fssh_qfileout
#define read_keyfile_line			Fssh_read_keyfile_line
#define read_mux				Fssh_read_mux
#define read_passphrase				Fssh_read_passphrase
#define reallocarray				Fssh_reallocarray
#define record_hostkey				Fssh_record_hostkey
#define reduce_add_sub				Fssh_reduce_add_sub
#define refresh_progress_meter			Fssh_refresh_progress_meter
#define replacearg				Fssh_replacearg
#define restore_uid				Fssh_restore_uid
#define revoke_blob				Fssh_revoke_blob
#define revoked_blob_tree_RB_REMOVE		Fssh_revoked_blob_tree_RB_REMOVE
#define revoked_certs_for_ca_key		Fssh_revoked_certs_for_ca_key
#define revoked_serial_tree_RB_REMOVE		Fssh_revoked_serial_tree_RB_REMOVE
#define rijndaelEncrypt				Fssh_rijndaelEncrypt
#define rijndaelKeySetupEnc			Fssh_rijndaelKeySetupEnc
#define rsa_generate_additional_parameters	Fssh_rsa_generate_additional_parameters
#define rsa_private_decrypt			Fssh_rsa_private_decrypt
#define rsa_public_encrypt			Fssh_rsa_public_encrypt
#define sanitise_stdfd				Fssh_sanitise_stdfd
#define scan_scaled				Fssh_scan_scaled
#define seed_rng				Fssh_seed_rng
#define set_log_handler				Fssh_set_log_handler
#define set_nodelay				Fssh_set_nodelay
#define set_nonblock				Fssh_set_nonblock
#define shadow_pw				Fssh_shadow_pw
#define sieve_large				Fssh_sieve_large
#define sig_winch				Fssh_sig_winch
#define sigdie					Fssh_sigdie
#define sock_set_v6only				Fssh_sock_set_v6only
#define square					Fssh_square
#define ssh1_3des_cbc				Fssh_ssh1_3des_cbc
#define ssh1_3des_cleanup			Fssh_ssh1_3des_cleanup
#define ssh1_3des_init				Fssh_ssh1_3des_init
#define ssh1_3des_iv				Fssh_ssh1_3des_iv
#define ssh_OpenSSL_add_all_algorithms		Fssh_ssh_OpenSSL_add_all_algorithms
#define ssh_add_hostkey				Fssh_ssh_add_hostkey
#define ssh_add_identity_constrained		Fssh_ssh_add_identity_constrained
#define ssh_agent_sign				Fssh_ssh_agent_sign
#define ssh_alloc_session_state			Fssh_ssh_alloc_session_state
#define ssh_close_authentication_socket		Fssh_ssh_close_authentication_socket
#define ssh_compatible_openssl			Fssh_ssh_compatible_openssl
#define ssh_crc32				Fssh_ssh_crc32
#define ssh_decrypt_challenge			Fssh_ssh_decrypt_challenge
#define ssh_digest_alg_by_name			Fssh_ssh_digest_alg_by_name
#define ssh_digest_alg_name			Fssh_ssh_digest_alg_name
#define ssh_digest_blocksize			Fssh_ssh_digest_blocksize
#define ssh_digest_buffer			Fssh_ssh_digest_buffer
#define ssh_digest_bytes			Fssh_ssh_digest_bytes
#define ssh_digest_copy_state			Fssh_ssh_digest_copy_state
#define ssh_digest_final			Fssh_ssh_digest_final
#define ssh_digest_free				Fssh_ssh_digest_free
#define ssh_digest_memory			Fssh_ssh_digest_memory
#define ssh_digest_start			Fssh_ssh_digest_start
#define ssh_digest_update			Fssh_ssh_digest_update
#define ssh_digest_update_buffer		Fssh_ssh_digest_update_buffer
#define ssh_dispatch_init			Fssh_ssh_dispatch_init
#define ssh_dispatch_range			Fssh_ssh_dispatch_range
#define ssh_dispatch_run			Fssh_ssh_dispatch_run
#define ssh_dispatch_run_fatal			Fssh_ssh_dispatch_run_fatal
#define ssh_dispatch_set			Fssh_ssh_dispatch_set
#define ssh_dss_sign				Fssh_ssh_dss_sign
#define ssh_dss_verify				Fssh_ssh_dss_verify
#define ssh_ecdsa_sign				Fssh_ssh_ecdsa_sign
#define ssh_ecdsa_verify			Fssh_ssh_ecdsa_verify
#define ssh_ed25519_sign			Fssh_ssh_ed25519_sign
#define ssh_ed25519_verify			Fssh_ssh_ed25519_verify
#define ssh_err					Fssh_ssh_err
#define ssh_fetch_identitylist			Fssh_ssh_fetch_identitylist
#define ssh_free				Fssh_ssh_free
#define ssh_free_identitylist			Fssh_ssh_free_identitylist
#define ssh_gai_strerror			Fssh_ssh_gai_strerror
#define ssh_get_app_data			Fssh_ssh_get_app_data
#define ssh_get_authentication_socket		Fssh_ssh_get_authentication_socket
#define ssh_get_progname			Fssh_ssh_get_progname
#define ssh_hmac_bytes				Fssh_ssh_hmac_bytes
#define ssh_hmac_final				Fssh_ssh_hmac_final
#define ssh_hmac_free				Fssh_ssh_hmac_free
#define ssh_hmac_init				Fssh_ssh_hmac_init
#define ssh_hmac_start				Fssh_ssh_hmac_start
#define ssh_hmac_update				Fssh_ssh_hmac_update
#define ssh_hmac_update_buffer			Fssh_ssh_hmac_update_buffer
#define ssh_init				Fssh_ssh_init
#define ssh_input_append			Fssh_ssh_input_append
#define ssh_input_space				Fssh_ssh_input_space
#define ssh_krl_check_key			Fssh_ssh_krl_check_key
#define ssh_krl_file_contains_key		Fssh_ssh_krl_file_contains_key
#define ssh_krl_free				Fssh_ssh_krl_free
#define ssh_krl_from_blob			Fssh_ssh_krl_from_blob
#define ssh_krl_init				Fssh_ssh_krl_init
#define ssh_krl_revoke_cert_by_key_id		Fssh_ssh_krl_revoke_cert_by_key_id
#define ssh_krl_revoke_cert_by_serial		Fssh_ssh_krl_revoke_cert_by_serial
#define ssh_krl_revoke_cert_by_serial_range	Fssh_ssh_krl_revoke_cert_by_serial_range
#define ssh_krl_revoke_key			Fssh_ssh_krl_revoke_key
#define ssh_krl_revoke_key_explicit		Fssh_ssh_krl_revoke_key_explicit
#define ssh_krl_revoke_key_sha1			Fssh_ssh_krl_revoke_key_sha1
#define ssh_krl_set_comment			Fssh_ssh_krl_set_comment
#define ssh_krl_set_version			Fssh_ssh_krl_set_version
#define ssh_krl_to_blob				Fssh_ssh_krl_to_blob
#define ssh_local_ipaddr			Fssh_ssh_local_ipaddr
#define ssh_local_port				Fssh_ssh_local_port
#define ssh_lock_agent				Fssh_ssh_lock_agent
#define ssh_malloc_init				Fssh_ssh_malloc_init
#define ssh_msg_recv				Fssh_ssh_msg_recv
#define ssh_msg_send				Fssh_ssh_msg_send
#define ssh_output_consume			Fssh_ssh_output_consume
#define ssh_output_ptr				Fssh_ssh_output_ptr
#define ssh_output_space			Fssh_ssh_output_space
#define ssh_packet_close			Fssh_ssh_packet_close
#define ssh_packet_connection_af		Fssh_ssh_packet_connection_af
#define ssh_packet_connection_is_on_socket	Fssh_ssh_packet_connection_is_on_socket
#define ssh_packet_disconnect			Fssh_ssh_packet_disconnect
#define ssh_packet_enable_delayed_compress	Fssh_ssh_packet_enable_delayed_compress
#define ssh_packet_get_bignum			Fssh_ssh_packet_get_bignum
#define ssh_packet_get_bignum2			Fssh_ssh_packet_get_bignum2
#define ssh_packet_get_bytes			Fssh_ssh_packet_get_bytes
#define ssh_packet_get_char			Fssh_ssh_packet_get_char
#define ssh_packet_get_connection_in		Fssh_ssh_packet_get_connection_in
#define ssh_packet_get_connection_out		Fssh_ssh_packet_get_connection_out
#define ssh_packet_get_cstring			Fssh_ssh_packet_get_cstring
#define ssh_packet_get_ecpoint			Fssh_ssh_packet_get_ecpoint
#define ssh_packet_get_input			Fssh_ssh_packet_get_input
#define ssh_packet_get_int			Fssh_ssh_packet_get_int
#define ssh_packet_get_int64			Fssh_ssh_packet_get_int64
#define ssh_packet_get_maxsize			Fssh_ssh_packet_get_maxsize
#define ssh_packet_get_output			Fssh_ssh_packet_get_output
#define ssh_packet_get_protocol_flags		Fssh_ssh_packet_get_protocol_flags
#define ssh_packet_get_rekey_timeout		Fssh_ssh_packet_get_rekey_timeout
#define ssh_packet_get_state			Fssh_ssh_packet_get_state
#define ssh_packet_get_string			Fssh_ssh_packet_get_string
#define ssh_packet_get_string_ptr		Fssh_ssh_packet_get_string_ptr
#define ssh_packet_have_data_to_write		Fssh_ssh_packet_have_data_to_write
#define ssh_packet_inc_alive_timeouts		Fssh_ssh_packet_inc_alive_timeouts
#define ssh_packet_is_interactive		Fssh_ssh_packet_is_interactive
#define ssh_packet_is_rekeying			Fssh_ssh_packet_is_rekeying
#define ssh_packet_need_rekeying		Fssh_ssh_packet_need_rekeying
#define ssh_packet_next				Fssh_ssh_packet_next
#define ssh_packet_not_very_much_data_to_write	Fssh_ssh_packet_not_very_much_data_to_write
#define ssh_packet_payload			Fssh_ssh_packet_payload
#define ssh_packet_process_incoming		Fssh_ssh_packet_process_incoming
#define ssh_packet_put				Fssh_ssh_packet_put
#define ssh_packet_put_bignum			Fssh_ssh_packet_put_bignum
#define ssh_packet_put_bignum2			Fssh_ssh_packet_put_bignum2
#define ssh_packet_put_char			Fssh_ssh_packet_put_char
#define ssh_packet_put_cstring			Fssh_ssh_packet_put_cstring
#define ssh_packet_put_ecpoint			Fssh_ssh_packet_put_ecpoint
#define ssh_packet_put_int			Fssh_ssh_packet_put_int
#define ssh_packet_put_int64			Fssh_ssh_packet_put_int64
#define ssh_packet_put_raw			Fssh_ssh_packet_put_raw
#define ssh_packet_put_string			Fssh_ssh_packet_put_string
#define ssh_packet_read				Fssh_ssh_packet_read
#define ssh_packet_read_expect			Fssh_ssh_packet_read_expect
#define ssh_packet_read_poll1			Fssh_ssh_packet_read_poll1
#define ssh_packet_read_poll2			Fssh_ssh_packet_read_poll2
#define ssh_packet_read_poll_seqnr		Fssh_ssh_packet_read_poll_seqnr
#define ssh_packet_read_seqnr			Fssh_ssh_packet_read_seqnr
#define ssh_packet_remaining			Fssh_ssh_packet_remaining
#define ssh_packet_send				Fssh_ssh_packet_send
#define ssh_packet_send1			Fssh_ssh_packet_send1
#define ssh_packet_send2			Fssh_ssh_packet_send2
#define ssh_packet_send2_wrapped		Fssh_ssh_packet_send2_wrapped
#define ssh_packet_send_debug			Fssh_ssh_packet_send_debug
#define ssh_packet_send_ignore			Fssh_ssh_packet_send_ignore
#define ssh_packet_set_alive_timeouts		Fssh_ssh_packet_set_alive_timeouts
#define ssh_packet_set_authenticated		Fssh_ssh_packet_set_authenticated
#define ssh_packet_set_compress_hooks		Fssh_ssh_packet_set_compress_hooks
#define ssh_packet_set_connection		Fssh_ssh_packet_set_connection
#define ssh_packet_set_encryption_key		Fssh_ssh_packet_set_encryption_key
#define ssh_packet_set_interactive		Fssh_ssh_packet_set_interactive
#define ssh_packet_set_maxsize			Fssh_ssh_packet_set_maxsize
#define ssh_packet_set_nonblocking		Fssh_ssh_packet_set_nonblocking
#define ssh_packet_set_protocol_flags		Fssh_ssh_packet_set_protocol_flags
#define ssh_packet_set_rekey_limits		Fssh_ssh_packet_set_rekey_limits
#define ssh_packet_set_server			Fssh_ssh_packet_set_server
#define ssh_packet_set_state			Fssh_ssh_packet_set_state
#define ssh_packet_set_timeout			Fssh_ssh_packet_set_timeout
#define ssh_packet_set_tos			Fssh_ssh_packet_set_tos
#define ssh_packet_start			Fssh_ssh_packet_start
#define ssh_packet_start_compression		Fssh_ssh_packet_start_compression
#define ssh_packet_start_discard		Fssh_ssh_packet_start_discard
#define ssh_packet_stop_discard			Fssh_ssh_packet_stop_discard
#define ssh_packet_write_poll			Fssh_ssh_packet_write_poll
#define ssh_packet_write_wait			Fssh_ssh_packet_write_wait
#define ssh_remote_ipaddr			Fssh_ssh_remote_ipaddr
#define ssh_remote_port				Fssh_ssh_remote_port
#define ssh_remove_all_identities		Fssh_ssh_remove_all_identities
#define ssh_remove_identity			Fssh_ssh_remove_identity
#define ssh_request_reply			Fssh_ssh_request_reply
#define ssh_rsa_sign				Fssh_ssh_rsa_sign
#define ssh_rsa_verify				Fssh_ssh_rsa_verify
#define ssh_set_app_data			Fssh_ssh_set_app_data
#define ssh_set_newkeys				Fssh_ssh_set_newkeys
#define ssh_set_verify_host_key_callback	Fssh_ssh_set_verify_host_key_callback
#define ssh_update_card				Fssh_ssh_update_card
#define sshbuf_alloc				Fssh_sshbuf_alloc
#define sshbuf_avail				Fssh_sshbuf_avail
#define sshbuf_b64tod				Fssh_sshbuf_b64tod
#define sshbuf_check_reserve			Fssh_sshbuf_check_reserve
#define sshbuf_consume				Fssh_sshbuf_consume
#define sshbuf_consume_end			Fssh_sshbuf_consume_end
#define sshbuf_dtob16				Fssh_sshbuf_dtob16
#define sshbuf_dtob64				Fssh_sshbuf_dtob64
#define sshbuf_dump				Fssh_sshbuf_dump
#define sshbuf_dump_data			Fssh_sshbuf_dump_data
#define sshbuf_dup_string			Fssh_sshbuf_dup_string
#define sshbuf_free				Fssh_sshbuf_free
#define sshbuf_from				Fssh_sshbuf_from
#define sshbuf_fromb				Fssh_sshbuf_fromb
#define sshbuf_froms				Fssh_sshbuf_froms
#define sshbuf_get				Fssh_sshbuf_get
#define sshbuf_get_bignum1			Fssh_sshbuf_get_bignum1
#define sshbuf_get_bignum2			Fssh_sshbuf_get_bignum2
#define sshbuf_get_bignum2_bytes_direct		Fssh_sshbuf_get_bignum2_bytes_direct
#define sshbuf_get_cstring			Fssh_sshbuf_get_cstring
#define sshbuf_get_ec				Fssh_sshbuf_get_ec
#define sshbuf_get_eckey			Fssh_sshbuf_get_eckey
#define sshbuf_get_string			Fssh_sshbuf_get_string
#define sshbuf_get_string_direct		Fssh_sshbuf_get_string_direct
#define sshbuf_get_stringb			Fssh_sshbuf_get_stringb
#define sshbuf_get_u16				Fssh_sshbuf_get_u16
#define sshbuf_get_u32				Fssh_sshbuf_get_u32
#define sshbuf_get_u64				Fssh_sshbuf_get_u64
#define sshbuf_get_u8				Fssh_sshbuf_get_u8
#define sshbuf_init				Fssh_sshbuf_init
#define sshbuf_len				Fssh_sshbuf_len
#define sshbuf_max_size				Fssh_sshbuf_max_size
#define sshbuf_mutable_ptr			Fssh_sshbuf_mutable_ptr
#define sshbuf_new				Fssh_sshbuf_new
#define sshbuf_parent				Fssh_sshbuf_parent
#define sshbuf_peek_string_direct		Fssh_sshbuf_peek_string_direct
#define sshbuf_ptr				Fssh_sshbuf_ptr
#define sshbuf_put				Fssh_sshbuf_put
#define sshbuf_put_bignum1			Fssh_sshbuf_put_bignum1
#define sshbuf_put_bignum2			Fssh_sshbuf_put_bignum2
#define sshbuf_put_bignum2_bytes		Fssh_sshbuf_put_bignum2_bytes
#define sshbuf_put_cstring			Fssh_sshbuf_put_cstring
#define sshbuf_put_ec				Fssh_sshbuf_put_ec
#define sshbuf_put_eckey			Fssh_sshbuf_put_eckey
#define sshbuf_put_string			Fssh_sshbuf_put_string
#define sshbuf_put_stringb			Fssh_sshbuf_put_stringb
#define sshbuf_put_u16				Fssh_sshbuf_put_u16
#define sshbuf_put_u32				Fssh_sshbuf_put_u32
#define sshbuf_put_u64				Fssh_sshbuf_put_u64
#define sshbuf_put_u8				Fssh_sshbuf_put_u8
#define sshbuf_putb				Fssh_sshbuf_putb
#define sshbuf_putf				Fssh_sshbuf_putf
#define sshbuf_putfv				Fssh_sshbuf_putfv
#define sshbuf_refcount				Fssh_sshbuf_refcount
#define sshbuf_reserve				Fssh_sshbuf_reserve
#define sshbuf_reset				Fssh_sshbuf_reset
#define sshbuf_set_max_size			Fssh_sshbuf_set_max_size
#define sshbuf_set_parent			Fssh_sshbuf_set_parent
#define sshkey_add_private			Fssh_sshkey_add_private
#define sshkey_cert_check_authority		Fssh_sshkey_cert_check_authority
#define sshkey_cert_copy			Fssh_sshkey_cert_copy
#define sshkey_cert_type			Fssh_sshkey_cert_type
#define sshkey_certify				Fssh_sshkey_certify
#define sshkey_check_revoked			Fssh_sshkey_check_revoked
#define sshkey_curve_name_to_nid		Fssh_sshkey_curve_name_to_nid
#define sshkey_curve_nid_to_bits		Fssh_sshkey_curve_nid_to_bits
#define sshkey_curve_nid_to_name		Fssh_sshkey_curve_nid_to_name
#define sshkey_demote				Fssh_sshkey_demote
#define sshkey_drop_cert			Fssh_sshkey_drop_cert
#define sshkey_dump_ec_key			Fssh_sshkey_dump_ec_key
#define sshkey_dump_ec_point			Fssh_sshkey_dump_ec_point
#define sshkey_ec_nid_to_hash_alg		Fssh_sshkey_ec_nid_to_hash_alg
#define sshkey_ec_validate_private		Fssh_sshkey_ec_validate_private
#define sshkey_ec_validate_public		Fssh_sshkey_ec_validate_public
#define sshkey_ecdsa_bits_to_nid		Fssh_sshkey_ecdsa_bits_to_nid
#define sshkey_ecdsa_key_to_nid			Fssh_sshkey_ecdsa_key_to_nid
#define sshkey_ecdsa_nid_from_name		Fssh_sshkey_ecdsa_nid_from_name
#define sshkey_equal				Fssh_sshkey_equal
#define sshkey_equal_public			Fssh_sshkey_equal_public
#define sshkey_fingerprint			Fssh_sshkey_fingerprint
#define sshkey_fingerprint_raw			Fssh_sshkey_fingerprint_raw
#define sshkey_format_cert_validity		Fssh_sshkey_format_cert_validity
#define sshkey_free				Fssh_sshkey_free
#define sshkey_from_blob			Fssh_sshkey_from_blob
#define sshkey_from_blob_internal		Fssh_sshkey_from_blob_internal
#define sshkey_from_private			Fssh_sshkey_from_private
#define sshkey_fromb				Fssh_sshkey_fromb
#define sshkey_froms				Fssh_sshkey_froms
#define sshkey_generate				Fssh_sshkey_generate
#define sshkey_in_file				Fssh_sshkey_in_file
#define sshkey_is_cert				Fssh_sshkey_is_cert
#define sshkey_load_cert			Fssh_sshkey_load_cert
#define sshkey_load_file			Fssh_sshkey_load_file
#define sshkey_load_private			Fssh_sshkey_load_private
#define sshkey_load_private_cert		Fssh_sshkey_load_private_cert
#define sshkey_load_private_type		Fssh_sshkey_load_private_type
#define sshkey_load_private_type_fd		Fssh_sshkey_load_private_type_fd
#define sshkey_load_public			Fssh_sshkey_load_public
#define sshkey_names_valid2			Fssh_sshkey_names_valid2
#define sshkey_new				Fssh_sshkey_new
#define sshkey_new_private			Fssh_sshkey_new_private
#define sshkey_parse_private2			Fssh_sshkey_parse_private2
#define sshkey_parse_private_fileblob		Fssh_sshkey_parse_private_fileblob
#define sshkey_parse_private_fileblob_type	Fssh_sshkey_parse_private_fileblob_type
#define sshkey_parse_private_pem_fileblob	Fssh_sshkey_parse_private_pem_fileblob
#define sshkey_parse_public_rsa1_fileblob	Fssh_sshkey_parse_public_rsa1_fileblob
#define sshkey_perm_ok				Fssh_sshkey_perm_ok
#define sshkey_plain_to_blob			Fssh_sshkey_plain_to_blob
#define sshkey_private_deserialize		Fssh_sshkey_private_deserialize
#define sshkey_private_serialize		Fssh_sshkey_private_serialize
#define sshkey_private_to_blob2			Fssh_sshkey_private_to_blob2
#define sshkey_private_to_fileblob		Fssh_sshkey_private_to_fileblob
#define sshkey_putb				Fssh_sshkey_putb
#define sshkey_putb_plain			Fssh_sshkey_putb_plain
#define sshkey_puts				Fssh_sshkey_puts
#define sshkey_read				Fssh_sshkey_read
#define sshkey_save_private			Fssh_sshkey_save_private
#define sshkey_sign				Fssh_sshkey_sign
#define sshkey_size				Fssh_sshkey_size
#define sshkey_ssh_name				Fssh_sshkey_ssh_name
#define sshkey_ssh_name_plain			Fssh_sshkey_ssh_name_plain
#define sshkey_to_base64			Fssh_sshkey_to_base64
#define sshkey_to_blob				Fssh_sshkey_to_blob
#define sshkey_to_certified			Fssh_sshkey_to_certified
#define sshkey_try_load_public			Fssh_sshkey_try_load_public
#define sshkey_type				Fssh_sshkey_type
#define sshkey_type_from_name			Fssh_sshkey_type_from_name
#define sshkey_type_is_cert			Fssh_sshkey_type_is_cert
#define sshkey_type_plain			Fssh_sshkey_type_plain
#define sshkey_verify				Fssh_sshkey_verify
#define sshkey_write				Fssh_sshkey_write
#define sshpkt_add_padding			Fssh_sshpkt_add_padding
#define sshpkt_disconnect			Fssh_sshpkt_disconnect
#define sshpkt_fatal				Fssh_sshpkt_fatal
#define sshpkt_get				Fssh_sshpkt_get
#define sshpkt_get_bignum1			Fssh_sshpkt_get_bignum1
#define sshpkt_get_bignum2			Fssh_sshpkt_get_bignum2
#define sshpkt_get_cstring			Fssh_sshpkt_get_cstring
#define sshpkt_get_ec				Fssh_sshpkt_get_ec
#define sshpkt_get_end				Fssh_sshpkt_get_end
#define sshpkt_get_string			Fssh_sshpkt_get_string
#define sshpkt_get_string_direct		Fssh_sshpkt_get_string_direct
#define sshpkt_get_u32				Fssh_sshpkt_get_u32
#define sshpkt_get_u64				Fssh_sshpkt_get_u64
#define sshpkt_get_u8				Fssh_sshpkt_get_u8
#define sshpkt_ptr				Fssh_sshpkt_ptr
#define sshpkt_put				Fssh_sshpkt_put
#define sshpkt_put_bignum1			Fssh_sshpkt_put_bignum1
#define sshpkt_put_bignum2			Fssh_sshpkt_put_bignum2
#define sshpkt_put_cstring			Fssh_sshpkt_put_cstring
#define sshpkt_put_ec				Fssh_sshpkt_put_ec
#define sshpkt_put_string			Fssh_sshpkt_put_string
#define sshpkt_put_stringb			Fssh_sshpkt_put_stringb
#define sshpkt_put_u32				Fssh_sshpkt_put_u32
#define sshpkt_put_u64				Fssh_sshpkt_put_u64
#define sshpkt_put_u8				Fssh_sshpkt_put_u8
#define sshpkt_putb				Fssh_sshpkt_putb
#define sshpkt_send				Fssh_sshpkt_send
#define sshpkt_start				Fssh_sshpkt_start
#define start_progress_meter			Fssh_start_progress_meter
#define stop_progress_meter			Fssh_stop_progress_meter
#define stravis					Fssh_stravis
#define strdelim				Fssh_strdelim
#define strnvis					Fssh_strnvis
#define strvis					Fssh_strvis
#define strvisx					Fssh_strvisx
#define sys_tun_open				Fssh_sys_tun_open
#define temporarily_use_uid			Fssh_temporarily_use_uid
#define tilde_expand_filename			Fssh_tilde_expand_filename
#define timingsafe_bcmp				Fssh_timingsafe_bcmp
#define to_blob					Fssh_to_blob
#define to_blob_buf				Fssh_to_blob_buf
#define tohex					Fssh_tohex
#define tty_make_modes				Fssh_tty_make_modes
#define tty_parse_modes				Fssh_tty_parse_modes
#define tun_open				Fssh_tun_open
#define umac128_delete				Fssh_umac128_delete
#define umac128_final				Fssh_umac128_final
#define umac128_new				Fssh_umac128_new
#define umac128_update				Fssh_umac128_update
#define umac_delete				Fssh_umac_delete
#define umac_final				Fssh_umac_final
#define umac_new				Fssh_umac_new
#define umac_update				Fssh_umac_update
#define uncompress_buffer			Fssh_uncompress_buffer
#define unix_listener				Fssh_unix_listener
#define unset_nonblock				Fssh_unset_nonblock
#define update_progress_meter			Fssh_update_progress_meter
#define uudecode				Fssh_uudecode
#define uuencode				Fssh_uuencode
#define verbose					Fssh_verbose
#define verify_host_key_dns			Fssh_verify_host_key_dns
#define vis					Fssh_vis
#define write_host_entry			Fssh_write_host_entry
#define x11_connect_display			Fssh_x11_connect_display
#define x11_create_display_inet			Fssh_x11_create_display_inet
#define x11_input_open				Fssh_x11_input_open
#define x11_open_helper				Fssh_x11_open_helper
#define x11_request_forwarding_with_spoofing	Fssh_x11_request_forwarding_with_spoofing
#define xasprintf				Fssh_xasprintf
#define xcalloc					Fssh_xcalloc
#define xcrypt					Fssh_xcrypt
#define xmalloc					Fssh_xmalloc
#define xmmap					Fssh_xmmap
#define xreallocarray				Fssh_xreallocarray
#define xstrdup					Fssh_xstrdup
