/*-
 * Copyright (c) 2017, Fedor Uporov
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * $FreeBSD: stable/11/sys/fs/ext2fs/ext2_acl.h 322711 2017-08-20 01:08:23Z pfg $
 */

#ifndef _FS_EXT2FS_EXT2_ACL_H_
#define	_FS_EXT2FS_EXT2_ACL_H_

#define	EXT4_ACL_VERSION	0x0001

struct ext2_acl_entry {
	int16_t		ae_tag;
	int16_t		ae_perm;
	int32_t		ae_id;
};

struct ext2_acl_entry_short {
	int16_t		ae_tag;
	int16_t		ae_perm;
};

struct ext2_acl_header {
	int32_t		a_version;
};

void ext2_sync_acl_from_inode(struct inode *ip, struct acl *acl);

int	ext2_getacl(struct vop_getacl_args *);
int	ext2_setacl(struct vop_setacl_args *);
int	ext2_aclcheck(struct vop_aclcheck_args *);

#endif /* !_FS_EXT2FS_EXT2_ACL_H_ */
