/*
 * ng_iface.h
 */

/*-
 * Copyright (c) 1996-1999 Whistle Communications, Inc.
 * All rights reserved.
 * 
 * Subject to the following obligations and disclaimer of warranty, use and
 * redistribution of this software, in source or object code forms, with or
 * without modifications are expressly permitted by Whistle Communications;
 * provided, however, that:
 * 1. Any and all reproductions of the source or object code must include the
 *    copyright notice above and the following disclaimer of warranties; and
 * 2. No rights are granted, in any manner or form, to use Whistle
 *    Communications, Inc. trademarks, including the mark "WHISTLE
 *    COMMUNICATIONS" on advertising, endorsements, or otherwise except as
 *    such appears in the above copyright notice or in the software.
 * 
 * THIS SOFTWARE IS BEING PROVIDED BY WHISTLE COMMUNICATIONS "AS IS", AND
 * TO THE MAXIMUM EXTENT PERMITTED BY LAW, WHISTLE COMMUNICATIONS MAKES NO
 * REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, REGARDING THIS SOFTWARE,
 * INCLUDING WITHOUT LIMITATION, ANY AND ALL IMPLIED WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, OR NON-INFRINGEMENT.
 * WHISTLE COMMUNICATIONS DOES NOT WARRANT, GUARANTEE, OR MAKE ANY
 * REPRESENTATIONS REGARDING THE USE OF, OR THE RESULTS OF THE USE OF THIS
 * SOFTWARE IN TERMS OF ITS CORRECTNESS, ACCURACY, RELIABILITY OR OTHERWISE.
 * IN NO EVENT SHALL WHISTLE COMMUNICATIONS BE LIABLE FOR ANY DAMAGES
 * RESULTING FROM OR ARISING OUT OF ANY USE OF THIS SOFTWARE, INCLUDING
 * WITHOUT LIMITATION, ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY,
 * PUNITIVE, OR CONSEQUENTIAL DAMAGES, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES, LOSS OF USE, DATA OR PROFITS, HOWEVER CAUSED AND UNDER ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF WHISTLE COMMUNICATIONS IS ADVISED OF THE POSSIBILITY
 * OF SUCH DAMAGE.
 *
 * Author: Archie Cobbs <archie@freebsd.org>
 *
 * $FreeBSD: stable/5/sys/netgraph/ng_iface.h 141090 2005-01-31 23:27:04Z imp $
 * $Whistle: ng_iface.h,v 1.5 1999/01/20 00:22:13 archie Exp $
 */

#ifndef _NETGRAPH_NG_IFACE_H_
#define _NETGRAPH_NG_IFACE_H_

/* Node type name and magic cookie */
#define NG_IFACE_NODE_TYPE		"iface"
#define NGM_IFACE_COOKIE		858821773

/* Interface base name */
#define NG_IFACE_IFACE_NAME		"ng"
#define NG_IFACE_IFACE_NAME_MAX		15

/* My hook names */
#define NG_IFACE_HOOK_INET		"inet"
#define NG_IFACE_HOOK_INET6		"inet6"
#define NG_IFACE_HOOK_ATALK		"atalk"	/* AppleTalk phase 2 */
#define NG_IFACE_HOOK_IPX		"ipx"
#define NG_IFACE_HOOK_ATM		"atm"
#define NG_IFACE_HOOK_NATM		"natm"

/* MTU bounds */
#define NG_IFACE_MTU_MIN		72
#define NG_IFACE_MTU_MAX		65535
#define NG_IFACE_MTU_DEFAULT		1500

/* Netgraph commands */
enum {
	NGM_IFACE_GET_IFNAME = 1,	/* returns struct ng_iface_ifname */
	NGM_IFACE_POINT2POINT,
	NGM_IFACE_BROADCAST,
	NGM_IFACE_GET_IFINDEX,
};

struct ng_iface_ifname {
	char    ngif_name[NG_IFACE_IFACE_NAME_MAX + 1];
};

#endif /* _NETGRAPH_NG_IFACE_H_ */
