/*
 * Copyright (c) 1996
 *	Bill Paul <wpaul@ctr.columbia.edu>.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *	This product includes software developed by Bill Paul.
 * 4. Neither the name of the author nor the names of any co-contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY Bill Paul AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL Bill Paul OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#include <sys/cdefs.h>
__FBSDID("$FreeBSD: stable/5/usr.sbin/ypserv/yp_svc_udp.c 114601 2003-05-03 21:06:42Z obrien $");

#include <rpc/rpc.h>
#include <rpc/svc_dg.h>
#include "yp_extern.h"

#define su_data(xprt)	((struct svc_dg_data *)(xprt->xp_p2))

/*
 * We need to be able to manually set the transaction ID in the
 * UDP transport handle, but the standard library offers us no way
 * to do that. Hence we need this garbage.
 */

unsigned long
svcudp_get_xid(SVCXPRT *xprt)
{
	struct svc_dg_data *su;

	if (xprt == NULL)
		return(0);
	su = su_data(xprt);
	return(su->su_xid);
}

unsigned long
svcudp_set_xid(SVCXPRT *xprt, unsigned long xid)
{
	struct svc_dg_data *su;
	unsigned long old_xid;

	if (xprt == NULL)
		return(0);
	su = su_data(xprt);
	old_xid = su->su_xid;
	su->su_xid = xid;
	return(old_xid);
}
