/**************************************************************************

Copyright (c) 2007, Chelsio Inc.
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

 1. Redistributions of source code must retain the above copyright notice,
    this list of conditions and the following disclaimer.

 2. Neither the name of the Chelsio Corporation nor the names of its
    contributors may be used to endorse or promote products derived from
    this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
POSSIBILITY OF SUCH DAMAGE.

$FreeBSD: stable/8/sys/dev/cxgb/common/cxgb_regs.h 199206 2009-11-12 00:20:31Z np $

***************************************************************************/
/* This file is automatically generated --- do not edit */

/* registers for module SGE3 */
#define SGE3_BASE_ADDR 0x0

#define A_SG_CONTROL 0x0

#define S_CONGMODE    29
#define V_CONGMODE(x) ((x) << S_CONGMODE)
#define F_CONGMODE    V_CONGMODE(1U)

#define S_TNLFLMODE    28
#define V_TNLFLMODE(x) ((x) << S_TNLFLMODE)
#define F_TNLFLMODE    V_TNLFLMODE(1U)

#define S_FATLPERREN    27
#define V_FATLPERREN(x) ((x) << S_FATLPERREN)
#define F_FATLPERREN    V_FATLPERREN(1U)

#define S_URGTNL    26
#define V_URGTNL(x) ((x) << S_URGTNL)
#define F_URGTNL    V_URGTNL(1U)

#define S_NEWNOTIFY    25
#define V_NEWNOTIFY(x) ((x) << S_NEWNOTIFY)
#define F_NEWNOTIFY    V_NEWNOTIFY(1U)

#define S_AVOIDCQOVFL    24
#define V_AVOIDCQOVFL(x) ((x) << S_AVOIDCQOVFL)
#define F_AVOIDCQOVFL    V_AVOIDCQOVFL(1U)

#define S_OPTONEINTMULTQ    23
#define V_OPTONEINTMULTQ(x) ((x) << S_OPTONEINTMULTQ)
#define F_OPTONEINTMULTQ    V_OPTONEINTMULTQ(1U)

#define S_CQCRDTCTRL    22
#define V_CQCRDTCTRL(x) ((x) << S_CQCRDTCTRL)
#define F_CQCRDTCTRL    V_CQCRDTCTRL(1U)

#define S_EGRENUPBP    21
#define V_EGRENUPBP(x) ((x) << S_EGRENUPBP)
#define F_EGRENUPBP    V_EGRENUPBP(1U)

#define S_DROPPKT    20
#define V_DROPPKT(x) ((x) << S_DROPPKT)
#define F_DROPPKT    V_DROPPKT(1U)

#define S_EGRGENCTRL    19
#define V_EGRGENCTRL(x) ((x) << S_EGRGENCTRL)
#define F_EGRGENCTRL    V_EGRGENCTRL(1U)

#define S_USERSPACESIZE    14
#define M_USERSPACESIZE    0x1f
#define V_USERSPACESIZE(x) ((x) << S_USERSPACESIZE)
#define G_USERSPACESIZE(x) (((x) >> S_USERSPACESIZE) & M_USERSPACESIZE)

#define S_HOSTPAGESIZE    11
#define M_HOSTPAGESIZE    0x7
#define V_HOSTPAGESIZE(x) ((x) << S_HOSTPAGESIZE)
#define G_HOSTPAGESIZE(x) (((x) >> S_HOSTPAGESIZE) & M_HOSTPAGESIZE)

#define S_PCIRELAX    10
#define V_PCIRELAX(x) ((x) << S_PCIRELAX)
#define F_PCIRELAX    V_PCIRELAX(1U)

#define S_FLMODE    9
#define V_FLMODE(x) ((x) << S_FLMODE)
#define F_FLMODE    V_FLMODE(1U)

#define S_PKTSHIFT    6
#define M_PKTSHIFT    0x7
#define V_PKTSHIFT(x) ((x) << S_PKTSHIFT)
#define G_PKTSHIFT(x) (((x) >> S_PKTSHIFT) & M_PKTSHIFT)

#define S_ONEINTMULTQ    5
#define V_ONEINTMULTQ(x) ((x) << S_ONEINTMULTQ)
#define F_ONEINTMULTQ    V_ONEINTMULTQ(1U)

#define S_FLPICKAVAIL    4
#define V_FLPICKAVAIL(x) ((x) << S_FLPICKAVAIL)
#define F_FLPICKAVAIL    V_FLPICKAVAIL(1U)

#define S_BIGENDIANEGRESS    3
#define V_BIGENDIANEGRESS(x) ((x) << S_BIGENDIANEGRESS)
#define F_BIGENDIANEGRESS    V_BIGENDIANEGRESS(1U)

#define S_BIGENDIANINGRESS    2
#define V_BIGENDIANINGRESS(x) ((x) << S_BIGENDIANINGRESS)
#define F_BIGENDIANINGRESS    V_BIGENDIANINGRESS(1U)

#define S_ISCSICOALESCING    1
#define V_ISCSICOALESCING(x) ((x) << S_ISCSICOALESCING)
#define F_ISCSICOALESCING    V_ISCSICOALESCING(1U)

#define S_GLOBALENABLE    0
#define V_GLOBALENABLE(x) ((x) << S_GLOBALENABLE)
#define F_GLOBALENABLE    V_GLOBALENABLE(1U)

#define A_SG_KDOORBELL 0x4

#define S_SELEGRCNTX    31
#define V_SELEGRCNTX(x) ((x) << S_SELEGRCNTX)
#define F_SELEGRCNTX    V_SELEGRCNTX(1U)

#define S_EGRCNTX    0
#define M_EGRCNTX    0xffff
#define V_EGRCNTX(x) ((x) << S_EGRCNTX)
#define G_EGRCNTX(x) (((x) >> S_EGRCNTX) & M_EGRCNTX)

#define A_SG_GTS 0x8

#define S_RSPQ    29
#define M_RSPQ    0x7
#define V_RSPQ(x) ((x) << S_RSPQ)
#define G_RSPQ(x) (((x) >> S_RSPQ) & M_RSPQ)

#define S_NEWTIMER    16
#define M_NEWTIMER    0x1fff
#define V_NEWTIMER(x) ((x) << S_NEWTIMER)
#define G_NEWTIMER(x) (((x) >> S_NEWTIMER) & M_NEWTIMER)

#define S_NEWINDEX    0
#define M_NEWINDEX    0xffff
#define V_NEWINDEX(x) ((x) << S_NEWINDEX)
#define G_NEWINDEX(x) (((x) >> S_NEWINDEX) & M_NEWINDEX)

#define A_SG_CONTEXT_CMD 0xc

#define S_CONTEXT_CMD_OPCODE    28
#define M_CONTEXT_CMD_OPCODE    0xf
#define V_CONTEXT_CMD_OPCODE(x) ((x) << S_CONTEXT_CMD_OPCODE)
#define G_CONTEXT_CMD_OPCODE(x) (((x) >> S_CONTEXT_CMD_OPCODE) & M_CONTEXT_CMD_OPCODE)

#define S_CONTEXT_CMD_BUSY    27
#define V_CONTEXT_CMD_BUSY(x) ((x) << S_CONTEXT_CMD_BUSY)
#define F_CONTEXT_CMD_BUSY    V_CONTEXT_CMD_BUSY(1U)

#define S_CQ_CREDIT    20
#define M_CQ_CREDIT    0x7f
#define V_CQ_CREDIT(x) ((x) << S_CQ_CREDIT)
#define G_CQ_CREDIT(x) (((x) >> S_CQ_CREDIT) & M_CQ_CREDIT)

#define S_CQ    19
#define V_CQ(x) ((x) << S_CQ)
#define F_CQ    V_CQ(1U)

#define S_RESPONSEQ    18
#define V_RESPONSEQ(x) ((x) << S_RESPONSEQ)
#define F_RESPONSEQ    V_RESPONSEQ(1U)

#define S_EGRESS    17
#define V_EGRESS(x) ((x) << S_EGRESS)
#define F_EGRESS    V_EGRESS(1U)

#define S_FREELIST    16
#define V_FREELIST(x) ((x) << S_FREELIST)
#define F_FREELIST    V_FREELIST(1U)

#define S_CONTEXT    0
#define M_CONTEXT    0xffff
#define V_CONTEXT(x) ((x) << S_CONTEXT)
#define G_CONTEXT(x) (((x) >> S_CONTEXT) & M_CONTEXT)

#define A_SG_CONTEXT_DATA0 0x10
#define A_SG_CONTEXT_DATA1 0x14
#define A_SG_CONTEXT_DATA2 0x18
#define A_SG_CONTEXT_DATA3 0x1c
#define A_SG_CONTEXT_MASK0 0x20
#define A_SG_CONTEXT_MASK1 0x24
#define A_SG_CONTEXT_MASK2 0x28
#define A_SG_CONTEXT_MASK3 0x2c
#define A_SG_RSPQ_CREDIT_RETURN 0x30

#define S_CREDITS    0
#define M_CREDITS    0xffff
#define V_CREDITS(x) ((x) << S_CREDITS)
#define G_CREDITS(x) (((x) >> S_CREDITS) & M_CREDITS)

#define A_SG_DATA_INTR 0x34

#define S_ERRINTR    31
#define V_ERRINTR(x) ((x) << S_ERRINTR)
#define F_ERRINTR    V_ERRINTR(1U)

#define S_DATAINTR    0
#define M_DATAINTR    0xff
#define V_DATAINTR(x) ((x) << S_DATAINTR)
#define G_DATAINTR(x) (((x) >> S_DATAINTR) & M_DATAINTR)

#define A_SG_HI_DRB_HI_THRSH 0x38

#define S_HIDRBHITHRSH    0
#define M_HIDRBHITHRSH    0x3ff
#define V_HIDRBHITHRSH(x) ((x) << S_HIDRBHITHRSH)
#define G_HIDRBHITHRSH(x) (((x) >> S_HIDRBHITHRSH) & M_HIDRBHITHRSH)

#define A_SG_HI_DRB_LO_THRSH 0x3c

#define S_HIDRBLOTHRSH    0
#define M_HIDRBLOTHRSH    0x3ff
#define V_HIDRBLOTHRSH(x) ((x) << S_HIDRBLOTHRSH)
#define G_HIDRBLOTHRSH(x) (((x) >> S_HIDRBLOTHRSH) & M_HIDRBLOTHRSH)

#define A_SG_LO_DRB_HI_THRSH 0x40

#define S_LODRBHITHRSH    0
#define M_LODRBHITHRSH    0x3ff
#define V_LODRBHITHRSH(x) ((x) << S_LODRBHITHRSH)
#define G_LODRBHITHRSH(x) (((x) >> S_LODRBHITHRSH) & M_LODRBHITHRSH)

#define A_SG_LO_DRB_LO_THRSH 0x44

#define S_LODRBLOTHRSH    0
#define M_LODRBLOTHRSH    0x3ff
#define V_LODRBLOTHRSH(x) ((x) << S_LODRBLOTHRSH)
#define G_LODRBLOTHRSH(x) (((x) >> S_LODRBLOTHRSH) & M_LODRBLOTHRSH)

#define A_SG_ONE_INT_MULT_Q_COALESCING_TIMER 0x48
#define A_SG_RSPQ_FL_STATUS 0x4c

#define S_RSPQ0STARVED    0
#define V_RSPQ0STARVED(x) ((x) << S_RSPQ0STARVED)
#define F_RSPQ0STARVED    V_RSPQ0STARVED(1U)

#define S_RSPQ1STARVED    1
#define V_RSPQ1STARVED(x) ((x) << S_RSPQ1STARVED)
#define F_RSPQ1STARVED    V_RSPQ1STARVED(1U)

#define S_RSPQ2STARVED    2
#define V_RSPQ2STARVED(x) ((x) << S_RSPQ2STARVED)
#define F_RSPQ2STARVED    V_RSPQ2STARVED(1U)

#define S_RSPQ3STARVED    3
#define V_RSPQ3STARVED(x) ((x) << S_RSPQ3STARVED)
#define F_RSPQ3STARVED    V_RSPQ3STARVED(1U)

#define S_RSPQ4STARVED    4
#define V_RSPQ4STARVED(x) ((x) << S_RSPQ4STARVED)
#define F_RSPQ4STARVED    V_RSPQ4STARVED(1U)

#define S_RSPQ5STARVED    5
#define V_RSPQ5STARVED(x) ((x) << S_RSPQ5STARVED)
#define F_RSPQ5STARVED    V_RSPQ5STARVED(1U)

#define S_RSPQ6STARVED    6
#define V_RSPQ6STARVED(x) ((x) << S_RSPQ6STARVED)
#define F_RSPQ6STARVED    V_RSPQ6STARVED(1U)

#define S_RSPQ7STARVED    7
#define V_RSPQ7STARVED(x) ((x) << S_RSPQ7STARVED)
#define F_RSPQ7STARVED    V_RSPQ7STARVED(1U)

#define S_RSPQXSTARVED    0
#define M_RSPQXSTARVED    0xff
#define V_RSPQXSTARVED(x) ((x) << S_RSPQXSTARVED)
#define G_RSPQXSTARVED(x) (((x) >> S_RSPQXSTARVED) & M_RSPQXSTARVED)

#define S_RSPQ0DISABLED    8
#define V_RSPQ0DISABLED(x) ((x) << S_RSPQ0DISABLED)
#define F_RSPQ0DISABLED    V_RSPQ0DISABLED(1U)

#define S_RSPQ1DISABLED    9
#define V_RSPQ1DISABLED(x) ((x) << S_RSPQ1DISABLED)
#define F_RSPQ1DISABLED    V_RSPQ1DISABLED(1U)

#define S_RSPQ2DISABLED    10
#define V_RSPQ2DISABLED(x) ((x) << S_RSPQ2DISABLED)
#define F_RSPQ2DISABLED    V_RSPQ2DISABLED(1U)

#define S_RSPQ3DISABLED    11
#define V_RSPQ3DISABLED(x) ((x) << S_RSPQ3DISABLED)
#define F_RSPQ3DISABLED    V_RSPQ3DISABLED(1U)

#define S_RSPQ4DISABLED    12
#define V_RSPQ4DISABLED(x) ((x) << S_RSPQ4DISABLED)
#define F_RSPQ4DISABLED    V_RSPQ4DISABLED(1U)

#define S_RSPQ5DISABLED    13
#define V_RSPQ5DISABLED(x) ((x) << S_RSPQ5DISABLED)
#define F_RSPQ5DISABLED    V_RSPQ5DISABLED(1U)

#define S_RSPQ6DISABLED    14
#define V_RSPQ6DISABLED(x) ((x) << S_RSPQ6DISABLED)
#define F_RSPQ6DISABLED    V_RSPQ6DISABLED(1U)

#define S_RSPQ7DISABLED    15
#define V_RSPQ7DISABLED(x) ((x) << S_RSPQ7DISABLED)
#define F_RSPQ7DISABLED    V_RSPQ7DISABLED(1U)

#define S_FL0EMPTY    16
#define V_FL0EMPTY(x) ((x) << S_FL0EMPTY)
#define F_FL0EMPTY    V_FL0EMPTY(1U)

#define S_FL1EMPTY    17
#define V_FL1EMPTY(x) ((x) << S_FL1EMPTY)
#define F_FL1EMPTY    V_FL1EMPTY(1U)

#define S_FL2EMPTY    18
#define V_FL2EMPTY(x) ((x) << S_FL2EMPTY)
#define F_FL2EMPTY    V_FL2EMPTY(1U)

#define S_FL3EMPTY    19
#define V_FL3EMPTY(x) ((x) << S_FL3EMPTY)
#define F_FL3EMPTY    V_FL3EMPTY(1U)

#define S_FL4EMPTY    20
#define V_FL4EMPTY(x) ((x) << S_FL4EMPTY)
#define F_FL4EMPTY    V_FL4EMPTY(1U)

#define S_FL5EMPTY    21
#define V_FL5EMPTY(x) ((x) << S_FL5EMPTY)
#define F_FL5EMPTY    V_FL5EMPTY(1U)

#define S_FL6EMPTY    22
#define V_FL6EMPTY(x) ((x) << S_FL6EMPTY)
#define F_FL6EMPTY    V_FL6EMPTY(1U)

#define S_FL7EMPTY    23
#define V_FL7EMPTY(x) ((x) << S_FL7EMPTY)
#define F_FL7EMPTY    V_FL7EMPTY(1U)

#define S_FL8EMPTY    24
#define V_FL8EMPTY(x) ((x) << S_FL8EMPTY)
#define F_FL8EMPTY    V_FL8EMPTY(1U)

#define S_FL9EMPTY    25
#define V_FL9EMPTY(x) ((x) << S_FL9EMPTY)
#define F_FL9EMPTY    V_FL9EMPTY(1U)

#define S_FL10EMPTY    26
#define V_FL10EMPTY(x) ((x) << S_FL10EMPTY)
#define F_FL10EMPTY    V_FL10EMPTY(1U)

#define S_FL11EMPTY    27
#define V_FL11EMPTY(x) ((x) << S_FL11EMPTY)
#define F_FL11EMPTY    V_FL11EMPTY(1U)

#define S_FL12EMPTY    28
#define V_FL12EMPTY(x) ((x) << S_FL12EMPTY)
#define F_FL12EMPTY    V_FL12EMPTY(1U)

#define S_FL13EMPTY    29
#define V_FL13EMPTY(x) ((x) << S_FL13EMPTY)
#define F_FL13EMPTY    V_FL13EMPTY(1U)

#define S_FL14EMPTY    30
#define V_FL14EMPTY(x) ((x) << S_FL14EMPTY)
#define F_FL14EMPTY    V_FL14EMPTY(1U)

#define S_FL15EMPTY    31
#define V_FL15EMPTY(x) ((x) << S_FL15EMPTY)
#define F_FL15EMPTY    V_FL15EMPTY(1U)

#define S_FLXEMPTY    16
#define M_FLXEMPTY    0xffff
#define V_FLXEMPTY(x) ((x) << S_FLXEMPTY)
#define G_FLXEMPTY(x) (((x) >> S_FLXEMPTY) & M_FLXEMPTY)

#define A_SG_EGR_PRI_CNT 0x50

#define S_EGRERROPCODE    24
#define M_EGRERROPCODE    0xff
#define V_EGRERROPCODE(x) ((x) << S_EGRERROPCODE)
#define G_EGRERROPCODE(x) (((x) >> S_EGRERROPCODE) & M_EGRERROPCODE)

#define S_EGRHIOPCODE    16
#define M_EGRHIOPCODE    0xff
#define V_EGRHIOPCODE(x) ((x) << S_EGRHIOPCODE)
#define G_EGRHIOPCODE(x) (((x) >> S_EGRHIOPCODE) & M_EGRHIOPCODE)

#define S_EGRLOOPCODE    8
#define M_EGRLOOPCODE    0xff
#define V_EGRLOOPCODE(x) ((x) << S_EGRLOOPCODE)
#define G_EGRLOOPCODE(x) (((x) >> S_EGRLOOPCODE) & M_EGRLOOPCODE)

#define S_EGRPRICNT    0
#define M_EGRPRICNT    0x1f
#define V_EGRPRICNT(x) ((x) << S_EGRPRICNT)
#define G_EGRPRICNT(x) (((x) >> S_EGRPRICNT) & M_EGRPRICNT)

#define A_SG_EGR_RCQ_DRB_THRSH 0x54

#define S_HIRCQDRBTHRSH    16
#define M_HIRCQDRBTHRSH    0x7ff
#define V_HIRCQDRBTHRSH(x) ((x) << S_HIRCQDRBTHRSH)
#define G_HIRCQDRBTHRSH(x) (((x) >> S_HIRCQDRBTHRSH) & M_HIRCQDRBTHRSH)

#define S_LORCQDRBTHRSH    0
#define M_LORCQDRBTHRSH    0x7ff
#define V_LORCQDRBTHRSH(x) ((x) << S_LORCQDRBTHRSH)
#define G_LORCQDRBTHRSH(x) (((x) >> S_LORCQDRBTHRSH) & M_LORCQDRBTHRSH)

#define A_SG_EGR_CNTX_BADDR 0x58

#define S_EGRCNTXBADDR    5
#define M_EGRCNTXBADDR    0x7ffffff
#define V_EGRCNTXBADDR(x) ((x) << S_EGRCNTXBADDR)
#define G_EGRCNTXBADDR(x) (((x) >> S_EGRCNTXBADDR) & M_EGRCNTXBADDR)

#define A_SG_INT_CAUSE 0x5c

#define S_HIRCQPARITYERROR    31
#define V_HIRCQPARITYERROR(x) ((x) << S_HIRCQPARITYERROR)
#define F_HIRCQPARITYERROR    V_HIRCQPARITYERROR(1U)

#define S_LORCQPARITYERROR    30
#define V_LORCQPARITYERROR(x) ((x) << S_LORCQPARITYERROR)
#define F_LORCQPARITYERROR    V_LORCQPARITYERROR(1U)

#define S_HIDRBPARITYERROR    29
#define V_HIDRBPARITYERROR(x) ((x) << S_HIDRBPARITYERROR)
#define F_HIDRBPARITYERROR    V_HIDRBPARITYERROR(1U)

#define S_LODRBPARITYERROR    28
#define V_LODRBPARITYERROR(x) ((x) << S_LODRBPARITYERROR)
#define F_LODRBPARITYERROR    V_LODRBPARITYERROR(1U)

#define S_FLPARITYERROR    22
#define M_FLPARITYERROR    0x3f
#define V_FLPARITYERROR(x) ((x) << S_FLPARITYERROR)
#define G_FLPARITYERROR(x) (((x) >> S_FLPARITYERROR) & M_FLPARITYERROR)

#define S_ITPARITYERROR    20
#define M_ITPARITYERROR    0x3
#define V_ITPARITYERROR(x) ((x) << S_ITPARITYERROR)
#define G_ITPARITYERROR(x) (((x) >> S_ITPARITYERROR) & M_ITPARITYERROR)

#define S_IRPARITYERROR    19
#define V_IRPARITYERROR(x) ((x) << S_IRPARITYERROR)
#define F_IRPARITYERROR    V_IRPARITYERROR(1U)

#define S_RCPARITYERROR    18
#define V_RCPARITYERROR(x) ((x) << S_RCPARITYERROR)
#define F_RCPARITYERROR    V_RCPARITYERROR(1U)

#define S_OCPARITYERROR    17
#define V_OCPARITYERROR(x) ((x) << S_OCPARITYERROR)
#define F_OCPARITYERROR    V_OCPARITYERROR(1U)

#define S_CPPARITYERROR    16
#define V_CPPARITYERROR(x) ((x) << S_CPPARITYERROR)
#define F_CPPARITYERROR    V_CPPARITYERROR(1U)

#define S_R_REQ_FRAMINGERROR    15
#define V_R_REQ_FRAMINGERROR(x) ((x) << S_R_REQ_FRAMINGERROR)
#define F_R_REQ_FRAMINGERROR    V_R_REQ_FRAMINGERROR(1U)

#define S_UC_REQ_FRAMINGERROR    14
#define V_UC_REQ_FRAMINGERROR(x) ((x) << S_UC_REQ_FRAMINGERROR)
#define F_UC_REQ_FRAMINGERROR    V_UC_REQ_FRAMINGERROR(1U)

#define S_HICTLDRBDROPERR    13
#define V_HICTLDRBDROPERR(x) ((x) << S_HICTLDRBDROPERR)
#define F_HICTLDRBDROPERR    V_HICTLDRBDROPERR(1U)

#define S_LOCTLDRBDROPERR    12
#define V_LOCTLDRBDROPERR(x) ((x) << S_LOCTLDRBDROPERR)
#define F_LOCTLDRBDROPERR    V_LOCTLDRBDROPERR(1U)

#define S_HIPIODRBDROPERR    11
#define V_HIPIODRBDROPERR(x) ((x) << S_HIPIODRBDROPERR)
#define F_HIPIODRBDROPERR    V_HIPIODRBDROPERR(1U)

#define S_LOPIODRBDROPERR    10
#define V_LOPIODRBDROPERR(x) ((x) << S_LOPIODRBDROPERR)
#define F_LOPIODRBDROPERR    V_LOPIODRBDROPERR(1U)

#define S_HICRDTUNDFLOWERR    9
#define V_HICRDTUNDFLOWERR(x) ((x) << S_HICRDTUNDFLOWERR)
#define F_HICRDTUNDFLOWERR    V_HICRDTUNDFLOWERR(1U)

#define S_LOCRDTUNDFLOWERR    8
#define V_LOCRDTUNDFLOWERR(x) ((x) << S_LOCRDTUNDFLOWERR)
#define F_LOCRDTUNDFLOWERR    V_LOCRDTUNDFLOWERR(1U)

#define S_HIPRIORITYDBFULL    7
#define V_HIPRIORITYDBFULL(x) ((x) << S_HIPRIORITYDBFULL)
#define F_HIPRIORITYDBFULL    V_HIPRIORITYDBFULL(1U)

#define S_HIPRIORITYDBEMPTY    6
#define V_HIPRIORITYDBEMPTY(x) ((x) << S_HIPRIORITYDBEMPTY)
#define F_HIPRIORITYDBEMPTY    V_HIPRIORITYDBEMPTY(1U)

#define S_LOPRIORITYDBFULL    5
#define V_LOPRIORITYDBFULL(x) ((x) << S_LOPRIORITYDBFULL)
#define F_LOPRIORITYDBFULL    V_LOPRIORITYDBFULL(1U)

#define S_LOPRIORITYDBEMPTY    4
#define V_LOPRIORITYDBEMPTY(x) ((x) << S_LOPRIORITYDBEMPTY)
#define F_LOPRIORITYDBEMPTY    V_LOPRIORITYDBEMPTY(1U)

#define S_RSPQDISABLED    3
#define V_RSPQDISABLED(x) ((x) << S_RSPQDISABLED)
#define F_RSPQDISABLED    V_RSPQDISABLED(1U)

#define S_RSPQCREDITOVERFOW    2
#define V_RSPQCREDITOVERFOW(x) ((x) << S_RSPQCREDITOVERFOW)
#define F_RSPQCREDITOVERFOW    V_RSPQCREDITOVERFOW(1U)

#define S_FLEMPTY    1
#define V_FLEMPTY(x) ((x) << S_FLEMPTY)
#define F_FLEMPTY    V_FLEMPTY(1U)

#define S_RSPQSTARVE    0
#define V_RSPQSTARVE(x) ((x) << S_RSPQSTARVE)
#define F_RSPQSTARVE    V_RSPQSTARVE(1U)

#define A_SG_INT_ENABLE 0x60
#define A_SG_CMDQ_CREDIT_TH 0x64

#define S_TIMEOUT    8
#define M_TIMEOUT    0xffffff
#define V_TIMEOUT(x) ((x) << S_TIMEOUT)
#define G_TIMEOUT(x) (((x) >> S_TIMEOUT) & M_TIMEOUT)

#define S_THRESHOLD    0
#define M_THRESHOLD    0xff
#define V_THRESHOLD(x) ((x) << S_THRESHOLD)
#define G_THRESHOLD(x) (((x) >> S_THRESHOLD) & M_THRESHOLD)

#define A_SG_TIMER_TICK 0x68
#define A_SG_CQ_CONTEXT_BADDR 0x6c

#define S_BASEADDR    5
#define M_BASEADDR    0x7ffffff
#define V_BASEADDR(x) ((x) << S_BASEADDR)
#define G_BASEADDR(x) (((x) >> S_BASEADDR) & M_BASEADDR)

#define A_SG_OCO_BASE 0x70

#define S_BASE1    16
#define M_BASE1    0xffff
#define V_BASE1(x) ((x) << S_BASE1)
#define G_BASE1(x) (((x) >> S_BASE1) & M_BASE1)

#define S_BASE0    0
#define M_BASE0    0xffff
#define V_BASE0(x) ((x) << S_BASE0)
#define G_BASE0(x) (((x) >> S_BASE0) & M_BASE0)

#define A_SG_DRB_PRI_THRESH 0x74

#define S_DRBPRITHRSH    0
#define M_DRBPRITHRSH    0xffff
#define V_DRBPRITHRSH(x) ((x) << S_DRBPRITHRSH)
#define G_DRBPRITHRSH(x) (((x) >> S_DRBPRITHRSH) & M_DRBPRITHRSH)

#define A_SG_DEBUG_INDEX 0x78
#define A_SG_DEBUG_DATA 0x7c

/* registers for module PCIX1 */
#define PCIX1_BASE_ADDR 0x80

#define A_PCIX_INT_ENABLE 0x80

#define S_MSIXPARERR    22
#define M_MSIXPARERR    0x7
#define V_MSIXPARERR(x) ((x) << S_MSIXPARERR)
#define G_MSIXPARERR(x) (((x) >> S_MSIXPARERR) & M_MSIXPARERR)

#define S_CFPARERR    18
#define M_CFPARERR    0xf
#define V_CFPARERR(x) ((x) << S_CFPARERR)
#define G_CFPARERR(x) (((x) >> S_CFPARERR) & M_CFPARERR)

#define S_RFPARERR    14
#define M_RFPARERR    0xf
#define V_RFPARERR(x) ((x) << S_RFPARERR)
#define G_RFPARERR(x) (((x) >> S_RFPARERR) & M_RFPARERR)

#define S_WFPARERR    12
#define M_WFPARERR    0x3
#define V_WFPARERR(x) ((x) << S_WFPARERR)
#define G_WFPARERR(x) (((x) >> S_WFPARERR) & M_WFPARERR)

#define S_PIOPARERR    11
#define V_PIOPARERR(x) ((x) << S_PIOPARERR)
#define F_PIOPARERR    V_PIOPARERR(1U)

#define S_DETUNCECCERR    10
#define V_DETUNCECCERR(x) ((x) << S_DETUNCECCERR)
#define F_DETUNCECCERR    V_DETUNCECCERR(1U)

#define S_DETCORECCERR    9
#define V_DETCORECCERR(x) ((x) << S_DETCORECCERR)
#define F_DETCORECCERR    V_DETCORECCERR(1U)

#define S_RCVSPLCMPERR    8
#define V_RCVSPLCMPERR(x) ((x) << S_RCVSPLCMPERR)
#define F_RCVSPLCMPERR    V_RCVSPLCMPERR(1U)

#define S_UNXSPLCMP    7
#define V_UNXSPLCMP(x) ((x) << S_UNXSPLCMP)
#define F_UNXSPLCMP    V_UNXSPLCMP(1U)

#define S_SPLCMPDIS    6
#define V_SPLCMPDIS(x) ((x) << S_SPLCMPDIS)
#define F_SPLCMPDIS    V_SPLCMPDIS(1U)

#define S_DETPARERR    5
#define V_DETPARERR(x) ((x) << S_DETPARERR)
#define F_DETPARERR    V_DETPARERR(1U)

#define S_SIGSYSERR    4
#define V_SIGSYSERR(x) ((x) << S_SIGSYSERR)
#define F_SIGSYSERR    V_SIGSYSERR(1U)

#define S_RCVMSTABT    3
#define V_RCVMSTABT(x) ((x) << S_RCVMSTABT)
#define F_RCVMSTABT    V_RCVMSTABT(1U)

#define S_RCVTARABT    2
#define V_RCVTARABT(x) ((x) << S_RCVTARABT)
#define F_RCVTARABT    V_RCVTARABT(1U)

#define S_SIGTARABT    1
#define V_SIGTARABT(x) ((x) << S_SIGTARABT)
#define F_SIGTARABT    V_SIGTARABT(1U)

#define S_MSTDETPARERR    0
#define V_MSTDETPARERR(x) ((x) << S_MSTDETPARERR)
#define F_MSTDETPARERR    V_MSTDETPARERR(1U)

#define A_PCIX_INT_CAUSE 0x84
#define A_PCIX_CFG 0x88

#define S_DMASTOPEN    19
#define V_DMASTOPEN(x) ((x) << S_DMASTOPEN)
#define F_DMASTOPEN    V_DMASTOPEN(1U)

#define S_CLIDECEN    18
#define V_CLIDECEN(x) ((x) << S_CLIDECEN)
#define F_CLIDECEN    V_CLIDECEN(1U)

#define S_LATTMRDIS    17
#define V_LATTMRDIS(x) ((x) << S_LATTMRDIS)
#define F_LATTMRDIS    V_LATTMRDIS(1U)

#define S_LOWPWREN    16
#define V_LOWPWREN(x) ((x) << S_LOWPWREN)
#define F_LOWPWREN    V_LOWPWREN(1U)

#define S_ASYNCINTVEC    11
#define M_ASYNCINTVEC    0x1f
#define V_ASYNCINTVEC(x) ((x) << S_ASYNCINTVEC)
#define G_ASYNCINTVEC(x) (((x) >> S_ASYNCINTVEC) & M_ASYNCINTVEC)

#define S_MAXSPLTRNC    8
#define M_MAXSPLTRNC    0x7
#define V_MAXSPLTRNC(x) ((x) << S_MAXSPLTRNC)
#define G_MAXSPLTRNC(x) (((x) >> S_MAXSPLTRNC) & M_MAXSPLTRNC)

#define S_MAXSPLTRNR    5
#define M_MAXSPLTRNR    0x7
#define V_MAXSPLTRNR(x) ((x) << S_MAXSPLTRNR)
#define G_MAXSPLTRNR(x) (((x) >> S_MAXSPLTRNR) & M_MAXSPLTRNR)

#define S_MAXWRBYTECNT    3
#define M_MAXWRBYTECNT    0x3
#define V_MAXWRBYTECNT(x) ((x) << S_MAXWRBYTECNT)
#define G_MAXWRBYTECNT(x) (((x) >> S_MAXWRBYTECNT) & M_MAXWRBYTECNT)

#define S_WRREQATOMICEN    2
#define V_WRREQATOMICEN(x) ((x) << S_WRREQATOMICEN)
#define F_WRREQATOMICEN    V_WRREQATOMICEN(1U)

#define S_RSTWRMMODE    1
#define V_RSTWRMMODE(x) ((x) << S_RSTWRMMODE)
#define F_RSTWRMMODE    V_RSTWRMMODE(1U)

#define S_PIOACK64EN    0
#define V_PIOACK64EN(x) ((x) << S_PIOACK64EN)
#define F_PIOACK64EN    V_PIOACK64EN(1U)

#define A_PCIX_MODE 0x8c

#define S_PCLKRANGE    6
#define M_PCLKRANGE    0x3
#define V_PCLKRANGE(x) ((x) << S_PCLKRANGE)
#define G_PCLKRANGE(x) (((x) >> S_PCLKRANGE) & M_PCLKRANGE)

#define S_PCIXINITPAT    2
#define M_PCIXINITPAT    0xf
#define V_PCIXINITPAT(x) ((x) << S_PCIXINITPAT)
#define G_PCIXINITPAT(x) (((x) >> S_PCIXINITPAT) & M_PCIXINITPAT)

#define S_66MHZ    1
#define V_66MHZ(x) ((x) << S_66MHZ)
#define F_66MHZ    V_66MHZ(1U)

#define S_64BIT    0
#define V_64BIT(x) ((x) << S_64BIT)
#define F_64BIT    V_64BIT(1U)

#define A_PCIX_CAL 0x90

#define S_BUSY    31
#define V_BUSY(x) ((x) << S_BUSY)
#define F_BUSY    V_BUSY(1U)

#define S_PERCALDIV    22
#define M_PERCALDIV    0xff
#define V_PERCALDIV(x) ((x) << S_PERCALDIV)
#define G_PERCALDIV(x) (((x) >> S_PERCALDIV) & M_PERCALDIV)

#define S_PERCALEN    21
#define V_PERCALEN(x) ((x) << S_PERCALEN)
#define F_PERCALEN    V_PERCALEN(1U)

#define S_SGLCALEN    20
#define V_SGLCALEN(x) ((x) << S_SGLCALEN)
#define F_SGLCALEN    V_SGLCALEN(1U)

#define S_ZINUPDMODE    19
#define V_ZINUPDMODE(x) ((x) << S_ZINUPDMODE)
#define F_ZINUPDMODE    V_ZINUPDMODE(1U)

#define S_ZINSEL    18
#define V_ZINSEL(x) ((x) << S_ZINSEL)
#define F_ZINSEL    V_ZINSEL(1U)

#define S_ZPDMAN    15
#define M_ZPDMAN    0x7
#define V_ZPDMAN(x) ((x) << S_ZPDMAN)
#define G_ZPDMAN(x) (((x) >> S_ZPDMAN) & M_ZPDMAN)

#define S_ZPUMAN    12
#define M_ZPUMAN    0x7
#define V_ZPUMAN(x) ((x) << S_ZPUMAN)
#define G_ZPUMAN(x) (((x) >> S_ZPUMAN) & M_ZPUMAN)

#define S_ZPDOUT    9
#define M_ZPDOUT    0x7
#define V_ZPDOUT(x) ((x) << S_ZPDOUT)
#define G_ZPDOUT(x) (((x) >> S_ZPDOUT) & M_ZPDOUT)

#define S_ZPUOUT    6
#define M_ZPUOUT    0x7
#define V_ZPUOUT(x) ((x) << S_ZPUOUT)
#define G_ZPUOUT(x) (((x) >> S_ZPUOUT) & M_ZPUOUT)

#define S_ZPDIN    3
#define M_ZPDIN    0x7
#define V_ZPDIN(x) ((x) << S_ZPDIN)
#define G_ZPDIN(x) (((x) >> S_ZPDIN) & M_ZPDIN)

#define S_ZPUIN    0
#define M_ZPUIN    0x7
#define V_ZPUIN(x) ((x) << S_ZPUIN)
#define G_ZPUIN(x) (((x) >> S_ZPUIN) & M_ZPUIN)

#define A_PCIX_WOL 0x94

#define S_WAKEUP1    3
#define V_WAKEUP1(x) ((x) << S_WAKEUP1)
#define F_WAKEUP1    V_WAKEUP1(1U)

#define S_WAKEUP0    2
#define V_WAKEUP0(x) ((x) << S_WAKEUP0)
#define F_WAKEUP0    V_WAKEUP0(1U)

#define S_SLEEPMODE1    1
#define V_SLEEPMODE1(x) ((x) << S_SLEEPMODE1)
#define F_SLEEPMODE1    V_SLEEPMODE1(1U)

#define S_SLEEPMODE0    0
#define V_SLEEPMODE0(x) ((x) << S_SLEEPMODE0)
#define F_SLEEPMODE0    V_SLEEPMODE0(1U)

#define A_PCIX_STAT0 0x98

#define S_PIOREQFIFOLEVEL    26
#define M_PIOREQFIFOLEVEL    0x3f
#define V_PIOREQFIFOLEVEL(x) ((x) << S_PIOREQFIFOLEVEL)
#define G_PIOREQFIFOLEVEL(x) (((x) >> S_PIOREQFIFOLEVEL) & M_PIOREQFIFOLEVEL)

#define S_RFINIST    24
#define M_RFINIST    0x3
#define V_RFINIST(x) ((x) << S_RFINIST)
#define G_RFINIST(x) (((x) >> S_RFINIST) & M_RFINIST)

#define S_RFRESPRDST    22
#define M_RFRESPRDST    0x3
#define V_RFRESPRDST(x) ((x) << S_RFRESPRDST)
#define G_RFRESPRDST(x) (((x) >> S_RFRESPRDST) & M_RFRESPRDST)

#define S_TARCST    19
#define M_TARCST    0x7
#define V_TARCST(x) ((x) << S_TARCST)
#define G_TARCST(x) (((x) >> S_TARCST) & M_TARCST)

#define S_TARXST    16
#define M_TARXST    0x7
#define V_TARXST(x) ((x) << S_TARXST)
#define G_TARXST(x) (((x) >> S_TARXST) & M_TARXST)

#define S_WFREQWRST    13
#define M_WFREQWRST    0x7
#define V_WFREQWRST(x) ((x) << S_WFREQWRST)
#define G_WFREQWRST(x) (((x) >> S_WFREQWRST) & M_WFREQWRST)

#define S_WFRESPFIFOEMPTY    12
#define V_WFRESPFIFOEMPTY(x) ((x) << S_WFRESPFIFOEMPTY)
#define F_WFRESPFIFOEMPTY    V_WFRESPFIFOEMPTY(1U)

#define S_WFREQFIFOEMPTY    11
#define V_WFREQFIFOEMPTY(x) ((x) << S_WFREQFIFOEMPTY)
#define F_WFREQFIFOEMPTY    V_WFREQFIFOEMPTY(1U)

#define S_RFRESPFIFOEMPTY    10
#define V_RFRESPFIFOEMPTY(x) ((x) << S_RFRESPFIFOEMPTY)
#define F_RFRESPFIFOEMPTY    V_RFRESPFIFOEMPTY(1U)

#define S_RFREQFIFOEMPTY    9
#define V_RFREQFIFOEMPTY(x) ((x) << S_RFREQFIFOEMPTY)
#define F_RFREQFIFOEMPTY    V_RFREQFIFOEMPTY(1U)

#define S_PIORESPFIFOLEVEL    7
#define M_PIORESPFIFOLEVEL    0x3
#define V_PIORESPFIFOLEVEL(x) ((x) << S_PIORESPFIFOLEVEL)
#define G_PIORESPFIFOLEVEL(x) (((x) >> S_PIORESPFIFOLEVEL) & M_PIORESPFIFOLEVEL)

#define S_CFRESPFIFOEMPTY    6
#define V_CFRESPFIFOEMPTY(x) ((x) << S_CFRESPFIFOEMPTY)
#define F_CFRESPFIFOEMPTY    V_CFRESPFIFOEMPTY(1U)

#define S_CFREQFIFOEMPTY    5
#define V_CFREQFIFOEMPTY(x) ((x) << S_CFREQFIFOEMPTY)
#define F_CFREQFIFOEMPTY    V_CFREQFIFOEMPTY(1U)

#define S_VPDRESPFIFOEMPTY    4
#define V_VPDRESPFIFOEMPTY(x) ((x) << S_VPDRESPFIFOEMPTY)
#define F_VPDRESPFIFOEMPTY    V_VPDRESPFIFOEMPTY(1U)

#define S_VPDREQFIFOEMPTY    3
#define V_VPDREQFIFOEMPTY(x) ((x) << S_VPDREQFIFOEMPTY)
#define F_VPDREQFIFOEMPTY    V_VPDREQFIFOEMPTY(1U)

#define S_PIO_RSPPND    2
#define V_PIO_RSPPND(x) ((x) << S_PIO_RSPPND)
#define F_PIO_RSPPND    V_PIO_RSPPND(1U)

#define S_DLYTRNPND    1
#define V_DLYTRNPND(x) ((x) << S_DLYTRNPND)
#define F_DLYTRNPND    V_DLYTRNPND(1U)

#define S_SPLTRNPND    0
#define V_SPLTRNPND(x) ((x) << S_SPLTRNPND)
#define F_SPLTRNPND    V_SPLTRNPND(1U)

#define A_PCIX_STAT1 0x9c

#define S_WFINIST    26
#define M_WFINIST    0xf
#define V_WFINIST(x) ((x) << S_WFINIST)
#define G_WFINIST(x) (((x) >> S_WFINIST) & M_WFINIST)

#define S_ARBST    23
#define M_ARBST    0x7
#define V_ARBST(x) ((x) << S_ARBST)
#define G_ARBST(x) (((x) >> S_ARBST) & M_ARBST)

#define S_PMIST    21
#define M_PMIST    0x3
#define V_PMIST(x) ((x) << S_PMIST)
#define G_PMIST(x) (((x) >> S_PMIST) & M_PMIST)

#define S_CALST    19
#define M_CALST    0x3
#define V_CALST(x) ((x) << S_CALST)
#define G_CALST(x) (((x) >> S_CALST) & M_CALST)

#define S_CFREQRDST    17
#define M_CFREQRDST    0x3
#define V_CFREQRDST(x) ((x) << S_CFREQRDST)
#define G_CFREQRDST(x) (((x) >> S_CFREQRDST) & M_CFREQRDST)

#define S_CFINIST    15
#define M_CFINIST    0x3
#define V_CFINIST(x) ((x) << S_CFINIST)
#define G_CFINIST(x) (((x) >> S_CFINIST) & M_CFINIST)

#define S_CFRESPRDST    13
#define M_CFRESPRDST    0x3
#define V_CFRESPRDST(x) ((x) << S_CFRESPRDST)
#define G_CFRESPRDST(x) (((x) >> S_CFRESPRDST) & M_CFRESPRDST)

#define S_INICST    10
#define M_INICST    0x7
#define V_INICST(x) ((x) << S_INICST)
#define G_INICST(x) (((x) >> S_INICST) & M_INICST)

#define S_INIXST    7
#define M_INIXST    0x7
#define V_INIXST(x) ((x) << S_INIXST)
#define G_INIXST(x) (((x) >> S_INIXST) & M_INIXST)

#define S_INTST    4
#define M_INTST    0x7
#define V_INTST(x) ((x) << S_INTST)
#define G_INTST(x) (((x) >> S_INTST) & M_INTST)

#define S_PIOST    2
#define M_PIOST    0x3
#define V_PIOST(x) ((x) << S_PIOST)
#define G_PIOST(x) (((x) >> S_PIOST) & M_PIOST)

#define S_RFREQRDST    0
#define M_RFREQRDST    0x3
#define V_RFREQRDST(x) ((x) << S_RFREQRDST)
#define G_RFREQRDST(x) (((x) >> S_RFREQRDST) & M_RFREQRDST)

/* registers for module PCIE0 */
#define PCIE0_BASE_ADDR 0x80

#define A_PCIE_INT_ENABLE 0x80

#define S_BISTERR    19
#define M_BISTERR    0xff
#define V_BISTERR(x) ((x) << S_BISTERR)
#define G_BISTERR(x) (((x) >> S_BISTERR) & M_BISTERR)

#define S_TXPARERR    18
#define V_TXPARERR(x) ((x) << S_TXPARERR)
#define F_TXPARERR    V_TXPARERR(1U)

#define S_RXPARERR    17
#define V_RXPARERR(x) ((x) << S_RXPARERR)
#define F_RXPARERR    V_RXPARERR(1U)

#define S_RETRYLUTPARERR    16
#define V_RETRYLUTPARERR(x) ((x) << S_RETRYLUTPARERR)
#define F_RETRYLUTPARERR    V_RETRYLUTPARERR(1U)

#define S_RETRYBUFPARERR    15
#define V_RETRYBUFPARERR(x) ((x) << S_RETRYBUFPARERR)
#define F_RETRYBUFPARERR    V_RETRYBUFPARERR(1U)

#define S_PCIE_MSIXPARERR    12
#define M_PCIE_MSIXPARERR    0x7
#define V_PCIE_MSIXPARERR(x) ((x) << S_PCIE_MSIXPARERR)
#define G_PCIE_MSIXPARERR(x) (((x) >> S_PCIE_MSIXPARERR) & M_PCIE_MSIXPARERR)

#define S_PCIE_CFPARERR    11
#define V_PCIE_CFPARERR(x) ((x) << S_PCIE_CFPARERR)
#define F_PCIE_CFPARERR    V_PCIE_CFPARERR(1U)

#define S_PCIE_RFPARERR    10
#define V_PCIE_RFPARERR(x) ((x) << S_PCIE_RFPARERR)
#define F_PCIE_RFPARERR    V_PCIE_RFPARERR(1U)

#define S_PCIE_WFPARERR    9
#define V_PCIE_WFPARERR(x) ((x) << S_PCIE_WFPARERR)
#define F_PCIE_WFPARERR    V_PCIE_WFPARERR(1U)

#define S_PCIE_PIOPARERR    8
#define V_PCIE_PIOPARERR(x) ((x) << S_PCIE_PIOPARERR)
#define F_PCIE_PIOPARERR    V_PCIE_PIOPARERR(1U)

#define S_UNXSPLCPLERRC    7
#define V_UNXSPLCPLERRC(x) ((x) << S_UNXSPLCPLERRC)
#define F_UNXSPLCPLERRC    V_UNXSPLCPLERRC(1U)

#define S_UNXSPLCPLERRR    6
#define V_UNXSPLCPLERRR(x) ((x) << S_UNXSPLCPLERRR)
#define F_UNXSPLCPLERRR    V_UNXSPLCPLERRR(1U)

#define S_VPDADDRCHNG    5
#define V_VPDADDRCHNG(x) ((x) << S_VPDADDRCHNG)
#define F_VPDADDRCHNG    V_VPDADDRCHNG(1U)

#define S_BUSMSTREN    4
#define V_BUSMSTREN(x) ((x) << S_BUSMSTREN)
#define F_BUSMSTREN    V_BUSMSTREN(1U)

#define S_PMSTCHNG    3
#define V_PMSTCHNG(x) ((x) << S_PMSTCHNG)
#define F_PMSTCHNG    V_PMSTCHNG(1U)

#define S_PEXMSG    2
#define V_PEXMSG(x) ((x) << S_PEXMSG)
#define F_PEXMSG    V_PEXMSG(1U)

#define S_ZEROLENRD    1
#define V_ZEROLENRD(x) ((x) << S_ZEROLENRD)
#define F_ZEROLENRD    V_ZEROLENRD(1U)

#define S_PEXERR    0
#define V_PEXERR(x) ((x) << S_PEXERR)
#define F_PEXERR    V_PEXERR(1U)

#define A_PCIE_INT_CAUSE 0x84
#define A_PCIE_CFG 0x88

#define S_PCIE_DMASTOPEN    24
#define V_PCIE_DMASTOPEN(x) ((x) << S_PCIE_DMASTOPEN)
#define F_PCIE_DMASTOPEN    V_PCIE_DMASTOPEN(1U)

#define S_PRIORITYINTA    23
#define V_PRIORITYINTA(x) ((x) << S_PRIORITYINTA)
#define F_PRIORITYINTA    V_PRIORITYINTA(1U)

#define S_INIFULLPKT    22
#define V_INIFULLPKT(x) ((x) << S_INIFULLPKT)
#define F_INIFULLPKT    V_INIFULLPKT(1U)

#define S_ENABLELINKDWNDRST    21
#define V_ENABLELINKDWNDRST(x) ((x) << S_ENABLELINKDWNDRST)
#define F_ENABLELINKDWNDRST    V_ENABLELINKDWNDRST(1U)

#define S_ENABLELINKDOWNRST    20
#define V_ENABLELINKDOWNRST(x) ((x) << S_ENABLELINKDOWNRST)
#define F_ENABLELINKDOWNRST    V_ENABLELINKDOWNRST(1U)

#define S_ENABLEHOTRST    19
#define V_ENABLEHOTRST(x) ((x) << S_ENABLEHOTRST)
#define F_ENABLEHOTRST    V_ENABLEHOTRST(1U)

#define S_INIWAITFORGNT    18
#define V_INIWAITFORGNT(x) ((x) << S_INIWAITFORGNT)
#define F_INIWAITFORGNT    V_INIWAITFORGNT(1U)

#define S_INIBEDIS    17
#define V_INIBEDIS(x) ((x) << S_INIBEDIS)
#define F_INIBEDIS    V_INIBEDIS(1U)

#define S_PCIE_CLIDECEN    16
#define V_PCIE_CLIDECEN(x) ((x) << S_PCIE_CLIDECEN)
#define F_PCIE_CLIDECEN    V_PCIE_CLIDECEN(1U)

#define S_PCIE_MAXSPLTRNC    7
#define M_PCIE_MAXSPLTRNC    0xf
#define V_PCIE_MAXSPLTRNC(x) ((x) << S_PCIE_MAXSPLTRNC)
#define G_PCIE_MAXSPLTRNC(x) (((x) >> S_PCIE_MAXSPLTRNC) & M_PCIE_MAXSPLTRNC)

#define S_PCIE_MAXSPLTRNR    1
#define M_PCIE_MAXSPLTRNR    0x3f
#define V_PCIE_MAXSPLTRNR(x) ((x) << S_PCIE_MAXSPLTRNR)
#define G_PCIE_MAXSPLTRNR(x) (((x) >> S_PCIE_MAXSPLTRNR) & M_PCIE_MAXSPLTRNR)

#define S_CRSTWRMMODE    0
#define V_CRSTWRMMODE(x) ((x) << S_CRSTWRMMODE)
#define F_CRSTWRMMODE    V_CRSTWRMMODE(1U)

#define A_PCIE_MODE 0x8c

#define S_TAR_STATE    29
#define M_TAR_STATE    0x7
#define V_TAR_STATE(x) ((x) << S_TAR_STATE)
#define G_TAR_STATE(x) (((x) >> S_TAR_STATE) & M_TAR_STATE)

#define S_RF_STATEINI    26
#define M_RF_STATEINI    0x7
#define V_RF_STATEINI(x) ((x) << S_RF_STATEINI)
#define G_RF_STATEINI(x) (((x) >> S_RF_STATEINI) & M_RF_STATEINI)

#define S_CF_STATEINI    23
#define M_CF_STATEINI    0x7
#define V_CF_STATEINI(x) ((x) << S_CF_STATEINI)
#define G_CF_STATEINI(x) (((x) >> S_CF_STATEINI) & M_CF_STATEINI)

#define S_PIO_STATEPL    20
#define M_PIO_STATEPL    0x7
#define V_PIO_STATEPL(x) ((x) << S_PIO_STATEPL)
#define G_PIO_STATEPL(x) (((x) >> S_PIO_STATEPL) & M_PIO_STATEPL)

#define S_PIO_STATEISC    18
#define M_PIO_STATEISC    0x3
#define V_PIO_STATEISC(x) ((x) << S_PIO_STATEISC)
#define G_PIO_STATEISC(x) (((x) >> S_PIO_STATEISC) & M_PIO_STATEISC)

#define S_NUMFSTTRNSEQRX    10
#define M_NUMFSTTRNSEQRX    0xff
#define V_NUMFSTTRNSEQRX(x) ((x) << S_NUMFSTTRNSEQRX)
#define G_NUMFSTTRNSEQRX(x) (((x) >> S_NUMFSTTRNSEQRX) & M_NUMFSTTRNSEQRX)

#define S_LNKCNTLSTATE    2
#define M_LNKCNTLSTATE    0xff
#define V_LNKCNTLSTATE(x) ((x) << S_LNKCNTLSTATE)
#define G_LNKCNTLSTATE(x) (((x) >> S_LNKCNTLSTATE) & M_LNKCNTLSTATE)

#define S_VC0UP    1
#define V_VC0UP(x) ((x) << S_VC0UP)
#define F_VC0UP    V_VC0UP(1U)

#define S_LNKINITIAL    0
#define V_LNKINITIAL(x) ((x) << S_LNKINITIAL)
#define F_LNKINITIAL    V_LNKINITIAL(1U)

#define A_PCIE_STAT 0x90

#define S_INI_STATE    28
#define M_INI_STATE    0xf
#define V_INI_STATE(x) ((x) << S_INI_STATE)
#define G_INI_STATE(x) (((x) >> S_INI_STATE) & M_INI_STATE)

#define S_WF_STATEINI    24
#define M_WF_STATEINI    0xf
#define V_WF_STATEINI(x) ((x) << S_WF_STATEINI)
#define G_WF_STATEINI(x) (((x) >> S_WF_STATEINI) & M_WF_STATEINI)

#define S_PLM_REQFIFOCNT    22
#define M_PLM_REQFIFOCNT    0x3
#define V_PLM_REQFIFOCNT(x) ((x) << S_PLM_REQFIFOCNT)
#define G_PLM_REQFIFOCNT(x) (((x) >> S_PLM_REQFIFOCNT) & M_PLM_REQFIFOCNT)

#define S_ER_REQFIFOEMPTY    21
#define V_ER_REQFIFOEMPTY(x) ((x) << S_ER_REQFIFOEMPTY)
#define F_ER_REQFIFOEMPTY    V_ER_REQFIFOEMPTY(1U)

#define S_WF_RSPFIFOEMPTY    20
#define V_WF_RSPFIFOEMPTY(x) ((x) << S_WF_RSPFIFOEMPTY)
#define F_WF_RSPFIFOEMPTY    V_WF_RSPFIFOEMPTY(1U)

#define S_WF_REQFIFOEMPTY    19
#define V_WF_REQFIFOEMPTY(x) ((x) << S_WF_REQFIFOEMPTY)
#define F_WF_REQFIFOEMPTY    V_WF_REQFIFOEMPTY(1U)

#define S_RF_RSPFIFOEMPTY    18
#define V_RF_RSPFIFOEMPTY(x) ((x) << S_RF_RSPFIFOEMPTY)
#define F_RF_RSPFIFOEMPTY    V_RF_RSPFIFOEMPTY(1U)

#define S_RF_REQFIFOEMPTY    17
#define V_RF_REQFIFOEMPTY(x) ((x) << S_RF_REQFIFOEMPTY)
#define F_RF_REQFIFOEMPTY    V_RF_REQFIFOEMPTY(1U)

#define S_RF_ACTEMPTY    16
#define V_RF_ACTEMPTY(x) ((x) << S_RF_ACTEMPTY)
#define F_RF_ACTEMPTY    V_RF_ACTEMPTY(1U)

#define S_PIO_RSPFIFOCNT    11
#define M_PIO_RSPFIFOCNT    0x1f
#define V_PIO_RSPFIFOCNT(x) ((x) << S_PIO_RSPFIFOCNT)
#define G_PIO_RSPFIFOCNT(x) (((x) >> S_PIO_RSPFIFOCNT) & M_PIO_RSPFIFOCNT)

#define S_PIO_REQFIFOCNT    5
#define M_PIO_REQFIFOCNT    0x3f
#define V_PIO_REQFIFOCNT(x) ((x) << S_PIO_REQFIFOCNT)
#define G_PIO_REQFIFOCNT(x) (((x) >> S_PIO_REQFIFOCNT) & M_PIO_REQFIFOCNT)

#define S_CF_RSPFIFOEMPTY    4
#define V_CF_RSPFIFOEMPTY(x) ((x) << S_CF_RSPFIFOEMPTY)
#define F_CF_RSPFIFOEMPTY    V_CF_RSPFIFOEMPTY(1U)

#define S_CF_REQFIFOEMPTY    3
#define V_CF_REQFIFOEMPTY(x) ((x) << S_CF_REQFIFOEMPTY)
#define F_CF_REQFIFOEMPTY    V_CF_REQFIFOEMPTY(1U)

#define S_CF_ACTEMPTY    2
#define V_CF_ACTEMPTY(x) ((x) << S_CF_ACTEMPTY)
#define F_CF_ACTEMPTY    V_CF_ACTEMPTY(1U)

#define S_VPD_RSPFIFOEMPTY    1
#define V_VPD_RSPFIFOEMPTY(x) ((x) << S_VPD_RSPFIFOEMPTY)
#define F_VPD_RSPFIFOEMPTY    V_VPD_RSPFIFOEMPTY(1U)

#define S_VPD_REQFIFOEMPTY    0
#define V_VPD_REQFIFOEMPTY(x) ((x) << S_VPD_REQFIFOEMPTY)
#define F_VPD_REQFIFOEMPTY    V_VPD_REQFIFOEMPTY(1U)

#define A_PCIE_CAL 0x90

#define S_CALBUSY    31
#define V_CALBUSY(x) ((x) << S_CALBUSY)
#define F_CALBUSY    V_CALBUSY(1U)

#define S_CALFAULT    30
#define V_CALFAULT(x) ((x) << S_CALFAULT)
#define F_CALFAULT    V_CALFAULT(1U)

#define S_PCIE_ZINSEL    11
#define V_PCIE_ZINSEL(x) ((x) << S_PCIE_ZINSEL)
#define F_PCIE_ZINSEL    V_PCIE_ZINSEL(1U)

#define S_ZMAN    8
#define M_ZMAN    0x7
#define V_ZMAN(x) ((x) << S_ZMAN)
#define G_ZMAN(x) (((x) >> S_ZMAN) & M_ZMAN)

#define S_ZOUT    3
#define M_ZOUT    0x1f
#define V_ZOUT(x) ((x) << S_ZOUT)
#define G_ZOUT(x) (((x) >> S_ZOUT) & M_ZOUT)

#define S_ZIN    0
#define M_ZIN    0x7
#define V_ZIN(x) ((x) << S_ZIN)
#define G_ZIN(x) (((x) >> S_ZIN) & M_ZIN)

#define A_PCIE_WOL 0x94

#define S_CF_RSPSTATE    12
#define M_CF_RSPSTATE    0x3
#define V_CF_RSPSTATE(x) ((x) << S_CF_RSPSTATE)
#define G_CF_RSPSTATE(x) (((x) >> S_CF_RSPSTATE) & M_CF_RSPSTATE)

#define S_RF_RSPSTATE    10
#define M_RF_RSPSTATE    0x3
#define V_RF_RSPSTATE(x) ((x) << S_RF_RSPSTATE)
#define G_RF_RSPSTATE(x) (((x) >> S_RF_RSPSTATE) & M_RF_RSPSTATE)

#define S_PME_STATE    7
#define M_PME_STATE    0x7
#define V_PME_STATE(x) ((x) << S_PME_STATE)
#define G_PME_STATE(x) (((x) >> S_PME_STATE) & M_PME_STATE)

#define S_INT_STATE    4
#define M_INT_STATE    0x7
#define V_INT_STATE(x) ((x) << S_INT_STATE)
#define G_INT_STATE(x) (((x) >> S_INT_STATE) & M_INT_STATE)

#define A_PCIE_PEX_CTRL0 0x98

#define S_CPLTIMEOUTRETRY    31
#define V_CPLTIMEOUTRETRY(x) ((x) << S_CPLTIMEOUTRETRY)
#define F_CPLTIMEOUTRETRY    V_CPLTIMEOUTRETRY(1U)

#define S_STRICTTSMN    30
#define V_STRICTTSMN(x) ((x) << S_STRICTTSMN)
#define F_STRICTTSMN    V_STRICTTSMN(1U)

#define S_NUMFSTTRNSEQ    22
#define M_NUMFSTTRNSEQ    0xff
#define V_NUMFSTTRNSEQ(x) ((x) << S_NUMFSTTRNSEQ)
#define G_NUMFSTTRNSEQ(x) (((x) >> S_NUMFSTTRNSEQ) & M_NUMFSTTRNSEQ)

#define S_REPLAYLMT    2
#define M_REPLAYLMT    0xfffff
#define V_REPLAYLMT(x) ((x) << S_REPLAYLMT)
#define G_REPLAYLMT(x) (((x) >> S_REPLAYLMT) & M_REPLAYLMT)

#define S_TXPNDCHKEN    1
#define V_TXPNDCHKEN(x) ((x) << S_TXPNDCHKEN)
#define F_TXPNDCHKEN    V_TXPNDCHKEN(1U)

#define S_CPLPNDCHKEN    0
#define V_CPLPNDCHKEN(x) ((x) << S_CPLPNDCHKEN)
#define F_CPLPNDCHKEN    V_CPLPNDCHKEN(1U)

#define A_PCIE_PEX_CTRL1 0x9c

#define S_RXPHYERREN    31
#define V_RXPHYERREN(x) ((x) << S_RXPHYERREN)
#define F_RXPHYERREN    V_RXPHYERREN(1U)

#define S_DLLPTIMEOUTLMT    13
#define M_DLLPTIMEOUTLMT    0x3ffff
#define V_DLLPTIMEOUTLMT(x) ((x) << S_DLLPTIMEOUTLMT)
#define G_DLLPTIMEOUTLMT(x) (((x) >> S_DLLPTIMEOUTLMT) & M_DLLPTIMEOUTLMT)

#define S_ACKLAT    0
#define M_ACKLAT    0x1fff
#define V_ACKLAT(x) ((x) << S_ACKLAT)
#define G_ACKLAT(x) (((x) >> S_ACKLAT) & M_ACKLAT)

#define S_T3A_DLLPTIMEOUTLMT    11
#define M_T3A_DLLPTIMEOUTLMT    0xfffff
#define V_T3A_DLLPTIMEOUTLMT(x) ((x) << S_T3A_DLLPTIMEOUTLMT)
#define G_T3A_DLLPTIMEOUTLMT(x) (((x) >> S_T3A_DLLPTIMEOUTLMT) & M_T3A_DLLPTIMEOUTLMT)

#define S_T3A_ACKLAT    0
#define M_T3A_ACKLAT    0x7ff
#define V_T3A_ACKLAT(x) ((x) << S_T3A_ACKLAT)
#define G_T3A_ACKLAT(x) (((x) >> S_T3A_ACKLAT) & M_T3A_ACKLAT)

#define A_PCIE_PEX_CTRL2 0xa0

#define S_LNKCNTLDETDIR    30
#define V_LNKCNTLDETDIR(x) ((x) << S_LNKCNTLDETDIR)
#define F_LNKCNTLDETDIR    V_LNKCNTLDETDIR(1U)

#define S_ENTERL1REN    29
#define V_ENTERL1REN(x) ((x) << S_ENTERL1REN)
#define F_ENTERL1REN    V_ENTERL1REN(1U)

#define S_PMEXITL1REQ    28
#define V_PMEXITL1REQ(x) ((x) << S_PMEXITL1REQ)
#define F_PMEXITL1REQ    V_PMEXITL1REQ(1U)

#define S_PMTXIDLE    27
#define V_PMTXIDLE(x) ((x) << S_PMTXIDLE)
#define F_PMTXIDLE    V_PMTXIDLE(1U)

#define S_PCIMODELOOP    26
#define V_PCIMODELOOP(x) ((x) << S_PCIMODELOOP)
#define F_PCIMODELOOP    V_PCIMODELOOP(1U)

#define S_L1ASPMTXRXL0STIME    14
#define M_L1ASPMTXRXL0STIME    0xfff
#define V_L1ASPMTXRXL0STIME(x) ((x) << S_L1ASPMTXRXL0STIME)
#define G_L1ASPMTXRXL0STIME(x) (((x) >> S_L1ASPMTXRXL0STIME) & M_L1ASPMTXRXL0STIME)

#define S_L0SIDLETIME    3
#define M_L0SIDLETIME    0x7ff
#define V_L0SIDLETIME(x) ((x) << S_L0SIDLETIME)
#define G_L0SIDLETIME(x) (((x) >> S_L0SIDLETIME) & M_L0SIDLETIME)

#define S_ENTERL1ASPMEN    2
#define V_ENTERL1ASPMEN(x) ((x) << S_ENTERL1ASPMEN)
#define F_ENTERL1ASPMEN    V_ENTERL1ASPMEN(1U)

#define S_ENTERL1EN    1
#define V_ENTERL1EN(x) ((x) << S_ENTERL1EN)
#define F_ENTERL1EN    V_ENTERL1EN(1U)

#define S_ENTERL0SEN    0
#define V_ENTERL0SEN(x) ((x) << S_ENTERL0SEN)
#define F_ENTERL0SEN    V_ENTERL0SEN(1U)

#define S_ENTERL23    3
#define V_ENTERL23(x) ((x) << S_ENTERL23)
#define F_ENTERL23    V_ENTERL23(1U)

#define A_PCIE_PEX_ERR 0xa4

#define S_CPLTIMEOUTID    18
#define M_CPLTIMEOUTID    0x7f
#define V_CPLTIMEOUTID(x) ((x) << S_CPLTIMEOUTID)
#define G_CPLTIMEOUTID(x) (((x) >> S_CPLTIMEOUTID) & M_CPLTIMEOUTID)

#define S_FLOWCTLOFLOWERR    17
#define V_FLOWCTLOFLOWERR(x) ((x) << S_FLOWCTLOFLOWERR)
#define F_FLOWCTLOFLOWERR    V_FLOWCTLOFLOWERR(1U)

#define S_REPLAYTIMEOUT    16
#define V_REPLAYTIMEOUT(x) ((x) << S_REPLAYTIMEOUT)
#define F_REPLAYTIMEOUT    V_REPLAYTIMEOUT(1U)

#define S_REPLAYROLLOVER    15
#define V_REPLAYROLLOVER(x) ((x) << S_REPLAYROLLOVER)
#define F_REPLAYROLLOVER    V_REPLAYROLLOVER(1U)

#define S_BADDLLP    14
#define V_BADDLLP(x) ((x) << S_BADDLLP)
#define F_BADDLLP    V_BADDLLP(1U)

#define S_DLLPERR    13
#define V_DLLPERR(x) ((x) << S_DLLPERR)
#define F_DLLPERR    V_DLLPERR(1U)

#define S_FLOWCTLPROTERR    12
#define V_FLOWCTLPROTERR(x) ((x) << S_FLOWCTLPROTERR)
#define F_FLOWCTLPROTERR    V_FLOWCTLPROTERR(1U)

#define S_CPLTIMEOUT    11
#define V_CPLTIMEOUT(x) ((x) << S_CPLTIMEOUT)
#define F_CPLTIMEOUT    V_CPLTIMEOUT(1U)

#define S_PHYRCVERR    10
#define V_PHYRCVERR(x) ((x) << S_PHYRCVERR)
#define F_PHYRCVERR    V_PHYRCVERR(1U)

#define S_DISTLP    9
#define V_DISTLP(x) ((x) << S_DISTLP)
#define F_DISTLP    V_DISTLP(1U)

#define S_BADECRC    8
#define V_BADECRC(x) ((x) << S_BADECRC)
#define F_BADECRC    V_BADECRC(1U)

#define S_BADTLP    7
#define V_BADTLP(x) ((x) << S_BADTLP)
#define F_BADTLP    V_BADTLP(1U)

#define S_MALTLP    6
#define V_MALTLP(x) ((x) << S_MALTLP)
#define F_MALTLP    V_MALTLP(1U)

#define S_UNXCPL    5
#define V_UNXCPL(x) ((x) << S_UNXCPL)
#define F_UNXCPL    V_UNXCPL(1U)

#define S_UNSREQ    4
#define V_UNSREQ(x) ((x) << S_UNSREQ)
#define F_UNSREQ    V_UNSREQ(1U)

#define S_PSNREQ    3
#define V_PSNREQ(x) ((x) << S_PSNREQ)
#define F_PSNREQ    V_PSNREQ(1U)

#define S_UNSCPL    2
#define V_UNSCPL(x) ((x) << S_UNSCPL)
#define F_UNSCPL    V_UNSCPL(1U)

#define S_CPLABT    1
#define V_CPLABT(x) ((x) << S_CPLABT)
#define F_CPLABT    V_CPLABT(1U)

#define S_PSNCPL    0
#define V_PSNCPL(x) ((x) << S_PSNCPL)
#define F_PSNCPL    V_PSNCPL(1U)

#define A_PCIE_SERDES_CTRL 0xa8

#define S_PMASEL    3
#define V_PMASEL(x) ((x) << S_PMASEL)
#define F_PMASEL    V_PMASEL(1U)

#define S_LANE    0
#define M_LANE    0x7
#define V_LANE(x) ((x) << S_LANE)
#define G_LANE(x) (((x) >> S_LANE) & M_LANE)

#define A_PCIE_PIPE_CTRL 0xa8

#define S_RECDETUSEC    19
#define M_RECDETUSEC    0x7
#define V_RECDETUSEC(x) ((x) << S_RECDETUSEC)
#define G_RECDETUSEC(x) (((x) >> S_RECDETUSEC) & M_RECDETUSEC)

#define S_PLLLCKCYC    6
#define M_PLLLCKCYC    0x1fff
#define V_PLLLCKCYC(x) ((x) << S_PLLLCKCYC)
#define G_PLLLCKCYC(x) (((x) >> S_PLLLCKCYC) & M_PLLLCKCYC)

#define S_ELECIDLEDETCYC    3
#define M_ELECIDLEDETCYC    0x7
#define V_ELECIDLEDETCYC(x) ((x) << S_ELECIDLEDETCYC)
#define G_ELECIDLEDETCYC(x) (((x) >> S_ELECIDLEDETCYC) & M_ELECIDLEDETCYC)

#define S_USECDRLOS    2
#define V_USECDRLOS(x) ((x) << S_USECDRLOS)
#define F_USECDRLOS    V_USECDRLOS(1U)

#define S_PCLKREQINP1    1
#define V_PCLKREQINP1(x) ((x) << S_PCLKREQINP1)
#define F_PCLKREQINP1    V_PCLKREQINP1(1U)

#define S_PCLKOFFINP1    0
#define V_PCLKOFFINP1(x) ((x) << S_PCLKOFFINP1)
#define F_PCLKOFFINP1    V_PCLKOFFINP1(1U)

#define A_PCIE_SERDES_QUAD_CTRL0 0xac

#define S_TESTSIG    10
#define M_TESTSIG    0x7ffff
#define V_TESTSIG(x) ((x) << S_TESTSIG)
#define G_TESTSIG(x) (((x) >> S_TESTSIG) & M_TESTSIG)

#define S_OFFSET    2
#define M_OFFSET    0xff
#define V_OFFSET(x) ((x) << S_OFFSET)
#define G_OFFSET(x) (((x) >> S_OFFSET) & M_OFFSET)

#define S_OFFSETEN    1
#define V_OFFSETEN(x) ((x) << S_OFFSETEN)
#define F_OFFSETEN    V_OFFSETEN(1U)

#define S_IDDQB    0
#define V_IDDQB(x) ((x) << S_IDDQB)
#define F_IDDQB    V_IDDQB(1U)

#define S_MANMODE    31
#define V_MANMODE(x) ((x) << S_MANMODE)
#define F_MANMODE    V_MANMODE(1U)

#define S_MANLPBKEN    29
#define M_MANLPBKEN    0x3
#define V_MANLPBKEN(x) ((x) << S_MANLPBKEN)
#define G_MANLPBKEN(x) (((x) >> S_MANLPBKEN) & M_MANLPBKEN)

#define S_MANTXRECDETEN    28
#define V_MANTXRECDETEN(x) ((x) << S_MANTXRECDETEN)
#define F_MANTXRECDETEN    V_MANTXRECDETEN(1U)

#define S_MANTXBEACON    27
#define V_MANTXBEACON(x) ((x) << S_MANTXBEACON)
#define F_MANTXBEACON    V_MANTXBEACON(1U)

#define S_MANTXEI    26
#define V_MANTXEI(x) ((x) << S_MANTXEI)
#define F_MANTXEI    V_MANTXEI(1U)

#define S_MANRXPOLARITY    25
#define V_MANRXPOLARITY(x) ((x) << S_MANRXPOLARITY)
#define F_MANRXPOLARITY    V_MANRXPOLARITY(1U)

#define S_MANTXRST    24
#define V_MANTXRST(x) ((x) << S_MANTXRST)
#define F_MANTXRST    V_MANTXRST(1U)

#define S_MANRXRST    23
#define V_MANRXRST(x) ((x) << S_MANRXRST)
#define F_MANRXRST    V_MANRXRST(1U)

#define S_MANTXEN    22
#define V_MANTXEN(x) ((x) << S_MANTXEN)
#define F_MANTXEN    V_MANTXEN(1U)

#define S_MANRXEN    21
#define V_MANRXEN(x) ((x) << S_MANRXEN)
#define F_MANRXEN    V_MANRXEN(1U)

#define S_MANEN    20
#define V_MANEN(x) ((x) << S_MANEN)
#define F_MANEN    V_MANEN(1U)

#define S_PCIE_CMURANGE    17
#define M_PCIE_CMURANGE    0x7
#define V_PCIE_CMURANGE(x) ((x) << S_PCIE_CMURANGE)
#define G_PCIE_CMURANGE(x) (((x) >> S_PCIE_CMURANGE) & M_PCIE_CMURANGE)

#define S_PCIE_BGENB    16
#define V_PCIE_BGENB(x) ((x) << S_PCIE_BGENB)
#define F_PCIE_BGENB    V_PCIE_BGENB(1U)

#define S_PCIE_ENSKPDROP    15
#define V_PCIE_ENSKPDROP(x) ((x) << S_PCIE_ENSKPDROP)
#define F_PCIE_ENSKPDROP    V_PCIE_ENSKPDROP(1U)

#define S_PCIE_ENCOMMA    14
#define V_PCIE_ENCOMMA(x) ((x) << S_PCIE_ENCOMMA)
#define F_PCIE_ENCOMMA    V_PCIE_ENCOMMA(1U)

#define S_PCIE_EN8B10B    13
#define V_PCIE_EN8B10B(x) ((x) << S_PCIE_EN8B10B)
#define F_PCIE_EN8B10B    V_PCIE_EN8B10B(1U)

#define S_PCIE_ENELBUF    12
#define V_PCIE_ENELBUF(x) ((x) << S_PCIE_ENELBUF)
#define F_PCIE_ENELBUF    V_PCIE_ENELBUF(1U)

#define S_PCIE_GAIN    7
#define M_PCIE_GAIN    0x1f
#define V_PCIE_GAIN(x) ((x) << S_PCIE_GAIN)
#define G_PCIE_GAIN(x) (((x) >> S_PCIE_GAIN) & M_PCIE_GAIN)

#define S_PCIE_BANDGAP    3
#define M_PCIE_BANDGAP    0xf
#define V_PCIE_BANDGAP(x) ((x) << S_PCIE_BANDGAP)
#define G_PCIE_BANDGAP(x) (((x) >> S_PCIE_BANDGAP) & M_PCIE_BANDGAP)

#define S_RXCOMADJ    2
#define V_RXCOMADJ(x) ((x) << S_RXCOMADJ)
#define F_RXCOMADJ    V_RXCOMADJ(1U)

#define S_PREEMPH    0
#define M_PREEMPH    0x3
#define V_PREEMPH(x) ((x) << S_PREEMPH)
#define G_PREEMPH(x) (((x) >> S_PREEMPH) & M_PREEMPH)

#define A_PCIE_SERDES_QUAD_CTRL1 0xb0

#define S_FASTINIT    28
#define V_FASTINIT(x) ((x) << S_FASTINIT)
#define F_FASTINIT    V_FASTINIT(1U)

#define S_CTCDISABLE    27
#define V_CTCDISABLE(x) ((x) << S_CTCDISABLE)
#define F_CTCDISABLE    V_CTCDISABLE(1U)

#define S_MANRESETPLL    26
#define V_MANRESETPLL(x) ((x) << S_MANRESETPLL)
#define F_MANRESETPLL    V_MANRESETPLL(1U)

#define S_MANL2PWRDN    25
#define V_MANL2PWRDN(x) ((x) << S_MANL2PWRDN)
#define F_MANL2PWRDN    V_MANL2PWRDN(1U)

#define S_MANQUADEN    24
#define V_MANQUADEN(x) ((x) << S_MANQUADEN)
#define F_MANQUADEN    V_MANQUADEN(1U)

#define S_RXEQCTL    22
#define M_RXEQCTL    0x3
#define V_RXEQCTL(x) ((x) << S_RXEQCTL)
#define G_RXEQCTL(x) (((x) >> S_RXEQCTL) & M_RXEQCTL)

#define S_HIVMODE    21
#define V_HIVMODE(x) ((x) << S_HIVMODE)
#define F_HIVMODE    V_HIVMODE(1U)

#define S_REFSEL    19
#define M_REFSEL    0x3
#define V_REFSEL(x) ((x) << S_REFSEL)
#define G_REFSEL(x) (((x) >> S_REFSEL) & M_REFSEL)

#define S_RXTERMADJ    17
#define M_RXTERMADJ    0x3
#define V_RXTERMADJ(x) ((x) << S_RXTERMADJ)
#define G_RXTERMADJ(x) (((x) >> S_RXTERMADJ) & M_RXTERMADJ)

#define S_TXTERMADJ    15
#define M_TXTERMADJ    0x3
#define V_TXTERMADJ(x) ((x) << S_TXTERMADJ)
#define G_TXTERMADJ(x) (((x) >> S_TXTERMADJ) & M_TXTERMADJ)

#define S_DEQ    11
#define M_DEQ    0xf
#define V_DEQ(x) ((x) << S_DEQ)
#define G_DEQ(x) (((x) >> S_DEQ) & M_DEQ)

#define S_DTX    7
#define M_DTX    0xf
#define V_DTX(x) ((x) << S_DTX)
#define G_DTX(x) (((x) >> S_DTX) & M_DTX)

#define S_LODRV    6
#define V_LODRV(x) ((x) << S_LODRV)
#define F_LODRV    V_LODRV(1U)

#define S_HIDRV    5
#define V_HIDRV(x) ((x) << S_HIDRV)
#define F_HIDRV    V_HIDRV(1U)

#define S_INTPARRESET    4
#define V_INTPARRESET(x) ((x) << S_INTPARRESET)
#define F_INTPARRESET    V_INTPARRESET(1U)

#define S_INTPARLPBK    3
#define V_INTPARLPBK(x) ((x) << S_INTPARLPBK)
#define F_INTPARLPBK    V_INTPARLPBK(1U)

#define S_INTSERLPBKWDRV    2
#define V_INTSERLPBKWDRV(x) ((x) << S_INTSERLPBKWDRV)
#define F_INTSERLPBKWDRV    V_INTSERLPBKWDRV(1U)

#define S_PW    1
#define V_PW(x) ((x) << S_PW)
#define F_PW    V_PW(1U)

#define S_PCLKDETECT    0
#define V_PCLKDETECT(x) ((x) << S_PCLKDETECT)
#define F_PCLKDETECT    V_PCLKDETECT(1U)

#define A_PCIE_SERDES_STATUS0 0xb0

#define S_RXERRLANE7    21
#define M_RXERRLANE7    0x7
#define V_RXERRLANE7(x) ((x) << S_RXERRLANE7)
#define G_RXERRLANE7(x) (((x) >> S_RXERRLANE7) & M_RXERRLANE7)

#define S_RXERRLANE6    18
#define M_RXERRLANE6    0x7
#define V_RXERRLANE6(x) ((x) << S_RXERRLANE6)
#define G_RXERRLANE6(x) (((x) >> S_RXERRLANE6) & M_RXERRLANE6)

#define S_RXERRLANE5    15
#define M_RXERRLANE5    0x7
#define V_RXERRLANE5(x) ((x) << S_RXERRLANE5)
#define G_RXERRLANE5(x) (((x) >> S_RXERRLANE5) & M_RXERRLANE5)

#define S_RXERRLANE4    12
#define M_RXERRLANE4    0x7
#define V_RXERRLANE4(x) ((x) << S_RXERRLANE4)
#define G_RXERRLANE4(x) (((x) >> S_RXERRLANE4) & M_RXERRLANE4)

#define S_PCIE_RXERRLANE3    9
#define M_PCIE_RXERRLANE3    0x7
#define V_PCIE_RXERRLANE3(x) ((x) << S_PCIE_RXERRLANE3)
#define G_PCIE_RXERRLANE3(x) (((x) >> S_PCIE_RXERRLANE3) & M_PCIE_RXERRLANE3)

#define S_PCIE_RXERRLANE2    6
#define M_PCIE_RXERRLANE2    0x7
#define V_PCIE_RXERRLANE2(x) ((x) << S_PCIE_RXERRLANE2)
#define G_PCIE_RXERRLANE2(x) (((x) >> S_PCIE_RXERRLANE2) & M_PCIE_RXERRLANE2)

#define S_PCIE_RXERRLANE1    3
#define M_PCIE_RXERRLANE1    0x7
#define V_PCIE_RXERRLANE1(x) ((x) << S_PCIE_RXERRLANE1)
#define G_PCIE_RXERRLANE1(x) (((x) >> S_PCIE_RXERRLANE1) & M_PCIE_RXERRLANE1)

#define S_PCIE_RXERRLANE0    0
#define M_PCIE_RXERRLANE0    0x7
#define V_PCIE_RXERRLANE0(x) ((x) << S_PCIE_RXERRLANE0)
#define G_PCIE_RXERRLANE0(x) (((x) >> S_PCIE_RXERRLANE0) & M_PCIE_RXERRLANE0)

#define A_PCIE_SERDES_LANE_CTRL 0xb4

#define S_EXTBISTCHKERRCLR    22
#define V_EXTBISTCHKERRCLR(x) ((x) << S_EXTBISTCHKERRCLR)
#define F_EXTBISTCHKERRCLR    V_EXTBISTCHKERRCLR(1U)

#define S_EXTBISTCHKEN    21
#define V_EXTBISTCHKEN(x) ((x) << S_EXTBISTCHKEN)
#define F_EXTBISTCHKEN    V_EXTBISTCHKEN(1U)

#define S_EXTBISTGENEN    20
#define V_EXTBISTGENEN(x) ((x) << S_EXTBISTGENEN)
#define F_EXTBISTGENEN    V_EXTBISTGENEN(1U)

#define S_EXTBISTPAT    17
#define M_EXTBISTPAT    0x7
#define V_EXTBISTPAT(x) ((x) << S_EXTBISTPAT)
#define G_EXTBISTPAT(x) (((x) >> S_EXTBISTPAT) & M_EXTBISTPAT)

#define S_EXTPARRESET    16
#define V_EXTPARRESET(x) ((x) << S_EXTPARRESET)
#define F_EXTPARRESET    V_EXTPARRESET(1U)

#define S_EXTPARLPBK    15
#define V_EXTPARLPBK(x) ((x) << S_EXTPARLPBK)
#define F_EXTPARLPBK    V_EXTPARLPBK(1U)

#define S_MANRXTERMEN    14
#define V_MANRXTERMEN(x) ((x) << S_MANRXTERMEN)
#define F_MANRXTERMEN    V_MANRXTERMEN(1U)

#define S_MANBEACONTXEN    13
#define V_MANBEACONTXEN(x) ((x) << S_MANBEACONTXEN)
#define F_MANBEACONTXEN    V_MANBEACONTXEN(1U)

#define S_MANRXDETECTEN    12
#define V_MANRXDETECTEN(x) ((x) << S_MANRXDETECTEN)
#define F_MANRXDETECTEN    V_MANRXDETECTEN(1U)

#define S_MANTXIDLEEN    11
#define V_MANTXIDLEEN(x) ((x) << S_MANTXIDLEEN)
#define F_MANTXIDLEEN    V_MANTXIDLEEN(1U)

#define S_MANRXIDLEEN    10
#define V_MANRXIDLEEN(x) ((x) << S_MANRXIDLEEN)
#define F_MANRXIDLEEN    V_MANRXIDLEEN(1U)

#define S_MANL1PWRDN    9
#define V_MANL1PWRDN(x) ((x) << S_MANL1PWRDN)
#define F_MANL1PWRDN    V_MANL1PWRDN(1U)

#define S_MANRESET    8
#define V_MANRESET(x) ((x) << S_MANRESET)
#define F_MANRESET    V_MANRESET(1U)

#define S_MANFMOFFSET    3
#define M_MANFMOFFSET    0x1f
#define V_MANFMOFFSET(x) ((x) << S_MANFMOFFSET)
#define G_MANFMOFFSET(x) (((x) >> S_MANFMOFFSET) & M_MANFMOFFSET)

#define S_MANFMOFFSETEN    2
#define V_MANFMOFFSETEN(x) ((x) << S_MANFMOFFSETEN)
#define F_MANFMOFFSETEN    V_MANFMOFFSETEN(1U)

#define S_MANLANEEN    1
#define V_MANLANEEN(x) ((x) << S_MANLANEEN)
#define F_MANLANEEN    V_MANLANEEN(1U)

#define S_INTSERLPBK    0
#define V_INTSERLPBK(x) ((x) << S_INTSERLPBK)
#define F_INTSERLPBK    V_INTSERLPBK(1U)

#define A_PCIE_SERDES_STATUS1 0xb4

#define S_CMULOCK    31
#define V_CMULOCK(x) ((x) << S_CMULOCK)
#define F_CMULOCK    V_CMULOCK(1U)

#define S_RXKLOCKLANE7    23
#define V_RXKLOCKLANE7(x) ((x) << S_RXKLOCKLANE7)
#define F_RXKLOCKLANE7    V_RXKLOCKLANE7(1U)

#define S_RXKLOCKLANE6    22
#define V_RXKLOCKLANE6(x) ((x) << S_RXKLOCKLANE6)
#define F_RXKLOCKLANE6    V_RXKLOCKLANE6(1U)

#define S_RXKLOCKLANE5    21
#define V_RXKLOCKLANE5(x) ((x) << S_RXKLOCKLANE5)
#define F_RXKLOCKLANE5    V_RXKLOCKLANE5(1U)

#define S_RXKLOCKLANE4    20
#define V_RXKLOCKLANE4(x) ((x) << S_RXKLOCKLANE4)
#define F_RXKLOCKLANE4    V_RXKLOCKLANE4(1U)

#define S_PCIE_RXKLOCKLANE3    19
#define V_PCIE_RXKLOCKLANE3(x) ((x) << S_PCIE_RXKLOCKLANE3)
#define F_PCIE_RXKLOCKLANE3    V_PCIE_RXKLOCKLANE3(1U)

#define S_PCIE_RXKLOCKLANE2    18
#define V_PCIE_RXKLOCKLANE2(x) ((x) << S_PCIE_RXKLOCKLANE2)
#define F_PCIE_RXKLOCKLANE2    V_PCIE_RXKLOCKLANE2(1U)

#define S_PCIE_RXKLOCKLANE1    17
#define V_PCIE_RXKLOCKLANE1(x) ((x) << S_PCIE_RXKLOCKLANE1)
#define F_PCIE_RXKLOCKLANE1    V_PCIE_RXKLOCKLANE1(1U)

#define S_PCIE_RXKLOCKLANE0    16
#define V_PCIE_RXKLOCKLANE0(x) ((x) << S_PCIE_RXKLOCKLANE0)
#define F_PCIE_RXKLOCKLANE0    V_PCIE_RXKLOCKLANE0(1U)

#define S_RXUFLOWLANE7    15
#define V_RXUFLOWLANE7(x) ((x) << S_RXUFLOWLANE7)
#define F_RXUFLOWLANE7    V_RXUFLOWLANE7(1U)

#define S_RXUFLOWLANE6    14
#define V_RXUFLOWLANE6(x) ((x) << S_RXUFLOWLANE6)
#define F_RXUFLOWLANE6    V_RXUFLOWLANE6(1U)

#define S_RXUFLOWLANE5    13
#define V_RXUFLOWLANE5(x) ((x) << S_RXUFLOWLANE5)
#define F_RXUFLOWLANE5    V_RXUFLOWLANE5(1U)

#define S_RXUFLOWLANE4    12
#define V_RXUFLOWLANE4(x) ((x) << S_RXUFLOWLANE4)
#define F_RXUFLOWLANE4    V_RXUFLOWLANE4(1U)

#define S_PCIE_RXUFLOWLANE3    11
#define V_PCIE_RXUFLOWLANE3(x) ((x) << S_PCIE_RXUFLOWLANE3)
#define F_PCIE_RXUFLOWLANE3    V_PCIE_RXUFLOWLANE3(1U)

#define S_PCIE_RXUFLOWLANE2    10
#define V_PCIE_RXUFLOWLANE2(x) ((x) << S_PCIE_RXUFLOWLANE2)
#define F_PCIE_RXUFLOWLANE2    V_PCIE_RXUFLOWLANE2(1U)

#define S_PCIE_RXUFLOWLANE1    9
#define V_PCIE_RXUFLOWLANE1(x) ((x) << S_PCIE_RXUFLOWLANE1)
#define F_PCIE_RXUFLOWLANE1    V_PCIE_RXUFLOWLANE1(1U)

#define S_PCIE_RXUFLOWLANE0    8
#define V_PCIE_RXUFLOWLANE0(x) ((x) << S_PCIE_RXUFLOWLANE0)
#define F_PCIE_RXUFLOWLANE0    V_PCIE_RXUFLOWLANE0(1U)

#define S_RXOFLOWLANE7    7
#define V_RXOFLOWLANE7(x) ((x) << S_RXOFLOWLANE7)
#define F_RXOFLOWLANE7    V_RXOFLOWLANE7(1U)

#define S_RXOFLOWLANE6    6
#define V_RXOFLOWLANE6(x) ((x) << S_RXOFLOWLANE6)
#define F_RXOFLOWLANE6    V_RXOFLOWLANE6(1U)

#define S_RXOFLOWLANE5    5
#define V_RXOFLOWLANE5(x) ((x) << S_RXOFLOWLANE5)
#define F_RXOFLOWLANE5    V_RXOFLOWLANE5(1U)

#define S_RXOFLOWLANE4    4
#define V_RXOFLOWLANE4(x) ((x) << S_RXOFLOWLANE4)
#define F_RXOFLOWLANE4    V_RXOFLOWLANE4(1U)

#define S_PCIE_RXOFLOWLANE3    3
#define V_PCIE_RXOFLOWLANE3(x) ((x) << S_PCIE_RXOFLOWLANE3)
#define F_PCIE_RXOFLOWLANE3    V_PCIE_RXOFLOWLANE3(1U)

#define S_PCIE_RXOFLOWLANE2    2
#define V_PCIE_RXOFLOWLANE2(x) ((x) << S_PCIE_RXOFLOWLANE2)
#define F_PCIE_RXOFLOWLANE2    V_PCIE_RXOFLOWLANE2(1U)

#define S_PCIE_RXOFLOWLANE1    1
#define V_PCIE_RXOFLOWLANE1(x) ((x) << S_PCIE_RXOFLOWLANE1)
#define F_PCIE_RXOFLOWLANE1    V_PCIE_RXOFLOWLANE1(1U)

#define S_PCIE_RXOFLOWLANE0    0
#define V_PCIE_RXOFLOWLANE0(x) ((x) << S_PCIE_RXOFLOWLANE0)
#define F_PCIE_RXOFLOWLANE0    V_PCIE_RXOFLOWLANE0(1U)

#define A_PCIE_SERDES_LANE_STAT 0xb8

#define S_EXTBISTCHKERRCNT    8
#define M_EXTBISTCHKERRCNT    0xffffff
#define V_EXTBISTCHKERRCNT(x) ((x) << S_EXTBISTCHKERRCNT)
#define G_EXTBISTCHKERRCNT(x) (((x) >> S_EXTBISTCHKERRCNT) & M_EXTBISTCHKERRCNT)

#define S_EXTBISTCHKFMD    7
#define V_EXTBISTCHKFMD(x) ((x) << S_EXTBISTCHKFMD)
#define F_EXTBISTCHKFMD    V_EXTBISTCHKFMD(1U)

#define S_BEACONDETECTCHG    6
#define V_BEACONDETECTCHG(x) ((x) << S_BEACONDETECTCHG)
#define F_BEACONDETECTCHG    V_BEACONDETECTCHG(1U)

#define S_RXDETECTCHG    5
#define V_RXDETECTCHG(x) ((x) << S_RXDETECTCHG)
#define F_RXDETECTCHG    V_RXDETECTCHG(1U)

#define S_TXIDLEDETECTCHG    4
#define V_TXIDLEDETECTCHG(x) ((x) << S_TXIDLEDETECTCHG)
#define F_TXIDLEDETECTCHG    V_TXIDLEDETECTCHG(1U)

#define S_BEACONDETECT    2
#define V_BEACONDETECT(x) ((x) << S_BEACONDETECT)
#define F_BEACONDETECT    V_BEACONDETECT(1U)

#define S_RXDETECT    1
#define V_RXDETECT(x) ((x) << S_RXDETECT)
#define F_RXDETECT    V_RXDETECT(1U)

#define S_TXIDLEDETECT    0
#define V_TXIDLEDETECT(x) ((x) << S_TXIDLEDETECT)
#define F_TXIDLEDETECT    V_TXIDLEDETECT(1U)

#define A_PCIE_SERDES_STATUS2 0xb8

#define S_TXRECDETLANE7    31
#define V_TXRECDETLANE7(x) ((x) << S_TXRECDETLANE7)
#define F_TXRECDETLANE7    V_TXRECDETLANE7(1U)

#define S_TXRECDETLANE6    30
#define V_TXRECDETLANE6(x) ((x) << S_TXRECDETLANE6)
#define F_TXRECDETLANE6    V_TXRECDETLANE6(1U)

#define S_TXRECDETLANE5    29
#define V_TXRECDETLANE5(x) ((x) << S_TXRECDETLANE5)
#define F_TXRECDETLANE5    V_TXRECDETLANE5(1U)

#define S_TXRECDETLANE4    28
#define V_TXRECDETLANE4(x) ((x) << S_TXRECDETLANE4)
#define F_TXRECDETLANE4    V_TXRECDETLANE4(1U)

#define S_TXRECDETLANE3    27
#define V_TXRECDETLANE3(x) ((x) << S_TXRECDETLANE3)
#define F_TXRECDETLANE3    V_TXRECDETLANE3(1U)

#define S_TXRECDETLANE2    26
#define V_TXRECDETLANE2(x) ((x) << S_TXRECDETLANE2)
#define F_TXRECDETLANE2    V_TXRECDETLANE2(1U)

#define S_TXRECDETLANE1    25
#define V_TXRECDETLANE1(x) ((x) << S_TXRECDETLANE1)
#define F_TXRECDETLANE1    V_TXRECDETLANE1(1U)

#define S_TXRECDETLANE0    24
#define V_TXRECDETLANE0(x) ((x) << S_TXRECDETLANE0)
#define F_TXRECDETLANE0    V_TXRECDETLANE0(1U)

#define S_RXEIDLANE7    23
#define V_RXEIDLANE7(x) ((x) << S_RXEIDLANE7)
#define F_RXEIDLANE7    V_RXEIDLANE7(1U)

#define S_RXEIDLANE6    22
#define V_RXEIDLANE6(x) ((x) << S_RXEIDLANE6)
#define F_RXEIDLANE6    V_RXEIDLANE6(1U)

#define S_RXEIDLANE5    21
#define V_RXEIDLANE5(x) ((x) << S_RXEIDLANE5)
#define F_RXEIDLANE5    V_RXEIDLANE5(1U)

#define S_RXEIDLANE4    20
#define V_RXEIDLANE4(x) ((x) << S_RXEIDLANE4)
#define F_RXEIDLANE4    V_RXEIDLANE4(1U)

#define S_RXEIDLANE3    19
#define V_RXEIDLANE3(x) ((x) << S_RXEIDLANE3)
#define F_RXEIDLANE3    V_RXEIDLANE3(1U)

#define S_RXEIDLANE2    18
#define V_RXEIDLANE2(x) ((x) << S_RXEIDLANE2)
#define F_RXEIDLANE2    V_RXEIDLANE2(1U)

#define S_RXEIDLANE1    17
#define V_RXEIDLANE1(x) ((x) << S_RXEIDLANE1)
#define F_RXEIDLANE1    V_RXEIDLANE1(1U)

#define S_RXEIDLANE0    16
#define V_RXEIDLANE0(x) ((x) << S_RXEIDLANE0)
#define F_RXEIDLANE0    V_RXEIDLANE0(1U)

#define S_RXREMSKIPLANE7    15
#define V_RXREMSKIPLANE7(x) ((x) << S_RXREMSKIPLANE7)
#define F_RXREMSKIPLANE7    V_RXREMSKIPLANE7(1U)

#define S_RXREMSKIPLANE6    14
#define V_RXREMSKIPLANE6(x) ((x) << S_RXREMSKIPLANE6)
#define F_RXREMSKIPLANE6    V_RXREMSKIPLANE6(1U)

#define S_RXREMSKIPLANE5    13
#define V_RXREMSKIPLANE5(x) ((x) << S_RXREMSKIPLANE5)
#define F_RXREMSKIPLANE5    V_RXREMSKIPLANE5(1U)

#define S_RXREMSKIPLANE4    12
#define V_RXREMSKIPLANE4(x) ((x) << S_RXREMSKIPLANE4)
#define F_RXREMSKIPLANE4    V_RXREMSKIPLANE4(1U)

#define S_PCIE_RXREMSKIPLANE3    11
#define V_PCIE_RXREMSKIPLANE3(x) ((x) << S_PCIE_RXREMSKIPLANE3)
#define F_PCIE_RXREMSKIPLANE3    V_PCIE_RXREMSKIPLANE3(1U)

#define S_PCIE_RXREMSKIPLANE2    10
#define V_PCIE_RXREMSKIPLANE2(x) ((x) << S_PCIE_RXREMSKIPLANE2)
#define F_PCIE_RXREMSKIPLANE2    V_PCIE_RXREMSKIPLANE2(1U)

#define S_PCIE_RXREMSKIPLANE1    9
#define V_PCIE_RXREMSKIPLANE1(x) ((x) << S_PCIE_RXREMSKIPLANE1)
#define F_PCIE_RXREMSKIPLANE1    V_PCIE_RXREMSKIPLANE1(1U)

#define S_PCIE_RXREMSKIPLANE0    8
#define V_PCIE_RXREMSKIPLANE0(x) ((x) << S_PCIE_RXREMSKIPLANE0)
#define F_PCIE_RXREMSKIPLANE0    V_PCIE_RXREMSKIPLANE0(1U)

#define S_RXADDSKIPLANE7    7
#define V_RXADDSKIPLANE7(x) ((x) << S_RXADDSKIPLANE7)
#define F_RXADDSKIPLANE7    V_RXADDSKIPLANE7(1U)

#define S_RXADDSKIPLANE6    6
#define V_RXADDSKIPLANE6(x) ((x) << S_RXADDSKIPLANE6)
#define F_RXADDSKIPLANE6    V_RXADDSKIPLANE6(1U)

#define S_RXADDSKIPLANE5    5
#define V_RXADDSKIPLANE5(x) ((x) << S_RXADDSKIPLANE5)
#define F_RXADDSKIPLANE5    V_RXADDSKIPLANE5(1U)

#define S_RXADDSKIPLANE4    4
#define V_RXADDSKIPLANE4(x) ((x) << S_RXADDSKIPLANE4)
#define F_RXADDSKIPLANE4    V_RXADDSKIPLANE4(1U)

#define S_PCIE_RXADDSKIPLANE3    3
#define V_PCIE_RXADDSKIPLANE3(x) ((x) << S_PCIE_RXADDSKIPLANE3)
#define F_PCIE_RXADDSKIPLANE3    V_PCIE_RXADDSKIPLANE3(1U)

#define S_PCIE_RXADDSKIPLANE2    2
#define V_PCIE_RXADDSKIPLANE2(x) ((x) << S_PCIE_RXADDSKIPLANE2)
#define F_PCIE_RXADDSKIPLANE2    V_PCIE_RXADDSKIPLANE2(1U)

#define S_PCIE_RXADDSKIPLANE1    1
#define V_PCIE_RXADDSKIPLANE1(x) ((x) << S_PCIE_RXADDSKIPLANE1)
#define F_PCIE_RXADDSKIPLANE1    V_PCIE_RXADDSKIPLANE1(1U)

#define S_PCIE_RXADDSKIPLANE0    0
#define V_PCIE_RXADDSKIPLANE0(x) ((x) << S_PCIE_RXADDSKIPLANE0)
#define F_PCIE_RXADDSKIPLANE0    V_PCIE_RXADDSKIPLANE0(1U)

#define A_PCIE_PEX_WMARK 0xbc

#define S_P_WMARK    18
#define M_P_WMARK    0x7ff
#define V_P_WMARK(x) ((x) << S_P_WMARK)
#define G_P_WMARK(x) (((x) >> S_P_WMARK) & M_P_WMARK)

#define S_NP_WMARK    11
#define M_NP_WMARK    0x7f
#define V_NP_WMARK(x) ((x) << S_NP_WMARK)
#define G_NP_WMARK(x) (((x) >> S_NP_WMARK) & M_NP_WMARK)

#define S_CPL_WMARK    0
#define M_CPL_WMARK    0x7ff
#define V_CPL_WMARK(x) ((x) << S_CPL_WMARK)
#define G_CPL_WMARK(x) (((x) >> S_CPL_WMARK) & M_CPL_WMARK)

#define A_PCIE_SERDES_BIST 0xbc

#define S_PCIE_BISTDONE    24
#define M_PCIE_BISTDONE    0xff
#define V_PCIE_BISTDONE(x) ((x) << S_PCIE_BISTDONE)
#define G_PCIE_BISTDONE(x) (((x) >> S_PCIE_BISTDONE) & M_PCIE_BISTDONE)

#define S_PCIE_BISTCYCLETHRESH    3
#define M_PCIE_BISTCYCLETHRESH    0xffff
#define V_PCIE_BISTCYCLETHRESH(x) ((x) << S_PCIE_BISTCYCLETHRESH)
#define G_PCIE_BISTCYCLETHRESH(x) (((x) >> S_PCIE_BISTCYCLETHRESH) & M_PCIE_BISTCYCLETHRESH)

#define S_BISTMODE    0
#define M_BISTMODE    0x7
#define V_BISTMODE(x) ((x) << S_BISTMODE)
#define G_BISTMODE(x) (((x) >> S_BISTMODE) & M_BISTMODE)

/* registers for module T3DBG */
#define T3DBG_BASE_ADDR 0xc0

#define A_T3DBG_DBG0_CFG 0xc0

#define S_REGSELECT    9
#define M_REGSELECT    0xff
#define V_REGSELECT(x) ((x) << S_REGSELECT)
#define G_REGSELECT(x) (((x) >> S_REGSELECT) & M_REGSELECT)

#define S_MODULESELECT    4
#define M_MODULESELECT    0x1f
#define V_MODULESELECT(x) ((x) << S_MODULESELECT)
#define G_MODULESELECT(x) (((x) >> S_MODULESELECT) & M_MODULESELECT)

#define S_CLKSELECT    0
#define M_CLKSELECT    0xf
#define V_CLKSELECT(x) ((x) << S_CLKSELECT)
#define G_CLKSELECT(x) (((x) >> S_CLKSELECT) & M_CLKSELECT)

#define A_T3DBG_DBG0_EN 0xc4

#define S_SDRBYTE0    8
#define V_SDRBYTE0(x) ((x) << S_SDRBYTE0)
#define F_SDRBYTE0    V_SDRBYTE0(1U)

#define S_DDREN    4
#define V_DDREN(x) ((x) << S_DDREN)
#define F_DDREN    V_DDREN(1U)

#define S_PORTEN    0
#define V_PORTEN(x) ((x) << S_PORTEN)
#define F_PORTEN    V_PORTEN(1U)

#define A_T3DBG_DBG1_CFG 0xc8
#define A_T3DBG_DBG1_EN 0xcc
#define A_T3DBG_GPIO_EN 0xd0

#define S_GPIO11_OEN    27
#define V_GPIO11_OEN(x) ((x) << S_GPIO11_OEN)
#define F_GPIO11_OEN    V_GPIO11_OEN(1U)

#define S_GPIO10_OEN    26
#define V_GPIO10_OEN(x) ((x) << S_GPIO10_OEN)
#define F_GPIO10_OEN    V_GPIO10_OEN(1U)

#define S_GPIO9_OEN    25
#define V_GPIO9_OEN(x) ((x) << S_GPIO9_OEN)
#define F_GPIO9_OEN    V_GPIO9_OEN(1U)

#define S_GPIO8_OEN    24
#define V_GPIO8_OEN(x) ((x) << S_GPIO8_OEN)
#define F_GPIO8_OEN    V_GPIO8_OEN(1U)

#define S_GPIO7_OEN    23
#define V_GPIO7_OEN(x) ((x) << S_GPIO7_OEN)
#define F_GPIO7_OEN    V_GPIO7_OEN(1U)

#define S_GPIO6_OEN    22
#define V_GPIO6_OEN(x) ((x) << S_GPIO6_OEN)
#define F_GPIO6_OEN    V_GPIO6_OEN(1U)

#define S_GPIO5_OEN    21
#define V_GPIO5_OEN(x) ((x) << S_GPIO5_OEN)
#define F_GPIO5_OEN    V_GPIO5_OEN(1U)

#define S_GPIO4_OEN    20
#define V_GPIO4_OEN(x) ((x) << S_GPIO4_OEN)
#define F_GPIO4_OEN    V_GPIO4_OEN(1U)

#define S_GPIO3_OEN    19
#define V_GPIO3_OEN(x) ((x) << S_GPIO3_OEN)
#define F_GPIO3_OEN    V_GPIO3_OEN(1U)

#define S_GPIO2_OEN    18
#define V_GPIO2_OEN(x) ((x) << S_GPIO2_OEN)
#define F_GPIO2_OEN    V_GPIO2_OEN(1U)

#define S_GPIO1_OEN    17
#define V_GPIO1_OEN(x) ((x) << S_GPIO1_OEN)
#define F_GPIO1_OEN    V_GPIO1_OEN(1U)

#define S_GPIO0_OEN    16
#define V_GPIO0_OEN(x) ((x) << S_GPIO0_OEN)
#define F_GPIO0_OEN    V_GPIO0_OEN(1U)

#define S_GPIO11_OUT_VAL    11
#define V_GPIO11_OUT_VAL(x) ((x) << S_GPIO11_OUT_VAL)
#define F_GPIO11_OUT_VAL    V_GPIO11_OUT_VAL(1U)

#define S_GPIO10_OUT_VAL    10
#define V_GPIO10_OUT_VAL(x) ((x) << S_GPIO10_OUT_VAL)
#define F_GPIO10_OUT_VAL    V_GPIO10_OUT_VAL(1U)

#define S_GPIO9_OUT_VAL    9
#define V_GPIO9_OUT_VAL(x) ((x) << S_GPIO9_OUT_VAL)
#define F_GPIO9_OUT_VAL    V_GPIO9_OUT_VAL(1U)

#define S_GPIO8_OUT_VAL    8
#define V_GPIO8_OUT_VAL(x) ((x) << S_GPIO8_OUT_VAL)
#define F_GPIO8_OUT_VAL    V_GPIO8_OUT_VAL(1U)

#define S_GPIO7_OUT_VAL    7
#define V_GPIO7_OUT_VAL(x) ((x) << S_GPIO7_OUT_VAL)
#define F_GPIO7_OUT_VAL    V_GPIO7_OUT_VAL(1U)

#define S_GPIO6_OUT_VAL    6
#define V_GPIO6_OUT_VAL(x) ((x) << S_GPIO6_OUT_VAL)
#define F_GPIO6_OUT_VAL    V_GPIO6_OUT_VAL(1U)

#define S_GPIO5_OUT_VAL    5
#define V_GPIO5_OUT_VAL(x) ((x) << S_GPIO5_OUT_VAL)
#define F_GPIO5_OUT_VAL    V_GPIO5_OUT_VAL(1U)

#define S_GPIO4_OUT_VAL    4
#define V_GPIO4_OUT_VAL(x) ((x) << S_GPIO4_OUT_VAL)
#define F_GPIO4_OUT_VAL    V_GPIO4_OUT_VAL(1U)

#define S_GPIO3_OUT_VAL    3
#define V_GPIO3_OUT_VAL(x) ((x) << S_GPIO3_OUT_VAL)
#define F_GPIO3_OUT_VAL    V_GPIO3_OUT_VAL(1U)

#define S_GPIO2_OUT_VAL    2
#define V_GPIO2_OUT_VAL(x) ((x) << S_GPIO2_OUT_VAL)
#define F_GPIO2_OUT_VAL    V_GPIO2_OUT_VAL(1U)

#define S_GPIO1_OUT_VAL    1
#define V_GPIO1_OUT_VAL(x) ((x) << S_GPIO1_OUT_VAL)
#define F_GPIO1_OUT_VAL    V_GPIO1_OUT_VAL(1U)

#define S_GPIO0_OUT_VAL    0
#define V_GPIO0_OUT_VAL(x) ((x) << S_GPIO0_OUT_VAL)
#define F_GPIO0_OUT_VAL    V_GPIO0_OUT_VAL(1U)

#define A_T3DBG_GPIO_IN 0xd4

#define S_GPIO11_CHG_DET    27
#define V_GPIO11_CHG_DET(x) ((x) << S_GPIO11_CHG_DET)
#define F_GPIO11_CHG_DET    V_GPIO11_CHG_DET(1U)

#define S_GPIO10_CHG_DET    26
#define V_GPIO10_CHG_DET(x) ((x) << S_GPIO10_CHG_DET)
#define F_GPIO10_CHG_DET    V_GPIO10_CHG_DET(1U)

#define S_GPIO9_CHG_DET    25
#define V_GPIO9_CHG_DET(x) ((x) << S_GPIO9_CHG_DET)
#define F_GPIO9_CHG_DET    V_GPIO9_CHG_DET(1U)

#define S_GPIO8_CHG_DET    24
#define V_GPIO8_CHG_DET(x) ((x) << S_GPIO8_CHG_DET)
#define F_GPIO8_CHG_DET    V_GPIO8_CHG_DET(1U)

#define S_GPIO7_CHG_DET    23
#define V_GPIO7_CHG_DET(x) ((x) << S_GPIO7_CHG_DET)
#define F_GPIO7_CHG_DET    V_GPIO7_CHG_DET(1U)

#define S_GPIO6_CHG_DET    22
#define V_GPIO6_CHG_DET(x) ((x) << S_GPIO6_CHG_DET)
#define F_GPIO6_CHG_DET    V_GPIO6_CHG_DET(1U)

#define S_GPIO5_CHG_DET    21
#define V_GPIO5_CHG_DET(x) ((x) << S_GPIO5_CHG_DET)
#define F_GPIO5_CHG_DET    V_GPIO5_CHG_DET(1U)

#define S_GPIO4_CHG_DET    20
#define V_GPIO4_CHG_DET(x) ((x) << S_GPIO4_CHG_DET)
#define F_GPIO4_CHG_DET    V_GPIO4_CHG_DET(1U)

#define S_GPIO3_CHG_DET    19
#define V_GPIO3_CHG_DET(x) ((x) << S_GPIO3_CHG_DET)
#define F_GPIO3_CHG_DET    V_GPIO3_CHG_DET(1U)

#define S_GPIO2_CHG_DET    18
#define V_GPIO2_CHG_DET(x) ((x) << S_GPIO2_CHG_DET)
#define F_GPIO2_CHG_DET    V_GPIO2_CHG_DET(1U)

#define S_GPIO1_CHG_DET    17
#define V_GPIO1_CHG_DET(x) ((x) << S_GPIO1_CHG_DET)
#define F_GPIO1_CHG_DET    V_GPIO1_CHG_DET(1U)

#define S_GPIO0_CHG_DET    16
#define V_GPIO0_CHG_DET(x) ((x) << S_GPIO0_CHG_DET)
#define F_GPIO0_CHG_DET    V_GPIO0_CHG_DET(1U)

#define S_GPIO11_IN    11
#define V_GPIO11_IN(x) ((x) << S_GPIO11_IN)
#define F_GPIO11_IN    V_GPIO11_IN(1U)

#define S_GPIO10_IN    10
#define V_GPIO10_IN(x) ((x) << S_GPIO10_IN)
#define F_GPIO10_IN    V_GPIO10_IN(1U)

#define S_GPIO9_IN    9
#define V_GPIO9_IN(x) ((x) << S_GPIO9_IN)
#define F_GPIO9_IN    V_GPIO9_IN(1U)

#define S_GPIO8_IN    8
#define V_GPIO8_IN(x) ((x) << S_GPIO8_IN)
#define F_GPIO8_IN    V_GPIO8_IN(1U)

#define S_GPIO7_IN    7
#define V_GPIO7_IN(x) ((x) << S_GPIO7_IN)
#define F_GPIO7_IN    V_GPIO7_IN(1U)

#define S_GPIO6_IN    6
#define V_GPIO6_IN(x) ((x) << S_GPIO6_IN)
#define F_GPIO6_IN    V_GPIO6_IN(1U)

#define S_GPIO5_IN    5
#define V_GPIO5_IN(x) ((x) << S_GPIO5_IN)
#define F_GPIO5_IN    V_GPIO5_IN(1U)

#define S_GPIO4_IN    4
#define V_GPIO4_IN(x) ((x) << S_GPIO4_IN)
#define F_GPIO4_IN    V_GPIO4_IN(1U)

#define S_GPIO3_IN    3
#define V_GPIO3_IN(x) ((x) << S_GPIO3_IN)
#define F_GPIO3_IN    V_GPIO3_IN(1U)

#define S_GPIO2_IN    2
#define V_GPIO2_IN(x) ((x) << S_GPIO2_IN)
#define F_GPIO2_IN    V_GPIO2_IN(1U)

#define S_GPIO1_IN    1
#define V_GPIO1_IN(x) ((x) << S_GPIO1_IN)
#define F_GPIO1_IN    V_GPIO1_IN(1U)

#define S_GPIO0_IN    0
#define V_GPIO0_IN(x) ((x) << S_GPIO0_IN)
#define F_GPIO0_IN    V_GPIO0_IN(1U)

#define A_T3DBG_INT_ENABLE 0xd8

#define S_C_LOCK    21
#define V_C_LOCK(x) ((x) << S_C_LOCK)
#define F_C_LOCK    V_C_LOCK(1U)

#define S_M_LOCK    20
#define V_M_LOCK(x) ((x) << S_M_LOCK)
#define F_M_LOCK    V_M_LOCK(1U)

#define S_U_LOCK    19
#define V_U_LOCK(x) ((x) << S_U_LOCK)
#define F_U_LOCK    V_U_LOCK(1U)

#define S_R_LOCK    18
#define V_R_LOCK(x) ((x) << S_R_LOCK)
#define F_R_LOCK    V_R_LOCK(1U)

#define S_PX_LOCK    17
#define V_PX_LOCK(x) ((x) << S_PX_LOCK)
#define F_PX_LOCK    V_PX_LOCK(1U)

#define S_GPIO11    11
#define V_GPIO11(x) ((x) << S_GPIO11)
#define F_GPIO11    V_GPIO11(1U)

#define S_GPIO10    10
#define V_GPIO10(x) ((x) << S_GPIO10)
#define F_GPIO10    V_GPIO10(1U)

#define S_GPIO9    9
#define V_GPIO9(x) ((x) << S_GPIO9)
#define F_GPIO9    V_GPIO9(1U)

#define S_GPIO8    8
#define V_GPIO8(x) ((x) << S_GPIO8)
#define F_GPIO8    V_GPIO8(1U)

#define S_GPIO7    7
#define V_GPIO7(x) ((x) << S_GPIO7)
#define F_GPIO7    V_GPIO7(1U)

#define S_GPIO6    6
#define V_GPIO6(x) ((x) << S_GPIO6)
#define F_GPIO6    V_GPIO6(1U)

#define S_GPIO5    5
#define V_GPIO5(x) ((x) << S_GPIO5)
#define F_GPIO5    V_GPIO5(1U)

#define S_GPIO4    4
#define V_GPIO4(x) ((x) << S_GPIO4)
#define F_GPIO4    V_GPIO4(1U)

#define S_GPIO3    3
#define V_GPIO3(x) ((x) << S_GPIO3)
#define F_GPIO3    V_GPIO3(1U)

#define S_GPIO2    2
#define V_GPIO2(x) ((x) << S_GPIO2)
#define F_GPIO2    V_GPIO2(1U)

#define S_GPIO1    1
#define V_GPIO1(x) ((x) << S_GPIO1)
#define F_GPIO1    V_GPIO1(1U)

#define S_GPIO0    0
#define V_GPIO0(x) ((x) << S_GPIO0)
#define F_GPIO0    V_GPIO0(1U)

#define S_PE_LOCK    16
#define V_PE_LOCK(x) ((x) << S_PE_LOCK)
#define F_PE_LOCK    V_PE_LOCK(1U)

#define A_T3DBG_INT_CAUSE 0xdc
#define A_T3DBG_DBG0_RST_VALUE 0xe0

#define S_DEBUGDATA    0
#define M_DEBUGDATA    0xff
#define V_DEBUGDATA(x) ((x) << S_DEBUGDATA)
#define G_DEBUGDATA(x) (((x) >> S_DEBUGDATA) & M_DEBUGDATA)

#define A_T3DBG_PLL_OCLK_PAD_EN 0xe4

#define S_PCIE_OCLK_EN    20
#define V_PCIE_OCLK_EN(x) ((x) << S_PCIE_OCLK_EN)
#define F_PCIE_OCLK_EN    V_PCIE_OCLK_EN(1U)

#define S_PCLKTREE_DBG_EN    17
#define V_PCLKTREE_DBG_EN(x) ((x) << S_PCLKTREE_DBG_EN)
#define F_PCLKTREE_DBG_EN    V_PCLKTREE_DBG_EN(1U)

#define S_PCIX_OCLK_EN    16
#define V_PCIX_OCLK_EN(x) ((x) << S_PCIX_OCLK_EN)
#define F_PCIX_OCLK_EN    V_PCIX_OCLK_EN(1U)

#define S_U_OCLK_EN    12
#define V_U_OCLK_EN(x) ((x) << S_U_OCLK_EN)
#define F_U_OCLK_EN    V_U_OCLK_EN(1U)

#define S_R_OCLK_EN    8
#define V_R_OCLK_EN(x) ((x) << S_R_OCLK_EN)
#define F_R_OCLK_EN    V_R_OCLK_EN(1U)

#define S_M_OCLK_EN    4
#define V_M_OCLK_EN(x) ((x) << S_M_OCLK_EN)
#define F_M_OCLK_EN    V_M_OCLK_EN(1U)

#define S_C_OCLK_EN    0
#define V_C_OCLK_EN(x) ((x) << S_C_OCLK_EN)
#define F_C_OCLK_EN    V_C_OCLK_EN(1U)

#define A_T3DBG_PLL_LOCK 0xe8

#define S_PCIX_LOCK    16
#define V_PCIX_LOCK(x) ((x) << S_PCIX_LOCK)
#define F_PCIX_LOCK    V_PCIX_LOCK(1U)

#define S_PLL_U_LOCK    12
#define V_PLL_U_LOCK(x) ((x) << S_PLL_U_LOCK)
#define F_PLL_U_LOCK    V_PLL_U_LOCK(1U)

#define S_PLL_R_LOCK    8
#define V_PLL_R_LOCK(x) ((x) << S_PLL_R_LOCK)
#define F_PLL_R_LOCK    V_PLL_R_LOCK(1U)

#define S_PLL_M_LOCK    4
#define V_PLL_M_LOCK(x) ((x) << S_PLL_M_LOCK)
#define F_PLL_M_LOCK    V_PLL_M_LOCK(1U)

#define S_PLL_C_LOCK    0
#define V_PLL_C_LOCK(x) ((x) << S_PLL_C_LOCK)
#define F_PLL_C_LOCK    V_PLL_C_LOCK(1U)

#define S_PCIE_LOCK    20
#define V_PCIE_LOCK(x) ((x) << S_PCIE_LOCK)
#define F_PCIE_LOCK    V_PCIE_LOCK(1U)

#define A_T3DBG_SERDES_RBC_CFG 0xec

#define S_X_RBC_LANE_SEL    16
#define M_X_RBC_LANE_SEL    0x3
#define V_X_RBC_LANE_SEL(x) ((x) << S_X_RBC_LANE_SEL)
#define G_X_RBC_LANE_SEL(x) (((x) >> S_X_RBC_LANE_SEL) & M_X_RBC_LANE_SEL)

#define S_X_RBC_DBG_EN    12
#define V_X_RBC_DBG_EN(x) ((x) << S_X_RBC_DBG_EN)
#define F_X_RBC_DBG_EN    V_X_RBC_DBG_EN(1U)

#define S_X_SERDES_SEL    8
#define V_X_SERDES_SEL(x) ((x) << S_X_SERDES_SEL)
#define F_X_SERDES_SEL    V_X_SERDES_SEL(1U)

#define S_PE_RBC_LANE_SEL    4
#define M_PE_RBC_LANE_SEL    0x7
#define V_PE_RBC_LANE_SEL(x) ((x) << S_PE_RBC_LANE_SEL)
#define G_PE_RBC_LANE_SEL(x) (((x) >> S_PE_RBC_LANE_SEL) & M_PE_RBC_LANE_SEL)

#define S_PE_RBC_DBG_EN    0
#define V_PE_RBC_DBG_EN(x) ((x) << S_PE_RBC_DBG_EN)
#define F_PE_RBC_DBG_EN    V_PE_RBC_DBG_EN(1U)

#define A_T3DBG_GPIO_ACT_LOW 0xf0

#define S_C_LOCK_ACT_LOW    21
#define V_C_LOCK_ACT_LOW(x) ((x) << S_C_LOCK_ACT_LOW)
#define F_C_LOCK_ACT_LOW    V_C_LOCK_ACT_LOW(1U)

#define S_M_LOCK_ACT_LOW    20
#define V_M_LOCK_ACT_LOW(x) ((x) << S_M_LOCK_ACT_LOW)
#define F_M_LOCK_ACT_LOW    V_M_LOCK_ACT_LOW(1U)

#define S_U_LOCK_ACT_LOW    19
#define V_U_LOCK_ACT_LOW(x) ((x) << S_U_LOCK_ACT_LOW)
#define F_U_LOCK_ACT_LOW    V_U_LOCK_ACT_LOW(1U)

#define S_R_LOCK_ACT_LOW    18
#define V_R_LOCK_ACT_LOW(x) ((x) << S_R_LOCK_ACT_LOW)
#define F_R_LOCK_ACT_LOW    V_R_LOCK_ACT_LOW(1U)

#define S_PX_LOCK_ACT_LOW    17
#define V_PX_LOCK_ACT_LOW(x) ((x) << S_PX_LOCK_ACT_LOW)
#define F_PX_LOCK_ACT_LOW    V_PX_LOCK_ACT_LOW(1U)

#define S_GPIO11_ACT_LOW    11
#define V_GPIO11_ACT_LOW(x) ((x) << S_GPIO11_ACT_LOW)
#define F_GPIO11_ACT_LOW    V_GPIO11_ACT_LOW(1U)

#define S_GPIO10_ACT_LOW    10
#define V_GPIO10_ACT_LOW(x) ((x) << S_GPIO10_ACT_LOW)
#define F_GPIO10_ACT_LOW    V_GPIO10_ACT_LOW(1U)

#define S_GPIO9_ACT_LOW    9
#define V_GPIO9_ACT_LOW(x) ((x) << S_GPIO9_ACT_LOW)
#define F_GPIO9_ACT_LOW    V_GPIO9_ACT_LOW(1U)

#define S_GPIO8_ACT_LOW    8
#define V_GPIO8_ACT_LOW(x) ((x) << S_GPIO8_ACT_LOW)
#define F_GPIO8_ACT_LOW    V_GPIO8_ACT_LOW(1U)

#define S_GPIO7_ACT_LOW    7
#define V_GPIO7_ACT_LOW(x) ((x) << S_GPIO7_ACT_LOW)
#define F_GPIO7_ACT_LOW    V_GPIO7_ACT_LOW(1U)

#define S_GPIO6_ACT_LOW    6
#define V_GPIO6_ACT_LOW(x) ((x) << S_GPIO6_ACT_LOW)
#define F_GPIO6_ACT_LOW    V_GPIO6_ACT_LOW(1U)

#define S_GPIO5_ACT_LOW    5
#define V_GPIO5_ACT_LOW(x) ((x) << S_GPIO5_ACT_LOW)
#define F_GPIO5_ACT_LOW    V_GPIO5_ACT_LOW(1U)

#define S_GPIO4_ACT_LOW    4
#define V_GPIO4_ACT_LOW(x) ((x) << S_GPIO4_ACT_LOW)
#define F_GPIO4_ACT_LOW    V_GPIO4_ACT_LOW(1U)

#define S_GPIO3_ACT_LOW    3
#define V_GPIO3_ACT_LOW(x) ((x) << S_GPIO3_ACT_LOW)
#define F_GPIO3_ACT_LOW    V_GPIO3_ACT_LOW(1U)

#define S_GPIO2_ACT_LOW    2
#define V_GPIO2_ACT_LOW(x) ((x) << S_GPIO2_ACT_LOW)
#define F_GPIO2_ACT_LOW    V_GPIO2_ACT_LOW(1U)

#define S_GPIO1_ACT_LOW    1
#define V_GPIO1_ACT_LOW(x) ((x) << S_GPIO1_ACT_LOW)
#define F_GPIO1_ACT_LOW    V_GPIO1_ACT_LOW(1U)

#define S_GPIO0_ACT_LOW    0
#define V_GPIO0_ACT_LOW(x) ((x) << S_GPIO0_ACT_LOW)
#define F_GPIO0_ACT_LOW    V_GPIO0_ACT_LOW(1U)

#define S_PE_LOCK_ACT_LOW    16
#define V_PE_LOCK_ACT_LOW(x) ((x) << S_PE_LOCK_ACT_LOW)
#define F_PE_LOCK_ACT_LOW    V_PE_LOCK_ACT_LOW(1U)

#define A_T3DBG_PMON_CFG 0xf4

#define S_PMON_DONE    29
#define V_PMON_DONE(x) ((x) << S_PMON_DONE)
#define F_PMON_DONE    V_PMON_DONE(1U)

#define S_PMON_FAIL    28
#define V_PMON_FAIL(x) ((x) << S_PMON_FAIL)
#define F_PMON_FAIL    V_PMON_FAIL(1U)

#define S_PMON_FDEL_AUTO    22
#define M_PMON_FDEL_AUTO    0x3f
#define V_PMON_FDEL_AUTO(x) ((x) << S_PMON_FDEL_AUTO)
#define G_PMON_FDEL_AUTO(x) (((x) >> S_PMON_FDEL_AUTO) & M_PMON_FDEL_AUTO)

#define S_PMON_CDEL_AUTO    16
#define M_PMON_CDEL_AUTO    0x3f
#define V_PMON_CDEL_AUTO(x) ((x) << S_PMON_CDEL_AUTO)
#define G_PMON_CDEL_AUTO(x) (((x) >> S_PMON_CDEL_AUTO) & M_PMON_CDEL_AUTO)

#define S_PMON_FDEL_MANUAL    10
#define M_PMON_FDEL_MANUAL    0x3f
#define V_PMON_FDEL_MANUAL(x) ((x) << S_PMON_FDEL_MANUAL)
#define G_PMON_FDEL_MANUAL(x) (((x) >> S_PMON_FDEL_MANUAL) & M_PMON_FDEL_MANUAL)

#define S_PMON_CDEL_MANUAL    4
#define M_PMON_CDEL_MANUAL    0x3f
#define V_PMON_CDEL_MANUAL(x) ((x) << S_PMON_CDEL_MANUAL)
#define G_PMON_CDEL_MANUAL(x) (((x) >> S_PMON_CDEL_MANUAL) & M_PMON_CDEL_MANUAL)

#define S_PMON_MANUAL    1
#define V_PMON_MANUAL(x) ((x) << S_PMON_MANUAL)
#define F_PMON_MANUAL    V_PMON_MANUAL(1U)

#define S_PMON_AUTO    0
#define V_PMON_AUTO(x) ((x) << S_PMON_AUTO)
#define F_PMON_AUTO    V_PMON_AUTO(1U)

#define A_T3DBG_SERDES_REFCLK_CFG 0xf8

#define S_PE_REFCLK_DBG_EN    12
#define V_PE_REFCLK_DBG_EN(x) ((x) << S_PE_REFCLK_DBG_EN)
#define F_PE_REFCLK_DBG_EN    V_PE_REFCLK_DBG_EN(1U)

#define S_X_REFCLK_DBG_EN    8
#define V_X_REFCLK_DBG_EN(x) ((x) << S_X_REFCLK_DBG_EN)
#define F_X_REFCLK_DBG_EN    V_X_REFCLK_DBG_EN(1U)

#define S_PE_REFCLK_TERMADJ    5
#define M_PE_REFCLK_TERMADJ    0x3
#define V_PE_REFCLK_TERMADJ(x) ((x) << S_PE_REFCLK_TERMADJ)
#define G_PE_REFCLK_TERMADJ(x) (((x) >> S_PE_REFCLK_TERMADJ) & M_PE_REFCLK_TERMADJ)

#define S_PE_REFCLK_PD    4
#define V_PE_REFCLK_PD(x) ((x) << S_PE_REFCLK_PD)
#define F_PE_REFCLK_PD    V_PE_REFCLK_PD(1U)

#define S_X_REFCLK_TERMADJ    1
#define M_X_REFCLK_TERMADJ    0x3
#define V_X_REFCLK_TERMADJ(x) ((x) << S_X_REFCLK_TERMADJ)
#define G_X_REFCLK_TERMADJ(x) (((x) >> S_X_REFCLK_TERMADJ) & M_X_REFCLK_TERMADJ)

#define S_X_REFCLK_PD    0
#define V_X_REFCLK_PD(x) ((x) << S_X_REFCLK_PD)
#define F_X_REFCLK_PD    V_X_REFCLK_PD(1U)

#define A_T3DBG_PCIE_PMA_BSPIN_CFG 0xfc

#define S_BSMODEQUAD1    31
#define V_BSMODEQUAD1(x) ((x) << S_BSMODEQUAD1)
#define F_BSMODEQUAD1    V_BSMODEQUAD1(1U)

#define S_BSINSELLANE7    29
#define M_BSINSELLANE7    0x3
#define V_BSINSELLANE7(x) ((x) << S_BSINSELLANE7)
#define G_BSINSELLANE7(x) (((x) >> S_BSINSELLANE7) & M_BSINSELLANE7)

#define S_BSENLANE7    28
#define V_BSENLANE7(x) ((x) << S_BSENLANE7)
#define F_BSENLANE7    V_BSENLANE7(1U)

#define S_BSINSELLANE6    25
#define M_BSINSELLANE6    0x3
#define V_BSINSELLANE6(x) ((x) << S_BSINSELLANE6)
#define G_BSINSELLANE6(x) (((x) >> S_BSINSELLANE6) & M_BSINSELLANE6)

#define S_BSENLANE6    24
#define V_BSENLANE6(x) ((x) << S_BSENLANE6)
#define F_BSENLANE6    V_BSENLANE6(1U)

#define S_BSINSELLANE5    21
#define M_BSINSELLANE5    0x3
#define V_BSINSELLANE5(x) ((x) << S_BSINSELLANE5)
#define G_BSINSELLANE5(x) (((x) >> S_BSINSELLANE5) & M_BSINSELLANE5)

#define S_BSENLANE5    20
#define V_BSENLANE5(x) ((x) << S_BSENLANE5)
#define F_BSENLANE5    V_BSENLANE5(1U)

#define S_BSINSELLANE4    17
#define M_BSINSELLANE4    0x3
#define V_BSINSELLANE4(x) ((x) << S_BSINSELLANE4)
#define G_BSINSELLANE4(x) (((x) >> S_BSINSELLANE4) & M_BSINSELLANE4)

#define S_BSENLANE4    16
#define V_BSENLANE4(x) ((x) << S_BSENLANE4)
#define F_BSENLANE4    V_BSENLANE4(1U)

#define S_BSMODEQUAD0    15
#define V_BSMODEQUAD0(x) ((x) << S_BSMODEQUAD0)
#define F_BSMODEQUAD0    V_BSMODEQUAD0(1U)

#define S_BSINSELLANE3    13
#define M_BSINSELLANE3    0x3
#define V_BSINSELLANE3(x) ((x) << S_BSINSELLANE3)
#define G_BSINSELLANE3(x) (((x) >> S_BSINSELLANE3) & M_BSINSELLANE3)

#define S_BSENLANE3    12
#define V_BSENLANE3(x) ((x) << S_BSENLANE3)
#define F_BSENLANE3    V_BSENLANE3(1U)

#define S_BSINSELLANE2    9
#define M_BSINSELLANE2    0x3
#define V_BSINSELLANE2(x) ((x) << S_BSINSELLANE2)
#define G_BSINSELLANE2(x) (((x) >> S_BSINSELLANE2) & M_BSINSELLANE2)

#define S_BSENLANE2    8
#define V_BSENLANE2(x) ((x) << S_BSENLANE2)
#define F_BSENLANE2    V_BSENLANE2(1U)

#define S_BSINSELLANE1    5
#define M_BSINSELLANE1    0x3
#define V_BSINSELLANE1(x) ((x) << S_BSINSELLANE1)
#define G_BSINSELLANE1(x) (((x) >> S_BSINSELLANE1) & M_BSINSELLANE1)

#define S_BSENLANE1    4
#define V_BSENLANE1(x) ((x) << S_BSENLANE1)
#define F_BSENLANE1    V_BSENLANE1(1U)

#define S_BSINSELLANE0    1
#define M_BSINSELLANE0    0x3
#define V_BSINSELLANE0(x) ((x) << S_BSINSELLANE0)
#define G_BSINSELLANE0(x) (((x) >> S_BSINSELLANE0) & M_BSINSELLANE0)

#define S_BSENLANE0    0
#define V_BSENLANE0(x) ((x) << S_BSENLANE0)
#define F_BSENLANE0    V_BSENLANE0(1U)

/* registers for module MC7_PMRX */
#define MC7_PMRX_BASE_ADDR 0x100

#define A_MC7_CFG 0x100

#define S_IMPSETUPDATE    14
#define V_IMPSETUPDATE(x) ((x) << S_IMPSETUPDATE)
#define F_IMPSETUPDATE    V_IMPSETUPDATE(1U)

#define S_IFEN    13
#define V_IFEN(x) ((x) << S_IFEN)
#define F_IFEN    V_IFEN(1U)

#define S_TERM300    12
#define V_TERM300(x) ((x) << S_TERM300)
#define F_TERM300    V_TERM300(1U)

#define S_TERM150    11
#define V_TERM150(x) ((x) << S_TERM150)
#define F_TERM150    V_TERM150(1U)

#define S_SLOW    10
#define V_SLOW(x) ((x) << S_SLOW)
#define F_SLOW    V_SLOW(1U)

#define S_WIDTH    8
#define M_WIDTH    0x3
#define V_WIDTH(x) ((x) << S_WIDTH)
#define G_WIDTH(x) (((x) >> S_WIDTH) & M_WIDTH)

#define S_ODTEN    7
#define V_ODTEN(x) ((x) << S_ODTEN)
#define F_ODTEN    V_ODTEN(1U)

#define S_BKS    6
#define V_BKS(x) ((x) << S_BKS)
#define F_BKS    V_BKS(1U)

#define S_ORG    5
#define V_ORG(x) ((x) << S_ORG)
#define F_ORG    V_ORG(1U)

#define S_DEN    2
#define M_DEN    0x7
#define V_DEN(x) ((x) << S_DEN)
#define G_DEN(x) (((x) >> S_DEN) & M_DEN)

#define S_RDY    1
#define V_RDY(x) ((x) << S_RDY)
#define F_RDY    V_RDY(1U)

#define S_CLKEN    0
#define V_CLKEN(x) ((x) << S_CLKEN)
#define F_CLKEN    V_CLKEN(1U)

#define A_MC7_MODE 0x104

#define S_MODE    0
#define M_MODE    0xffff
#define V_MODE(x) ((x) << S_MODE)
#define G_MODE(x) (((x) >> S_MODE) & M_MODE)

#define A_MC7_EXT_MODE1 0x108

#define S_OCDADJUSTMODE    20
#define V_OCDADJUSTMODE(x) ((x) << S_OCDADJUSTMODE)
#define F_OCDADJUSTMODE    V_OCDADJUSTMODE(1U)

#define S_OCDCODE    16
#define M_OCDCODE    0xf
#define V_OCDCODE(x) ((x) << S_OCDCODE)
#define G_OCDCODE(x) (((x) >> S_OCDCODE) & M_OCDCODE)

#define S_EXTMODE1    0
#define M_EXTMODE1    0xffff
#define V_EXTMODE1(x) ((x) << S_EXTMODE1)
#define G_EXTMODE1(x) (((x) >> S_EXTMODE1) & M_EXTMODE1)

#define A_MC7_EXT_MODE2 0x10c

#define S_EXTMODE2    0
#define M_EXTMODE2    0xffff
#define V_EXTMODE2(x) ((x) << S_EXTMODE2)
#define G_EXTMODE2(x) (((x) >> S_EXTMODE2) & M_EXTMODE2)

#define A_MC7_EXT_MODE3 0x110

#define S_EXTMODE3    0
#define M_EXTMODE3    0xffff
#define V_EXTMODE3(x) ((x) << S_EXTMODE3)
#define G_EXTMODE3(x) (((x) >> S_EXTMODE3) & M_EXTMODE3)

#define A_MC7_PRE 0x114
#define A_MC7_REF 0x118

#define S_PREREFDIV    1
#define M_PREREFDIV    0x3fff
#define V_PREREFDIV(x) ((x) << S_PREREFDIV)
#define G_PREREFDIV(x) (((x) >> S_PREREFDIV) & M_PREREFDIV)

#define S_PERREFEN    0
#define V_PERREFEN(x) ((x) << S_PERREFEN)
#define F_PERREFEN    V_PERREFEN(1U)

#define A_MC7_DLL 0x11c

#define S_DLLLOCK    31
#define V_DLLLOCK(x) ((x) << S_DLLLOCK)
#define F_DLLLOCK    V_DLLLOCK(1U)

#define S_DLLDELTA    24
#define M_DLLDELTA    0x7f
#define V_DLLDELTA(x) ((x) << S_DLLDELTA)
#define G_DLLDELTA(x) (((x) >> S_DLLDELTA) & M_DLLDELTA)

#define S_MANDELTA    3
#define M_MANDELTA    0x7f
#define V_MANDELTA(x) ((x) << S_MANDELTA)
#define G_MANDELTA(x) (((x) >> S_MANDELTA) & M_MANDELTA)

#define S_DLLDELTASEL    2
#define V_DLLDELTASEL(x) ((x) << S_DLLDELTASEL)
#define F_DLLDELTASEL    V_DLLDELTASEL(1U)

#define S_DLLENB    1
#define V_DLLENB(x) ((x) << S_DLLENB)
#define F_DLLENB    V_DLLENB(1U)

#define S_DLLRST    0
#define V_DLLRST(x) ((x) << S_DLLRST)
#define F_DLLRST    V_DLLRST(1U)

#define A_MC7_PARM 0x120

#define S_ACTTOPREDLY    26
#define M_ACTTOPREDLY    0xf
#define V_ACTTOPREDLY(x) ((x) << S_ACTTOPREDLY)
#define G_ACTTOPREDLY(x) (((x) >> S_ACTTOPREDLY) & M_ACTTOPREDLY)

#define S_ACTTORDWRDLY    23
#define M_ACTTORDWRDLY    0x7
#define V_ACTTORDWRDLY(x) ((x) << S_ACTTORDWRDLY)
#define G_ACTTORDWRDLY(x) (((x) >> S_ACTTORDWRDLY) & M_ACTTORDWRDLY)

#define S_PRECYC    20
#define M_PRECYC    0x7
#define V_PRECYC(x) ((x) << S_PRECYC)
#define G_PRECYC(x) (((x) >> S_PRECYC) & M_PRECYC)

#define S_REFCYC    13
#define M_REFCYC    0x7f
#define V_REFCYC(x) ((x) << S_REFCYC)
#define G_REFCYC(x) (((x) >> S_REFCYC) & M_REFCYC)

#define S_BKCYC    8
#define M_BKCYC    0x1f
#define V_BKCYC(x) ((x) << S_BKCYC)
#define G_BKCYC(x) (((x) >> S_BKCYC) & M_BKCYC)

#define S_WRTORDDLY    4
#define M_WRTORDDLY    0xf
#define V_WRTORDDLY(x) ((x) << S_WRTORDDLY)
#define G_WRTORDDLY(x) (((x) >> S_WRTORDDLY) & M_WRTORDDLY)

#define S_RDTOWRDLY    0
#define M_RDTOWRDLY    0xf
#define V_RDTOWRDLY(x) ((x) << S_RDTOWRDLY)
#define G_RDTOWRDLY(x) (((x) >> S_RDTOWRDLY) & M_RDTOWRDLY)

#define A_MC7_HWM_WRR 0x124

#define S_MEM_HWM    26
#define M_MEM_HWM    0x3f
#define V_MEM_HWM(x) ((x) << S_MEM_HWM)
#define G_MEM_HWM(x) (((x) >> S_MEM_HWM) & M_MEM_HWM)

#define S_ULP_HWM    22
#define M_ULP_HWM    0xf
#define V_ULP_HWM(x) ((x) << S_ULP_HWM)
#define G_ULP_HWM(x) (((x) >> S_ULP_HWM) & M_ULP_HWM)

#define S_TOT_RLD_WT    14
#define M_TOT_RLD_WT    0xff
#define V_TOT_RLD_WT(x) ((x) << S_TOT_RLD_WT)
#define G_TOT_RLD_WT(x) (((x) >> S_TOT_RLD_WT) & M_TOT_RLD_WT)

#define S_MEM_RLD_WT    7
#define M_MEM_RLD_WT    0x7f
#define V_MEM_RLD_WT(x) ((x) << S_MEM_RLD_WT)
#define G_MEM_RLD_WT(x) (((x) >> S_MEM_RLD_WT) & M_MEM_RLD_WT)

#define S_ULP_RLD_WT    0
#define M_ULP_RLD_WT    0x7f
#define V_ULP_RLD_WT(x) ((x) << S_ULP_RLD_WT)
#define G_ULP_RLD_WT(x) (((x) >> S_ULP_RLD_WT) & M_ULP_RLD_WT)

#define A_MC7_CAL 0x128

#define S_BUSY    31
#define V_BUSY(x) ((x) << S_BUSY)
#define F_BUSY    V_BUSY(1U)

#define S_CAL_FAULT    30
#define V_CAL_FAULT(x) ((x) << S_CAL_FAULT)
#define F_CAL_FAULT    V_CAL_FAULT(1U)

#define S_PER_CAL_DIV    22
#define M_PER_CAL_DIV    0xff
#define V_PER_CAL_DIV(x) ((x) << S_PER_CAL_DIV)
#define G_PER_CAL_DIV(x) (((x) >> S_PER_CAL_DIV) & M_PER_CAL_DIV)

#define S_PER_CAL_EN    21
#define V_PER_CAL_EN(x) ((x) << S_PER_CAL_EN)
#define F_PER_CAL_EN    V_PER_CAL_EN(1U)

#define S_SGL_CAL_EN    20
#define V_SGL_CAL_EN(x) ((x) << S_SGL_CAL_EN)
#define F_SGL_CAL_EN    V_SGL_CAL_EN(1U)

#define S_IMP_UPD_MODE    19
#define V_IMP_UPD_MODE(x) ((x) << S_IMP_UPD_MODE)
#define F_IMP_UPD_MODE    V_IMP_UPD_MODE(1U)

#define S_IMP_SEL    18
#define V_IMP_SEL(x) ((x) << S_IMP_SEL)
#define F_IMP_SEL    V_IMP_SEL(1U)

#define S_IMP_MAN_PD    15
#define M_IMP_MAN_PD    0x7
#define V_IMP_MAN_PD(x) ((x) << S_IMP_MAN_PD)
#define G_IMP_MAN_PD(x) (((x) >> S_IMP_MAN_PD) & M_IMP_MAN_PD)

#define S_IMP_MAN_PU    12
#define M_IMP_MAN_PU    0x7
#define V_IMP_MAN_PU(x) ((x) << S_IMP_MAN_PU)
#define G_IMP_MAN_PU(x) (((x) >> S_IMP_MAN_PU) & M_IMP_MAN_PU)

#define S_IMP_CAL_PD    9
#define M_IMP_CAL_PD    0x7
#define V_IMP_CAL_PD(x) ((x) << S_IMP_CAL_PD)
#define G_IMP_CAL_PD(x) (((x) >> S_IMP_CAL_PD) & M_IMP_CAL_PD)

#define S_IMP_CAL_PU    6
#define M_IMP_CAL_PU    0x7
#define V_IMP_CAL_PU(x) ((x) << S_IMP_CAL_PU)
#define G_IMP_CAL_PU(x) (((x) >> S_IMP_CAL_PU) & M_IMP_CAL_PU)

#define S_IMP_SET_PD    3
#define M_IMP_SET_PD    0x7
#define V_IMP_SET_PD(x) ((x) << S_IMP_SET_PD)
#define G_IMP_SET_PD(x) (((x) >> S_IMP_SET_PD) & M_IMP_SET_PD)

#define S_IMP_SET_PU    0
#define M_IMP_SET_PU    0x7
#define V_IMP_SET_PU(x) ((x) << S_IMP_SET_PU)
#define G_IMP_SET_PU(x) (((x) >> S_IMP_SET_PU) & M_IMP_SET_PU)

#define A_MC7_ERR_ADDR 0x12c

#define S_ERRADDRESS    3
#define M_ERRADDRESS    0x1fffffff
#define V_ERRADDRESS(x) ((x) << S_ERRADDRESS)
#define G_ERRADDRESS(x) (((x) >> S_ERRADDRESS) & M_ERRADDRESS)

#define S_ERRAGENT    1
#define M_ERRAGENT    0x3
#define V_ERRAGENT(x) ((x) << S_ERRAGENT)
#define G_ERRAGENT(x) (((x) >> S_ERRAGENT) & M_ERRAGENT)

#define S_ERROP    0
#define V_ERROP(x) ((x) << S_ERROP)
#define F_ERROP    V_ERROP(1U)

#define A_MC7_ECC 0x130

#define S_UECNT    10
#define M_UECNT    0xff
#define V_UECNT(x) ((x) << S_UECNT)
#define G_UECNT(x) (((x) >> S_UECNT) & M_UECNT)

#define S_CECNT    2
#define M_CECNT    0xff
#define V_CECNT(x) ((x) << S_CECNT)
#define G_CECNT(x) (((x) >> S_CECNT) & M_CECNT)

#define S_ECCCHKEN    1
#define V_ECCCHKEN(x) ((x) << S_ECCCHKEN)
#define F_ECCCHKEN    V_ECCCHKEN(1U)

#define S_ECCGENEN    0
#define V_ECCGENEN(x) ((x) << S_ECCGENEN)
#define F_ECCGENEN    V_ECCGENEN(1U)

#define A_MC7_CE_ADDR 0x134
#define A_MC7_CE_DATA0 0x138
#define A_MC7_CE_DATA1 0x13c
#define A_MC7_CE_DATA2 0x140

#define S_DATA    0
#define M_DATA    0xff
#define V_DATA(x) ((x) << S_DATA)
#define G_DATA(x) (((x) >> S_DATA) & M_DATA)

#define A_MC7_UE_ADDR 0x144
#define A_MC7_UE_DATA0 0x148
#define A_MC7_UE_DATA1 0x14c
#define A_MC7_UE_DATA2 0x150
#define A_MC7_BD_ADDR 0x154

#define S_ADDR    3
#define M_ADDR    0x1fffffff
#define V_ADDR(x) ((x) << S_ADDR)
#define G_ADDR(x) (((x) >> S_ADDR) & M_ADDR)

#define A_MC7_BD_DATA0 0x158
#define A_MC7_BD_DATA1 0x15c
#define A_MC7_BD_DATA2 0x160
#define A_MC7_BD_OP 0x164

#define S_OP    0
#define V_OP(x) ((x) << S_OP)
#define F_OP    V_OP(1U)

#define A_MC7_BIST_ADDR_BEG 0x168

#define S_ADDRBEG    5
#define M_ADDRBEG    0x7ffffff
#define V_ADDRBEG(x) ((x) << S_ADDRBEG)
#define G_ADDRBEG(x) (((x) >> S_ADDRBEG) & M_ADDRBEG)

#define A_MC7_BIST_ADDR_END 0x16c

#define S_ADDREND    5
#define M_ADDREND    0x7ffffff
#define V_ADDREND(x) ((x) << S_ADDREND)
#define G_ADDREND(x) (((x) >> S_ADDREND) & M_ADDREND)

#define A_MC7_BIST_DATA 0x170
#define A_MC7_BIST_OP 0x174

#define S_GAP    4
#define M_GAP    0x1f
#define V_GAP(x) ((x) << S_GAP)
#define G_GAP(x) (((x) >> S_GAP) & M_GAP)

#define S_CONT    3
#define V_CONT(x) ((x) << S_CONT)
#define F_CONT    V_CONT(1U)

#define S_DATAPAT    1
#define M_DATAPAT    0x3
#define V_DATAPAT(x) ((x) << S_DATAPAT)
#define G_DATAPAT(x) (((x) >> S_DATAPAT) & M_DATAPAT)

#define A_MC7_INT_ENABLE 0x178

#define S_AE    17
#define V_AE(x) ((x) << S_AE)
#define F_AE    V_AE(1U)

#define S_PE    2
#define M_PE    0x7fff
#define V_PE(x) ((x) << S_PE)
#define G_PE(x) (((x) >> S_PE) & M_PE)

#define S_UE    1
#define V_UE(x) ((x) << S_UE)
#define F_UE    V_UE(1U)

#define S_CE    0
#define V_CE(x) ((x) << S_CE)
#define F_CE    V_CE(1U)

#define A_MC7_INT_CAUSE 0x17c

/* registers for module MC7_PMTX */
#define MC7_PMTX_BASE_ADDR 0x180

/* registers for module MC7_CM */
#define MC7_CM_BASE_ADDR 0x200

/* registers for module CIM */
#define CIM_BASE_ADDR 0x280

#define A_CIM_BOOT_CFG 0x280

#define S_BOOTADDR    2
#define M_BOOTADDR    0x3fffffff
#define V_BOOTADDR(x) ((x) << S_BOOTADDR)
#define G_BOOTADDR(x) (((x) >> S_BOOTADDR) & M_BOOTADDR)

#define S_BOOTSDRAM    1
#define V_BOOTSDRAM(x) ((x) << S_BOOTSDRAM)
#define F_BOOTSDRAM    V_BOOTSDRAM(1U)

#define S_UPCRST    0
#define V_UPCRST(x) ((x) << S_UPCRST)
#define F_UPCRST    V_UPCRST(1U)

#define A_CIM_FLASH_BASE_ADDR 0x284

#define S_FLASHBASEADDR    2
#define M_FLASHBASEADDR    0x3fffff
#define V_FLASHBASEADDR(x) ((x) << S_FLASHBASEADDR)
#define G_FLASHBASEADDR(x) (((x) >> S_FLASHBASEADDR) & M_FLASHBASEADDR)

#define A_CIM_FLASH_ADDR_SIZE 0x288

#define S_FLASHADDRSIZE    2
#define M_FLASHADDRSIZE    0x3fffff
#define V_FLASHADDRSIZE(x) ((x) << S_FLASHADDRSIZE)
#define G_FLASHADDRSIZE(x) (((x) >> S_FLASHADDRSIZE) & M_FLASHADDRSIZE)

#define A_CIM_SDRAM_BASE_ADDR 0x28c

#define S_SDRAMBASEADDR    2
#define M_SDRAMBASEADDR    0x3fffffff
#define V_SDRAMBASEADDR(x) ((x) << S_SDRAMBASEADDR)
#define G_SDRAMBASEADDR(x) (((x) >> S_SDRAMBASEADDR) & M_SDRAMBASEADDR)

#define A_CIM_SDRAM_ADDR_SIZE 0x290

#define S_SDRAMADDRSIZE    2
#define M_SDRAMADDRSIZE    0x3fffffff
#define V_SDRAMADDRSIZE(x) ((x) << S_SDRAMADDRSIZE)
#define G_SDRAMADDRSIZE(x) (((x) >> S_SDRAMADDRSIZE) & M_SDRAMADDRSIZE)

#define A_CIM_UP_SPARE_INT 0x294

#define S_UPSPAREINT    0
#define M_UPSPAREINT    0x7
#define V_UPSPAREINT(x) ((x) << S_UPSPAREINT)
#define G_UPSPAREINT(x) (((x) >> S_UPSPAREINT) & M_UPSPAREINT)

#define A_CIM_HOST_INT_ENABLE 0x298

#define S_DTAGPARERR    28
#define V_DTAGPARERR(x) ((x) << S_DTAGPARERR)
#define F_DTAGPARERR    V_DTAGPARERR(1U)

#define S_ITAGPARERR    27
#define V_ITAGPARERR(x) ((x) << S_ITAGPARERR)
#define F_ITAGPARERR    V_ITAGPARERR(1U)

#define S_IBQTPPARERR    26
#define V_IBQTPPARERR(x) ((x) << S_IBQTPPARERR)
#define F_IBQTPPARERR    V_IBQTPPARERR(1U)

#define S_IBQULPPARERR    25
#define V_IBQULPPARERR(x) ((x) << S_IBQULPPARERR)
#define F_IBQULPPARERR    V_IBQULPPARERR(1U)

#define S_IBQSGEHIPARERR    24
#define V_IBQSGEHIPARERR(x) ((x) << S_IBQSGEHIPARERR)
#define F_IBQSGEHIPARERR    V_IBQSGEHIPARERR(1U)

#define S_IBQSGELOPARERR    23
#define V_IBQSGELOPARERR(x) ((x) << S_IBQSGELOPARERR)
#define F_IBQSGELOPARERR    V_IBQSGELOPARERR(1U)

#define S_OBQULPLOPARERR    22
#define V_OBQULPLOPARERR(x) ((x) << S_OBQULPLOPARERR)
#define F_OBQULPLOPARERR    V_OBQULPLOPARERR(1U)

#define S_OBQULPHIPARERR    21
#define V_OBQULPHIPARERR(x) ((x) << S_OBQULPHIPARERR)
#define F_OBQULPHIPARERR    V_OBQULPHIPARERR(1U)

#define S_OBQSGEPARERR    20
#define V_OBQSGEPARERR(x) ((x) << S_OBQSGEPARERR)
#define F_OBQSGEPARERR    V_OBQSGEPARERR(1U)

#define S_DCACHEPARERR    19
#define V_DCACHEPARERR(x) ((x) << S_DCACHEPARERR)
#define F_DCACHEPARERR    V_DCACHEPARERR(1U)

#define S_ICACHEPARERR    18
#define V_ICACHEPARERR(x) ((x) << S_ICACHEPARERR)
#define F_ICACHEPARERR    V_ICACHEPARERR(1U)

#define S_DRAMPARERR    17
#define V_DRAMPARERR(x) ((x) << S_DRAMPARERR)
#define F_DRAMPARERR    V_DRAMPARERR(1U)

#define S_TIMER1INTEN    15
#define V_TIMER1INTEN(x) ((x) << S_TIMER1INTEN)
#define F_TIMER1INTEN    V_TIMER1INTEN(1U)

#define S_TIMER0INTEN    14
#define V_TIMER0INTEN(x) ((x) << S_TIMER0INTEN)
#define F_TIMER0INTEN    V_TIMER0INTEN(1U)

#define S_PREFDROPINTEN    13
#define V_PREFDROPINTEN(x) ((x) << S_PREFDROPINTEN)
#define F_PREFDROPINTEN    V_PREFDROPINTEN(1U)

#define S_BLKWRPLINTEN    12
#define V_BLKWRPLINTEN(x) ((x) << S_BLKWRPLINTEN)
#define F_BLKWRPLINTEN    V_BLKWRPLINTEN(1U)

#define S_BLKRDPLINTEN    11
#define V_BLKRDPLINTEN(x) ((x) << S_BLKRDPLINTEN)
#define F_BLKRDPLINTEN    V_BLKRDPLINTEN(1U)

#define S_BLKWRCTLINTEN    10
#define V_BLKWRCTLINTEN(x) ((x) << S_BLKWRCTLINTEN)
#define F_BLKWRCTLINTEN    V_BLKWRCTLINTEN(1U)

#define S_BLKRDCTLINTEN    9
#define V_BLKRDCTLINTEN(x) ((x) << S_BLKRDCTLINTEN)
#define F_BLKRDCTLINTEN    V_BLKRDCTLINTEN(1U)

#define S_BLKWRFLASHINTEN    8
#define V_BLKWRFLASHINTEN(x) ((x) << S_BLKWRFLASHINTEN)
#define F_BLKWRFLASHINTEN    V_BLKWRFLASHINTEN(1U)

#define S_BLKRDFLASHINTEN    7
#define V_BLKRDFLASHINTEN(x) ((x) << S_BLKRDFLASHINTEN)
#define F_BLKRDFLASHINTEN    V_BLKRDFLASHINTEN(1U)

#define S_SGLWRFLASHINTEN    6
#define V_SGLWRFLASHINTEN(x) ((x) << S_SGLWRFLASHINTEN)
#define F_SGLWRFLASHINTEN    V_SGLWRFLASHINTEN(1U)

#define S_WRBLKFLASHINTEN    5
#define V_WRBLKFLASHINTEN(x) ((x) << S_WRBLKFLASHINTEN)
#define F_WRBLKFLASHINTEN    V_WRBLKFLASHINTEN(1U)

#define S_BLKWRBOOTINTEN    4
#define V_BLKWRBOOTINTEN(x) ((x) << S_BLKWRBOOTINTEN)
#define F_BLKWRBOOTINTEN    V_BLKWRBOOTINTEN(1U)

#define S_BLKRDBOOTINTEN    3
#define V_BLKRDBOOTINTEN(x) ((x) << S_BLKRDBOOTINTEN)
#define F_BLKRDBOOTINTEN    V_BLKRDBOOTINTEN(1U)

#define S_FLASHRANGEINTEN    2
#define V_FLASHRANGEINTEN(x) ((x) << S_FLASHRANGEINTEN)
#define F_FLASHRANGEINTEN    V_FLASHRANGEINTEN(1U)

#define S_SDRAMRANGEINTEN    1
#define V_SDRAMRANGEINTEN(x) ((x) << S_SDRAMRANGEINTEN)
#define F_SDRAMRANGEINTEN    V_SDRAMRANGEINTEN(1U)

#define S_RSVDSPACEINTEN    0
#define V_RSVDSPACEINTEN(x) ((x) << S_RSVDSPACEINTEN)
#define F_RSVDSPACEINTEN    V_RSVDSPACEINTEN(1U)

#define A_CIM_HOST_INT_CAUSE 0x29c

#define S_TIMER1INT    15
#define V_TIMER1INT(x) ((x) << S_TIMER1INT)
#define F_TIMER1INT    V_TIMER1INT(1U)

#define S_TIMER0INT    14
#define V_TIMER0INT(x) ((x) << S_TIMER0INT)
#define F_TIMER0INT    V_TIMER0INT(1U)

#define S_PREFDROPINT    13
#define V_PREFDROPINT(x) ((x) << S_PREFDROPINT)
#define F_PREFDROPINT    V_PREFDROPINT(1U)

#define S_BLKWRPLINT    12
#define V_BLKWRPLINT(x) ((x) << S_BLKWRPLINT)
#define F_BLKWRPLINT    V_BLKWRPLINT(1U)

#define S_BLKRDPLINT    11
#define V_BLKRDPLINT(x) ((x) << S_BLKRDPLINT)
#define F_BLKRDPLINT    V_BLKRDPLINT(1U)

#define S_BLKWRCTLINT    10
#define V_BLKWRCTLINT(x) ((x) << S_BLKWRCTLINT)
#define F_BLKWRCTLINT    V_BLKWRCTLINT(1U)

#define S_BLKRDCTLINT    9
#define V_BLKRDCTLINT(x) ((x) << S_BLKRDCTLINT)
#define F_BLKRDCTLINT    V_BLKRDCTLINT(1U)

#define S_BLKWRFLASHINT    8
#define V_BLKWRFLASHINT(x) ((x) << S_BLKWRFLASHINT)
#define F_BLKWRFLASHINT    V_BLKWRFLASHINT(1U)

#define S_BLKRDFLASHINT    7
#define V_BLKRDFLASHINT(x) ((x) << S_BLKRDFLASHINT)
#define F_BLKRDFLASHINT    V_BLKRDFLASHINT(1U)

#define S_SGLWRFLASHINT    6
#define V_SGLWRFLASHINT(x) ((x) << S_SGLWRFLASHINT)
#define F_SGLWRFLASHINT    V_SGLWRFLASHINT(1U)

#define S_WRBLKFLASHINT    5
#define V_WRBLKFLASHINT(x) ((x) << S_WRBLKFLASHINT)
#define F_WRBLKFLASHINT    V_WRBLKFLASHINT(1U)

#define S_BLKWRBOOTINT    4
#define V_BLKWRBOOTINT(x) ((x) << S_BLKWRBOOTINT)
#define F_BLKWRBOOTINT    V_BLKWRBOOTINT(1U)

#define S_BLKRDBOOTINT    3
#define V_BLKRDBOOTINT(x) ((x) << S_BLKRDBOOTINT)
#define F_BLKRDBOOTINT    V_BLKRDBOOTINT(1U)

#define S_FLASHRANGEINT    2
#define V_FLASHRANGEINT(x) ((x) << S_FLASHRANGEINT)
#define F_FLASHRANGEINT    V_FLASHRANGEINT(1U)

#define S_SDRAMRANGEINT    1
#define V_SDRAMRANGEINT(x) ((x) << S_SDRAMRANGEINT)
#define F_SDRAMRANGEINT    V_SDRAMRANGEINT(1U)

#define S_RSVDSPACEINT    0
#define V_RSVDSPACEINT(x) ((x) << S_RSVDSPACEINT)
#define F_RSVDSPACEINT    V_RSVDSPACEINT(1U)

#define A_CIM_UP_INT_ENABLE 0x2a0

#define S_MSTPLINTEN    16
#define V_MSTPLINTEN(x) ((x) << S_MSTPLINTEN)
#define F_MSTPLINTEN    V_MSTPLINTEN(1U)

#define A_CIM_UP_INT_CAUSE 0x2a4

#define S_MSTPLINT    16
#define V_MSTPLINT(x) ((x) << S_MSTPLINT)
#define F_MSTPLINT    V_MSTPLINT(1U)

#define A_CIM_IBQ_FULLA_THRSH 0x2a8

#define S_IBQ0FULLTHRSH    0
#define M_IBQ0FULLTHRSH    0x1ff
#define V_IBQ0FULLTHRSH(x) ((x) << S_IBQ0FULLTHRSH)
#define G_IBQ0FULLTHRSH(x) (((x) >> S_IBQ0FULLTHRSH) & M_IBQ0FULLTHRSH)

#define S_IBQ1FULLTHRSH    16
#define M_IBQ1FULLTHRSH    0x1ff
#define V_IBQ1FULLTHRSH(x) ((x) << S_IBQ1FULLTHRSH)
#define G_IBQ1FULLTHRSH(x) (((x) >> S_IBQ1FULLTHRSH) & M_IBQ1FULLTHRSH)

#define A_CIM_IBQ_FULLB_THRSH 0x2ac

#define S_IBQ2FULLTHRSH    0
#define M_IBQ2FULLTHRSH    0x1ff
#define V_IBQ2FULLTHRSH(x) ((x) << S_IBQ2FULLTHRSH)
#define G_IBQ2FULLTHRSH(x) (((x) >> S_IBQ2FULLTHRSH) & M_IBQ2FULLTHRSH)

#define S_IBQ3FULLTHRSH    16
#define M_IBQ3FULLTHRSH    0x1ff
#define V_IBQ3FULLTHRSH(x) ((x) << S_IBQ3FULLTHRSH)
#define G_IBQ3FULLTHRSH(x) (((x) >> S_IBQ3FULLTHRSH) & M_IBQ3FULLTHRSH)

#define A_CIM_HOST_ACC_CTRL 0x2b0

#define S_HOSTBUSY    17
#define V_HOSTBUSY(x) ((x) << S_HOSTBUSY)
#define F_HOSTBUSY    V_HOSTBUSY(1U)

#define S_HOSTWRITE    16
#define V_HOSTWRITE(x) ((x) << S_HOSTWRITE)
#define F_HOSTWRITE    V_HOSTWRITE(1U)

#define S_HOSTADDR    0
#define M_HOSTADDR    0xffff
#define V_HOSTADDR(x) ((x) << S_HOSTADDR)
#define G_HOSTADDR(x) (((x) >> S_HOSTADDR) & M_HOSTADDR)

#define A_CIM_HOST_ACC_DATA 0x2b4
#define A_CIM_IBQ_DBG_CFG 0x2c0

#define S_IBQDBGADDR    16
#define M_IBQDBGADDR    0x1ff
#define V_IBQDBGADDR(x) ((x) << S_IBQDBGADDR)
#define G_IBQDBGADDR(x) (((x) >> S_IBQDBGADDR) & M_IBQDBGADDR)

#define S_IBQDBGQID    3
#define M_IBQDBGQID    0x3
#define V_IBQDBGQID(x) ((x) << S_IBQDBGQID)
#define G_IBQDBGQID(x) (((x) >> S_IBQDBGQID) & M_IBQDBGQID)

#define S_IBQDBGWR    2
#define V_IBQDBGWR(x) ((x) << S_IBQDBGWR)
#define F_IBQDBGWR    V_IBQDBGWR(1U)

#define S_IBQDBGBUSY    1
#define V_IBQDBGBUSY(x) ((x) << S_IBQDBGBUSY)
#define F_IBQDBGBUSY    V_IBQDBGBUSY(1U)

#define S_IBQDBGEN    0
#define V_IBQDBGEN(x) ((x) << S_IBQDBGEN)
#define F_IBQDBGEN    V_IBQDBGEN(1U)

#define A_CIM_OBQ_DBG_CFG 0x2c4

#define S_OBQDBGADDR    16
#define M_OBQDBGADDR    0x1ff
#define V_OBQDBGADDR(x) ((x) << S_OBQDBGADDR)
#define G_OBQDBGADDR(x) (((x) >> S_OBQDBGADDR) & M_OBQDBGADDR)

#define S_OBQDBGQID    3
#define M_OBQDBGQID    0x3
#define V_OBQDBGQID(x) ((x) << S_OBQDBGQID)
#define G_OBQDBGQID(x) (((x) >> S_OBQDBGQID) & M_OBQDBGQID)

#define S_OBQDBGWR    2
#define V_OBQDBGWR(x) ((x) << S_OBQDBGWR)
#define F_OBQDBGWR    V_OBQDBGWR(1U)

#define S_OBQDBGBUSY    1
#define V_OBQDBGBUSY(x) ((x) << S_OBQDBGBUSY)
#define F_OBQDBGBUSY    V_OBQDBGBUSY(1U)

#define S_OBQDBGEN    0
#define V_OBQDBGEN(x) ((x) << S_OBQDBGEN)
#define F_OBQDBGEN    V_OBQDBGEN(1U)

#define A_CIM_IBQ_DBG_DATA 0x2c8
#define A_CIM_OBQ_DBG_DATA 0x2cc
#define A_CIM_CDEBUGDATA 0x2d0

#define S_CDEBUGDATAH    16
#define M_CDEBUGDATAH    0xffff
#define V_CDEBUGDATAH(x) ((x) << S_CDEBUGDATAH)
#define G_CDEBUGDATAH(x) (((x) >> S_CDEBUGDATAH) & M_CDEBUGDATAH)

#define S_CDEBUGDATAL    0
#define M_CDEBUGDATAL    0xffff
#define V_CDEBUGDATAL(x) ((x) << S_CDEBUGDATAL)
#define G_CDEBUGDATAL(x) (((x) >> S_CDEBUGDATAL) & M_CDEBUGDATAL)

#define A_CIM_DEBUGCFG 0x2e0

#define S_POLADBGRDPTR    23
#define M_POLADBGRDPTR    0x1ff
#define V_POLADBGRDPTR(x) ((x) << S_POLADBGRDPTR)
#define G_POLADBGRDPTR(x) (((x) >> S_POLADBGRDPTR) & M_POLADBGRDPTR)

#define S_PILADBGRDPTR    14
#define M_PILADBGRDPTR    0x1ff
#define V_PILADBGRDPTR(x) ((x) << S_PILADBGRDPTR)
#define G_PILADBGRDPTR(x) (((x) >> S_PILADBGRDPTR) & M_PILADBGRDPTR)

#define S_CIM_LADBGEN    12
#define V_CIM_LADBGEN(x) ((x) << S_CIM_LADBGEN)
#define F_CIM_LADBGEN    V_CIM_LADBGEN(1U)

#define S_DEBUGSELHI    5
#define M_DEBUGSELHI    0x1f
#define V_DEBUGSELHI(x) ((x) << S_DEBUGSELHI)
#define G_DEBUGSELHI(x) (((x) >> S_DEBUGSELHI) & M_DEBUGSELHI)

#define S_DEBUGSELLO    0
#define M_DEBUGSELLO    0x1f
#define V_DEBUGSELLO(x) ((x) << S_DEBUGSELLO)
#define G_DEBUGSELLO(x) (((x) >> S_DEBUGSELLO) & M_DEBUGSELLO)

#define A_CIM_DEBUGSTS 0x2e4

#define S_POLADBGWRPTR    16
#define M_POLADBGWRPTR    0x1ff
#define V_POLADBGWRPTR(x) ((x) << S_POLADBGWRPTR)
#define G_POLADBGWRPTR(x) (((x) >> S_POLADBGWRPTR) & M_POLADBGWRPTR)

#define S_PILADBGWRPTR    0
#define M_PILADBGWRPTR    0x1ff
#define V_PILADBGWRPTR(x) ((x) << S_PILADBGWRPTR)
#define G_PILADBGWRPTR(x) (((x) >> S_PILADBGWRPTR) & M_PILADBGWRPTR)

#define A_CIM_PO_LA_DEBUGDATA 0x2e8
#define A_CIM_PI_LA_DEBUGDATA 0x2ec

/* registers for module TP1 */
#define TP1_BASE_ADDR 0x300

#define A_TP_IN_CONFIG 0x300

#define S_RXFBARBPRIO    25
#define V_RXFBARBPRIO(x) ((x) << S_RXFBARBPRIO)
#define F_RXFBARBPRIO    V_RXFBARBPRIO(1U)

#define S_TXFBARBPRIO    24
#define V_TXFBARBPRIO(x) ((x) << S_TXFBARBPRIO)
#define F_TXFBARBPRIO    V_TXFBARBPRIO(1U)

#define S_DBMAXOPCNT    16
#define M_DBMAXOPCNT    0xff
#define V_DBMAXOPCNT(x) ((x) << S_DBMAXOPCNT)
#define G_DBMAXOPCNT(x) (((x) >> S_DBMAXOPCNT) & M_DBMAXOPCNT)

#define S_IPV6ENABLE    15
#define V_IPV6ENABLE(x) ((x) << S_IPV6ENABLE)
#define F_IPV6ENABLE    V_IPV6ENABLE(1U)

#define S_NICMODE    14
#define V_NICMODE(x) ((x) << S_NICMODE)
#define F_NICMODE    V_NICMODE(1U)

#define S_ECHECKSUMCHECKTCP    13
#define V_ECHECKSUMCHECKTCP(x) ((x) << S_ECHECKSUMCHECKTCP)
#define F_ECHECKSUMCHECKTCP    V_ECHECKSUMCHECKTCP(1U)

#define S_ECHECKSUMCHECKIP    12
#define V_ECHECKSUMCHECKIP(x) ((x) << S_ECHECKSUMCHECKIP)
#define F_ECHECKSUMCHECKIP    V_ECHECKSUMCHECKIP(1U)

#define S_ECPL    10
#define V_ECPL(x) ((x) << S_ECPL)
#define F_ECPL    V_ECPL(1U)

#define S_EETHERNET    8
#define V_EETHERNET(x) ((x) << S_EETHERNET)
#define F_EETHERNET    V_EETHERNET(1U)

#define S_ETUNNEL    7
#define V_ETUNNEL(x) ((x) << S_ETUNNEL)
#define F_ETUNNEL    V_ETUNNEL(1U)

#define S_CCHECKSUMCHECKTCP    6
#define V_CCHECKSUMCHECKTCP(x) ((x) << S_CCHECKSUMCHECKTCP)
#define F_CCHECKSUMCHECKTCP    V_CCHECKSUMCHECKTCP(1U)

#define S_CCHECKSUMCHECKIP    5
#define V_CCHECKSUMCHECKIP(x) ((x) << S_CCHECKSUMCHECKIP)
#define F_CCHECKSUMCHECKIP    V_CCHECKSUMCHECKIP(1U)

#define S_CCPL    3
#define V_CCPL(x) ((x) << S_CCPL)
#define F_CCPL    V_CCPL(1U)

#define S_CETHERNET    1
#define V_CETHERNET(x) ((x) << S_CETHERNET)
#define F_CETHERNET    V_CETHERNET(1U)

#define S_CTUNNEL    0
#define V_CTUNNEL(x) ((x) << S_CTUNNEL)
#define F_CTUNNEL    V_CTUNNEL(1U)

#define A_TP_OUT_CONFIG 0x304

#define S_IPIDSPLITMODE    16
#define V_IPIDSPLITMODE(x) ((x) << S_IPIDSPLITMODE)
#define F_IPIDSPLITMODE    V_IPIDSPLITMODE(1U)

#define S_VLANEXTRACTIONENABLE2NDPORT    13
#define V_VLANEXTRACTIONENABLE2NDPORT(x) ((x) << S_VLANEXTRACTIONENABLE2NDPORT)
#define F_VLANEXTRACTIONENABLE2NDPORT    V_VLANEXTRACTIONENABLE2NDPORT(1U)

#define S_VLANEXTRACTIONENABLE    12
#define V_VLANEXTRACTIONENABLE(x) ((x) << S_VLANEXTRACTIONENABLE)
#define F_VLANEXTRACTIONENABLE    V_VLANEXTRACTIONENABLE(1U)

#define S_ECHECKSUMGENERATETCP    11
#define V_ECHECKSUMGENERATETCP(x) ((x) << S_ECHECKSUMGENERATETCP)
#define F_ECHECKSUMGENERATETCP    V_ECHECKSUMGENERATETCP(1U)

#define S_ECHECKSUMGENERATEIP    10
#define V_ECHECKSUMGENERATEIP(x) ((x) << S_ECHECKSUMGENERATEIP)
#define F_ECHECKSUMGENERATEIP    V_ECHECKSUMGENERATEIP(1U)

#define S_OUT_ECPL    8
#define V_OUT_ECPL(x) ((x) << S_OUT_ECPL)
#define F_OUT_ECPL    V_OUT_ECPL(1U)

#define S_OUT_EETHERNET    6
#define V_OUT_EETHERNET(x) ((x) << S_OUT_EETHERNET)
#define F_OUT_EETHERNET    V_OUT_EETHERNET(1U)

#define S_CCHECKSUMGENERATETCP    5
#define V_CCHECKSUMGENERATETCP(x) ((x) << S_CCHECKSUMGENERATETCP)
#define F_CCHECKSUMGENERATETCP    V_CCHECKSUMGENERATETCP(1U)

#define S_CCHECKSUMGENERATEIP    4
#define V_CCHECKSUMGENERATEIP(x) ((x) << S_CCHECKSUMGENERATEIP)
#define F_CCHECKSUMGENERATEIP    V_CCHECKSUMGENERATEIP(1U)

#define S_OUT_CCPL    2
#define V_OUT_CCPL(x) ((x) << S_OUT_CCPL)
#define F_OUT_CCPL    V_OUT_CCPL(1U)

#define S_OUT_CETHERNET    0
#define V_OUT_CETHERNET(x) ((x) << S_OUT_CETHERNET)
#define F_OUT_CETHERNET    V_OUT_CETHERNET(1U)

#define A_TP_GLOBAL_CONFIG 0x308

#define S_SYNCOOKIEPARAMS    26
#define M_SYNCOOKIEPARAMS    0x3f
#define V_SYNCOOKIEPARAMS(x) ((x) << S_SYNCOOKIEPARAMS)
#define G_SYNCOOKIEPARAMS(x) (((x) >> S_SYNCOOKIEPARAMS) & M_SYNCOOKIEPARAMS)

#define S_RXFLOWCONTROLDISABLE    25
#define V_RXFLOWCONTROLDISABLE(x) ((x) << S_RXFLOWCONTROLDISABLE)
#define F_RXFLOWCONTROLDISABLE    V_RXFLOWCONTROLDISABLE(1U)

#define S_TXPACINGENABLE    24
#define V_TXPACINGENABLE(x) ((x) << S_TXPACINGENABLE)
#define F_TXPACINGENABLE    V_TXPACINGENABLE(1U)

#define S_ATTACKFILTERENABLE    23
#define V_ATTACKFILTERENABLE(x) ((x) << S_ATTACKFILTERENABLE)
#define F_ATTACKFILTERENABLE    V_ATTACKFILTERENABLE(1U)

#define S_SYNCOOKIENOOPTIONS    22
#define V_SYNCOOKIENOOPTIONS(x) ((x) << S_SYNCOOKIENOOPTIONS)
#define F_SYNCOOKIENOOPTIONS    V_SYNCOOKIENOOPTIONS(1U)

#define S_PROTECTEDMODE    21
#define V_PROTECTEDMODE(x) ((x) << S_PROTECTEDMODE)
#define F_PROTECTEDMODE    V_PROTECTEDMODE(1U)

#define S_PINGDROP    20
#define V_PINGDROP(x) ((x) << S_PINGDROP)
#define F_PINGDROP    V_PINGDROP(1U)

#define S_FRAGMENTDROP    19
#define V_FRAGMENTDROP(x) ((x) << S_FRAGMENTDROP)
#define F_FRAGMENTDROP    V_FRAGMENTDROP(1U)

#define S_FIVETUPLELOOKUP    17
#define M_FIVETUPLELOOKUP    0x3
#define V_FIVETUPLELOOKUP(x) ((x) << S_FIVETUPLELOOKUP)
#define G_FIVETUPLELOOKUP(x) (((x) >> S_FIVETUPLELOOKUP) & M_FIVETUPLELOOKUP)

#define S_PATHMTU    15
#define V_PATHMTU(x) ((x) << S_PATHMTU)
#define F_PATHMTU    V_PATHMTU(1U)

#define S_IPIDENTSPLIT    14
#define V_IPIDENTSPLIT(x) ((x) << S_IPIDENTSPLIT)
#define F_IPIDENTSPLIT    V_IPIDENTSPLIT(1U)

#define S_IPCHECKSUMOFFLOAD    13
#define V_IPCHECKSUMOFFLOAD(x) ((x) << S_IPCHECKSUMOFFLOAD)
#define F_IPCHECKSUMOFFLOAD    V_IPCHECKSUMOFFLOAD(1U)

#define S_UDPCHECKSUMOFFLOAD    12
#define V_UDPCHECKSUMOFFLOAD(x) ((x) << S_UDPCHECKSUMOFFLOAD)
#define F_UDPCHECKSUMOFFLOAD    V_UDPCHECKSUMOFFLOAD(1U)

#define S_TCPCHECKSUMOFFLOAD    11
#define V_TCPCHECKSUMOFFLOAD(x) ((x) << S_TCPCHECKSUMOFFLOAD)
#define F_TCPCHECKSUMOFFLOAD    V_TCPCHECKSUMOFFLOAD(1U)

#define S_QOSMAPPING    10
#define V_QOSMAPPING(x) ((x) << S_QOSMAPPING)
#define F_QOSMAPPING    V_QOSMAPPING(1U)

#define S_TCAMSERVERUSE    8
#define M_TCAMSERVERUSE    0x3
#define V_TCAMSERVERUSE(x) ((x) << S_TCAMSERVERUSE)
#define G_TCAMSERVERUSE(x) (((x) >> S_TCAMSERVERUSE) & M_TCAMSERVERUSE)

#define S_IPTTL    0
#define M_IPTTL    0xff
#define V_IPTTL(x) ((x) << S_IPTTL)
#define G_IPTTL(x) (((x) >> S_IPTTL) & M_IPTTL)

#define A_TP_GLOBAL_RX_CREDIT 0x30c
#define A_TP_CMM_SIZE 0x310

#define S_CMMEMMGRSIZE    0
#define M_CMMEMMGRSIZE    0xfffffff
#define V_CMMEMMGRSIZE(x) ((x) << S_CMMEMMGRSIZE)
#define G_CMMEMMGRSIZE(x) (((x) >> S_CMMEMMGRSIZE) & M_CMMEMMGRSIZE)

#define A_TP_CMM_MM_BASE 0x314

#define S_CMMEMMGRBASE    0
#define M_CMMEMMGRBASE    0xfffffff
#define V_CMMEMMGRBASE(x) ((x) << S_CMMEMMGRBASE)
#define G_CMMEMMGRBASE(x) (((x) >> S_CMMEMMGRBASE) & M_CMMEMMGRBASE)

#define A_TP_CMM_TIMER_BASE 0x318

#define S_CMTIMERMAXNUM    28
#define M_CMTIMERMAXNUM    0x3
#define V_CMTIMERMAXNUM(x) ((x) << S_CMTIMERMAXNUM)
#define G_CMTIMERMAXNUM(x) (((x) >> S_CMTIMERMAXNUM) & M_CMTIMERMAXNUM)

#define S_CMTIMERBASE    0
#define M_CMTIMERBASE    0xfffffff
#define V_CMTIMERBASE(x) ((x) << S_CMTIMERBASE)
#define G_CMTIMERBASE(x) (((x) >> S_CMTIMERBASE) & M_CMTIMERBASE)

#define A_TP_PMM_SIZE 0x31c

#define S_PMSIZE    0
#define M_PMSIZE    0xfffffff
#define V_PMSIZE(x) ((x) << S_PMSIZE)
#define G_PMSIZE(x) (((x) >> S_PMSIZE) & M_PMSIZE)

#define A_TP_PMM_TX_BASE 0x320
#define A_TP_PMM_DEFRAG_BASE 0x324
#define A_TP_PMM_RX_BASE 0x328
#define A_TP_PMM_RX_PAGE_SIZE 0x32c
#define A_TP_PMM_RX_MAX_PAGE 0x330

#define S_PMRXMAXPAGE    0
#define M_PMRXMAXPAGE    0x1fffff
#define V_PMRXMAXPAGE(x) ((x) << S_PMRXMAXPAGE)
#define G_PMRXMAXPAGE(x) (((x) >> S_PMRXMAXPAGE) & M_PMRXMAXPAGE)

#define A_TP_PMM_TX_PAGE_SIZE 0x334
#define A_TP_PMM_TX_MAX_PAGE 0x338

#define S_PMTXMAXPAGE    0
#define M_PMTXMAXPAGE    0x1fffff
#define V_PMTXMAXPAGE(x) ((x) << S_PMTXMAXPAGE)
#define G_PMTXMAXPAGE(x) (((x) >> S_PMTXMAXPAGE) & M_PMTXMAXPAGE)

#define A_TP_TCP_OPTIONS 0x340

#define S_MTUDEFAULT    16
#define M_MTUDEFAULT    0xffff
#define V_MTUDEFAULT(x) ((x) << S_MTUDEFAULT)
#define G_MTUDEFAULT(x) (((x) >> S_MTUDEFAULT) & M_MTUDEFAULT)

#define S_MTUENABLE    10
#define V_MTUENABLE(x) ((x) << S_MTUENABLE)
#define F_MTUENABLE    V_MTUENABLE(1U)

#define S_SACKTX    9
#define V_SACKTX(x) ((x) << S_SACKTX)
#define F_SACKTX    V_SACKTX(1U)

#define S_SACKRX    8
#define V_SACKRX(x) ((x) << S_SACKRX)
#define F_SACKRX    V_SACKRX(1U)

#define S_SACKMODE    4
#define M_SACKMODE    0x3
#define V_SACKMODE(x) ((x) << S_SACKMODE)
#define G_SACKMODE(x) (((x) >> S_SACKMODE) & M_SACKMODE)

#define S_WINDOWSCALEMODE    2
#define M_WINDOWSCALEMODE    0x3
#define V_WINDOWSCALEMODE(x) ((x) << S_WINDOWSCALEMODE)
#define G_WINDOWSCALEMODE(x) (((x) >> S_WINDOWSCALEMODE) & M_WINDOWSCALEMODE)

#define S_TIMESTAMPSMODE    0
#define M_TIMESTAMPSMODE    0x3
#define V_TIMESTAMPSMODE(x) ((x) << S_TIMESTAMPSMODE)
#define G_TIMESTAMPSMODE(x) (((x) >> S_TIMESTAMPSMODE) & M_TIMESTAMPSMODE)

#define A_TP_DACK_CONFIG 0x344

#define S_AUTOSTATE3    30
#define M_AUTOSTATE3    0x3
#define V_AUTOSTATE3(x) ((x) << S_AUTOSTATE3)
#define G_AUTOSTATE3(x) (((x) >> S_AUTOSTATE3) & M_AUTOSTATE3)

#define S_AUTOSTATE2    28
#define M_AUTOSTATE2    0x3
#define V_AUTOSTATE2(x) ((x) << S_AUTOSTATE2)
#define G_AUTOSTATE2(x) (((x) >> S_AUTOSTATE2) & M_AUTOSTATE2)

#define S_AUTOSTATE1    26
#define M_AUTOSTATE1    0x3
#define V_AUTOSTATE1(x) ((x) << S_AUTOSTATE1)
#define G_AUTOSTATE1(x) (((x) >> S_AUTOSTATE1) & M_AUTOSTATE1)

#define S_BYTETHRESHOLD    5
#define M_BYTETHRESHOLD    0xfffff
#define V_BYTETHRESHOLD(x) ((x) << S_BYTETHRESHOLD)
#define G_BYTETHRESHOLD(x) (((x) >> S_BYTETHRESHOLD) & M_BYTETHRESHOLD)

#define S_MSSTHRESHOLD    3
#define M_MSSTHRESHOLD    0x3
#define V_MSSTHRESHOLD(x) ((x) << S_MSSTHRESHOLD)
#define G_MSSTHRESHOLD(x) (((x) >> S_MSSTHRESHOLD) & M_MSSTHRESHOLD)

#define S_AUTOCAREFUL    2
#define V_AUTOCAREFUL(x) ((x) << S_AUTOCAREFUL)
#define F_AUTOCAREFUL    V_AUTOCAREFUL(1U)

#define S_AUTOENABLE    1
#define V_AUTOENABLE(x) ((x) << S_AUTOENABLE)
#define F_AUTOENABLE    V_AUTOENABLE(1U)

#define S_DACK_MODE    0
#define V_DACK_MODE(x) ((x) << S_DACK_MODE)
#define F_DACK_MODE    V_DACK_MODE(1U)

#define A_TP_PC_CONFIG 0x348

#define S_CMCACHEDISABLE    31
#define V_CMCACHEDISABLE(x) ((x) << S_CMCACHEDISABLE)
#define F_CMCACHEDISABLE    V_CMCACHEDISABLE(1U)

#define S_ENABLEOCSPIFULL    30
#define V_ENABLEOCSPIFULL(x) ((x) << S_ENABLEOCSPIFULL)
#define F_ENABLEOCSPIFULL    V_ENABLEOCSPIFULL(1U)

#define S_ENABLEFLMERRORDDP    29
#define V_ENABLEFLMERRORDDP(x) ((x) << S_ENABLEFLMERRORDDP)
#define F_ENABLEFLMERRORDDP    V_ENABLEFLMERRORDDP(1U)

#define S_LOCKTID    28
#define V_LOCKTID(x) ((x) << S_LOCKTID)
#define F_LOCKTID    V_LOCKTID(1U)

#define S_FIXRCVWND    27
#define V_FIXRCVWND(x) ((x) << S_FIXRCVWND)
#define F_FIXRCVWND    V_FIXRCVWND(1U)

#define S_TXTOSQUEUEMAPMODE    26
#define V_TXTOSQUEUEMAPMODE(x) ((x) << S_TXTOSQUEUEMAPMODE)
#define F_TXTOSQUEUEMAPMODE    V_TXTOSQUEUEMAPMODE(1U)

#define S_RDDPCONGEN    25
#define V_RDDPCONGEN(x) ((x) << S_RDDPCONGEN)
#define F_RDDPCONGEN    V_RDDPCONGEN(1U)

#define S_ENABLEONFLYPDU    24
#define V_ENABLEONFLYPDU(x) ((x) << S_ENABLEONFLYPDU)
#define F_ENABLEONFLYPDU    V_ENABLEONFLYPDU(1U)

#define S_ENABLEEPCMDAFULL    23
#define V_ENABLEEPCMDAFULL(x) ((x) << S_ENABLEEPCMDAFULL)
#define F_ENABLEEPCMDAFULL    V_ENABLEEPCMDAFULL(1U)

#define S_MODULATEUNIONMODE    22
#define V_MODULATEUNIONMODE(x) ((x) << S_MODULATEUNIONMODE)
#define F_MODULATEUNIONMODE    V_MODULATEUNIONMODE(1U)

#define S_TXDATAACKRATEENABLE    21
#define V_TXDATAACKRATEENABLE(x) ((x) << S_TXDATAACKRATEENABLE)
#define F_TXDATAACKRATEENABLE    V_TXDATAACKRATEENABLE(1U)

#define S_TXDEFERENABLE    20
#define V_TXDEFERENABLE(x) ((x) << S_TXDEFERENABLE)
#define F_TXDEFERENABLE    V_TXDEFERENABLE(1U)

#define S_RXCONGESTIONMODE    19
#define V_RXCONGESTIONMODE(x) ((x) << S_RXCONGESTIONMODE)
#define F_RXCONGESTIONMODE    V_RXCONGESTIONMODE(1U)

#define S_HEARBEATONCEDACK    18
#define V_HEARBEATONCEDACK(x) ((x) << S_HEARBEATONCEDACK)
#define F_HEARBEATONCEDACK    V_HEARBEATONCEDACK(1U)

#define S_HEARBEATONCEHEAP    17
#define V_HEARBEATONCEHEAP(x) ((x) << S_HEARBEATONCEHEAP)
#define F_HEARBEATONCEHEAP    V_HEARBEATONCEHEAP(1U)

#define S_HEARBEATDACK    16
#define V_HEARBEATDACK(x) ((x) << S_HEARBEATDACK)
#define F_HEARBEATDACK    V_HEARBEATDACK(1U)

#define S_TXCONGESTIONMODE    15
#define V_TXCONGESTIONMODE(x) ((x) << S_TXCONGESTIONMODE)
#define F_TXCONGESTIONMODE    V_TXCONGESTIONMODE(1U)

#define S_ACCEPTLATESTRCVADV    14
#define V_ACCEPTLATESTRCVADV(x) ((x) << S_ACCEPTLATESTRCVADV)
#define F_ACCEPTLATESTRCVADV    V_ACCEPTLATESTRCVADV(1U)

#define S_DISABLESYNDATA    13
#define V_DISABLESYNDATA(x) ((x) << S_DISABLESYNDATA)
#define F_DISABLESYNDATA    V_DISABLESYNDATA(1U)

#define S_DISABLEWINDOWPSH    12
#define V_DISABLEWINDOWPSH(x) ((x) << S_DISABLEWINDOWPSH)
#define F_DISABLEWINDOWPSH    V_DISABLEWINDOWPSH(1U)

#define S_DISABLEFINOLDDATA    11
#define V_DISABLEFINOLDDATA(x) ((x) << S_DISABLEFINOLDDATA)
#define F_DISABLEFINOLDDATA    V_DISABLEFINOLDDATA(1U)

#define S_ENABLEFLMERROR    10
#define V_ENABLEFLMERROR(x) ((x) << S_ENABLEFLMERROR)
#define F_ENABLEFLMERROR    V_ENABLEFLMERROR(1U)

#define S_DISABLENEXTMTU    9
#define V_DISABLENEXTMTU(x) ((x) << S_DISABLENEXTMTU)
#define F_DISABLENEXTMTU    V_DISABLENEXTMTU(1U)

#define S_FILTERPEERFIN    8
#define V_FILTERPEERFIN(x) ((x) << S_FILTERPEERFIN)
#define F_FILTERPEERFIN    V_FILTERPEERFIN(1U)

#define S_ENABLEFEEDBACKSEND    7
#define V_ENABLEFEEDBACKSEND(x) ((x) << S_ENABLEFEEDBACKSEND)
#define F_ENABLEFEEDBACKSEND    V_ENABLEFEEDBACKSEND(1U)

#define S_ENABLERDMAERROR    6
#define V_ENABLERDMAERROR(x) ((x) << S_ENABLERDMAERROR)
#define F_ENABLERDMAERROR    V_ENABLERDMAERROR(1U)

#define S_ENABLEDDPFLOWCONTROL    5
#define V_ENABLEDDPFLOWCONTROL(x) ((x) << S_ENABLEDDPFLOWCONTROL)
#define F_ENABLEDDPFLOWCONTROL    V_ENABLEDDPFLOWCONTROL(1U)

#define S_DISABLEHELDFIN    4
#define V_DISABLEHELDFIN(x) ((x) << S_DISABLEHELDFIN)
#define F_DISABLEHELDFIN    V_DISABLEHELDFIN(1U)

#define S_TABLELATENCYDELTA    0
#define M_TABLELATENCYDELTA    0xf
#define V_TABLELATENCYDELTA(x) ((x) << S_TABLELATENCYDELTA)
#define G_TABLELATENCYDELTA(x) (((x) >> S_TABLELATENCYDELTA) & M_TABLELATENCYDELTA)

#define A_TP_PC_CONFIG2 0x34c

#define S_DISBLEDAPARBIT0    15
#define V_DISBLEDAPARBIT0(x) ((x) << S_DISBLEDAPARBIT0)
#define F_DISBLEDAPARBIT0    V_DISBLEDAPARBIT0(1U)

#define S_ENABLEARPMISS    13
#define V_ENABLEARPMISS(x) ((x) << S_ENABLEARPMISS)
#define F_ENABLEARPMISS    V_ENABLEARPMISS(1U)

#define S_ENABLENONOFDTNLSYN    12
#define V_ENABLENONOFDTNLSYN(x) ((x) << S_ENABLENONOFDTNLSYN)
#define F_ENABLENONOFDTNLSYN    V_ENABLENONOFDTNLSYN(1U)

#define S_ENABLEIPV6RSS    11
#define V_ENABLEIPV6RSS(x) ((x) << S_ENABLEIPV6RSS)
#define F_ENABLEIPV6RSS    V_ENABLEIPV6RSS(1U)

#define S_ENABLEDROPRQEMPTYPKT    10
#define V_ENABLEDROPRQEMPTYPKT(x) ((x) << S_ENABLEDROPRQEMPTYPKT)
#define F_ENABLEDROPRQEMPTYPKT    V_ENABLEDROPRQEMPTYPKT(1U)

#define S_ENABLETXPORTFROMDA2    9
#define V_ENABLETXPORTFROMDA2(x) ((x) << S_ENABLETXPORTFROMDA2)
#define F_ENABLETXPORTFROMDA2    V_ENABLETXPORTFROMDA2(1U)

#define S_ENABLERXPKTTMSTPRSS    8
#define V_ENABLERXPKTTMSTPRSS(x) ((x) << S_ENABLERXPKTTMSTPRSS)
#define F_ENABLERXPKTTMSTPRSS    V_ENABLERXPKTTMSTPRSS(1U)

#define S_ENABLESNDUNAINRXDATA    7
#define V_ENABLESNDUNAINRXDATA(x) ((x) << S_ENABLESNDUNAINRXDATA)
#define F_ENABLESNDUNAINRXDATA    V_ENABLESNDUNAINRXDATA(1U)

#define S_ENABLERXPORTFROMADDR    6
#define V_ENABLERXPORTFROMADDR(x) ((x) << S_ENABLERXPORTFROMADDR)
#define F_ENABLERXPORTFROMADDR    V_ENABLERXPORTFROMADDR(1U)

#define S_ENABLETXPORTFROMDA    5
#define V_ENABLETXPORTFROMDA(x) ((x) << S_ENABLETXPORTFROMDA)
#define F_ENABLETXPORTFROMDA    V_ENABLETXPORTFROMDA(1U)

#define S_ENABLECHDRAFULL    4
#define V_ENABLECHDRAFULL(x) ((x) << S_ENABLECHDRAFULL)
#define F_ENABLECHDRAFULL    V_ENABLECHDRAFULL(1U)

#define S_ENABLENONOFDSCBBIT    3
#define V_ENABLENONOFDSCBBIT(x) ((x) << S_ENABLENONOFDSCBBIT)
#define F_ENABLENONOFDSCBBIT    V_ENABLENONOFDSCBBIT(1U)

#define S_ENABLENONOFDTIDRSS    2
#define V_ENABLENONOFDTIDRSS(x) ((x) << S_ENABLENONOFDTIDRSS)
#define F_ENABLENONOFDTIDRSS    V_ENABLENONOFDTIDRSS(1U)

#define S_ENABLENONOFDTCBRSS    1
#define V_ENABLENONOFDTCBRSS(x) ((x) << S_ENABLENONOFDTCBRSS)
#define F_ENABLENONOFDTCBRSS    V_ENABLENONOFDTCBRSS(1U)

#define S_ENABLEOLDRXFORWARD    0
#define V_ENABLEOLDRXFORWARD(x) ((x) << S_ENABLEOLDRXFORWARD)
#define F_ENABLEOLDRXFORWARD    V_ENABLEOLDRXFORWARD(1U)

#define S_CHDRAFULL    4
#define V_CHDRAFULL(x) ((x) << S_CHDRAFULL)
#define F_CHDRAFULL    V_CHDRAFULL(1U)

#define A_TP_TCP_BACKOFF_REG0 0x350

#define S_TIMERBACKOFFINDEX3    24
#define M_TIMERBACKOFFINDEX3    0xff
#define V_TIMERBACKOFFINDEX3(x) ((x) << S_TIMERBACKOFFINDEX3)
#define G_TIMERBACKOFFINDEX3(x) (((x) >> S_TIMERBACKOFFINDEX3) & M_TIMERBACKOFFINDEX3)

#define S_TIMERBACKOFFINDEX2    16
#define M_TIMERBACKOFFINDEX2    0xff
#define V_TIMERBACKOFFINDEX2(x) ((x) << S_TIMERBACKOFFINDEX2)
#define G_TIMERBACKOFFINDEX2(x) (((x) >> S_TIMERBACKOFFINDEX2) & M_TIMERBACKOFFINDEX2)

#define S_TIMERBACKOFFINDEX1    8
#define M_TIMERBACKOFFINDEX1    0xff
#define V_TIMERBACKOFFINDEX1(x) ((x) << S_TIMERBACKOFFINDEX1)
#define G_TIMERBACKOFFINDEX1(x) (((x) >> S_TIMERBACKOFFINDEX1) & M_TIMERBACKOFFINDEX1)

#define S_TIMERBACKOFFINDEX0    0
#define M_TIMERBACKOFFINDEX0    0xff
#define V_TIMERBACKOFFINDEX0(x) ((x) << S_TIMERBACKOFFINDEX0)
#define G_TIMERBACKOFFINDEX0(x) (((x) >> S_TIMERBACKOFFINDEX0) & M_TIMERBACKOFFINDEX0)

#define A_TP_TCP_BACKOFF_REG1 0x354

#define S_TIMERBACKOFFINDEX7    24
#define M_TIMERBACKOFFINDEX7    0xff
#define V_TIMERBACKOFFINDEX7(x) ((x) << S_TIMERBACKOFFINDEX7)
#define G_TIMERBACKOFFINDEX7(x) (((x) >> S_TIMERBACKOFFINDEX7) & M_TIMERBACKOFFINDEX7)

#define S_TIMERBACKOFFINDEX6    16
#define M_TIMERBACKOFFINDEX6    0xff
#define V_TIMERBACKOFFINDEX6(x) ((x) << S_TIMERBACKOFFINDEX6)
#define G_TIMERBACKOFFINDEX6(x) (((x) >> S_TIMERBACKOFFINDEX6) & M_TIMERBACKOFFINDEX6)

#define S_TIMERBACKOFFINDEX5    8
#define M_TIMERBACKOFFINDEX5    0xff
#define V_TIMERBACKOFFINDEX5(x) ((x) << S_TIMERBACKOFFINDEX5)
#define G_TIMERBACKOFFINDEX5(x) (((x) >> S_TIMERBACKOFFINDEX5) & M_TIMERBACKOFFINDEX5)

#define S_TIMERBACKOFFINDEX4    0
#define M_TIMERBACKOFFINDEX4    0xff
#define V_TIMERBACKOFFINDEX4(x) ((x) << S_TIMERBACKOFFINDEX4)
#define G_TIMERBACKOFFINDEX4(x) (((x) >> S_TIMERBACKOFFINDEX4) & M_TIMERBACKOFFINDEX4)

#define A_TP_TCP_BACKOFF_REG2 0x358

#define S_TIMERBACKOFFINDEX11    24
#define M_TIMERBACKOFFINDEX11    0xff
#define V_TIMERBACKOFFINDEX11(x) ((x) << S_TIMERBACKOFFINDEX11)
#define G_TIMERBACKOFFINDEX11(x) (((x) >> S_TIMERBACKOFFINDEX11) & M_TIMERBACKOFFINDEX11)

#define S_TIMERBACKOFFINDEX10    16
#define M_TIMERBACKOFFINDEX10    0xff
#define V_TIMERBACKOFFINDEX10(x) ((x) << S_TIMERBACKOFFINDEX10)
#define G_TIMERBACKOFFINDEX10(x) (((x) >> S_TIMERBACKOFFINDEX10) & M_TIMERBACKOFFINDEX10)

#define S_TIMERBACKOFFINDEX9    8
#define M_TIMERBACKOFFINDEX9    0xff
#define V_TIMERBACKOFFINDEX9(x) ((x) << S_TIMERBACKOFFINDEX9)
#define G_TIMERBACKOFFINDEX9(x) (((x) >> S_TIMERBACKOFFINDEX9) & M_TIMERBACKOFFINDEX9)

#define S_TIMERBACKOFFINDEX8    0
#define M_TIMERBACKOFFINDEX8    0xff
#define V_TIMERBACKOFFINDEX8(x) ((x) << S_TIMERBACKOFFINDEX8)
#define G_TIMERBACKOFFINDEX8(x) (((x) >> S_TIMERBACKOFFINDEX8) & M_TIMERBACKOFFINDEX8)

#define A_TP_TCP_BACKOFF_REG3 0x35c

#define S_TIMERBACKOFFINDEX15    24
#define M_TIMERBACKOFFINDEX15    0xff
#define V_TIMERBACKOFFINDEX15(x) ((x) << S_TIMERBACKOFFINDEX15)
#define G_TIMERBACKOFFINDEX15(x) (((x) >> S_TIMERBACKOFFINDEX15) & M_TIMERBACKOFFINDEX15)

#define S_TIMERBACKOFFINDEX14    16
#define M_TIMERBACKOFFINDEX14    0xff
#define V_TIMERBACKOFFINDEX14(x) ((x) << S_TIMERBACKOFFINDEX14)
#define G_TIMERBACKOFFINDEX14(x) (((x) >> S_TIMERBACKOFFINDEX14) & M_TIMERBACKOFFINDEX14)

#define S_TIMERBACKOFFINDEX13    8
#define M_TIMERBACKOFFINDEX13    0xff
#define V_TIMERBACKOFFINDEX13(x) ((x) << S_TIMERBACKOFFINDEX13)
#define G_TIMERBACKOFFINDEX13(x) (((x) >> S_TIMERBACKOFFINDEX13) & M_TIMERBACKOFFINDEX13)

#define S_TIMERBACKOFFINDEX12    0
#define M_TIMERBACKOFFINDEX12    0xff
#define V_TIMERBACKOFFINDEX12(x) ((x) << S_TIMERBACKOFFINDEX12)
#define G_TIMERBACKOFFINDEX12(x) (((x) >> S_TIMERBACKOFFINDEX12) & M_TIMERBACKOFFINDEX12)

#define A_TP_PARA_REG0 0x360

#define S_INITCWND    24
#define M_INITCWND    0x7
#define V_INITCWND(x) ((x) << S_INITCWND)
#define G_INITCWND(x) (((x) >> S_INITCWND) & M_INITCWND)

#define S_DUPACKTHRESH    20
#define M_DUPACKTHRESH    0xf
#define V_DUPACKTHRESH(x) ((x) << S_DUPACKTHRESH)
#define G_DUPACKTHRESH(x) (((x) >> S_DUPACKTHRESH) & M_DUPACKTHRESH)

#define A_TP_PARA_REG1 0x364

#define S_INITRWND    16
#define M_INITRWND    0xffff
#define V_INITRWND(x) ((x) << S_INITRWND)
#define G_INITRWND(x) (((x) >> S_INITRWND) & M_INITRWND)

#define S_INITIALSSTHRESH    0
#define M_INITIALSSTHRESH    0xffff
#define V_INITIALSSTHRESH(x) ((x) << S_INITIALSSTHRESH)
#define G_INITIALSSTHRESH(x) (((x) >> S_INITIALSSTHRESH) & M_INITIALSSTHRESH)

#define A_TP_PARA_REG2 0x368

#define S_MAXRXDATA    16
#define M_MAXRXDATA    0xffff
#define V_MAXRXDATA(x) ((x) << S_MAXRXDATA)
#define G_MAXRXDATA(x) (((x) >> S_MAXRXDATA) & M_MAXRXDATA)

#define S_RXCOALESCESIZE    0
#define M_RXCOALESCESIZE    0xffff
#define V_RXCOALESCESIZE(x) ((x) << S_RXCOALESCESIZE)
#define G_RXCOALESCESIZE(x) (((x) >> S_RXCOALESCESIZE) & M_RXCOALESCESIZE)

#define A_TP_PARA_REG3 0x36c

#define S_TUNNELCNGDROP1    21
#define V_TUNNELCNGDROP1(x) ((x) << S_TUNNELCNGDROP1)
#define F_TUNNELCNGDROP1    V_TUNNELCNGDROP1(1U)

#define S_TUNNELCNGDROP0    20
#define V_TUNNELCNGDROP0(x) ((x) << S_TUNNELCNGDROP0)
#define F_TUNNELCNGDROP0    V_TUNNELCNGDROP0(1U)

#define S_TXDATAACKIDX    16
#define M_TXDATAACKIDX    0xf
#define V_TXDATAACKIDX(x) ((x) << S_TXDATAACKIDX)
#define G_TXDATAACKIDX(x) (((x) >> S_TXDATAACKIDX) & M_TXDATAACKIDX)

#define S_RXFRAGENABLE    12
#define M_RXFRAGENABLE    0x7
#define V_RXFRAGENABLE(x) ((x) << S_RXFRAGENABLE)
#define G_RXFRAGENABLE(x) (((x) >> S_RXFRAGENABLE) & M_RXFRAGENABLE)

#define S_TXPACEFIXEDSTRICT    11
#define V_TXPACEFIXEDSTRICT(x) ((x) << S_TXPACEFIXEDSTRICT)
#define F_TXPACEFIXEDSTRICT    V_TXPACEFIXEDSTRICT(1U)

#define S_TXPACEAUTOSTRICT    10
#define V_TXPACEAUTOSTRICT(x) ((x) << S_TXPACEAUTOSTRICT)
#define F_TXPACEAUTOSTRICT    V_TXPACEAUTOSTRICT(1U)

#define S_TXPACEFIXED    9
#define V_TXPACEFIXED(x) ((x) << S_TXPACEFIXED)
#define F_TXPACEFIXED    V_TXPACEFIXED(1U)

#define S_TXPACEAUTO    8
#define V_TXPACEAUTO(x) ((x) << S_TXPACEAUTO)
#define F_TXPACEAUTO    V_TXPACEAUTO(1U)

#define S_RXURGTUNNEL    6
#define V_RXURGTUNNEL(x) ((x) << S_RXURGTUNNEL)
#define F_RXURGTUNNEL    V_RXURGTUNNEL(1U)

#define S_RXURGMODE    5
#define V_RXURGMODE(x) ((x) << S_RXURGMODE)
#define F_RXURGMODE    V_RXURGMODE(1U)

#define S_TXURGMODE    4
#define V_TXURGMODE(x) ((x) << S_TXURGMODE)
#define F_TXURGMODE    V_TXURGMODE(1U)

#define S_CNGCTRLMODE    2
#define M_CNGCTRLMODE    0x3
#define V_CNGCTRLMODE(x) ((x) << S_CNGCTRLMODE)
#define G_CNGCTRLMODE(x) (((x) >> S_CNGCTRLMODE) & M_CNGCTRLMODE)

#define S_RXCOALESCEENABLE    1
#define V_RXCOALESCEENABLE(x) ((x) << S_RXCOALESCEENABLE)
#define F_RXCOALESCEENABLE    V_RXCOALESCEENABLE(1U)

#define S_RXCOALESCEPSHEN    0
#define V_RXCOALESCEPSHEN(x) ((x) << S_RXCOALESCEPSHEN)
#define F_RXCOALESCEPSHEN    V_RXCOALESCEPSHEN(1U)

#define A_TP_PARA_REG4 0x370

#define S_HIGHSPEEDCFG    24
#define M_HIGHSPEEDCFG    0xff
#define V_HIGHSPEEDCFG(x) ((x) << S_HIGHSPEEDCFG)
#define G_HIGHSPEEDCFG(x) (((x) >> S_HIGHSPEEDCFG) & M_HIGHSPEEDCFG)

#define S_NEWRENOCFG    16
#define M_NEWRENOCFG    0xff
#define V_NEWRENOCFG(x) ((x) << S_NEWRENOCFG)
#define G_NEWRENOCFG(x) (((x) >> S_NEWRENOCFG) & M_NEWRENOCFG)

#define S_TAHOECFG    8
#define M_TAHOECFG    0xff
#define V_TAHOECFG(x) ((x) << S_TAHOECFG)
#define G_TAHOECFG(x) (((x) >> S_TAHOECFG) & M_TAHOECFG)

#define S_RENOCFG    0
#define M_RENOCFG    0xff
#define V_RENOCFG(x) ((x) << S_RENOCFG)
#define G_RENOCFG(x) (((x) >> S_RENOCFG) & M_RENOCFG)

#define A_TP_PARA_REG5 0x374

#define S_INDICATESIZE    16
#define M_INDICATESIZE    0xffff
#define V_INDICATESIZE(x) ((x) << S_INDICATESIZE)
#define G_INDICATESIZE(x) (((x) >> S_INDICATESIZE) & M_INDICATESIZE)

#define S_SCHDENABLE    8
#define V_SCHDENABLE(x) ((x) << S_SCHDENABLE)
#define F_SCHDENABLE    V_SCHDENABLE(1U)

#define S_RXDDPOFFINIT    3
#define V_RXDDPOFFINIT(x) ((x) << S_RXDDPOFFINIT)
#define F_RXDDPOFFINIT    V_RXDDPOFFINIT(1U)

#define S_ONFLYDDPENABLE    2
#define V_ONFLYDDPENABLE(x) ((x) << S_ONFLYDDPENABLE)
#define F_ONFLYDDPENABLE    V_ONFLYDDPENABLE(1U)

#define S_DACKTIMERSPIN    1
#define V_DACKTIMERSPIN(x) ((x) << S_DACKTIMERSPIN)
#define F_DACKTIMERSPIN    V_DACKTIMERSPIN(1U)

#define S_PUSHTIMERENABLE    0
#define V_PUSHTIMERENABLE(x) ((x) << S_PUSHTIMERENABLE)
#define F_PUSHTIMERENABLE    V_PUSHTIMERENABLE(1U)

#define A_TP_PARA_REG6 0x378

#define S_TXPDUSIZEADJ    16
#define M_TXPDUSIZEADJ    0xff
#define V_TXPDUSIZEADJ(x) ((x) << S_TXPDUSIZEADJ)
#define G_TXPDUSIZEADJ(x) (((x) >> S_TXPDUSIZEADJ) & M_TXPDUSIZEADJ)

#define S_ENABLEDEFERACK    12
#define V_ENABLEDEFERACK(x) ((x) << S_ENABLEDEFERACK)
#define F_ENABLEDEFERACK    V_ENABLEDEFERACK(1U)

#define S_ENABLEESND    11
#define V_ENABLEESND(x) ((x) << S_ENABLEESND)
#define F_ENABLEESND    V_ENABLEESND(1U)

#define S_ENABLECSND    10
#define V_ENABLECSND(x) ((x) << S_ENABLECSND)
#define F_ENABLECSND    V_ENABLECSND(1U)

#define S_ENABLEPDUE    9
#define V_ENABLEPDUE(x) ((x) << S_ENABLEPDUE)
#define F_ENABLEPDUE    V_ENABLEPDUE(1U)

#define S_ENABLEPDUC    8
#define V_ENABLEPDUC(x) ((x) << S_ENABLEPDUC)
#define F_ENABLEPDUC    V_ENABLEPDUC(1U)

#define S_ENABLEBUFI    7
#define V_ENABLEBUFI(x) ((x) << S_ENABLEBUFI)
#define F_ENABLEBUFI    V_ENABLEBUFI(1U)

#define S_ENABLEBUFE    6
#define V_ENABLEBUFE(x) ((x) << S_ENABLEBUFE)
#define F_ENABLEBUFE    V_ENABLEBUFE(1U)

#define S_ENABLEDEFER    5
#define V_ENABLEDEFER(x) ((x) << S_ENABLEDEFER)
#define F_ENABLEDEFER    V_ENABLEDEFER(1U)

#define S_ENABLECLEARRXMTOOS    4
#define V_ENABLECLEARRXMTOOS(x) ((x) << S_ENABLECLEARRXMTOOS)
#define F_ENABLECLEARRXMTOOS    V_ENABLECLEARRXMTOOS(1U)

#define S_DISABLEPDUCNG    3
#define V_DISABLEPDUCNG(x) ((x) << S_DISABLEPDUCNG)
#define F_DISABLEPDUCNG    V_DISABLEPDUCNG(1U)

#define S_DISABLEPDUTIMEOUT    2
#define V_DISABLEPDUTIMEOUT(x) ((x) << S_DISABLEPDUTIMEOUT)
#define F_DISABLEPDUTIMEOUT    V_DISABLEPDUTIMEOUT(1U)

#define S_DISABLEPDURXMT    1
#define V_DISABLEPDURXMT(x) ((x) << S_DISABLEPDURXMT)
#define F_DISABLEPDURXMT    V_DISABLEPDURXMT(1U)

#define S_DISABLEPDUXMT    0
#define V_DISABLEPDUXMT(x) ((x) << S_DISABLEPDUXMT)
#define F_DISABLEPDUXMT    V_DISABLEPDUXMT(1U)

#define S_ENABLEEPDU    14
#define V_ENABLEEPDU(x) ((x) << S_ENABLEEPDU)
#define F_ENABLEEPDU    V_ENABLEEPDU(1U)

#define S_T3A_ENABLEESND    13
#define V_T3A_ENABLEESND(x) ((x) << S_T3A_ENABLEESND)
#define F_T3A_ENABLEESND    V_T3A_ENABLEESND(1U)

#define S_T3A_ENABLECSND    12
#define V_T3A_ENABLECSND(x) ((x) << S_T3A_ENABLECSND)
#define F_T3A_ENABLECSND    V_T3A_ENABLECSND(1U)

#define S_T3A_ENABLEDEFERACK    9
#define V_T3A_ENABLEDEFERACK(x) ((x) << S_T3A_ENABLEDEFERACK)
#define F_T3A_ENABLEDEFERACK    V_T3A_ENABLEDEFERACK(1U)

#define S_ENABLEPDUI    7
#define V_ENABLEPDUI(x) ((x) << S_ENABLEPDUI)
#define F_ENABLEPDUI    V_ENABLEPDUI(1U)

#define S_T3A_ENABLEPDUE    6
#define V_T3A_ENABLEPDUE(x) ((x) << S_T3A_ENABLEPDUE)
#define F_T3A_ENABLEPDUE    V_T3A_ENABLEPDUE(1U)

#define A_TP_PARA_REG7 0x37c

#define S_PMMAXXFERLEN1    16
#define M_PMMAXXFERLEN1    0xffff
#define V_PMMAXXFERLEN1(x) ((x) << S_PMMAXXFERLEN1)
#define G_PMMAXXFERLEN1(x) (((x) >> S_PMMAXXFERLEN1) & M_PMMAXXFERLEN1)

#define S_PMMAXXFERLEN0    0
#define M_PMMAXXFERLEN0    0xffff
#define V_PMMAXXFERLEN0(x) ((x) << S_PMMAXXFERLEN0)
#define G_PMMAXXFERLEN0(x) (((x) >> S_PMMAXXFERLEN0) & M_PMMAXXFERLEN0)

#define A_TP_TIMER_RESOLUTION 0x390

#define S_TIMERRESOLUTION    16
#define M_TIMERRESOLUTION    0xff
#define V_TIMERRESOLUTION(x) ((x) << S_TIMERRESOLUTION)
#define G_TIMERRESOLUTION(x) (((x) >> S_TIMERRESOLUTION) & M_TIMERRESOLUTION)

#define S_TIMESTAMPRESOLUTION    8
#define M_TIMESTAMPRESOLUTION    0xff
#define V_TIMESTAMPRESOLUTION(x) ((x) << S_TIMESTAMPRESOLUTION)
#define G_TIMESTAMPRESOLUTION(x) (((x) >> S_TIMESTAMPRESOLUTION) & M_TIMESTAMPRESOLUTION)

#define S_DELAYEDACKRESOLUTION    0
#define M_DELAYEDACKRESOLUTION    0xff
#define V_DELAYEDACKRESOLUTION(x) ((x) << S_DELAYEDACKRESOLUTION)
#define G_DELAYEDACKRESOLUTION(x) (((x) >> S_DELAYEDACKRESOLUTION) & M_DELAYEDACKRESOLUTION)

#define A_TP_MSL 0x394

#define S_MSL    0
#define M_MSL    0x3fffffff
#define V_MSL(x) ((x) << S_MSL)
#define G_MSL(x) (((x) >> S_MSL) & M_MSL)

#define A_TP_RXT_MIN 0x398

#define S_RXTMIN    0
#define M_RXTMIN    0x3fffffff
#define V_RXTMIN(x) ((x) << S_RXTMIN)
#define G_RXTMIN(x) (((x) >> S_RXTMIN) & M_RXTMIN)

#define A_TP_RXT_MAX 0x39c

#define S_RXTMAX    0
#define M_RXTMAX    0x3fffffff
#define V_RXTMAX(x) ((x) << S_RXTMAX)
#define G_RXTMAX(x) (((x) >> S_RXTMAX) & M_RXTMAX)

#define A_TP_PERS_MIN 0x3a0

#define S_PERSMIN    0
#define M_PERSMIN    0x3fffffff
#define V_PERSMIN(x) ((x) << S_PERSMIN)
#define G_PERSMIN(x) (((x) >> S_PERSMIN) & M_PERSMIN)

#define A_TP_PERS_MAX 0x3a4

#define S_PERSMAX    0
#define M_PERSMAX    0x3fffffff
#define V_PERSMAX(x) ((x) << S_PERSMAX)
#define G_PERSMAX(x) (((x) >> S_PERSMAX) & M_PERSMAX)

#define A_TP_KEEP_IDLE 0x3a8

#define S_KEEPALIVEIDLE    0
#define M_KEEPALIVEIDLE    0x3fffffff
#define V_KEEPALIVEIDLE(x) ((x) << S_KEEPALIVEIDLE)
#define G_KEEPALIVEIDLE(x) (((x) >> S_KEEPALIVEIDLE) & M_KEEPALIVEIDLE)

#define A_TP_KEEP_INTVL 0x3ac

#define S_KEEPALIVEINTVL    0
#define M_KEEPALIVEINTVL    0x3fffffff
#define V_KEEPALIVEINTVL(x) ((x) << S_KEEPALIVEINTVL)
#define G_KEEPALIVEINTVL(x) (((x) >> S_KEEPALIVEINTVL) & M_KEEPALIVEINTVL)

#define A_TP_INIT_SRTT 0x3b0

#define S_INITSRTT    0
#define M_INITSRTT    0xffff
#define V_INITSRTT(x) ((x) << S_INITSRTT)
#define G_INITSRTT(x) (((x) >> S_INITSRTT) & M_INITSRTT)

#define A_TP_DACK_TIMER 0x3b4

#define S_DACKTIME    0
#define M_DACKTIME    0xfff
#define V_DACKTIME(x) ((x) << S_DACKTIME)
#define G_DACKTIME(x) (((x) >> S_DACKTIME) & M_DACKTIME)

#define A_TP_FINWAIT2_TIMER 0x3b8

#define S_FINWAIT2TIME    0
#define M_FINWAIT2TIME    0x3fffffff
#define V_FINWAIT2TIME(x) ((x) << S_FINWAIT2TIME)
#define G_FINWAIT2TIME(x) (((x) >> S_FINWAIT2TIME) & M_FINWAIT2TIME)

#define A_TP_FAST_FINWAIT2_TIMER 0x3bc

#define S_FASTFINWAIT2TIME    0
#define M_FASTFINWAIT2TIME    0x3fffffff
#define V_FASTFINWAIT2TIME(x) ((x) << S_FASTFINWAIT2TIME)
#define G_FASTFINWAIT2TIME(x) (((x) >> S_FASTFINWAIT2TIME) & M_FASTFINWAIT2TIME)

#define A_TP_SHIFT_CNT 0x3c0

#define S_SYNSHIFTMAX    24
#define M_SYNSHIFTMAX    0xff
#define V_SYNSHIFTMAX(x) ((x) << S_SYNSHIFTMAX)
#define G_SYNSHIFTMAX(x) (((x) >> S_SYNSHIFTMAX) & M_SYNSHIFTMAX)

#define S_RXTSHIFTMAXR1    20
#define M_RXTSHIFTMAXR1    0xf
#define V_RXTSHIFTMAXR1(x) ((x) << S_RXTSHIFTMAXR1)
#define G_RXTSHIFTMAXR1(x) (((x) >> S_RXTSHIFTMAXR1) & M_RXTSHIFTMAXR1)

#define S_RXTSHIFTMAXR2    16
#define M_RXTSHIFTMAXR2    0xf
#define V_RXTSHIFTMAXR2(x) ((x) << S_RXTSHIFTMAXR2)
#define G_RXTSHIFTMAXR2(x) (((x) >> S_RXTSHIFTMAXR2) & M_RXTSHIFTMAXR2)

#define S_PERSHIFTBACKOFFMAX    12
#define M_PERSHIFTBACKOFFMAX    0xf
#define V_PERSHIFTBACKOFFMAX(x) ((x) << S_PERSHIFTBACKOFFMAX)
#define G_PERSHIFTBACKOFFMAX(x) (((x) >> S_PERSHIFTBACKOFFMAX) & M_PERSHIFTBACKOFFMAX)

#define S_PERSHIFTMAX    8
#define M_PERSHIFTMAX    0xf
#define V_PERSHIFTMAX(x) ((x) << S_PERSHIFTMAX)
#define G_PERSHIFTMAX(x) (((x) >> S_PERSHIFTMAX) & M_PERSHIFTMAX)

#define S_KEEPALIVEMAX    0
#define M_KEEPALIVEMAX    0xff
#define V_KEEPALIVEMAX(x) ((x) << S_KEEPALIVEMAX)
#define G_KEEPALIVEMAX(x) (((x) >> S_KEEPALIVEMAX) & M_KEEPALIVEMAX)

#define A_TP_TIME_HI 0x3c8
#define A_TP_TIME_LO 0x3cc
#define A_TP_MTU_PORT_TABLE 0x3d0

#define S_PORT1MTUVALUE    16
#define M_PORT1MTUVALUE    0xffff
#define V_PORT1MTUVALUE(x) ((x) << S_PORT1MTUVALUE)
#define G_PORT1MTUVALUE(x) (((x) >> S_PORT1MTUVALUE) & M_PORT1MTUVALUE)

#define S_PORT0MTUVALUE    0
#define M_PORT0MTUVALUE    0xffff
#define V_PORT0MTUVALUE(x) ((x) << S_PORT0MTUVALUE)
#define G_PORT0MTUVALUE(x) (((x) >> S_PORT0MTUVALUE) & M_PORT0MTUVALUE)

#define A_TP_ULP_TABLE 0x3d4

#define S_ULPTYPE7FIELD    28
#define M_ULPTYPE7FIELD    0xf
#define V_ULPTYPE7FIELD(x) ((x) << S_ULPTYPE7FIELD)
#define G_ULPTYPE7FIELD(x) (((x) >> S_ULPTYPE7FIELD) & M_ULPTYPE7FIELD)

#define S_ULPTYPE6FIELD    24
#define M_ULPTYPE6FIELD    0xf
#define V_ULPTYPE6FIELD(x) ((x) << S_ULPTYPE6FIELD)
#define G_ULPTYPE6FIELD(x) (((x) >> S_ULPTYPE6FIELD) & M_ULPTYPE6FIELD)

#define S_ULPTYPE5FIELD    20
#define M_ULPTYPE5FIELD    0xf
#define V_ULPTYPE5FIELD(x) ((x) << S_ULPTYPE5FIELD)
#define G_ULPTYPE5FIELD(x) (((x) >> S_ULPTYPE5FIELD) & M_ULPTYPE5FIELD)

#define S_ULPTYPE4FIELD    16
#define M_ULPTYPE4FIELD    0xf
#define V_ULPTYPE4FIELD(x) ((x) << S_ULPTYPE4FIELD)
#define G_ULPTYPE4FIELD(x) (((x) >> S_ULPTYPE4FIELD) & M_ULPTYPE4FIELD)

#define S_ULPTYPE3FIELD    12
#define M_ULPTYPE3FIELD    0xf
#define V_ULPTYPE3FIELD(x) ((x) << S_ULPTYPE3FIELD)
#define G_ULPTYPE3FIELD(x) (((x) >> S_ULPTYPE3FIELD) & M_ULPTYPE3FIELD)

#define S_ULPTYPE2FIELD    8
#define M_ULPTYPE2FIELD    0xf
#define V_ULPTYPE2FIELD(x) ((x) << S_ULPTYPE2FIELD)
#define G_ULPTYPE2FIELD(x) (((x) >> S_ULPTYPE2FIELD) & M_ULPTYPE2FIELD)

#define S_ULPTYPE1FIELD    4
#define M_ULPTYPE1FIELD    0xf
#define V_ULPTYPE1FIELD(x) ((x) << S_ULPTYPE1FIELD)
#define G_ULPTYPE1FIELD(x) (((x) >> S_ULPTYPE1FIELD) & M_ULPTYPE1FIELD)

#define S_ULPTYPE0FIELD    0
#define M_ULPTYPE0FIELD    0xf
#define V_ULPTYPE0FIELD(x) ((x) << S_ULPTYPE0FIELD)
#define G_ULPTYPE0FIELD(x) (((x) >> S_ULPTYPE0FIELD) & M_ULPTYPE0FIELD)

#define A_TP_PACE_TABLE 0x3d8
#define A_TP_CCTRL_TABLE 0x3dc
#define A_TP_TOS_TABLE 0x3e0
#define A_TP_MTU_TABLE 0x3e4
#define A_TP_RSS_MAP_TABLE 0x3e8
#define A_TP_RSS_LKP_TABLE 0x3ec
#define A_TP_RSS_CONFIG 0x3f0

#define S_TNL4TUPEN    29
#define V_TNL4TUPEN(x) ((x) << S_TNL4TUPEN)
#define F_TNL4TUPEN    V_TNL4TUPEN(1U)

#define S_TNL2TUPEN    28
#define V_TNL2TUPEN(x) ((x) << S_TNL2TUPEN)
#define F_TNL2TUPEN    V_TNL2TUPEN(1U)

#define S_TNLPRTEN    26
#define V_TNLPRTEN(x) ((x) << S_TNLPRTEN)
#define F_TNLPRTEN    V_TNLPRTEN(1U)

#define S_TNLMAPEN    25
#define V_TNLMAPEN(x) ((x) << S_TNLMAPEN)
#define F_TNLMAPEN    V_TNLMAPEN(1U)

#define S_TNLLKPEN    24
#define V_TNLLKPEN(x) ((x) << S_TNLLKPEN)
#define F_TNLLKPEN    V_TNLLKPEN(1U)

#define S_OFD4TUPEN    21
#define V_OFD4TUPEN(x) ((x) << S_OFD4TUPEN)
#define F_OFD4TUPEN    V_OFD4TUPEN(1U)

#define S_OFD2TUPEN    20
#define V_OFD2TUPEN(x) ((x) << S_OFD2TUPEN)
#define F_OFD2TUPEN    V_OFD2TUPEN(1U)

#define S_OFDMAPEN    17
#define V_OFDMAPEN(x) ((x) << S_OFDMAPEN)
#define F_OFDMAPEN    V_OFDMAPEN(1U)

#define S_OFDLKPEN    16
#define V_OFDLKPEN(x) ((x) << S_OFDLKPEN)
#define F_OFDLKPEN    V_OFDLKPEN(1U)

#define S_SYN4TUPEN    13
#define V_SYN4TUPEN(x) ((x) << S_SYN4TUPEN)
#define F_SYN4TUPEN    V_SYN4TUPEN(1U)

#define S_SYN2TUPEN    12
#define V_SYN2TUPEN(x) ((x) << S_SYN2TUPEN)
#define F_SYN2TUPEN    V_SYN2TUPEN(1U)

#define S_SYNMAPEN    9
#define V_SYNMAPEN(x) ((x) << S_SYNMAPEN)
#define F_SYNMAPEN    V_SYNMAPEN(1U)

#define S_SYNLKPEN    8
#define V_SYNLKPEN(x) ((x) << S_SYNLKPEN)
#define F_SYNLKPEN    V_SYNLKPEN(1U)

#define S_RRCPLMAPEN    7
#define V_RRCPLMAPEN(x) ((x) << S_RRCPLMAPEN)
#define F_RRCPLMAPEN    V_RRCPLMAPEN(1U)

#define S_RRCPLCPUSIZE    4
#define M_RRCPLCPUSIZE    0x7
#define V_RRCPLCPUSIZE(x) ((x) << S_RRCPLCPUSIZE)
#define G_RRCPLCPUSIZE(x) (((x) >> S_RRCPLCPUSIZE) & M_RRCPLCPUSIZE)

#define S_RQFEEDBACKENABLE    3
#define V_RQFEEDBACKENABLE(x) ((x) << S_RQFEEDBACKENABLE)
#define F_RQFEEDBACKENABLE    V_RQFEEDBACKENABLE(1U)

#define S_HASHTOEPLITZ    2
#define V_HASHTOEPLITZ(x) ((x) << S_HASHTOEPLITZ)
#define F_HASHTOEPLITZ    V_HASHTOEPLITZ(1U)

#define S_HASHSAVE    1
#define V_HASHSAVE(x) ((x) << S_HASHSAVE)
#define F_HASHSAVE    V_HASHSAVE(1U)

#define S_DISABLE    0
#define V_DISABLE(x) ((x) << S_DISABLE)
#define F_DISABLE    V_DISABLE(1U)

#define A_TP_RSS_CONFIG_TNL 0x3f4

#define S_MASKSIZE    28
#define M_MASKSIZE    0x7
#define V_MASKSIZE(x) ((x) << S_MASKSIZE)
#define G_MASKSIZE(x) (((x) >> S_MASKSIZE) & M_MASKSIZE)

#define S_DEFAULTCPUBASE    22
#define M_DEFAULTCPUBASE    0x3f
#define V_DEFAULTCPUBASE(x) ((x) << S_DEFAULTCPUBASE)
#define G_DEFAULTCPUBASE(x) (((x) >> S_DEFAULTCPUBASE) & M_DEFAULTCPUBASE)

#define S_DEFAULTCPU    16
#define M_DEFAULTCPU    0x3f
#define V_DEFAULTCPU(x) ((x) << S_DEFAULTCPU)
#define G_DEFAULTCPU(x) (((x) >> S_DEFAULTCPU) & M_DEFAULTCPU)

#define S_DEFAULTQUEUE    0
#define M_DEFAULTQUEUE    0xffff
#define V_DEFAULTQUEUE(x) ((x) << S_DEFAULTQUEUE)
#define G_DEFAULTQUEUE(x) (((x) >> S_DEFAULTQUEUE) & M_DEFAULTQUEUE)

#define A_TP_RSS_CONFIG_OFD 0x3f8
#define A_TP_RSS_CONFIG_SYN 0x3fc
#define A_TP_RSS_SECRET_KEY0 0x400
#define A_TP_RSS_SECRET_KEY1 0x404
#define A_TP_RSS_SECRET_KEY2 0x408
#define A_TP_RSS_SECRET_KEY3 0x40c
#define A_TP_TM_PIO_ADDR 0x418
#define A_TP_TM_PIO_DATA 0x41c
#define A_TP_TX_MOD_QUE_TABLE 0x420
#define A_TP_TX_RESOURCE_LIMIT 0x424

#define S_TX_RESOURCE_LIMIT_CH1_PC    24
#define M_TX_RESOURCE_LIMIT_CH1_PC    0xff
#define V_TX_RESOURCE_LIMIT_CH1_PC(x) ((x) << S_TX_RESOURCE_LIMIT_CH1_PC)
#define G_TX_RESOURCE_LIMIT_CH1_PC(x) (((x) >> S_TX_RESOURCE_LIMIT_CH1_PC) & M_TX_RESOURCE_LIMIT_CH1_PC)

#define S_TX_RESOURCE_LIMIT_CH1_NON_PC    16
#define M_TX_RESOURCE_LIMIT_CH1_NON_PC    0xff
#define V_TX_RESOURCE_LIMIT_CH1_NON_PC(x) ((x) << S_TX_RESOURCE_LIMIT_CH1_NON_PC)
#define G_TX_RESOURCE_LIMIT_CH1_NON_PC(x) (((x) >> S_TX_RESOURCE_LIMIT_CH1_NON_PC) & M_TX_RESOURCE_LIMIT_CH1_NON_PC)

#define S_TX_RESOURCE_LIMIT_CH0_PC    8
#define M_TX_RESOURCE_LIMIT_CH0_PC    0xff
#define V_TX_RESOURCE_LIMIT_CH0_PC(x) ((x) << S_TX_RESOURCE_LIMIT_CH0_PC)
#define G_TX_RESOURCE_LIMIT_CH0_PC(x) (((x) >> S_TX_RESOURCE_LIMIT_CH0_PC) & M_TX_RESOURCE_LIMIT_CH0_PC)

#define S_TX_RESOURCE_LIMIT_CH0_NON_PC    0
#define M_TX_RESOURCE_LIMIT_CH0_NON_PC    0xff
#define V_TX_RESOURCE_LIMIT_CH0_NON_PC(x) ((x) << S_TX_RESOURCE_LIMIT_CH0_NON_PC)
#define G_TX_RESOURCE_LIMIT_CH0_NON_PC(x) (((x) >> S_TX_RESOURCE_LIMIT_CH0_NON_PC) & M_TX_RESOURCE_LIMIT_CH0_NON_PC)

#define A_TP_TX_MOD_QUEUE_REQ_MAP 0x428

#define S_RX_MOD_WEIGHT    24
#define M_RX_MOD_WEIGHT    0xff
#define V_RX_MOD_WEIGHT(x) ((x) << S_RX_MOD_WEIGHT)
#define G_RX_MOD_WEIGHT(x) (((x) >> S_RX_MOD_WEIGHT) & M_RX_MOD_WEIGHT)

#define S_TX_MOD_WEIGHT    16
#define M_TX_MOD_WEIGHT    0xff
#define V_TX_MOD_WEIGHT(x) ((x) << S_TX_MOD_WEIGHT)
#define G_TX_MOD_WEIGHT(x) (((x) >> S_TX_MOD_WEIGHT) & M_TX_MOD_WEIGHT)

#define S_TX_MOD_TIMER_MODE    8
#define M_TX_MOD_TIMER_MODE    0xff
#define V_TX_MOD_TIMER_MODE(x) ((x) << S_TX_MOD_TIMER_MODE)
#define G_TX_MOD_TIMER_MODE(x) (((x) >> S_TX_MOD_TIMER_MODE) & M_TX_MOD_TIMER_MODE)

#define S_TX_MOD_QUEUE_REQ_MAP    0
#define M_TX_MOD_QUEUE_REQ_MAP    0xff
#define V_TX_MOD_QUEUE_REQ_MAP(x) ((x) << S_TX_MOD_QUEUE_REQ_MAP)
#define G_TX_MOD_QUEUE_REQ_MAP(x) (((x) >> S_TX_MOD_QUEUE_REQ_MAP) & M_TX_MOD_QUEUE_REQ_MAP)

#define A_TP_TX_MOD_QUEUE_WEIGHT1 0x42c

#define S_TP_TX_MODQ_WGHT7    24
#define M_TP_TX_MODQ_WGHT7    0xff
#define V_TP_TX_MODQ_WGHT7(x) ((x) << S_TP_TX_MODQ_WGHT7)
#define G_TP_TX_MODQ_WGHT7(x) (((x) >> S_TP_TX_MODQ_WGHT7) & M_TP_TX_MODQ_WGHT7)

#define S_TP_TX_MODQ_WGHT6    16
#define M_TP_TX_MODQ_WGHT6    0xff
#define V_TP_TX_MODQ_WGHT6(x) ((x) << S_TP_TX_MODQ_WGHT6)
#define G_TP_TX_MODQ_WGHT6(x) (((x) >> S_TP_TX_MODQ_WGHT6) & M_TP_TX_MODQ_WGHT6)

#define S_TP_TX_MODQ_WGHT5    8
#define M_TP_TX_MODQ_WGHT5    0xff
#define V_TP_TX_MODQ_WGHT5(x) ((x) << S_TP_TX_MODQ_WGHT5)
#define G_TP_TX_MODQ_WGHT5(x) (((x) >> S_TP_TX_MODQ_WGHT5) & M_TP_TX_MODQ_WGHT5)

#define S_TP_TX_MODQ_WGHT4    0
#define M_TP_TX_MODQ_WGHT4    0xff
#define V_TP_TX_MODQ_WGHT4(x) ((x) << S_TP_TX_MODQ_WGHT4)
#define G_TP_TX_MODQ_WGHT4(x) (((x) >> S_TP_TX_MODQ_WGHT4) & M_TP_TX_MODQ_WGHT4)

#define A_TP_TX_MOD_QUEUE_WEIGHT0 0x430

#define S_TP_TX_MODQ_WGHT3    24
#define M_TP_TX_MODQ_WGHT3    0xff
#define V_TP_TX_MODQ_WGHT3(x) ((x) << S_TP_TX_MODQ_WGHT3)
#define G_TP_TX_MODQ_WGHT3(x) (((x) >> S_TP_TX_MODQ_WGHT3) & M_TP_TX_MODQ_WGHT3)

#define S_TP_TX_MODQ_WGHT2    16
#define M_TP_TX_MODQ_WGHT2    0xff
#define V_TP_TX_MODQ_WGHT2(x) ((x) << S_TP_TX_MODQ_WGHT2)
#define G_TP_TX_MODQ_WGHT2(x) (((x) >> S_TP_TX_MODQ_WGHT2) & M_TP_TX_MODQ_WGHT2)

#define S_TP_TX_MODQ_WGHT1    8
#define M_TP_TX_MODQ_WGHT1    0xff
#define V_TP_TX_MODQ_WGHT1(x) ((x) << S_TP_TX_MODQ_WGHT1)
#define G_TP_TX_MODQ_WGHT1(x) (((x) >> S_TP_TX_MODQ_WGHT1) & M_TP_TX_MODQ_WGHT1)

#define S_TP_TX_MODQ_WGHT0    0
#define M_TP_TX_MODQ_WGHT0    0xff
#define V_TP_TX_MODQ_WGHT0(x) ((x) << S_TP_TX_MODQ_WGHT0)
#define G_TP_TX_MODQ_WGHT0(x) (((x) >> S_TP_TX_MODQ_WGHT0) & M_TP_TX_MODQ_WGHT0)

#define A_TP_MOD_CHANNEL_WEIGHT 0x434

#define S_RX_MOD_CHANNEL_WEIGHT1    24
#define M_RX_MOD_CHANNEL_WEIGHT1    0xff
#define V_RX_MOD_CHANNEL_WEIGHT1(x) ((x) << S_RX_MOD_CHANNEL_WEIGHT1)
#define G_RX_MOD_CHANNEL_WEIGHT1(x) (((x) >> S_RX_MOD_CHANNEL_WEIGHT1) & M_RX_MOD_CHANNEL_WEIGHT1)

#define S_RX_MOD_CHANNEL_WEIGHT0    16
#define M_RX_MOD_CHANNEL_WEIGHT0    0xff
#define V_RX_MOD_CHANNEL_WEIGHT0(x) ((x) << S_RX_MOD_CHANNEL_WEIGHT0)
#define G_RX_MOD_CHANNEL_WEIGHT0(x) (((x) >> S_RX_MOD_CHANNEL_WEIGHT0) & M_RX_MOD_CHANNEL_WEIGHT0)

#define S_TX_MOD_CHANNEL_WEIGHT1    8
#define M_TX_MOD_CHANNEL_WEIGHT1    0xff
#define V_TX_MOD_CHANNEL_WEIGHT1(x) ((x) << S_TX_MOD_CHANNEL_WEIGHT1)
#define G_TX_MOD_CHANNEL_WEIGHT1(x) (((x) >> S_TX_MOD_CHANNEL_WEIGHT1) & M_TX_MOD_CHANNEL_WEIGHT1)

#define S_TX_MOD_CHANNEL_WEIGHT0    0
#define M_TX_MOD_CHANNEL_WEIGHT0    0xff
#define V_TX_MOD_CHANNEL_WEIGHT0(x) ((x) << S_TX_MOD_CHANNEL_WEIGHT0)
#define G_TX_MOD_CHANNEL_WEIGHT0(x) (((x) >> S_TX_MOD_CHANNEL_WEIGHT0) & M_TX_MOD_CHANNEL_WEIGHT0)

#define A_TP_MOD_RATE_LIMIT 0x438

#define S_RX_MOD_RATE_LIMIT_INC    24
#define M_RX_MOD_RATE_LIMIT_INC    0xff
#define V_RX_MOD_RATE_LIMIT_INC(x) ((x) << S_RX_MOD_RATE_LIMIT_INC)
#define G_RX_MOD_RATE_LIMIT_INC(x) (((x) >> S_RX_MOD_RATE_LIMIT_INC) & M_RX_MOD_RATE_LIMIT_INC)

#define S_RX_MOD_RATE_LIMIT_TICK    16
#define M_RX_MOD_RATE_LIMIT_TICK    0xff
#define V_RX_MOD_RATE_LIMIT_TICK(x) ((x) << S_RX_MOD_RATE_LIMIT_TICK)
#define G_RX_MOD_RATE_LIMIT_TICK(x) (((x) >> S_RX_MOD_RATE_LIMIT_TICK) & M_RX_MOD_RATE_LIMIT_TICK)

#define S_TX_MOD_RATE_LIMIT_INC    8
#define M_TX_MOD_RATE_LIMIT_INC    0xff
#define V_TX_MOD_RATE_LIMIT_INC(x) ((x) << S_TX_MOD_RATE_LIMIT_INC)
#define G_TX_MOD_RATE_LIMIT_INC(x) (((x) >> S_TX_MOD_RATE_LIMIT_INC) & M_TX_MOD_RATE_LIMIT_INC)

#define S_TX_MOD_RATE_LIMIT_TICK    0
#define M_TX_MOD_RATE_LIMIT_TICK    0xff
#define V_TX_MOD_RATE_LIMIT_TICK(x) ((x) << S_TX_MOD_RATE_LIMIT_TICK)
#define G_TX_MOD_RATE_LIMIT_TICK(x) (((x) >> S_TX_MOD_RATE_LIMIT_TICK) & M_TX_MOD_RATE_LIMIT_TICK)

#define A_TP_PIO_ADDR 0x440
#define A_TP_PIO_DATA 0x444
#define A_TP_RESET 0x44c

#define S_FLSTINITENABLE    1
#define V_FLSTINITENABLE(x) ((x) << S_FLSTINITENABLE)
#define F_FLSTINITENABLE    V_FLSTINITENABLE(1U)

#define S_TPRESET    0
#define V_TPRESET(x) ((x) << S_TPRESET)
#define F_TPRESET    V_TPRESET(1U)

#define A_TP_MIB_INDEX 0x450
#define A_TP_MIB_RDATA 0x454
#define A_TP_SYNC_TIME_HI 0x458
#define A_TP_SYNC_TIME_LO 0x45c
#define A_TP_CMM_MM_RX_FLST_BASE 0x460

#define S_CMRXFLSTBASE    0
#define M_CMRXFLSTBASE    0xfffffff
#define V_CMRXFLSTBASE(x) ((x) << S_CMRXFLSTBASE)
#define G_CMRXFLSTBASE(x) (((x) >> S_CMRXFLSTBASE) & M_CMRXFLSTBASE)

#define A_TP_CMM_MM_TX_FLST_BASE 0x464

#define S_CMTXFLSTBASE    0
#define M_CMTXFLSTBASE    0xfffffff
#define V_CMTXFLSTBASE(x) ((x) << S_CMTXFLSTBASE)
#define G_CMTXFLSTBASE(x) (((x) >> S_CMTXFLSTBASE) & M_CMTXFLSTBASE)

#define A_TP_CMM_MM_PS_FLST_BASE 0x468

#define S_CMPSFLSTBASE    0
#define M_CMPSFLSTBASE    0xfffffff
#define V_CMPSFLSTBASE(x) ((x) << S_CMPSFLSTBASE)
#define G_CMPSFLSTBASE(x) (((x) >> S_CMPSFLSTBASE) & M_CMPSFLSTBASE)

#define A_TP_CMM_MM_MAX_PSTRUCT 0x46c

#define S_CMMAXPSTRUCT    0
#define M_CMMAXPSTRUCT    0x1fffff
#define V_CMMAXPSTRUCT(x) ((x) << S_CMMAXPSTRUCT)
#define G_CMMAXPSTRUCT(x) (((x) >> S_CMMAXPSTRUCT) & M_CMMAXPSTRUCT)

#define A_TP_INT_ENABLE 0x470

#define S_FLMTXFLSTEMPTY    30
#define V_FLMTXFLSTEMPTY(x) ((x) << S_FLMTXFLSTEMPTY)
#define F_FLMTXFLSTEMPTY    V_FLMTXFLSTEMPTY(1U)

#define S_FLMRXFLSTEMPTY    29
#define V_FLMRXFLSTEMPTY(x) ((x) << S_FLMRXFLSTEMPTY)
#define F_FLMRXFLSTEMPTY    V_FLMRXFLSTEMPTY(1U)

#define S_FLMPERRSET    28
#define V_FLMPERRSET(x) ((x) << S_FLMPERRSET)
#define F_FLMPERRSET    V_FLMPERRSET(1U)

#define S_PROTOCOLSRAMPERR    27
#define V_PROTOCOLSRAMPERR(x) ((x) << S_PROTOCOLSRAMPERR)
#define F_PROTOCOLSRAMPERR    V_PROTOCOLSRAMPERR(1U)

#define S_ARPLUTPERR    26
#define V_ARPLUTPERR(x) ((x) << S_ARPLUTPERR)
#define F_ARPLUTPERR    V_ARPLUTPERR(1U)

#define S_CMRCFOPPERR    25
#define V_CMRCFOPPERR(x) ((x) << S_CMRCFOPPERR)
#define F_CMRCFOPPERR    V_CMRCFOPPERR(1U)

#define S_CMCACHEPERR    24
#define V_CMCACHEPERR(x) ((x) << S_CMCACHEPERR)
#define F_CMCACHEPERR    V_CMCACHEPERR(1U)

#define S_CMRCFDATAPERR    23
#define V_CMRCFDATAPERR(x) ((x) << S_CMRCFDATAPERR)
#define F_CMRCFDATAPERR    V_CMRCFDATAPERR(1U)

#define S_DBL2TLUTPERR    22
#define V_DBL2TLUTPERR(x) ((x) << S_DBL2TLUTPERR)
#define F_DBL2TLUTPERR    V_DBL2TLUTPERR(1U)

#define S_DBTXTIDPERR    21
#define V_DBTXTIDPERR(x) ((x) << S_DBTXTIDPERR)
#define F_DBTXTIDPERR    V_DBTXTIDPERR(1U)

#define S_DBEXTPERR    20
#define V_DBEXTPERR(x) ((x) << S_DBEXTPERR)
#define F_DBEXTPERR    V_DBEXTPERR(1U)

#define S_DBOPPERR    19
#define V_DBOPPERR(x) ((x) << S_DBOPPERR)
#define F_DBOPPERR    V_DBOPPERR(1U)

#define S_TMCACHEPERR    18
#define V_TMCACHEPERR(x) ((x) << S_TMCACHEPERR)
#define F_TMCACHEPERR    V_TMCACHEPERR(1U)

#define S_ETPOUTCPLFIFOPERR    17
#define V_ETPOUTCPLFIFOPERR(x) ((x) << S_ETPOUTCPLFIFOPERR)
#define F_ETPOUTCPLFIFOPERR    V_ETPOUTCPLFIFOPERR(1U)

#define S_ETPOUTTCPFIFOPERR    16
#define V_ETPOUTTCPFIFOPERR(x) ((x) << S_ETPOUTTCPFIFOPERR)
#define F_ETPOUTTCPFIFOPERR    V_ETPOUTTCPFIFOPERR(1U)

#define S_ETPOUTIPFIFOPERR    15
#define V_ETPOUTIPFIFOPERR(x) ((x) << S_ETPOUTIPFIFOPERR)
#define F_ETPOUTIPFIFOPERR    V_ETPOUTIPFIFOPERR(1U)

#define S_ETPOUTETHFIFOPERR    14
#define V_ETPOUTETHFIFOPERR(x) ((x) << S_ETPOUTETHFIFOPERR)
#define F_ETPOUTETHFIFOPERR    V_ETPOUTETHFIFOPERR(1U)

#define S_ETPINCPLFIFOPERR    13
#define V_ETPINCPLFIFOPERR(x) ((x) << S_ETPINCPLFIFOPERR)
#define F_ETPINCPLFIFOPERR    V_ETPINCPLFIFOPERR(1U)

#define S_ETPINTCPOPTFIFOPERR    12
#define V_ETPINTCPOPTFIFOPERR(x) ((x) << S_ETPINTCPOPTFIFOPERR)
#define F_ETPINTCPOPTFIFOPERR    V_ETPINTCPOPTFIFOPERR(1U)

#define S_ETPINTCPFIFOPERR    11
#define V_ETPINTCPFIFOPERR(x) ((x) << S_ETPINTCPFIFOPERR)
#define F_ETPINTCPFIFOPERR    V_ETPINTCPFIFOPERR(1U)

#define S_ETPINIPFIFOPERR    10
#define V_ETPINIPFIFOPERR(x) ((x) << S_ETPINIPFIFOPERR)
#define F_ETPINIPFIFOPERR    V_ETPINIPFIFOPERR(1U)

#define S_ETPINETHFIFOPERR    9
#define V_ETPINETHFIFOPERR(x) ((x) << S_ETPINETHFIFOPERR)
#define F_ETPINETHFIFOPERR    V_ETPINETHFIFOPERR(1U)

#define S_CTPOUTCPLFIFOPERR    8
#define V_CTPOUTCPLFIFOPERR(x) ((x) << S_CTPOUTCPLFIFOPERR)
#define F_CTPOUTCPLFIFOPERR    V_CTPOUTCPLFIFOPERR(1U)

#define S_CTPOUTTCPFIFOPERR    7
#define V_CTPOUTTCPFIFOPERR(x) ((x) << S_CTPOUTTCPFIFOPERR)
#define F_CTPOUTTCPFIFOPERR    V_CTPOUTTCPFIFOPERR(1U)

#define S_CTPOUTIPFIFOPERR    6
#define V_CTPOUTIPFIFOPERR(x) ((x) << S_CTPOUTIPFIFOPERR)
#define F_CTPOUTIPFIFOPERR    V_CTPOUTIPFIFOPERR(1U)

#define S_CTPOUTETHFIFOPERR    5
#define V_CTPOUTETHFIFOPERR(x) ((x) << S_CTPOUTETHFIFOPERR)
#define F_CTPOUTETHFIFOPERR    V_CTPOUTETHFIFOPERR(1U)

#define S_CTPINCPLFIFOPERR    4
#define V_CTPINCPLFIFOPERR(x) ((x) << S_CTPINCPLFIFOPERR)
#define F_CTPINCPLFIFOPERR    V_CTPINCPLFIFOPERR(1U)

#define S_CTPINTCPOPFIFOPERR    3
#define V_CTPINTCPOPFIFOPERR(x) ((x) << S_CTPINTCPOPFIFOPERR)
#define F_CTPINTCPOPFIFOPERR    V_CTPINTCPOPFIFOPERR(1U)

#define S_CTPINTCPFIFOPERR    2
#define V_CTPINTCPFIFOPERR(x) ((x) << S_CTPINTCPFIFOPERR)
#define F_CTPINTCPFIFOPERR    V_CTPINTCPFIFOPERR(1U)

#define S_CTPINIPFIFOPERR    1
#define V_CTPINIPFIFOPERR(x) ((x) << S_CTPINIPFIFOPERR)
#define F_CTPINIPFIFOPERR    V_CTPINIPFIFOPERR(1U)

#define S_CTPINETHFIFOPERR    0
#define V_CTPINETHFIFOPERR(x) ((x) << S_CTPINETHFIFOPERR)
#define F_CTPINETHFIFOPERR    V_CTPINETHFIFOPERR(1U)

#define A_TP_INT_CAUSE 0x474
#define A_TP_FLM_FREE_PS_CNT 0x480

#define S_FREEPSTRUCTCOUNT    0
#define M_FREEPSTRUCTCOUNT    0x1fffff
#define V_FREEPSTRUCTCOUNT(x) ((x) << S_FREEPSTRUCTCOUNT)
#define G_FREEPSTRUCTCOUNT(x) (((x) >> S_FREEPSTRUCTCOUNT) & M_FREEPSTRUCTCOUNT)

#define A_TP_FLM_FREE_RX_CNT 0x484

#define S_FREERXPAGECOUNT    0
#define M_FREERXPAGECOUNT    0x1fffff
#define V_FREERXPAGECOUNT(x) ((x) << S_FREERXPAGECOUNT)
#define G_FREERXPAGECOUNT(x) (((x) >> S_FREERXPAGECOUNT) & M_FREERXPAGECOUNT)

#define A_TP_FLM_FREE_TX_CNT 0x488

#define S_FREETXPAGECOUNT    0
#define M_FREETXPAGECOUNT    0x1fffff
#define V_FREETXPAGECOUNT(x) ((x) << S_FREETXPAGECOUNT)
#define G_FREETXPAGECOUNT(x) (((x) >> S_FREETXPAGECOUNT) & M_FREETXPAGECOUNT)

#define A_TP_TM_HEAP_PUSH_CNT 0x48c
#define A_TP_TM_HEAP_POP_CNT 0x490
#define A_TP_TM_DACK_PUSH_CNT 0x494
#define A_TP_TM_DACK_POP_CNT 0x498
#define A_TP_TM_MOD_PUSH_CNT 0x49c
#define A_TP_MOD_POP_CNT 0x4a0
#define A_TP_TIMER_SEPARATOR 0x4a4
#define A_TP_DEBUG_SEL 0x4a8
#define A_TP_DEBUG_FLAGS 0x4ac

#define S_RXTIMERDACKFIRST    26
#define V_RXTIMERDACKFIRST(x) ((x) << S_RXTIMERDACKFIRST)
#define F_RXTIMERDACKFIRST    V_RXTIMERDACKFIRST(1U)

#define S_RXTIMERDACK    25
#define V_RXTIMERDACK(x) ((x) << S_RXTIMERDACK)
#define F_RXTIMERDACK    V_RXTIMERDACK(1U)

#define S_RXTIMERHEARTBEAT    24
#define V_RXTIMERHEARTBEAT(x) ((x) << S_RXTIMERHEARTBEAT)
#define F_RXTIMERHEARTBEAT    V_RXTIMERHEARTBEAT(1U)

#define S_RXPAWSDROP    23
#define V_RXPAWSDROP(x) ((x) << S_RXPAWSDROP)
#define F_RXPAWSDROP    V_RXPAWSDROP(1U)

#define S_RXURGDATADROP    22
#define V_RXURGDATADROP(x) ((x) << S_RXURGDATADROP)
#define F_RXURGDATADROP    V_RXURGDATADROP(1U)

#define S_RXFUTUREDATA    21
#define V_RXFUTUREDATA(x) ((x) << S_RXFUTUREDATA)
#define F_RXFUTUREDATA    V_RXFUTUREDATA(1U)

#define S_RXRCVRXMDATA    20
#define V_RXRCVRXMDATA(x) ((x) << S_RXRCVRXMDATA)
#define F_RXRCVRXMDATA    V_RXRCVRXMDATA(1U)

#define S_RXRCVOOODATAFIN    19
#define V_RXRCVOOODATAFIN(x) ((x) << S_RXRCVOOODATAFIN)
#define F_RXRCVOOODATAFIN    V_RXRCVOOODATAFIN(1U)

#define S_RXRCVOOODATA    18
#define V_RXRCVOOODATA(x) ((x) << S_RXRCVOOODATA)
#define F_RXRCVOOODATA    V_RXRCVOOODATA(1U)

#define S_RXRCVWNDZERO    17
#define V_RXRCVWNDZERO(x) ((x) << S_RXRCVWNDZERO)
#define F_RXRCVWNDZERO    V_RXRCVWNDZERO(1U)

#define S_RXRCVWNDLTMSS    16
#define V_RXRCVWNDLTMSS(x) ((x) << S_RXRCVWNDLTMSS)
#define F_RXRCVWNDLTMSS    V_RXRCVWNDLTMSS(1U)

#define S_TXDUPACKINC    11
#define V_TXDUPACKINC(x) ((x) << S_TXDUPACKINC)
#define F_TXDUPACKINC    V_TXDUPACKINC(1U)

#define S_TXRXMURG    10
#define V_TXRXMURG(x) ((x) << S_TXRXMURG)
#define F_TXRXMURG    V_TXRXMURG(1U)

#define S_TXRXMFIN    9
#define V_TXRXMFIN(x) ((x) << S_TXRXMFIN)
#define F_TXRXMFIN    V_TXRXMFIN(1U)

#define S_TXRXMSYN    8
#define V_TXRXMSYN(x) ((x) << S_TXRXMSYN)
#define F_TXRXMSYN    V_TXRXMSYN(1U)

#define S_TXRXMNEWRENO    7
#define V_TXRXMNEWRENO(x) ((x) << S_TXRXMNEWRENO)
#define F_TXRXMNEWRENO    V_TXRXMNEWRENO(1U)

#define S_TXRXMFAST    6
#define V_TXRXMFAST(x) ((x) << S_TXRXMFAST)
#define F_TXRXMFAST    V_TXRXMFAST(1U)

#define S_TXRXMTIMER    5
#define V_TXRXMTIMER(x) ((x) << S_TXRXMTIMER)
#define F_TXRXMTIMER    V_TXRXMTIMER(1U)

#define S_TXRXMTIMERKEEPALIVE    4
#define V_TXRXMTIMERKEEPALIVE(x) ((x) << S_TXRXMTIMERKEEPALIVE)
#define F_TXRXMTIMERKEEPALIVE    V_TXRXMTIMERKEEPALIVE(1U)

#define S_TXRXMTIMERPERSIST    3
#define V_TXRXMTIMERPERSIST(x) ((x) << S_TXRXMTIMERPERSIST)
#define F_TXRXMTIMERPERSIST    V_TXRXMTIMERPERSIST(1U)

#define S_TXRCVADVSHRUNK    2
#define V_TXRCVADVSHRUNK(x) ((x) << S_TXRCVADVSHRUNK)
#define F_TXRCVADVSHRUNK    V_TXRCVADVSHRUNK(1U)

#define S_TXRCVADVZERO    1
#define V_TXRCVADVZERO(x) ((x) << S_TXRCVADVZERO)
#define F_TXRCVADVZERO    V_TXRCVADVZERO(1U)

#define S_TXRCVADVLTMSS    0
#define V_TXRCVADVLTMSS(x) ((x) << S_TXRCVADVLTMSS)
#define F_TXRCVADVLTMSS    V_TXRCVADVLTMSS(1U)

#define S_RXDEBUGFLAGS    16
#define M_RXDEBUGFLAGS    0xffff
#define V_RXDEBUGFLAGS(x) ((x) << S_RXDEBUGFLAGS)
#define G_RXDEBUGFLAGS(x) (((x) >> S_RXDEBUGFLAGS) & M_RXDEBUGFLAGS)

#define S_TXDEBUGFLAGS    0
#define M_TXDEBUGFLAGS    0xffff
#define V_TXDEBUGFLAGS(x) ((x) << S_TXDEBUGFLAGS)
#define G_TXDEBUGFLAGS(x) (((x) >> S_TXDEBUGFLAGS) & M_TXDEBUGFLAGS)

#define A_TP_PROXY_FLOW_CNTL 0x4b0
#define A_TP_CM_FLOW_CNTL_MODE 0x4b0

#define S_CMFLOWCACHEDISABLE    0
#define V_CMFLOWCACHEDISABLE(x) ((x) << S_CMFLOWCACHEDISABLE)
#define F_CMFLOWCACHEDISABLE    V_CMFLOWCACHEDISABLE(1U)

#define A_TP_PC_CONGESTION_CNTL 0x4b4

#define S_EDROPTUNNEL    19
#define V_EDROPTUNNEL(x) ((x) << S_EDROPTUNNEL)
#define F_EDROPTUNNEL    V_EDROPTUNNEL(1U)

#define S_CDROPTUNNEL    18
#define V_CDROPTUNNEL(x) ((x) << S_CDROPTUNNEL)
#define F_CDROPTUNNEL    V_CDROPTUNNEL(1U)

#define S_ETHRESHOLD    12
#define M_ETHRESHOLD    0x3f
#define V_ETHRESHOLD(x) ((x) << S_ETHRESHOLD)
#define G_ETHRESHOLD(x) (((x) >> S_ETHRESHOLD) & M_ETHRESHOLD)

#define S_CTHRESHOLD    6
#define M_CTHRESHOLD    0x3f
#define V_CTHRESHOLD(x) ((x) << S_CTHRESHOLD)
#define G_CTHRESHOLD(x) (((x) >> S_CTHRESHOLD) & M_CTHRESHOLD)

#define S_TXTHRESHOLD    0
#define M_TXTHRESHOLD    0x3f
#define V_TXTHRESHOLD(x) ((x) << S_TXTHRESHOLD)
#define G_TXTHRESHOLD(x) (((x) >> S_TXTHRESHOLD) & M_TXTHRESHOLD)

#define A_TP_TX_DROP_COUNT 0x4bc
#define A_TP_CLEAR_DEBUG 0x4c0

#define S_CLRDEBUG    0
#define V_CLRDEBUG(x) ((x) << S_CLRDEBUG)
#define F_CLRDEBUG    V_CLRDEBUG(1U)

#define A_TP_DEBUG_VEC 0x4c4
#define A_TP_DEBUG_VEC2 0x4c8
#define A_TP_DEBUG_REG_SEL 0x4cc
#define A_TP_DEBUG 0x4d0
#define A_TP_DBG_LA_CONFIG 0x4d4
#define A_TP_DBG_LA_DATAH 0x4d8
#define A_TP_DBG_LA_DATAL 0x4dc
#define A_TP_EMBED_OP_FIELD0 0x4e8
#define A_TP_EMBED_OP_FIELD1 0x4ec
#define A_TP_EMBED_OP_FIELD2 0x4f0
#define A_TP_EMBED_OP_FIELD3 0x4f4
#define A_TP_EMBED_OP_FIELD4 0x4f8
#define A_TP_EMBED_OP_FIELD5 0x4fc
#define A_TP_TX_MOD_Q7_Q6_TIMER_SEPARATOR 0x0
#define A_TP_TX_MOD_Q5_Q4_TIMER_SEPARATOR 0x1
#define A_TP_TX_MOD_Q3_Q2_TIMER_SEPARATOR 0x2
#define A_TP_TX_MOD_Q1_Q0_TIMER_SEPARATOR 0x3
#define A_TP_RX_MOD_Q1_Q0_TIMER_SEPARATOR 0x4
#define A_TP_TX_MOD_Q7_Q6_RATE_LIMIT 0x5
#define A_TP_TX_MOD_Q5_Q4_RATE_LIMIT 0x6
#define A_TP_TX_MOD_Q3_Q2_RATE_LIMIT 0x7
#define A_TP_TX_MOD_Q1_Q0_RATE_LIMIT 0x8
#define A_TP_RX_MOD_Q1_Q0_RATE_LIMIT 0x9
#define A_TP_TX_TRC_KEY0 0x20
#define A_TP_TX_TRC_MASK0 0x21
#define A_TP_TX_TRC_KEY1 0x22
#define A_TP_TX_TRC_MASK1 0x23
#define A_TP_TX_TRC_KEY2 0x24
#define A_TP_TX_TRC_MASK2 0x25
#define A_TP_TX_TRC_KEY3 0x26
#define A_TP_TX_TRC_MASK3 0x27
#define A_TP_IPMI_CFG1 0x28

#define S_VLANENABLE    31
#define V_VLANENABLE(x) ((x) << S_VLANENABLE)
#define F_VLANENABLE    V_VLANENABLE(1U)

#define S_PRIMARYPORTENABLE    30
#define V_PRIMARYPORTENABLE(x) ((x) << S_PRIMARYPORTENABLE)
#define F_PRIMARYPORTENABLE    V_PRIMARYPORTENABLE(1U)

#define S_SECUREPORTENABLE    29
#define V_SECUREPORTENABLE(x) ((x) << S_SECUREPORTENABLE)
#define F_SECUREPORTENABLE    V_SECUREPORTENABLE(1U)

#define S_ARPENABLE    28
#define V_ARPENABLE(x) ((x) << S_ARPENABLE)
#define F_ARPENABLE    V_ARPENABLE(1U)

#define S_VLAN    0
#define M_VLAN    0xffff
#define V_VLAN(x) ((x) << S_VLAN)
#define G_VLAN(x) (((x) >> S_VLAN) & M_VLAN)

#define A_TP_IPMI_CFG2 0x29

#define S_SECUREPORT    16
#define M_SECUREPORT    0xffff
#define V_SECUREPORT(x) ((x) << S_SECUREPORT)
#define G_SECUREPORT(x) (((x) >> S_SECUREPORT) & M_SECUREPORT)

#define S_PRIMARYPORT    0
#define M_PRIMARYPORT    0xffff
#define V_PRIMARYPORT(x) ((x) << S_PRIMARYPORT)
#define G_PRIMARYPORT(x) (((x) >> S_PRIMARYPORT) & M_PRIMARYPORT)

#define A_TP_RX_TRC_KEY0 0x120
#define A_TP_RX_TRC_MASK0 0x121
#define A_TP_RX_TRC_KEY1 0x122
#define A_TP_RX_TRC_MASK1 0x123
#define A_TP_RX_TRC_KEY2 0x124
#define A_TP_RX_TRC_MASK2 0x125
#define A_TP_RX_TRC_KEY3 0x126
#define A_TP_RX_TRC_MASK3 0x127
#define A_TP_QOS_RX_TOS_MAP_H 0x128
#define A_TP_QOS_RX_TOS_MAP_L 0x129
#define A_TP_QOS_RX_MAP_MODE 0x12a

#define S_DEFAULTCH    11
#define V_DEFAULTCH(x) ((x) << S_DEFAULTCH)
#define F_DEFAULTCH    V_DEFAULTCH(1U)

#define S_RXMAPMODE    8
#define M_RXMAPMODE    0x7
#define V_RXMAPMODE(x) ((x) << S_RXMAPMODE)
#define G_RXMAPMODE(x) (((x) >> S_RXMAPMODE) & M_RXMAPMODE)

#define S_RXVLANMAP    7
#define V_RXVLANMAP(x) ((x) << S_RXVLANMAP)
#define F_RXVLANMAP    V_RXVLANMAP(1U)

#define A_TP_TX_DROP_CFG_CH0 0x12b

#define S_TIMERENABLED    31
#define V_TIMERENABLED(x) ((x) << S_TIMERENABLED)
#define F_TIMERENABLED    V_TIMERENABLED(1U)

#define S_TIMERERRORENABLE    30
#define V_TIMERERRORENABLE(x) ((x) << S_TIMERERRORENABLE)
#define F_TIMERERRORENABLE    V_TIMERERRORENABLE(1U)

#define S_TIMERTHRESHOLD    4
#define M_TIMERTHRESHOLD    0x3ffffff
#define V_TIMERTHRESHOLD(x) ((x) << S_TIMERTHRESHOLD)
#define G_TIMERTHRESHOLD(x) (((x) >> S_TIMERTHRESHOLD) & M_TIMERTHRESHOLD)

#define S_PACKETDROPS    0
#define M_PACKETDROPS    0xf
#define V_PACKETDROPS(x) ((x) << S_PACKETDROPS)
#define G_PACKETDROPS(x) (((x) >> S_PACKETDROPS) & M_PACKETDROPS)

#define A_TP_TX_DROP_CFG_CH1 0x12c
#define A_TP_TX_DROP_CNT_CH0 0x12d

#define S_TXDROPCNTCH0SENT    16
#define M_TXDROPCNTCH0SENT    0xffff
#define V_TXDROPCNTCH0SENT(x) ((x) << S_TXDROPCNTCH0SENT)
#define G_TXDROPCNTCH0SENT(x) (((x) >> S_TXDROPCNTCH0SENT) & M_TXDROPCNTCH0SENT)

#define S_TXDROPCNTCH0RCVD    0
#define M_TXDROPCNTCH0RCVD    0xffff
#define V_TXDROPCNTCH0RCVD(x) ((x) << S_TXDROPCNTCH0RCVD)
#define G_TXDROPCNTCH0RCVD(x) (((x) >> S_TXDROPCNTCH0RCVD) & M_TXDROPCNTCH0RCVD)

#define A_TP_TX_DROP_CNT_CH1 0x12e

#define S_TXDROPCNTCH1SENT    16
#define M_TXDROPCNTCH1SENT    0xffff
#define V_TXDROPCNTCH1SENT(x) ((x) << S_TXDROPCNTCH1SENT)
#define G_TXDROPCNTCH1SENT(x) (((x) >> S_TXDROPCNTCH1SENT) & M_TXDROPCNTCH1SENT)

#define S_TXDROPCNTCH1RCVD    0
#define M_TXDROPCNTCH1RCVD    0xffff
#define V_TXDROPCNTCH1RCVD(x) ((x) << S_TXDROPCNTCH1RCVD)
#define G_TXDROPCNTCH1RCVD(x) (((x) >> S_TXDROPCNTCH1RCVD) & M_TXDROPCNTCH1RCVD)

#define A_TP_TX_DROP_MODE 0x12f

#define S_TXDROPMODECH1    1
#define V_TXDROPMODECH1(x) ((x) << S_TXDROPMODECH1)
#define F_TXDROPMODECH1    V_TXDROPMODECH1(1U)

#define S_TXDROPMODECH0    0
#define V_TXDROPMODECH0(x) ((x) << S_TXDROPMODECH0)
#define F_TXDROPMODECH0    V_TXDROPMODECH0(1U)

#define A_TP_VLAN_PRI_MAP 0x137

#define S_VLANPRIMAP7    14
#define M_VLANPRIMAP7    0x3
#define V_VLANPRIMAP7(x) ((x) << S_VLANPRIMAP7)
#define G_VLANPRIMAP7(x) (((x) >> S_VLANPRIMAP7) & M_VLANPRIMAP7)

#define S_VLANPRIMAP6    12
#define M_VLANPRIMAP6    0x3
#define V_VLANPRIMAP6(x) ((x) << S_VLANPRIMAP6)
#define G_VLANPRIMAP6(x) (((x) >> S_VLANPRIMAP6) & M_VLANPRIMAP6)

#define S_VLANPRIMAP5    10
#define M_VLANPRIMAP5    0x3
#define V_VLANPRIMAP5(x) ((x) << S_VLANPRIMAP5)
#define G_VLANPRIMAP5(x) (((x) >> S_VLANPRIMAP5) & M_VLANPRIMAP5)

#define S_VLANPRIMAP4    8
#define M_VLANPRIMAP4    0x3
#define V_VLANPRIMAP4(x) ((x) << S_VLANPRIMAP4)
#define G_VLANPRIMAP4(x) (((x) >> S_VLANPRIMAP4) & M_VLANPRIMAP4)

#define S_VLANPRIMAP3    6
#define M_VLANPRIMAP3    0x3
#define V_VLANPRIMAP3(x) ((x) << S_VLANPRIMAP3)
#define G_VLANPRIMAP3(x) (((x) >> S_VLANPRIMAP3) & M_VLANPRIMAP3)

#define S_VLANPRIMAP2    4
#define M_VLANPRIMAP2    0x3
#define V_VLANPRIMAP2(x) ((x) << S_VLANPRIMAP2)
#define G_VLANPRIMAP2(x) (((x) >> S_VLANPRIMAP2) & M_VLANPRIMAP2)

#define S_VLANPRIMAP1    2
#define M_VLANPRIMAP1    0x3
#define V_VLANPRIMAP1(x) ((x) << S_VLANPRIMAP1)
#define G_VLANPRIMAP1(x) (((x) >> S_VLANPRIMAP1) & M_VLANPRIMAP1)

#define S_VLANPRIMAP0    0
#define M_VLANPRIMAP0    0x3
#define V_VLANPRIMAP0(x) ((x) << S_VLANPRIMAP0)
#define G_VLANPRIMAP0(x) (((x) >> S_VLANPRIMAP0) & M_VLANPRIMAP0)

#define A_TP_MAC_MATCH_MAP0 0x138

#define S_MACMATCHMAP7    21
#define M_MACMATCHMAP7    0x7
#define V_MACMATCHMAP7(x) ((x) << S_MACMATCHMAP7)
#define G_MACMATCHMAP7(x) (((x) >> S_MACMATCHMAP7) & M_MACMATCHMAP7)

#define S_MACMATCHMAP6    18
#define M_MACMATCHMAP6    0x7
#define V_MACMATCHMAP6(x) ((x) << S_MACMATCHMAP6)
#define G_MACMATCHMAP6(x) (((x) >> S_MACMATCHMAP6) & M_MACMATCHMAP6)

#define S_MACMATCHMAP5    15
#define M_MACMATCHMAP5    0x7
#define V_MACMATCHMAP5(x) ((x) << S_MACMATCHMAP5)
#define G_MACMATCHMAP5(x) (((x) >> S_MACMATCHMAP5) & M_MACMATCHMAP5)

#define S_MACMATCHMAP4    12
#define M_MACMATCHMAP4    0x7
#define V_MACMATCHMAP4(x) ((x) << S_MACMATCHMAP4)
#define G_MACMATCHMAP4(x) (((x) >> S_MACMATCHMAP4) & M_MACMATCHMAP4)

#define S_MACMATCHMAP3    9
#define M_MACMATCHMAP3    0x7
#define V_MACMATCHMAP3(x) ((x) << S_MACMATCHMAP3)
#define G_MACMATCHMAP3(x) (((x) >> S_MACMATCHMAP3) & M_MACMATCHMAP3)

#define S_MACMATCHMAP2    6
#define M_MACMATCHMAP2    0x7
#define V_MACMATCHMAP2(x) ((x) << S_MACMATCHMAP2)
#define G_MACMATCHMAP2(x) (((x) >> S_MACMATCHMAP2) & M_MACMATCHMAP2)

#define S_MACMATCHMAP1    3
#define M_MACMATCHMAP1    0x7
#define V_MACMATCHMAP1(x) ((x) << S_MACMATCHMAP1)
#define G_MACMATCHMAP1(x) (((x) >> S_MACMATCHMAP1) & M_MACMATCHMAP1)

#define S_MACMATCHMAP0    0
#define M_MACMATCHMAP0    0x7
#define V_MACMATCHMAP0(x) ((x) << S_MACMATCHMAP0)
#define G_MACMATCHMAP0(x) (((x) >> S_MACMATCHMAP0) & M_MACMATCHMAP0)

#define A_TP_MAC_MATCH_MAP1 0x139
#define A_TP_INGRESS_CONFIG 0x141

#define S_LOOKUPEVERYPKT    28
#define V_LOOKUPEVERYPKT(x) ((x) << S_LOOKUPEVERYPKT)
#define F_LOOKUPEVERYPKT    V_LOOKUPEVERYPKT(1U)

#define S_ENABLEINSERTIONSFD    27
#define V_ENABLEINSERTIONSFD(x) ((x) << S_ENABLEINSERTIONSFD)
#define F_ENABLEINSERTIONSFD    V_ENABLEINSERTIONSFD(1U)

#define S_ENABLEINSERTION    26
#define V_ENABLEINSERTION(x) ((x) << S_ENABLEINSERTION)
#define F_ENABLEINSERTION    V_ENABLEINSERTION(1U)

#define S_ENABLEEXTRACTIONSFD    25
#define V_ENABLEEXTRACTIONSFD(x) ((x) << S_ENABLEEXTRACTIONSFD)
#define F_ENABLEEXTRACTIONSFD    V_ENABLEEXTRACTIONSFD(1U)

#define S_ENABLEEXTRACT    24
#define V_ENABLEEXTRACT(x) ((x) << S_ENABLEEXTRACT)
#define F_ENABLEEXTRACT    V_ENABLEEXTRACT(1U)

#define S_BITPOS3    18
#define M_BITPOS3    0x3f
#define V_BITPOS3(x) ((x) << S_BITPOS3)
#define G_BITPOS3(x) (((x) >> S_BITPOS3) & M_BITPOS3)

#define S_BITPOS2    12
#define M_BITPOS2    0x3f
#define V_BITPOS2(x) ((x) << S_BITPOS2)
#define G_BITPOS2(x) (((x) >> S_BITPOS2) & M_BITPOS2)

#define S_BITPOS1    6
#define M_BITPOS1    0x3f
#define V_BITPOS1(x) ((x) << S_BITPOS1)
#define G_BITPOS1(x) (((x) >> S_BITPOS1) & M_BITPOS1)

#define S_BITPOS0    0
#define M_BITPOS0    0x3f
#define V_BITPOS0(x) ((x) << S_BITPOS0)
#define G_BITPOS0(x) (((x) >> S_BITPOS0) & M_BITPOS0)

#define A_TP_PREAMBLE_MSB 0x142
#define A_TP_PREAMBLE_LSB 0x143
#define A_TP_EGRESS_CONFIG 0x145

#define S_REWRITEFORCETOSIZE    0
#define V_REWRITEFORCETOSIZE(x) ((x) << S_REWRITEFORCETOSIZE)
#define F_REWRITEFORCETOSIZE    V_REWRITEFORCETOSIZE(1U)

#define A_TP_INTF_FROM_TX_PKT 0x244

#define S_INTFFROMTXPKT    0
#define V_INTFFROMTXPKT(x) ((x) << S_INTFFROMTXPKT)
#define F_INTFFROMTXPKT    V_INTFFROMTXPKT(1U)

#define A_TP_FIFO_CONFIG 0x8c0

#define S_RXFIFOCONFIG    10
#define M_RXFIFOCONFIG    0x3f
#define V_RXFIFOCONFIG(x) ((x) << S_RXFIFOCONFIG)
#define G_RXFIFOCONFIG(x) (((x) >> S_RXFIFOCONFIG) & M_RXFIFOCONFIG)

#define S_TXFIFOCONFIG    2
#define M_TXFIFOCONFIG    0x3f
#define V_TXFIFOCONFIG(x) ((x) << S_TXFIFOCONFIG)
#define G_TXFIFOCONFIG(x) (((x) >> S_TXFIFOCONFIG) & M_TXFIFOCONFIG)

/* registers for module ULP2_RX */
#define ULP2_RX_BASE_ADDR 0x500

#define A_ULPRX_CTL 0x500

#define S_PCMD1THRESHOLD    24
#define M_PCMD1THRESHOLD    0xff
#define V_PCMD1THRESHOLD(x) ((x) << S_PCMD1THRESHOLD)
#define G_PCMD1THRESHOLD(x) (((x) >> S_PCMD1THRESHOLD) & M_PCMD1THRESHOLD)

#define S_PCMD0THRESHOLD    16
#define M_PCMD0THRESHOLD    0xff
#define V_PCMD0THRESHOLD(x) ((x) << S_PCMD0THRESHOLD)
#define G_PCMD0THRESHOLD(x) (((x) >> S_PCMD0THRESHOLD) & M_PCMD0THRESHOLD)

#define S_ROUND_ROBIN    4
#define V_ROUND_ROBIN(x) ((x) << S_ROUND_ROBIN)
#define F_ROUND_ROBIN    V_ROUND_ROBIN(1U)

#define S_RDMA_PERMISSIVE_MODE    3
#define V_RDMA_PERMISSIVE_MODE(x) ((x) << S_RDMA_PERMISSIVE_MODE)
#define F_RDMA_PERMISSIVE_MODE    V_RDMA_PERMISSIVE_MODE(1U)

#define S_PAGEPODME    2
#define V_PAGEPODME(x) ((x) << S_PAGEPODME)
#define F_PAGEPODME    V_PAGEPODME(1U)

#define S_ISCSITAGTCB    1
#define V_ISCSITAGTCB(x) ((x) << S_ISCSITAGTCB)
#define F_ISCSITAGTCB    V_ISCSITAGTCB(1U)

#define S_TDDPTAGTCB    0
#define V_TDDPTAGTCB(x) ((x) << S_TDDPTAGTCB)
#define F_TDDPTAGTCB    V_TDDPTAGTCB(1U)

#define A_ULPRX_INT_ENABLE 0x504

#define S_DATASELFRAMEERR0    7
#define V_DATASELFRAMEERR0(x) ((x) << S_DATASELFRAMEERR0)
#define F_DATASELFRAMEERR0    V_DATASELFRAMEERR0(1U)

#define S_DATASELFRAMEERR1    6
#define V_DATASELFRAMEERR1(x) ((x) << S_DATASELFRAMEERR1)
#define F_DATASELFRAMEERR1    V_DATASELFRAMEERR1(1U)

#define S_PCMDMUXPERR    5
#define V_PCMDMUXPERR(x) ((x) << S_PCMDMUXPERR)
#define F_PCMDMUXPERR    V_PCMDMUXPERR(1U)

#define S_ARBFPERR    4
#define V_ARBFPERR(x) ((x) << S_ARBFPERR)
#define F_ARBFPERR    V_ARBFPERR(1U)

#define S_ARBPF0PERR    3
#define V_ARBPF0PERR(x) ((x) << S_ARBPF0PERR)
#define F_ARBPF0PERR    V_ARBPF0PERR(1U)

#define S_ARBPF1PERR    2
#define V_ARBPF1PERR(x) ((x) << S_ARBPF1PERR)
#define F_ARBPF1PERR    V_ARBPF1PERR(1U)

#define S_PARERRPCMD    1
#define V_PARERRPCMD(x) ((x) << S_PARERRPCMD)
#define F_PARERRPCMD    V_PARERRPCMD(1U)

#define S_PARERRDATA    0
#define V_PARERRDATA(x) ((x) << S_PARERRDATA)
#define F_PARERRDATA    V_PARERRDATA(1U)

#define S_PARERR    0
#define V_PARERR(x) ((x) << S_PARERR)
#define F_PARERR    V_PARERR(1U)

#define A_ULPRX_INT_CAUSE 0x508
#define A_ULPRX_ISCSI_LLIMIT 0x50c

#define S_ISCSILLIMIT    6
#define M_ISCSILLIMIT    0x3ffffff
#define V_ISCSILLIMIT(x) ((x) << S_ISCSILLIMIT)
#define G_ISCSILLIMIT(x) (((x) >> S_ISCSILLIMIT) & M_ISCSILLIMIT)

#define A_ULPRX_ISCSI_ULIMIT 0x510

#define S_ISCSIULIMIT    6
#define M_ISCSIULIMIT    0x3ffffff
#define V_ISCSIULIMIT(x) ((x) << S_ISCSIULIMIT)
#define G_ISCSIULIMIT(x) (((x) >> S_ISCSIULIMIT) & M_ISCSIULIMIT)

#define A_ULPRX_ISCSI_TAGMASK 0x514

#define S_ISCSITAGMASK    6
#define M_ISCSITAGMASK    0x3ffffff
#define V_ISCSITAGMASK(x) ((x) << S_ISCSITAGMASK)
#define G_ISCSITAGMASK(x) (((x) >> S_ISCSITAGMASK) & M_ISCSITAGMASK)

#define A_ULPRX_ISCSI_PSZ 0x518

#define S_HPZ3    24
#define M_HPZ3    0xf
#define V_HPZ3(x) ((x) << S_HPZ3)
#define G_HPZ3(x) (((x) >> S_HPZ3) & M_HPZ3)

#define S_HPZ2    16
#define M_HPZ2    0xf
#define V_HPZ2(x) ((x) << S_HPZ2)
#define G_HPZ2(x) (((x) >> S_HPZ2) & M_HPZ2)

#define S_HPZ1    8
#define M_HPZ1    0xf
#define V_HPZ1(x) ((x) << S_HPZ1)
#define G_HPZ1(x) (((x) >> S_HPZ1) & M_HPZ1)

#define S_HPZ0    0
#define M_HPZ0    0xf
#define V_HPZ0(x) ((x) << S_HPZ0)
#define G_HPZ0(x) (((x) >> S_HPZ0) & M_HPZ0)

#define A_ULPRX_TDDP_LLIMIT 0x51c

#define S_TDDPLLIMIT    6
#define M_TDDPLLIMIT    0x3ffffff
#define V_TDDPLLIMIT(x) ((x) << S_TDDPLLIMIT)
#define G_TDDPLLIMIT(x) (((x) >> S_TDDPLLIMIT) & M_TDDPLLIMIT)

#define A_ULPRX_TDDP_ULIMIT 0x520

#define S_TDDPULIMIT    6
#define M_TDDPULIMIT    0x3ffffff
#define V_TDDPULIMIT(x) ((x) << S_TDDPULIMIT)
#define G_TDDPULIMIT(x) (((x) >> S_TDDPULIMIT) & M_TDDPULIMIT)

#define A_ULPRX_TDDP_TAGMASK 0x524

#define S_TDDPTAGMASK    6
#define M_TDDPTAGMASK    0x3ffffff
#define V_TDDPTAGMASK(x) ((x) << S_TDDPTAGMASK)
#define G_TDDPTAGMASK(x) (((x) >> S_TDDPTAGMASK) & M_TDDPTAGMASK)

#define A_ULPRX_TDDP_PSZ 0x528
#define A_ULPRX_STAG_LLIMIT 0x52c
#define A_ULPRX_STAG_ULIMIT 0x530
#define A_ULPRX_RQ_LLIMIT 0x534
#define A_ULPRX_RQ_ULIMIT 0x538
#define A_ULPRX_PBL_LLIMIT 0x53c
#define A_ULPRX_PBL_ULIMIT 0x540

/* registers for module ULP2_TX */
#define ULP2_TX_BASE_ADDR 0x580

#define A_ULPTX_CONFIG 0x580

#define S_CFG_CQE_SOP_MASK    1
#define V_CFG_CQE_SOP_MASK(x) ((x) << S_CFG_CQE_SOP_MASK)
#define F_CFG_CQE_SOP_MASK    V_CFG_CQE_SOP_MASK(1U)

#define S_CFG_RR_ARB    0
#define V_CFG_RR_ARB(x) ((x) << S_CFG_RR_ARB)
#define F_CFG_RR_ARB    V_CFG_RR_ARB(1U)

#define A_ULPTX_INT_ENABLE 0x584

#define S_CMD_FIFO_PERR_SET1    7
#define V_CMD_FIFO_PERR_SET1(x) ((x) << S_CMD_FIFO_PERR_SET1)
#define F_CMD_FIFO_PERR_SET1    V_CMD_FIFO_PERR_SET1(1U)

#define S_CMD_FIFO_PERR_SET0    6
#define V_CMD_FIFO_PERR_SET0(x) ((x) << S_CMD_FIFO_PERR_SET0)
#define F_CMD_FIFO_PERR_SET0    V_CMD_FIFO_PERR_SET0(1U)

#define S_LSO_HDR_SRAM_PERR_SET1    5
#define V_LSO_HDR_SRAM_PERR_SET1(x) ((x) << S_LSO_HDR_SRAM_PERR_SET1)
#define F_LSO_HDR_SRAM_PERR_SET1    V_LSO_HDR_SRAM_PERR_SET1(1U)

#define S_LSO_HDR_SRAM_PERR_SET0    4
#define V_LSO_HDR_SRAM_PERR_SET0(x) ((x) << S_LSO_HDR_SRAM_PERR_SET0)
#define F_LSO_HDR_SRAM_PERR_SET0    V_LSO_HDR_SRAM_PERR_SET0(1U)

#define S_IMM_DATA_PERR_SET_CH1    3
#define V_IMM_DATA_PERR_SET_CH1(x) ((x) << S_IMM_DATA_PERR_SET_CH1)
#define F_IMM_DATA_PERR_SET_CH1    V_IMM_DATA_PERR_SET_CH1(1U)

#define S_IMM_DATA_PERR_SET_CH0    2
#define V_IMM_DATA_PERR_SET_CH0(x) ((x) << S_IMM_DATA_PERR_SET_CH0)
#define F_IMM_DATA_PERR_SET_CH0    V_IMM_DATA_PERR_SET_CH0(1U)

#define S_PBL_BOUND_ERR_CH1    1
#define V_PBL_BOUND_ERR_CH1(x) ((x) << S_PBL_BOUND_ERR_CH1)
#define F_PBL_BOUND_ERR_CH1    V_PBL_BOUND_ERR_CH1(1U)

#define S_PBL_BOUND_ERR_CH0    0
#define V_PBL_BOUND_ERR_CH0(x) ((x) << S_PBL_BOUND_ERR_CH0)
#define F_PBL_BOUND_ERR_CH0    V_PBL_BOUND_ERR_CH0(1U)

#define A_ULPTX_INT_CAUSE 0x588
#define A_ULPTX_TPT_LLIMIT 0x58c
#define A_ULPTX_TPT_ULIMIT 0x590
#define A_ULPTX_PBL_LLIMIT 0x594
#define A_ULPTX_PBL_ULIMIT 0x598
#define A_ULPTX_CPL_ERR_OFFSET 0x59c
#define A_ULPTX_CPL_ERR_MASK 0x5a0
#define A_ULPTX_CPL_ERR_VALUE 0x5a4
#define A_ULPTX_CPL_PACK_SIZE 0x5a8

#define S_VALUE    24
#define M_VALUE    0xff
#define V_VALUE(x) ((x) << S_VALUE)
#define G_VALUE(x) (((x) >> S_VALUE) & M_VALUE)

#define S_CH1SIZE2    24
#define M_CH1SIZE2    0xff
#define V_CH1SIZE2(x) ((x) << S_CH1SIZE2)
#define G_CH1SIZE2(x) (((x) >> S_CH1SIZE2) & M_CH1SIZE2)

#define S_CH1SIZE1    16
#define M_CH1SIZE1    0xff
#define V_CH1SIZE1(x) ((x) << S_CH1SIZE1)
#define G_CH1SIZE1(x) (((x) >> S_CH1SIZE1) & M_CH1SIZE1)

#define S_CH0SIZE2    8
#define M_CH0SIZE2    0xff
#define V_CH0SIZE2(x) ((x) << S_CH0SIZE2)
#define G_CH0SIZE2(x) (((x) >> S_CH0SIZE2) & M_CH0SIZE2)

#define S_CH0SIZE1    0
#define M_CH0SIZE1    0xff
#define V_CH0SIZE1(x) ((x) << S_CH0SIZE1)
#define G_CH0SIZE1(x) (((x) >> S_CH0SIZE1) & M_CH0SIZE1)

#define A_ULPTX_DMA_WEIGHT 0x5ac

#define S_D1_WEIGHT    16
#define M_D1_WEIGHT    0xffff
#define V_D1_WEIGHT(x) ((x) << S_D1_WEIGHT)
#define G_D1_WEIGHT(x) (((x) >> S_D1_WEIGHT) & M_D1_WEIGHT)

#define S_D0_WEIGHT    0
#define M_D0_WEIGHT    0xffff
#define V_D0_WEIGHT(x) ((x) << S_D0_WEIGHT)
#define G_D0_WEIGHT(x) (((x) >> S_D0_WEIGHT) & M_D0_WEIGHT)

/* registers for module PM1_RX */
#define PM1_RX_BASE_ADDR 0x5c0

#define A_PM1_RX_CFG 0x5c0
#define A_PM1_RX_MODE 0x5c4

#define S_STAT_CHANNEL    1
#define V_STAT_CHANNEL(x) ((x) << S_STAT_CHANNEL)
#define F_STAT_CHANNEL    V_STAT_CHANNEL(1U)

#define S_PRIORITY_CH    0
#define V_PRIORITY_CH(x) ((x) << S_PRIORITY_CH)
#define F_PRIORITY_CH    V_PRIORITY_CH(1U)

#define A_PM1_RX_STAT_CONFIG 0x5c8
#define A_PM1_RX_STAT_COUNT 0x5cc
#define A_PM1_RX_STAT_MSB 0x5d0
#define A_PM1_RX_STAT_LSB 0x5d4
#define A_PM1_RX_INT_ENABLE 0x5d8

#define S_ZERO_E_CMD_ERROR    18
#define V_ZERO_E_CMD_ERROR(x) ((x) << S_ZERO_E_CMD_ERROR)
#define F_ZERO_E_CMD_ERROR    V_ZERO_E_CMD_ERROR(1U)

#define S_IESPI0_FIFO2X_RX_FRAMING_ERROR    17
#define V_IESPI0_FIFO2X_RX_FRAMING_ERROR(x) ((x) << S_IESPI0_FIFO2X_RX_FRAMING_ERROR)
#define F_IESPI0_FIFO2X_RX_FRAMING_ERROR    V_IESPI0_FIFO2X_RX_FRAMING_ERROR(1U)

#define S_IESPI1_FIFO2X_RX_FRAMING_ERROR    16
#define V_IESPI1_FIFO2X_RX_FRAMING_ERROR(x) ((x) << S_IESPI1_FIFO2X_RX_FRAMING_ERROR)
#define F_IESPI1_FIFO2X_RX_FRAMING_ERROR    V_IESPI1_FIFO2X_RX_FRAMING_ERROR(1U)

#define S_IESPI0_RX_FRAMING_ERROR    15
#define V_IESPI0_RX_FRAMING_ERROR(x) ((x) << S_IESPI0_RX_FRAMING_ERROR)
#define F_IESPI0_RX_FRAMING_ERROR    V_IESPI0_RX_FRAMING_ERROR(1U)

#define S_IESPI1_RX_FRAMING_ERROR    14
#define V_IESPI1_RX_FRAMING_ERROR(x) ((x) << S_IESPI1_RX_FRAMING_ERROR)
#define F_IESPI1_RX_FRAMING_ERROR    V_IESPI1_RX_FRAMING_ERROR(1U)

#define S_IESPI0_TX_FRAMING_ERROR    13
#define V_IESPI0_TX_FRAMING_ERROR(x) ((x) << S_IESPI0_TX_FRAMING_ERROR)
#define F_IESPI0_TX_FRAMING_ERROR    V_IESPI0_TX_FRAMING_ERROR(1U)

#define S_IESPI1_TX_FRAMING_ERROR    12
#define V_IESPI1_TX_FRAMING_ERROR(x) ((x) << S_IESPI1_TX_FRAMING_ERROR)
#define F_IESPI1_TX_FRAMING_ERROR    V_IESPI1_TX_FRAMING_ERROR(1U)

#define S_OCSPI0_RX_FRAMING_ERROR    11
#define V_OCSPI0_RX_FRAMING_ERROR(x) ((x) << S_OCSPI0_RX_FRAMING_ERROR)
#define F_OCSPI0_RX_FRAMING_ERROR    V_OCSPI0_RX_FRAMING_ERROR(1U)

#define S_OCSPI1_RX_FRAMING_ERROR    10
#define V_OCSPI1_RX_FRAMING_ERROR(x) ((x) << S_OCSPI1_RX_FRAMING_ERROR)
#define F_OCSPI1_RX_FRAMING_ERROR    V_OCSPI1_RX_FRAMING_ERROR(1U)

#define S_OCSPI0_TX_FRAMING_ERROR    9
#define V_OCSPI0_TX_FRAMING_ERROR(x) ((x) << S_OCSPI0_TX_FRAMING_ERROR)
#define F_OCSPI0_TX_FRAMING_ERROR    V_OCSPI0_TX_FRAMING_ERROR(1U)

#define S_OCSPI1_TX_FRAMING_ERROR    8
#define V_OCSPI1_TX_FRAMING_ERROR(x) ((x) << S_OCSPI1_TX_FRAMING_ERROR)
#define F_OCSPI1_TX_FRAMING_ERROR    V_OCSPI1_TX_FRAMING_ERROR(1U)

#define S_OCSPI0_OFIFO2X_TX_FRAMING_ERROR    7
#define V_OCSPI0_OFIFO2X_TX_FRAMING_ERROR(x) ((x) << S_OCSPI0_OFIFO2X_TX_FRAMING_ERROR)
#define F_OCSPI0_OFIFO2X_TX_FRAMING_ERROR    V_OCSPI0_OFIFO2X_TX_FRAMING_ERROR(1U)

#define S_OCSPI1_OFIFO2X_TX_FRAMING_ERROR    6
#define V_OCSPI1_OFIFO2X_TX_FRAMING_ERROR(x) ((x) << S_OCSPI1_OFIFO2X_TX_FRAMING_ERROR)
#define F_OCSPI1_OFIFO2X_TX_FRAMING_ERROR    V_OCSPI1_OFIFO2X_TX_FRAMING_ERROR(1U)

#define S_IESPI_PAR_ERROR    3
#define M_IESPI_PAR_ERROR    0x7
#define V_IESPI_PAR_ERROR(x) ((x) << S_IESPI_PAR_ERROR)
#define G_IESPI_PAR_ERROR(x) (((x) >> S_IESPI_PAR_ERROR) & M_IESPI_PAR_ERROR)

#define S_OCSPI_PAR_ERROR    0
#define M_OCSPI_PAR_ERROR    0x7
#define V_OCSPI_PAR_ERROR(x) ((x) << S_OCSPI_PAR_ERROR)
#define G_OCSPI_PAR_ERROR(x) (((x) >> S_OCSPI_PAR_ERROR) & M_OCSPI_PAR_ERROR)

#define A_PM1_RX_INT_CAUSE 0x5dc

/* registers for module PM1_TX */
#define PM1_TX_BASE_ADDR 0x5e0

#define A_PM1_TX_CFG 0x5e0
#define A_PM1_TX_MODE 0x5e4
#define A_PM1_TX_STAT_CONFIG 0x5e8
#define A_PM1_TX_STAT_COUNT 0x5ec
#define A_PM1_TX_STAT_MSB 0x5f0
#define A_PM1_TX_STAT_LSB 0x5f4
#define A_PM1_TX_INT_ENABLE 0x5f8

#define S_ZERO_C_CMD_ERROR    18
#define V_ZERO_C_CMD_ERROR(x) ((x) << S_ZERO_C_CMD_ERROR)
#define F_ZERO_C_CMD_ERROR    V_ZERO_C_CMD_ERROR(1U)

#define S_ICSPI0_FIFO2X_RX_FRAMING_ERROR    17
#define V_ICSPI0_FIFO2X_RX_FRAMING_ERROR(x) ((x) << S_ICSPI0_FIFO2X_RX_FRAMING_ERROR)
#define F_ICSPI0_FIFO2X_RX_FRAMING_ERROR    V_ICSPI0_FIFO2X_RX_FRAMING_ERROR(1U)

#define S_ICSPI1_FIFO2X_RX_FRAMING_ERROR    16
#define V_ICSPI1_FIFO2X_RX_FRAMING_ERROR(x) ((x) << S_ICSPI1_FIFO2X_RX_FRAMING_ERROR)
#define F_ICSPI1_FIFO2X_RX_FRAMING_ERROR    V_ICSPI1_FIFO2X_RX_FRAMING_ERROR(1U)

#define S_ICSPI0_RX_FRAMING_ERROR    15
#define V_ICSPI0_RX_FRAMING_ERROR(x) ((x) << S_ICSPI0_RX_FRAMING_ERROR)
#define F_ICSPI0_RX_FRAMING_ERROR    V_ICSPI0_RX_FRAMING_ERROR(1U)

#define S_ICSPI1_RX_FRAMING_ERROR    14
#define V_ICSPI1_RX_FRAMING_ERROR(x) ((x) << S_ICSPI1_RX_FRAMING_ERROR)
#define F_ICSPI1_RX_FRAMING_ERROR    V_ICSPI1_RX_FRAMING_ERROR(1U)

#define S_ICSPI0_TX_FRAMING_ERROR    13
#define V_ICSPI0_TX_FRAMING_ERROR(x) ((x) << S_ICSPI0_TX_FRAMING_ERROR)
#define F_ICSPI0_TX_FRAMING_ERROR    V_ICSPI0_TX_FRAMING_ERROR(1U)

#define S_ICSPI1_TX_FRAMING_ERROR    12
#define V_ICSPI1_TX_FRAMING_ERROR(x) ((x) << S_ICSPI1_TX_FRAMING_ERROR)
#define F_ICSPI1_TX_FRAMING_ERROR    V_ICSPI1_TX_FRAMING_ERROR(1U)

#define S_OESPI0_RX_FRAMING_ERROR    11
#define V_OESPI0_RX_FRAMING_ERROR(x) ((x) << S_OESPI0_RX_FRAMING_ERROR)
#define F_OESPI0_RX_FRAMING_ERROR    V_OESPI0_RX_FRAMING_ERROR(1U)

#define S_OESPI1_RX_FRAMING_ERROR    10
#define V_OESPI1_RX_FRAMING_ERROR(x) ((x) << S_OESPI1_RX_FRAMING_ERROR)
#define F_OESPI1_RX_FRAMING_ERROR    V_OESPI1_RX_FRAMING_ERROR(1U)

#define S_OESPI0_TX_FRAMING_ERROR    9
#define V_OESPI0_TX_FRAMING_ERROR(x) ((x) << S_OESPI0_TX_FRAMING_ERROR)
#define F_OESPI0_TX_FRAMING_ERROR    V_OESPI0_TX_FRAMING_ERROR(1U)

#define S_OESPI1_TX_FRAMING_ERROR    8
#define V_OESPI1_TX_FRAMING_ERROR(x) ((x) << S_OESPI1_TX_FRAMING_ERROR)
#define F_OESPI1_TX_FRAMING_ERROR    V_OESPI1_TX_FRAMING_ERROR(1U)

#define S_OESPI0_OFIFO2X_TX_FRAMING_ERROR    7
#define V_OESPI0_OFIFO2X_TX_FRAMING_ERROR(x) ((x) << S_OESPI0_OFIFO2X_TX_FRAMING_ERROR)
#define F_OESPI0_OFIFO2X_TX_FRAMING_ERROR    V_OESPI0_OFIFO2X_TX_FRAMING_ERROR(1U)

#define S_OESPI1_OFIFO2X_TX_FRAMING_ERROR    6
#define V_OESPI1_OFIFO2X_TX_FRAMING_ERROR(x) ((x) << S_OESPI1_OFIFO2X_TX_FRAMING_ERROR)
#define F_OESPI1_OFIFO2X_TX_FRAMING_ERROR    V_OESPI1_OFIFO2X_TX_FRAMING_ERROR(1U)

#define S_ICSPI_PAR_ERROR    3
#define M_ICSPI_PAR_ERROR    0x7
#define V_ICSPI_PAR_ERROR(x) ((x) << S_ICSPI_PAR_ERROR)
#define G_ICSPI_PAR_ERROR(x) (((x) >> S_ICSPI_PAR_ERROR) & M_ICSPI_PAR_ERROR)

#define S_OESPI_PAR_ERROR    0
#define M_OESPI_PAR_ERROR    0x7
#define V_OESPI_PAR_ERROR(x) ((x) << S_OESPI_PAR_ERROR)
#define G_OESPI_PAR_ERROR(x) (((x) >> S_OESPI_PAR_ERROR) & M_OESPI_PAR_ERROR)

#define A_PM1_TX_INT_CAUSE 0x5fc

/* registers for module MPS0 */
#define MPS0_BASE_ADDR 0x600

#define A_MPS_CFG 0x600

#define S_ENFORCEPKT    11
#define V_ENFORCEPKT(x) ((x) << S_ENFORCEPKT)
#define F_ENFORCEPKT    V_ENFORCEPKT(1U)

#define S_SGETPQID    8
#define M_SGETPQID    0x7
#define V_SGETPQID(x) ((x) << S_SGETPQID)
#define G_SGETPQID(x) (((x) >> S_SGETPQID) & M_SGETPQID)

#define S_TPRXPORTSIZE    7
#define V_TPRXPORTSIZE(x) ((x) << S_TPRXPORTSIZE)
#define F_TPRXPORTSIZE    V_TPRXPORTSIZE(1U)

#define S_TPTXPORT1SIZE    6
#define V_TPTXPORT1SIZE(x) ((x) << S_TPTXPORT1SIZE)
#define F_TPTXPORT1SIZE    V_TPTXPORT1SIZE(1U)

#define S_TPTXPORT0SIZE    5
#define V_TPTXPORT0SIZE(x) ((x) << S_TPTXPORT0SIZE)
#define F_TPTXPORT0SIZE    V_TPTXPORT0SIZE(1U)

#define S_TPRXPORTEN    4
#define V_TPRXPORTEN(x) ((x) << S_TPRXPORTEN)
#define F_TPRXPORTEN    V_TPRXPORTEN(1U)

#define S_TPTXPORT1EN    3
#define V_TPTXPORT1EN(x) ((x) << S_TPTXPORT1EN)
#define F_TPTXPORT1EN    V_TPTXPORT1EN(1U)

#define S_TPTXPORT0EN    2
#define V_TPTXPORT0EN(x) ((x) << S_TPTXPORT0EN)
#define F_TPTXPORT0EN    V_TPTXPORT0EN(1U)

#define S_PORT1ACTIVE    1
#define V_PORT1ACTIVE(x) ((x) << S_PORT1ACTIVE)
#define F_PORT1ACTIVE    V_PORT1ACTIVE(1U)

#define S_PORT0ACTIVE    0
#define V_PORT0ACTIVE(x) ((x) << S_PORT0ACTIVE)
#define F_PORT0ACTIVE    V_PORT0ACTIVE(1U)

#define A_MPS_DRR_CFG1 0x604

#define S_RLDWTTPD1    11
#define M_RLDWTTPD1    0x7ff
#define V_RLDWTTPD1(x) ((x) << S_RLDWTTPD1)
#define G_RLDWTTPD1(x) (((x) >> S_RLDWTTPD1) & M_RLDWTTPD1)

#define S_RLDWTTPD0    0
#define M_RLDWTTPD0    0x7ff
#define V_RLDWTTPD0(x) ((x) << S_RLDWTTPD0)
#define G_RLDWTTPD0(x) (((x) >> S_RLDWTTPD0) & M_RLDWTTPD0)

#define A_MPS_DRR_CFG2 0x608

#define S_RLDWTTOTAL    0
#define M_RLDWTTOTAL    0xfff
#define V_RLDWTTOTAL(x) ((x) << S_RLDWTTOTAL)
#define G_RLDWTTOTAL(x) (((x) >> S_RLDWTTOTAL) & M_RLDWTTOTAL)

#define A_MPS_MCA_STATUS 0x60c

#define S_MCAPKTCNT    12
#define M_MCAPKTCNT    0xfffff
#define V_MCAPKTCNT(x) ((x) << S_MCAPKTCNT)
#define G_MCAPKTCNT(x) (((x) >> S_MCAPKTCNT) & M_MCAPKTCNT)

#define S_MCADEPTH    0
#define M_MCADEPTH    0xfff
#define V_MCADEPTH(x) ((x) << S_MCADEPTH)
#define G_MCADEPTH(x) (((x) >> S_MCADEPTH) & M_MCADEPTH)

#define A_MPS_TX0_TP_CNT 0x610

#define S_TX0TPDISCNT    24
#define M_TX0TPDISCNT    0xff
#define V_TX0TPDISCNT(x) ((x) << S_TX0TPDISCNT)
#define G_TX0TPDISCNT(x) (((x) >> S_TX0TPDISCNT) & M_TX0TPDISCNT)

#define S_TX0TPCNT    0
#define M_TX0TPCNT    0xffffff
#define V_TX0TPCNT(x) ((x) << S_TX0TPCNT)
#define G_TX0TPCNT(x) (((x) >> S_TX0TPCNT) & M_TX0TPCNT)

#define A_MPS_TX1_TP_CNT 0x614

#define S_TX1TPDISCNT    24
#define M_TX1TPDISCNT    0xff
#define V_TX1TPDISCNT(x) ((x) << S_TX1TPDISCNT)
#define G_TX1TPDISCNT(x) (((x) >> S_TX1TPDISCNT) & M_TX1TPDISCNT)

#define S_TX1TPCNT    0
#define M_TX1TPCNT    0xffffff
#define V_TX1TPCNT(x) ((x) << S_TX1TPCNT)
#define G_TX1TPCNT(x) (((x) >> S_TX1TPCNT) & M_TX1TPCNT)

#define A_MPS_RX_TP_CNT 0x618

#define S_RXTPDISCNT    24
#define M_RXTPDISCNT    0xff
#define V_RXTPDISCNT(x) ((x) << S_RXTPDISCNT)
#define G_RXTPDISCNT(x) (((x) >> S_RXTPDISCNT) & M_RXTPDISCNT)

#define S_RXTPCNT    0
#define M_RXTPCNT    0xffffff
#define V_RXTPCNT(x) ((x) << S_RXTPCNT)
#define G_RXTPCNT(x) (((x) >> S_RXTPCNT) & M_RXTPCNT)

#define A_MPS_INT_ENABLE 0x61c

#define S_MCAPARERRENB    6
#define M_MCAPARERRENB    0x7
#define V_MCAPARERRENB(x) ((x) << S_MCAPARERRENB)
#define G_MCAPARERRENB(x) (((x) >> S_MCAPARERRENB) & M_MCAPARERRENB)

#define S_RXTPPARERRENB    4
#define M_RXTPPARERRENB    0x3
#define V_RXTPPARERRENB(x) ((x) << S_RXTPPARERRENB)
#define G_RXTPPARERRENB(x) (((x) >> S_RXTPPARERRENB) & M_RXTPPARERRENB)

#define S_TX1TPPARERRENB    2
#define M_TX1TPPARERRENB    0x3
#define V_TX1TPPARERRENB(x) ((x) << S_TX1TPPARERRENB)
#define G_TX1TPPARERRENB(x) (((x) >> S_TX1TPPARERRENB) & M_TX1TPPARERRENB)

#define S_TX0TPPARERRENB    0
#define M_TX0TPPARERRENB    0x3
#define V_TX0TPPARERRENB(x) ((x) << S_TX0TPPARERRENB)
#define G_TX0TPPARERRENB(x) (((x) >> S_TX0TPPARERRENB) & M_TX0TPPARERRENB)

#define A_MPS_INT_CAUSE 0x620

#define S_MCAPARERR    6
#define M_MCAPARERR    0x7
#define V_MCAPARERR(x) ((x) << S_MCAPARERR)
#define G_MCAPARERR(x) (((x) >> S_MCAPARERR) & M_MCAPARERR)

#define S_RXTPPARERR    4
#define M_RXTPPARERR    0x3
#define V_RXTPPARERR(x) ((x) << S_RXTPPARERR)
#define G_RXTPPARERR(x) (((x) >> S_RXTPPARERR) & M_RXTPPARERR)

#define S_TX1TPPARERR    2
#define M_TX1TPPARERR    0x3
#define V_TX1TPPARERR(x) ((x) << S_TX1TPPARERR)
#define G_TX1TPPARERR(x) (((x) >> S_TX1TPPARERR) & M_TX1TPPARERR)

#define S_TX0TPPARERR    0
#define M_TX0TPPARERR    0x3
#define V_TX0TPPARERR(x) ((x) << S_TX0TPPARERR)
#define G_TX0TPPARERR(x) (((x) >> S_TX0TPPARERR) & M_TX0TPPARERR)

/* registers for module CPL_SWITCH */
#define CPL_SWITCH_BASE_ADDR 0x640

#define A_CPL_SWITCH_CNTRL 0x640

#define S_CPL_PKT_TID    8
#define M_CPL_PKT_TID    0xffffff
#define V_CPL_PKT_TID(x) ((x) << S_CPL_PKT_TID)
#define G_CPL_PKT_TID(x) (((x) >> S_CPL_PKT_TID) & M_CPL_PKT_TID)

#define S_CIM_TO_UP_FULL_SIZE    4
#define V_CIM_TO_UP_FULL_SIZE(x) ((x) << S_CIM_TO_UP_FULL_SIZE)
#define F_CIM_TO_UP_FULL_SIZE    V_CIM_TO_UP_FULL_SIZE(1U)

#define S_CPU_NO_3F_CIM_ENABLE    3
#define V_CPU_NO_3F_CIM_ENABLE(x) ((x) << S_CPU_NO_3F_CIM_ENABLE)
#define F_CPU_NO_3F_CIM_ENABLE    V_CPU_NO_3F_CIM_ENABLE(1U)

#define S_SWITCH_TABLE_ENABLE    2
#define V_SWITCH_TABLE_ENABLE(x) ((x) << S_SWITCH_TABLE_ENABLE)
#define F_SWITCH_TABLE_ENABLE    V_SWITCH_TABLE_ENABLE(1U)

#define S_SGE_ENABLE    1
#define V_SGE_ENABLE(x) ((x) << S_SGE_ENABLE)
#define F_SGE_ENABLE    V_SGE_ENABLE(1U)

#define S_CIM_ENABLE    0
#define V_CIM_ENABLE(x) ((x) << S_CIM_ENABLE)
#define F_CIM_ENABLE    V_CIM_ENABLE(1U)

#define A_CPL_SWITCH_TBL_IDX 0x644

#define S_SWITCH_TBL_IDX    0
#define M_SWITCH_TBL_IDX    0xf
#define V_SWITCH_TBL_IDX(x) ((x) << S_SWITCH_TBL_IDX)
#define G_SWITCH_TBL_IDX(x) (((x) >> S_SWITCH_TBL_IDX) & M_SWITCH_TBL_IDX)

#define A_CPL_SWITCH_TBL_DATA 0x648
#define A_CPL_SWITCH_ZERO_ERROR 0x64c

#define S_ZERO_CMD    0
#define M_ZERO_CMD    0xff
#define V_ZERO_CMD(x) ((x) << S_ZERO_CMD)
#define G_ZERO_CMD(x) (((x) >> S_ZERO_CMD) & M_ZERO_CMD)

#define A_CPL_INTR_ENABLE 0x650

#define S_CIM_OP_MAP_PERR    5
#define V_CIM_OP_MAP_PERR(x) ((x) << S_CIM_OP_MAP_PERR)
#define F_CIM_OP_MAP_PERR    V_CIM_OP_MAP_PERR(1U)

#define S_CIM_OVFL_ERROR    4
#define V_CIM_OVFL_ERROR(x) ((x) << S_CIM_OVFL_ERROR)
#define F_CIM_OVFL_ERROR    V_CIM_OVFL_ERROR(1U)

#define S_TP_FRAMING_ERROR    3
#define V_TP_FRAMING_ERROR(x) ((x) << S_TP_FRAMING_ERROR)
#define F_TP_FRAMING_ERROR    V_TP_FRAMING_ERROR(1U)

#define S_SGE_FRAMING_ERROR    2
#define V_SGE_FRAMING_ERROR(x) ((x) << S_SGE_FRAMING_ERROR)
#define F_SGE_FRAMING_ERROR    V_SGE_FRAMING_ERROR(1U)

#define S_CIM_FRAMING_ERROR    1
#define V_CIM_FRAMING_ERROR(x) ((x) << S_CIM_FRAMING_ERROR)
#define F_CIM_FRAMING_ERROR    V_CIM_FRAMING_ERROR(1U)

#define S_ZERO_SWITCH_ERROR    0
#define V_ZERO_SWITCH_ERROR(x) ((x) << S_ZERO_SWITCH_ERROR)
#define F_ZERO_SWITCH_ERROR    V_ZERO_SWITCH_ERROR(1U)

#define A_CPL_INTR_CAUSE 0x654
#define A_CPL_MAP_TBL_IDX 0x658

#define S_CPL_MAP_TBL_IDX    0
#define M_CPL_MAP_TBL_IDX    0xff
#define V_CPL_MAP_TBL_IDX(x) ((x) << S_CPL_MAP_TBL_IDX)
#define G_CPL_MAP_TBL_IDX(x) (((x) >> S_CPL_MAP_TBL_IDX) & M_CPL_MAP_TBL_IDX)

#define A_CPL_MAP_TBL_DATA 0x65c

#define S_CPL_MAP_TBL_DATA    0
#define M_CPL_MAP_TBL_DATA    0xff
#define V_CPL_MAP_TBL_DATA(x) ((x) << S_CPL_MAP_TBL_DATA)
#define G_CPL_MAP_TBL_DATA(x) (((x) >> S_CPL_MAP_TBL_DATA) & M_CPL_MAP_TBL_DATA)

/* registers for module SMB0 */
#define SMB0_BASE_ADDR 0x660

#define A_SMB_GLOBAL_TIME_CFG 0x660

#define S_LADBGWRPTR    24
#define M_LADBGWRPTR    0xff
#define V_LADBGWRPTR(x) ((x) << S_LADBGWRPTR)
#define G_LADBGWRPTR(x) (((x) >> S_LADBGWRPTR) & M_LADBGWRPTR)

#define S_LADBGRDPTR    16
#define M_LADBGRDPTR    0xff
#define V_LADBGRDPTR(x) ((x) << S_LADBGRDPTR)
#define G_LADBGRDPTR(x) (((x) >> S_LADBGRDPTR) & M_LADBGRDPTR)

#define S_LADBGEN    13
#define V_LADBGEN(x) ((x) << S_LADBGEN)
#define F_LADBGEN    V_LADBGEN(1U)

#define S_MACROCNTCFG    8
#define M_MACROCNTCFG    0x1f
#define V_MACROCNTCFG(x) ((x) << S_MACROCNTCFG)
#define G_MACROCNTCFG(x) (((x) >> S_MACROCNTCFG) & M_MACROCNTCFG)

#define S_MICROCNTCFG    0
#define M_MICROCNTCFG    0xff
#define V_MICROCNTCFG(x) ((x) << S_MICROCNTCFG)
#define G_MICROCNTCFG(x) (((x) >> S_MICROCNTCFG) & M_MICROCNTCFG)

#define A_SMB_MST_TIMEOUT_CFG 0x664

#define S_DEBUGSELH    28
#define M_DEBUGSELH    0xf
#define V_DEBUGSELH(x) ((x) << S_DEBUGSELH)
#define G_DEBUGSELH(x) (((x) >> S_DEBUGSELH) & M_DEBUGSELH)

#define S_DEBUGSELL    24
#define M_DEBUGSELL    0xf
#define V_DEBUGSELL(x) ((x) << S_DEBUGSELL)
#define G_DEBUGSELL(x) (((x) >> S_DEBUGSELL) & M_DEBUGSELL)

#define S_MSTTIMEOUTCFG    0
#define M_MSTTIMEOUTCFG    0xffffff
#define V_MSTTIMEOUTCFG(x) ((x) << S_MSTTIMEOUTCFG)
#define G_MSTTIMEOUTCFG(x) (((x) >> S_MSTTIMEOUTCFG) & M_MSTTIMEOUTCFG)

#define A_SMB_MST_CTL_CFG 0x668

#define S_MSTFIFODBG    31
#define V_MSTFIFODBG(x) ((x) << S_MSTFIFODBG)
#define F_MSTFIFODBG    V_MSTFIFODBG(1U)

#define S_MSTFIFODBGCLR    30
#define V_MSTFIFODBGCLR(x) ((x) << S_MSTFIFODBGCLR)
#define F_MSTFIFODBGCLR    V_MSTFIFODBGCLR(1U)

#define S_MSTRXBYTECFG    12
#define M_MSTRXBYTECFG    0x3f
#define V_MSTRXBYTECFG(x) ((x) << S_MSTRXBYTECFG)
#define G_MSTRXBYTECFG(x) (((x) >> S_MSTRXBYTECFG) & M_MSTRXBYTECFG)

#define S_MSTTXBYTECFG    6
#define M_MSTTXBYTECFG    0x3f
#define V_MSTTXBYTECFG(x) ((x) << S_MSTTXBYTECFG)
#define G_MSTTXBYTECFG(x) (((x) >> S_MSTTXBYTECFG) & M_MSTTXBYTECFG)

#define S_MSTRESET    1
#define V_MSTRESET(x) ((x) << S_MSTRESET)
#define F_MSTRESET    V_MSTRESET(1U)

#define S_MSTCTLEN    0
#define V_MSTCTLEN(x) ((x) << S_MSTCTLEN)
#define F_MSTCTLEN    V_MSTCTLEN(1U)

#define A_SMB_MST_CTL_STS 0x66c

#define S_MSTRXBYTECNT    12
#define M_MSTRXBYTECNT    0x3f
#define V_MSTRXBYTECNT(x) ((x) << S_MSTRXBYTECNT)
#define G_MSTRXBYTECNT(x) (((x) >> S_MSTRXBYTECNT) & M_MSTRXBYTECNT)

#define S_MSTTXBYTECNT    6
#define M_MSTTXBYTECNT    0x3f
#define V_MSTTXBYTECNT(x) ((x) << S_MSTTXBYTECNT)
#define G_MSTTXBYTECNT(x) (((x) >> S_MSTTXBYTECNT) & M_MSTTXBYTECNT)

#define S_MSTBUSYSTS    0
#define V_MSTBUSYSTS(x) ((x) << S_MSTBUSYSTS)
#define F_MSTBUSYSTS    V_MSTBUSYSTS(1U)

#define A_SMB_MST_TX_FIFO_RDWR 0x670
#define A_SMB_MST_RX_FIFO_RDWR 0x674
#define A_SMB_SLV_TIMEOUT_CFG 0x678

#define S_SLVTIMEOUTCFG    0
#define M_SLVTIMEOUTCFG    0xffffff
#define V_SLVTIMEOUTCFG(x) ((x) << S_SLVTIMEOUTCFG)
#define G_SLVTIMEOUTCFG(x) (((x) >> S_SLVTIMEOUTCFG) & M_SLVTIMEOUTCFG)

#define A_SMB_SLV_CTL_CFG 0x67c

#define S_SLVFIFODBG    31
#define V_SLVFIFODBG(x) ((x) << S_SLVFIFODBG)
#define F_SLVFIFODBG    V_SLVFIFODBG(1U)

#define S_SLVFIFODBGCLR    30
#define V_SLVFIFODBGCLR(x) ((x) << S_SLVFIFODBGCLR)
#define F_SLVFIFODBGCLR    V_SLVFIFODBGCLR(1U)

#define S_SLVADDRCFG    4
#define M_SLVADDRCFG    0x7f
#define V_SLVADDRCFG(x) ((x) << S_SLVADDRCFG)
#define G_SLVADDRCFG(x) (((x) >> S_SLVADDRCFG) & M_SLVADDRCFG)

#define S_SLVALRTSET    2
#define V_SLVALRTSET(x) ((x) << S_SLVALRTSET)
#define F_SLVALRTSET    V_SLVALRTSET(1U)

#define S_SLVRESET    1
#define V_SLVRESET(x) ((x) << S_SLVRESET)
#define F_SLVRESET    V_SLVRESET(1U)

#define S_SLVCTLEN    0
#define V_SLVCTLEN(x) ((x) << S_SLVCTLEN)
#define F_SLVCTLEN    V_SLVCTLEN(1U)

#define A_SMB_SLV_CTL_STS 0x680

#define S_SLVFIFOTXCNT    12
#define M_SLVFIFOTXCNT    0x3f
#define V_SLVFIFOTXCNT(x) ((x) << S_SLVFIFOTXCNT)
#define G_SLVFIFOTXCNT(x) (((x) >> S_SLVFIFOTXCNT) & M_SLVFIFOTXCNT)

#define S_SLVFIFOCNT    6
#define M_SLVFIFOCNT    0x3f
#define V_SLVFIFOCNT(x) ((x) << S_SLVFIFOCNT)
#define G_SLVFIFOCNT(x) (((x) >> S_SLVFIFOCNT) & M_SLVFIFOCNT)

#define S_SLVALRTSTS    2
#define V_SLVALRTSTS(x) ((x) << S_SLVALRTSTS)
#define F_SLVALRTSTS    V_SLVALRTSTS(1U)

#define S_SLVBUSYSTS    0
#define V_SLVBUSYSTS(x) ((x) << S_SLVBUSYSTS)
#define F_SLVBUSYSTS    V_SLVBUSYSTS(1U)

#define A_SMB_SLV_FIFO_RDWR 0x684
#define A_SMB_SLV_CMD_FIFO_RDWR 0x688
#define A_SMB_INT_ENABLE 0x68c

#define S_SLVTIMEOUTINTEN    7
#define V_SLVTIMEOUTINTEN(x) ((x) << S_SLVTIMEOUTINTEN)
#define F_SLVTIMEOUTINTEN    V_SLVTIMEOUTINTEN(1U)

#define S_SLVERRINTEN    6
#define V_SLVERRINTEN(x) ((x) << S_SLVERRINTEN)
#define F_SLVERRINTEN    V_SLVERRINTEN(1U)

#define S_SLVDONEINTEN    5
#define V_SLVDONEINTEN(x) ((x) << S_SLVDONEINTEN)
#define F_SLVDONEINTEN    V_SLVDONEINTEN(1U)

#define S_SLVRXRDYINTEN    4
#define V_SLVRXRDYINTEN(x) ((x) << S_SLVRXRDYINTEN)
#define F_SLVRXRDYINTEN    V_SLVRXRDYINTEN(1U)

#define S_MSTTIMEOUTINTEN    3
#define V_MSTTIMEOUTINTEN(x) ((x) << S_MSTTIMEOUTINTEN)
#define F_MSTTIMEOUTINTEN    V_MSTTIMEOUTINTEN(1U)

#define S_MSTNACKINTEN    2
#define V_MSTNACKINTEN(x) ((x) << S_MSTNACKINTEN)
#define F_MSTNACKINTEN    V_MSTNACKINTEN(1U)

#define S_MSTLOSTARBINTEN    1
#define V_MSTLOSTARBINTEN(x) ((x) << S_MSTLOSTARBINTEN)
#define F_MSTLOSTARBINTEN    V_MSTLOSTARBINTEN(1U)

#define S_MSTDONEINTEN    0
#define V_MSTDONEINTEN(x) ((x) << S_MSTDONEINTEN)
#define F_MSTDONEINTEN    V_MSTDONEINTEN(1U)

#define A_SMB_INT_CAUSE 0x690

#define S_SLVTIMEOUTINT    7
#define V_SLVTIMEOUTINT(x) ((x) << S_SLVTIMEOUTINT)
#define F_SLVTIMEOUTINT    V_SLVTIMEOUTINT(1U)

#define S_SLVERRINT    6
#define V_SLVERRINT(x) ((x) << S_SLVERRINT)
#define F_SLVERRINT    V_SLVERRINT(1U)

#define S_SLVDONEINT    5
#define V_SLVDONEINT(x) ((x) << S_SLVDONEINT)
#define F_SLVDONEINT    V_SLVDONEINT(1U)

#define S_SLVRXRDYINT    4
#define V_SLVRXRDYINT(x) ((x) << S_SLVRXRDYINT)
#define F_SLVRXRDYINT    V_SLVRXRDYINT(1U)

#define S_MSTTIMEOUTINT    3
#define V_MSTTIMEOUTINT(x) ((x) << S_MSTTIMEOUTINT)
#define F_MSTTIMEOUTINT    V_MSTTIMEOUTINT(1U)

#define S_MSTNACKINT    2
#define V_MSTNACKINT(x) ((x) << S_MSTNACKINT)
#define F_MSTNACKINT    V_MSTNACKINT(1U)

#define S_MSTLOSTARBINT    1
#define V_MSTLOSTARBINT(x) ((x) << S_MSTLOSTARBINT)
#define F_MSTLOSTARBINT    V_MSTLOSTARBINT(1U)

#define S_MSTDONEINT    0
#define V_MSTDONEINT(x) ((x) << S_MSTDONEINT)
#define F_MSTDONEINT    V_MSTDONEINT(1U)

#define A_SMB_DEBUG_DATA 0x694

#define S_DEBUGDATAH    16
#define M_DEBUGDATAH    0xffff
#define V_DEBUGDATAH(x) ((x) << S_DEBUGDATAH)
#define G_DEBUGDATAH(x) (((x) >> S_DEBUGDATAH) & M_DEBUGDATAH)

#define S_DEBUGDATAL    0
#define M_DEBUGDATAL    0xffff
#define V_DEBUGDATAL(x) ((x) << S_DEBUGDATAL)
#define G_DEBUGDATAL(x) (((x) >> S_DEBUGDATAL) & M_DEBUGDATAL)

#define A_SMB_DEBUG_LA 0x69c

#define S_DEBUGLAREQADDR    0
#define M_DEBUGLAREQADDR    0x3ff
#define V_DEBUGLAREQADDR(x) ((x) << S_DEBUGLAREQADDR)
#define G_DEBUGLAREQADDR(x) (((x) >> S_DEBUGLAREQADDR) & M_DEBUGLAREQADDR)

/* registers for module I2CM0 */
#define I2CM0_BASE_ADDR 0x6a0

#define A_I2C_CFG 0x6a0

#define S_I2C_CLKDIV    0
#define M_I2C_CLKDIV    0xfff
#define V_I2C_CLKDIV(x) ((x) << S_I2C_CLKDIV)
#define G_I2C_CLKDIV(x) (((x) >> S_I2C_CLKDIV) & M_I2C_CLKDIV)

#define A_I2C_DATA 0x6a4
#define A_I2C_OP 0x6a8

#define S_ACK    30
#define V_ACK(x) ((x) << S_ACK)
#define F_ACK    V_ACK(1U)

#define S_I2C_DATA    0
#define M_I2C_DATA    0xff
#define V_I2C_DATA(x) ((x) << S_I2C_DATA)
#define G_I2C_DATA(x) (((x) >> S_I2C_DATA) & M_I2C_DATA)

#define S_I2C_BUSY    31
#define V_I2C_BUSY(x) ((x) << S_I2C_BUSY)
#define F_I2C_BUSY    V_I2C_BUSY(1U)

#define S_I2C_ACK     30
#define V_I2C_ACK(x)  ((x) << S_I2C_ACK)
#define F_I2C_ACK     V_I2C_ACK(1U)

#define S_I2C_CONT    1
#define V_I2C_CONT(x) ((x) << S_I2C_CONT)
#define F_I2C_CONT    V_I2C_CONT(1U)

#define S_I2C_RDWR    0
#define V_I2C_RDWR(x) ((x) << S_I2C_RDWR)
#define F_I2C_READ    V_I2C_RDWR(0U)
#define F_I2C_WRITE   V_I2C_RDWR(1U)

/* registers for module MI1 */
#define MI1_BASE_ADDR 0x6b0

#define A_MI1_CFG 0x6b0

#define S_CLKDIV    5
#define M_CLKDIV    0xff
#define V_CLKDIV(x) ((x) << S_CLKDIV)
#define G_CLKDIV(x) (((x) >> S_CLKDIV) & M_CLKDIV)

#define S_ST    3
#define M_ST    0x3
#define V_ST(x) ((x) << S_ST)
#define G_ST(x) (((x) >> S_ST) & M_ST)

#define S_PREEN    2
#define V_PREEN(x) ((x) << S_PREEN)
#define F_PREEN    V_PREEN(1U)

#define S_MDIINV    1
#define V_MDIINV(x) ((x) << S_MDIINV)
#define F_MDIINV    V_MDIINV(1U)

#define S_MDIEN    0
#define V_MDIEN(x) ((x) << S_MDIEN)
#define F_MDIEN    V_MDIEN(1U)

#define A_MI1_ADDR 0x6b4

#define S_PHYADDR    5
#define M_PHYADDR    0x1f
#define V_PHYADDR(x) ((x) << S_PHYADDR)
#define G_PHYADDR(x) (((x) >> S_PHYADDR) & M_PHYADDR)

#define S_REGADDR    0
#define M_REGADDR    0x1f
#define V_REGADDR(x) ((x) << S_REGADDR)
#define G_REGADDR(x) (((x) >> S_REGADDR) & M_REGADDR)

#define A_MI1_DATA 0x6b8

#define S_MDI_DATA    0
#define M_MDI_DATA    0xffff
#define V_MDI_DATA(x) ((x) << S_MDI_DATA)
#define G_MDI_DATA(x) (((x) >> S_MDI_DATA) & M_MDI_DATA)

#define A_MI1_OP 0x6bc

#define S_INC    2
#define V_INC(x) ((x) << S_INC)
#define F_INC    V_INC(1U)

#define S_MDI_OP    0
#define M_MDI_OP    0x3
#define V_MDI_OP(x) ((x) << S_MDI_OP)
#define G_MDI_OP(x) (((x) >> S_MDI_OP) & M_MDI_OP)

/* registers for module JM1 */
#define JM1_BASE_ADDR 0x6c0

#define A_JM_CFG 0x6c0

#define S_JM_CLKDIV    2
#define M_JM_CLKDIV    0xff
#define V_JM_CLKDIV(x) ((x) << S_JM_CLKDIV)
#define G_JM_CLKDIV(x) (((x) >> S_JM_CLKDIV) & M_JM_CLKDIV)

#define S_TRST    1
#define V_TRST(x) ((x) << S_TRST)
#define F_TRST    V_TRST(1U)

#define S_EN    0
#define V_EN(x) ((x) << S_EN)
#define F_EN    V_EN(1U)

#define A_JM_MODE 0x6c4
#define A_JM_DATA 0x6c8
#define A_JM_OP 0x6cc

#define S_CNT    0
#define M_CNT    0x1f
#define V_CNT(x) ((x) << S_CNT)
#define G_CNT(x) (((x) >> S_CNT) & M_CNT)

/* registers for module SF1 */
#define SF1_BASE_ADDR 0x6d8

#define A_SF_DATA 0x6d8
#define A_SF_OP 0x6dc

#define S_BYTECNT    1
#define M_BYTECNT    0x3
#define V_BYTECNT(x) ((x) << S_BYTECNT)
#define G_BYTECNT(x) (((x) >> S_BYTECNT) & M_BYTECNT)

/* registers for module PL3 */
#define PL3_BASE_ADDR 0x6e0

#define A_PL_INT_ENABLE0 0x6e0

#define S_SW    25
#define V_SW(x) ((x) << S_SW)
#define F_SW    V_SW(1U)

#define S_EXT    24
#define V_EXT(x) ((x) << S_EXT)
#define F_EXT    V_EXT(1U)

#define S_T3DBG    23
#define V_T3DBG(x) ((x) << S_T3DBG)
#define F_T3DBG    V_T3DBG(1U)

#define S_XGMAC0_1    20
#define V_XGMAC0_1(x) ((x) << S_XGMAC0_1)
#define F_XGMAC0_1    V_XGMAC0_1(1U)

#define S_XGMAC0_0    19
#define V_XGMAC0_0(x) ((x) << S_XGMAC0_0)
#define F_XGMAC0_0    V_XGMAC0_0(1U)

#define S_MC5A    18
#define V_MC5A(x) ((x) << S_MC5A)
#define F_MC5A    V_MC5A(1U)

#define S_SF1    17
#define V_SF1(x) ((x) << S_SF1)
#define F_SF1    V_SF1(1U)

#define S_SMB0    15
#define V_SMB0(x) ((x) << S_SMB0)
#define F_SMB0    V_SMB0(1U)

#define S_I2CM0    14
#define V_I2CM0(x) ((x) << S_I2CM0)
#define F_I2CM0    V_I2CM0(1U)

#define S_MI1    13
#define V_MI1(x) ((x) << S_MI1)
#define F_MI1    V_MI1(1U)

#define S_CPL_SWITCH    12
#define V_CPL_SWITCH(x) ((x) << S_CPL_SWITCH)
#define F_CPL_SWITCH    V_CPL_SWITCH(1U)

#define S_MPS0    11
#define V_MPS0(x) ((x) << S_MPS0)
#define F_MPS0    V_MPS0(1U)

#define S_PM1_TX    10
#define V_PM1_TX(x) ((x) << S_PM1_TX)
#define F_PM1_TX    V_PM1_TX(1U)

#define S_PM1_RX    9
#define V_PM1_RX(x) ((x) << S_PM1_RX)
#define F_PM1_RX    V_PM1_RX(1U)

#define S_ULP2_TX    8
#define V_ULP2_TX(x) ((x) << S_ULP2_TX)
#define F_ULP2_TX    V_ULP2_TX(1U)

#define S_ULP2_RX    7
#define V_ULP2_RX(x) ((x) << S_ULP2_RX)
#define F_ULP2_RX    V_ULP2_RX(1U)

#define S_TP1    6
#define V_TP1(x) ((x) << S_TP1)
#define F_TP1    V_TP1(1U)

#define S_CIM    5
#define V_CIM(x) ((x) << S_CIM)
#define F_CIM    V_CIM(1U)

#define S_MC7_CM    4
#define V_MC7_CM(x) ((x) << S_MC7_CM)
#define F_MC7_CM    V_MC7_CM(1U)

#define S_MC7_PMTX    3
#define V_MC7_PMTX(x) ((x) << S_MC7_PMTX)
#define F_MC7_PMTX    V_MC7_PMTX(1U)

#define S_MC7_PMRX    2
#define V_MC7_PMRX(x) ((x) << S_MC7_PMRX)
#define F_MC7_PMRX    V_MC7_PMRX(1U)

#define S_PCIM0    1
#define V_PCIM0(x) ((x) << S_PCIM0)
#define F_PCIM0    V_PCIM0(1U)

#define S_SGE3    0
#define V_SGE3(x) ((x) << S_SGE3)
#define F_SGE3    V_SGE3(1U)

#define A_PL_INT_CAUSE0 0x6e4
#define A_PL_INT_ENABLE1 0x6e8
#define A_PL_INT_CAUSE1 0x6ec
#define A_PL_RST 0x6f0

#define S_FATALPERREN    4
#define V_FATALPERREN(x) ((x) << S_FATALPERREN)
#define F_FATALPERREN    V_FATALPERREN(1U)

#define S_SWINT1    3
#define V_SWINT1(x) ((x) << S_SWINT1)
#define F_SWINT1    V_SWINT1(1U)

#define S_SWINT0    2
#define V_SWINT0(x) ((x) << S_SWINT0)
#define F_SWINT0    V_SWINT0(1U)

#define S_CRSTWRM    1
#define V_CRSTWRM(x) ((x) << S_CRSTWRM)
#define F_CRSTWRM    V_CRSTWRM(1U)

#define A_PL_REV 0x6f4

#define S_REV    0
#define M_REV    0xf
#define V_REV(x) ((x) << S_REV)
#define G_REV(x) (((x) >> S_REV) & M_REV)

#define A_PL_CLI 0x6f8
#define A_PL_LCK 0x6fc

#define S_LCK    0
#define M_LCK    0x3
#define V_LCK(x) ((x) << S_LCK)
#define G_LCK(x) (((x) >> S_LCK) & M_LCK)

/* registers for module MC5A */
#define MC5A_BASE_ADDR 0x700

#define A_MC5_BUF_CONFIG 0x700

#define S_TERM300_240    31
#define V_TERM300_240(x) ((x) << S_TERM300_240)
#define F_TERM300_240    V_TERM300_240(1U)

#define S_MC5_TERM150    30
#define V_MC5_TERM150(x) ((x) << S_MC5_TERM150)
#define F_MC5_TERM150    V_MC5_TERM150(1U)

#define S_TERM60    29
#define V_TERM60(x) ((x) << S_TERM60)
#define F_TERM60    V_TERM60(1U)

#define S_GDDRIII    28
#define V_GDDRIII(x) ((x) << S_GDDRIII)
#define F_GDDRIII    V_GDDRIII(1U)

#define S_GDDRII    27
#define V_GDDRII(x) ((x) << S_GDDRII)
#define F_GDDRII    V_GDDRII(1U)

#define S_GDDRI    26
#define V_GDDRI(x) ((x) << S_GDDRI)
#define F_GDDRI    V_GDDRI(1U)

#define S_READ    25
#define V_READ(x) ((x) << S_READ)
#define F_READ    V_READ(1U)

#define S_IMP_SET_UPDATE    24
#define V_IMP_SET_UPDATE(x) ((x) << S_IMP_SET_UPDATE)
#define F_IMP_SET_UPDATE    V_IMP_SET_UPDATE(1U)

#define S_CAL_UPDATE    23
#define V_CAL_UPDATE(x) ((x) << S_CAL_UPDATE)
#define F_CAL_UPDATE    V_CAL_UPDATE(1U)

#define S_CAL_BUSY    22
#define V_CAL_BUSY(x) ((x) << S_CAL_BUSY)
#define F_CAL_BUSY    V_CAL_BUSY(1U)

#define S_CAL_ERROR    21
#define V_CAL_ERROR(x) ((x) << S_CAL_ERROR)
#define F_CAL_ERROR    V_CAL_ERROR(1U)

#define S_SGL_CAL_EN    20
#define V_SGL_CAL_EN(x) ((x) << S_SGL_CAL_EN)
#define F_SGL_CAL_EN    V_SGL_CAL_EN(1U)

#define S_IMP_UPD_MODE    19
#define V_IMP_UPD_MODE(x) ((x) << S_IMP_UPD_MODE)
#define F_IMP_UPD_MODE    V_IMP_UPD_MODE(1U)

#define S_IMP_SEL    18
#define V_IMP_SEL(x) ((x) << S_IMP_SEL)
#define F_IMP_SEL    V_IMP_SEL(1U)

#define S_MAN_PU    15
#define M_MAN_PU    0x7
#define V_MAN_PU(x) ((x) << S_MAN_PU)
#define G_MAN_PU(x) (((x) >> S_MAN_PU) & M_MAN_PU)

#define S_MAN_PD    12
#define M_MAN_PD    0x7
#define V_MAN_PD(x) ((x) << S_MAN_PD)
#define G_MAN_PD(x) (((x) >> S_MAN_PD) & M_MAN_PD)

#define S_CAL_PU    9
#define M_CAL_PU    0x7
#define V_CAL_PU(x) ((x) << S_CAL_PU)
#define G_CAL_PU(x) (((x) >> S_CAL_PU) & M_CAL_PU)

#define S_CAL_PD    6
#define M_CAL_PD    0x7
#define V_CAL_PD(x) ((x) << S_CAL_PD)
#define G_CAL_PD(x) (((x) >> S_CAL_PD) & M_CAL_PD)

#define S_SET_PU    3
#define M_SET_PU    0x7
#define V_SET_PU(x) ((x) << S_SET_PU)
#define G_SET_PU(x) (((x) >> S_SET_PU) & M_SET_PU)

#define S_SET_PD    0
#define M_SET_PD    0x7
#define V_SET_PD(x) ((x) << S_SET_PD)
#define G_SET_PD(x) (((x) >> S_SET_PD) & M_SET_PD)

#define S_CAL_IMP_UPD    23
#define V_CAL_IMP_UPD(x) ((x) << S_CAL_IMP_UPD)
#define F_CAL_IMP_UPD    V_CAL_IMP_UPD(1U)

#define A_MC5_DB_CONFIG 0x704

#define S_TMCFGWRLOCK    31
#define V_TMCFGWRLOCK(x) ((x) << S_TMCFGWRLOCK)
#define F_TMCFGWRLOCK    V_TMCFGWRLOCK(1U)

#define S_TMTYPEHI    30
#define V_TMTYPEHI(x) ((x) << S_TMTYPEHI)
#define F_TMTYPEHI    V_TMTYPEHI(1U)

#define S_TMPARTSIZE    28
#define M_TMPARTSIZE    0x3
#define V_TMPARTSIZE(x) ((x) << S_TMPARTSIZE)
#define G_TMPARTSIZE(x) (((x) >> S_TMPARTSIZE) & M_TMPARTSIZE)

#define S_TMTYPE    26
#define M_TMTYPE    0x3
#define V_TMTYPE(x) ((x) << S_TMTYPE)
#define G_TMTYPE(x) (((x) >> S_TMTYPE) & M_TMTYPE)

#define S_TMPARTCOUNT    24
#define M_TMPARTCOUNT    0x3
#define V_TMPARTCOUNT(x) ((x) << S_TMPARTCOUNT)
#define G_TMPARTCOUNT(x) (((x) >> S_TMPARTCOUNT) & M_TMPARTCOUNT)

#define S_NLIP    18
#define M_NLIP    0x3f
#define V_NLIP(x) ((x) << S_NLIP)
#define G_NLIP(x) (((x) >> S_NLIP) & M_NLIP)

#define S_COMPEN    17
#define V_COMPEN(x) ((x) << S_COMPEN)
#define F_COMPEN    V_COMPEN(1U)

#define S_BUILD    16
#define V_BUILD(x) ((x) << S_BUILD)
#define F_BUILD    V_BUILD(1U)

#define S_FILTEREN    11
#define V_FILTEREN(x) ((x) << S_FILTEREN)
#define F_FILTEREN    V_FILTEREN(1U)

#define S_CLIPUPDATE    10
#define V_CLIPUPDATE(x) ((x) << S_CLIPUPDATE)
#define F_CLIPUPDATE    V_CLIPUPDATE(1U)

#define S_TM_IO_PDOWN    9
#define V_TM_IO_PDOWN(x) ((x) << S_TM_IO_PDOWN)
#define F_TM_IO_PDOWN    V_TM_IO_PDOWN(1U)

#define S_SYNMODE    7
#define M_SYNMODE    0x3
#define V_SYNMODE(x) ((x) << S_SYNMODE)
#define G_SYNMODE(x) (((x) >> S_SYNMODE) & M_SYNMODE)

#define S_PRTYEN    6
#define V_PRTYEN(x) ((x) << S_PRTYEN)
#define F_PRTYEN    V_PRTYEN(1U)

#define S_MBUSEN    5
#define V_MBUSEN(x) ((x) << S_MBUSEN)
#define F_MBUSEN    V_MBUSEN(1U)

#define S_DBGIEN    4
#define V_DBGIEN(x) ((x) << S_DBGIEN)
#define F_DBGIEN    V_DBGIEN(1U)

#define S_TCMCFGOVR    3
#define V_TCMCFGOVR(x) ((x) << S_TCMCFGOVR)
#define F_TCMCFGOVR    V_TCMCFGOVR(1U)

#define S_TMRDY    2
#define V_TMRDY(x) ((x) << S_TMRDY)
#define F_TMRDY    V_TMRDY(1U)

#define S_TMRST    1
#define V_TMRST(x) ((x) << S_TMRST)
#define F_TMRST    V_TMRST(1U)

#define S_TMMODE    0
#define V_TMMODE(x) ((x) << S_TMMODE)
#define F_TMMODE    V_TMMODE(1U)

#define A_MC5_MISC 0x708

#define S_LIP_CMP_UNAVAILABLE    0
#define M_LIP_CMP_UNAVAILABLE    0xf
#define V_LIP_CMP_UNAVAILABLE(x) ((x) << S_LIP_CMP_UNAVAILABLE)
#define G_LIP_CMP_UNAVAILABLE(x) (((x) >> S_LIP_CMP_UNAVAILABLE) & M_LIP_CMP_UNAVAILABLE)

#define A_MC5_DB_ROUTING_TABLE_INDEX 0x70c

#define S_RTINDX    0
#define M_RTINDX    0x3fffff
#define V_RTINDX(x) ((x) << S_RTINDX)
#define G_RTINDX(x) (((x) >> S_RTINDX) & M_RTINDX)

#define A_MC5_DB_FILTER_TABLE 0x710

#define S_SRINDX    0
#define M_SRINDX    0x3fffff
#define V_SRINDX(x) ((x) << S_SRINDX)
#define G_SRINDX(x) (((x) >> S_SRINDX) & M_SRINDX)

#define A_MC5_DB_SERVER_INDEX 0x714
#define A_MC5_DB_LIP_RAM_ADDR 0x718

#define S_RAMWR    8
#define V_RAMWR(x) ((x) << S_RAMWR)
#define F_RAMWR    V_RAMWR(1U)

#define S_RAMADDR    0
#define M_RAMADDR    0x3f
#define V_RAMADDR(x) ((x) << S_RAMADDR)
#define G_RAMADDR(x) (((x) >> S_RAMADDR) & M_RAMADDR)

#define A_MC5_DB_LIP_RAM_DATA 0x71c
#define A_MC5_DB_RSP_LATENCY 0x720

#define S_RDLAT    16
#define M_RDLAT    0x1f
#define V_RDLAT(x) ((x) << S_RDLAT)
#define G_RDLAT(x) (((x) >> S_RDLAT) & M_RDLAT)

#define S_LRNLAT    8
#define M_LRNLAT    0x1f
#define V_LRNLAT(x) ((x) << S_LRNLAT)
#define G_LRNLAT(x) (((x) >> S_LRNLAT) & M_LRNLAT)

#define S_SRCHLAT    0
#define M_SRCHLAT    0x1f
#define V_SRCHLAT(x) ((x) << S_SRCHLAT)
#define G_SRCHLAT(x) (((x) >> S_SRCHLAT) & M_SRCHLAT)

#define A_MC5_DB_PARITY_LATENCY 0x724

#define S_PARLAT    0
#define M_PARLAT    0xf
#define V_PARLAT(x) ((x) << S_PARLAT)
#define G_PARLAT(x) (((x) >> S_PARLAT) & M_PARLAT)

#define A_MC5_DB_WR_LRN_VERIFY 0x728

#define S_VWVEREN    2
#define V_VWVEREN(x) ((x) << S_VWVEREN)
#define F_VWVEREN    V_VWVEREN(1U)

#define S_LRNVEREN    1
#define V_LRNVEREN(x) ((x) << S_LRNVEREN)
#define F_LRNVEREN    V_LRNVEREN(1U)

#define S_POVEREN    0
#define V_POVEREN(x) ((x) << S_POVEREN)
#define F_POVEREN    V_POVEREN(1U)

#define A_MC5_DB_PART_ID_INDEX 0x72c

#define S_IDINDEX    0
#define M_IDINDEX    0xf
#define V_IDINDEX(x) ((x) << S_IDINDEX)
#define G_IDINDEX(x) (((x) >> S_IDINDEX) & M_IDINDEX)

#define A_MC5_DB_RESET_MAX 0x730

#define S_RSTMAX    0
#define M_RSTMAX    0xf
#define V_RSTMAX(x) ((x) << S_RSTMAX)
#define G_RSTMAX(x) (((x) >> S_RSTMAX) & M_RSTMAX)

#define A_MC5_DB_ACT_CNT 0x734

#define S_ACTCNT    0
#define M_ACTCNT    0xfffff
#define V_ACTCNT(x) ((x) << S_ACTCNT)
#define G_ACTCNT(x) (((x) >> S_ACTCNT) & M_ACTCNT)

#define A_MC5_DB_CLIP_MAP 0x738

#define S_CLIPMAPOP    31
#define V_CLIPMAPOP(x) ((x) << S_CLIPMAPOP)
#define F_CLIPMAPOP    V_CLIPMAPOP(1U)

#define S_CLIPMAPVAL    16
#define M_CLIPMAPVAL    0x3f
#define V_CLIPMAPVAL(x) ((x) << S_CLIPMAPVAL)
#define G_CLIPMAPVAL(x) (((x) >> S_CLIPMAPVAL) & M_CLIPMAPVAL)

#define S_CLIPMAPADDR    0
#define M_CLIPMAPADDR    0x3f
#define V_CLIPMAPADDR(x) ((x) << S_CLIPMAPADDR)
#define G_CLIPMAPADDR(x) (((x) >> S_CLIPMAPADDR) & M_CLIPMAPADDR)

#define A_MC5_DB_SIZE 0x73c
#define A_MC5_DB_INT_ENABLE 0x740

#define S_MSGSEL    28
#define M_MSGSEL    0xf
#define V_MSGSEL(x) ((x) << S_MSGSEL)
#define G_MSGSEL(x) (((x) >> S_MSGSEL) & M_MSGSEL)

#define S_DELACTEMPTY    18
#define V_DELACTEMPTY(x) ((x) << S_DELACTEMPTY)
#define F_DELACTEMPTY    V_DELACTEMPTY(1U)

#define S_DISPQPARERR    17
#define V_DISPQPARERR(x) ((x) << S_DISPQPARERR)
#define F_DISPQPARERR    V_DISPQPARERR(1U)

#define S_REQQPARERR    16
#define V_REQQPARERR(x) ((x) << S_REQQPARERR)
#define F_REQQPARERR    V_REQQPARERR(1U)

#define S_UNKNOWNCMD    15
#define V_UNKNOWNCMD(x) ((x) << S_UNKNOWNCMD)
#define F_UNKNOWNCMD    V_UNKNOWNCMD(1U)

#define S_SYNCOOKIEOFF    11
#define V_SYNCOOKIEOFF(x) ((x) << S_SYNCOOKIEOFF)
#define F_SYNCOOKIEOFF    V_SYNCOOKIEOFF(1U)

#define S_SYNCOOKIEBAD    10
#define V_SYNCOOKIEBAD(x) ((x) << S_SYNCOOKIEBAD)
#define F_SYNCOOKIEBAD    V_SYNCOOKIEBAD(1U)

#define S_SYNCOOKIE    9
#define V_SYNCOOKIE(x) ((x) << S_SYNCOOKIE)
#define F_SYNCOOKIE    V_SYNCOOKIE(1U)

#define S_NFASRCHFAIL    8
#define V_NFASRCHFAIL(x) ((x) << S_NFASRCHFAIL)
#define F_NFASRCHFAIL    V_NFASRCHFAIL(1U)

#define S_ACTRGNFULL    7
#define V_ACTRGNFULL(x) ((x) << S_ACTRGNFULL)
#define F_ACTRGNFULL    V_ACTRGNFULL(1U)

#define S_PARITYERR    6
#define V_PARITYERR(x) ((x) << S_PARITYERR)
#define F_PARITYERR    V_PARITYERR(1U)

#define S_LIPMISS    5
#define V_LIPMISS(x) ((x) << S_LIPMISS)
#define F_LIPMISS    V_LIPMISS(1U)

#define S_LIP0    4
#define V_LIP0(x) ((x) << S_LIP0)
#define F_LIP0    V_LIP0(1U)

#define S_MISS    3
#define V_MISS(x) ((x) << S_MISS)
#define F_MISS    V_MISS(1U)

#define S_ROUTINGHIT    2
#define V_ROUTINGHIT(x) ((x) << S_ROUTINGHIT)
#define F_ROUTINGHIT    V_ROUTINGHIT(1U)

#define S_ACTIVEHIT    1
#define V_ACTIVEHIT(x) ((x) << S_ACTIVEHIT)
#define F_ACTIVEHIT    V_ACTIVEHIT(1U)

#define S_ACTIVEOUTHIT    0
#define V_ACTIVEOUTHIT(x) ((x) << S_ACTIVEOUTHIT)
#define F_ACTIVEOUTHIT    V_ACTIVEOUTHIT(1U)

#define A_MC5_DB_INT_CAUSE 0x744
#define A_MC5_DB_INT_TID 0x748

#define S_INTTID    0
#define M_INTTID    0xfffff
#define V_INTTID(x) ((x) << S_INTTID)
#define G_INTTID(x) (((x) >> S_INTTID) & M_INTTID)

#define A_MC5_DB_INT_PTID 0x74c

#define S_INTPTID    0
#define M_INTPTID    0xfffff
#define V_INTPTID(x) ((x) << S_INTPTID)
#define G_INTPTID(x) (((x) >> S_INTPTID) & M_INTPTID)

#define A_MC5_DB_DBGI_CONFIG 0x774

#define S_WRREQSIZE    22
#define M_WRREQSIZE    0x3ff
#define V_WRREQSIZE(x) ((x) << S_WRREQSIZE)
#define G_WRREQSIZE(x) (((x) >> S_WRREQSIZE) & M_WRREQSIZE)

#define S_SADRSEL    4
#define V_SADRSEL(x) ((x) << S_SADRSEL)
#define F_SADRSEL    V_SADRSEL(1U)

#define S_CMDMODE    0
#define M_CMDMODE    0x7
#define V_CMDMODE(x) ((x) << S_CMDMODE)
#define G_CMDMODE(x) (((x) >> S_CMDMODE) & M_CMDMODE)

#define A_MC5_DB_DBGI_REQ_CMD 0x778

#define S_MBUSCMD    0
#define M_MBUSCMD    0xf
#define V_MBUSCMD(x) ((x) << S_MBUSCMD)
#define G_MBUSCMD(x) (((x) >> S_MBUSCMD) & M_MBUSCMD)

#define S_IDTCMDHI    11
#define M_IDTCMDHI    0x7
#define V_IDTCMDHI(x) ((x) << S_IDTCMDHI)
#define G_IDTCMDHI(x) (((x) >> S_IDTCMDHI) & M_IDTCMDHI)

#define S_IDTCMDLO    0
#define M_IDTCMDLO    0xf
#define V_IDTCMDLO(x) ((x) << S_IDTCMDLO)
#define G_IDTCMDLO(x) (((x) >> S_IDTCMDLO) & M_IDTCMDLO)

#define S_IDTCMD    0
#define M_IDTCMD    0xfffff
#define V_IDTCMD(x) ((x) << S_IDTCMD)
#define G_IDTCMD(x) (((x) >> S_IDTCMD) & M_IDTCMD)

#define S_LCMDB    16
#define M_LCMDB    0x7ff
#define V_LCMDB(x) ((x) << S_LCMDB)
#define G_LCMDB(x) (((x) >> S_LCMDB) & M_LCMDB)

#define S_LCMDA    0
#define M_LCMDA    0x7ff
#define V_LCMDA(x) ((x) << S_LCMDA)
#define G_LCMDA(x) (((x) >> S_LCMDA) & M_LCMDA)

#define A_MC5_DB_DBGI_REQ_ADDR0 0x77c
#define A_MC5_DB_DBGI_REQ_ADDR1 0x780
#define A_MC5_DB_DBGI_REQ_ADDR2 0x784

#define S_DBGIREQADRHI    0
#define M_DBGIREQADRHI    0xff
#define V_DBGIREQADRHI(x) ((x) << S_DBGIREQADRHI)
#define G_DBGIREQADRHI(x) (((x) >> S_DBGIREQADRHI) & M_DBGIREQADRHI)

#define A_MC5_DB_DBGI_REQ_DATA0 0x788
#define A_MC5_DB_DBGI_REQ_DATA1 0x78c
#define A_MC5_DB_DBGI_REQ_DATA2 0x790
#define A_MC5_DB_DBGI_REQ_DATA3 0x794
#define A_MC5_DB_DBGI_REQ_DATA4 0x798

#define S_DBGIREQDATA4    0
#define M_DBGIREQDATA4    0xffff
#define V_DBGIREQDATA4(x) ((x) << S_DBGIREQDATA4)
#define G_DBGIREQDATA4(x) (((x) >> S_DBGIREQDATA4) & M_DBGIREQDATA4)

#define A_MC5_DB_DBGI_REQ_MASK0 0x79c
#define A_MC5_DB_DBGI_REQ_MASK1 0x7a0
#define A_MC5_DB_DBGI_REQ_MASK2 0x7a4
#define A_MC5_DB_DBGI_REQ_MASK3 0x7a8
#define A_MC5_DB_DBGI_REQ_MASK4 0x7ac

#define S_DBGIREQMSK4    0
#define M_DBGIREQMSK4    0xffff
#define V_DBGIREQMSK4(x) ((x) << S_DBGIREQMSK4)
#define G_DBGIREQMSK4(x) (((x) >> S_DBGIREQMSK4) & M_DBGIREQMSK4)

#define A_MC5_DB_DBGI_RSP_STATUS 0x7b0

#define S_DBGIRSPMSG    8
#define M_DBGIRSPMSG    0xf
#define V_DBGIRSPMSG(x) ((x) << S_DBGIRSPMSG)
#define G_DBGIRSPMSG(x) (((x) >> S_DBGIRSPMSG) & M_DBGIRSPMSG)

#define S_DBGIRSPMSGVLD    2
#define V_DBGIRSPMSGVLD(x) ((x) << S_DBGIRSPMSGVLD)
#define F_DBGIRSPMSGVLD    V_DBGIRSPMSGVLD(1U)

#define S_DBGIRSPHIT    1
#define V_DBGIRSPHIT(x) ((x) << S_DBGIRSPHIT)
#define F_DBGIRSPHIT    V_DBGIRSPHIT(1U)

#define S_DBGIRSPVALID    0
#define V_DBGIRSPVALID(x) ((x) << S_DBGIRSPVALID)
#define F_DBGIRSPVALID    V_DBGIRSPVALID(1U)

#define A_MC5_DB_DBGI_RSP_DATA0 0x7b4
#define A_MC5_DB_DBGI_RSP_DATA1 0x7b8
#define A_MC5_DB_DBGI_RSP_DATA2 0x7bc
#define A_MC5_DB_DBGI_RSP_DATA3 0x7c0
#define A_MC5_DB_DBGI_RSP_DATA4 0x7c4

#define S_DBGIRSPDATA3    0
#define M_DBGIRSPDATA3    0xffff
#define V_DBGIRSPDATA3(x) ((x) << S_DBGIRSPDATA3)
#define G_DBGIRSPDATA3(x) (((x) >> S_DBGIRSPDATA3) & M_DBGIRSPDATA3)

#define A_MC5_DB_DBGI_RSP_LAST_CMD 0x7c8

#define S_LASTCMDB    16
#define M_LASTCMDB    0x7ff
#define V_LASTCMDB(x) ((x) << S_LASTCMDB)
#define G_LASTCMDB(x) (((x) >> S_LASTCMDB) & M_LASTCMDB)

#define S_LASTCMDA    0
#define M_LASTCMDA    0x7ff
#define V_LASTCMDA(x) ((x) << S_LASTCMDA)
#define G_LASTCMDA(x) (((x) >> S_LASTCMDA) & M_LASTCMDA)

#define A_MC5_DB_POPEN_DATA_WR_CMD 0x7cc

#define S_PO_DWR    0
#define M_PO_DWR    0xfffff
#define V_PO_DWR(x) ((x) << S_PO_DWR)
#define G_PO_DWR(x) (((x) >> S_PO_DWR) & M_PO_DWR)

#define A_MC5_DB_POPEN_MASK_WR_CMD 0x7d0

#define S_PO_MWR    0
#define M_PO_MWR    0xfffff
#define V_PO_MWR(x) ((x) << S_PO_MWR)
#define G_PO_MWR(x) (((x) >> S_PO_MWR) & M_PO_MWR)

#define A_MC5_DB_AOPEN_SRCH_CMD 0x7d4

#define S_AO_SRCH    0
#define M_AO_SRCH    0xfffff
#define V_AO_SRCH(x) ((x) << S_AO_SRCH)
#define G_AO_SRCH(x) (((x) >> S_AO_SRCH) & M_AO_SRCH)

#define A_MC5_DB_AOPEN_LRN_CMD 0x7d8

#define S_AO_LRN    0
#define M_AO_LRN    0xfffff
#define V_AO_LRN(x) ((x) << S_AO_LRN)
#define G_AO_LRN(x) (((x) >> S_AO_LRN) & M_AO_LRN)

#define A_MC5_DB_SYN_SRCH_CMD 0x7dc

#define S_SYN_SRCH    0
#define M_SYN_SRCH    0xfffff
#define V_SYN_SRCH(x) ((x) << S_SYN_SRCH)
#define G_SYN_SRCH(x) (((x) >> S_SYN_SRCH) & M_SYN_SRCH)

#define A_MC5_DB_SYN_LRN_CMD 0x7e0

#define S_SYN_LRN    0
#define M_SYN_LRN    0xfffff
#define V_SYN_LRN(x) ((x) << S_SYN_LRN)
#define G_SYN_LRN(x) (((x) >> S_SYN_LRN) & M_SYN_LRN)

#define A_MC5_DB_ACK_SRCH_CMD 0x7e4

#define S_ACK_SRCH    0
#define M_ACK_SRCH    0xfffff
#define V_ACK_SRCH(x) ((x) << S_ACK_SRCH)
#define G_ACK_SRCH(x) (((x) >> S_ACK_SRCH) & M_ACK_SRCH)

#define A_MC5_DB_ACK_LRN_CMD 0x7e8

#define S_ACK_LRN    0
#define M_ACK_LRN    0xfffff
#define V_ACK_LRN(x) ((x) << S_ACK_LRN)
#define G_ACK_LRN(x) (((x) >> S_ACK_LRN) & M_ACK_LRN)

#define A_MC5_DB_ILOOKUP_CMD 0x7ec

#define S_I_SRCH    0
#define M_I_SRCH    0xfffff
#define V_I_SRCH(x) ((x) << S_I_SRCH)
#define G_I_SRCH(x) (((x) >> S_I_SRCH) & M_I_SRCH)

#define A_MC5_DB_ELOOKUP_CMD 0x7f0

#define S_E_SRCH    0
#define M_E_SRCH    0xfffff
#define V_E_SRCH(x) ((x) << S_E_SRCH)
#define G_E_SRCH(x) (((x) >> S_E_SRCH) & M_E_SRCH)

#define A_MC5_DB_DATA_WRITE_CMD 0x7f4

#define S_WRITE    0
#define M_WRITE    0xfffff
#define V_WRITE(x) ((x) << S_WRITE)
#define G_WRITE(x) (((x) >> S_WRITE) & M_WRITE)

#define A_MC5_DB_DATA_READ_CMD 0x7f8

#define S_READCMD    0
#define M_READCMD    0xfffff
#define V_READCMD(x) ((x) << S_READCMD)
#define G_READCMD(x) (((x) >> S_READCMD) & M_READCMD)

#define A_MC5_DB_MASK_WRITE_CMD 0x7fc

#define S_MASKWR    0
#define M_MASKWR    0xffff
#define V_MASKWR(x) ((x) << S_MASKWR)
#define G_MASKWR(x) (((x) >> S_MASKWR) & M_MASKWR)

/* registers for module XGMAC0_0 */
#define XGMAC0_0_BASE_ADDR 0x800

#define A_XGM_TX_CTRL 0x800

#define S_SENDPAUSE    2
#define V_SENDPAUSE(x) ((x) << S_SENDPAUSE)
#define F_SENDPAUSE    V_SENDPAUSE(1U)

#define S_SENDZEROPAUSE    1
#define V_SENDZEROPAUSE(x) ((x) << S_SENDZEROPAUSE)
#define F_SENDZEROPAUSE    V_SENDZEROPAUSE(1U)

#define S_TXEN    0
#define V_TXEN(x) ((x) << S_TXEN)
#define F_TXEN    V_TXEN(1U)

#define A_XGM_TX_CFG 0x804

#define S_CFGCLKSPEED    2
#define M_CFGCLKSPEED    0x7
#define V_CFGCLKSPEED(x) ((x) << S_CFGCLKSPEED)
#define G_CFGCLKSPEED(x) (((x) >> S_CFGCLKSPEED) & M_CFGCLKSPEED)

#define S_STRETCHMODE    1
#define V_STRETCHMODE(x) ((x) << S_STRETCHMODE)
#define F_STRETCHMODE    V_STRETCHMODE(1U)

#define S_TXPAUSEEN    0
#define V_TXPAUSEEN(x) ((x) << S_TXPAUSEEN)
#define F_TXPAUSEEN    V_TXPAUSEEN(1U)

#define A_XGM_TX_PAUSE_QUANTA 0x808

#define S_TXPAUSEQUANTA    0
#define M_TXPAUSEQUANTA    0xffff
#define V_TXPAUSEQUANTA(x) ((x) << S_TXPAUSEQUANTA)
#define G_TXPAUSEQUANTA(x) (((x) >> S_TXPAUSEQUANTA) & M_TXPAUSEQUANTA)

#define A_XGM_RX_CTRL 0x80c

#define S_RXEN    0
#define V_RXEN(x) ((x) << S_RXEN)
#define F_RXEN    V_RXEN(1U)

#define A_XGM_RX_CFG 0x810

#define S_CON802_3PREAMBLE    12
#define V_CON802_3PREAMBLE(x) ((x) << S_CON802_3PREAMBLE)
#define F_CON802_3PREAMBLE    V_CON802_3PREAMBLE(1U)

#define S_ENNON802_3PREAMBLE    11
#define V_ENNON802_3PREAMBLE(x) ((x) << S_ENNON802_3PREAMBLE)
#define F_ENNON802_3PREAMBLE    V_ENNON802_3PREAMBLE(1U)

#define S_COPYPREAMBLE    10
#define V_COPYPREAMBLE(x) ((x) << S_COPYPREAMBLE)
#define F_COPYPREAMBLE    V_COPYPREAMBLE(1U)

#define S_DISPAUSEFRAMES    9
#define V_DISPAUSEFRAMES(x) ((x) << S_DISPAUSEFRAMES)
#define F_DISPAUSEFRAMES    V_DISPAUSEFRAMES(1U)

#define S_EN1536BFRAMES    8
#define V_EN1536BFRAMES(x) ((x) << S_EN1536BFRAMES)
#define F_EN1536BFRAMES    V_EN1536BFRAMES(1U)

#define S_ENJUMBO    7
#define V_ENJUMBO(x) ((x) << S_ENJUMBO)
#define F_ENJUMBO    V_ENJUMBO(1U)

#define S_RMFCS    6
#define V_RMFCS(x) ((x) << S_RMFCS)
#define F_RMFCS    V_RMFCS(1U)

#define S_DISNONVLAN    5
#define V_DISNONVLAN(x) ((x) << S_DISNONVLAN)
#define F_DISNONVLAN    V_DISNONVLAN(1U)

#define S_ENEXTMATCH    4
#define V_ENEXTMATCH(x) ((x) << S_ENEXTMATCH)
#define F_ENEXTMATCH    V_ENEXTMATCH(1U)

#define S_ENHASHUCAST    3
#define V_ENHASHUCAST(x) ((x) << S_ENHASHUCAST)
#define F_ENHASHUCAST    V_ENHASHUCAST(1U)

#define S_ENHASHMCAST    2
#define V_ENHASHMCAST(x) ((x) << S_ENHASHMCAST)
#define F_ENHASHMCAST    V_ENHASHMCAST(1U)

#define S_DISBCAST    1
#define V_DISBCAST(x) ((x) << S_DISBCAST)
#define F_DISBCAST    V_DISBCAST(1U)

#define S_COPYALLFRAMES    0
#define V_COPYALLFRAMES(x) ((x) << S_COPYALLFRAMES)
#define F_COPYALLFRAMES    V_COPYALLFRAMES(1U)

#define A_XGM_RX_HASH_LOW 0x814
#define A_XGM_RX_HASH_HIGH 0x818
#define A_XGM_RX_EXACT_MATCH_LOW_1 0x81c
#define A_XGM_RX_EXACT_MATCH_HIGH_1 0x820

#define S_ADDRESS_HIGH    0
#define M_ADDRESS_HIGH    0xffff
#define V_ADDRESS_HIGH(x) ((x) << S_ADDRESS_HIGH)
#define G_ADDRESS_HIGH(x) (((x) >> S_ADDRESS_HIGH) & M_ADDRESS_HIGH)

#define A_XGM_RX_EXACT_MATCH_LOW_2 0x824
#define A_XGM_RX_EXACT_MATCH_HIGH_2 0x828
#define A_XGM_RX_EXACT_MATCH_LOW_3 0x82c
#define A_XGM_RX_EXACT_MATCH_HIGH_3 0x830
#define A_XGM_RX_EXACT_MATCH_LOW_4 0x834
#define A_XGM_RX_EXACT_MATCH_HIGH_4 0x838
#define A_XGM_RX_EXACT_MATCH_LOW_5 0x83c
#define A_XGM_RX_EXACT_MATCH_HIGH_5 0x840
#define A_XGM_RX_EXACT_MATCH_LOW_6 0x844
#define A_XGM_RX_EXACT_MATCH_HIGH_6 0x848
#define A_XGM_RX_EXACT_MATCH_LOW_7 0x84c
#define A_XGM_RX_EXACT_MATCH_HIGH_7 0x850
#define A_XGM_RX_EXACT_MATCH_LOW_8 0x854
#define A_XGM_RX_EXACT_MATCH_HIGH_8 0x858
#define A_XGM_RX_TYPE_MATCH_1 0x85c

#define S_ENTYPEMATCH    31
#define V_ENTYPEMATCH(x) ((x) << S_ENTYPEMATCH)
#define F_ENTYPEMATCH    V_ENTYPEMATCH(1U)

#define S_TYPE    0
#define M_TYPE    0xffff
#define V_TYPE(x) ((x) << S_TYPE)
#define G_TYPE(x) (((x) >> S_TYPE) & M_TYPE)

#define A_XGM_RX_TYPE_MATCH_2 0x860
#define A_XGM_RX_TYPE_MATCH_3 0x864
#define A_XGM_RX_TYPE_MATCH_4 0x868
#define A_XGM_INT_STATUS 0x86c

#define S_XGMIIEXTINT    10
#define V_XGMIIEXTINT(x) ((x) << S_XGMIIEXTINT)
#define F_XGMIIEXTINT    V_XGMIIEXTINT(1U)

#define S_LINKFAULTCHANGE    9
#define V_LINKFAULTCHANGE(x) ((x) << S_LINKFAULTCHANGE)
#define F_LINKFAULTCHANGE    V_LINKFAULTCHANGE(1U)

#define S_PHYFRAMECOMPLETE    8
#define V_PHYFRAMECOMPLETE(x) ((x) << S_PHYFRAMECOMPLETE)
#define F_PHYFRAMECOMPLETE    V_PHYFRAMECOMPLETE(1U)

#define S_PAUSEFRAMETXMT    7
#define V_PAUSEFRAMETXMT(x) ((x) << S_PAUSEFRAMETXMT)
#define F_PAUSEFRAMETXMT    V_PAUSEFRAMETXMT(1U)

#define S_PAUSECNTRTIMEOUT    6
#define V_PAUSECNTRTIMEOUT(x) ((x) << S_PAUSECNTRTIMEOUT)
#define F_PAUSECNTRTIMEOUT    V_PAUSECNTRTIMEOUT(1U)

#define S_NON0PAUSERCVD    5
#define V_NON0PAUSERCVD(x) ((x) << S_NON0PAUSERCVD)
#define F_NON0PAUSERCVD    V_NON0PAUSERCVD(1U)

#define S_STATOFLOW    4
#define V_STATOFLOW(x) ((x) << S_STATOFLOW)
#define F_STATOFLOW    V_STATOFLOW(1U)

#define S_TXERRFIFO    3
#define V_TXERRFIFO(x) ((x) << S_TXERRFIFO)
#define F_TXERRFIFO    V_TXERRFIFO(1U)

#define S_TXUFLOW    2
#define V_TXUFLOW(x) ((x) << S_TXUFLOW)
#define F_TXUFLOW    V_TXUFLOW(1U)

#define S_FRAMETXMT    1
#define V_FRAMETXMT(x) ((x) << S_FRAMETXMT)
#define F_FRAMETXMT    V_FRAMETXMT(1U)

#define S_FRAMERCVD    0
#define V_FRAMERCVD(x) ((x) << S_FRAMERCVD)
#define F_FRAMERCVD    V_FRAMERCVD(1U)

#define A_XGM_XGM_INT_MASK 0x870
#define A_XGM_XGM_INT_ENABLE 0x874
#define A_XGM_XGM_INT_DISABLE 0x878
#define A_XGM_TX_PAUSE_TIMER 0x87c

#define S_CURPAUSETIMER    0
#define M_CURPAUSETIMER    0xffff
#define V_CURPAUSETIMER(x) ((x) << S_CURPAUSETIMER)
#define G_CURPAUSETIMER(x) (((x) >> S_CURPAUSETIMER) & M_CURPAUSETIMER)

#define A_XGM_STAT_CTRL 0x880

#define S_READSNPSHOT    4
#define V_READSNPSHOT(x) ((x) << S_READSNPSHOT)
#define F_READSNPSHOT    V_READSNPSHOT(1U)

#define S_TAKESNPSHOT    3
#define V_TAKESNPSHOT(x) ((x) << S_TAKESNPSHOT)
#define F_TAKESNPSHOT    V_TAKESNPSHOT(1U)

#define S_CLRSTATS    2
#define V_CLRSTATS(x) ((x) << S_CLRSTATS)
#define F_CLRSTATS    V_CLRSTATS(1U)

#define S_INCRSTATS    1
#define V_INCRSTATS(x) ((x) << S_INCRSTATS)
#define F_INCRSTATS    V_INCRSTATS(1U)

#define S_ENTESTMODEWR    0
#define V_ENTESTMODEWR(x) ((x) << S_ENTESTMODEWR)
#define F_ENTESTMODEWR    V_ENTESTMODEWR(1U)

#define A_XGM_RXFIFO_CFG 0x884

#define S_RXFIFO_EMPTY    31
#define V_RXFIFO_EMPTY(x) ((x) << S_RXFIFO_EMPTY)
#define F_RXFIFO_EMPTY    V_RXFIFO_EMPTY(1U)

#define S_RXFIFO_FULL    30
#define V_RXFIFO_FULL(x) ((x) << S_RXFIFO_FULL)
#define F_RXFIFO_FULL    V_RXFIFO_FULL(1U)

#define S_RXFIFOPAUSEHWM    17
#define M_RXFIFOPAUSEHWM    0xfff
#define V_RXFIFOPAUSEHWM(x) ((x) << S_RXFIFOPAUSEHWM)
#define G_RXFIFOPAUSEHWM(x) (((x) >> S_RXFIFOPAUSEHWM) & M_RXFIFOPAUSEHWM)

#define S_RXFIFOPAUSELWM    5
#define M_RXFIFOPAUSELWM    0xfff
#define V_RXFIFOPAUSELWM(x) ((x) << S_RXFIFOPAUSELWM)
#define G_RXFIFOPAUSELWM(x) (((x) >> S_RXFIFOPAUSELWM) & M_RXFIFOPAUSELWM)

#define S_FORCEDPAUSE    4
#define V_FORCEDPAUSE(x) ((x) << S_FORCEDPAUSE)
#define F_FORCEDPAUSE    V_FORCEDPAUSE(1U)

#define S_EXTERNLOOPBACK    3
#define V_EXTERNLOOPBACK(x) ((x) << S_EXTERNLOOPBACK)
#define F_EXTERNLOOPBACK    V_EXTERNLOOPBACK(1U)

#define S_RXBYTESWAP    2
#define V_RXBYTESWAP(x) ((x) << S_RXBYTESWAP)
#define F_RXBYTESWAP    V_RXBYTESWAP(1U)

#define S_RXSTRFRWRD    1
#define V_RXSTRFRWRD(x) ((x) << S_RXSTRFRWRD)
#define F_RXSTRFRWRD    V_RXSTRFRWRD(1U)

#define S_DISERRFRAMES    0
#define V_DISERRFRAMES(x) ((x) << S_DISERRFRAMES)
#define F_DISERRFRAMES    V_DISERRFRAMES(1U)

#define A_XGM_TXFIFO_CFG 0x888

#define S_TXFIFO_EMPTY    31
#define V_TXFIFO_EMPTY(x) ((x) << S_TXFIFO_EMPTY)
#define F_TXFIFO_EMPTY    V_TXFIFO_EMPTY(1U)

#define S_TXFIFO_FULL    30
#define V_TXFIFO_FULL(x) ((x) << S_TXFIFO_FULL)
#define F_TXFIFO_FULL    V_TXFIFO_FULL(1U)

#define S_UNDERUNFIX    22
#define V_UNDERUNFIX(x) ((x) << S_UNDERUNFIX)
#define F_UNDERUNFIX    V_UNDERUNFIX(1U)

#define S_ENDROPPKT    21
#define V_ENDROPPKT(x) ((x) << S_ENDROPPKT)
#define F_ENDROPPKT    V_ENDROPPKT(1U)

#define S_TXIPG    13
#define M_TXIPG    0xff
#define V_TXIPG(x) ((x) << S_TXIPG)
#define G_TXIPG(x) (((x) >> S_TXIPG) & M_TXIPG)

#define S_TXFIFOTHRESH    4
#define M_TXFIFOTHRESH    0x1ff
#define V_TXFIFOTHRESH(x) ((x) << S_TXFIFOTHRESH)
#define G_TXFIFOTHRESH(x) (((x) >> S_TXFIFOTHRESH) & M_TXFIFOTHRESH)

#define S_INTERNLOOPBACK    3
#define V_INTERNLOOPBACK(x) ((x) << S_INTERNLOOPBACK)
#define F_INTERNLOOPBACK    V_INTERNLOOPBACK(1U)

#define S_TXBYTESWAP    2
#define V_TXBYTESWAP(x) ((x) << S_TXBYTESWAP)
#define F_TXBYTESWAP    V_TXBYTESWAP(1U)

#define S_DISCRC    1
#define V_DISCRC(x) ((x) << S_DISCRC)
#define F_DISCRC    V_DISCRC(1U)

#define S_DISPREAMBLE    0
#define V_DISPREAMBLE(x) ((x) << S_DISPREAMBLE)
#define F_DISPREAMBLE    V_DISPREAMBLE(1U)

#define A_XGM_SLOW_TIMER 0x88c

#define S_PAUSESLOWTIMEREN    31
#define V_PAUSESLOWTIMEREN(x) ((x) << S_PAUSESLOWTIMEREN)
#define F_PAUSESLOWTIMEREN    V_PAUSESLOWTIMEREN(1U)

#define S_PAUSESLOWTIMER    0
#define M_PAUSESLOWTIMER    0xfffff
#define V_PAUSESLOWTIMER(x) ((x) << S_PAUSESLOWTIMER)
#define G_PAUSESLOWTIMER(x) (((x) >> S_PAUSESLOWTIMER) & M_PAUSESLOWTIMER)

#define A_XGM_PAUSE_TIMER 0x890

#define S_PAUSETIMER    0
#define M_PAUSETIMER    0xfffff
#define V_PAUSETIMER(x) ((x) << S_PAUSETIMER)
#define G_PAUSETIMER(x) (((x) >> S_PAUSETIMER) & M_PAUSETIMER)

#define A_XGM_SERDES_CTRL 0x890

#define S_SERDESEN    25
#define V_SERDESEN(x) ((x) << S_SERDESEN)
#define F_SERDESEN    V_SERDESEN(1U)

#define S_SERDESRESET_    24
#define V_SERDESRESET_(x) ((x) << S_SERDESRESET_)
#define F_SERDESRESET_    V_SERDESRESET_(1U)

#define S_CMURANGE    21
#define M_CMURANGE    0x7
#define V_CMURANGE(x) ((x) << S_CMURANGE)
#define G_CMURANGE(x) (((x) >> S_CMURANGE) & M_CMURANGE)

#define S_BGENB    20
#define V_BGENB(x) ((x) << S_BGENB)
#define F_BGENB    V_BGENB(1U)

#define S_ENSKPDROP    19
#define V_ENSKPDROP(x) ((x) << S_ENSKPDROP)
#define F_ENSKPDROP    V_ENSKPDROP(1U)

#define S_ENCOMMA    18
#define V_ENCOMMA(x) ((x) << S_ENCOMMA)
#define F_ENCOMMA    V_ENCOMMA(1U)

#define S_EN8B10B    17
#define V_EN8B10B(x) ((x) << S_EN8B10B)
#define F_EN8B10B    V_EN8B10B(1U)

#define S_ENELBUF    16
#define V_ENELBUF(x) ((x) << S_ENELBUF)
#define F_ENELBUF    V_ENELBUF(1U)

#define S_GAIN    11
#define M_GAIN    0x1f
#define V_GAIN(x) ((x) << S_GAIN)
#define G_GAIN(x) (((x) >> S_GAIN) & M_GAIN)

#define S_BANDGAP    7
#define M_BANDGAP    0xf
#define V_BANDGAP(x) ((x) << S_BANDGAP)
#define G_BANDGAP(x) (((x) >> S_BANDGAP) & M_BANDGAP)

#define S_LPBKEN    5
#define M_LPBKEN    0x3
#define V_LPBKEN(x) ((x) << S_LPBKEN)
#define G_LPBKEN(x) (((x) >> S_LPBKEN) & M_LPBKEN)

#define S_RXENABLE    4
#define V_RXENABLE(x) ((x) << S_RXENABLE)
#define F_RXENABLE    V_RXENABLE(1U)

#define S_TXENABLE    3
#define V_TXENABLE(x) ((x) << S_TXENABLE)
#define F_TXENABLE    V_TXENABLE(1U)

#define A_XGM_XAUI_PCS_TEST 0x894

#define S_TESTPATTERN    1
#define M_TESTPATTERN    0x3
#define V_TESTPATTERN(x) ((x) << S_TESTPATTERN)
#define G_TESTPATTERN(x) (((x) >> S_TESTPATTERN) & M_TESTPATTERN)

#define S_ENTEST    0
#define V_ENTEST(x) ((x) << S_ENTEST)
#define F_ENTEST    V_ENTEST(1U)

#define A_XGM_RGMII_CTRL 0x898

#define S_PHALIGNFIFOTHRESH    1
#define M_PHALIGNFIFOTHRESH    0x3
#define V_PHALIGNFIFOTHRESH(x) ((x) << S_PHALIGNFIFOTHRESH)
#define G_PHALIGNFIFOTHRESH(x) (((x) >> S_PHALIGNFIFOTHRESH) & M_PHALIGNFIFOTHRESH)

#define S_TXCLK90SHIFT    0
#define V_TXCLK90SHIFT(x) ((x) << S_TXCLK90SHIFT)
#define F_TXCLK90SHIFT    V_TXCLK90SHIFT(1U)

#define A_XGM_RGMII_IMP 0x89c

#define S_CALRESET    8
#define V_CALRESET(x) ((x) << S_CALRESET)
#define F_CALRESET    V_CALRESET(1U)

#define S_CALUPDATE    7
#define V_CALUPDATE(x) ((x) << S_CALUPDATE)
#define F_CALUPDATE    V_CALUPDATE(1U)

#define S_XGM_IMPSETUPDATE    6
#define V_XGM_IMPSETUPDATE(x) ((x) << S_XGM_IMPSETUPDATE)
#define F_XGM_IMPSETUPDATE    V_XGM_IMPSETUPDATE(1U)

#define S_RGMIIIMPPD    3
#define M_RGMIIIMPPD    0x7
#define V_RGMIIIMPPD(x) ((x) << S_RGMIIIMPPD)
#define G_RGMIIIMPPD(x) (((x) >> S_RGMIIIMPPD) & M_RGMIIIMPPD)

#define S_RGMIIIMPPU    0
#define M_RGMIIIMPPU    0x7
#define V_RGMIIIMPPU(x) ((x) << S_RGMIIIMPPU)
#define G_RGMIIIMPPU(x) (((x) >> S_RGMIIIMPPU) & M_RGMIIIMPPU)

#define A_XGM_XAUI_IMP 0x8a0

#define S_XGM_CALFAULT    29
#define V_XGM_CALFAULT(x) ((x) << S_XGM_CALFAULT)
#define F_XGM_CALFAULT    V_XGM_CALFAULT(1U)

#define S_CALIMP    24
#define M_CALIMP    0x1f
#define V_CALIMP(x) ((x) << S_CALIMP)
#define G_CALIMP(x) (((x) >> S_CALIMP) & M_CALIMP)

#define S_XAUIIMP    0
#define M_XAUIIMP    0x7
#define V_XAUIIMP(x) ((x) << S_XAUIIMP)
#define G_XAUIIMP(x) (((x) >> S_XAUIIMP) & M_XAUIIMP)

#define A_XGM_SERDES_BIST 0x8a4

#define S_BISTDONE    28
#define M_BISTDONE    0xf
#define V_BISTDONE(x) ((x) << S_BISTDONE)
#define G_BISTDONE(x) (((x) >> S_BISTDONE) & M_BISTDONE)

#define S_BISTCYCLETHRESH    3
#define M_BISTCYCLETHRESH    0x1ffff
#define V_BISTCYCLETHRESH(x) ((x) << S_BISTCYCLETHRESH)
#define G_BISTCYCLETHRESH(x) (((x) >> S_BISTCYCLETHRESH) & M_BISTCYCLETHRESH)

#define A_XGM_RX_MAX_PKT_SIZE 0x8a8

#define S_RXMAXFRAMERSIZE    17
#define M_RXMAXFRAMERSIZE    0x3fff
#define V_RXMAXFRAMERSIZE(x) ((x) << S_RXMAXFRAMERSIZE)
#define G_RXMAXFRAMERSIZE(x) (((x) >> S_RXMAXFRAMERSIZE) & M_RXMAXFRAMERSIZE)

#define S_RXENERRORGATHER    16
#define V_RXENERRORGATHER(x) ((x) << S_RXENERRORGATHER)
#define F_RXENERRORGATHER    V_RXENERRORGATHER(1U)

#define S_RXENSINGLEFLIT    15
#define V_RXENSINGLEFLIT(x) ((x) << S_RXENSINGLEFLIT)
#define F_RXENSINGLEFLIT    V_RXENSINGLEFLIT(1U)

#define S_RXENFRAMER    14
#define V_RXENFRAMER(x) ((x) << S_RXENFRAMER)
#define F_RXENFRAMER    V_RXENFRAMER(1U)

#define S_RXMAXPKTSIZE    0
#define M_RXMAXPKTSIZE    0x3fff
#define V_RXMAXPKTSIZE(x) ((x) << S_RXMAXPKTSIZE)
#define G_RXMAXPKTSIZE(x) (((x) >> S_RXMAXPKTSIZE) & M_RXMAXPKTSIZE)

#define A_XGM_RESET_CTRL 0x8ac

#define S_XGMAC_STOP_EN    4
#define V_XGMAC_STOP_EN(x) ((x) << S_XGMAC_STOP_EN)
#define F_XGMAC_STOP_EN    V_XGMAC_STOP_EN(1U)

#define S_XG2G_RESET_    3
#define V_XG2G_RESET_(x) ((x) << S_XG2G_RESET_)
#define F_XG2G_RESET_    V_XG2G_RESET_(1U)

#define S_RGMII_RESET_    2
#define V_RGMII_RESET_(x) ((x) << S_RGMII_RESET_)
#define F_RGMII_RESET_    V_RGMII_RESET_(1U)

#define S_PCS_RESET_    1
#define V_PCS_RESET_(x) ((x) << S_PCS_RESET_)
#define F_PCS_RESET_    V_PCS_RESET_(1U)

#define S_MAC_RESET_    0
#define V_MAC_RESET_(x) ((x) << S_MAC_RESET_)
#define F_MAC_RESET_    V_MAC_RESET_(1U)

#define A_XGM_XAUI1G_CTRL 0x8b0

#define S_XAUI1GLINKID    0
#define M_XAUI1GLINKID    0x3
#define V_XAUI1GLINKID(x) ((x) << S_XAUI1GLINKID)
#define G_XAUI1GLINKID(x) (((x) >> S_XAUI1GLINKID) & M_XAUI1GLINKID)

#define A_XGM_SERDES_LANE_CTRL 0x8b4

#define S_LANEREVERSAL    8
#define V_LANEREVERSAL(x) ((x) << S_LANEREVERSAL)
#define F_LANEREVERSAL    V_LANEREVERSAL(1U)

#define S_TXPOLARITY    4
#define M_TXPOLARITY    0xf
#define V_TXPOLARITY(x) ((x) << S_TXPOLARITY)
#define G_TXPOLARITY(x) (((x) >> S_TXPOLARITY) & M_TXPOLARITY)

#define S_RXPOLARITY    0
#define M_RXPOLARITY    0xf
#define V_RXPOLARITY(x) ((x) << S_RXPOLARITY)
#define G_RXPOLARITY(x) (((x) >> S_RXPOLARITY) & M_RXPOLARITY)

#define A_XGM_PORT_CFG 0x8b8

#define S_SAFESPEEDCHANGE    4
#define V_SAFESPEEDCHANGE(x) ((x) << S_SAFESPEEDCHANGE)
#define F_SAFESPEEDCHANGE    V_SAFESPEEDCHANGE(1U)

#define S_CLKDIVRESET_    3
#define V_CLKDIVRESET_(x) ((x) << S_CLKDIVRESET_)
#define F_CLKDIVRESET_    V_CLKDIVRESET_(1U)

#define S_PORTSPEED    1
#define M_PORTSPEED    0x3
#define V_PORTSPEED(x) ((x) << S_PORTSPEED)
#define G_PORTSPEED(x) (((x) >> S_PORTSPEED) & M_PORTSPEED)

#define S_ENRGMII    0
#define V_ENRGMII(x) ((x) << S_ENRGMII)
#define F_ENRGMII    V_ENRGMII(1U)

#define A_XGM_EPIO_DATA0 0x8c0
#define A_XGM_EPIO_DATA1 0x8c4
#define A_XGM_EPIO_DATA2 0x8c8
#define A_XGM_EPIO_DATA3 0x8cc
#define A_XGM_EPIO_OP 0x8d0

#define S_PIO_READY    31
#define V_PIO_READY(x) ((x) << S_PIO_READY)
#define F_PIO_READY    V_PIO_READY(1U)

#define S_PIO_WRRD    24
#define V_PIO_WRRD(x) ((x) << S_PIO_WRRD)
#define F_PIO_WRRD    V_PIO_WRRD(1U)

#define S_PIO_ADDRESS    0
#define M_PIO_ADDRESS    0xff
#define V_PIO_ADDRESS(x) ((x) << S_PIO_ADDRESS)
#define G_PIO_ADDRESS(x) (((x) >> S_PIO_ADDRESS) & M_PIO_ADDRESS)

#define A_XGM_INT_ENABLE 0x8d4

#define S_XAUIPCSDECERR    24
#define V_XAUIPCSDECERR(x) ((x) << S_XAUIPCSDECERR)
#define F_XAUIPCSDECERR    V_XAUIPCSDECERR(1U)

#define S_RGMIIRXFIFOOVERFLOW    23
#define V_RGMIIRXFIFOOVERFLOW(x) ((x) << S_RGMIIRXFIFOOVERFLOW)
#define F_RGMIIRXFIFOOVERFLOW    V_RGMIIRXFIFOOVERFLOW(1U)

#define S_RGMIIRXFIFOUNDERFLOW    22
#define V_RGMIIRXFIFOUNDERFLOW(x) ((x) << S_RGMIIRXFIFOUNDERFLOW)
#define F_RGMIIRXFIFOUNDERFLOW    V_RGMIIRXFIFOUNDERFLOW(1U)

#define S_RXPKTSIZEERROR    21
#define V_RXPKTSIZEERROR(x) ((x) << S_RXPKTSIZEERROR)
#define F_RXPKTSIZEERROR    V_RXPKTSIZEERROR(1U)

#define S_WOLPATDETECTED    20
#define V_WOLPATDETECTED(x) ((x) << S_WOLPATDETECTED)
#define F_WOLPATDETECTED    V_WOLPATDETECTED(1U)

#define S_TXFIFO_PRTY_ERR    17
#define M_TXFIFO_PRTY_ERR    0x7
#define V_TXFIFO_PRTY_ERR(x) ((x) << S_TXFIFO_PRTY_ERR)
#define G_TXFIFO_PRTY_ERR(x) (((x) >> S_TXFIFO_PRTY_ERR) & M_TXFIFO_PRTY_ERR)

#define S_RXFIFO_PRTY_ERR    14
#define M_RXFIFO_PRTY_ERR    0x7
#define V_RXFIFO_PRTY_ERR(x) ((x) << S_RXFIFO_PRTY_ERR)
#define G_RXFIFO_PRTY_ERR(x) (((x) >> S_RXFIFO_PRTY_ERR) & M_RXFIFO_PRTY_ERR)

#define S_TXFIFO_UNDERRUN    13
#define V_TXFIFO_UNDERRUN(x) ((x) << S_TXFIFO_UNDERRUN)
#define F_TXFIFO_UNDERRUN    V_TXFIFO_UNDERRUN(1U)

#define S_RXFIFO_OVERFLOW    12
#define V_RXFIFO_OVERFLOW(x) ((x) << S_RXFIFO_OVERFLOW)
#define F_RXFIFO_OVERFLOW    V_RXFIFO_OVERFLOW(1U)

#define S_SERDESBISTERR    8
#define M_SERDESBISTERR    0xf
#define V_SERDESBISTERR(x) ((x) << S_SERDESBISTERR)
#define G_SERDESBISTERR(x) (((x) >> S_SERDESBISTERR) & M_SERDESBISTERR)

#define S_SERDESLOWSIGCHANGE    4
#define M_SERDESLOWSIGCHANGE    0xf
#define V_SERDESLOWSIGCHANGE(x) ((x) << S_SERDESLOWSIGCHANGE)
#define G_SERDESLOWSIGCHANGE(x) (((x) >> S_SERDESLOWSIGCHANGE) & M_SERDESLOWSIGCHANGE)

#define S_XAUIPCSCTCERR    3
#define V_XAUIPCSCTCERR(x) ((x) << S_XAUIPCSCTCERR)
#define F_XAUIPCSCTCERR    V_XAUIPCSCTCERR(1U)

#define S_XAUIPCSALIGNCHANGE    2
#define V_XAUIPCSALIGNCHANGE(x) ((x) << S_XAUIPCSALIGNCHANGE)
#define F_XAUIPCSALIGNCHANGE    V_XAUIPCSALIGNCHANGE(1U)

#define S_RGMIILINKSTSCHANGE    1
#define V_RGMIILINKSTSCHANGE(x) ((x) << S_RGMIILINKSTSCHANGE)
#define F_RGMIILINKSTSCHANGE    V_RGMIILINKSTSCHANGE(1U)

#define S_XGM_INT    0
#define V_XGM_INT(x) ((x) << S_XGM_INT)
#define F_XGM_INT    V_XGM_INT(1U)

#define S_SERDESCMULOCK_LOSS    24
#define V_SERDESCMULOCK_LOSS(x) ((x) << S_SERDESCMULOCK_LOSS)
#define F_SERDESCMULOCK_LOSS    V_SERDESCMULOCK_LOSS(1U)

#define S_SERDESBIST_ERR    8
#define M_SERDESBIST_ERR    0xf
#define V_SERDESBIST_ERR(x) ((x) << S_SERDESBIST_ERR)
#define G_SERDESBIST_ERR(x) (((x) >> S_SERDESBIST_ERR) & M_SERDESBIST_ERR)

#define S_SERDES_LOS    4
#define M_SERDES_LOS    0xf
#define V_SERDES_LOS(x) ((x) << S_SERDES_LOS)
#define G_SERDES_LOS(x) (((x) >> S_SERDES_LOS) & M_SERDES_LOS)

#define A_XGM_INT_CAUSE 0x8d8
#define A_XGM_XAUI_ACT_CTRL 0x8dc

#define S_TXACTENABLE    1
#define V_TXACTENABLE(x) ((x) << S_TXACTENABLE)
#define F_TXACTENABLE    V_TXACTENABLE(1U)

#define A_XGM_SERDES_CTRL0 0x8e0

#define S_INTSERLPBK3    27
#define V_INTSERLPBK3(x) ((x) << S_INTSERLPBK3)
#define F_INTSERLPBK3    V_INTSERLPBK3(1U)

#define S_INTSERLPBK2    26
#define V_INTSERLPBK2(x) ((x) << S_INTSERLPBK2)
#define F_INTSERLPBK2    V_INTSERLPBK2(1U)

#define S_INTSERLPBK1    25
#define V_INTSERLPBK1(x) ((x) << S_INTSERLPBK1)
#define F_INTSERLPBK1    V_INTSERLPBK1(1U)

#define S_INTSERLPBK0    24
#define V_INTSERLPBK0(x) ((x) << S_INTSERLPBK0)
#define F_INTSERLPBK0    V_INTSERLPBK0(1U)

#define S_RESET3    23
#define V_RESET3(x) ((x) << S_RESET3)
#define F_RESET3    V_RESET3(1U)

#define S_RESET2    22
#define V_RESET2(x) ((x) << S_RESET2)
#define F_RESET2    V_RESET2(1U)

#define S_RESET1    21
#define V_RESET1(x) ((x) << S_RESET1)
#define F_RESET1    V_RESET1(1U)

#define S_RESET0    20
#define V_RESET0(x) ((x) << S_RESET0)
#define F_RESET0    V_RESET0(1U)

#define S_PWRDN3    19
#define V_PWRDN3(x) ((x) << S_PWRDN3)
#define F_PWRDN3    V_PWRDN3(1U)

#define S_PWRDN2    18
#define V_PWRDN2(x) ((x) << S_PWRDN2)
#define F_PWRDN2    V_PWRDN2(1U)

#define S_PWRDN1    17
#define V_PWRDN1(x) ((x) << S_PWRDN1)
#define F_PWRDN1    V_PWRDN1(1U)

#define S_PWRDN0    16
#define V_PWRDN0(x) ((x) << S_PWRDN0)
#define F_PWRDN0    V_PWRDN0(1U)

#define S_RESETPLL23    15
#define V_RESETPLL23(x) ((x) << S_RESETPLL23)
#define F_RESETPLL23    V_RESETPLL23(1U)

#define S_RESETPLL01    14
#define V_RESETPLL01(x) ((x) << S_RESETPLL01)
#define F_RESETPLL01    V_RESETPLL01(1U)

#define S_PW23    12
#define M_PW23    0x3
#define V_PW23(x) ((x) << S_PW23)
#define G_PW23(x) (((x) >> S_PW23) & M_PW23)

#define S_PW01    10
#define M_PW01    0x3
#define V_PW01(x) ((x) << S_PW01)
#define G_PW01(x) (((x) >> S_PW01) & M_PW01)

#define S_XGM_DEQ    6
#define M_XGM_DEQ    0xf
#define V_XGM_DEQ(x) ((x) << S_XGM_DEQ)
#define G_XGM_DEQ(x) (((x) >> S_XGM_DEQ) & M_XGM_DEQ)

#define S_XGM_DTX    2
#define M_XGM_DTX    0xf
#define V_XGM_DTX(x) ((x) << S_XGM_DTX)
#define G_XGM_DTX(x) (((x) >> S_XGM_DTX) & M_XGM_DTX)

#define S_XGM_LODRV    1
#define V_XGM_LODRV(x) ((x) << S_XGM_LODRV)
#define F_XGM_LODRV    V_XGM_LODRV(1U)

#define S_XGM_HIDRV    0
#define V_XGM_HIDRV(x) ((x) << S_XGM_HIDRV)
#define F_XGM_HIDRV    V_XGM_HIDRV(1U)

#define A_XGM_SERDES_CTRL1 0x8e4

#define S_FMOFFSET3    19
#define M_FMOFFSET3    0x1f
#define V_FMOFFSET3(x) ((x) << S_FMOFFSET3)
#define G_FMOFFSET3(x) (((x) >> S_FMOFFSET3) & M_FMOFFSET3)

#define S_FMOFFSETEN3    18
#define V_FMOFFSETEN3(x) ((x) << S_FMOFFSETEN3)
#define F_FMOFFSETEN3    V_FMOFFSETEN3(1U)

#define S_FMOFFSET2    13
#define M_FMOFFSET2    0x1f
#define V_FMOFFSET2(x) ((x) << S_FMOFFSET2)
#define G_FMOFFSET2(x) (((x) >> S_FMOFFSET2) & M_FMOFFSET2)

#define S_FMOFFSETEN2    12
#define V_FMOFFSETEN2(x) ((x) << S_FMOFFSETEN2)
#define F_FMOFFSETEN2    V_FMOFFSETEN2(1U)

#define S_FMOFFSET1    7
#define M_FMOFFSET1    0x1f
#define V_FMOFFSET1(x) ((x) << S_FMOFFSET1)
#define G_FMOFFSET1(x) (((x) >> S_FMOFFSET1) & M_FMOFFSET1)

#define S_FMOFFSETEN1    6
#define V_FMOFFSETEN1(x) ((x) << S_FMOFFSETEN1)
#define F_FMOFFSETEN1    V_FMOFFSETEN1(1U)

#define S_FMOFFSET0    1
#define M_FMOFFSET0    0x1f
#define V_FMOFFSET0(x) ((x) << S_FMOFFSET0)
#define G_FMOFFSET0(x) (((x) >> S_FMOFFSET0) & M_FMOFFSET0)

#define S_FMOFFSETEN0    0
#define V_FMOFFSETEN0(x) ((x) << S_FMOFFSETEN0)
#define F_FMOFFSETEN0    V_FMOFFSETEN0(1U)

#define A_XGM_SERDES_CTRL2 0x8e8

#define S_DNIN3    11
#define V_DNIN3(x) ((x) << S_DNIN3)
#define F_DNIN3    V_DNIN3(1U)

#define S_UPIN3    10
#define V_UPIN3(x) ((x) << S_UPIN3)
#define F_UPIN3    V_UPIN3(1U)

#define S_RXSLAVE3    9
#define V_RXSLAVE3(x) ((x) << S_RXSLAVE3)
#define F_RXSLAVE3    V_RXSLAVE3(1U)

#define S_DNIN2    8
#define V_DNIN2(x) ((x) << S_DNIN2)
#define F_DNIN2    V_DNIN2(1U)

#define S_UPIN2    7
#define V_UPIN2(x) ((x) << S_UPIN2)
#define F_UPIN2    V_UPIN2(1U)

#define S_RXSLAVE2    6
#define V_RXSLAVE2(x) ((x) << S_RXSLAVE2)
#define F_RXSLAVE2    V_RXSLAVE2(1U)

#define S_DNIN1    5
#define V_DNIN1(x) ((x) << S_DNIN1)
#define F_DNIN1    V_DNIN1(1U)

#define S_UPIN1    4
#define V_UPIN1(x) ((x) << S_UPIN1)
#define F_UPIN1    V_UPIN1(1U)

#define S_RXSLAVE1    3
#define V_RXSLAVE1(x) ((x) << S_RXSLAVE1)
#define F_RXSLAVE1    V_RXSLAVE1(1U)

#define S_DNIN0    2
#define V_DNIN0(x) ((x) << S_DNIN0)
#define F_DNIN0    V_DNIN0(1U)

#define S_UPIN0    1
#define V_UPIN0(x) ((x) << S_UPIN0)
#define F_UPIN0    V_UPIN0(1U)

#define S_RXSLAVE0    0
#define V_RXSLAVE0(x) ((x) << S_RXSLAVE0)
#define F_RXSLAVE0    V_RXSLAVE0(1U)

#define A_XGM_SERDES_CTRL3 0x8ec

#define S_EXTBISTCHKERRCLR3    31
#define V_EXTBISTCHKERRCLR3(x) ((x) << S_EXTBISTCHKERRCLR3)
#define F_EXTBISTCHKERRCLR3    V_EXTBISTCHKERRCLR3(1U)

#define S_EXTBISTCHKEN3    30
#define V_EXTBISTCHKEN3(x) ((x) << S_EXTBISTCHKEN3)
#define F_EXTBISTCHKEN3    V_EXTBISTCHKEN3(1U)

#define S_EXTBISTGENEN3    29
#define V_EXTBISTGENEN3(x) ((x) << S_EXTBISTGENEN3)
#define F_EXTBISTGENEN3    V_EXTBISTGENEN3(1U)

#define S_EXTBISTPAT3    26
#define M_EXTBISTPAT3    0x7
#define V_EXTBISTPAT3(x) ((x) << S_EXTBISTPAT3)
#define G_EXTBISTPAT3(x) (((x) >> S_EXTBISTPAT3) & M_EXTBISTPAT3)

#define S_EXTPARRESET3    25
#define V_EXTPARRESET3(x) ((x) << S_EXTPARRESET3)
#define F_EXTPARRESET3    V_EXTPARRESET3(1U)

#define S_EXTPARLPBK3    24
#define V_EXTPARLPBK3(x) ((x) << S_EXTPARLPBK3)
#define F_EXTPARLPBK3    V_EXTPARLPBK3(1U)

#define S_EXTBISTCHKERRCLR2    23
#define V_EXTBISTCHKERRCLR2(x) ((x) << S_EXTBISTCHKERRCLR2)
#define F_EXTBISTCHKERRCLR2    V_EXTBISTCHKERRCLR2(1U)

#define S_EXTBISTCHKEN2    22
#define V_EXTBISTCHKEN2(x) ((x) << S_EXTBISTCHKEN2)
#define F_EXTBISTCHKEN2    V_EXTBISTCHKEN2(1U)

#define S_EXTBISTGENEN2    21
#define V_EXTBISTGENEN2(x) ((x) << S_EXTBISTGENEN2)
#define F_EXTBISTGENEN2    V_EXTBISTGENEN2(1U)

#define S_EXTBISTPAT2    18
#define M_EXTBISTPAT2    0x7
#define V_EXTBISTPAT2(x) ((x) << S_EXTBISTPAT2)
#define G_EXTBISTPAT2(x) (((x) >> S_EXTBISTPAT2) & M_EXTBISTPAT2)

#define S_EXTPARRESET2    17
#define V_EXTPARRESET2(x) ((x) << S_EXTPARRESET2)
#define F_EXTPARRESET2    V_EXTPARRESET2(1U)

#define S_EXTPARLPBK2    16
#define V_EXTPARLPBK2(x) ((x) << S_EXTPARLPBK2)
#define F_EXTPARLPBK2    V_EXTPARLPBK2(1U)

#define S_EXTBISTCHKERRCLR1    15
#define V_EXTBISTCHKERRCLR1(x) ((x) << S_EXTBISTCHKERRCLR1)
#define F_EXTBISTCHKERRCLR1    V_EXTBISTCHKERRCLR1(1U)

#define S_EXTBISTCHKEN1    14
#define V_EXTBISTCHKEN1(x) ((x) << S_EXTBISTCHKEN1)
#define F_EXTBISTCHKEN1    V_EXTBISTCHKEN1(1U)

#define S_EXTBISTGENEN1    13
#define V_EXTBISTGENEN1(x) ((x) << S_EXTBISTGENEN1)
#define F_EXTBISTGENEN1    V_EXTBISTGENEN1(1U)

#define S_EXTBISTPAT1    10
#define M_EXTBISTPAT1    0x7
#define V_EXTBISTPAT1(x) ((x) << S_EXTBISTPAT1)
#define G_EXTBISTPAT1(x) (((x) >> S_EXTBISTPAT1) & M_EXTBISTPAT1)

#define S_EXTPARRESET1    9
#define V_EXTPARRESET1(x) ((x) << S_EXTPARRESET1)
#define F_EXTPARRESET1    V_EXTPARRESET1(1U)

#define S_EXTPARLPBK1    8
#define V_EXTPARLPBK1(x) ((x) << S_EXTPARLPBK1)
#define F_EXTPARLPBK1    V_EXTPARLPBK1(1U)

#define S_EXTBISTCHKERRCLR0    7
#define V_EXTBISTCHKERRCLR0(x) ((x) << S_EXTBISTCHKERRCLR0)
#define F_EXTBISTCHKERRCLR0    V_EXTBISTCHKERRCLR0(1U)

#define S_EXTBISTCHKEN0    6
#define V_EXTBISTCHKEN0(x) ((x) << S_EXTBISTCHKEN0)
#define F_EXTBISTCHKEN0    V_EXTBISTCHKEN0(1U)

#define S_EXTBISTGENEN0    5
#define V_EXTBISTGENEN0(x) ((x) << S_EXTBISTGENEN0)
#define F_EXTBISTGENEN0    V_EXTBISTGENEN0(1U)

#define S_EXTBISTPAT0    2
#define M_EXTBISTPAT0    0x7
#define V_EXTBISTPAT0(x) ((x) << S_EXTBISTPAT0)
#define G_EXTBISTPAT0(x) (((x) >> S_EXTBISTPAT0) & M_EXTBISTPAT0)

#define S_EXTPARRESET0    1
#define V_EXTPARRESET0(x) ((x) << S_EXTPARRESET0)
#define F_EXTPARRESET0    V_EXTPARRESET0(1U)

#define S_EXTPARLPBK0    0
#define V_EXTPARLPBK0(x) ((x) << S_EXTPARLPBK0)
#define F_EXTPARLPBK0    V_EXTPARLPBK0(1U)

#define A_XGM_SERDES_STAT0 0x8f0

#define S_EXTBISTCHKERRCNT0    4
#define M_EXTBISTCHKERRCNT0    0xffffff
#define V_EXTBISTCHKERRCNT0(x) ((x) << S_EXTBISTCHKERRCNT0)
#define G_EXTBISTCHKERRCNT0(x) (((x) >> S_EXTBISTCHKERRCNT0) & M_EXTBISTCHKERRCNT0)

#define S_EXTBISTCHKFMD0    3
#define V_EXTBISTCHKFMD0(x) ((x) << S_EXTBISTCHKFMD0)
#define F_EXTBISTCHKFMD0    V_EXTBISTCHKFMD0(1U)

#define S_LOWSIGFORCEEN0    2
#define V_LOWSIGFORCEEN0(x) ((x) << S_LOWSIGFORCEEN0)
#define F_LOWSIGFORCEEN0    V_LOWSIGFORCEEN0(1U)

#define S_LOWSIGFORCEVALUE0    1
#define V_LOWSIGFORCEVALUE0(x) ((x) << S_LOWSIGFORCEVALUE0)
#define F_LOWSIGFORCEVALUE0    V_LOWSIGFORCEVALUE0(1U)

#define S_LOWSIG0    0
#define V_LOWSIG0(x) ((x) << S_LOWSIG0)
#define F_LOWSIG0    V_LOWSIG0(1U)

#define A_XGM_SERDES_STAT1 0x8f4

#define S_EXTBISTCHKERRCNT1    4
#define M_EXTBISTCHKERRCNT1    0xffffff
#define V_EXTBISTCHKERRCNT1(x) ((x) << S_EXTBISTCHKERRCNT1)
#define G_EXTBISTCHKERRCNT1(x) (((x) >> S_EXTBISTCHKERRCNT1) & M_EXTBISTCHKERRCNT1)

#define S_EXTBISTCHKFMD1    3
#define V_EXTBISTCHKFMD1(x) ((x) << S_EXTBISTCHKFMD1)
#define F_EXTBISTCHKFMD1    V_EXTBISTCHKFMD1(1U)

#define S_LOWSIGFORCEEN1    2
#define V_LOWSIGFORCEEN1(x) ((x) << S_LOWSIGFORCEEN1)
#define F_LOWSIGFORCEEN1    V_LOWSIGFORCEEN1(1U)

#define S_LOWSIGFORCEVALUE1    1
#define V_LOWSIGFORCEVALUE1(x) ((x) << S_LOWSIGFORCEVALUE1)
#define F_LOWSIGFORCEVALUE1    V_LOWSIGFORCEVALUE1(1U)

#define S_LOWSIG1    0
#define V_LOWSIG1(x) ((x) << S_LOWSIG1)
#define F_LOWSIG1    V_LOWSIG1(1U)

#define A_XGM_SERDES_STAT2 0x8f8

#define S_EXTBISTCHKERRCNT2    4
#define M_EXTBISTCHKERRCNT2    0xffffff
#define V_EXTBISTCHKERRCNT2(x) ((x) << S_EXTBISTCHKERRCNT2)
#define G_EXTBISTCHKERRCNT2(x) (((x) >> S_EXTBISTCHKERRCNT2) & M_EXTBISTCHKERRCNT2)

#define S_EXTBISTCHKFMD2    3
#define V_EXTBISTCHKFMD2(x) ((x) << S_EXTBISTCHKFMD2)
#define F_EXTBISTCHKFMD2    V_EXTBISTCHKFMD2(1U)

#define S_LOWSIGFORCEEN2    2
#define V_LOWSIGFORCEEN2(x) ((x) << S_LOWSIGFORCEEN2)
#define F_LOWSIGFORCEEN2    V_LOWSIGFORCEEN2(1U)

#define S_LOWSIGFORCEVALUE2    1
#define V_LOWSIGFORCEVALUE2(x) ((x) << S_LOWSIGFORCEVALUE2)
#define F_LOWSIGFORCEVALUE2    V_LOWSIGFORCEVALUE2(1U)

#define S_LOWSIG2    0
#define V_LOWSIG2(x) ((x) << S_LOWSIG2)
#define F_LOWSIG2    V_LOWSIG2(1U)

#define A_XGM_SERDES_STAT3 0x8fc

#define S_EXTBISTCHKERRCNT3    4
#define M_EXTBISTCHKERRCNT3    0xffffff
#define V_EXTBISTCHKERRCNT3(x) ((x) << S_EXTBISTCHKERRCNT3)
#define G_EXTBISTCHKERRCNT3(x) (((x) >> S_EXTBISTCHKERRCNT3) & M_EXTBISTCHKERRCNT3)

#define S_EXTBISTCHKFMD3    3
#define V_EXTBISTCHKFMD3(x) ((x) << S_EXTBISTCHKFMD3)
#define F_EXTBISTCHKFMD3    V_EXTBISTCHKFMD3(1U)

#define S_LOWSIGFORCEEN3    2
#define V_LOWSIGFORCEEN3(x) ((x) << S_LOWSIGFORCEEN3)
#define F_LOWSIGFORCEEN3    V_LOWSIGFORCEEN3(1U)

#define S_LOWSIGFORCEVALUE3    1
#define V_LOWSIGFORCEVALUE3(x) ((x) << S_LOWSIGFORCEVALUE3)
#define F_LOWSIGFORCEVALUE3    V_LOWSIGFORCEVALUE3(1U)

#define S_LOWSIG3    0
#define V_LOWSIG3(x) ((x) << S_LOWSIG3)
#define F_LOWSIG3    V_LOWSIG3(1U)

#define A_XGM_STAT_TX_BYTE_LOW 0x900
#define A_XGM_STAT_TX_BYTE_HIGH 0x904

#define S_TXBYTES_HIGH    0
#define M_TXBYTES_HIGH    0x1fff
#define V_TXBYTES_HIGH(x) ((x) << S_TXBYTES_HIGH)
#define G_TXBYTES_HIGH(x) (((x) >> S_TXBYTES_HIGH) & M_TXBYTES_HIGH)

#define A_XGM_STAT_TX_FRAME_LOW 0x908
#define A_XGM_STAT_TX_FRAME_HIGH 0x90c

#define S_TXFRAMES_HIGH    0
#define M_TXFRAMES_HIGH    0xf
#define V_TXFRAMES_HIGH(x) ((x) << S_TXFRAMES_HIGH)
#define G_TXFRAMES_HIGH(x) (((x) >> S_TXFRAMES_HIGH) & M_TXFRAMES_HIGH)

#define A_XGM_STAT_TX_BCAST 0x910
#define A_XGM_STAT_TX_MCAST 0x914
#define A_XGM_STAT_TX_PAUSE 0x918
#define A_XGM_STAT_TX_64B_FRAMES 0x91c
#define A_XGM_STAT_TX_65_127B_FRAMES 0x920
#define A_XGM_STAT_TX_128_255B_FRAMES 0x924
#define A_XGM_STAT_TX_256_511B_FRAMES 0x928
#define A_XGM_STAT_TX_512_1023B_FRAMES 0x92c
#define A_XGM_STAT_TX_1024_1518B_FRAMES 0x930
#define A_XGM_STAT_TX_1519_MAXB_FRAMES 0x934
#define A_XGM_STAT_TX_ERR_FRAMES 0x938
#define A_XGM_STAT_RX_BYTES_LOW 0x93c
#define A_XGM_STAT_RX_BYTES_HIGH 0x940

#define S_RXBYTES_HIGH    0
#define M_RXBYTES_HIGH    0x1fff
#define V_RXBYTES_HIGH(x) ((x) << S_RXBYTES_HIGH)
#define G_RXBYTES_HIGH(x) (((x) >> S_RXBYTES_HIGH) & M_RXBYTES_HIGH)

#define A_XGM_STAT_RX_FRAMES_LOW 0x944
#define A_XGM_STAT_RX_FRAMES_HIGH 0x948

#define S_RXFRAMES_HIGH    0
#define M_RXFRAMES_HIGH    0xf
#define V_RXFRAMES_HIGH(x) ((x) << S_RXFRAMES_HIGH)
#define G_RXFRAMES_HIGH(x) (((x) >> S_RXFRAMES_HIGH) & M_RXFRAMES_HIGH)

#define A_XGM_STAT_RX_BCAST_FRAMES 0x94c
#define A_XGM_STAT_RX_MCAST_FRAMES 0x950
#define A_XGM_STAT_RX_PAUSE_FRAMES 0x954

#define S_RXPAUSEFRAMES    0
#define M_RXPAUSEFRAMES    0xffff
#define V_RXPAUSEFRAMES(x) ((x) << S_RXPAUSEFRAMES)
#define G_RXPAUSEFRAMES(x) (((x) >> S_RXPAUSEFRAMES) & M_RXPAUSEFRAMES)

#define A_XGM_STAT_RX_64B_FRAMES 0x958
#define A_XGM_STAT_RX_65_127B_FRAMES 0x95c
#define A_XGM_STAT_RX_128_255B_FRAMES 0x960
#define A_XGM_STAT_RX_256_511B_FRAMES 0x964
#define A_XGM_STAT_RX_512_1023B_FRAMES 0x968
#define A_XGM_STAT_RX_1024_1518B_FRAMES 0x96c
#define A_XGM_STAT_RX_1519_MAXB_FRAMES 0x970
#define A_XGM_STAT_RX_SHORT_FRAMES 0x974

#define S_RXSHORTFRAMES    0
#define M_RXSHORTFRAMES    0xffff
#define V_RXSHORTFRAMES(x) ((x) << S_RXSHORTFRAMES)
#define G_RXSHORTFRAMES(x) (((x) >> S_RXSHORTFRAMES) & M_RXSHORTFRAMES)

#define A_XGM_STAT_RX_OVERSIZE_FRAMES 0x978

#define S_RXOVERSIZEFRAMES    0
#define M_RXOVERSIZEFRAMES    0xffff
#define V_RXOVERSIZEFRAMES(x) ((x) << S_RXOVERSIZEFRAMES)
#define G_RXOVERSIZEFRAMES(x) (((x) >> S_RXOVERSIZEFRAMES) & M_RXOVERSIZEFRAMES)

#define A_XGM_STAT_RX_JABBER_FRAMES 0x97c

#define S_RXJABBERFRAMES    0
#define M_RXJABBERFRAMES    0xffff
#define V_RXJABBERFRAMES(x) ((x) << S_RXJABBERFRAMES)
#define G_RXJABBERFRAMES(x) (((x) >> S_RXJABBERFRAMES) & M_RXJABBERFRAMES)

#define A_XGM_STAT_RX_CRC_ERR_FRAMES 0x980

#define S_RXCRCERRFRAMES    0
#define M_RXCRCERRFRAMES    0xffff
#define V_RXCRCERRFRAMES(x) ((x) << S_RXCRCERRFRAMES)
#define G_RXCRCERRFRAMES(x) (((x) >> S_RXCRCERRFRAMES) & M_RXCRCERRFRAMES)

#define A_XGM_STAT_RX_LENGTH_ERR_FRAMES 0x984

#define S_RXLENGTHERRFRAMES    0
#define M_RXLENGTHERRFRAMES    0xffff
#define V_RXLENGTHERRFRAMES(x) ((x) << S_RXLENGTHERRFRAMES)
#define G_RXLENGTHERRFRAMES(x) (((x) >> S_RXLENGTHERRFRAMES) & M_RXLENGTHERRFRAMES)

#define A_XGM_STAT_RX_SYM_CODE_ERR_FRAMES 0x988

#define S_RXSYMCODEERRFRAMES    0
#define M_RXSYMCODEERRFRAMES    0xffff
#define V_RXSYMCODEERRFRAMES(x) ((x) << S_RXSYMCODEERRFRAMES)
#define G_RXSYMCODEERRFRAMES(x) (((x) >> S_RXSYMCODEERRFRAMES) & M_RXSYMCODEERRFRAMES)

#define A_XGM_SERDES_STATUS0 0x98c

#define S_RXERRLANE3    9
#define M_RXERRLANE3    0x7
#define V_RXERRLANE3(x) ((x) << S_RXERRLANE3)
#define G_RXERRLANE3(x) (((x) >> S_RXERRLANE3) & M_RXERRLANE3)

#define S_RXERRLANE2    6
#define M_RXERRLANE2    0x7
#define V_RXERRLANE2(x) ((x) << S_RXERRLANE2)
#define G_RXERRLANE2(x) (((x) >> S_RXERRLANE2) & M_RXERRLANE2)

#define S_RXERRLANE1    3
#define M_RXERRLANE1    0x7
#define V_RXERRLANE1(x) ((x) << S_RXERRLANE1)
#define G_RXERRLANE1(x) (((x) >> S_RXERRLANE1) & M_RXERRLANE1)

#define S_RXERRLANE0    0
#define M_RXERRLANE0    0x7
#define V_RXERRLANE0(x) ((x) << S_RXERRLANE0)
#define G_RXERRLANE0(x) (((x) >> S_RXERRLANE0) & M_RXERRLANE0)

#define A_XGM_SERDES_STATUS1 0x990

#define S_RXKLOCKLANE3    11
#define V_RXKLOCKLANE3(x) ((x) << S_RXKLOCKLANE3)
#define F_RXKLOCKLANE3    V_RXKLOCKLANE3(1U)

#define S_RXKLOCKLANE2    10
#define V_RXKLOCKLANE2(x) ((x) << S_RXKLOCKLANE2)
#define F_RXKLOCKLANE2    V_RXKLOCKLANE2(1U)

#define S_RXKLOCKLANE1    9
#define V_RXKLOCKLANE1(x) ((x) << S_RXKLOCKLANE1)
#define F_RXKLOCKLANE1    V_RXKLOCKLANE1(1U)

#define S_RXKLOCKLANE0    8
#define V_RXKLOCKLANE0(x) ((x) << S_RXKLOCKLANE0)
#define F_RXKLOCKLANE0    V_RXKLOCKLANE0(1U)

#define S_RXUFLOWLANE3    7
#define V_RXUFLOWLANE3(x) ((x) << S_RXUFLOWLANE3)
#define F_RXUFLOWLANE3    V_RXUFLOWLANE3(1U)

#define S_RXUFLOWLANE2    6
#define V_RXUFLOWLANE2(x) ((x) << S_RXUFLOWLANE2)
#define F_RXUFLOWLANE2    V_RXUFLOWLANE2(1U)

#define S_RXUFLOWLANE1    5
#define V_RXUFLOWLANE1(x) ((x) << S_RXUFLOWLANE1)
#define F_RXUFLOWLANE1    V_RXUFLOWLANE1(1U)

#define S_RXUFLOWLANE0    4
#define V_RXUFLOWLANE0(x) ((x) << S_RXUFLOWLANE0)
#define F_RXUFLOWLANE0    V_RXUFLOWLANE0(1U)

#define S_RXOFLOWLANE3    3
#define V_RXOFLOWLANE3(x) ((x) << S_RXOFLOWLANE3)
#define F_RXOFLOWLANE3    V_RXOFLOWLANE3(1U)

#define S_RXOFLOWLANE2    2
#define V_RXOFLOWLANE2(x) ((x) << S_RXOFLOWLANE2)
#define F_RXOFLOWLANE2    V_RXOFLOWLANE2(1U)

#define S_RXOFLOWLANE1    1
#define V_RXOFLOWLANE1(x) ((x) << S_RXOFLOWLANE1)
#define F_RXOFLOWLANE1    V_RXOFLOWLANE1(1U)

#define S_RXOFLOWLANE0    0
#define V_RXOFLOWLANE0(x) ((x) << S_RXOFLOWLANE0)
#define F_RXOFLOWLANE0    V_RXOFLOWLANE0(1U)

#define A_XGM_SERDES_STATUS2 0x994

#define S_XGM_RXEIDLANE3    11
#define V_XGM_RXEIDLANE3(x) ((x) << S_XGM_RXEIDLANE3)
#define F_XGM_RXEIDLANE3    V_XGM_RXEIDLANE3(1U)

#define S_XGM_RXEIDLANE2    10
#define V_XGM_RXEIDLANE2(x) ((x) << S_XGM_RXEIDLANE2)
#define F_XGM_RXEIDLANE2    V_XGM_RXEIDLANE2(1U)

#define S_XGM_RXEIDLANE1    9
#define V_XGM_RXEIDLANE1(x) ((x) << S_XGM_RXEIDLANE1)
#define F_XGM_RXEIDLANE1    V_XGM_RXEIDLANE1(1U)

#define S_XGM_RXEIDLANE0    8
#define V_XGM_RXEIDLANE0(x) ((x) << S_XGM_RXEIDLANE0)
#define F_XGM_RXEIDLANE0    V_XGM_RXEIDLANE0(1U)

#define S_RXREMSKIPLANE3    7
#define V_RXREMSKIPLANE3(x) ((x) << S_RXREMSKIPLANE3)
#define F_RXREMSKIPLANE3    V_RXREMSKIPLANE3(1U)

#define S_RXREMSKIPLANE2    6
#define V_RXREMSKIPLANE2(x) ((x) << S_RXREMSKIPLANE2)
#define F_RXREMSKIPLANE2    V_RXREMSKIPLANE2(1U)

#define S_RXREMSKIPLANE1    5
#define V_RXREMSKIPLANE1(x) ((x) << S_RXREMSKIPLANE1)
#define F_RXREMSKIPLANE1    V_RXREMSKIPLANE1(1U)

#define S_RXREMSKIPLANE0    4
#define V_RXREMSKIPLANE0(x) ((x) << S_RXREMSKIPLANE0)
#define F_RXREMSKIPLANE0    V_RXREMSKIPLANE0(1U)

#define S_RXADDSKIPLANE3    3
#define V_RXADDSKIPLANE3(x) ((x) << S_RXADDSKIPLANE3)
#define F_RXADDSKIPLANE3    V_RXADDSKIPLANE3(1U)

#define S_RXADDSKIPLANE2    2
#define V_RXADDSKIPLANE2(x) ((x) << S_RXADDSKIPLANE2)
#define F_RXADDSKIPLANE2    V_RXADDSKIPLANE2(1U)

#define S_RXADDSKIPLANE1    1
#define V_RXADDSKIPLANE1(x) ((x) << S_RXADDSKIPLANE1)
#define F_RXADDSKIPLANE1    V_RXADDSKIPLANE1(1U)

#define S_RXADDSKIPLANE0    0
#define V_RXADDSKIPLANE0(x) ((x) << S_RXADDSKIPLANE0)
#define F_RXADDSKIPLANE0    V_RXADDSKIPLANE0(1U)

#define A_XGM_XAUI_PCS_ERR 0x998

#define S_PCS_SYNCSTATUS    5
#define M_PCS_SYNCSTATUS    0xf
#define V_PCS_SYNCSTATUS(x) ((x) << S_PCS_SYNCSTATUS)
#define G_PCS_SYNCSTATUS(x) (((x) >> S_PCS_SYNCSTATUS) & M_PCS_SYNCSTATUS)

#define S_PCS_CTCFIFOERR    1
#define M_PCS_CTCFIFOERR    0xf
#define V_PCS_CTCFIFOERR(x) ((x) << S_PCS_CTCFIFOERR)
#define G_PCS_CTCFIFOERR(x) (((x) >> S_PCS_CTCFIFOERR) & M_PCS_CTCFIFOERR)

#define S_PCS_NOTALIGNED    0
#define V_PCS_NOTALIGNED(x) ((x) << S_PCS_NOTALIGNED)
#define F_PCS_NOTALIGNED    V_PCS_NOTALIGNED(1U)

#define A_XGM_RGMII_STATUS 0x99c

#define S_GMIIDUPLEX    3
#define V_GMIIDUPLEX(x) ((x) << S_GMIIDUPLEX)
#define F_GMIIDUPLEX    V_GMIIDUPLEX(1U)

#define S_GMIISPEED    1
#define M_GMIISPEED    0x3
#define V_GMIISPEED(x) ((x) << S_GMIISPEED)
#define G_GMIISPEED(x) (((x) >> S_GMIISPEED) & M_GMIISPEED)

#define S_GMIILINKSTATUS    0
#define V_GMIILINKSTATUS(x) ((x) << S_GMIILINKSTATUS)
#define F_GMIILINKSTATUS    V_GMIILINKSTATUS(1U)

#define A_XGM_WOL_STATUS 0x9a0

#define S_PATDETECTED    31
#define V_PATDETECTED(x) ((x) << S_PATDETECTED)
#define F_PATDETECTED    V_PATDETECTED(1U)

#define S_MATCHEDFILTER    0
#define M_MATCHEDFILTER    0x7
#define V_MATCHEDFILTER(x) ((x) << S_MATCHEDFILTER)
#define G_MATCHEDFILTER(x) (((x) >> S_MATCHEDFILTER) & M_MATCHEDFILTER)

#define A_XGM_RX_MAX_PKT_SIZE_ERR_CNT 0x9a4
#define A_XGM_TX_SPI4_SOP_EOP_CNT 0x9a8

#define S_TXSPI4SOPCNT    16
#define M_TXSPI4SOPCNT    0xffff
#define V_TXSPI4SOPCNT(x) ((x) << S_TXSPI4SOPCNT)
#define G_TXSPI4SOPCNT(x) (((x) >> S_TXSPI4SOPCNT) & M_TXSPI4SOPCNT)

#define S_TXSPI4EOPCNT    0
#define M_TXSPI4EOPCNT    0xffff
#define V_TXSPI4EOPCNT(x) ((x) << S_TXSPI4EOPCNT)
#define G_TXSPI4EOPCNT(x) (((x) >> S_TXSPI4EOPCNT) & M_TXSPI4EOPCNT)

#define A_XGM_RX_SPI4_SOP_EOP_CNT 0x9ac

#define S_RXSPI4SOPCNT    16
#define M_RXSPI4SOPCNT    0xffff
#define V_RXSPI4SOPCNT(x) ((x) << S_RXSPI4SOPCNT)
#define G_RXSPI4SOPCNT(x) (((x) >> S_RXSPI4SOPCNT) & M_RXSPI4SOPCNT)

#define S_RXSPI4EOPCNT    0
#define M_RXSPI4EOPCNT    0xffff
#define V_RXSPI4EOPCNT(x) ((x) << S_RXSPI4EOPCNT)
#define G_RXSPI4EOPCNT(x) (((x) >> S_RXSPI4EOPCNT) & M_RXSPI4EOPCNT)

/* registers for module XGMAC0_1 */
#define XGMAC0_1_BASE_ADDR 0xa00
