/*-
 * Copyright (c) 2003
 *	Fraunhofer Institute for Open Communication Systems (FhG Fokus).
 * 	All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * Author: Hartmut Brandt <harti@freebsd.org>
 *
 * $FreeBSD: stable/8/sys/dev/utopia/suni.h 139749 2005-01-06 01:43:34Z imp $
 *
 * Register definitions for the following chips:
 *	PMC-Sierra PMC-5346 (S/UNI-LITE)
 *	PMC-Sierra PMC-5350 (S/UNI-ULTRA)
 *	PMC-Sierra PMC-5355 (S/UNI-622)
 *
 * All definitions ending with _ULTRA are for the ULTRA chip only, all
 * definitions ending with _LITE are for the LITE chip only. Some registers
 * are only in the ULTRA and the definitions are not suffixed. All other
 * definitions are for all chips.
 */
#ifndef _DEV_UTOPIA_SUNI_H
#define	_DEV_UTOPIA_SUNI_H

/* lite, ultra, 622 */
#define	SUNI_REGN_MRESET 	"Master Reset and Identity/Load Meters"
#define	SUNI_REGO_MRESET		0x00
#define	SUNI_REGM_MRESET_RESET		0x80
#define	SUNI_REGM_MRESET_TYPE		0x70
#define	SUNI_REGM_MRESET_TYPE_622	0x10
#define	SUNI_REGM_MRESET_TYPE_LITE	0x30
#define	SUNI_REGM_MRESET_TYPE_ULTRA	0x70
#define	SUNI_REGM_MRESET_TIP_ULTRA	0x08
#define	SUNI_REGM_MRESET_ID_ULTRA	0x07
#define	SUNI_REGM_MRESET_ID_LITE	0x0f
#define	SUNI_REGM_MRESET_ID_622		0x0f
#define	SUNI_REGX_MRESET_ULTRA	"\020\10RESET\12\x70\12TYPE\4TIP\12\7\12ID"
#define	SUNI_REGX_MRESET_LITE	"\020\10RESET\12\x70\12TYPE\12\xf\12ID"
#define	SUNI_REGX_MRESET_622	"\020\10RESET\12\x70\12TYPE\12\xf\12ID"

/* lite, ultra */
#define	SUNI_REGN_MCONFIG "Master Configuration"
#define	SUNI_REGO_MCONFIG		0x01
#define	SUNI_REGM_MCONFIG_AUTOFEBE	0x40
#define	SUNI_REGM_MCONFIG_AUTOLRDI	0x20
#define	SUNI_REGM_MCONFIG_AUTOPRDI	0x10
#define	SUNI_REGM_MCONFIG_TCAINV	0x08
#define	SUNI_REGM_MCONFIG_RCAINV	0x04
#define	SUNI_REGM_MCONFIG_RXDINV_LITE	0x02
#define	SUNI_REGM_MCONFIG_TFP_IN_ULTRA	0x01
#define	SUNI_REGM_MCONFIG_RESERVED	0x00
#define	SUNI_REGX_MCONFIG_LITE "\020\7AUTOFEBE\6AUTOLRDI\5AUTOPRDI\4TCAINV\3RCAINV\2RXDINV"
#define	SUNI_REGX_MCONFIG_ULTRA "\020\7AUTOFEBE\6AUTOLRDI\5AUTOPRDI\4TCAINV\3RCAINV\1TFPI_IN"

/* 622 */
#define	SUNI_REGM_MCONFIG_TPTBEN_622	0x80
#define	SUNI_REGM_MCONFIG_TSTBEN_622	0x40
#define	SUNI_REGM_MCONFIG_SDH_C1_622	0x20
#define	SUNI_REGM_MCONFIG_FIXPTR_622	0x10
#define	SUNI_REGM_MCONFIG_TMODE_622	0x0C
#define	SUNI_REGM_MCONFIG_TMODE_STS1_BYTE	0x00
#define	SUNI_REGM_MCONFIG_TMODE_STS3c		0x04
#define	SUNI_REGM_MCONFIG_TMODE_STS1_BIT	0x08
#define	SUNI_REGM_MCONFIG_TMODE_STS12c		0x0C
#define	SUNI_REGM_MCONFIG_RMODE_622	0x03
#define	SUNI_REGM_MCONFIG_RMODE_STS1_BYTE	0x00
#define	SUNI_REGM_MCONFIG_RMODE_STS3c		0x01
#define	SUNI_REGM_MCONFIG_RMODE_STS1_BIT	0x02
#define	SUNI_REGM_MCONFIG_RMODE_STS12c		0x03
#define	SUNI_REGX_MCONFIG_622	"\020\10TPTBEN\7TSTBEN\6SDH_C1\5FIXPTR\11\x0C\0x00XSTS1BYTE\11\0x0C\0x04XSTS3c\11\0x0C\0x08XSTS1BIT\11\0x0C\0x0CXSTS12c\11\0x03\0x00RSTS1BYTE\11\0x03\0x01RSTS3c\11\0x03\0x02RSTS1BIT\11\0x03\0x03RSTS12c"

/* lite, ultra, 622 */
#define	SUNI_REGN_MISTATUS "Master Interrupt Status"
#define	SUNI_REGO_MISTATUS		0x02
#define	SUNI_REGM_MISTATUS_CSUI_ULTRA	0x80
#define	SUNI_REGM_MISTATUS_TROOLI_LITE	0x80
#define	SUNI_REGM_MISTATUS_SUNII_622	0x80
#define	SUNI_REGM_MISTATUS_LCDI		0x40
#define	SUNI_REGM_MISTATUS_STBI_622	0x40
#define	SUNI_REGM_MISTATUS_CRUI_ULTRA	0x20
#define	SUNI_REGM_MISTATUS_RDOOLI_LITE	0x20
#define	SUNI_REGM_MISTATUS_RESERVED_622	0x20
#define	SUNI_REGM_MISTATUS_TACPI	0x10
#define	SUNI_REGM_MISTATUS_RACPI	0x08
#define	SUNI_REGM_MISTATUS_RPOPI	0x04
#define	SUNI_REGM_MISTATUS_RLOPI	0x02
#define	SUNI_REGM_MISTATUS_RSOPI	0x01
#define	SUNI_REGX_MISTATUS_LITE "\020\10TROOLI\7LCDI\6RDOOLI\5TACPI\4RACPI\3RPOPI\2RLOPI\1RSOPI"
#define	SUNI_REGX_MISTATUS_ULTRA "\020\10CSUI\7LCDI\6CRUI\5TACPI\4RACPI\3RPOPI\2RLOPI\1RSOPI"
#define	SUNI_REGX_MISTATUS_622	"\020\10S/UNII\7STBI\5TACPI\4RACPI\3RPOPI\2RLOPI\1RSOPI"

/* ultra */
#define	SUNI_REGN_MMCTRL	"Master Mode Control"
#define	SUNI_REGO_MMCTRL		0x03
#define	SUNI_REGM_MMCTRL_51		0x02
#define	SUNI_REGM_MMCTRL_155		0x03
#define	SUNI_REGX_MMCTRL	"\020\11\3\00251MBIT\11\3\003155MBIT"

/* 622 */
#define	SUNI_REGN_PISO		"PISO Interrupt"
#define	SUNI_REGO_PISO			0x03
#define	SUNI_REGM_PISO_PAEE		0x02
#define	SUNI_REGM_PISO_PAEI		0x01
#define	SUNI_REGX_PISO		"\020\2PAEE\1PAEI"

/* ultra/lite */
#define	SUNI_REGN_MCLKM		"Master Clock Monitor"
#define	SUNI_REGO_MCLKM			0x04
#define	SUNI_REGM_MCLKM_RFCLKA		0x10	/* ultra */
#define	SUNI_REGM_MCLKM_TFCLKA		0x08	/* ultra */
#define	SUNI_REGM_MCLKM_RRCLKA		0x08	/* lite */
#define	SUNI_REGM_MCLKM_REFCLKA		0x04	/* ultra */
#define	SUNI_REGM_MCLKM_TRCLKA		0x04	/* lite */
#define	SUNI_REGM_MCLKM_RCLKA		0x02
#define	SUNI_REGM_MCLKM_TCLKA		0x01
#define	SUNI_REGX_MCLKM_LITE	"\020\4RRCLKA\3TRCLKA\2RCLKA\1TCLKA"
#define	SUNI_REGX_MCLKM_ULTRA	"\020\5RFCLKA\4TFCLKA\3REFCLKA\2RCLKA\1TCLKA"

/* 622 */
#define	SUNI_REGN_MCTRLM	"Master Control/Monitor"
#define	SUNI_REGO_MCTRLM		0x04
#define	SUNI_REGM_MCTRLM_TCAINV		0x80
#define	SUNI_REGM_MCTRLM_RCAINV		0x40
#define	SUNI_REGM_MCTRLM_LLE		0x20
#define	SUNI_REGM_MCTRLM_DLE		0x10
#define	SUNI_REGM_MCTRLM_LOOPT		0x08
#define	SUNI_REGM_MCTRLM_DPLE		0x04
#define	SUNI_REGM_MCTRLM_PICLKA		0x02
#define	SUNI_REGM_MCTRLM_TCLKA		0x01
#define	SUNI_REGX_MCTRLM	"\020\10TCAINV\7RCAINV\6LLE\5DLE\4LOOPT\3DPLE\2PICLKA\1TCLKA"

/* ultra/lite */
#define	SUNI_REGN_MCTRL		"Master Control"
#define	SUNI_REGO_MCTRL			0x05
#define	SUNI_REGM_MCTRL_LCDE		0x80
#define	SUNI_REGM_MCTRL_LCDV		0x40
#define	SUNI_REGM_MCTRL_FIXPTR		0x20
#define	SUNI_REGM_MCTRL_TPLE		0x10	/* ultra */
#define	SUNI_REGM_MCTRL_PDLE		0x08	/* ultra */
#define	SUNI_REGM_MCTRL_LLE		0x04
#define	SUNI_REGM_MCTRL_SDLE		0x02	/* ultra */
#define	SUNI_REGM_MCTRL_DLE		0x02	/* lite */
#define	SUNI_REGM_MCTRL_LOOPT		0x01
#define	SUNI_REGX_MCTRL_ULTRA	"\020\10LCDE\7LCDV\6FIXPTR\5TPLE\4PDLE\3LLE\2SDLE\1LOOPT"
#define	SUNI_REGX_MCTRL_LITE	"\020\10LCDE\7LCDV\6FIXPTR\3LLE\2DLE\1LOOPT"

/* 622 */
#define	SUNI_REGN_MALARM	"Master Auto Alarm"
#define	SUNI_REGO_MALARM		0x05
#define	SUNI_REGM_MALARM_AUTOFEBE	0x04
#define	SUNI_REGM_MALARM_AUTOLRDI	0x02
#define	SUNI_REGM_MALARM_AUTOPRDI	0x01
#define	SUNI_REGX_MALARM	"\020\4AUTOFEBE\2AUTOLRDI\1AUTOPRDI"

/* ultra/lite */
#define	SUNI_REGN_CLKSYN	"Clock Synthesis Control and Status"
#define	SUNI_REGO_CLKSYN		0x06
#define	SUNI_REGM_CLKSYN_TROOLI		0x20	/* ultra */
#define	SUNI_REGM_CLKSYN_TROOLV		0x08
#define	SUNI_REGM_CLKSYN_TROOLE		0x02
#define	SUNI_REGM_CLKSYN_TREFSEL	0x01	/* lite */
#define	SUNI_REGM_CLKSYN_RESERVED	0x00
#define	SUNI_REGX_CLKSYN_ULTRA	"\020\6TROOLI\4TROOLV\2TROOLE"
#define	SUNI_REGX_CLKSYN_LITE	"\020\4TROOLV\2TROOLE\1TREFSEL"

/* 622 */
#define	SUNI_REGN_POUT	"Parallel Output Port"
#define	SUNI_REGO_POUT			0x06
#define	SUNI_REGM_POUT_POP		0x3f
#define	SUNI_REGX_POUT	"\020\12\x3f\12POP"

/* ultra/lite */
#define	SUNI_REGN_CLKREC "Clock Recovery Control and Status"
#define	SUNI_REGO_CLKREC_LITE		0x07
#define	SUNI_REGO_CLKREC_ULTRA		0x08
#define	SUNI_REGM_CLKREC_RROOLI		0x40	/* ultra */
#define	SUNI_REGM_CLKREC_RDOOLI		0x20	/* ultra */
#define	SUNI_REGM_CLKREC_RROOLV		0x10
#define	SUNI_REGM_CLKREC_RDOOLV		0x08
#define	SUNI_REGM_CLKREC_RROOLE		0x04	/* ultra */
#define	SUNI_REGM_CLKREC_RDOOLE		0x02
#define	SUNI_REGM_CLKREC_RREFSEL	0x01	/* lite */
#define	SUNI_REGM_CLKREC_RESERVED	0x00
#define	SUNI_REGX_CLKREC_ULTRA "\020\7RROOLI\6RDOOLI\5RROOLV\4RDOOLV\3RROOLE\2RDOOLE"
#define	SUNI_REGX_CLKREC_LITE "\020\5RROOLV\4RDOOLV\2RDOOLE\1RREFSEL"

/* 622 */
#define	SUNI_REGN_PIN	"Parallel Input Port"
#define	SUNI_REGO_PIN			0x07

/* 622 */
#define	SUNI_REGN_PINV	"Parallel Input Port Value"
#define	SUNI_REGO_PINV			0x08
#define	SUNI_REGM_PINV_PIPV		0x0f
#define	SUNI_REGX_PINV	"\020\12\0x0f\12PIPIV"

/* ultra */
#define	SUNI_REGN_CLKRECCFG	"Clock Recovery Configuration"
#define	SUNI_REGO_CLKRECCFG		0x09
#define	SUNI_REGM_CLKRECCFG_RESERVED	0x07
#define	SUNI_REGX_CLKRECCFG	"\020"

/* 622 */
#define	SUNI_REGN_PINE	"Parallel Input Port Enable"
#define	SUNI_REGO_PINE			0x09

/* ultra */
#define	SUNI_REGN_LTXCFG1 "Line Transmitter Configuration 1"
#define	SUNI_REGO_LTXCFG1		0x0A
#define	SUNI_REGM_LTXCFG1_VREFSEL	0x80
#define	SUNI_REGM_LTXCFG1_OEN		0x20
#define	SUNI_REGM_LTXCFG1_OTQ		0x10
#define	SUNI_REGM_LTXCFG1_RESERVED	0x0C
#define	SUNI_REGX_LTXCFG1 "\020\10VREFSEL\6OEN\5OTQ"

/* 622 */
#define	SUNI_REGN_XC1	"Transmit C1"
#define	SUNI_REGO_XC1			0x0A

/* ultra */
#define	SUNI_REGN_LTXCFG2 "Line Transmitter Configuration 2"
#define	SUNI_REGO_LTXCFG2		0x0B
#define	SUNI_REGM_LTXCFG2_RESERVED	0xFF
#define	SUNI_REGX_LTXCFG2 "\020"

/* 622 */
#define	SUNI_REGN_APSCS	"APS Control/Status"
#define	SUNI_REGO_APSCS			0x0B
#define	SUNI_REGM_APSCS_PSBFE		0x80
#define	SUNI_REGM_APSCS_COAPSE		0x40
#define	SUNI_REGM_APSCS_Z1E		0x20
#define	SUNI_REGM_APSCS_Zi1		0x10
#define	SUNI_REGM_APSCS_PSBFI		0x08
#define	SUNI_REGM_APSCS_COAPSI		0x04
#define	SUNI_REGM_APSCS_RESERVED	0x02
#define	SUNI_REGM_APSCS_PSBFV		0x01
#define	SUNI_REGX_APSCS	"\020\10PSBFE\7COAPSE\6Z1E\5Z1I\4PSBFI\3COAPSI\1PSBFV"

/* ultra */
#define	SUNI_REGN_LRXCFG "Line Receiver Configuration"
#define	SUNI_REGO_LRXCFG		0x0C
#define	SUNI_REGM_LRXCFG_RESERVED	0x01
#define	SUNI_REGX_LRXCFG "\020"

/* 622 */
#define	SUNI_REGN_RK1	"Receive K1"
#define	SUNI_REGO_RK1			0x0C

/* 622 */
#define	SUNI_REGN_RK2	"Receive K2"
#define	SUNI_REGO_RK2			0x0D

/* 622 */
#define	SUNI_REGN_RZ1	"Receive Z1"
#define	SUNI_REGO_RZ1			0x0E

/* 622 */
#define	SUNI_REGN_XZ1	"Transmit Z1"
#define	SUNI_REGO_XZ1			0x0F

/* lite, ultra, 622 */
#define	SUNI_REGN_RSOPCIE "RSOP Control/Interrupt Enable"
#define	SUNI_REGO_RSOPCIE		0x10
#define	SUNI_REGO_RSOPCIE_BIPWORD_622	0x80
#define	SUNI_REGM_RSOPCIE_DDS		0x40
#define	SUNI_REGM_RSOPCIE_FOOF		0x20
#define	SUNI_REGM_RSOPCIE_RESV		0x10
#define	SUNI_REGM_RSOPCIE_ALGO2_622	0x10
#define	SUNI_REGM_RSOPCIE_BIPEE		0x08
#define	SUNI_REGM_RSOPCIE_LOSE		0x04
#define	SUNI_REGM_RSOPCIE_LOFE		0x02
#define	SUNI_REGM_RSOPCIE_OOFE		0x01
#define	SUNI_REGX_RSOPCIE	"\020\7DDS\6FOOF\4BIPEE\3LOSE\2LOFE\1OOFE"
#define	SUNI_REGX_RSOPCIE_622	"\020\10BIPWORD\7DDS\6FOOF\5ALGO2\4BIPEE\3LOSE\2LOFE\1OOFE"

/* lite, ultra, 622 */
#define	SUNI_REGN_RSOPSIS "RSOP Status/Interrupt Status"
#define	SUNI_REGO_RSOPSIS		0x11
#define	SUNI_REGM_RSOPSIS_BIPEI		0x40
#define	SUNI_REGM_RSOPSIS_LOSI		0x20
#define	SUNI_REGM_RSOPSIS_LOFI		0x10
#define	SUNI_REGM_RSOPSIS_OOFI		0x08
#define	SUNI_REGM_RSOPSIS_LOSV		0x04
#define	SUNI_REGM_RSOPSIS_LOFV		0x02
#define	SUNI_REGM_RSOPSIS_OOFV		0x01
#define	SUNI_REGX_RSOPSIS "\020\7BIPEI\6LOSI\5LOFI\4OOFI\3LOSV\2LOFV\1OOFV"

/* lite, ultra, 622 */
#define	SUNI_REGN_RSOP_BIP8 "RSOP Section BIP-8"
#define	SUNI_REGO_RSOP_BIP8		0x12	/* +0x13 */

/* lite, ultra, 622 */
#define	SUNI_REGN_TSOPCTRL "TSOP Control"
#define	SUNI_REGO_TSOPCTRL		0x14
#define	SUNI_REGM_TSOPCTRL_DS		0x40
#define	SUNI_REGM_TSOPCTRL_LAIS		0x01
#define	SUNI_REGM_TSOPCTRL_RESERVED	0x00
#define	SUNI_REGX_TSOPCTRL "\020\7DS\1LAIS"

/* lite, ultra, 622 */
#define	SUNI_REGN_TSOPDIAG "TSOP Diagnostics"
#define	SUNI_REGO_TSOPDIAG		0x15
#define	SUNI_REGM_TSOPDIAG_DLOS		0x04
#define	SUNI_REGM_TSOPDIAG_DBIP8	0x02
#define	SUNI_REGM_TSOPDIAG_DFP		0x01
#define	SUNI_REGX_TSOPDIAG "\020\3DLOS\2DBIP8\1DFP"

/* lite, ultra, 622 */
#define	SUNI_REGN_RLOPCTRL "RLOP Control/Status"
#define	SUNI_REGO_RLOPCTRL		0x18
#define	SUNI_REGO_RLOPCTRL_BIPWORD	0x80
#define	SUNI_REGO_RLOPCTRL_ALLONES_622	0x40
#define	SUNI_REGO_RLOPCTRL_AISDET_622	0x20
#define	SUNI_REGO_RLOPCTRL_LRDIDET_622	0x10
#define	SUNI_REGO_RLOPCTRL_BIPWORDO_622	0x08
#define	SUNI_REGO_RLOPCTRL_LAISV	0x02
#define	SUNI_REGO_RLOPCTRL_RDIV		0x01
#define	SUNI_REGO_RLOPCTRL_RESERVED	0x00
#define	SUNI_REGX_RLOPCTRL	"\020\10BIPWORD\2LAISV\1RDIV"
#define	SUNI_REGX_RLOPCTRL_622	"\020\10BIPWORD\7ALLONES\6AISDET\5LRDIDET\4BIPWORDO\2LAISV\1RDIV"

/* lite, ultra, 622 */
#define	SUNI_REGN_RLOPINTR "RLOP Interrupt Enable/Interrupt Status"
#define	SUNI_REGO_RLOPINTR		0x19
#define	SUNI_REGO_RLOPINTR_FEBEE	0x80
#define	SUNI_REGO_RLOPINTR_BIPEE	0x40
#define	SUNI_REGO_RLOPINTR_LAISE	0x20
#define	SUNI_REGO_RLOPINTR_RDIE		0x10
#define	SUNI_REGO_RLOPINTR_FEBEI	0x08
#define	SUNI_REGO_RLOPINTR_BIPEI	0x04
#define	SUNI_REGO_RLOPINTR_LAISI	0x02
#define	SUNI_REGO_RLOPINTR_RDII		0x01
#define	SUNI_REGX_RLOPINTR "\020\10FEBEE\7BIPEE\6LAISE\5DRIE\4FEBEI\3BIPEI\2LAISI\1RDII"

/* lite, ultra */
#define	SUNI_REGN_RLOPBIP8_24 "RLOP Line BIP-8/24"
#define	SUNI_REGO_RLOPBIP8_24		0x1A	/* +1B,1C */
#define	SUNI_REGM_RLOPBIP8_24		0x0F

/* 622 */
#define	SUNI_REGN_RLOPBIP8_24_96 "RLOP Line BIP-8/24/96"
#define	SUNI_REGO_RLOPBIP8_24_96	0x1A	/* +1B,1C */
#define	SUNI_REGM_RLOPBIP8_24_96	0x0F

/* lite, ultra, 622 */
#define	SUNI_REGN_RLOPFEBE "RLOP Line FEBE"
#define	SUNI_REGO_RLOPFEBE		0x1D	/* +1E,1F */
#define	SUNI_REGM_RLOPFEBE		0x0F

/* lite, ultra, 622 */
#define	SUNI_REGN_TLOPCTRL "TLOP Control"
#define	SUNI_REGO_TLOPCTRL		0x20
#define	SUNI_REGM_TLOPCTRL_APSREG_622	0x20
#define	SUNI_REGM_TLOPCTRL_RDI		0x01
#define	SUNI_REGM_TLOPCTRL_RESERVED	0x00
#define	SUNI_REGX_TLOPCTRL	"\020\1RDI"
#define	SUNI_REGX_TLOPCTRL_622	"\020\6APSREG\1LRDI"

/* lite, ultra, 622 */
#define	SUNI_REGN_TLOPDIAG "TLOP Diagnostics"
#define	SUNI_REGO_TLOPDIAG		0x21
#define	SUNI_REGM_TLOPDIAG_DBIP		0x01
#define	SUNI_REGX_TLOPDIAG "\020\1DBIP"

/* 622 */
#define	SUNI_REGN_TLOP_XK1	"TLOP Transmit K1"
#define	SUNI_REGO_TLOP_XK1		0x22

/* 622 */
#define	SUNI_REGN_TLOP_XK2	"TLOP Transmit K2"
#define	SUNI_REGO_TLOP_XK2		0x23

/* 622 */
#define	SUNI_REGN_SSTBCTRL	"SSTB Control"
#define	SUNI_REGO_SSTBCTRL		0x28
#define	SUNI_REGM_SSTBCTRL_RRAMACC	0x40
#define	SUNI_REGM_SSTBCTRL_RTIUIE	0x20
#define	SUNI_REGM_SSTBCTRL_RTIMIE	0x10
#define	SUNI_REGM_SSTBCTRL_PER5		0x08
#define	SUNI_REGM_SSTBCTRL_TNULL	0x04
#define	SUNI_REGM_SSTBCTRL_NOSYNC	0x02
#define	SUNI_REGM_SSTBCTRL_LEN16	0x01
#define	SUNI_REGX_SSTBCTRL	"\020\7RRAMACC\6RTIUIE\5RTIMIE\4PER5\3TNULL\2NOSYNC\1LEN16"

/* 622 */
#define	SUNI_REGN_SSTBSTIS	"SSTB Section Trace Identifier Status"
#define	SUNI_REGO_SSTBSTIS		0x29
#define	SUNI_REGM_SSTBSTIS_BUSY		0x80
#define	SUNI_REGM_SSTBSTIS_RTIUI	0x08
#define	SUNI_REGM_SSTBSTIS_RTIUV	0x04
#define	SUNI_REGM_SSTBSTIS_RTIMI	0x02
#define	SUNI_REGM_SSTBSTIS_RTIMV	0x01
#define	SUNI_REGX_SSTBSTIS	"\020\10BUSY\4RTIUI\3RTIUV\2RTIMI\1RTIMV"

/* 622 */
#define	SUNI_REGN_SSTBIAR	"SSTB Indirect Address Register"
#define	SUNI_REGO_SSTBIAR		0x2A
#define	SUNI_REGM_SSTBIAR_RWB		0x80
#define	SUNI_REGM_SSTBIAR_A		0x7F
#define	SUNI_REGX_SSTBIAR	"\020\10RWB\12\x7f\20"

/* 622 */
#define	SUNI_REGN_SSTBIDR	"SSTB Indirect Data Register"
#define	SUNI_REGO_SSTBIDR		0x2B

#if 0	/* see chip errata */
/* 622 */
#define	SUNI_REGN_SSTBECSM	"SSTB Expected Clock Synchronization Message"
#define	SUNI_REGO_SSTBECSM		0x2C
#endif

/* 622 */
#define	SUNI_REGN_SSTBCSMS	"SSTB Clock Synchronisation Message Status"
#define	SUNI_REGO_SSTBCSMS		0x2D
#define	SUNI_REGM_SSTBCSMS_RCSMUIE	0x80
#define	SUNI_REGM_SSTBCSMS_RCSMMIE	0x40
#define	SUNI_REGM_SSTBCSMS_RCSMUI	0x08
#define	SUNI_REGM_SSTBCSMS_RCSMUV	0x04
#define	SUNI_REGM_SSTBCSMS_RCSMMI	0x02
#define	SUNI_REGM_SSTBCSMS_RCSMMV	0x01
#define	SUNI_REGX_SSTBCSMS	"\020\10RCSMUIE\7RCSMMIE\4RCSMUI\3RCSMUV\2RCSMMI\1RCSMMV"

/* lite, ultra, 622 */
#define	SUNI_REGN_RPOPCTRL	"RPOP Status/Control"
#define	SUNI_REGO_RPOPCTRL		0x30
#define	SUNI_REGM_RPOPCTRL_LOP		0x20
#define	SUNI_REGM_RPOPCTRL_PAIS		0x08
#define	SUNI_REGM_RPOPCTRL_PRDI		0x04
#define	SUNI_REGM_RPOPCTRL_NEWPTRI_622	0x02
#define	SUNI_REGM_RPOPCTRL_NEWPTRE_622	0x01
#define	SUNI_REGM_RPOPCTRL_RESERVED	0x00
#define	SUNI_REGX_RPOPCTRL	"\020\6LOP\4PAIS\3PRDI"
#define	SUNI_REGX_RPOPCTRL_622	"\020\6LOP\4PAIS\3PRDI\2NEWPTRI\1NEWPTRE"

/* lite, ultra, 622 */
#define	SUNI_REGN_RPOPISTAT	"RPOP Interrupt Status"
#define	SUNI_REGO_RPOPISTAT		0x31
#define	SUNI_REGM_RPOPISTAT_PSLI	0x80
#define	SUNI_REGM_RPOPISTAT_LOPI	0x20
#define	SUNI_REGM_RPOPISTAT_PAISI	0x08
#define	SUNI_REGM_RPOPISTAT_PRDII	0x04
#define	SUNI_REGM_RPOPISTAT_BIPEI	0x02
#define	SUNI_REGM_RPOPISTAT_FEBEI	0x01
#define	SUNI_REGX_RPOPISTAT	"\02010PSLI\6LOPI\4PAISI\3PRDII\2BIPEI\1FEBEI"

/* 622 */
#define	SUNI_REGN_RPOPPIS	"RPOP Pointer Interrupt Status"
#define	SUNI_REGO_RPOPPIS		0x32
#define	SUNI_REGM_RPOPPIS_ILLJREQI	0x80
#define	SUNI_REGM_RPOPPIS_DISCOPAI	0x20
#define	SUNI_REGM_RPOPPIS_INVNDFI	0x10
#define	SUNI_REGM_RPOPPIS_ILLPTRI	0x08
#define	SUNI_REGM_RPOPPIS_NSEI		0x04
#define	SUNI_REGM_RPOPPIS_PSEI		0x02
#define	SUNI_REGM_RPOPPIS_NDFI		0x01
#define	SUNI_REGX_RPOPPIS	"\020\10ILLJREQI\6DISCOPAI\5INVNDFI\4ILLPTRI\3NSEI\2PSEI\1NDFI"

/* lite, ultra, 622 */
#define	SUNI_REGN_RPOPIEN	"RPOP Interrupt Enable"
#define	SUNI_REGO_RPOPIEN		0x33
#define	SUNI_REGM_RPOPIEN_PSLE		0x80
#define	SUNI_REGM_RPOPIEN_LOPE		0x20
#define	SUNI_REGM_RPOPIEN_PAISE		0x08
#define	SUNI_REGM_RPOPIEN_PRDIE		0x04
#define	SUNI_REGM_RPOPIEN_BIPEE		0x02
#define	SUNI_REGM_RPOPIEN_FEBEE		0x01
#define	SUNI_REGM_RPOPIEN_RESERVED	0x00
#define	SUNI_REGX_RPOPIEN	"\02010PSLE\6LOPE\4PAISE\3PRDIE\2BIPEE\1FEBEE"

/* 622 */
#define	SUNI_REGN_RPOPPIE	"RPOP Pointer Interrupt Enable"
#define	SUNI_REGO_RPOPPIE		0x34
#define	SUNI_REGM_RPOPPIE_ILLJREQE	0x80
#define	SUNI_REGM_RPOPPIE_DISCOPAE	0x20
#define	SUNI_REGM_RPOPPIE_INVNDFE	0x10
#define	SUNI_REGM_RPOPPIE_ILLPTRE	0x08
#define	SUNI_REGM_RPOPPIE_NSEE		0x04
#define	SUNI_REGM_RPOPPIE_PSEE		0x02
#define	SUNI_REGM_RPOPPIE_NDFE		0x01
#define	SUNI_REGX_RPOPPIE	"\020\10ILLJREQE\6DISCOPAE\5INVNDFE\4ILLPTRE\3NSEE\2PSEE\1NDFE"

/* 622 */
#define	SUNI_REGN_RPOPPTR	"RPOP Pointer"
#define	SUNI_REGO_RPOPPTR		0x35	/* +36 */
#define	SUNI_REGM_RPOPPTR_RDI10		0x20
#define	SUNI_REGM_RPOPPTR_S		0x0c
#define	SUNI_REGS_RPOPPTR_S		2
#define	SUNI_REGM_RPOPPTR		0x03
#define	SUNI_REGS_RPOPPTR		0
#define	SUNI_REGX_RPOPPTR		"\020\6RDI10\12\xc\20S"

/* lite, ultra, 622 */
#define	SUNI_REGN_RPOPPSL "RPOP Path Signal Label"
#define	SUNI_REGO_RPOPPSL		0x37

/* lite, ultra, 622 */
#define	SUNI_REGN_RPOPBIP8 "RPOP Path BIP-8"
#define	SUNI_REGO_RPOPBIP8		0x38	/* +39 */

/* lite, ultra, 622 */
#define	SUNI_REGN_RPOPFEBE "RPOP Path FEBE"
#define	SUNI_REGO_RPOPFEBE		0x3A	/* +3B */

/* 622 */
#define	SUNI_REGN_RPOPRDI	"RPOP RDI"
#define	SUNI_REGO_RPOPRDI		0x3C
#define	SUNI_REGM_RPOPRDI_BLKFEBE	0x10
#define	SUNI_REGM_RPOPRDI_ARDIE		0x02
#define	SUNI_REGM_RPOPRDI_ARDIV		0x01
#define	SUNI_REGM_RPOPRDI_RESERVED	0x00
#define	SUNI_REGX_RPOPRDI	"\020\5BLKFEBE\2ARDIE\1ARDIV"

/* lite, ultra */
#define	SUNI_REGN_RPOPBIP8CFG 	"RPOP Path BIP-8 Configuration"
#define	SUNI_REGO_RPOPBIP8CFG		0x3D
#define	SUNI_REGM_RPOPBIP8CFG_BLKBIP	0x20
#define	SUNI_REGM_RPOPBIP8CFG_RESERVED	0x00
#define	SUNI_REGX_RPOPBIP8CFG 	"\020\6BLKBIP"

/* 622 */
#define	SUNI_REGN_RPOPRING	"RPOP Ring Control"
#define	SUNI_REGO_RPOPRING		0x3D
#define	SUNI_REGM_RPOPRING_SOS		0x80
#define	SUNI_REGM_RPOPRING_ENSS		0x40
#define	SUNI_REGM_RPOPRING_BLKBIP	0x20
#define	SUNI_REGM_RPOPRING_DISFS	0x10
#define	SUNI_REGM_RPOPRING_BLKBIPO	0x08
#define	SUNI_REGM_RPOPRING_RESERVED	0x00
#define	SUNI_REGX_RPOPRING	"\020\10SOS\7ENSS\6BLKBIP\5DISFS\4BLKBIPO"

/* lite, ultra, 622 */
#define	SUNI_REGN_TPOPCTRL	"TPOP Control/Diagnostic"
#define	SUNI_REGO_TPOPCTRL		0x40
#define	SUNI_REGM_TPOPCTRL_EXCFS	0x80	/* 622 */
#define	SUNI_REGM_TPOPCTRL_DB3		0x02
#define	SUNI_REGM_TPOPCTRL_PAIS		0x01
#define	SUNI_REGM_TPOPCTRL_RESERVED	0x00
#define	SUNI_REGX_TPOPCTRL	"\020\2DB3\1PAIS"
#define	SUNI_REGX_TPOPCTRL_622	"\020\4EXCFS\2DB3\1PAIS"

/* lite, ultra, 622 */
#define	SUNI_REGN_TPOPPTRC "TPOP Pointer Control"
#define	SUNI_REGO_TPOPPTRC		0x41
#define	SUNI_REGM_TPOPPTRC_FTPTR	0x40
#define	SUNI_REGM_TPOPPTRC_SOS		0x20
#define	SUNI_REGM_TPOPPTRC_PLD		0x10
#define	SUNI_REGM_TPOPPTRC_NDF		0x08
#define	SUNI_REGM_TPOPPTRC_NSE		0x04
#define	SUNI_REGM_TPOPPTRC_PSE		0x02
#define	SUNI_REGM_TPOPPTRC_RESERVED	0x00
#define	SUNI_REGX_TPOPPTRC "\020\7FTPTR\6SOS\5PLD\4NDF\3NSE\2PSE"

/* 622 */
#define	SUNI_REGN_TPOPCP	"TPOP Current Pointer"
#define	SUNI_REGO_TPOPCP		0x43	/* +44 */
#define	SUNI_REGM_TPOPCP		0x03
#define	SUNI_REGS_TPOPCP		0
#define	SUNI_REGX_TPOPCP	"\020"

/* lite, ultra, 622 */
#define	SUNI_REGN_TPOPAPTR 	"TPOP Arbitrary Pointer"
#define	SUNI_REGO_TPOPAPTR		0x45	/* +46 */
#define	SUNI_REGM_TPOPAPTR_NDF		0xF0
#define	SUNI_REGS_TPOPAPTR_NDF		4
#define	SUNI_REGM_TPOPAPTR_S		0x0C
#define	SUNI_REGS_TPOPAPTR_S		2
#define	SUNI_REGM_TPOPAPTR		0x03
#define	SUNI_REGS_TPOPAPTR		0
#define	SUNI_REGX_TPOPAPTR	"\020\12\x0C\12S\12\xF0\12NDF"

#define	SUNI_REGM_SONET			0
#define	SUNI_REGM_SDH			2

/* 622 */
#define	SUNI_REGN_TPOPPT	"TPOP Path Trace"
#define	SUNI_REGO_TPOPPT		0x47

/* lite, ultra, 622 */
#define	SUNI_REGN_TPOPPSL	"TPOP Path Signal Label"
#define	SUNI_REGO_TPOPPSL		0x48

/* lite, ultra, 622 */
#define	SUNI_REGN_TPOPSTATUS "TPOP Path Status"
#define	SUNI_REGO_TPOPSTATUS		0x49
#define	SUNI_REGM_TPOPSTATUS_FEBE	0xF0
#define	SUNI_REGS_TPOPSTATUS_FEBE	4
#define	SUNI_REGM_TPOPSTATUS_PRDI	0x08
#define	SUNI_REGM_TPOPSTATUS_G1		0x07
#define	SUNI_REGS_TPOPSTATUS_G1		0
#define	SUNI_REGX_TPOPSTATUS "\020\12\xF0\12FEBE\4PRDI\12\x7\12G"

/* 622 */
#define	SUNI_REGN_TPOPPUC	"TPOP Path User Channel"
#define	SUNI_REGO_TPOPPUC		0x4A

/* 622 */
#define	SUNI_REGN_TPOPPG1	"TPOP Path Grow #1"
#define	SUNI_REGO_TPOPPG1		0x4B

/* 622 */
#define	SUNI_REGN_TPOPPG2	"TPOP Path Grow #2"
#define	SUNI_REGO_TPOPPG2		0x4C

/* 622 */
#define	SUNI_REGN_TPOPPG3	"TPOP Path Grow #3"
#define	SUNI_REGO_TPOPPG3		0x4D

/* lite, ultra, 622 */
#define	SUNI_REGN_RACPCTRL	"RACP Control/Status"
#define	SUNI_REGO_RACPCTRL		0x50
#define	SUNI_REGM_RACPCTRL_OOCDV	0x80
#define	SUNI_REGM_RACPCTRL_FSEN		0x80
#define	SUNI_REGM_RACPCTRL_RXPTYP	0x40
#define	SUNI_REGM_RACPCTRL_PASS		0x20
#define	SUNI_REGM_RACPCTRL_DISCOR	0x10
#define	SUNI_REGM_RACPCTRL_HCSPASS	0x08
#define	SUNI_REGM_RACPCTRL_HCSADD	0x04
#define	SUNI_REGM_RACPCTRL_DDSCR	0x02
#define	SUNI_REGM_RACPCTRL_FIFORST	0x01
#define	SUNI_REGX_RACPCTRL	"\020\10OOCDV\7RXPTYP\6PASS\5DISCO\4HCSPASS\3HCSADD\2DDSCR\1FIFORST"
#define	SUNI_REGX_RACPCTRL_622	"\020\10FSEN\7RXPTYP\6PASS\5DISCO\4HCSPASS\3HCSADD\2DDSCR\1FIFORST"

/* lite, ultra */
#define	SUNI_REGN_RACPINTR "RACP Interrupt Enable/Status"
#define	SUNI_REGO_RACPINTR		0x51
#define	SUNI_REGM_RACPINTR_OOCDE	0x80
#define	SUNI_REGM_RACPINTR_HCSE		0x40
#define	SUNI_REGM_RACPINTR_FIFOE	0x20
#define	SUNI_REGM_RACPINTR_OOCDI	0x10
#define	SUNI_REGM_RACPINTR_CHCSI	0x08
#define	SUNI_REGM_RACPINTR_UHCSI	0x04
#define	SUNI_REGM_RACPINTR_FOVRI	0x02
#define	SUNI_REGX_RACPINTR "\020\10OOCDE\7HCSE\6FIFOE\5OOCDI\4CHCSI\3UHCSI\2FOVRI"

/* 622 */
#define	SUNI_REGN_RACPIS	"RACP Interrupt Status"
#define	SUNI_REGO_RACPIS		0x51
#define	SUNI_REGM_RACPIS_OCDV		0x80
#define	SUNI_REGM_RACPIS_LCDV		0x40
#define	SUNI_REGM_RACPIS_OCDI		0x20
#define	SUNI_REGM_RACPIS_LCDI		0x10
#define	SUNI_REGM_RACPIS_CHCSI		0x08
#define	SUNI_REGM_RACPIS_UHCSI		0x04
#define	SUNI_REGM_RACPIS_FOVRI		0x02
#define	SUNI_REGM_RACPIS_FUDRI		0x01
#define	SUNI_REGX_RACPIS	"\020\10OCDV\7LCDV\6OCDI\5LCDI\4CHCSI\3UHCSI\2FOVRI\1FUDRI"

/* lite, ultra */
#define	SUNI_REGN_RACPPATTERN "RACP Match Header Pattern"
#define	SUNI_REGO_RACPPATTERN		0x52
#define	SUNI_REGM_RACPPATTERN_GFC	0xF0
#define	SUNI_REGS_RACPPATTERN_GFC	4
#define	SUNI_REGM_RACPPATTERN_PTI	0x0E
#define	SUNI_REGS_RACPPATTERN_PTI	1
#define	SUNI_REGM_RACPPATTERN_CLP	0x01
#define	SUNI_REGS_RACPPATTERN_CLP	0
#define	SUNI_REGX_RACPPATTERN "\020\12\xF0\12GFC\12\x0E\12PTI\1CLP"

/* 622 */
#define	SUNI_REGN_RACPIEC	"RACP Interrupt Enable/Control"
#define	SUNI_REGO_RACPIEC		0x52
#define	SUNI_REGM_RACPIEC_OCDE		0x80
#define	SUNI_REGM_RACPIEC_LCDE		0x40
#define	SUNI_REGM_RACPIEC_HCSE		0x20
#define	SUNI_REGM_RACPIEC_FIFOE		0x10
#define	SUNI_REGM_RACPIEC_LCDDROP	0x08
#define	SUNI_REGM_RACPIEC_RCALEVEL0	0x04
#define	SUNI_REGM_RACPIEC_HCSFTR	0x03
#define	SUNI_REGX_RACPIEC	"\020\10OCDE\7LCDE\6HCSE\5FIFOE\4LCDDROP\3RCALEVEL0\12\0x3\12HCSFTR"

/* lite, ultra */
#define	SUNI_REGN_RACPMASK "RACP Match Header Mask"
#define	SUNI_REGO_RACPMASK		0x53
#define	SUNI_REGM_RACPMASK_MGFC		0xF0
#define	SUNI_REGS_RACPMASK_MGFC		4
#define	SUNI_REGM_RACPMASK_MPTI		0x0E
#define	SUNI_REGS_RACPMASK_MPTI		1
#define	SUNI_REGM_RACPMASK_MCLP		0x01
#define	SUNI_REGS_RACPMASK_MCLP		0
#define	SUNI_REGX_RACPMASK "\020\12\xF0\12MGFC\12\x0E\12MPTI\1MCLP"

/* 622 */
#define	SUNI_REGO_RACPPATTERN_622	0x53

/* lite, ultra */
#define	SUNI_REGN_RACPCHCS "RACP Correctable HCS Error Count"
#define	SUNI_REGO_RACPCHCS		0x54

/* 622 */
#define	SUNI_REGO_RACPMASK_622		0x54

/* lite, ultra */
#define	SUNI_REGN_RACPUHCS "RACP Uncorrectable HCS Error Count"
#define	SUNI_REGO_RACPUHCS		0x55

/* 622 */
#define	SUNI_REGO_RACPCHCS_622		0x55	/* +56 */
#define	SUNI_REGM_RACPCHCS_622		0x0f

/* lite, ultra */
#define	SUNI_REGN_RACPCNT "RACP Receive Cell Counter"
#define	SUNI_REGO_RACPCNT		0x56	/* +57,58 */
#define	SUNI_REGM_RACPCNT		0x07

/* 622 */
#define	SUNI_REGO_RACPUHCS_622		0x57	/* +58 */
#define	SUNI_REGM_RACPUHCS_622		0x0f

/* 622 */
#define	SUNI_REGO_RACPCNT_622		0x59	/* +5A,5B */
#define	SUNI_REGM_RACPCNT_622		0x1F

/* lite, ultra */
#define	SUNI_REGN_RACPCFG "RACP Configuration"
#define	SUNI_REGO_RACPCFG		0x59
#define	SUNI_REGM_RACPCFG_RGFCE		0xF0
#define	SUNI_REGS_RACPCFG_RGFCE		4
#define	SUNI_REGM_RACPCFG_FSEN		0x08
#define	SUNI_REGM_RACPCFG_LEVEL0	0x04
#define	SUNI_REGM_RACPCFG_HCSFTR	0x03
#define	SUNI_REGS_RACPCFG_HCSFTR	0
#define	SUNI_REGX_RACPCFG "\020\12\xF0\20RGFCE\4FSEN\3RCALEVEL0\12\x03\12HCSFTR"

/* 622 */
#define	SUNI_REGN_RACPGFC	"RACP GFC Control/Misc. Control"
#define	SUNI_REGO_RACPGFC		0x5C
#define	SUNI_REGM_RACPGFC_CDDIS		0x80
#define	SUNI_REGM_RACPGFC_RXBYTEPRTY	0x40
#define	SUNI_REGM_RACPGFC_RGFCE		0x0f
#define	SUNI_REGX_RACPGFC	"\020\10CDDIS\7RXBYTEPRTY\12\xf\20"

/* lite, ultra, 622 */
#define	SUNI_REGN_TACPCTRL "TACP Control/Status"
#define	SUNI_REGO_TACPCTRL		0x60
#define	SUNI_REGM_TACPCTRL_FIFOE	0x80
#define	SUNI_REGM_TACPCTRL_TSOCI	0x40
#define	SUNI_REGM_TACPCTRL_FOVRI	0x20
#define	SUNI_REGM_TACPCTRL_DHCS		0x10
#define	SUNI_REGM_TACPCTRL_HCSB		0x08	/* ultra, 622 */
#define	SUNI_REGM_TACPCTRL_HCSADD	0x04
#define	SUNI_REGM_TACPCTRL_DSCR		0x02
#define	SUNI_REGM_TACPCTRL_FIFORST	0x01
#define	SUNI_REGX_TACPCTRL_LITE		"\020\10FIFOE\7TSOCI\6FOVRI\5DHCS\3HCSADD\2DSCR\1FIFORST"
#define	SUNI_REGX_TACPCTRL_ULTRA	"\020\10FIFOE\7TSOCI\6FOVRI\5DHCS\4HCSB\3HCSADD\2DSCR\1FIFORST"
#define	SUNI_REGX_TACPCTRL_622		"\020\10FIFOE\7TSOCI\6FOVRI\5DHCS\4HCSB\3HCSADD\2DSCR\1FIFORST"

/* lite, ultra, 622 */
#define	SUNI_REGN_TACPIDLEH 	"TACP Idle/Unassigned Cell Header Pattern"
#define	SUNI_REGO_TACPIDLEH		0x61
#define	SUNI_REGM_TACPIDLEH_GFC		0xF0
#define	SUNI_REGS_TACPIDLEH_GFC		4
#define	SUNI_REGM_TACPIDLEH_PTI		0x0E
#define	SUNI_REGS_TACPIDLEH_PTI		1
#define	SUNI_REGM_TACPIDLEH_CLP		0x01
#define	SUNI_REGS_TACPIDLEH_CLP		0
#define	SUNI_REGX_TACPIDLEH 	"\020\12\xF0\20GFC\12\x0E\20PTI\12\x01\20CLP"

/* lite, ultra, 622 */
#define	SUNI_REGN_TACPIDLEP "TACP Idle/Unassigned Cell Payload Octet Pattern"
#define	SUNI_REGO_TACPIDLEP		0x62

/* lite, ultra, 622 */
#define	SUNI_REGN_TACPFIFOC		"TACP FIFO Control"
#define	SUNI_REGO_TACPFIFOC		0x63
#define	SUNI_REGM_TACPFIFOC_TXPTYP	0x80
#define	SUNI_REGM_TACPFIFOC_TXPRTYE	0x40
#define	SUNI_REGM_TACPFIFOC_TXPRTYI	0x10
#define	SUNI_REGM_TACPFIFOC_TXPRTYI_622	0x30
#define	SUNI_REGS_TACPFIFOC_TXPRTYI_622	4
#define	SUNI_REGM_TACPFIFOC_FIFODP	0x0C
#define	SUNI_REGS_TACPFIFOC_FIFODP	2
#define	SUNI_REGM_TACPFIFOC_TCALEVEL0	0x02
#define	SUNI_REGM_TACPFIFOC_HCSCTLEB	0x01
#define	SUNI_REGM_TACPFIFOC_RESERVED	0x00
#define	SUNI_REGX_TACPFIFOC		"\020\10TXPTYP\7TXPRTYE\5TXPRTYI\12\x0C\20FIFODP\2TCALEVEL0"
#define	SUNI_REGX_TACPFIFOC_622		"\020\10TXPTYP\7TXPRTYE\12\x30\12TXPRTYI\12\x0C\20FIFODP\2TCALEVEL0\1HCSCTLEB"

/* lite, ultra, 622 */
#define	SUNI_REGN_TACPCNT "TACP Transmit Cell Counter"
#define	SUNI_REGO_TACPCNT		0x64	/* +65,66 */
#define	SUNI_REGM_TACPCNT		0x07
#define	SUNI_REGM_TACPCNT_622		0x1F

/* lite, ultra */
#define	SUNI_REGN_TACPCFG "TACP Configuration"
#define	SUNI_REGO_TACPCFG		0x67
#define	SUNI_REGM_TACPCFG_TGFCE		0xF0
#define	SUNI_REGS_TACPCFG_TGFCE		4
#define	SUNI_REGM_TACPCFG_FSEN		0x08
#define	SUNI_REGM_TACPCFG_H4INSB	0x04
#define	SUNI_REGM_TACPCFG_FIXBYTE	0x03
#define	SUNI_REGS_TACPCFG_FIXBYTE	0
#define	SUNI_REGX_TACPCFG "\020\12\xF0\20TGFCE\4FSEN\3H4INSB\12\x03\20FIXBYTE"

/* 622 */
#define	SUNI_REGN_TACPGFC	"TACP Fixed Stuff/GFC"
#define	SUNI_REGO_TACPGFC		0x67
#define	SUNI_REGO_TACPGFC_TGFCE		0xf0
#define	SUNI_REGS_TACPGFC_TGFCE		4
#define	SUNI_REGO_TACPGFC_FSEN		0x08
#define	SUNI_REGO_TACPGFC_TXBYTEPRTY	0x04
#define	SUNI_REGO_TACPGFC_FIXBYTE	0x03
#define	SUNI_REGS_TACPGFC_FIXBYTE	0
#define	SUNI_REGX_TACPGFC	"\020\12\xf0\20TGFCE\4FSEN\3TXBYTEPRTY\12\x3\20FIXBYTE"

/* 622 */
#define	SUNI_REGN_SPTBCTRL	"SPTB Control"
#define	SUNI_REGO_SPTBCTRL		0x68
#define	SUNI_REGO_SPTBCTRL_RRAMACC	0x40
#define	SUNI_REGO_SPTBCTRL_RTIUIE	0x20
#define	SUNI_REGO_SPTBCTRL_RTIMIE	0x10
#define	SUNI_REGO_SPTBCTRL_PER5		0x08
#define	SUNI_REGO_SPTBCTRL_TNULL	0x04
#define	SUNI_REGO_SPTBCTRL_NOSYNC	0x02
#define	SUNI_REGO_SPTBCTRL_LEN16	0x01
#define	SUNI_REGX_SPTBCTRL	"\020\7RRAMACC\6RTIUIE\5RTIMIE\4PER5\3TNULL\2NOSYNC\1LEN16"

/* 622 */
#define	SUNI_REGN_SPTBPTIS	"SPTB Path Trace Identifier Status"
#define	SUNI_REGO_SPTBPTIS		0x69
#define	SUNI_REGM_SPTBPTIS_BUSY		0x80
#define	SUNI_REGM_SPTBPTIS_RTIUI	0x08
#define	SUNI_REGM_SPTBPTIS_RTIUV	0x04
#define	SUNI_REGM_SPTBPTIS_RTIMI	0x02
#define	SUNI_REGM_SPTBPTIS_RTIMV	0x01
#define	SUNI_REGX_SPTBPTIS	"\020\10BUSY\4RTIUI\3RTIUV\2RTIMI\1RTIMV"

/* 622 */
#define	SUNI_REGN_SPTBIAR	"SPTB Indirect Address Register"
#define	SUNI_REGO_SPTBIAR		0x6A
#define	SUNI_REGM_SPTBIAR_RWB		0x80
#define	SUNI_REGM_SPTBIAR_A		0x7f
#define	SUNI_REGX_SPTBIAR	"\020\10RWB\12\x7f\20A"

/* 622 */
#define	SUNI_REGN_SPTBIDR	"SPTB Indirect Data Register"
#define	SUNI_REGO_SPTBIDR		0x6B

/* 622 */
#define	SUNI_REGN_SPTBEPSL	"SPTB Expected Path Signal Label"
#define	SUNI_REGO_SPTBEPSL		0x6C

/* 622 */
#define	SUNI_REGN_SPTBPSLS	"SPTB Path Signal Label Status"
#define	SUNI_REGO_SPTBPSLS		0x6D
#define	SUNI_REGM_SPTBPSLS_RPSLUIE	0x80
#define	SUNI_REGM_SPTBPSLS_RPSLMIE	0x40
#define	SUNI_REGM_SPTBPSLS_RPSLUI	0x08
#define	SUNI_REGM_SPTBPSLS_RPSLUV	0x04
#define	SUNI_REGM_SPTBPSLS_RPSLMI	0x02
#define	SUNI_REGM_SPTBPSLS_RPSLMV	0x01
#define	SUNI_REGX_SPTBPSLS	"\020\10RPSLUIE\7RPSLMIE\4RPSLUI\3RPSLUV\2RPSLMI\1RPSLMV"

/* ultra */
#define	SUNI_REGN_POPCCTRL "POPC Control"
#define	SUNI_REGO_POPCCTRL		0x68
#define	SUNI_REGM_POPCCTRL_PDAT		0xC0
#define	SUNI_REGS_POPCCTRL_PDAT		6
#define	SUNI_REGM_POPCCTRL_TOGGLE	0x30
#define	SUNI_REGS_POPCCTRL_TOGGLE	4
#define	SUNI_REGM_POPCCTRL_TRAFFIC	0x02
#define	SUNI_REGM_POPCCTRL_ALARM	0x01
#define	SUNI_REGX_POPCCTRL "\020\12\xC0\20PDAT\12\x30\20TOGGLE\2TRAFFIC\1ALARM"

/* ultra */
#define	SUNI_REGN_POPCSTROBE0 "POPC Strobe Rate 0"
#define	SUNI_REGO_POPCSTROBE0		0x69

/* ultra */
#define	SUNI_REGN_POPCSTROBE1 "POPC Strobe Rate 1"
#define	SUNI_REGO_POPCSTROBE1		0x6A

/* 622 */
#define	SUNI_REGN_BERMCTRL	"BERM Control"
#define	SUNI_REGO_BERMCTRL		0x70
#define	SUNI_REGM_BERMCTRL_BERTEN	0x80
#define	SUNI_REGM_BERMCTRL_BERIE	0x01
#define	SUNI_REGX_BERMCTRL	"\020\10BERTEN\1BERIE"

/* 622 */
#define	SUNI_REGN_BERMINT	"BERM Interrupt"
#define	SUNI_REGO_BERMINT		0x71
#define	SUNI_REGM_BERMINT_TST		0xf0
#define	SUNI_REGS_BERMINT_TST		4
#define	SUNI_REGM_BERMINT_BERI		0x01
#define	SUNI_REGX_BERMINT	"\020\12\xf0\20BERM_TST\1BERI"

/* 622 */
#define	SUNI_REGN_BERMLAP	"BERM Line BIP Accumulation Period"
#define	SUNI_REGO_BERMLAP		0x72	/* +73 */

/* 622 */
#define	SUNI_REGN_BERMLT	"BERM Line BIP Threshold"
#define	SUNI_REGO_BERMLT		0x74	/* +75 */

/* lite, ultra, 622 */
#define	SUNI_REGN_MTEST "Master Test"
#define	SUNI_REGO_MTEST			0x80
#define	SUNI_REGM_MTEST_DS27_53_622	0x80
#define	SUNI_REGM_MTEST_BYPASS_ULTRA	0x40
#define	SUNI_REGM_MTEST_PMCATST_ULTRA	0x20
#define	SUNI_REGM_MTEST_PMCTST		0x10
#define	SUNI_REGM_MTEST_DBCTRL		0x08
#define	SUNI_REGM_MTEST_IOTST		0x04
#define	SUNI_REGM_MTEST_HIZDATA		0x02
#define	SUNI_REGM_MTEST_HIZIO		0x01
#define	SUNI_REGX_MTEST_LITE	"\020\5PMCTST\4DBCTRL\3IOTST\2HIZDATA\1HIZIO"
#define	SUNI_REGX_MTEST_ULTRA	"\020\7BYPASS\6PMCATST\5PMCTST\4DBCTRL\3IOTST\2HIZDATA\1HIZIO"
#define	SUNI_REGX_MTEST_622	"\020\10DS27_53\5PMCTST\4DBCTRL\3IOTST\2HIZDATA\1HIZIO"

/*
 * Printing support
 */
#define	SUNI_PRINT_LITE							\
	{ /* 00 */							\
	  UTP_REGT_BITS,	SUNI_REGO_MRESET, 			\
	  SUNI_REGN_MRESET,	SUNI_REGX_MRESET_LITE },		\
	{ /* 01 */							\
	  UTP_REGT_BITS,	SUNI_REGO_MCONFIG,			\
	  SUNI_REGN_MCONFIG,	SUNI_REGX_MCONFIG_LITE },		\
	{ /* 02 */							\
	  UTP_REGT_BITS,	SUNI_REGO_MISTATUS,			\
	  SUNI_REGN_MISTATUS,	SUNI_REGX_MISTATUS_LITE },		\
	  /* 03 unused */						\
	{ /* 04 */							\
	  UTP_REGT_BITS,	SUNI_REGO_MCLKM,			\
	  SUNI_REGN_MCLKM,	SUNI_REGX_MCLKM_LITE },			\
	{ /* 05 */							\
	  UTP_REGT_BITS,	SUNI_REGO_MCTRL,			\
	  SUNI_REGN_MCTRL,	SUNI_REGX_MCTRL_LITE },			\
	{ /* 06 */							\
	  UTP_REGT_BITS,	SUNI_REGO_CLKSYN,			\
	  SUNI_REGN_CLKSYN,	SUNI_REGX_CLKSYN_LITE },		\
	{ /* 07 */							\
	  UTP_REGT_BITS,	SUNI_REGO_CLKREC_LITE,			\
	  SUNI_REGN_CLKREC,	SUNI_REGX_CLKREC_LITE },		\
	  /* 08-0F unused */						\
	{ /* 10 */							\
	  UTP_REGT_BITS,	SUNI_REGO_RSOPCIE,			\
	  SUNI_REGN_RSOPCIE,	SUNI_REGX_RSOPCIE },			\
	{ /* 11 */							\
	  UTP_REGT_BITS,	SUNI_REGO_RSOPSIS,			\
	  SUNI_REGN_RSOPSIS,	SUNI_REGX_RSOPSIS },			\
	{ /* 12, 13 */							\
	  UTP_REGT_INT16,	SUNI_REGO_RSOP_BIP8,			\
	  SUNI_REGN_RSOP_BIP8,	NULL },					\
	{ /* 14 */							\
	  UTP_REGT_BITS,	SUNI_REGO_TSOPCTRL,			\
	  SUNI_REGN_TSOPCTRL,	SUNI_REGX_TSOPCTRL },			\
	{ /* 15 */							\
	  UTP_REGT_BITS,	SUNI_REGO_TSOPDIAG,			\
	  SUNI_REGN_TSOPDIAG,	SUNI_REGX_TSOPDIAG },			\
	  /* 16-17 unused */						\
	{ /* 18 */							\
	  UTP_REGT_BITS,	SUNI_REGO_RLOPCTRL,			\
	  SUNI_REGN_RLOPCTRL,	SUNI_REGX_RLOPCTRL },			\
	{ /* 19 */							\
	  UTP_REGT_BITS,	SUNI_REGO_RLOPINTR,			\
	  SUNI_REGN_RLOPINTR,	SUNI_REGX_RLOPINTR },			\
	{ /* 1A, 1B, 1C */						\
	  UTP_REGT_INT20,	SUNI_REGO_RLOPBIP8_24,			\
	  SUNI_REGN_RLOPBIP8_24, NULL },				\
	{ /* 1D, 1E, 1F */						\
	  UTP_REGT_INT20,	SUNI_REGO_RLOPFEBE,			\
	  SUNI_REGN_RLOPFEBE,	NULL },					\
	{ /* 20 */							\
	  UTP_REGT_BITS,	SUNI_REGO_TLOPCTRL,			\
	  SUNI_REGN_TLOPCTRL,	SUNI_REGX_TLOPCTRL },			\
	{ /* 21 */							\
	  UTP_REGT_BITS,	SUNI_REGO_TLOPDIAG,			\
	  SUNI_REGN_TLOPDIAG,	SUNI_REGX_TLOPDIAG },			\
	  /* 22-2F unused */						\
	{ /* 30 */							\
	  UTP_REGT_BITS,	SUNI_REGO_RPOPCTRL,			\
	  SUNI_REGN_RPOPCTRL,	SUNI_REGX_RPOPCTRL },			\
	{ /* 31 */							\
	  UTP_REGT_BITS,	SUNI_REGO_RPOPISTAT,			\
	  SUNI_REGN_RPOPISTAT,	SUNI_REGX_RPOPISTAT },			\
	  /* 32 unused */						\
	{ /* 33 */							\
	  UTP_REGT_BITS,	SUNI_REGO_RPOPIEN,			\
	  SUNI_REGN_RPOPIEN,	SUNI_REGX_RPOPIEN },			\
	  /* 34-36 unused */						\
	{ /* 37 */							\
	  UTP_REGT_INT8,	SUNI_REGO_RPOPPSL,			\
	  SUNI_REGN_RPOPPSL,	NULL },					\
	{ /* 38, 39 */							\
	  UTP_REGT_INT16,	SUNI_REGO_RPOPBIP8,			\
	  SUNI_REGN_RPOPBIP8,	NULL },					\
	{ /* 3A, 3B */							\
	  UTP_REGT_INT16,	SUNI_REGO_RPOPFEBE,			\
	  SUNI_REGN_RPOPFEBE,	NULL },					\
	  /* 3C unused */						\
	{ /* 3D */							\
	  UTP_REGT_BITS,	SUNI_REGO_RPOPBIP8CFG,			\
	  SUNI_REGN_RPOPBIP8CFG, SUNI_REGX_RPOPBIP8CFG },		\
	  /* 3E-3F unused */						\
	{ /* 40 */							\
	  UTP_REGT_BITS,	SUNI_REGO_TPOPCTRL,			\
	  SUNI_REGN_TPOPCTRL,	SUNI_REGX_TPOPCTRL },			\
	{ /* 41 */							\
	  UTP_REGT_BITS,	SUNI_REGO_TPOPPTRC,			\
	  SUNI_REGN_TPOPPTRC,	SUNI_REGX_TPOPPTRC },			\
	  /* 42-44 unused */						\
	{ /* 45, 46 */							\
	  UTP_REGT_INT10BITS,	SUNI_REGO_TPOPAPTR,			\
	  SUNI_REGN_TPOPAPTR,	SUNI_REGX_TPOPAPTR },			\
	  /* 47 unused */						\
	{ /* 48 */							\
	  UTP_REGT_INT8,	SUNI_REGO_TPOPPSL,			\
	  SUNI_REGN_TPOPPSL,	NULL },					\
	{ /* 49 */							\
	  UTP_REGT_BITS,	SUNI_REGO_TPOPSTATUS,			\
	  SUNI_REGN_TPOPSTATUS,	SUNI_REGX_TPOPSTATUS },			\
	  /* 4A-4F unused */						\
	{ /* 50 */							\
	  UTP_REGT_BITS,	SUNI_REGO_RACPCTRL,			\
	  SUNI_REGN_RACPCTRL,	SUNI_REGX_RACPCTRL },			\
	{ /* 51 */							\
	  UTP_REGT_BITS,	SUNI_REGO_RACPINTR,			\
	  SUNI_REGN_RACPINTR,	SUNI_REGX_RACPINTR },			\
	{ /* 52 */							\
	  UTP_REGT_BITS,	SUNI_REGO_RACPPATTERN,			\
	  SUNI_REGN_RACPPATTERN, SUNI_REGX_RACPPATTERN },		\
	{ /* 53 */							\
	  UTP_REGT_BITS,	SUNI_REGO_RACPMASK,			\
	  SUNI_REGN_RACPMASK,	SUNI_REGX_RACPMASK },			\
	{ /* 54 */							\
	  UTP_REGT_INT8,	SUNI_REGO_RACPCHCS,			\
	  SUNI_REGN_RACPCHCS,	NULL },					\
	{ /* 55 */							\
	  UTP_REGT_INT8,	SUNI_REGO_RACPUHCS,			\
	  SUNI_REGN_RACPUHCS,	NULL },					\
	{ /* 56, 57, 58 */						\
	  UTP_REGT_INT19,	SUNI_REGO_RACPCNT,			\
	  SUNI_REGN_RACPCNT,	NULL },					\
	{ /* 59 */							\
	  UTP_REGT_BITS,	SUNI_REGO_RACPCFG,			\
	  SUNI_REGN_RACPCFG,	SUNI_REGX_RACPCFG },			\
	  /* 5A-5F unused */						\
	{ /* 60 */							\
	  UTP_REGT_BITS,	SUNI_REGO_TACPCTRL,			\
	  SUNI_REGN_TACPCTRL,	SUNI_REGX_TACPCTRL_LITE },		\
	{ /* 61 */							\
	  UTP_REGT_BITS,	SUNI_REGO_TACPIDLEH,			\
	  SUNI_REGN_TACPIDLEH,	SUNI_REGX_TACPIDLEH },			\
	{ /* 62 */							\
	  UTP_REGT_INT8,	SUNI_REGO_TACPIDLEP,			\
	  SUNI_REGN_TACPIDLEP,	NULL },					\
	{ /* 63 */							\
	  UTP_REGT_BITS,	SUNI_REGO_TACPFIFOC,			\
	  SUNI_REGN_TACPFIFOC,	SUNI_REGX_TACPFIFOC },			\
	{ /* 64, 65, 66 */						\
	  UTP_REGT_INT19,	SUNI_REGO_TACPCNT,			\
	  SUNI_REGN_TACPCNT,	NULL },					\
	{ /* 67 */							\
	  UTP_REGT_BITS,	SUNI_REGO_TACPGFC,			\
	  SUNI_REGN_TACPGFC,	SUNI_REGX_TACPGFC },			\
	  /* 68-7f unused */						\
	{ /* 80 */							\
	  UTP_REGT_BITS,	SUNI_REGO_MTEST,			\
	  SUNI_REGN_MTEST,	SUNI_REGX_MTEST_LITE }

#define	SUNI_PRINT_ULTRA						\
	{ /* 00 */							\
	  UTP_REGT_BITS,	SUNI_REGO_MRESET, 			\
	  SUNI_REGN_MRESET,	SUNI_REGX_MRESET_ULTRA },		\
	{ /* 01 */							\
	  UTP_REGT_BITS,	SUNI_REGO_MCONFIG,			\
	  SUNI_REGN_MCONFIG,	SUNI_REGX_MCONFIG_ULTRA },		\
	{ /* 02 */							\
	  UTP_REGT_BITS,	SUNI_REGO_MISTATUS,			\
	  SUNI_REGN_MISTATUS,	SUNI_REGX_MISTATUS_ULTRA },		\
	{ /* 03 */							\
	  UTP_REGT_BITS,	SUNI_REGO_MMCTRL,			\
	  SUNI_REGN_MMCTRL,	SUNI_REGX_MMCTRL },			\
	{ /* 04 */							\
	  UTP_REGT_BITS,	SUNI_REGO_MCLKM,			\
	  SUNI_REGN_MCLKM,	SUNI_REGX_MCLKM_ULTRA },		\
	{ /* 05 */							\
	  UTP_REGT_BITS,	SUNI_REGO_MCTRL,			\
	  SUNI_REGN_MCTRL,	SUNI_REGX_MCTRL_ULTRA },		\
	{ /* 06 */							\
	  UTP_REGT_BITS,	SUNI_REGO_CLKSYN,			\
	  SUNI_REGN_CLKSYN,	SUNI_REGX_CLKSYN_ULTRA },		\
	  /* 07 unused */						\
	{ /* 08 */							\
	  UTP_REGT_BITS,	SUNI_REGO_CLKREC_ULTRA,			\
	  SUNI_REGN_CLKREC,	SUNI_REGX_CLKREC_ULTRA },		\
	{ /* 09 */							\
	  UTP_REGT_BITS,	SUNI_REGO_CLKRECCFG,			\
	  SUNI_REGN_CLKRECCFG,	SUNI_REGX_CLKRECCFG },			\
	{ /* 0A */							\
	  UTP_REGT_BITS,	SUNI_REGO_LTXCFG1,			\
	  SUNI_REGN_LTXCFG1,	SUNI_REGX_LTXCFG1 },			\
	{ /* 0B */							\
	  UTP_REGT_BITS,	SUNI_REGO_LTXCFG2,			\
	  SUNI_REGN_LTXCFG2,	SUNI_REGX_LTXCFG2 },			\
	{ /* 0C */							\
	  UTP_REGT_BITS,	SUNI_REGO_LRXCFG,			\
	  SUNI_REGN_LRXCFG,	SUNI_REGX_LRXCFG },			\
	  /* 0D-0F unused */						\
	{ /* 10 */							\
	  UTP_REGT_BITS,	SUNI_REGO_RSOPCIE,			\
	  SUNI_REGN_RSOPCIE,	SUNI_REGX_RSOPCIE },			\
	{ /* 11 */							\
	  UTP_REGT_BITS,	SUNI_REGO_RSOPSIS,			\
	  SUNI_REGN_RSOPSIS,	SUNI_REGX_RSOPSIS },			\
	{ /* 12, 13 */							\
	  UTP_REGT_INT16,	SUNI_REGO_RSOP_BIP8,			\
	  SUNI_REGN_RSOP_BIP8,	NULL },					\
	{ /* 14 */							\
	  UTP_REGT_BITS,	SUNI_REGO_TSOPCTRL,			\
	  SUNI_REGN_TSOPCTRL,	SUNI_REGX_TSOPCTRL },			\
	{ /* 15 */							\
	  UTP_REGT_BITS,	SUNI_REGO_TSOPDIAG,			\
	  SUNI_REGN_TSOPDIAG,	SUNI_REGX_TSOPDIAG },			\
	  /* 16-17 unused */						\
	{ /* 18 */							\
	  UTP_REGT_BITS,	SUNI_REGO_RLOPCTRL,			\
	  SUNI_REGN_RLOPCTRL,	SUNI_REGX_RLOPCTRL },			\
	{ /* 19 */							\
	  UTP_REGT_BITS,	SUNI_REGO_RLOPINTR,			\
	  SUNI_REGN_RLOPINTR,	SUNI_REGX_RLOPINTR },			\
	{ /* 1A, 1B, 1C */						\
	  UTP_REGT_INT20,	SUNI_REGO_RLOPBIP8_24,			\
	  SUNI_REGN_RLOPBIP8_24, NULL },				\
	{ /* 1D, 1E, 1F */						\
	  UTP_REGT_INT20,	SUNI_REGO_RLOPFEBE,			\
	  SUNI_REGN_RLOPFEBE,	NULL },					\
	{ /* 20 */							\
	  UTP_REGT_BITS,	SUNI_REGO_TLOPCTRL,			\
	  SUNI_REGN_TLOPCTRL,	SUNI_REGX_TLOPCTRL },			\
	{ /* 21 */							\
	  UTP_REGT_BITS,	SUNI_REGO_TLOPDIAG,			\
	  SUNI_REGN_TLOPDIAG,	SUNI_REGX_TLOPDIAG },			\
	  /* 22-2F unused */						\
	{ /* 30 */							\
	  UTP_REGT_BITS,	SUNI_REGO_RPOPCTRL,			\
	  SUNI_REGN_RPOPCTRL,	SUNI_REGX_RPOPCTRL },			\
	{ /* 31 */							\
	  UTP_REGT_BITS,	SUNI_REGO_RPOPISTAT,			\
	  SUNI_REGN_RPOPISTAT,	SUNI_REGX_RPOPISTAT },			\
	  /* 32 unused */						\
	{ /* 33 */							\
	  UTP_REGT_BITS,	SUNI_REGO_RPOPIEN,			\
	  SUNI_REGN_RPOPIEN,	SUNI_REGX_RPOPIEN },			\
	  /* 34-36 unused */						\
	{ /* 37 */							\
	  UTP_REGT_INT8,	SUNI_REGO_RPOPPSL,			\
	  SUNI_REGN_RPOPPSL,	NULL },					\
	{ /* 38, 39 */							\
	  UTP_REGT_INT16,	SUNI_REGO_RPOPBIP8,			\
	  SUNI_REGN_RPOPBIP8,	NULL },					\
	{ /* 3A, 3B */							\
	  UTP_REGT_INT16,	SUNI_REGO_RPOPFEBE,			\
	  SUNI_REGN_RPOPFEBE,	NULL },					\
	  /* 3C unused */						\
	{ /* 3D */							\
	  UTP_REGT_BITS,	SUNI_REGO_RPOPBIP8CFG,			\
	  SUNI_REGN_RPOPBIP8CFG, SUNI_REGX_RPOPBIP8CFG },		\
	  /* 3E-3F unused */						\
	{ /* 40 */							\
	  UTP_REGT_BITS,	SUNI_REGO_TPOPCTRL,			\
	  SUNI_REGN_TPOPCTRL,	SUNI_REGX_TPOPCTRL },			\
	{ /* 41 */							\
	  UTP_REGT_BITS,	SUNI_REGO_TPOPPTRC,			\
	  SUNI_REGN_TPOPPTRC,	SUNI_REGX_TPOPPTRC },			\
	  /* 42-44 unused */						\
	{ /* 45, 46 */							\
	  UTP_REGT_INT10BITS,	SUNI_REGO_TPOPAPTR,			\
	  SUNI_REGN_TPOPAPTR,	SUNI_REGX_TPOPAPTR },			\
	  /* 47 unused */						\
	{ /* 48 */							\
	  UTP_REGT_INT8,	SUNI_REGO_TPOPPSL,			\
	  SUNI_REGN_TPOPPSL,	NULL },					\
	{ /* 49 */							\
	  UTP_REGT_BITS,	SUNI_REGO_TPOPSTATUS,			\
	  SUNI_REGN_TPOPSTATUS,	SUNI_REGX_TPOPSTATUS },			\
	  /* 4A-4F unused */						\
	{ /* 50 */							\
	  UTP_REGT_BITS,	SUNI_REGO_RACPCTRL,			\
	  SUNI_REGN_RACPCTRL,	SUNI_REGX_RACPCTRL },			\
	{ /* 51 */							\
	  UTP_REGT_BITS,	SUNI_REGO_RACPINTR,			\
	  SUNI_REGN_RACPINTR,	SUNI_REGX_RACPINTR },			\
	{ /* 52 */							\
	  UTP_REGT_BITS,	SUNI_REGO_RACPPATTERN,			\
	  SUNI_REGN_RACPPATTERN, SUNI_REGX_RACPPATTERN },		\
	{ /* 53 */							\
	  UTP_REGT_BITS,	SUNI_REGO_RACPMASK,			\
	  SUNI_REGN_RACPMASK,	SUNI_REGX_RACPMASK },			\
	{ /* 54 */							\
	  UTP_REGT_INT8,	SUNI_REGO_RACPCHCS,			\
	  SUNI_REGN_RACPCHCS,	NULL },					\
	{ /* 55 */							\
	  UTP_REGT_INT8,	SUNI_REGO_RACPUHCS,			\
	  SUNI_REGN_RACPUHCS,	NULL },					\
	{ /* 56, 57, 58 */						\
	  UTP_REGT_INT19,	SUNI_REGO_RACPCNT,			\
	  SUNI_REGN_RACPCNT,	NULL },					\
	{ /* 59 */							\
	  UTP_REGT_BITS,	SUNI_REGO_RACPCFG,			\
	  SUNI_REGN_RACPCFG,	SUNI_REGX_RACPCFG },			\
	  /* 5A-5F unused */						\
	{ /* 60 */							\
	  UTP_REGT_BITS,	SUNI_REGO_TACPCTRL,			\
	  SUNI_REGN_TACPCTRL,	SUNI_REGX_TACPCTRL_ULTRA },		\
	{ /* 61 */							\
	  UTP_REGT_BITS,	SUNI_REGO_TACPIDLEH,			\
	  SUNI_REGN_TACPIDLEH,	SUNI_REGX_TACPIDLEH },			\
	{ /* 62 */							\
	  UTP_REGT_INT8,	SUNI_REGO_TACPIDLEP,			\
	  SUNI_REGN_TACPIDLEP,	NULL },					\
	{ /* 63 */							\
	  UTP_REGT_BITS,	SUNI_REGO_TACPFIFOC,			\
	  SUNI_REGN_TACPFIFOC,	SUNI_REGX_TACPFIFOC },			\
	{ /* 64, 65, 66 */						\
	  UTP_REGT_INT19,	SUNI_REGO_TACPCNT,			\
	  SUNI_REGN_TACPCNT,	NULL },					\
	{ /* 67 */							\
	  UTP_REGT_BITS,	SUNI_REGO_TACPGFC,			\
	  SUNI_REGN_TACPGFC,	SUNI_REGX_TACPGFC },			\
	{ /* 68 */							\
	  UTP_REGT_BITS,	SUNI_REGO_POPCCTRL,			\
	  SUNI_REGN_POPCCTRL,	SUNI_REGX_POPCCTRL },			\
	{ /* 69 */							\
	  UTP_REGT_INT8,	SUNI_REGO_POPCSTROBE0,			\
	  SUNI_REGN_POPCSTROBE0, NULL },				\
	{ /* 6A */							\
	  UTP_REGT_INT8,	SUNI_REGO_POPCSTROBE1,			\
	  SUNI_REGN_POPCSTROBE1, NULL },				\
	  /* 6B-7f unused */						\
	{ /* 80 */							\
	  UTP_REGT_BITS,	SUNI_REGO_MTEST,			\
	  SUNI_REGN_MTEST,	SUNI_REGX_MTEST_ULTRA }

#define	SUNI_PRINT_622 							\
	{ /* 00 */							\
	  UTP_REGT_BITS,	SUNI_REGO_MRESET, 			\
	  SUNI_REGN_MRESET,	SUNI_REGX_MRESET_622 },			\
	{ /* 01 */							\
	  UTP_REGT_BITS,	SUNI_REGO_MCONFIG,			\
	  SUNI_REGN_MCONFIG,	SUNI_REGX_MCONFIG_622 },		\
	{ /* 02 */							\
	  UTP_REGT_BITS,	SUNI_REGO_MISTATUS,			\
	  SUNI_REGN_MISTATUS,	SUNI_REGX_MISTATUS_622 },		\
	{ /* 03 */							\
	  UTP_REGT_BITS,	SUNI_REGO_PISO, 			\
	  SUNI_REGN_PISO,	SUNI_REGX_PISO },			\
	{ /* 04 */							\
	  UTP_REGT_BITS,	SUNI_REGO_MCTRLM, 			\
	  SUNI_REGN_MCTRLM,	SUNI_REGX_MCTRLM },			\
	{ /* 05 */							\
	  UTP_REGT_BITS,	SUNI_REGO_MALARM,			\
	  SUNI_REGN_MALARM,	SUNI_REGX_MALARM },			\
	{ /* 06 */							\
	  UTP_REGT_BITS,	SUNI_REGO_POUT,				\
	  SUNI_REGN_POUT,	SUNI_REGX_POUT },			\
	{ /* 07 */							\
	  UTP_REGT_INT8,	SUNI_REGO_PIN,				\
	  SUNI_REGN_PIN,	NULL },					\
	{ /* 08 */							\
	  UTP_REGT_BITS,	SUNI_REGO_PINV,				\
	  SUNI_REGN_PINV,	SUNI_REGX_PINV },			\
	{ /* 09 */							\
	  UTP_REGT_INT8,	SUNI_REGO_PINE,				\
	  SUNI_REGN_PINE,	NULL },					\
	{ /* 0A */							\
	  UTP_REGT_INT8,	SUNI_REGO_XC1,				\
	  SUNI_REGN_XC1,	NULL },					\
	{ /* 0B */							\
	  UTP_REGT_BITS,	SUNI_REGO_APSCS,			\
	  SUNI_REGN_APSCS,	SUNI_REGX_APSCS },			\
	{ /* 0C */							\
	  UTP_REGT_INT8,	SUNI_REGO_RK1,				\
	  SUNI_REGN_RK1,	NULL },					\
	{ /* 0D */							\
	  UTP_REGT_INT8,	SUNI_REGO_RK2,				\
	  SUNI_REGN_RK2,	NULL },					\
	{ /* 0E */							\
	  UTP_REGT_INT8,	SUNI_REGO_RZ1,				\
	  SUNI_REGN_RZ1,	NULL },					\
	{ /* 0F */							\
	  UTP_REGT_INT8,	SUNI_REGO_XZ1,				\
	  SUNI_REGN_XZ1,	NULL },					\
	{ /* 10 */							\
	  UTP_REGT_BITS,	SUNI_REGO_RSOPCIE,			\
	  SUNI_REGN_RSOPCIE,	SUNI_REGX_RSOPCIE_622 },		\
	{ /* 11 */							\
	  UTP_REGT_BITS,	SUNI_REGO_RSOPSIS,			\
	  SUNI_REGN_RSOPSIS,	SUNI_REGX_RSOPSIS },			\
	{ /* 12, 13 */							\
	  UTP_REGT_INT16,	SUNI_REGO_RSOP_BIP8,			\
	  SUNI_REGN_RSOP_BIP8,	NULL },					\
	{ /* 14 */							\
	  UTP_REGT_BITS,	SUNI_REGO_TSOPCTRL,			\
	  SUNI_REGN_TSOPCTRL,	SUNI_REGX_TSOPCTRL },			\
	{ /* 15 */							\
	  UTP_REGT_BITS,	SUNI_REGO_TSOPDIAG,			\
	  SUNI_REGN_TSOPDIAG,	SUNI_REGX_TSOPDIAG },			\
	  /* 16-17 unused */						\
	{ /* 18 */							\
	  UTP_REGT_BITS,	SUNI_REGO_RLOPCTRL,			\
	  SUNI_REGN_RLOPCTRL,	SUNI_REGX_RLOPCTRL_622 },		\
	{ /* 19 */							\
	  UTP_REGT_BITS,	SUNI_REGO_RLOPINTR,			\
	  SUNI_REGN_RLOPINTR,	SUNI_REGX_RLOPINTR },			\
	{ /* 1A, 1B, 1C */						\
	  UTP_REGT_INT20,	SUNI_REGO_RLOPBIP8_24_96,		\
	  SUNI_REGN_RLOPBIP8_24_96, NULL },				\
	{ /* 1D, 1E, 1F */						\
	  UTP_REGT_INT20,	SUNI_REGO_RLOPFEBE,			\
	  SUNI_REGN_RLOPFEBE,	NULL },					\
	{ /* 20 */							\
	  UTP_REGT_BITS,	SUNI_REGO_TLOPCTRL,			\
	  SUNI_REGN_TLOPCTRL,	SUNI_REGX_TLOPCTRL_622 },		\
	{ /* 21 */							\
	  UTP_REGT_BITS,	SUNI_REGO_TLOPDIAG,			\
	  SUNI_REGN_TLOPDIAG,	SUNI_REGX_TLOPDIAG },			\
	{ /* 22 */							\
	  UTP_REGT_INT8,	SUNI_REGO_TLOP_XK1,			\
	  SUNI_REGN_TLOP_XK1,	NULL },					\
	{ /* 23 */							\
	  UTP_REGT_INT8,	SUNI_REGO_TLOP_XK2,			\
	  SUNI_REGN_TLOP_XK2,	NULL },					\
	  /* 24-27 unused */						\
	{ /* 28 */							\
	  UTP_REGT_BITS,	SUNI_REGO_SSTBCTRL,			\
	  SUNI_REGN_SSTBCTRL,	SUNI_REGX_SSTBCTRL },			\
	{ /* 29 */							\
	  UTP_REGT_BITS,	SUNI_REGO_SSTBSTIS,			\
	  SUNI_REGN_SSTBSTIS,	SUNI_REGX_SSTBSTIS },			\
	{ /* 2A */							\
	  UTP_REGT_BITS,	SUNI_REGO_SSTBIAR,			\
	  SUNI_REGN_SSTBIAR,	SUNI_REGX_SSTBIAR },			\
	{ /* 2B */							\
	  UTP_REGT_INT8,	SUNI_REGO_SSTBIDR,			\
	  SUNI_REGN_SSTBIDR,	NULL },					\
	  /* 2C unused (see chip errata) */				\
	{ /* 2D */							\
	  UTP_REGT_BITS,	SUNI_REGO_SSTBCSMS,			\
	  SUNI_REGN_SSTBCSMS,	SUNI_REGX_SSTBCSMS },			\
	  /* 2E-2F unused */						\
	{ /* 30 */							\
	  UTP_REGT_BITS,	SUNI_REGO_RPOPCTRL,			\
	  SUNI_REGN_RPOPCTRL,	SUNI_REGX_RPOPCTRL_622 },		\
	{ /* 31 */							\
	  UTP_REGT_BITS,	SUNI_REGO_RPOPISTAT,			\
	  SUNI_REGN_RPOPISTAT,	SUNI_REGX_RPOPISTAT },			\
	{ /* 32 */							\
	  UTP_REGT_BITS,	SUNI_REGO_RPOPPIS,			\
	  SUNI_REGN_RPOPPIS,	SUNI_REGX_RPOPPIS },			\
	{ /* 33 */							\
	  UTP_REGT_BITS,	SUNI_REGO_RPOPIEN,			\
	  SUNI_REGN_RPOPIEN,	SUNI_REGX_RPOPIEN },			\
	{ /* 34 */							\
	  UTP_REGT_BITS,	SUNI_REGO_RPOPPIE,			\
	  SUNI_REGN_RPOPPIE,	SUNI_REGX_RPOPPIE },			\
	{ /* 35, 36 */							\
	  UTP_REGT_INT10BITS,	SUNI_REGO_RPOPPTR,			\
	  SUNI_REGN_RPOPPTR,	SUNI_REGX_RPOPPTR },			\
	{ /* 37 */							\
	  UTP_REGT_INT8,	SUNI_REGO_RPOPPSL,			\
	  SUNI_REGN_RPOPPSL,	NULL },					\
	{ /* 38, 39 */							\
	  UTP_REGT_INT16,	SUNI_REGO_RPOPBIP8,			\
	  SUNI_REGN_RPOPBIP8,	NULL },					\
	{ /* 3A, 3B */							\
	  UTP_REGT_INT16,	SUNI_REGO_RPOPFEBE,			\
	  SUNI_REGN_RPOPFEBE,	NULL },					\
	{ /* 3C */							\
	  UTP_REGT_BITS,	SUNI_REGO_RPOPRDI,			\
	  SUNI_REGN_RPOPRDI,	SUNI_REGX_RPOPRDI },			\
	{ /* 3D */							\
	  UTP_REGT_BITS,	SUNI_REGO_RPOPRING,			\
	  SUNI_REGN_RPOPRING,	SUNI_REGX_RPOPRING },			\
	  /* 3E-3F unused */						\
	{ /* 40 */							\
	  UTP_REGT_BITS,	SUNI_REGO_TPOPCTRL,			\
	  SUNI_REGN_TPOPCTRL,	SUNI_REGX_TPOPCTRL_622 },		\
	{ /* 41 */							\
	  UTP_REGT_BITS,	SUNI_REGO_TPOPPTRC,			\
	  SUNI_REGN_TPOPPTRC,	SUNI_REGX_TPOPPTRC },			\
	  /* 42 unused */						\
	{ /* 43, 44 */							\
	  UTP_REGT_INT10BITS,	SUNI_REGO_TPOPCP,			\
	  SUNI_REGN_TPOPCP,	SUNI_REGX_TPOPCP },			\
	{ /* 45, 46 */							\
	  UTP_REGT_INT10BITS,	SUNI_REGO_TPOPAPTR,			\
	  SUNI_REGN_TPOPAPTR,	SUNI_REGX_TPOPAPTR },			\
	{ /* 47 */							\
	  UTP_REGT_INT8,	SUNI_REGO_TPOPPT,			\
	  SUNI_REGN_TPOPPT,	NULL },					\
	{ /* 48 */							\
	  UTP_REGT_INT8,	SUNI_REGO_TPOPPSL,			\
	  SUNI_REGN_TPOPPSL,	NULL },					\
	{ /* 49 */							\
	  UTP_REGT_BITS,	SUNI_REGO_TPOPSTATUS,			\
	  SUNI_REGN_TPOPSTATUS,	SUNI_REGX_TPOPSTATUS },			\
	{ /* 4A */							\
	  UTP_REGT_INT8,	SUNI_REGO_TPOPPUC,			\
	  SUNI_REGN_TPOPPUC,	NULL },					\
	{ /* 4B */							\
	  UTP_REGT_INT8,	SUNI_REGO_TPOPPG1,			\
	  SUNI_REGN_TPOPPG1,	NULL },					\
	{ /* 4C */							\
	  UTP_REGT_INT8,	SUNI_REGO_TPOPPG2,			\
	  SUNI_REGN_TPOPPG2,	NULL },					\
	{ /* 4D */							\
	  UTP_REGT_INT8,	SUNI_REGO_TPOPPG3,			\
	  SUNI_REGN_TPOPPG3,	NULL },					\
	  /* 4E-4F unused */						\
	{ /* 50 */							\
	  UTP_REGT_BITS,	SUNI_REGO_RACPCTRL,			\
	  SUNI_REGN_RACPCTRL,	SUNI_REGX_RACPCTRL_622 },		\
	{ /* 51 */							\
	  UTP_REGT_BITS,	SUNI_REGO_RACPIS,			\
	  SUNI_REGN_RACPIS,	SUNI_REGX_RACPIS },			\
	{ /* 52 */							\
	  UTP_REGT_BITS,	SUNI_REGO_RACPIEC,			\
	  SUNI_REGN_RACPIEC,	SUNI_REGX_RACPIEC },			\
	{ /* 53 */							\
	  UTP_REGT_BITS,	SUNI_REGO_RACPPATTERN_622,		\
	  SUNI_REGN_RACPPATTERN, SUNI_REGX_RACPPATTERN },		\
	{ /* 54 */							\
	  UTP_REGT_BITS,	SUNI_REGO_RACPMASK_622,			\
	  SUNI_REGN_RACPMASK,	SUNI_REGX_RACPMASK },			\
	{ /* 55, 56 */							\
	  UTP_REGT_INT12,	SUNI_REGO_RACPCHCS_622,			\
	  SUNI_REGN_RACPCHCS,	NULL },					\
	{ /* 57, 58 */							\
	  UTP_REGT_INT12,	SUNI_REGO_RACPUHCS_622,			\
	  SUNI_REGN_RACPUHCS,	NULL },					\
	{ /* 59, 5A, 5B */						\
	  UTP_REGT_INT21,	SUNI_REGO_RACPCNT_622,			\
	  SUNI_REGN_RACPCNT,	NULL },					\
	{ /* 5C */							\
	  UTP_REGT_BITS,	SUNI_REGO_RACPGFC,			\
	  SUNI_REGN_RACPGFC,	SUNI_REGX_RACPGFC },			\
	  /* 5D-5F unused */						\
	{ /* 60 */							\
	  UTP_REGT_BITS,	SUNI_REGO_TACPCTRL,			\
	  SUNI_REGN_TACPCTRL,	SUNI_REGX_TACPCTRL_622 },		\
	{ /* 61 */							\
	  UTP_REGT_BITS,	SUNI_REGO_TACPIDLEH,			\
	  SUNI_REGN_TACPIDLEH,	SUNI_REGX_TACPIDLEH },			\
	{ /* 62 */							\
	  UTP_REGT_INT8,	SUNI_REGO_TACPIDLEP,			\
	  SUNI_REGN_TACPIDLEP,	NULL },					\
	{ /* 63 */							\
	  UTP_REGT_BITS,	SUNI_REGO_TACPFIFOC,			\
	  SUNI_REGN_TACPFIFOC,	SUNI_REGX_TACPFIFOC_622 },		\
	{ /* 64, 65, 66 */						\
	  UTP_REGT_INT21,	SUNI_REGO_TACPCNT,			\
	  SUNI_REGN_TACPCNT,	NULL },					\
	{ /* 67 */							\
	  UTP_REGT_BITS,	SUNI_REGO_TACPGFC,			\
	  SUNI_REGN_TACPGFC,	SUNI_REGX_TACPGFC },			\
	{ /* 68 */							\
	  UTP_REGT_BITS,	SUNI_REGO_SPTBCTRL,			\
	  SUNI_REGN_SPTBCTRL,	SUNI_REGX_SPTBCTRL },			\
	{ /* 69 */							\
	  UTP_REGT_BITS,	SUNI_REGO_SPTBPTIS,			\
	  SUNI_REGN_SPTBPTIS,	SUNI_REGX_SPTBPTIS },			\
	{ /* 6A */							\
	  UTP_REGT_BITS,	SUNI_REGO_SPTBIAR,			\
	  SUNI_REGN_SPTBIAR,	SUNI_REGX_SPTBIAR },			\
	{ /* 6B */							\
	  UTP_REGT_INT8,	SUNI_REGO_SPTBIDR,			\
	  SUNI_REGN_SPTBIDR,	NULL },					\
	{ /* 6C */							\
	  UTP_REGT_INT8,	SUNI_REGO_SPTBEPSL,			\
	  SUNI_REGN_SPTBEPSL,	NULL },					\
	{ /* 6D */							\
	  UTP_REGT_BITS,	SUNI_REGO_SPTBPSLS,			\
	  SUNI_REGN_SPTBPSLS,	SUNI_REGX_SPTBPSLS },			\
	  /* 6E-6F unused */						\
	{ /* 70 */							\
	  UTP_REGT_BITS,	SUNI_REGO_BERMCTRL,			\
	  SUNI_REGN_BERMCTRL,	SUNI_REGX_BERMCTRL },			\
	{ /* 71 */							\
	  UTP_REGT_BITS,	SUNI_REGO_BERMINT,			\
	  SUNI_REGN_BERMINT,	SUNI_REGX_BERMINT },			\
	{ /* 72, 73 */							\
	  UTP_REGT_INT16,	SUNI_REGO_BERMLAP,			\
	  SUNI_REGN_BERMLAP,	NULL },					\
	{ /* 74, 75 */							\
	  UTP_REGT_INT16,	SUNI_REGO_BERMLT,			\
	  SUNI_REGN_BERMLT,	NULL },					\
	  /* 76-7f unused */						\
	{ /* 80 */							\
	  UTP_REGT_BITS,	SUNI_REGO_MTEST,			\
	  SUNI_REGN_MTEST,	SUNI_REGX_MTEST_622 }

#endif /* _DEV_UTOPIA_SUNI_H */
