# Before `make install' is performed this script should be runnable with
# `make test'. After `make install' it should work as `perl Algorithm-CurveFit.t'

#########################

use Test::More tests => 7;
BEGIN { use_ok('Algorithm::CurveFit') };

my $xdata = [];
foreach my $t ( 0 .. 100 ) {
    local $_ = $t/100;
    push @$xdata,  $_;
}

my $ydata = [
          '2.74668578135698',
          '1.99805118921396',
          '1.99853641654954',
          '1.9985125858416',
          '2.00855273759592',
          '1.99421589469338',
          '1.98776223820884',
          '2.00865301701153',
          '2.00034641271862',
          '2.00365933048676',
          '2.00614661782642',
          '2.02842949375954',
          '2.02644873219082',
          '1.97835275163834',
          '1.99723936588325',
          '2.03822843888429',
          '2.01874504271563',
          '1.98427069933109',
          '2.0132985183091',
          '1.99697540151472',
          '1.97154074243663',
          '1.96088918805175',
          '2.00041112366652',
          '2.01347045848792',
          '1.95318857620762',
          '2.02634173212117',
          '1.99293017711835',
          '2.03645084082953',
          '2.04744711238729',
          '2.00237392569881',
          '1.96389441960213',
          '1.96151508693936',
          '2.00718155279406',
          '1.9566617250324',
          '2.03461482573735',
          '1.94195043756795',
          '2.11376078716156',
          '2.08110607851905',
          '2.01873394896203',
          '1.94894118086398',
          '2.01106036667956',
          '2.0006307614176',
          '2.10677283426554',
          '2.07761536539796',
          '1.96889915439611',
          '2.0347028188962',
          '2.09678012343498',
          '1.96346883059215',
          '2.11989134855018',
          '2.04484549335896',
          '2.13406865949543',
          '2.16248993162949',
          '2.09003312220615',
          '2.14206946826349',
          '2.19186995928015',
          '2.01793970264423',
          '1.9306362515292',
          '1.9343252282622',
          '1.99483419784696',
          '2.11140751953195',
          '2.07481600707861',
          '2.0913608105674',
          '2.13075488654319',
          '2.13619157252702',
          '2.13530766776266',
          '2.11300666979717',
          '2.21837949744426',
          '2.19201958799807',
          '2.09766991449844',
          '2.17182223180029',
          '2.17618037893199',
          '2.26794416667709',
          '2.05450291780982',
          '2.04181437342668',
          '2.19507912736935',
          '2.28527771848344',
          '2.30130721698316',
          '2.11583190599986',
          '1.96124105394915',
          '2.0265761276989',
          '1.93950378313908',
          '2.06417550020264',
          '2.12565765837745',
          '2.02088280071306',
          '2.13446746857603',
          '2.16453067780087',
          '2.01261145537851',
          '2.21219342485829',
          '1.99356109265438',
          '2.0417917884463',
          '2.04264067810866',
          '2.32892736270956',
          '1.94203564172302',
          '2.17862453381208',
          '2.02298710522281',
          '2.06016785210408',
          '2.08654762730258',
          '2.24630881136672',
          '2.24898854508052',
          '2.10667677725939',
          '2.27627593183404'
];


my $formula = 'c+a*foo^2';
my $max_iter = 100;
my $variable = 'foo';
my @parameters = (
	['a', 2, 0.0000001],
	['c', 20, 0.0000005],
);

my $sqr;
eval {
	$sqr = Algorithm::CurveFit::curve_fit(
		variable => $variable,
		formula => $formula,
		params => \@parameters,
		maximum_iterations => $max_iter,
		xdata => $xdata,
		ydata => $ydata,
	);
};
ok(!$@, "Call didn't die ($@).");
ok($parameters[0][1] > 0.2-0.1, "Param 1 not too small.");
ok($parameters[0][1] < 0.2+0.1, "Param 1 not too big.");
ok($parameters[1][1] > 2-0.5, "Param 2 not too small.");
ok($parameters[1][1] < 2+0.5, "Param 2 not too big.");

ok(defined $sqr, "Sum of square residuals returned.");


 
