package PDF::API2::Resource::Font::CoreFont::trebuchetitalic;

use strict;
use warnings;

our $VERSION = '2.040'; # VERSION

sub data { return {
    'fontname' => 'TrebuchetMS,Italic',
    'type' => 'TrueType',
    'apiname' => 'TrIt',
    'ascender' => '938',
    'capheight' => '715',
    'descender' => '-222',
    'isfixedpitch' => '0',
    'issymbol' => '0',
    'italicangle' => '-10',
    'underlineposition' => '-261',
    'underlinethickness' => '127',
    'xheight' => '522',
    'firstchar' => '32',
    'lastchar' => '255',
    'flags' => '104',
    'char' => [ # DEF. ENCODING GLYPH TABLE
        '.notdef',                               # C+0x00 # U+0x0000
        '.notdef',                               # C+0x01 # U+0x0000
        '.notdef',                               # C+0x02 # U+0x0000
        '.notdef',                               # C+0x03 # U+0x0000
        '.notdef',                               # C+0x04 # U+0x0000
        '.notdef',                               # C+0x05 # U+0x0000
        '.notdef',                               # C+0x06 # U+0x0000
        '.notdef',                               # C+0x07 # U+0x0000
        '.notdef',                               # C+0x08 # U+0x0000
        '.notdef',                               # C+0x09 # U+0x0000
        '.notdef',                               # C+0x0A # U+0x0000
        '.notdef',                               # C+0x0B # U+0x0000
        '.notdef',                               # C+0x0C # U+0x0000
        '.notdef',                               # C+0x0D # U+0x0000
        '.notdef',                               # C+0x0E # U+0x0000
        '.notdef',                               # C+0x0F # U+0x0000
        '.notdef',                               # C+0x10 # U+0x0000
        '.notdef',                               # C+0x11 # U+0x0000
        '.notdef',                               # C+0x12 # U+0x0000
        '.notdef',                               # C+0x13 # U+0x0000
        '.notdef',                               # C+0x14 # U+0x0000
        '.notdef',                               # C+0x15 # U+0x0000
        '.notdef',                               # C+0x16 # U+0x0000
        '.notdef',                               # C+0x17 # U+0x0000
        '.notdef',                               # C+0x18 # U+0x0000
        '.notdef',                               # C+0x19 # U+0x0000
        '.notdef',                               # C+0x1A # U+0x0000
        '.notdef',                               # C+0x1B # U+0x0000
        '.notdef',                               # C+0x1C # U+0x0000
        '.notdef',                               # C+0x1D # U+0x0000
        '.notdef',                               # C+0x1E # U+0x0000
        '.notdef',                               # C+0x1F # U+0x0000
        'space',                                 # C+0x20 # U+0x0020
        'exclam',                                # C+0x21 # U+0x0021
        'quotedbl',                              # C+0x22 # U+0x0022
        'numbersign',                            # C+0x23 # U+0x0023
        'dollar',                                # C+0x24 # U+0x0024
        'percent',                               # C+0x25 # U+0x0025
        'ampersand',                             # C+0x26 # U+0x0026
        'quotesingle',                           # C+0x27 # U+0x0027
        'parenleft',                             # C+0x28 # U+0x0028
        'parenright',                            # C+0x29 # U+0x0029
        'asterisk',                              # C+0x2A # U+0x002A
        'plus',                                  # C+0x2B # U+0x002B
        'comma',                                 # C+0x2C # U+0x002C
        'hyphen',                                # C+0x2D # U+0x002D
        'period',                                # C+0x2E # U+0x002E
        'slash',                                 # C+0x2F # U+0x002F
        'zero',                                  # C+0x30 # U+0x0030
        'one',                                   # C+0x31 # U+0x0031
        'two',                                   # C+0x32 # U+0x0032
        'three',                                 # C+0x33 # U+0x0033
        'four',                                  # C+0x34 # U+0x0034
        'five',                                  # C+0x35 # U+0x0035
        'six',                                   # C+0x36 # U+0x0036
        'seven',                                 # C+0x37 # U+0x0037
        'eight',                                 # C+0x38 # U+0x0038
        'nine',                                  # C+0x39 # U+0x0039
        'colon',                                 # C+0x3A # U+0x003A
        'semicolon',                             # C+0x3B # U+0x003B
        'less',                                  # C+0x3C # U+0x003C
        'equal',                                 # C+0x3D # U+0x003D
        'greater',                               # C+0x3E # U+0x003E
        'question',                              # C+0x3F # U+0x003F
        'at',                                    # C+0x40 # U+0x0040
        'A',                                     # C+0x41 # U+0x0041
        'B',                                     # C+0x42 # U+0x0042
        'C',                                     # C+0x43 # U+0x0043
        'D',                                     # C+0x44 # U+0x0044
        'E',                                     # C+0x45 # U+0x0045
        'F',                                     # C+0x46 # U+0x0046
        'G',                                     # C+0x47 # U+0x0047
        'H',                                     # C+0x48 # U+0x0048
        'I',                                     # C+0x49 # U+0x0049
        'J',                                     # C+0x4A # U+0x004A
        'K',                                     # C+0x4B # U+0x004B
        'L',                                     # C+0x4C # U+0x004C
        'M',                                     # C+0x4D # U+0x004D
        'N',                                     # C+0x4E # U+0x004E
        'O',                                     # C+0x4F # U+0x004F
        'P',                                     # C+0x50 # U+0x0050
        'Q',                                     # C+0x51 # U+0x0051
        'R',                                     # C+0x52 # U+0x0052
        'S',                                     # C+0x53 # U+0x0053
        'T',                                     # C+0x54 # U+0x0054
        'U',                                     # C+0x55 # U+0x0055
        'V',                                     # C+0x56 # U+0x0056
        'W',                                     # C+0x57 # U+0x0057
        'X',                                     # C+0x58 # U+0x0058
        'Y',                                     # C+0x59 # U+0x0059
        'Z',                                     # C+0x5A # U+0x005A
        'bracketleft',                           # C+0x5B # U+0x005B
        'backslash',                             # C+0x5C # U+0x005C
        'bracketright',                          # C+0x5D # U+0x005D
        'asciicircum',                           # C+0x5E # U+0x005E
        'underscore',                            # C+0x5F # U+0x005F
        'grave',                                 # C+0x60 # U+0x0060
        'a',                                     # C+0x61 # U+0x0061
        'b',                                     # C+0x62 # U+0x0062
        'c',                                     # C+0x63 # U+0x0063
        'd',                                     # C+0x64 # U+0x0064
        'e',                                     # C+0x65 # U+0x0065
        'f',                                     # C+0x66 # U+0x0066
        'g',                                     # C+0x67 # U+0x0067
        'h',                                     # C+0x68 # U+0x0068
        'i',                                     # C+0x69 # U+0x0069
        'j',                                     # C+0x6A # U+0x006A
        'k',                                     # C+0x6B # U+0x006B
        'l',                                     # C+0x6C # U+0x006C
        'm',                                     # C+0x6D # U+0x006D
        'n',                                     # C+0x6E # U+0x006E
        'o',                                     # C+0x6F # U+0x006F
        'p',                                     # C+0x70 # U+0x0070
        'q',                                     # C+0x71 # U+0x0071
        'r',                                     # C+0x72 # U+0x0072
        's',                                     # C+0x73 # U+0x0073
        't',                                     # C+0x74 # U+0x0074
        'u',                                     # C+0x75 # U+0x0075
        'v',                                     # C+0x76 # U+0x0076
        'w',                                     # C+0x77 # U+0x0077
        'x',                                     # C+0x78 # U+0x0078
        'y',                                     # C+0x79 # U+0x0079
        'z',                                     # C+0x7A # U+0x007A
        'braceleft',                             # C+0x7B # U+0x007B
        'bar',                                   # C+0x7C # U+0x007C
        'braceright',                            # C+0x7D # U+0x007D
        'asciitilde',                            # C+0x7E # U+0x007E
        'bullet',                                # C+0x7F # U+0x2022
        'Euro',                                  # C+0x80 # U+0x20AC
        'bullet',                                # C+0x81 # U+0x2022
        'quotesinglbase',                        # C+0x82 # U+0x201A
        'florin',                                # C+0x83 # U+0x0192
        'quotedblbase',                          # C+0x84 # U+0x201E
        'ellipsis',                              # C+0x85 # U+0x2026
        'dagger',                                # C+0x86 # U+0x2020
        'daggerdbl',                             # C+0x87 # U+0x2021
        'circumflex',                            # C+0x88 # U+0x02C6
        'perthousand',                           # C+0x89 # U+0x2030
        'Scaron',                                # C+0x8A # U+0x0160
        'guilsinglleft',                         # C+0x8B # U+0x2039
        'OE',                                    # C+0x8C # U+0x0152
        'bullet',                                # C+0x8D # U+0x2022
        'Zcaron',                                # C+0x8E # U+0x017D
        'bullet',                                # C+0x8F # U+0x2022
        'bullet',                                # C+0x90 # U+0x2022
        'quoteleft',                             # C+0x91 # U+0x2018
        'quoteright',                            # C+0x92 # U+0x2019
        'quotedblleft',                          # C+0x93 # U+0x201C
        'quotedblright',                         # C+0x94 # U+0x201D
        'bullet',                                # C+0x95 # U+0x2022
        'endash',                                # C+0x96 # U+0x2013
        'emdash',                                # C+0x97 # U+0x2014
        'tilde',                                 # C+0x98 # U+0x02DC
        'trademark',                             # C+0x99 # U+0x2122
        'scaron',                                # C+0x9A # U+0x0161
        'guilsinglright',                        # C+0x9B # U+0x203A
        'oe',                                    # C+0x9C # U+0x0153
        'bullet',                                # C+0x9D # U+0x2022
        'zcaron',                                # C+0x9E # U+0x017E
        'Ydieresis',                             # C+0x9F # U+0x0178
        'space',                                 # C+0xA0 # U+0x0020
        'exclamdown',                            # C+0xA1 # U+0x00A1
        'cent',                                  # C+0xA2 # U+0x00A2
        'sterling',                              # C+0xA3 # U+0x00A3
        'currency',                              # C+0xA4 # U+0x00A4
        'yen',                                   # C+0xA5 # U+0x00A5
        'brokenbar',                             # C+0xA6 # U+0x00A6
        'section',                               # C+0xA7 # U+0x00A7
        'dieresis',                              # C+0xA8 # U+0x00A8
        'copyright',                             # C+0xA9 # U+0x00A9
        'ordfeminine',                           # C+0xAA # U+0x00AA
        'guillemotleft',                         # C+0xAB # U+0x00AB
        'logicalnot',                            # C+0xAC # U+0x00AC
        'hyphen',                                # C+0xAD # U+0x002D
        'registered',                            # C+0xAE # U+0x00AE
        'macron',                                # C+0xAF # U+0x00AF
        'degree',                                # C+0xB0 # U+0x00B0
        'plusminus',                             # C+0xB1 # U+0x00B1
        'twosuperior',                           # C+0xB2 # U+0x00B2
        'threesuperior',                         # C+0xB3 # U+0x00B3
        'acute',                                 # C+0xB4 # U+0x00B4
        'mu',                                    # C+0xB5 # U+0x00B5
        'paragraph',                             # C+0xB6 # U+0x00B6
        'periodcentered',                        # C+0xB7 # U+0x00B7
        'cedilla',                               # C+0xB8 # U+0x00B8
        'onesuperior',                           # C+0xB9 # U+0x00B9
        'ordmasculine',                          # C+0xBA # U+0x00BA
        'guillemotright',                        # C+0xBB # U+0x00BB
        'onequarter',                            # C+0xBC # U+0x00BC
        'onehalf',                               # C+0xBD # U+0x00BD
        'threequarters',                         # C+0xBE # U+0x00BE
        'questiondown',                          # C+0xBF # U+0x00BF
        'Agrave',                                # C+0xC0 # U+0x00C0
        'Aacute',                                # C+0xC1 # U+0x00C1
        'Acircumflex',                           # C+0xC2 # U+0x00C2
        'Atilde',                                # C+0xC3 # U+0x00C3
        'Adieresis',                             # C+0xC4 # U+0x00C4
        'Aring',                                 # C+0xC5 # U+0x00C5
        'AE',                                    # C+0xC6 # U+0x00C6
        'Ccedilla',                              # C+0xC7 # U+0x00C7
        'Egrave',                                # C+0xC8 # U+0x00C8
        'Eacute',                                # C+0xC9 # U+0x00C9
        'Ecircumflex',                           # C+0xCA # U+0x00CA
        'Edieresis',                             # C+0xCB # U+0x00CB
        'Igrave',                                # C+0xCC # U+0x00CC
        'Iacute',                                # C+0xCD # U+0x00CD
        'Icircumflex',                           # C+0xCE # U+0x00CE
        'Idieresis',                             # C+0xCF # U+0x00CF
        'Eth',                                   # C+0xD0 # U+0x00D0
        'Ntilde',                                # C+0xD1 # U+0x00D1
        'Ograve',                                # C+0xD2 # U+0x00D2
        'Oacute',                                # C+0xD3 # U+0x00D3
        'Ocircumflex',                           # C+0xD4 # U+0x00D4
        'Otilde',                                # C+0xD5 # U+0x00D5
        'Odieresis',                             # C+0xD6 # U+0x00D6
        'multiply',                              # C+0xD7 # U+0x00D7
        'Oslash',                                # C+0xD8 # U+0x00D8
        'Ugrave',                                # C+0xD9 # U+0x00D9
        'Uacute',                                # C+0xDA # U+0x00DA
        'Ucircumflex',                           # C+0xDB # U+0x00DB
        'Udieresis',                             # C+0xDC # U+0x00DC
        'Yacute',                                # C+0xDD # U+0x00DD
        'Thorn',                                 # C+0xDE # U+0x00DE
        'germandbls',                            # C+0xDF # U+0x00DF
        'agrave',                                # C+0xE0 # U+0x00E0
        'aacute',                                # C+0xE1 # U+0x00E1
        'acircumflex',                           # C+0xE2 # U+0x00E2
        'atilde',                                # C+0xE3 # U+0x00E3
        'adieresis',                             # C+0xE4 # U+0x00E4
        'aring',                                 # C+0xE5 # U+0x00E5
        'ae',                                    # C+0xE6 # U+0x00E6
        'ccedilla',                              # C+0xE7 # U+0x00E7
        'egrave',                                # C+0xE8 # U+0x00E8
        'eacute',                                # C+0xE9 # U+0x00E9
        'ecircumflex',                           # C+0xEA # U+0x00EA
        'edieresis',                             # C+0xEB # U+0x00EB
        'igrave',                                # C+0xEC # U+0x00EC
        'iacute',                                # C+0xED # U+0x00ED
        'icircumflex',                           # C+0xEE # U+0x00EE
        'idieresis',                             # C+0xEF # U+0x00EF
        'eth',                                   # C+0xF0 # U+0x00F0
        'ntilde',                                # C+0xF1 # U+0x00F1
        'ograve',                                # C+0xF2 # U+0x00F2
        'oacute',                                # C+0xF3 # U+0x00F3
        'ocircumflex',                           # C+0xF4 # U+0x00F4
        'otilde',                                # C+0xF5 # U+0x00F5
        'odieresis',                             # C+0xF6 # U+0x00F6
        'divide',                                # C+0xF7 # U+0x00F7
        'oslash',                                # C+0xF8 # U+0x00F8
        'ugrave',                                # C+0xF9 # U+0x00F9
        'uacute',                                # C+0xFA # U+0x00FA
        'ucircumflex',                           # C+0xFB # U+0x00FB
        'udieresis',                             # C+0xFC # U+0x00FC
        'yacute',                                # C+0xFD # U+0x00FD
        'thorn',                                 # C+0xFE # U+0x00FE
        'ydieresis',                             # C+0xFF # U+0x00FF
    ], # DEF. ENCODING GLYPH TABLE
    'fontbbox' => [ -109, -257, 1107, 945 ],
    'wx' => { # HORIZ. WIDTH TABLE
        'space' => '301',                        # C+0x20 # U+0x0020
        'exclam' => '367',                       # C+0x21 # U+0x0021
        'quotedbl' => '324',                     # C+0x22 # U+0x0022
        'numbersign' => '524',                   # C+0x23 # U+0x0023
        'dollar' => '480',                       # C+0x24 # U+0x0024
        'percent' => '600',                      # C+0x25 # U+0x0025
        'ampersand' => '706',                    # C+0x26 # U+0x0026
        'quotesingle' => '159',                  # C+0x27 # U+0x0027
        'parenleft' => '367',                    # C+0x28 # U+0x0028
        'parenright' => '367',                   # C+0x29 # U+0x0029
        'asterisk' => '367',                     # C+0x2A # U+0x002A
        'plus' => '524',                         # C+0x2B # U+0x002B
        'comma' => '367',                        # C+0x2C # U+0x002C
        'hyphen' => '367',                       # C+0x2D # U+0x002D
        'period' => '367',                       # C+0x2E # U+0x002E
        'slash' => '524',                        # C+0x2F # U+0x002F
        'zero' => '524',                         # C+0x30 # U+0x0030
        'one' => '524',                          # C+0x31 # U+0x0031
        'two' => '524',                          # C+0x32 # U+0x0032
        'three' => '524',                        # C+0x33 # U+0x0033
        'four' => '524',                         # C+0x34 # U+0x0034
        'five' => '524',                         # C+0x35 # U+0x0035
        'six' => '524',                          # C+0x36 # U+0x0036
        'seven' => '524',                        # C+0x37 # U+0x0037
        'eight' => '524',                        # C+0x38 # U+0x0038
        'nine' => '524',                         # C+0x39 # U+0x0039
        'colon' => '367',                        # C+0x3A # U+0x003A
        'semicolon' => '367',                    # C+0x3B # U+0x003B
        'less' => '524',                         # C+0x3C # U+0x003C
        'equal' => '524',                        # C+0x3D # U+0x003D
        'greater' => '524',                      # C+0x3E # U+0x003E
        'question' => '367',                     # C+0x3F # U+0x003F
        'at' => '770',                           # C+0x40 # U+0x0040
        'A' => '610',                            # C+0x41 # U+0x0041
        'B' => '565',                            # C+0x42 # U+0x0042
        'C' => '598',                            # C+0x43 # U+0x0043
        'D' => '613',                            # C+0x44 # U+0x0044
        'E' => '535',                            # C+0x45 # U+0x0045
        'F' => '524',                            # C+0x46 # U+0x0046
        'G' => '676',                            # C+0x47 # U+0x0047
        'H' => '654',                            # C+0x48 # U+0x0048
        'I' => '278',                            # C+0x49 # U+0x0049
        'J' => '476',                            # C+0x4A # U+0x004A
        'K' => '575',                            # C+0x4B # U+0x004B
        'L' => '506',                            # C+0x4C # U+0x004C
        'M' => '761',                            # C+0x4D # U+0x004D
        'N' => '638',                            # C+0x4E # U+0x004E
        'O' => '673',                            # C+0x4F # U+0x004F
        'P' => '543',                            # C+0x50 # U+0x0050
        'Q' => '673',                            # C+0x51 # U+0x0051
        'R' => '582',                            # C+0x52 # U+0x0052
        'S' => '480',                            # C+0x53 # U+0x0053
        'T' => '580',                            # C+0x54 # U+0x0054
        'U' => '648',                            # C+0x55 # U+0x0055
        'V' => '587',                            # C+0x56 # U+0x0056
        'W' => '852',                            # C+0x57 # U+0x0057
        'X' => '556',                            # C+0x58 # U+0x0058
        'Y' => '570',                            # C+0x59 # U+0x0059
        'Z' => '550',                            # C+0x5A # U+0x005A
        'bracketleft' => '367',                  # C+0x5B # U+0x005B
        'backslash' => '355',                    # C+0x5C # U+0x005C
        'bracketright' => '367',                 # C+0x5D # U+0x005D
        'asciicircum' => '524',                  # C+0x5E # U+0x005E
        'underscore' => '524',                   # C+0x5F # U+0x005F
        'grave' => '524',                        # C+0x60 # U+0x0060
        'a' => '525',                            # C+0x61 # U+0x0061
        'b' => '557',                            # C+0x62 # U+0x0062
        'c' => '459',                            # C+0x63 # U+0x0063
        'd' => '557',                            # C+0x64 # U+0x0064
        'e' => '537',                            # C+0x65 # U+0x0065
        'f' => '401',                            # C+0x66 # U+0x0066
        'g' => '501',                            # C+0x67 # U+0x0067
        'h' => '557',                            # C+0x68 # U+0x0068
        'i' => '306',                            # C+0x69 # U+0x0069
        'j' => '366',                            # C+0x6A # U+0x006A
        'k' => '504',                            # C+0x6B # U+0x006B
        'l' => '320',                            # C+0x6C # U+0x006C
        'm' => '830',                            # C+0x6D # U+0x006D
        'n' => '546',                            # C+0x6E # U+0x006E
        'o' => '536',                            # C+0x6F # U+0x006F
        'p' => '557',                            # C+0x70 # U+0x0070
        'q' => '557',                            # C+0x71 # U+0x0071
        'r' => '416',                            # C+0x72 # U+0x0072
        's' => '404',                            # C+0x73 # U+0x0073
        't' => '419',                            # C+0x74 # U+0x0074
        'u' => '556',                            # C+0x75 # U+0x0075
        'v' => '489',                            # C+0x76 # U+0x0076
        'w' => '744',                            # C+0x77 # U+0x0077
        'x' => '500',                            # C+0x78 # U+0x0078
        'y' => '493',                            # C+0x79 # U+0x0079
        'z' => '474',                            # C+0x7A # U+0x007A
        'braceleft' => '367',                    # C+0x7B # U+0x007B
        'bar' => '524',                          # C+0x7C # U+0x007C
        'braceright' => '367',                   # C+0x7D # U+0x007D
        'asciitilde' => '524',                   # C+0x7E # U+0x007E
        'bullet' => '524',                       # C+0x7F # U+0x2022
        'Euro' => '524',                         # C+0x80 # U+0x20AC
        'quotesinglbase' => '367',               # C+0x82 # U+0x201A
        'florin' => '401',                       # C+0x83 # U+0x0192
        'quotedblbase' => '524',                 # C+0x84 # U+0x201E
        'ellipsis' => '734',                     # C+0x85 # U+0x2026
        'dagger' => '458',                       # C+0x86 # U+0x2020
        'daggerdbl' => '458',                    # C+0x87 # U+0x2021
        'circumflex' => '524',                   # C+0x88 # U+0x02C6
        'perthousand' => '912',                  # C+0x89 # U+0x2030
        'Scaron' => '480',                       # C+0x8A # U+0x0160
        'guilsinglleft' => '367',                # C+0x8B # U+0x2039
        'OE' => '993',                           # C+0x8C # U+0x0152
        'Zcaron' => '550',                       # C+0x8E # U+0x017D
        'quoteleft' => '367',                    # C+0x91 # U+0x2018
        'quoteright' => '367',                   # C+0x92 # U+0x2019
        'quotedblleft' => '524',                 # C+0x93 # U+0x201C
        'quotedblright' => '524',                # C+0x94 # U+0x201D
        'endash' => '367',                       # C+0x96 # U+0x2013
        'emdash' => '734',                       # C+0x97 # U+0x2014
        'tilde' => '524',                        # C+0x98 # U+0x02DC
        'trademark' => '634',                    # C+0x99 # U+0x2122
        'scaron' => '404',                       # C+0x9A # U+0x0161
        'guilsinglright' => '367',               # C+0x9B # U+0x203A
        'oe' => '891',                           # C+0x9C # U+0x0153
        'zcaron' => '474',                       # C+0x9E # U+0x017E
        'Ydieresis' => '570',                    # C+0x9F # U+0x0178
        'exclamdown' => '367',                   # C+0xA1 # U+0x00A1
        'cent' => '524',                         # C+0xA2 # U+0x00A2
        'sterling' => '529',                     # C+0xA3 # U+0x00A3
        'currency' => '524',                     # C+0xA4 # U+0x00A4
        'yen' => '556',                          # C+0xA5 # U+0x00A5
        'brokenbar' => '524',                    # C+0xA6 # U+0x00A6
        'section' => '453',                      # C+0xA7 # U+0x00A7
        'dieresis' => '524',                     # C+0xA8 # U+0x00A8
        'copyright' => '712',                    # C+0xA9 # U+0x00A9
        'ordfeminine' => '452',                  # C+0xAA # U+0x00AA
        'guillemotleft' => '524',                # C+0xAB # U+0x00AB
        'logicalnot' => '524',                   # C+0xAC # U+0x00AC
        'registered' => '712',                   # C+0xAE # U+0x00AE
        'macron' => '524',                       # C+0xAF # U+0x00AF
        'degree' => '524',                       # C+0xB0 # U+0x00B0
        'plusminus' => '524',                    # C+0xB1 # U+0x00B1
        'twosuperior' => '451',                  # C+0xB2 # U+0x00B2
        'threesuperior' => '451',                # C+0xB3 # U+0x00B3
        'acute' => '524',                        # C+0xB4 # U+0x00B4
        'mu' => '556',                           # C+0xB5 # U+0x00B5
        'paragraph' => '598',                    # C+0xB6 # U+0x00B6
        'periodcentered' => '367',               # C+0xB7 # U+0x00B7
        'cedilla' => '524',                      # C+0xB8 # U+0x00B8
        'onesuperior' => '451',                  # C+0xB9 # U+0x00B9
        'ordmasculine' => '458',                 # C+0xBA # U+0x00BA
        'guillemotright' => '524',               # C+0xBB # U+0x00BB
        'onequarter' => '814',                   # C+0xBC # U+0x00BC
        'onehalf' => '814',                      # C+0xBD # U+0x00BD
        'threequarters' => '814',                # C+0xBE # U+0x00BE
        'questiondown' => '367',                 # C+0xBF # U+0x00BF
        'Agrave' => '610',                       # C+0xC0 # U+0x00C0
        'Aacute' => '610',                       # C+0xC1 # U+0x00C1
        'Acircumflex' => '610',                  # C+0xC2 # U+0x00C2
        'Atilde' => '610',                       # C+0xC3 # U+0x00C3
        'Adieresis' => '610',                    # C+0xC4 # U+0x00C4
        'Aring' => '610',                        # C+0xC5 # U+0x00C5
        'AE' => '866',                           # C+0xC6 # U+0x00C6
        'Ccedilla' => '598',                     # C+0xC7 # U+0x00C7
        'Egrave' => '535',                       # C+0xC8 # U+0x00C8
        'Eacute' => '535',                       # C+0xC9 # U+0x00C9
        'Ecircumflex' => '535',                  # C+0xCA # U+0x00CA
        'Edieresis' => '535',                    # C+0xCB # U+0x00CB
        'Igrave' => '278',                       # C+0xCC # U+0x00CC
        'Iacute' => '278',                       # C+0xCD # U+0x00CD
        'Icircumflex' => '278',                  # C+0xCE # U+0x00CE
        'Idieresis' => '278',                    # C+0xCF # U+0x00CF
        'Eth' => '613',                          # C+0xD0 # U+0x00D0
        'Ntilde' => '638',                       # C+0xD1 # U+0x00D1
        'Ograve' => '673',                       # C+0xD2 # U+0x00D2
        'Oacute' => '673',                       # C+0xD3 # U+0x00D3
        'Ocircumflex' => '673',                  # C+0xD4 # U+0x00D4
        'Otilde' => '673',                       # C+0xD5 # U+0x00D5
        'Odieresis' => '673',                    # C+0xD6 # U+0x00D6
        'multiply' => '524',                     # C+0xD7 # U+0x00D7
        'Oslash' => '673',                       # C+0xD8 # U+0x00D8
        'Ugrave' => '648',                       # C+0xD9 # U+0x00D9
        'Uacute' => '648',                       # C+0xDA # U+0x00DA
        'Ucircumflex' => '648',                  # C+0xDB # U+0x00DB
        'Udieresis' => '648',                    # C+0xDC # U+0x00DC
        'Yacute' => '570',                       # C+0xDD # U+0x00DD
        'Thorn' => '543',                        # C+0xDE # U+0x00DE
        'germandbls' => '546',                   # C+0xDF # U+0x00DF
        'agrave' => '525',                       # C+0xE0 # U+0x00E0
        'aacute' => '525',                       # C+0xE1 # U+0x00E1
        'acircumflex' => '525',                  # C+0xE2 # U+0x00E2
        'atilde' => '525',                       # C+0xE3 # U+0x00E3
        'adieresis' => '525',                    # C+0xE4 # U+0x00E4
        'aring' => '525',                        # C+0xE5 # U+0x00E5
        'ae' => '844',                           # C+0xE6 # U+0x00E6
        'ccedilla' => '459',                     # C+0xE7 # U+0x00E7
        'egrave' => '537',                       # C+0xE8 # U+0x00E8
        'eacute' => '537',                       # C+0xE9 # U+0x00E9
        'ecircumflex' => '537',                  # C+0xEA # U+0x00EA
        'edieresis' => '537',                    # C+0xEB # U+0x00EB
        'igrave' => '306',                       # C+0xEC # U+0x00EC
        'iacute' => '306',                       # C+0xED # U+0x00ED
        'icircumflex' => '306',                  # C+0xEE # U+0x00EE
        'idieresis' => '306',                    # C+0xEF # U+0x00EF
        'eth' => '549',                          # C+0xF0 # U+0x00F0
        'ntilde' => '546',                       # C+0xF1 # U+0x00F1
        'ograve' => '536',                       # C+0xF2 # U+0x00F2
        'oacute' => '536',                       # C+0xF3 # U+0x00F3
        'ocircumflex' => '536',                  # C+0xF4 # U+0x00F4
        'otilde' => '536',                       # C+0xF5 # U+0x00F5
        'odieresis' => '536',                    # C+0xF6 # U+0x00F6
        'divide' => '524',                       # C+0xF7 # U+0x00F7
        'oslash' => '536',                       # C+0xF8 # U+0x00F8
        'ugrave' => '556',                       # C+0xF9 # U+0x00F9
        'uacute' => '556',                       # C+0xFA # U+0x00FA
        'ucircumflex' => '556',                  # C+0xFB # U+0x00FB
        'udieresis' => '556',                    # C+0xFC # U+0x00FC
        'yacute' => '493',                       # C+0xFD # U+0x00FD
        'thorn' => '557',                        # C+0xFE # U+0x00FE
        'ydieresis' => '493',                    # C+0xFF # U+0x00FF
        'middot' => '367',                       # U+0x00B7
        'Amacron' => '610',                      # U+0x0100
        'amacron' => '525',                      # U+0x0101
        'Abreve' => '610',                       # U+0x0102
        'abreve' => '525',                       # U+0x0103
        'Aogonek' => '610',                      # U+0x0104
        'aogonek' => '525',                      # U+0x0105
        'Cacute' => '598',                       # U+0x0106
        'cacute' => '459',                       # U+0x0107
        'Ccircumflex' => '598',                  # U+0x0108
        'ccircumflex' => '459',                  # U+0x0109
        'Cdot' => '598',                         # U+0x010A
        'cdot' => '459',                         # U+0x010B
        'Ccaron' => '598',                       # U+0x010C
        'ccaron' => '459',                       # U+0x010D
        'Dcaron' => '613',                       # U+0x010E
        'dcaron' => '691',                       # U+0x010F
        'dcroat' => '557',                       # U+0x0111
        'Emacron' => '535',                      # U+0x0112
        'emacron' => '537',                      # U+0x0113
        'Ebreve' => '535',                       # U+0x0114
        'ebreve' => '537',                       # U+0x0115
        'Edot' => '535',                         # U+0x0116
        'edot' => '537',                         # U+0x0117
        'Eogonek' => '535',                      # U+0x0118
        'eogonek' => '537',                      # U+0x0119
        'Ecaron' => '535',                       # U+0x011A
        'ecaron' => '537',                       # U+0x011B
        'Gcircumflex' => '676',                  # U+0x011C
        'gcircumflex' => '501',                  # U+0x011D
        'Gbreve' => '676',                       # U+0x011E
        'gbreve' => '501',                       # U+0x011F
        'Gdot' => '676',                         # U+0x0120
        'gdot' => '501',                         # U+0x0121
        'Hcircumflex' => '654',                  # U+0x0124
        'hcircumflex' => '557',                  # U+0x0125
        'Hbar' => '682',                         # U+0x0126
        'hbar' => '553',                         # U+0x0127
        'Itilde' => '278',                       # U+0x0128
        'itilde' => '306',                       # U+0x0129
        'Imacron' => '278',                      # U+0x012A
        'imacron' => '306',                      # U+0x012B
        'Ibreve' => '278',                       # U+0x012C
        'ibreve' => '306',                       # U+0x012D
        'Iogonek' => '278',                      # U+0x012E
        'iogonek' => '306',                      # U+0x012F
        'Idotaccent' => '278',                   # U+0x0130
        'dotlessi' => '306',                     # U+0x0131
        'IJ' => '727',                           # U+0x0132
        'ij' => '585',                           # U+0x0133
        'Jcircumflex' => '476',                  # U+0x0134
        'jcircumflex' => '366',                  # U+0x0135
        'kgreenlandic' => '537',                 # U+0x0138
        'Lacute' => '506',                       # U+0x0139
        'lacute' => '320',                       # U+0x013A
        'Lcaron' => '506',                       # U+0x013D
        'lcaron' => '320',                       # U+0x013E
        'Ldot' => '506',                         # U+0x013F
        'ldot' => '506',                         # U+0x0140
        'Lslash' => '506',                       # U+0x0141
        'lslash' => '294',                       # U+0x0142
        'Nacute' => '638',                       # U+0x0143
        'nacute' => '546',                       # U+0x0144
        'Ncaron' => '638',                       # U+0x0147
        'ncaron' => '546',                       # U+0x0148
        'napostrophe' => '604',                  # U+0x0149
        'Eng' => '651',                          # U+0x014A
        'eng' => '546',                          # U+0x014B
        'Omacron' => '673',                      # U+0x014C
        'omacron' => '536',                      # U+0x014D
        'Obreve' => '673',                       # U+0x014E
        'obreve' => '536',                       # U+0x014F
        'Racute' => '582',                       # U+0x0154
        'racute' => '416',                       # U+0x0155
        'Rcaron' => '582',                       # U+0x0158
        'rcaron' => '416',                       # U+0x0159
        'Sacute' => '480',                       # U+0x015A
        'sacute' => '404',                       # U+0x015B
        'Scircumflex' => '480',                  # U+0x015C
        'scircumflex' => '404',                  # U+0x015D
        'Scedilla' => '480',                     # U+0x015E
        'scedilla' => '404',                     # U+0x015F
        'Tcaron' => '580',                       # U+0x0164
        'tcaron' => '496',                       # U+0x0165
        'Tbar' => '580',                         # U+0x0166
        'tbar' => '419',                         # U+0x0167
        'Utilde' => '648',                       # U+0x0168
        'utilde' => '556',                       # U+0x0169
        'Umacron' => '648',                      # U+0x016A
        'umacron' => '556',                      # U+0x016B
        'Ubreve' => '648',                       # U+0x016C
        'ubreve' => '556',                       # U+0x016D
        'Uring' => '648',                        # U+0x016E
        'uring' => '556',                        # U+0x016F
        'Uogonek' => '648',                      # U+0x0172
        'uogonek' => '556',                      # U+0x0173
        'Wcircumflex' => '852',                  # U+0x0174
        'wcircumflex' => '744',                  # U+0x0175
        'Ycircumflex' => '570',                  # U+0x0176
        'ycircumflex' => '493',                  # U+0x0177
        'Zacute' => '550',                       # U+0x0179
        'zacute' => '474',                       # U+0x017A
        'Zdot' => '550',                         # U+0x017B
        'zdot' => '474',                         # U+0x017C
        'caron' => '524',                        # U+0x02C7
        'breve' => '524',                        # U+0x02D8
        'dotaccent' => '524',                    # U+0x02D9
        'ring' => '524',                         # U+0x02DA
        'ogonek' => '524',                       # U+0x02DB
        'hungarumlaut' => '524',                 # U+0x02DD
        'Delta' => '584',                        # U+0x0394
        'Omega' => '668',                        # U+0x03A9
        'pi' => '601',                           # U+0x03C0
        'fraction' => '528',                     # U+0x2044
        'franc' => '941',                        # U+0x20A3
        'partialdiff' => '549',                  # U+0x2202
        'product' => '552',                      # U+0x220F
        'summation' => '524',                    # U+0x2211
        'minus' => '524',                        # U+0x2212
        'radical' => '524',                      # U+0x221A
        'infinity' => '524',                     # U+0x221E
        'integral' => '524',                     # U+0x222B
        'approxequal' => '524',                  # U+0x2248
        'notequal' => '524',                     # U+0x2260
        'lessequal' => '524',                    # U+0x2264
        'greaterequal' => '524',                 # U+0x2265
        'lozenge' => '494',                      # U+0x25CA
        'dotlessj' => '366',                     # U+0xF6BE
        'fi' => '636',                           # U+0xFB01
        'fl' => '672',                           # U+0xFB02
    }, # HORIZ. WIDTH TABLE
} };

1;
