# A Closer Look at a Distribution

Now that you know your way around `Dist::Zilla` a bit, it's time to take a
closer look at its output through a broad examination of the distribution we
created with the `[@Starter]` bundle in the last tutorial. As this is only a
tutorial, we will provide just enough information to satisfy the curious and set
the stage for some more advanced tutorials. But an entire book could be written
about all the different components of a Perl distribution that we definitely
aren't getting paid well enough to document here.

## Your Module's Distribution

In the `App::sayhi` work area, do:

`dzil build`

You should now have the `sayhi-0.001` distribution and `sayhi-0.001.tar.gz` in
your directory.

Dive down into your distribution's directory, also known as your **"build
tree,"** with `cd sayhi-0.001`, and we'll step through each of the files and
directories we see from left to right with the `ls -l` command.

### The `bin` Directory

Nothing exciting here. This is where your `sayhi` command is stored.

### `dist.ini` File

It's considered good practice to ship your `dist.ini` file along with your
distribution so the `[@Starter]` bundle places a copy of it in your build tree
for you.

### The `lib` Directory

This is where your modules live.

### LICENSE

Yup, this contains a copy of your license. The license is automatically
generated for you based on the setting in your default configuration using the
`[License]` plugin. If you want to override the default license, the easiest
thing to do is to modify your `dist.ini` file. You can get a list of available
licenses in the [`[License]` plugin's
documentation](https://metacpan.org/pod/Software::License).

As you might imagine, other advanced plugins are available for generating the
license file. We'll leave that for you to explore.

### Makefile.PL

This is by far the most complicated part of your distribution and is at the
heart of it. You have encountered the `Makefile.PL` if you have ever installed a
Perl module manually with the magic incantation, `perl Makefile.pl`.

`Makefile.PL` is what's known as a "build script" and one of its main jobs is to
build you distribution. However, this job is completely replaced by
`Dist::Zilla` which now does all of distribution building for you. So why does
`Dist::Zilla` bother creating the `Makefile.PL` script?

`Dist::Zilla` still relies on the `Makefile.PL` script to run tests on the
distribution and to create the tarball. Most importantly, `Makefile.PL` is
needed to install the modules after the distribution is downloaded to another
computer.

Going into detail on how `Makefile.PL` works is beyond the scope of this
tutorial. But we encourage you to read up on it and get familiar with it
especially if you want to become a `Dist::Zilla` pro and write all kinds of
advanced plugins.

### The MANIFEST

Nothing too interesting here, just a straight up listing of all the files in the
distribution. It's mostly there to help the installer do its thing, install your
software.

### META.yml and META.json

These two files contain meta information about your module.  Strictly speaking
you don't need both, but it's good practice and since `Dist::Zilla` does all the
hard work of generating them for you, it's no skin off your back.  These files
are generated by the `[MetaYAML]` and `[MetaJSON]` plugins.

Meta files have a couple of important roles in our distribution. First they are
used by CPAN to tell the world about your module and to automatically generate
technical documentation about your module for human consumption. They are also
used by installers to determine some basic requirements for your module's
installation.

If you're interested to know, the json format is the more modern standard and
can provide more metadata than the yaml file format. But we still need the yaml
format hanging around to keep users with more ancient installers happy. The
default `[@Basic]` bundle doesn't yet include the `[MetaJSON]`, another good
reason to take the time to install the `[@Starter]` bundle and use it instead.

### README, Please!

Here is our lowly, plain text `README` file. There are no requirements for what
should go into the `README` file. But more and more we see developers stuffing
their POD into them as GitHub has risen to prominence and made `README` files
useful again. So, we have done the same. It's certainly better than the other
useless information you usually find in them.

### Testing 1, 2, 3

Lastly, we see two directories, `t` and `xt`. If you are familiar with testing
Perl modules, you'll recognize these directories as the home of the module tests
that get run by you and the installer to make sure your module works as
expected.

Using `Dist::Zilla` to test your distribution is a topic worthy of a tutorial
all by itself. Continue on to the next tutorial to learn more.

### Wait! What about...?

Some of you might notice the distribution contains no `INSTALL` file, `Changes`
file or some other file you'd like to include in your own distribution. Rest
assured they can likely be added by an existing plugins and most certainly by
any custom plugin you wish to write. Some plugins for generating more commonly
used distribution files will be covered in later tutorials.
