# Generated by default/object.tt
package Paws::NetworkFirewall::RuleOption;
  use Moose;
  has Keyword => (is => 'ro', isa => 'Str', required => 1);
  has Settings => (is => 'ro', isa => 'ArrayRef[Str|Undef]');

1;

### main pod documentation begin ###

=head1 NAME

Paws::NetworkFirewall::RuleOption

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::NetworkFirewall::RuleOption object:

  $service_obj->Method(Att1 => { Keyword => $value, ..., Settings => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::NetworkFirewall::RuleOption object:

  $result = $service_obj->Method(...);
  $result->Att1->Keyword

=head1 DESCRIPTION

Additional settings for a stateful rule. This is part of the
StatefulRule configuration.

=head1 ATTRIBUTES


=head2 B<REQUIRED> Keyword => Str




=head2 Settings => ArrayRef[Str|Undef]





=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::NetworkFirewall>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

