#include "uulib/pack.h"

void uu_pack(const struct uu *in, uu_t out) {
  U32 tmp;
  //U8  *out = ptr;

  tmp = in->time_low;
  out[3] = (U8)tmp; tmp >>= 8;
  out[2] = (U8)tmp; tmp >>= 8;
  out[1] = (U8)tmp; tmp >>= 8;
  out[0] = (U8)tmp;

  tmp = in->time_mid;
  out[5] = (U8)tmp; tmp >>= 8;
  out[4] = (U8)tmp;

  tmp = in->time_high_and_version;
  out[7] = (U8)tmp; tmp >>= 8;
  out[6] = (U8)tmp;

  tmp = in->clock_seq_and_variant;
  out[9] = (U8)tmp; tmp >>= 8;
  out[8] = (U8)tmp;

  memcpy(out+10, in->node, 6);
}

void uu_pack6(const struct uu6 *in, uu_t out) {
  U32 tmp;

  tmp = in->time_high;
  out[3] = (U8)tmp; tmp >>= 8;
  out[2] = (U8)tmp; tmp >>= 8;
  out[1] = (U8)tmp; tmp >>= 8;
  out[0] = (U8)tmp;

  tmp = in->time_mid;
  out[5] = (U8)tmp; tmp >>= 8;
  out[4] = (U8)tmp;

  tmp = in->time_low_and_version;
  out[7] = (U8)tmp; tmp >>= 8;
  out[6] = (U8)tmp;

  tmp = in->clock_seq_and_variant;
  out[9] = (U8)tmp; tmp >>= 8;
  out[8] = (U8)tmp;

  memcpy(out+10, in->node, 6);
}

/* ex:set ts=2 sw=2 itab=spaces: */
