use Test::More;
use strict;
use warnings;
our ( $sub, $globref );

BEGIN {
	use_ok('String::Locale::Object');
	$sub     = sub { };
	$globref = \*globref;
}
subtest 'new' => sub {
	plan tests => 19;
	ok( my $obj = String::Locale::Object->new( { locale => 'algea' } ),
		q{my $obj = String::Locale::Object->new({locale => 'algea'})}
	);
	ok( $obj = String::Locale::Object->new( locale => 'algea' ),
		q{$obj = String::Locale::Object->new(locale => 'algea')}
	);
	isa_ok( $obj, 'String::Locale::Object' );
	ok( $obj = String::Locale::Object->new(
			{   language => 'hypnos',
				locale   => 'algea',
				locales  => { 'nosoi' => { 'test' => 'test' } }
			}
		),
		q{$obj = String::Locale::Object->new({language => 'hypnos', locale => 'algea', locales => { 'nosoi' => { 'test' => 'test' } }})}
	);
	ok( $obj = String::Locale::Object->new(
			language => 'hypnos',
			locale   => 'algea',
			locales  => { 'nosoi' => { 'test' => 'test' } }
		),
		q{$obj = String::Locale::Object->new(language => 'hypnos', locale => 'algea', locales => { 'nosoi' => { 'test' => 'test' } })}
	);
	is_deeply( $obj->fb, 'en', q{$obj->fb} );
	ok( $obj = String::Locale::Object->new(
			{   fb       => 'phobos',
				language => 'hypnos',
				locale   => 'algea',
				locales  => { 'nosoi' => { 'test' => 'test' } }
			}
		),
		q{$obj = String::Locale::Object->new({ fb => 'phobos', language => 'hypnos', locale => 'algea', locales => { 'nosoi' => { 'test' => 'test' } } })}
	);
	eval {
		$obj = String::Locale::Object->new(
			{   fb       => [],
				language => 'hypnos',
				locale   => 'algea',
				locales  => { 'nosoi' => { 'test' => 'test' } }
			}
		);
	};
	like( $@, qr/invalid|type|constraint|greater|atleast/,
		q{$obj = String::Locale::Object->new({ fb => [], language => 'hypnos', locale => 'algea', locales => { 'nosoi' => { 'test' => 'test' } } })}
	);
	eval {
		$obj = String::Locale::Object->new(
			{   fb       => \1,
				language => 'hypnos',
				locale   => 'algea',
				locales  => { 'nosoi' => { 'test' => 'test' } }
			}
		);
	};
	like( $@, qr/invalid|type|constraint|greater|atleast/,
		q{$obj = String::Locale::Object->new({ fb => \1, language => 'hypnos', locale => 'algea', locales => { 'nosoi' => { 'test' => 'test' } } })}
	);
	eval {
		$obj = String::Locale::Object->new(
			{   fb       => 'phobos',
				language => [],
				locale   => 'algea',
				locales  => { 'nosoi' => { 'test' => 'test' } }
			}
		);
	};
	like( $@, qr/invalid|type|constraint|greater|atleast/,
		q{$obj = String::Locale::Object->new({ fb => 'phobos', language => [], locale => 'algea', locales => { 'nosoi' => { 'test' => 'test' } } })}
	);
	eval {
		$obj = String::Locale::Object->new(
			{   fb       => 'phobos',
				language => \1,
				locale   => 'algea',
				locales  => { 'nosoi' => { 'test' => 'test' } }
			}
		);
	};
	like( $@, qr/invalid|type|constraint|greater|atleast/,
		q{$obj = String::Locale::Object->new({ fb => 'phobos', language => \1, locale => 'algea', locales => { 'nosoi' => { 'test' => 'test' } } })}
	);
	eval {
		$obj = String::Locale::Object->new(
			{   fb       => 'phobos',
				language => 'hypnos',
				locales  => { 'nosoi' => { 'test' => 'test' } }
			}
		);
	};
	like( $@, qr/required/,
		q{$obj = String::Locale::Object->new({fb => 'phobos', language => 'hypnos', locales => { 'nosoi' => { 'test' => 'test' } }})}
	);
	eval {
		$obj = String::Locale::Object->new(
			{   fb       => 'phobos',
				language => 'hypnos',
				locale   => [],
				locales  => { 'nosoi' => { 'test' => 'test' } }
			}
		);
	};
	like( $@, qr/invalid|type|constraint|greater|atleast/,
		q{$obj = String::Locale::Object->new({ fb => 'phobos', language => 'hypnos', locale => [], locales => { 'nosoi' => { 'test' => 'test' } } })}
	);
	eval {
		$obj = String::Locale::Object->new(
			{   fb       => 'phobos',
				language => 'hypnos',
				locale   => \1,
				locales  => { 'nosoi' => { 'test' => 'test' } }
			}
		);
	};
	like( $@, qr/invalid|type|constraint|greater|atleast/,
		q{$obj = String::Locale::Object->new({ fb => 'phobos', language => 'hypnos', locale => \1, locales => { 'nosoi' => { 'test' => 'test' } } })}
	);
	eval {
		$obj = String::Locale::Object->new(
			{   fb       => 'phobos',
				language => 'hypnos',
				locale   => 'algea',
				locales  => { 'nosoi' => [] }
			}
		);
	};
	like( $@, qr/invalid|type|constraint|greater|atleast/,
		q{$obj = String::Locale::Object->new({ fb => 'phobos', language => 'hypnos', locale => 'algea', locales => { 'nosoi' => [] } })}
	);
	eval {
		$obj = String::Locale::Object->new(
			{   fb       => 'phobos',
				language => 'hypnos',
				locale   => 'algea',
				locales  => { 'nosoi' => 'limos' }
			}
		);
	};
	like( $@, qr/invalid|type|constraint|greater|atleast/,
		q{$obj = String::Locale::Object->new({ fb => 'phobos', language => 'hypnos', locale => 'algea', locales => { 'nosoi' => 'limos' } })}
	);
	eval {
		$obj = String::Locale::Object->new(
			{   fb       => 'phobos',
				language => 'hypnos',
				locale   => 'algea',
				locales  => { 'nosoi' => undef }
			}
		);
	};
	like( $@, qr/invalid|type|constraint|greater|atleast/,
		q{$obj = String::Locale::Object->new({ fb => 'phobos', language => 'hypnos', locale => 'algea', locales => { 'nosoi' => undef } })}
	);
	eval {
		$obj = String::Locale::Object->new(
			{   fb       => 'phobos',
				language => 'hypnos',
				locale   => 'algea',
				locales  => []
			}
		);
	};
	like( $@, qr/invalid|type|constraint|greater|atleast/,
		q{$obj = String::Locale::Object->new({ fb => 'phobos', language => 'hypnos', locale => 'algea', locales => [] })}
	);
	eval {
		$obj = String::Locale::Object->new(
			{   fb       => 'phobos',
				language => 'hypnos',
				locale   => 'algea',
				locales  => 'algea'
			}
		);
	};
	like( $@, qr/invalid|type|constraint|greater|atleast/,
		q{$obj = String::Locale::Object->new({ fb => 'phobos', language => 'hypnos', locale => 'algea', locales => 'algea' })}
	);
};
subtest 'has fb' => sub {
	plan tests => 6;
	ok( my $obj = String::Locale::Object->new( { locale => 'algea' } ),
		q{my $obj = String::Locale::Object->new({locale => 'algea'})}
	);
	can_ok( $obj, 'fb' );
	is_deeply( $obj->fb('algea'), 'algea', q{$obj->fb('algea')} );
	eval { $obj->fb( [] ) };
	like( $@, qr/invalid|value|type|constraint|greater|atleast/,
		q{$obj->fb([])} );
	eval { $obj->fb( \1 ) };
	like( $@, qr/invalid|value|type|constraint|greater|atleast/,
		q{$obj->fb(\1)} );
	is_deeply( $obj->fb, 'algea', q{$obj->fb} );
};
subtest 'has locale' => sub {
	plan tests => 6;
	ok( my $obj = String::Locale::Object->new( { locale => 'algea' } ),
		q{my $obj = String::Locale::Object->new({locale => 'algea'})}
	);
	can_ok( $obj, 'locale' );
	is_deeply( $obj->locale('penthos'),
		'penthos', q{$obj->locale('penthos')} );
	eval { $obj->locale( [] ) };
	like( $@, qr/invalid|value|type|constraint|greater|atleast/,
		q{$obj->locale([])} );
	eval { $obj->locale( \1 ) };
	like( $@, qr/invalid|value|type|constraint|greater|atleast/,
		q{$obj->locale(\1)} );
	is_deeply( $obj->locale, 'penthos', q{$obj->locale} );
};
subtest '_set_language_from_locale' => sub {
	plan tests => 5;
	ok( my $obj = String::Locale::Object->new( { locale => 'algea' } ),
		q{my $obj = String::Locale::Object->new({locale => 'algea'})}
	);
	can_ok( $obj, '_set_language_from_locale' );
	eval { $obj->_set_language_from_locale( [] ) };
	like(
		$@,
		qr/invalid|value|type|constraint|greater|atleast/,
		q{$obj->_set_language_from_locale([])}
	);
	eval { $obj->_set_language_from_locale( \1 ) };
	like(
		$@,
		qr/invalid|value|type|constraint|greater|atleast/,
		q{$obj->_set_language_from_locale(\1)}
	);
	eval { $obj->_set_language_from_locale() };
	like( $@, qr/undef/, q{$obj->_set_language_from_locale()} );
};
subtest 'has language' => sub {
	plan tests => 7;
	ok( my $obj = String::Locale::Object->new( { locale => 'algea' } ),
		q{my $obj = String::Locale::Object->new({locale => 'algea'})}
	);
	can_ok( $obj, 'language' );
	is( $obj->language, undef, q{$obj->language} );
	is_deeply( $obj->language('thanatos'),
		'thanatos', q{$obj->language('thanatos')} );
	eval { $obj->language( [] ) };
	like( $@, qr/invalid|value|type|constraint|greater|atleast/,
		q{$obj->language([])} );
	eval { $obj->language( \1 ) };
	like( $@, qr/invalid|value|type|constraint|greater|atleast/,
		q{$obj->language(\1)} );
	is_deeply( $obj->language, 'thanatos', q{$obj->language} );
};
subtest 'has_language' => sub {
	plan tests => 5;
	ok( my $obj = String::Locale::Object->new( { locale => 'algea' } ),
		q{my $obj = String::Locale::Object->new({locale => 'algea'})}
	);
	can_ok( $obj, 'has_language' );
	is( $obj->has_language, '', q{$obj->has_language} );
	is_deeply( $obj->language('thanatos'),
		'thanatos', q{$obj->language('thanatos')} );
	is( $obj->has_language, 1, q{$obj->has_language} );
};
subtest 'has locales' => sub {
	plan tests => 9;
	ok( my $obj = String::Locale::Object->new( { locale => 'algea' } ),
		q{my $obj = String::Locale::Object->new({locale => 'algea'})}
	);
	can_ok( $obj, 'locales' );
	is_deeply(
		$obj->locales( { 'penthos' => { 'test' => 'test' } } ),
		{ 'penthos' => { 'test' => 'test' } },
		q{$obj->locales({ 'penthos' => { 'test' => 'test' } })}
	);
	eval { $obj->locales( { 'penthos' => [] } ) };
	like(
		$@,
		qr/invalid|value|type|constraint|greater|atleast/,
		q{$obj->locales({ 'penthos' => [] })}
	);
	eval { $obj->locales( { 'penthos' => 'curae' } ) };
	like(
		$@,
		qr/invalid|value|type|constraint|greater|atleast/,
		q{$obj->locales({ 'penthos' => 'curae' })}
	);
	eval { $obj->locales( { 'penthos' => undef } ) };
	like(
		$@,
		qr/invalid|value|type|constraint|greater|atleast/,
		q{$obj->locales({ 'penthos' => undef })}
	);
	eval { $obj->locales( [] ) };
	like( $@, qr/invalid|value|type|constraint|greater|atleast/,
		q{$obj->locales([])} );
	eval { $obj->locales('penthos') };
	like( $@, qr/invalid|value|type|constraint|greater|atleast/,
		q{$obj->locales('penthos')} );
	is_deeply( $obj->locales, { 'penthos' => { 'test' => 'test' } },
		q{$obj->locales} );
};
subtest '_build_locales' => sub {
	plan tests => 4;
	ok( my $obj = String::Locale::Object->new( { locale => 'algea' } ),
		q{my $obj = String::Locale::Object->new({locale => 'algea'})}
	);
	can_ok( $obj, '_build_locales' );
	eval { $obj->_build_locales( [] ) };
	like( $@, qr/invalid|value|type|constraint|greater|atleast/,
		q{$obj->_build_locales([])} );
	eval { $obj->_build_locales('phobos') };
	like(
		$@,
		qr/invalid|value|type|constraint|greater|atleast/,
		q{$obj->_build_locales('phobos')}
	);
};
subtest 'convert_locale' => sub {
	plan tests => 6;
	ok( my $obj = String::Locale::Object->new( { locale => 'algea' } ),
		q{my $obj = String::Locale::Object->new({locale => 'algea'})}
	);
	can_ok( $obj, 'convert_locale' );
	eval { $obj->convert_locale( [], 'phobos' ) };
	like(
		$@,
		qr/invalid|value|type|constraint|greater|atleast/,
		q{$obj->convert_locale([], 'phobos')}
	);
	eval { $obj->convert_locale( \1, 'phobos' ) };
	like(
		$@,
		qr/invalid|value|type|constraint|greater|atleast/,
		q{$obj->convert_locale(\1, 'phobos')}
	);
	eval { $obj->convert_locale( 'algea', [] ) };
	like(
		$@,
		qr/invalid|value|type|constraint|greater|atleast/,
		q{$obj->convert_locale('algea', [])}
	);
	eval { $obj->convert_locale( 'algea', \1 ) };
	like(
		$@,
		qr/invalid|value|type|constraint|greater|atleast/,
		q{$obj->convert_locale('algea', \1)}
	);
};
subtest 'add' => sub {
	plan tests => 9;
	ok( my $obj = String::Locale::Object->new( { locale => 'algea' } ),
		q{my $obj = String::Locale::Object->new({locale => 'algea'})}
	);
	can_ok( $obj, 'add' );
	eval { $obj->add( [], { 'nosoi' => { 'test' => 'test' } } ) };
	like(
		$@,
		qr/invalid|value|type|constraint|greater|atleast/,
		q{$obj->add([], { 'nosoi' => { 'test' => 'test' } })}
	);
	eval { $obj->add( \1, { 'nosoi' => { 'test' => 'test' } } ) };
	like(
		$@,
		qr/invalid|value|type|constraint|greater|atleast/,
		q{$obj->add(\1, { 'nosoi' => { 'test' => 'test' } })}
	);
	eval { $obj->add( 'nosoi', { 'nosoi' => [] } ) };
	like(
		$@,
		qr/invalid|value|type|constraint|greater|atleast/,
		q{$obj->add('nosoi', { 'nosoi' => [] })}
	);
	eval { $obj->add( 'nosoi', { 'nosoi' => 'aporia' } ) };
	like(
		$@,
		qr/invalid|value|type|constraint|greater|atleast/,
		q{$obj->add('nosoi', { 'nosoi' => 'aporia' })}
	);
	eval { $obj->add( 'nosoi', { 'nosoi' => undef } ) };
	like(
		$@,
		qr/invalid|value|type|constraint|greater|atleast/,
		q{$obj->add('nosoi', { 'nosoi' => undef })}
	);
	eval { $obj->add( 'nosoi', [] ) };
	like(
		$@,
		qr/invalid|value|type|constraint|greater|atleast/,
		q{$obj->add('nosoi', [])}
	);
	eval { $obj->add( 'nosoi', 'limos' ) };
	like(
		$@,
		qr/invalid|value|type|constraint|greater|atleast/,
		q{$obj->add('nosoi', 'limos')}
	);
};
subtest 'string' => sub {
	plan tests => 10;
	ok( my $obj = String::Locale::Object->new( { locale => 'algea' } ),
		q{my $obj = String::Locale::Object->new({locale => 'algea'})}
	);
	can_ok( $obj, 'string' );
	eval { $obj->string( [], 'penthos', 'hypnos', 'hypnos' ) };
	like(
		$@,
		qr/invalid|value|type|constraint|greater|atleast/,
		q{$obj->string([], 'penthos', 'hypnos', 'hypnos')}
	);
	eval { $obj->string( \1, 'penthos', 'hypnos', 'hypnos' ) };
	like(
		$@,
		qr/invalid|value|type|constraint|greater|atleast/,
		q{$obj->string(\1, 'penthos', 'hypnos', 'hypnos')}
	);
	eval { $obj->string( 'phobos', [], 'hypnos', 'hypnos' ) };
	like(
		$@,
		qr/invalid|value|type|constraint|greater|atleast/,
		q{$obj->string('phobos', [], 'hypnos', 'hypnos')}
	);
	eval { $obj->string( 'phobos', \1, 'hypnos', 'hypnos' ) };
	like(
		$@,
		qr/invalid|value|type|constraint|greater|atleast/,
		q{$obj->string('phobos', \1, 'hypnos', 'hypnos')}
	);
	eval { $obj->string( 'phobos', 'penthos', [], 'hypnos' ) };
	like(
		$@,
		qr/invalid|value|type|constraint|greater|atleast/,
		q{$obj->string('phobos', 'penthos', [], 'hypnos')}
	);
	eval { $obj->string( 'phobos', 'penthos', \1, 'hypnos' ) };
	like(
		$@,
		qr/invalid|value|type|constraint|greater|atleast/,
		q{$obj->string('phobos', 'penthos', \1, 'hypnos')}
	);
	eval { $obj->string( 'phobos', 'penthos', 'hypnos', [] ) };
	like(
		$@,
		qr/invalid|value|type|constraint|greater|atleast/,
		q{$obj->string('phobos', 'penthos', 'hypnos', [])}
	);
	eval { $obj->string( 'phobos', 'penthos', 'hypnos', \1 ) };
	like(
		$@,
		qr/invalid|value|type|constraint|greater|atleast/,
		q{$obj->string('phobos', 'penthos', 'hypnos', \1)}
	);
};
subtest 'DESTROY' => sub {
	plan tests => 2;
	ok( my $obj = String::Locale::Object->new( { locale => 'algea' } ),
		q{my $obj = String::Locale::Object->new({locale => 'algea'})}
	);
	can_ok( $obj, 'DESTROY' );
};
subtest 'AUTOLOAD' => sub {
	plan tests => 2;
	ok( my $obj = String::Locale::Object->new( { locale => 'algea' } ),
		q{my $obj = String::Locale::Object->new({locale => 'algea'})}
	);
	can_ok( $obj, 'AUTOLOAD' );
};
done_testing();
