/* This file is part of dvi2bitmap; see README for copyrights and licence */

#include <config.h>

#ifdef HAVE_CSTD_INCLUDE
#include <cstdio>
#include <cstdarg>
#include <cstring>		// for strlen
#else
#include <stdio.h>
#include <stdarg.h>
#include <string.h>
#endif
#include <string>
#include <iostream>

#include "DviError.h"

DviError::DviError(const char *fmt,...)
{
    char *p = new char[2*STD::strlen(fmt)];
    va_list ap;
    va_start(ap,fmt);
    STD::vsprintf (p, fmt, ap);
    va_end(ap);
    problem_ = p;
    delete[] p;
}

void DviError::print() const {
    STD::cerr << "DVI error: " << problem_ << STD::endl; }
void DviBug::print() const {
    STD::cerr << "BUG: " << problem_ << STD::endl; }

DviBug::DviBug(const char *fmt,...)
{
    char *p = new char[2*STD::strlen(fmt)];
    va_list ap;
    va_start(ap,fmt);
    vsprintf (p, fmt, ap);
    va_end(ap);
    problem_ = p;
    delete[] p;
}

