/***************************/
/* liste.c                 */
/***************************/

#include <stdio.h>
#include <stdlib.h>
#include "liste.h"

void note_insert(oct, pit, laut, t, chann)
	int oct, pit, laut, chann;
	unsigned long int t;
{
	struct element *ptr, *ende;

	if ((ptr = (struct element *) malloc (sizeof(struct element))) == NULL) {
		fprintf(stderr, "malloc error\n");
		exit(10);
	}

	ptr->oct = oct;
	ptr->pit = pit;
	ptr->laut = laut;
	ptr->t   = t;
	ptr->chann = chann;
	ptr->folger = NULL;
	if (anker) {
		for (ende = anker; ende->folger; ende = ende->folger);
		ende->folger = ptr;
		return;
	}
	anker = ptr;

}

int note_delete(oct, pit, laut, zeit, beg, ch)
	int oct, pit, ch, *laut;
	unsigned long int zeit, *beg;
{
	struct element *ptr1, *ptr2;
	unsigned long int delta;

	if ((ptr1 = anker) == NULL) {
		fprintf(stderr, "oct %d, pit %d not found\n", oct, pit);
		exit(10);
	}
	if ((anker->oct == oct) && (anker->pit == pit) && (anker->chann == ch)) {
		*laut = anker->laut;
		*beg = anker->t;
		if ((delta = zeit - anker->t) <= 0) {
			fprintf(stderr, "note_loeschen: delta = %ld\n", delta);
			exit(10);
		}
		anker = anker->folger;
		free(ptr1);
		return(delta);
	}
	for(ptr2 = ptr1, ptr1 = ptr1->folger; ptr1; ptr2 = ptr1, ptr1 = ptr1->folger) {
		if ((ptr1->oct == oct) && (ptr1->pit == pit)) {
			*beg = ptr1->t;
			*laut = ptr1->laut;
			if ((delta = zeit - ptr1->t) <= 0) {
				fprintf(stderr, "note_loeschen: delta = %ld\n", delta);
				exit(10);
			}
			ptr2->folger = ptr1->folger;
			free(ptr1);
			return(delta);
		}
	}
	fprintf(stderr, "oct %d, pit %d not found\n", oct, pit);
	exit(10);
}
	
		
int search_note(oct, pit, laut, zeit, beg, ch)
	int *oct, *pit, *laut, *ch;
	unsigned long int zeit, *beg;
{
	struct element *ptr;
	int delta;

	if (!anker) return (-1);
	
	ptr = anker;
	*oct = anker->oct;
	*pit = anker->pit;
	*laut = anker->laut;
	*beg = anker->t;
	*ch = anker->chann;
	if ((delta = zeit - anker->t) <= 0) {
		fprintf(stderr, "note_loeschen: delta = %d\n", delta);
		exit(10);
	}
	anker = anker->folger;
	free (ptr);
	return(delta);
}
