/* Output from p2c 1.21alpha2-dt-Jul.95, the Pascal-to-C translator */
/* From input file "rtflatex.pas" */
 
 
#include "p2crtf.h"
#include "p2c_mods.h"
#include "p2clib_m.c"
 
 
/* version 2.15 */
 
 
#define lmx             511
#define olmx            1023
#define maxlevel        72
#define maxkeyln        64
#define bfslen          24
#define numsizes        16
#define maxfonts        128
#define maxstyles       12
#define max_skip_strings  8
#define maxRTFstyles    64
#define RTFstyle_length  128
 
 
typedef Char string24[bfslen + 1];
 
typedef Char string2[3];
 
typedef Char string5[6];
 
typedef Char string128[129];
 
typedef Char string255[256];
 
typedef Char exline_type[olmx];
typedef Char string_RTFstyle[RTFstyle_length + 1];
 
 
Static FILE *inputfile, *outputfile, *figurefile, *logfile, *skipfile;
Static short catcode[256], digit[256], majusc[256], letter[256];
Static string24 acc_transl[256], ftech_transl[256];
Static Char prev_line[lmx], inpline[lmx];
Static exline_type exline;
Static short tex_verbose, verbose, icharz, numl, kout, kinp, prev_kinp,
	     bracelvl;
Static short lvlcode[maxlevel + 1], tab_nb_cellx[maxlevel + 1],
	     tab_nb_ands[maxlevel + 1], tab_cellx[maxlevel + 1];
Static Char kar, hexaone, hexatwo;
Static string255 next_rtf;
Static boolean removed_ok, write_log, do_it_again, no_space_conv, use_sl,
	       latex209, latex_header, base_flag, envir_closed_ok,
	       last_percent, simplify_ok, no_RTFrtf, par_to_begin;
Static short num_styles, input_line_number, numfonts, num_word_fonts, stdsize,
	     stdkz;
Static string24 close_kar[maxlevel + 1], form_code[maxlevel + 1],
		bfslcode[maxlevel + 1], sizecode[maxlevel + 1],
		currsize[maxlevel + 1], currbfsl[maxlevel + 1],
		spacingcode[maxlevel + 1], active_RTFf[maxlevel + 1];
Static short center_flag[maxlevel + 1], flushright_flag[maxlevel + 1],
	     math_mode[maxlevel + 1];
Static boolean underl_flag[maxlevel + 1], auto_close[maxlevel + 1];
Static string24 sizekey[numsizes];
Static short sizeval[3][numsizes];
Static short sizemags[3][numsizes];
Static string24 newfonts[maxfonts], word_fonts[maxfonts],
		equiv_fonts[maxfonts], font_names[maxfonts];
Static short word_font_num[maxfonts];
Static string255 inkeyw;
Static short num_diff_sizes, keyw, cat, ikar, numval, numsign, num_hexa,
	     num_skip_strings, decl_font_num, num_latex_options, num_indent,
	     i, j, k, l, m, n;
Static string24 works, worksa, worksb, latex_style, end_math_code;
Static string24 latex_options[maxstyles + 1];
Static string24 environ_type[11];
Static string255 skip_strings[max_skip_strings];
Static short leftskip, rightskip, leftcurskip, rightcurskip, save_skip,
	     space_after, displ_skip;
Static string_RTFstyle RTFstyles[maxRTFstyles];
Static short ref_styles[256];
 
Static boolean clbrdrr, clbrdrl, clbrdrt, clbrdrb;
 
/* indications to build file names of figure bitmaps */
Static string128 figure_name, figure_path, figure_type;
Static string24 pict_name;
Static long rtfpicw, rtfpich, pict_char_number, pict_byte_number;
Static short pict_last_hexa, pict_number;
Static boolean pict_left_hexa;
Static Char last_kar;
Static Char inputfile_NAME[_FNSIZE];
Static Char outputfile_NAME[_FNSIZE];
Static Char figurefile_NAME[_FNSIZE];
Static Char logfile_NAME[_FNSIZE];
Static Char skipfile_NAME[_FNSIZE];
 
 
/*---------------------------------------------------------------------------*/
/* resets all integers to 0, all strings to '', for safety */
 
Static Void clean_all()
{
  short z;
 
  for (z = 1; z <= lmx; z++)
    prev_line[k-1] = ' ';
  for (z = 1; z <= lmx; z++)
    inpline[k-1] = ' ';
  for (z = 1; z <= olmx; z++)
    exline[k-1] = ' ';
 
  tex_verbose = 0;
  verbose = 0;
  icharz = 0;
  numl = 0;
  kout = 0;
  kinp = 0;
  prev_kinp = 0;
  bracelvl = 0;
 
  for (z = 0; z <= maxlevel; z++) {
    lvlcode[z] = 0;
    tab_nb_cellx[z] = 0;
    tab_nb_ands[z] = 0;
    tab_cellx[z] = 0;
  }
  kar = ' ';
  hexaone = ' ';
  hexatwo = ' ';
 
  *next_rtf = '\0';
  removed_ok = false;
  write_log = false;
  do_it_again = false;
  no_space_conv = false;
  use_sl = false;
  latex209 = false;
  latex_header = false;
  base_flag = false;
  envir_closed_ok = false;
  last_percent = false;
  simplify_ok = false;
  no_RTFrtf = false;
  par_to_begin = false;
 
  num_styles = 0;
  input_line_number = 0;
  numfonts = 0;
  num_word_fonts = 0;
  stdsize = 0;
  stdkz = 0;
 
  for (z = 0; z <= maxlevel; z++) {
    *close_kar[z] = '\0';
    *form_code[z] = '\0';
    *bfslcode[z] = '\0';
    *sizecode[z] = '\0';
    *currsize[z] = '\0';
    *currbfsl[z] = '\0';
    *spacingcode[z] = '\0';
    *active_RTFf[z] = '\0';
    center_flag[z] = 0;
    flushright_flag[z] = 0;
    math_mode[z] = 0;
    underl_flag[z] = false;
    auto_close[z] = false;
  }
  /*  sizekey : array[1..numsizes] of string24; */
  /*  sizeval : array[1..3,1..numsizes] of integer; */
  /*  sizemags : array[1..3,1..numsizes] of integer; */
  for (z = 0; z <= maxfonts - 1; z++) {
    *newfonts[z] = '\0';
    *word_fonts[z] = '\0';
    *equiv_fonts[z] = '\0';
    *font_names[z] = '\0';
    word_font_num[z] = 0;
  }
  *inkeyw = '\0';
  num_diff_sizes = 0;
  keyw = 0;
  cat = 0;
  ikar = 0;
  numval = 0;
  numsign = 0;
  num_hexa = 0;
  num_skip_strings = 0;
  decl_font_num = 0;
  num_latex_options = 0;
  num_indent = 0;
  i = 0;
  j = 0;
  k = 0;
  l = 0;
  m = 0;
  n = 0;
  *works = '\0';
  *worksa = '\0';
  *worksb = '\0';
  *latex_style = '\0';
  *end_math_code = '\0';
 
  for (z = 0; z <= maxstyles; z++)
    *latex_options[z] = '\0';
  for (z = 0; z <= 10; z++)
    *environ_type[z] = '\0';
  for (z = 0; z <= max_skip_strings - 1; z++)
    *skip_strings[z] = '\0';
  leftskip = 0;
  rightskip = 0;
  leftcurskip = 0;
  rightcurskip = 0;
  save_skip = 0;
  space_after = 0;
  displ_skip = 0;
 
  for (z = 0; z <= maxRTFstyles - 1; z++)
    *RTFstyles[z] = '\0';
  for (z = 0; z <= 255; z++)
    ref_styles[z] = 0;
 
  clbrdrr = false;
  clbrdrl = false;
  clbrdrt = false;
  clbrdrb = false;
 
  /* indications to build file names of figure bitmaps */
  *figure_name = '\0';
  *figure_path = '\0';
  *figure_type = '\0';
  *pict_name = '\0';
  rtfpicw = 0;
  rtfpich = 0;
  pict_char_number = 0;
  pict_byte_number = 0;
  pict_last_hexa = 0;
  pict_number = 0;
  pict_left_hexa = false;
  last_kar = ' ';
}
 
 
/*---------------------------------------------------------------------------*/
 
Static Void title()
{
  printf("           MICROSOFT RTF(Word[Perfect]) to LaTeX conversion\n");
  printf("           Daniel Taupin, CNRS, 20th September 1996\n");
  printf("           Universite de Paris-Sud, Orsay, France\n");
  printf("           Version 2.15\n");
  printf("           E-mail: taupin@lps.u-psud.fr\n");
}
 
 
/*---------------------------------------------------------------------------*/
/* converts a hexa character into a number from 0 to 15 */
 
Static short hx_to_i(kar)
Char kar;
{
  short ikar = kar;
  short okar;
 
  if (ikar < '0') {
    okar = 0;
    return okar;
  }
  if (ikar <= '9') {
    okar = ikar - '0';
    return okar;
  }
  if (ikar <= 'Z') {
    okar = ikar + 10 - 'A';
    return okar;
  }
  if (ikar <= 'z')
    okar = ikar + 10 - 'a';
  else
    okar = 0;
  /*END IF ikar */
  return okar;
}
 
 
/*---------------------------------------------------------------------------*/
/* converts a string of two hexa character into a number from 0 to 255 */
 
Static short hs_to_i(input_stg)
Char *input_stg;
{
  return (hx_to_i(input_stg[0]) * 16 + hx_to_i(input_stg[1]));
}
 
 
/*---------------------------------------------------------------------------*/
/* truncate at bfslen a string */
 
Static Char *truncate24(Result, a)
Char *Result;
Char *a;
{
  sprintf(Result, "%.*s", bfslen, a);
  return Result;
/* p2c: rtflatex.h, line 173:
 * Note: Possible faulty string assignment [145] */
/* p2c: rtflatex.h, line 173:
 * Note: string[24] := string[255] => unpredictable crashes */
}
 
 
/* version 2.15 */
 
/*---------------------------------------------------------------------------*/
/* finds the '.' initiating the postfix of the given file name */
 
Static short pos_postfix(xx)
Char *xx;
{
  short Result = 0;
  short i, FORLIM;
 
  FORLIM = strlen(xx);
  for (i = 1; i <= FORLIM; i++) {   /*END DO*/
    if (xx[i-1] == '.')
      Result = i;
    else if (xx[i-1] == ']')
      Result = 0;
    else if (xx[i-1] == '/')
      Result = 0;
    else if (xx[i-1] == '\\')
      Result = 0;
    else if (xx[i-1] == ':')
      Result = 0;
  }
  /*END IF*/
  return Result;
}
 
 
/*---------------------------------------------------------------------------*/
/* the signed variant of str(n,stg) */
 
Static Void sign_str(num, out_sign_str)
short num;
Char *out_sign_str;
{
  string255 sign_work;
  Char STR2[256];
 
  sprintf(sign_work, "%d", num);
  /*  if (num<0) then out_sign_str:='-'+sign_work */
  if (num < 0) {
    sprintf(STR2, "-%s", sign_work);
    truncate24(out_sign_str, STR2);
  } else {
    truncate24(out_sign_str, sign_work);
    /*END IF*/
  }
}
 
 
/*---------------------------------------------------------------------------*/
/* prints/displays a message */
 
Static Void print_msg(verbose_level, msg)
short verbose_level;
Char *msg;
{
  if (verbose >= verbose_level)
    fputs(msg, stdout);
  if (write_log)
    fputs(msg, logfile);
}
 
 
/*---------------------------------------------------------------------------*/
/* prints/displays a message with RETURN */
 
Static Void println_msg(verbose_level, msg)
short verbose_level;
Char *msg;
{
  if (verbose >= verbose_level)
    puts(msg);
  if (write_log)
    fprintf(logfile, "%s\n", msg);
}
 
 
/* ======================================================================= */
/* used at initialization to store one size name (Latex) and its magnitudes */
 
Static Void sizeone(i, s, j, k, l, mag10, mag11, mag12)
short i;
Char *s;
short j, k, l, mag10, mag11, mag12;
{
  truncate24(sizekey[i-1], s);
  sizeval[0][i-1] = j;
  sizemags[0][i-1] = mag10;
  sizeval[1][i-1] = k;
  sizemags[1][i-1] = mag11;
  sizeval[2][i-1] = l;
  sizemags[2][i-1] = mag12;
}
 
 
/* ======================================================================= */
/* initialization of LaTeX font heights <==> size keywords */
 
Static Void sizeinit()
{
  short k;
 
  sizeone(1, "HUGE", 720, 720, 840, 2986, 2986, 3583);
  sizeone(2, "Huge", 600, 600, 720, 2488, 2488, 2986);
  sizeone(3, "huge", 500, 500, 600, 2074, 2074, 2488);
  sizeone(4, "LARGE", 440, 440, 500, 1728, 1728, 2074);
  sizeone(5, "Large", 360, 360, 440, 1440, 1440, 1728);
  sizeone(6, "large", 280, 280, 360, 1200, 1200, 1440);
  sizeone(7, "normalsize", 240, 272, 290, 1000, 1095, 1200);
  sizeone(8, "small", 220, 240, 272, 900, 1000, 1095);
  sizeone(9, "footnotesize", 190, 220, 240, 800, 900, 1000);
  sizeone(10, "scriptsize", 160, 190, 190, 700, 800, 800);
  sizeone(11, "tiny", 120, 140, 140, 500, 600, 600);
  for (k = 12; k <= 16; k++)
    sizeone(k, "tiny", 0, 0, 0, 500, 600, 600);
  num_diff_sizes = 11;
 
  for (k = 0; k <= 10; k++)
    strcpy(environ_type[k], "\\RTFerror");
 
  strcpy(environ_type[0], "document");
  strcpy(environ_type[1], "center");
  strcpy(environ_type[2], "flushright");
 
}
 
 
/* ======================================================================= */
 
Static Void mac_init()
{
  short k;
 
  /* install the conversions of RTF accents (coded \'xx in hexa) */
  /* build a list of conversion of accented letters */
 
  for (k = 0; k <= 255; k++)
    *acc_transl[k] = '\0';
 
  strcpy(acc_transl[hs_to_i("80")], "\"A");
  strcpy(acc_transl[hs_to_i("81")], "\\AA{}");
  strcpy(acc_transl[hs_to_i("82")], "\\c{C}");
  strcpy(acc_transl[hs_to_i("83")], "\\'E");
  strcpy(acc_transl[hs_to_i("84")], "\\~N");
  strcpy(acc_transl[hs_to_i("85")], "\\\"O");
  strcpy(acc_transl[hs_to_i("86")], "\\\"U");
  strcpy(acc_transl[hs_to_i("87")], "\\'a");
  strcpy(acc_transl[hs_to_i("88")], "\\`a");
  strcpy(acc_transl[hs_to_i("89")], "\\^a");
  strcpy(acc_transl[hs_to_i("8a")], "\\\"a");
  strcpy(acc_transl[hs_to_i("8b")], "\\~a");
  strcpy(acc_transl[hs_to_i("8c")], "\\aa{}");
  strcpy(acc_transl[hs_to_i("8d")], "\\c{c}");
  strcpy(acc_transl[hs_to_i("8e")], "\\'e");
  strcpy(acc_transl[hs_to_i("8f")], "\\`e");
  strcpy(acc_transl[hs_to_i("90")], "\\^e");
  strcpy(acc_transl[hs_to_i("91")], "\\\"e");
  strcpy(acc_transl[hs_to_i("93")], "\\'{\\i}");
  strcpy(acc_transl[hs_to_i("93")], "\\`{\\i}");
  strcpy(acc_transl[hs_to_i("94")], "\\^{\\i}");
  strcpy(acc_transl[hs_to_i("95")], "\\\"{\\i}");
  strcpy(acc_transl[hs_to_i("96")], "\\~n");
  strcpy(acc_transl[hs_to_i("97")], "\\'o");
  strcpy(acc_transl[hs_to_i("98")], "\\`o");
  strcpy(acc_transl[hs_to_i("99")], "\\^o");
  strcpy(acc_transl[hs_to_i("9a")], "\\\"o");
  strcpy(acc_transl[hs_to_i("9b")], "\\~o");
  strcpy(acc_transl[hs_to_i("9c")], "\\'u");
  strcpy(acc_transl[hs_to_i("9d")], "\\`u");
  strcpy(acc_transl[hs_to_i("9e")], "\\^u");
  strcpy(acc_transl[hs_to_i("9f")], "\\\"u");
  strcpy(acc_transl[hs_to_i("a0")], "\\dag{}");
  strcpy(acc_transl[hs_to_i("a1")], "\\degree{}");
  strcpy(acc_transl[hs_to_i("a3")], "\\pound{}");
  strcpy(acc_transl[hs_to_i("a4")], "\\S{}");
  strcpy(acc_transl[hs_to_i("a7")], "\\ss{}");
  strcpy(acc_transl[hs_to_i("ae")], "\\AE{}");
  strcpy(acc_transl[hs_to_i("af")], "\\O{}");
  strcpy(acc_transl[hs_to_i("b0")], "$\\infty ");
  strcpy(acc_transl[hs_to_i("b1")], "$\\pm ");
  strcpy(acc_transl[hs_to_i("b2")], "$\\leq ");
  strcpy(acc_transl[hs_to_i("b3")], "$\\geq ");
  strcpy(acc_transl[hs_to_i("b5")], "$\\mu ");
  strcpy(acc_transl[hs_to_i("b6")], "$\\partial ");
  strcpy(acc_transl[hs_to_i("b7")], "$\\Sigma ");
  strcpy(acc_transl[hs_to_i("b8")], "$\\Pi ");
  strcpy(acc_transl[hs_to_i("b9")], "$\\pi ");
  strcpy(acc_transl[hs_to_i("bd")], "${1\\over2}");
  strcpy(acc_transl[hs_to_i("bf")], "\\o{}");
  strcpy(acc_transl[hs_to_i("c6")], "$\\Delta ");
  strcpy(acc_transl[hs_to_i("c9")], "...");
  strcpy(acc_transl[hs_to_i("cb")], "\\`A");
  strcpy(acc_transl[hs_to_i("cc")], "\\~A");
  strcpy(acc_transl[hs_to_i("cd")], "\\~O");
  strcpy(acc_transl[hs_to_i("ce")], "\\OE{}");
  strcpy(acc_transl[hs_to_i("cf")], "\\oe{}");
  strcpy(acc_transl[hs_to_i("d0")], "--{}");
  strcpy(acc_transl[hs_to_i("d1")], "---{}");
  strcpy(acc_transl[hs_to_i("d2")], "``");
  strcpy(acc_transl[hs_to_i("d3")], "''");
  strcpy(acc_transl[hs_to_i("d4")], "`{}");
  strcpy(acc_transl[hs_to_i("d5")], "'{}");
  strcpy(acc_transl[hs_to_i("d6")], "$\\div ");
  strcpy(acc_transl[hs_to_i("d8")], "\\\"y");
  strcpy(acc_transl[hs_to_i("e1")], "$\\cdot ");
  strcpy(acc_transl[hs_to_i("e4")], "\\\"a");
  strcpy(acc_transl[hs_to_i("e5")], "\\^A");
  strcpy(acc_transl[hs_to_i("e6")], "\\^E");
  strcpy(acc_transl[hs_to_i("e7")], "\\'A");
  strcpy(acc_transl[hs_to_i("e8")], "\\\"E");
  strcpy(acc_transl[hs_to_i("e9")], "\\`E");
  strcpy(acc_transl[hs_to_i("ea")], "\\'I");
  strcpy(acc_transl[hs_to_i("eb")], "\\^I");
  strcpy(acc_transl[hs_to_i("ec")], "\\\"I");
  strcpy(acc_transl[hs_to_i("ed")], "\\`I");
  strcpy(acc_transl[hs_to_i("ee")], "\\'O");
  strcpy(acc_transl[hs_to_i("ef")], "\\^O");
  strcpy(acc_transl[hs_to_i("f1")], "\\`O");
  strcpy(acc_transl[hs_to_i("f2")], "\\'U");
  strcpy(acc_transl[hs_to_i("f3")], "\\^U");
  strcpy(acc_transl[hs_to_i("f4")], "\\`U");
  strcpy(acc_transl[hs_to_i("f6")], "\\\"o");
  strcpy(acc_transl[hs_to_i("fb")], "\\degree{}");
  strcpy(acc_transl[hs_to_i("fc")], "\\\"u");
 
}
 
 
/* ======================================================================= */
 
Static Void ansi_init()
{
  short k;
 
  /* install the conversions of RTF accents (coded \'xx in hexa) */
  /* build a list of conversion of accented letters */
 
  for (k = 0; k <= 255; k++)
    *acc_transl[k] = '\0';
 
  strcpy(acc_transl[hs_to_i("a1")], "!`");
  strcpy(acc_transl[hs_to_i("a3")], "\\pound{}");
  strcpy(acc_transl[hs_to_i("a7")], "\\S{}");
  strcpy(acc_transl[hs_to_i("a8")], "\\\"{ }");
  strcpy(acc_transl[hs_to_i("a9")], "\\copyright{}");
  strcpy(acc_transl[hs_to_i("ab")], "<<");
  strcpy(acc_transl[hs_to_i("b0")], "\\degree{}");
  strcpy(acc_transl[hs_to_i("b1")], "$\\pm ");
  strcpy(acc_transl[hs_to_i("b4")], "\\'{ }");
  strcpy(acc_transl[hs_to_i("b5")], "$\\mu ");
  strcpy(acc_transl[hs_to_i("b7")], "$\\cdot ");
  strcpy(acc_transl[hs_to_i("b8")], "\\c{ }");
  strcpy(acc_transl[hs_to_i("bb")], ">>");
  strcpy(acc_transl[hs_to_i("bc")], "${1\\over4}");
  strcpy(acc_transl[hs_to_i("bd")], "${1\\over2}");
  strcpy(acc_transl[hs_to_i("be")], "${3\\over4}");
  strcpy(acc_transl[hs_to_i("bf")], "?`");
 
  strcpy(acc_transl[hs_to_i("c0")], "\\`A");
  strcpy(acc_transl[hs_to_i("c1")], "\\'A");
  strcpy(acc_transl[hs_to_i("c2")], "\\^A");
  strcpy(acc_transl[hs_to_i("c3")], "\\~A");
  strcpy(acc_transl[hs_to_i("c4")], "\\\"A");
  strcpy(acc_transl[hs_to_i("c5")], "\\AA{}");
  strcpy(acc_transl[hs_to_i("c6")], "\\AE{}");
  strcpy(acc_transl[hs_to_i("c7")], "\\c{C}");
  strcpy(acc_transl[hs_to_i("c8")], "\\`E");
  strcpy(acc_transl[hs_to_i("c9")], "\\'E");
  strcpy(acc_transl[hs_to_i("ca")], "\\^E");
  strcpy(acc_transl[hs_to_i("cb")], "\\\"E");
  strcpy(acc_transl[hs_to_i("cc")], "\\`I");
  strcpy(acc_transl[hs_to_i("cd")], "\\'I");
  strcpy(acc_transl[hs_to_i("ce")], "\\^I");
  strcpy(acc_transl[hs_to_i("cf")], "\\\"I");
 
  strcpy(acc_transl[hs_to_i("d1")], "\\~N");
  strcpy(acc_transl[hs_to_i("d2")], "\\`O");
  strcpy(acc_transl[hs_to_i("d3")], "\\'O");
  strcpy(acc_transl[hs_to_i("d4")], "\\^O");
  strcpy(acc_transl[hs_to_i("d5")], "\\~O");
  strcpy(acc_transl[hs_to_i("d6")], "\\\"O");
  strcpy(acc_transl[hs_to_i("d8")], "\\O");
  strcpy(acc_transl[hs_to_i("d9")], "\\`U");
  strcpy(acc_transl[hs_to_i("da")], "\\'U");
  strcpy(acc_transl[hs_to_i("db")], "\\^U");
  strcpy(acc_transl[hs_to_i("dc")], "\\\"U");
  strcpy(acc_transl[hs_to_i("dd")], "\\'Y");
  strcpy(acc_transl[hs_to_i("df")], "\\ss{}");
 
 
  strcpy(acc_transl[hs_to_i("e0")], "\\`a");
  strcpy(acc_transl[hs_to_i("e1")], "\\'a");
  strcpy(acc_transl[hs_to_i("e2")], "\\^a");
  strcpy(acc_transl[hs_to_i("e3")], "\\~a");
  strcpy(acc_transl[hs_to_i("e4")], "\\\"a");
  strcpy(acc_transl[hs_to_i("e5")], "\\aa{}");
  strcpy(acc_transl[hs_to_i("e6")], "\\ae{}");
  strcpy(acc_transl[hs_to_i("e7")], "\\c{c}");
  strcpy(acc_transl[hs_to_i("e8")], "\\`e");
  strcpy(acc_transl[hs_to_i("e9")], "\\'e");
  strcpy(acc_transl[hs_to_i("ea")], "\\^e");
  strcpy(acc_transl[hs_to_i("eb")], "\\\"e");
  strcpy(acc_transl[hs_to_i("ec")], "\\`i");
  strcpy(acc_transl[hs_to_i("ed")], "\\'i");
  strcpy(acc_transl[hs_to_i("ee")], "\\^i");
  strcpy(acc_transl[hs_to_i("ef")], "\\\"i");
 
  strcpy(acc_transl[hs_to_i("f1")], "\\~n");
  strcpy(acc_transl[hs_to_i("f2")], "\\`o");
  strcpy(acc_transl[hs_to_i("f3")], "\\'o");
  strcpy(acc_transl[hs_to_i("f4")], "\\^o");
  strcpy(acc_transl[hs_to_i("f5")], "\\~o");
  strcpy(acc_transl[hs_to_i("f6")], "\\\"o");
  strcpy(acc_transl[hs_to_i("f8")], "\\o");
  strcpy(acc_transl[hs_to_i("f9")], "\\`u");
  strcpy(acc_transl[hs_to_i("fa")], "\\'u");
  strcpy(acc_transl[hs_to_i("fb")], "\\^u");
  strcpy(acc_transl[hs_to_i("fc")], "\\\"u");
  strcpy(acc_transl[hs_to_i("fd")], "\\'y");
  strcpy(acc_transl[hs_to_i("ff")], "\\\"y");
 
 
 
}
 
 
/* ======================================================================= */
 
Static Void charinit()
{
  short K;
 
  for (K = 0; K <= 255; K++)
    catcode[K] = 12;
  for (K = 'A'; K <= 'Z'; K++)
    catcode[K] = 11;
  for (K = 'a'; K <= 'z'; K++)
    catcode[K] = 11;
  for (K = '0'; K <= '9'; K++)
    catcode[K] = 16;
  K = ' ';
  catcode[K] = 10;
  K = '{';
  catcode[K] = 1;
  K = '}';
  catcode[K] = 2;
  K = '(';
  catcode[K] = 3;
  K = ')';
  catcode[K] = 4;
  K = '\\';
  catcode[K] = 0;
 
  icharz = '0';
 
  /* build an empty list of conversion of accented letters */
 
  for (K = 0; K <= 255; K++)
    *acc_transl[K] = '\0';
 
  /* Now install the conversions of "ftech" characters into math codes
... or letters*/
 
  for (K = 0; K <= 255; K++)
    *ftech_transl[K] = '\0';
  strcpy(ftech_transl['a'], "\\alpha ");
  strcpy(ftech_transl['A'], "\\Alpha ");
  strcpy(ftech_transl['b'], "\\beta ");
  strcpy(ftech_transl['B'], "\\Beta ");
  strcpy(ftech_transl['c'], "\\chi ");
  strcpy(ftech_transl['C'], "\\Chi ");
  strcpy(ftech_transl['d'], "\\delta ");
  strcpy(ftech_transl['D'], "\\Delta ");
  strcpy(ftech_transl['e'], "\\varepsilon ");
  strcpy(ftech_transl['E'], "\\Epsilon ");
  strcpy(ftech_transl['f'], "\\phi ");
  strcpy(ftech_transl['F'], "\\Phi ");
  strcpy(ftech_transl['g'], "\\gamma ");
  strcpy(ftech_transl['G'], "\\Gamma ");
  strcpy(ftech_transl['h'], "\\eta ");
  strcpy(ftech_transl['H'], "\\Eta ");
  strcpy(ftech_transl['i'], "\\iota ");
  strcpy(ftech_transl['I'], "\\Iota ");
  strcpy(ftech_transl['j'], "\\varphi ");
  strcpy(ftech_transl['J'], "\\vartheta ");
  strcpy(ftech_transl['k'], "\\kappa ");
  strcpy(ftech_transl['K'], "\\Kappa ");
  strcpy(ftech_transl['l'], "\\lambda ");
  strcpy(ftech_transl['L'], "\\Lambda ");
  strcpy(ftech_transl['m'], "\\mu ");
  strcpy(ftech_transl['M'], "\\Mu ");
  strcpy(ftech_transl['n'], "\\nu ");
  strcpy(ftech_transl['N'], "\\Nu");
  strcpy(ftech_transl['o'], "o");
  strcpy(ftech_transl['O'], "\\Omicron ");
  strcpy(ftech_transl['p'], "\\pi ");
  strcpy(ftech_transl['P'], "\\Pi ");
  strcpy(ftech_transl['q'], "\\theta ");
  strcpy(ftech_transl['Q'], "\\Theta ");
  strcpy(ftech_transl['r'], "\\rho ");
  strcpy(ftech_transl['R'], "\\Rho ");
  strcpy(ftech_transl['s'], "\\sigma ");
  strcpy(ftech_transl['S'], "\\Sigma ");
  strcpy(ftech_transl['t'], "\\tau ");
  strcpy(ftech_transl['T'], "\\Tau ");
  strcpy(ftech_transl['u'], "\\upsilon ");
  strcpy(ftech_transl['U'], "\\varUpsilon ");
  strcpy(ftech_transl['v'], "\\varpi ");
  strcpy(ftech_transl['V'], "\\varsigma ");
  strcpy(ftech_transl['w'], "\\omega ");
  strcpy(ftech_transl['W'], "\\Omega ");
  strcpy(ftech_transl['x'], "\\xi ");
  strcpy(ftech_transl['X'], "\\Xi ");
  strcpy(ftech_transl['y'], "\\psi ");
  strcpy(ftech_transl['Y'], "\\Psi ");
  strcpy(ftech_transl['z'], "\\zeta ");
  strcpy(ftech_transl['Z'], "\\Zeta ");
 
  strcpy(ftech_transl['@'], "\\cong ");
  strcpy(ftech_transl['~'], "\\sim ");
  strcpy(ftech_transl['"'], "\\forall ");
  strcpy(ftech_transl['$'], "\\exists ");
 
  strcpy(ftech_transl[hs_to_i("27")], "\\ni ");
  strcpy(ftech_transl[hs_to_i("5e")], "\\bot ");
  strcpy(ftech_transl[hs_to_i("a0")], "\\dag ");
  strcpy(ftech_transl[hs_to_i("a1")], "\\Upsilon ");
  strcpy(ftech_transl[hs_to_i("a2")], "'");
  strcpy(ftech_transl[hs_to_i("a3")], "\\leq ");
  strcpy(ftech_transl[hs_to_i("a4")], "/");
  strcpy(ftech_transl[hs_to_i("a5")], "\\infty ");
  strcpy(ftech_transl[hs_to_i("a6")], "\\cap ");
  strcpy(ftech_transl[hs_to_i("a7")], "\\clubsuit ");
  strcpy(ftech_transl[hs_to_i("a9")], "\\heartsuit ");
  strcpy(ftech_transl[hs_to_i("aa")], "\\spadesuit ");
  strcpy(ftech_transl[hs_to_i("ab")], "\\leftrightarrow ");
  strcpy(ftech_transl[hs_to_i("ac")], "\\leftarrow ");
  strcpy(ftech_transl[hs_to_i("ad")], "\\uparrow ");
  strcpy(ftech_transl[hs_to_i("ae")], "\\rightarrow ");
  strcpy(ftech_transl[hs_to_i("af")], "\\downarrow ");
  strcpy(ftech_transl[hs_to_i("b0")], "^{\\circ}");
  strcpy(ftech_transl[hs_to_i("b1")], "\\pm ");
  strcpy(ftech_transl[hs_to_i("b2")], "''");
  strcpy(ftech_transl[hs_to_i("b3")], "\\geq ");
  strcpy(ftech_transl[hs_to_i("b4")], "\\times ");
  strcpy(ftech_transl[hs_to_i("b5")], "\\propto ");
  strcpy(ftech_transl[hs_to_i("b6")], "\\partial ");
  strcpy(ftech_transl[hs_to_i("b7")], "\\bullet ");
  strcpy(ftech_transl[hs_to_i("b8")], "\\div ");
  strcpy(ftech_transl[hs_to_i("b9")], "\\neq ");
  strcpy(ftech_transl[hs_to_i("ba")], "\\equiv ");
  strcpy(ftech_transl[hs_to_i("bb")], "\\approx ");
  strcpy(ftech_transl[hs_to_i("bc")], "\\ldots ");
  strcpy(ftech_transl[hs_to_i("bd")], "\\mid ");
  strcpy(ftech_transl[hs_to_i("c0")], "\\aleph ");
  strcpy(ftech_transl[hs_to_i("c1")], "\\Im ");
  strcpy(ftech_transl[hs_to_i("c2")], "\\Re ");
  strcpy(ftech_transl[hs_to_i("c3")], "\\wp ");
  strcpy(ftech_transl[hs_to_i("c4")], "\\otimes ");
  strcpy(ftech_transl[hs_to_i("c5")], "\\oplus ");
  strcpy(ftech_transl[hs_to_i("c6")], "\\oslash ");
  strcpy(ftech_transl[hs_to_i("c7")], "\\cap ");
  strcpy(ftech_transl[hs_to_i("c8")], "\\cup ");
  strcpy(ftech_transl[hs_to_i("c9")], "\\supset ");
  strcpy(ftech_transl[hs_to_i("ca")], "\\supseteq ");
  strcpy(ftech_transl[hs_to_i("cb")], "\\not\\subset ");
  strcpy(ftech_transl[hs_to_i("cc")], "\\subset ");
  strcpy(ftech_transl[hs_to_i("cd")], "\\subseteq ");
  strcpy(ftech_transl[hs_to_i("ce")], "\\in ");
  strcpy(ftech_transl[hs_to_i("cf")], "\\not\\in ");
  strcpy(ftech_transl[hs_to_i("d0")], "\\angle ");
  strcpy(ftech_transl[hs_to_i("d1")], "\\nabla ");
  strcpy(ftech_transl[hs_to_i("d2")], "\\registered ");
  strcpy(ftech_transl[hs_to_i("d3")], "\\copyright ");
  strcpy(ftech_transl[hs_to_i("d4")], "\\trademark ");
  strcpy(ftech_transl[hs_to_i("d5")], "\\prod ");
  strcpy(ftech_transl[hs_to_i("d7")], "\\cdot ");
  strcpy(ftech_transl[hs_to_i("d8")], "\\neg ");
  strcpy(ftech_transl[hs_to_i("d9")], "\\wedge ");
  strcpy(ftech_transl[hs_to_i("da")], "\\vee ");
  strcpy(ftech_transl[hs_to_i("db")], "\\Leftrightarrow ");
  strcpy(ftech_transl[hs_to_i("dc")], "\\Leftarrow ");
  strcpy(ftech_transl[hs_to_i("dd")], "\\Uparrow ");
  strcpy(ftech_transl[hs_to_i("de")], "\\Rightarrow ");
  strcpy(ftech_transl[hs_to_i("df")], "\\Downarrow ");
  strcpy(ftech_transl[hs_to_i("e0")], "\\diamondsuit ");
  strcpy(ftech_transl[hs_to_i("e1")], "\\langle ");
  strcpy(ftech_transl[hs_to_i("e2")], "\\registered ");
  strcpy(ftech_transl[hs_to_i("e3")], "\\copyright ");
  strcpy(ftech_transl[hs_to_i("e4")], "\\trademark ");
  strcpy(ftech_transl[hs_to_i("e5")], "\\sum ");
  strcpy(ftech_transl[hs_to_i("e9")], "\\lceil ");
  strcpy(ftech_transl[hs_to_i("ea")], "\\mid ");
  strcpy(ftech_transl[hs_to_i("eb")], "\\lfloor ");
  strcpy(ftech_transl[hs_to_i("f1")], "\\rangle ");
  strcpy(ftech_transl[hs_to_i("f2")], "\\int ");
 
  strcpy(end_math_code, "$");
}
 
 
/* ======================================================================= */
/* this procedure returns a set of 4 chars, the size preamble of a non std font */
Static Char *sizealpha(Result, i)
Char *Result;
short i;
{
  short h;
 
  h = i / 2;
  if (h <= 5)
    return strcpy(Result, "\\fiv");
  else if (h <= 6)
    return strcpy(Result, "\\six");
  else if (h <= 7)
    return strcpy(Result, "\\sev");
  else if (h <= 8)
    return strcpy(Result, "\\egt");
  else if (h <= 9)
    return strcpy(Result, "\\nin");
  else if (h <= 10)
    return strcpy(Result, "\\ten");
  else if (h <= 11)
    return strcpy(Result, "\\elv");
  else if (h <= 13)
    return strcpy(Result, "\\twl");
  else if (h <= 15)
    return strcpy(Result, "\\frt");
  else if (h <= 18)
    return strcpy(Result, "\\svtn");
  else if (h <= 23)
    return strcpy(Result, "\\twty");
  else if (h <= 28)
    return strcpy(Result, "\\twfv");
  else {
    return strcpy(Result, "\\thtw");
    /*END IF*/
 
  }
}
 
 
/* ======================================================================= */
/* write "help" information */
 
Static Void write_help()
{
  printf("Usage: RTFLATEX [options] <input-file> [options] <output-file>\n");
  printf("Options:\n");
  printf("         -b         : set explicit \\baselineskip at par ends\n");
  printf("         -d<nnn>    : debug level: 1=default, 0=quiet, >1=verbose\n");
  printf("         -f<templ>  : file template to put figures (need a * )\n");
  printf("         -l<style>  : latex style (default is \"report\")\n");
  printf("         -m         : put debugging marks in output TeX\n");
  printf("         -o<option> : latex style option (cumulative)\n");
  printf("         -p<value>  : std font size (10, 11, 12)\n");
  printf("         -r<file>   : LOG output file (default is none)\n");
  printf("         -s         : use slanted instead of italic\n");
  printf("         -t         : omit LaTeX \\documentstyle etc.\n");
  printf("         -v         : convert text and fonts, not spacings\n");
  printf("         -x         : inhibit output simplification\n");
  printf("         -z<file>   : file containing list of ignored keywords\n");
  printf("         -209       : assume ancient Latex209\n");
  _Escape(0);
}
 
 
/*---------------------------------------------------------------------------*/
/* this procedure open files and set the -xxxx options */
 
Static Void open_files()
{
  string128 skipname, outputname, inputname, logname, optstr;
  short testio, cat, ikar;
  short kparm = 0;
  short L, pospt;
  Char first_char;
  boolean success;
  string24 inskipk;
  short kkk, number_params;
  Char STR1[256], STR3[256], STR4[256];
  short FORLIM1;
  Char *TEMP;
  Char STR5[40];
  Char STR6[68];
 
  strcpy(figure_path, "rtf*.bit");
  *figure_type = '\0';
  stdsize = 12;
  stdkz = 3;   /* standard LaTeX size : 10, 11, 12 pt */
  *inputname = '\0';
  *outputname = '\0';
  strcpy(skipname, P_argv[0]);
  num_skip_strings = 1;
  for (L = 0; L <= max_skip_strings - 1; L++)
    *skip_strings[L] = '\0';
 
  pospt = pos_postfix(skipname);
  if (pospt > 0) {
    if (!strcmp(strsub(STR1, skipname, pospt, strlen(skipname)), ".EXE"))
      sprintf(skipname, "%.*sSKW", pospt, strcpy(STR3, skipname));
    else if (!strcmp(strsub(STR3, skipname, pospt, strlen(skipname)), ".exe"))
      sprintf(skipname, "%.*sskw", pospt, strcpy(STR4, skipname));
  } else
    strcat(skipname, ".skw");
  /*END IF*/
  number_params = P_argc - 1;
 
  for (kkk = 1; kkk <= number_params; kkk++) {   /*END WHILE*/
    kparm = kkk;
    strcpy(optstr, P_argv[kparm]);
    first_char = optstr[0];
    if (first_char == '-') {
      printf("%cOption :>%s<\n", first_char, optstr);
      if (optstr[1] == 'p') {
	stdsize = 0;
	FORLIM1 = strlen(optstr);
	for (L = 2; L <= FORLIM1 - 1; L++) {
	  ikar = optstr[L];
	  cat = catcode[ikar];
	  if (cat != 16) {
	    printf("Illegal character in -p option: %s\n", optstr);
	    _Escape(0);
	  }
	  stdsize = stdsize * 10 + ikar - icharz;
	}
	printf("Standard size found: %dpt\n", stdsize);
	if (stdsize < 11)
	  stdkz = 1;
	else if (stdsize == 11)
	  stdkz = 2;
	else
	  stdkz = 3;
      } else if (optstr[1] == '2') {
	/*END IF*/
	latex209 = true;
      } else if (optstr[1] == 'v')
	no_space_conv = true;
      else if (optstr[1] == 's')
	use_sl = true;
      else if (optstr[1] == 't')
	latex_header = false;
      else if (optstr[1] == 'x')
	simplify_ok = false;
      else if (optstr[1] == 'b')
	base_flag = true;
      else if (optstr[1] == 'z')
	strcpy(skipname, optstr + 2);
      else if (optstr[1] == 'l') {
	truncate24(latex_style, optstr);
	if (*latex_style == '\0')
	  strcpy(latex_style, "report");
      } else if (optstr[1] == 'o') {
	if (num_latex_options >= maxstyles)
	  printf("Too many style options, %s ignored !\n", optstr);
	else {
	  num_latex_options++;
	  truncate24(latex_options[num_latex_options],
		     strsub(STR4, optstr, 3, bfslen));
	}
      } else if (optstr[1] == 'f') {
	/*END IF num_latex_options*/
	strcpy(figure_path, optstr + 2);
	printf("-f:%s\n", figure_path);
      } else if (optstr[1] == 'r') {
	strcpy(logname, optstr + 2);
	write_log = true;
      } else if (optstr[1] == 'm')
	tex_verbose = 1;   /* insert marks in TeX output */
      else if (optstr[1] == 'd') {
	verbose = 0;
	FORLIM1 = strlen(optstr);
	for (L = 2; L <= FORLIM1 - 1; L++) {
	  ikar = optstr[L];
	  cat = catcode[ikar];
	  if (cat != 16) {
	    printf("Illegal character in -d option: %s\n", optstr);
	    _Escape(0);
	  }
	  verbose = verbose * 10 + ikar - icharz;
	  /*END IF*/
	  if (verbose > 0)
	    printf("Verbose=%d\n", verbose);
	}
      } else
	printf("Unsupported option, ignored: %s\n", optstr);
    } else if (*inputname == '\0') {
      /*END IF*/
      strcpy(inputname, optstr);
    } else if (*outputname == '\0')
      strcpy(outputname, optstr);
    else if (*optstr != '\0') {
      printf("Too many non option args : %s\n", optstr);
      printf("This one ignored !\n");
    }
  }
 
  /*END IF*/
  pospt = strpos2(figure_path, "*", 1);
  if (pospt == 0) {
    printf("NO * in -f<path> option\n");
    _Escape(0);
  }
  strcpy(figure_type, figure_path + pospt);
  sprintf(figure_path, "%.*s", pospt - 1, strcpy(STR3, figure_path));
 
  if (*inputname == '\0')   /* stops if help written */
    write_help();
 
  if (pos_postfix(inputname) == 0)
    strcat(inputname, ".rtf");
 
  strcpy(inputfile_NAME, inputname);
  if (inputfile != NULL)
    inputfile = freopen(inputfile_NAME, "r", inputfile);
  else
    inputfile = fopen(inputfile_NAME, "r");
  _SETIO(inputfile != NULL, FileNotFound);
  testio = P_ioresult;
  success = (testio == 0);
  if (!success) {
    _SETIO(printf("Unable to open input file %s ; code=%d\n",
		  inputname, testio) >= 0, FileWriteError);
    _Escape(0);
  }
 
  if (*outputname == '\0') {
    pospt = pos_postfix(inputname);
    sprintf(outputname, "%.*stex", pospt, inputname);
    _SETIO(printf("Output name taken from input: %s\n", outputname) >= 0,
	   FileWriteError);
  }
 
  if (!strcmp(outputname, inputname)) {
    _SETIO(printf("Input and output files have same names, abort!\n") >= 0,
	   FileWriteError);
    _SETIO(printf("  Input:  %s\n", inputname) >= 0, FileWriteError);
    _SETIO(printf("  Output: %s\n", inputname) >= 0, FileWriteError);
    if (inputfile != NULL)
      fclose(inputfile);
    inputfile = NULL;
    _Escape(0);
  }
 
  strcpy(outputfile_NAME, outputname);
  if (outputfile != NULL)
    outputfile = freopen(outputfile_NAME, "w", outputfile);
  else
    outputfile = fopen(outputfile_NAME, "w");
  _SETIO(outputfile != NULL, FileNotFound);
  testio = P_ioresult;
  success = (testio == 0);
 
  if (!success) {
    _SETIO(printf("ioresult (output)=%d\n", testio) >= 0, FileWriteError);
    _SETIO(printf("Unable to open output file %s ; code=%d\n",
		  outputname, testio) >= 0, FileWriteError);
    if (inputfile != NULL)
      fclose(inputfile);
    inputfile = NULL;
    _Escape(0);
  }
 
  /* opening skip file to eliminate useless output \RTFxxx keywords */
  if (*skipname == '\0') {
    pospt = pos_postfix(inputname);
    sprintf(skipname, "%.*sskw", pospt, inputname);
    _SETIO(printf("keyword skip file name taken from input: %s\n", skipname) >= 0,
	   FileWriteError);
  }
 
  if (!strcmp(skipname, inputname)) {
    _SETIO(printf("Input and skip files have same names, abort!\n") >= 0,
	   FileWriteError);
    _SETIO(printf("  Input:  %s\n", inputname) >= 0, FileWriteError);
    _SETIO(printf("  skip: %s\n", inputname) >= 0, FileWriteError);
    if (inputfile != NULL)
      fclose(inputfile);
    inputfile = NULL;
    _Escape(0);
  }
 
  strcpy(skipfile_NAME, skipname);
  if (skipfile != NULL)
    skipfile = freopen(skipfile_NAME, "r", skipfile);
  else
    skipfile = fopen(skipfile_NAME, "r");
  _SETIO(skipfile != NULL, FileNotFound);
  testio = P_ioresult;
  success = (testio == 0);
 
  if (!success) {
    _SETIO(printf("ioresult (keyword skip file)=%d\n", testio) >= 0,
	   FileWriteError);
    _SETIO(printf("Unable to open keyword skip file %s ; code=%d\n",
		  skipname, testio) >= 0, FileWriteError);
    if (inputfile != NULL)
      fclose(inputfile);
    inputfile = NULL;
    _Escape(0);
  }
 
 
  if (write_log) {   /*END IF write_log*/
    if (*logname == '\0') {   /*END IF logname*/
      pospt = pos_postfix(inputname);
      sprintf(logname, "%.*slog", pospt, inputname);
      _SETIO(printf("Log name taken from input   : %s\n", logname) >= 0,
	     FileWriteError);
    }
 
    if (!strcmp(logname, inputname) || !strcmp(logname, outputname))
    {   /*END IF logname*/
      _SETIO(printf("Log and input or output files have same names, abort!\n") >=
	     0, FileWriteError);
      _SETIO(printf("  Log:    %s\n", logname) >= 0, FileWriteError);
      if (inputfile != NULL)
	fclose(inputfile);
      inputfile = NULL;
      _Escape(0);
    }
 
    strcpy(logfile_NAME, logname);
    if (logfile != NULL)
      logfile = freopen(logfile_NAME, "w", logfile);
    else
      logfile = fopen(logfile_NAME, "w");
    _SETIO(logfile != NULL, FileNotFound);
    testio = P_ioresult;
    write_log = (testio == 0);
 
    if (!write_log) {   /*END IF not success*/
      _SETIO(printf("ioresult (Log)=%d\n", testio) >= 0, FileWriteError);
      _SETIO(printf("Unable to open log file %s ; code=%d\n", logname, testio) >=
	     0, FileWriteError);
      if (inputfile != NULL)
	fclose(inputfile);
      inputfile = NULL;
      _Escape(0);
    }
    _SETIO(printf("%s, ", logname) >= 0, FileWriteError);
  }
  _SETIO(printf("%s, %s and %s successfully opened.\n",
		inputname, skipname, outputname) >= 0, FileWriteError);
 
  while (!P_eof(skipfile)) {   /*END DO*/
    _SETIO(fgets(inskipk, bfslen + 1, skipfile) != NULL, EndOfFile);
    TEMP = strchr(inskipk, '\n');
    if (TEMP != NULL)
      *TEMP = 0;
    sprintf(STR5, "Cancelling \"%s\"", inskipk);
    println_msg(2, STR5);
    if (*inskipk == '\0') {   /*END IF*/
      /*END IF*/
      continue;
    }
    if (strlen(inskipk) + strlen(skip_strings[num_skip_strings-1]) < 255)
      sprintf(skip_strings[num_skip_strings-1] +
	      strlen(skip_strings[num_skip_strings-1]), "%s ", inskipk);
    else if (num_skip_strings < max_skip_strings) {
      num_skip_strings++;
      sprintf(skip_strings[num_skip_strings-1] +
	      strlen(skip_strings[num_skip_strings-1]), "%s ", inskipk);
    } else {
      sprintf(STR6, "Too many keywords to ignore, %s not recorded!", inskipk);
      println_msg(1, STR6);
    }
  }
}
 
 
/*---------------------------------------------------------------------------*/
/* clean the output line */
 
Static Void cleanout()
{
  for (i = 1; i <= olmx; i++)
    exline[i-1] = ' ';
  kout = 0;
}
 
 
/*---------------------------------------------------------------------------*/
/* prints/displays the current stored output line */
 
Static Void print_line(verbose_level)
short verbose_level;
{
  short i, FORLIM;
  Char STR1[256];
 
  FORLIM = kout;
  for (i = 0; i <= FORLIM - 1; i++) {
    sprintf(STR1, "%c", exline[i]);
    print_msg(verbose_level, STR1);
  }
  println_msg(verbose_level, "<<<");
}
 
 
/*---------------------------------------------------------------------------*/
/* makes the pos function in an array of type exline_type */
 
Static short array_pos(oldstring, testline, array_long)
Char *oldstring;
Char *testline;
short array_long;
{
  short Result = 0;
  boolean string_found;
  short lth1, jpos, kpos, FORLIM;
 
  lth1 = strlen(oldstring);
  FORLIM = array_long - lth1 + 1;
  for (kpos = 1; kpos <= FORLIM; kpos++) {   /*END DO*/
    string_found = true;
    for (jpos = 1; jpos <= lth1; jpos++)   /*END DO*/
      string_found = (string_found &&
		      oldstring[jpos-1] == testline[kpos + jpos - 2]);
    if (string_found)   /*END IF*/
      return kpos;
  }
  return Result;
}
 
 
/*---------------------------------------------------------------------------*/
/* substitute a string with another in output line */
 
Static Void outsubstitute(oldstring, newstring)
Char *oldstring, *newstring;
{
  boolean string_found = true;
  short lth1, lth2, jpos, kpos, oldkout;
  exline_type oldline;
 
  lth1 = strlen(oldstring);
  lth2 = strlen(newstring);
  while (string_found) {   /*END DO*/
    kpos = array_pos(oldstring, exline, kout);
    string_found = (kpos > 0);
    if (!string_found)   /*END IF*/
      break;
    memcpy(oldline, exline, sizeof(exline_type));
    oldkout = kout;
    kout = kpos - 1;
    for (jpos = 0; jpos <= lth2 - 1; jpos++) {   /*END DO*/
      kout++;
      exline[kout-1] = newstring[jpos];
    }
    for (jpos = kpos + lth1 - 1; jpos <= oldkout - 1; jpos++) {   /*END DO*/
      kout++;
      exline[kout-1] = oldline[jpos];
    }
    for (jpos = kout; jpos <= olmx - 1; jpos++)   /*END DO*/
      exline[jpos] = ' ';
  }
}
 
 
/*---------------------------------------------------------------------------*/
/* converts an integer number of twips into a decimal string */
 
Static Void str_twips_pt(numval, outpts)
short numval;
Char *outpts;
{
  short k, l;
  string24 wk, STR1;
  Char STR2[28];
  Char STR3[256];
  Char STR5[256];
 
  k = numval * 5;   /* convert to hundredth of pts */
  sign_str(k, wk);
  if (strlen(wk) < 2) {
    sprintf(STR2, "00%s", wk);
    strcpy(wk, truncate24(STR1, STR2));
  }
  l = strlen(wk);
  sprintf(STR5, "%.*s.%s", l - 2, wk, strsub(STR3, wk, l - 1, 2));
  truncate24(outpts, STR5);
}
 
 
/*---------------------------------------------------------------------------*/
/* eliminates end replaces useless sequences in output -- pragmatic feature */
 
Static Void simplify(oldstring, newstring)
Char *oldstring, *newstring;
{
  if (simplify_ok)
    outsubstitute(oldstring, newstring);
}
 
 
/*---------------------------------------------------------------------------*/
/* read the future chars, excluding control chars < ord(' ') */
 
Static Void read_next_char()
{
  short next_ikar = 0;
  Char next_char;
 
  next_char = next_ikar;
  while (!P_eof(inputfile) && next_ikar < ' ' && strlen(next_rtf) < 8)
  {   /*END DO*/
    next_char = getc(inputfile);
    _SETIO(next_char != EOF, EndOfFile);
    next_ikar = next_char;
    if (next_ikar == 13) {
      input_line_number++;
      memcpy(prev_line, inpline, (long)lmx);
      prev_kinp = kinp;
      kinp = 0;
    } else if (next_ikar >= ' ') {
      sprintf(next_rtf + strlen(next_rtf), "%c", next_char);
      /*END IF*/
    }
  }
}
 
 
/*---------------------------------------------------------------------------*/
/* read one char except nulls */
 
Static Void read_char()
{
  if (*next_rtf != '\0') {
    kar = next_rtf[0];
    strdelete((Anyptr)next_rtf, 1, 1);
    read_next_char();
  } else
    kar = '\032';
  /*END IF*/
  ikar = kar;
  cat = catcode[ikar];
  if (*next_rtf == '\0')   /*END IF*/
    strcat(next_rtf, "\032");
 
  if (kinp < lmx) {   /*END IF*/
    kinp++;
    inpline[kinp-1] = kar;
  }
}
 
 
/*---------------------------------------------------------------------------*/
/* outputs the stored output line */
 
Static Void output_line()
{
  short i;
  string24 simpl_pattern;
  short FORLIM;
  Char STR1[28];
  Char STR2[26];
  Char STR3[42];
 
  numl++;
  simplify("{{}", "{");
  simplify("{}}", "}");
  simplify("{}{}", "{}");
  FORLIM = num_diff_sizes;
  for (i = 0; i <= FORLIM - 1; i++) {   /*END DO*/
    sprintf(STR2, "\\%s", sizekey[i]);
    truncate24(simpl_pattern, STR2);
    sprintf(STR1, "%s{}\\", simpl_pattern);
    sprintf(STR2, "%s\\", simpl_pattern);
    simplify(STR1, STR2);
    sprintf(STR2, "%s}", simpl_pattern);
    simplify(STR2, "}");
  }
  simplify("\\root{}\\of{", "\\sqrt{");
 
  FORLIM = kout;
  for (i = 0; i <= FORLIM - 1; i++)
    _SETIO(putc(exline[i], outputfile) >= 0, FileWriteError);
  _SETIO(putc('\n', outputfile) >= 0, FileWriteError);
 
  if (numl % 100 == 0) {   /*END IF NUML*/
/* p2c: rtflatex.cmn, line 915:
 * Note: Using % for possibly-negative arguments [317] */
    if (verbose > 0) {
      sign_str(numl, works);
      sprintf(STR3, "Output : %s lines ", works);
      print_msg(1, STR3);
      FORLIM = bracelvl;
      for (j = 1; j <= FORLIM; j++)
	print_msg(1, "{");
      println_msg(1, "");
    } else
      _SETIO(putchar('.') >= 0, FileWriteError);
  }
  cleanout();
}
 
 
/*---------------------------------------------------------------------------*/
/* write a character into output line */
 
Static Void output_real_line()
{
  if (kout > 0)
    output_line();
}
 
 
/*---------------------------------------------------------------------------*/
/* write a character into output line */
 
Static Void outchr(CHARAC)
Char CHARAC;
{
  Char oldchar;
  Char newchar = CHARAC;
  Char STR1[48];
 
  if (kout > 0) {
    oldchar = exline[kout-1];
    if (oldchar == ' ' && newchar == ' ')
      return;
  } else if (kout == 0 && last_percent && CHARAC == ' ') {
    kout = 1;
    exline[kout-1] = '\\';
  }
  /*END IF*/
  last_percent = false;
 
  if (kout >= olmx - 2) {
    /*END IF*/
    sign_str(kout, works);
    sprintf(STR1, "Output overflow, KOUT:=%s", works);
    println_msg(0, STR1);
    /*END IF*/
    return;
  }
  kout++;
  exline[kout-1] = newchar;
  if (newchar != '}' || kout <= 80) {
    /*END IF*/
    if (newchar == ' ' && kout > 64)
      output_line();
    return;
  }
  if (exline[kout-2] == ';') {
    exline[kout-1] = '\\';
    kout++;
    exline[kout-1] = 'r';
    kout++;
    exline[kout-1] = 'e';
    kout++;
    exline[kout-1] = 'l';
    kout++;
    exline[kout-1] = 'a';
    kout++;
    exline[kout-1] = 'x';
    output_line();
    kout++;
    exline[kout-1] = ' ';
    kout++;
    exline[kout-1] = newchar;
    return;
  }
  if (kout <= 120)
    return;
  kout++;
  exline[kout-1] = '%';
  kout++;
  exline[kout-1] = '%';
  output_line();
  last_percent = true;
}
 
 
/* ===================================================================== */
/* change contents of bfslcode[bracelvl] : replace first arg with 2nd */
/* but do not declare font, since output will be standard */
 
Static Void font_subs2e(old, new_)
Char *old, *new_;
{
  Char workstg[49];
  short positn;
 
  positn = strpos2(bfslcode[bracelvl], old, 1);
  if (positn == 0)
    return;
  if (lvlcode[bracelvl] == 9)   /* ignore new fonts in header/footer */
    return;
  if (verbose >= 2)
    _SETIO(printf("font_subs2e: %s|%s|%s", old, bfslcode[bracelvl], new_) >= 0,
	   FileWriteError);
  strcpy(workstg, bfslcode[bracelvl]);
  strdelete((Anyptr)workstg, positn, strlen(old));
  if (strpos2(workstg, new_, 1) == 0)
    strinsert(new_, (Anyptr)workstg, positn);
  truncate24(bfslcode[bracelvl], workstg);
  if (verbose >= 2)
    _SETIO(printf("=>%s\n", workstg) >= 0, FileWriteError);
}
 
 
/*---------------------------------------------------------------------------*/
/* inserts a new font specification like \bf \rm \sc into bfslcode[bracelvl] */
 
Static Void add_to_bfsl(kod)
Char *kod;
{  /* bfsl_old:=bfslcode[bracelvl]; */
  Char bfsl_try[65];
  Char STR1[256];
  string24 STR2;
 
  sprintf(bfsl_try, "%s\\", bfslcode[bracelvl]);
  sprintf(STR1, "%s\\", kod);
  if (strpos2(bfsl_try, STR1, 1) > 0)
    return;
  sprintf(STR1, "%s%s", bfslcode[bracelvl], kod);
  strcpy(bfslcode[bracelvl], truncate24(STR2, STR1));
  /*  writeln('add_to:',bfsl_old,'+',kod,'=',bfslcode[bracelvl]); */
}
 
 
/*---------------------------------------------------------------------------*/
/* output one character capitalized if needed */
 
Static Void outchrc(CHARAC)
Char CHARAC;
{
  Char kar;
 
  if (lvlcode[bracelvl] == 2)
    kar = toupper(CHARAC);
  else
    kar = CHARAC;
  outchr(kar);
}
 
 
/*---------------------------------------------------------------------------*/
/* write a string into output line */
 
Static Void outstg(CHARACs)
Char *CHARACs;
{
  short k, FORLIM;
 
  FORLIM = strlen(CHARACs);
  for (k = 0; k <= FORLIM - 1; k++)
    outchr(CHARACs[k]);
}
 
 
/* ===================================================================== */
/* checks the presence of a string at end of current output */
 
Static boolean last_is(CHARACs)
Char *CHARACs;
{
  boolean Result;
  short k, long_;
 
  long_ = strlen(CHARACs);
/* p2c: rtflatex.cmn: Note: Eliminated unused assignment statement [338] */
  if (kout < long_)
    return false;
  for (k = 0; k <= long_ - 1; k++) {
    if (exline[kout - long_ + k] != CHARACs[k])
      return false;
  }
  return true;
}
 
 
/* ===================================================================== */
/* remove one string from output */
 
Static Void outrem(CHARACs)
Char *CHARACs;
{
  short k, long_, FORLIM;
 
  long_ = strlen(CHARACs);
  removed_ok = last_is(CHARACs);
  if (!removed_ok)
    return;
  FORLIM = kout;
  for (k = kout - long_ + 1; k <= FORLIM; k++)
    exline[kout-1] = ' ';
  kout -= long_;
}
 
 
/* ===================================================================== */
/* remove all empty pairs of braces at the end of output */
 
Static Void outrem_empty_braces()
{
  short num_removed = 0;
 
  removed_ok = true;
  while (removed_ok) {   /*END WHILE*/
    outrem("{}");
    if (removed_ok)
      num_removed++;
  }
  removed_ok = (num_removed > 0);
}
 
 
/*---------------------------------------------------------------------------*/
/* output a TeX keyword ( the \ not in args ) on output line EXLINE */
 
Static Void outkeyw(CHARACs)
Char *CHARACs;
{
  short k, FORLIM;
 
  /* eliminate useless brace pairs terminating a previous keyword*/
  outrem_empty_braces();
  outchr('\\');
  FORLIM = strlen(CHARACs);
  for (k = 0; k <= FORLIM - 1; k++)
    outchr(CHARACs[k]);
}
 
 
/*---------------------------------------------------------------------------*/
/* outputs the new \bf \sl code if different from current at that level */
 
Static Void output_bfsl()
{
  if (!strcmp(bfslcode[bracelvl], currbfsl[bracelvl]))
    return;
  if (!strcmp(bfslcode[bracelvl], "\\relax"))
    return;
  if (math_mode[bracelvl] > 0)
    return;
  outrem_empty_braces();
  outrem(currbfsl[bracelvl]);
  font_subs2e("\\rm\\bf", "\\bf");
  font_subs2e("\\rm\\tt", "\\tt");
  font_subs2e("\\rm\\it", "\\it");
  font_subs2e("\\rm\\sf", "\\sf");
  font_subs2e("\\rm\\sl", "\\sl");
 
  if (!latex209) {
    font_subs2e("\\bf\\it", "\\bfit");
    font_subs2e("\\it\\bf", "\\bfit");
    font_subs2e("\\bf\\sl", "\\bfsl");
    font_subs2e("\\sl\\bf", "\\bfsl");
    font_subs2e("\\bf\\sf", "\\sfbf");
    font_subs2e("\\sf\\bf", "\\sfbf");
    font_subs2e("\\sf\\it", "\\sfit");
    font_subs2e("\\sf\\sl", "\\sfsl");
    font_subs2e("\\tt\\bf", "\\ttbf");
    font_subs2e("\\tt\\it", "\\ttit");
    font_subs2e("\\tt\\sl", "\\ttsl");
    font_subs2e("\\bf\\tt", "\\ttbf");
    font_subs2e("\\it\\tt", "\\ttit");
    font_subs2e("\\sl\\tt", "\\ttsl");
    font_subs2e("\\sfit\\bf", "\\sfbfit");
    font_subs2e("\\sfsl\\bf", "\\sfbfsl");
    font_subs2e("\\bfit\\sf", "\\sfbfit");
    font_subs2e("\\bfsl\\sf", "\\sfbfsl");
  }
  /* latex2e */
  /*END IF latex209*/
  outstg(bfslcode[bracelvl]);
  outstg("{}");
  strcpy(currbfsl[bracelvl], bfslcode[bracelvl]);
}
 
 
/*---------------------------------------------------------------------------*/
/* outputs the new \large code if different from current at that level */
 
Static Void output_size(codesize)
Char *codesize;
{
  if (!strcmp(codesize, currsize[bracelvl]))
    return;
  if (!strcmp(codesize, "relax"))
    return;
  if (lvlcode[bracelvl] == 8)
    return;
  if (lvlcode[bracelvl] == 9)
    return;
  if (math_mode[bracelvl] > 0)
    return;
  outkeyw(codesize);
  if (!base_flag) {   /*END IF*/
    outstg("{}");
    strcpy(currsize[bracelvl], codesize);
  }
  strcpy(currbfsl[bracelvl], "\\relax");
}
 
 
/* ----------------------------------------------------------------------*/
Static Void ensure_sizebfsl()
{
  if (par_to_begin)
    return;
  if (last_is("{"))
    output_size(sizecode[bracelvl]);
  output_bfsl();
}
 
 
/* ----------------------------------------------------------------------*/
Static Void output_skips()
{
  if (leftcurskip != leftskip) {
    str_twips_pt(leftskip, worksa);
    outkeyw("global\\leftskip ");
    outstg(worksa);
    outstg("pt\\relax");
    leftcurskip = leftskip;
  }
 
  if (rightcurskip == rightskip)
    return;
  str_twips_pt(rightskip, worksa);
  outkeyw("global\\rightskip ");
  outstg(worksa);
  outstg("pt\\relax");
  rightcurskip = rightskip;
}
 
 
/*---------------------------------------------------------------------------*/
Static Void close_files()
{
  if (outputfile != NULL)
    fclose(outputfile);
  outputfile = NULL;
  if (inputfile != NULL)
    fclose(inputfile);
  inputfile = NULL;
  if (!write_log)
    return;
  if (logfile != NULL)
    fclose(logfile);
  logfile = NULL;
}
 
 
/* ===================================================================== */
/* remove one keyword from output */
 
Static Void outkrem(CHARACs)
Char *CHARACs;
{
  Char STR1[256];
 
  sprintf(STR1, "\\%s", CHARACs);
  outrem(STR1);
}
 
 
/* --------------------------------------------------------------------------*/
/* open brace and increment  bracelvl */
 
Static Void open_brace()
{
  Char STR1[56];
  Char STR2[34];
 
  if (bracelvl < maxlevel) {
    bracelvl++;
    strcpy(bfslcode[bracelvl], bfslcode[bracelvl-1]);
    tab_nb_cellx[bracelvl] = tab_nb_cellx[bracelvl-1];
    tab_cellx[bracelvl] = 0;
    strcpy(sizecode[bracelvl], sizecode[bracelvl-1]);
    strcpy(currsize[bracelvl], currsize[bracelvl-1]);
    strcpy(currbfsl[bracelvl], currbfsl[bracelvl-1]);
    strcpy(spacingcode[bracelvl], spacingcode[bracelvl-1]);
    lvlcode[bracelvl] = lvlcode[bracelvl-1];
    if (bracelvl < maxlevel)
      lvlcode[bracelvl+1] = 0;
    strcpy(active_RTFf[bracelvl], active_RTFf[bracelvl-1]);
    /* propagate math_mode, but say 2 if previous was 1 to avoid extra closins by $ */
    math_mode[bracelvl] = math_mode[bracelvl-1];
    if (math_mode[bracelvl] == 1)
      math_mode[bracelvl] = 2;
 
    flushright_flag[bracelvl] = flushright_flag[bracelvl-1];
    if (flushright_flag[bracelvl] == 2)
      flushright_flag[bracelvl] = 3;
 
    center_flag[bracelvl] = center_flag[bracelvl-1];
    if (center_flag[bracelvl] == 2)
      center_flag[bracelvl] = 3;
 
    underl_flag[bracelvl] = false;
    auto_close[bracelvl] = false;
    *form_code[bracelvl] = '\0';
    strcpy(close_kar[bracelvl], " ");
    if (lvlcode[bracelvl] == 3) {
      lvlcode[bracelvl] = 4;
      return;
    }
    if (lvlcode[bracelvl] == 10) {   /*in objects*/
      lvlcode[bracelvl] = -lvlcode[bracelvl];
      return;
    }
    if (lvlcode[bracelvl] == 15)
	  /*brace opened after \RTFintbl => set normal*/
	    lvlcode[bracelvl] = 0;
    else if (lvlcode[bracelvl] >= 16)   /*in formulas*/
      lvlcode[bracelvl] = -lvlcode[bracelvl];
    return;
  } else {
    /*END IF*/
    sign_str(maxlevel, works);
    sprintf(STR1, "Too many brace levels, max is %s", works);
    print_msg(0, STR1);
    sign_str(numl + 1, works);
    sprintf(STR2, " at line%s", works);
    println_msg(0, STR2);
    print_line(0);
    if (write_log)
      close_files();
    _Escape(0);
    /*END IF bracelvl<maxlevel*/
  }
}
 
 
/*---------------------------------------------------------------------------*/
/* output \begin(<arg>) */
 
Static Void begin_env(environ)
short environ;
{
  if (kout > 0)
    output_line();
  outkeyw("begin{");
  outstg(environ_type[environ]);
  outstg("}\\strut");
  open_brace();
  output_line();
}
 
 
/* ----------------------------------------------------------------------*/
/* execute \begin{center}/{flushright} is center_flag set to 1 */
Static Void make_center()
{
  if (center_flag[bracelvl] == 1) {
    begin_env(1);
    center_flag[bracelvl] = 2;
  }
  if (flushright_flag[bracelvl] == 1) {
    begin_env(2);
    flushright_flag[bracelvl] = 2;
  }
}
 
 
/* ----------------------------------------------------------------------*/
Static Void begin_par()
{
  short k, FORLIM;
 
  if (!par_to_begin)
    return;
  if (lvlcode[bracelvl] == 6)
    return;
  if (lvlcode[bracelvl] == 8)
    return;
  if (lvlcode[bracelvl] == 9)
    return;
  if (center_flag[bracelvl] + flushright_flag[bracelvl] == 0)
    output_skips();
  space_after = save_skip;
  save_skip = 0;
  if (num_indent == 0 && lvlcode[bracelvl] != 15 &&
      center_flag[bracelvl] == 0 && flushright_flag[bracelvl] == 0)
    outkeyw("noindent ");
  FORLIM = num_indent;
  for (k = 2; k <= FORLIM; k++)
    outkeyw("indent ");
  num_indent = 0;
  make_center();
  output_size(sizecode[bracelvl]);
  output_bfsl();
  outkeyw("beginparagraph{}");
  par_to_begin = false;
}
 
 
/*---------------------------------------------------------------------------*/
/* write a string into math mode onto output line, and leave in math mode */
 
Static Void out_math_leave(CHARACs)
Char *CHARACs;
{
  if (math_mode[bracelvl] > 0)
    outchr(' ');
  else {
    outrem_empty_braces();
    outrem("$");
    if (removed_ok)
      math_mode[bracelvl] = 1;
  }
  /*END IF math_mode*/
  if (math_mode[bracelvl] == 0) {   /*END IF math_mode=0*/
    begin_par();
    outchr('$');
    math_mode[bracelvl] = 1;
  }
  outstg(CHARACs);
}
 
 
/*---------------------------------------------------------------------------*/
/* close math_mode if possible, i.e. =1 */
 
Static Void close_math()
{
  if (math_mode[bracelvl] == 1) {   /*END IF math_mode*/
    outstg(end_math_code);
    math_mode[bracelvl] = 0;
  }
}
 
 
/*---------------------------------------------------------------------------*/
/* write a string into math mode onto output and close math mode if possible*/
 
Static Void out_math(CHARACs)
Char *CHARACs;
{
  out_math_leave(CHARACs);
  close_math();
}
 
 
/* ===================================================================== */
/* output one string and capitalize it if required */
 
Static Void outstgc(CHARACs)
Char *CHARACs;
{
  short k, FORLIM;
 
  FORLIM = strlen(CHARACs);
  for (k = 0; k <= FORLIM - 1; k++)
    outchrc(CHARACs[k]);
}
 
 
/* ===================================================================== */
/* output a number */
 
Static Void output_num(numb)
short numb;
{
  string24 wkk;
 
  sign_str(numb, wkk);
  outstg(wkk);
}
 
 
/* ===================================================================== */
/* output one keyword and capitalize it */
 
Static Void outkeywc(CHARACs)
Char *CHARACs;
{
  short k, FORLIM;
 
  outrem_empty_braces();
  outchr('\\');
  FORLIM = strlen(CHARACs);
  for (k = 0; k <= FORLIM - 1; k++)
    outchrc(CHARACs[k]);
}
 
 
/* ===================================================================== */
/* close brace pair and remove all sub/superscripted empty pairs at end of output */
 
Static Void close_subs()
{
  if (math_mode[bracelvl] > 0)
    outrem(" ");
  outchr('}');
  outrem("^{}");
  outrem("_{}");
  outrem("^{ }");
  outrem("_{ }");
}
 
 
/* ===================================================================== */
/* declares a new font as \global, and record it */
 
Static Void declare_font(font_id, fontname, magnification)
Char *font_id, *fontname;
short magnification;
{
  short i, FORLIM;
  Char STR2[256];
 
  FORLIM = numfonts;
  for (i = 0; i <= FORLIM - 1; i++) {
    if (!strcmp(newfonts[i], font_id))
      return;
  }
  if (numfonts >= maxfonts) {   /*END IF*/
    sprintf(STR2, "Font %s cannot be declared... too many fonts !", font_id);
    println_msg(0, STR2);
    return;
  }
 
  numfonts++;
  truncate24(newfonts[numfonts-1], font_id);
 
  if (kout > 1)   /* to have font decl at left of a line */
    output_line();
  outstg("\\ifx");
  outstg(font_id);
  outstg("\\undefined \\global\\font");
  outstg(font_id);
  outstg("=\\FontHdg\\FontHdge ");
  outstg(fontname);
  sign_str(magnification, works);
  outstg(" scaled ");
  outstg(works);
  outstg("\\fi");
  output_line();
 
}
 
 
/* ===================================================================== */
/* change contents of bfslcode[bracelvl] : replace first arg with 2nd */
 
Static Void font_subs(old, new_, fontname, magnification)
Char *old, *new_, *fontname;
short magnification;
{
  Char workstg[49];
  short positn;
 
  positn = strpos2(bfslcode[bracelvl], old, 1);
  if (positn == 0)
    return;
  if (lvlcode[bracelvl] == 9)   /* ignore new fonts in header/footer */
    return;
  strcpy(workstg, bfslcode[bracelvl]);
  strdelete((Anyptr)workstg, positn, strlen(old));
  if (strpos2(bfslcode[bracelvl], new_, 1) == 0)
    strinsert(new_, (Anyptr)workstg, positn);
  truncate24(bfslcode[bracelvl], workstg);
  declare_font(new_, fontname, magnification);
}
 
 
/*---------------------------------------------------------------------------*/
/* builds the correct LaTeX font size according to NUMVAL (unit=1/2 pt) */
/* stores it in sizecode[bracelvl] ; uses the global variable "stdsize" */
 
Static Void outfsize(numval, magnif)
short numval, *magnif;
{
  short ll;
  short selectsize = 0;
  short latex_size;
  short best_diff = 30000;
  Char STR1[68];
 
  /* I select the nearest sizemags */
  latex_size = numval * 50;
      /* convert from half points to hundredths of points */
  /* big integer */
  strcpy(sizecode[bracelvl], "tiny");
  for (ll = 0; ll <= numsizes - 1; ll++) {   /*END DO*/
    if (abs(sizemags[stdkz-1][ll] - latex_size) < best_diff) {   /*END IF*/
      strcpy(sizecode[bracelvl], sizekey[ll]);
      selectsize = sizemags[stdkz-1][ll];
      *magnif = sizemags[stdkz-1][ll];
      best_diff = abs(selectsize - latex_size);
    }
  }
 
  sign_str(selectsize, works);
  sprintf(STR1, " selectsize=%s xkey=%s", works, sizecode[bracelvl]);
  println_msg(2, STR1);
 
}
 
 
/*---------------------------------------------------------------------------*/
Static Void font_clean(sizeheader, magnification)
Char *sizeheader;
short magnification;
{
  Char STR1[256];
 
  if (latex209) {
    sprintf(STR1, "%sbfit", sizeheader);
    font_subs("\\rm\\bf\\it", STR1, "bxti10", magnification);
    sprintf(STR1, "%sbfit", sizeheader);
    font_subs("\\rm\\it\\bf", STR1, "bxti10", magnification);
    sprintf(STR1, "%sbfsl", sizeheader);
    font_subs("\\rm\\bf\\sl", STR1, "bxsl10", magnification);
    sprintf(STR1, "%sbfsl", sizeheader);
    font_subs("\\rm\\sl\\bf", STR1, "bxsl10", magnification);
    sprintf(STR1, "%ssfbf", sizeheader);
    font_subs("\\rm\\bf\\sf", STR1, "ssbx10", magnification);
    sprintf(STR1, "%ssfbf", sizeheader);
    font_subs("\\rm\\sf\\bf", STR1, "ssbx10", magnification);
    sprintf(STR1, "%sbfit", sizeheader);
    font_subs("\\bf\\it", STR1, "bxti10", magnification);
    sprintf(STR1, "%sbfit", sizeheader);
    font_subs("\\it\\bf", STR1, "bxti10", magnification);
    sprintf(STR1, "%sbfsl", sizeheader);
    font_subs("\\bf\\sl", STR1, "bxsl10", magnification);
    sprintf(STR1, "%sbfsl", sizeheader);
    font_subs("\\sl\\bf", STR1, "bxsl10", magnification);
    sprintf(STR1, "%ssfbf", sizeheader);
    font_subs("\\bf\\sf", STR1, "ssbx10", magnification);
    sprintf(STR1, "%ssfbf", sizeheader);
    font_subs("\\sf\\bf", STR1, "ssbx10", magnification);
    if (magnification > 2000) {  /*definir explicitement les grosses polices*/
      sprintf(STR1, "%sobf", sizeheader);
      font_subs("\\rm\\oul", STR1, "obx10", magnification);
      sprintf(STR1, "%ssf", sizeheader);
      font_subs("\\rm\\sf", STR1, "ss10", magnification);
      sprintf(STR1, "%sit", sizeheader);
      font_subs("\\rm\\it", STR1, "ti10", magnification);
      sprintf(STR1, "%ssl", sizeheader);
      font_subs("\\rm\\sl", STR1, "sl10", magnification);
      sprintf(STR1, "%ssc", sizeheader);
      font_subs("\\rm\\sc", STR1, "csc10", magnification);
      sprintf(STR1, "%stt", sizeheader);
      font_subs("\\rm\\tt", STR1, "tt10", magnification);
      sprintf(STR1, "%ssf", sizeheader);
      font_subs("\\sf", STR1, "ss10", magnification);
      sprintf(STR1, "%sit", sizeheader);
      font_subs("\\it", STR1, "ti10", magnification);
      sprintf(STR1, "%ssl", sizeheader);
      font_subs("\\sl", STR1, "sl10", magnification);
      sprintf(STR1, "%ssc", sizeheader);
      font_subs("\\sc", STR1, "csc10", magnification);
      sprintf(STR1, "%stt", sizeheader);
      font_subs("\\tt", STR1, "tt10", magnification);
    }
  } else {
    font_subs2e("\\rm\\bf\\it", "\\bfit");
    font_subs2e("\\rm\\it\\bf", "\\bfit");
    font_subs2e("\\rm\\bf\\sl", "\\bfsl");
    font_subs2e("\\rm\\sl\\bf", "\\bfsl");
    font_subs2e("\\rm\\bf\\sf", "\\sfbf");
    font_subs2e("\\rm\\sf\\bf", "\\sfbf");
    font_subs2e("\\rm\\sf\\it", "\\sfit");
    font_subs2e("\\rm\\sf\\sl", "\\sfsl");
    font_subs2e("\\bf\\it", "\\bfit");
    font_subs2e("\\it\\bf", "\\bfit");
    font_subs2e("\\bf\\sl", "\\bfsl");
    font_subs2e("\\sl\\bf", "\\bfsl");
    font_subs2e("\\bf\\sf", "\\sfbf");
    font_subs2e("\\sf\\bf", "\\sfbf");
    font_subs2e("\\sf\\it", "\\sfit");
    font_subs2e("\\sf\\sl", "\\sfsl");
    if (magnification > 2000) {  /*definir explicitement les grosses polices*/
      sprintf(STR1, "%sobf", sizeheader);
      font_subs("\\rm\\oul", STR1, "obx10", magnification);
      sprintf(STR1, "%ssf", sizeheader);
      font_subs("\\rm\\sf", STR1, "ss10", magnification);
      sprintf(STR1, "%sit", sizeheader);
      font_subs("\\rm\\it", STR1, "ti10", magnification);
      sprintf(STR1, "%ssl", sizeheader);
      font_subs("\\rm\\sl", STR1, "sl10", magnification);
      sprintf(STR1, "%ssc", sizeheader);
      font_subs("\\rm\\sc", STR1, "csc10", magnification);
      sprintf(STR1, "%stt", sizeheader);
      font_subs("\\rm\\tt", STR1, "tt10", magnification);
      sprintf(STR1, "%ssf", sizeheader);
      font_subs("\\sf", STR1, "ss10", magnification);
      sprintf(STR1, "%sit", sizeheader);
      font_subs("\\it", STR1, "ti10", magnification);
      sprintf(STR1, "%ssl", sizeheader);
      font_subs("\\sl", STR1, "sl10", magnification);
      sprintf(STR1, "%ssc", sizeheader);
      font_subs("\\sc", STR1, "csc10", magnification);
      sprintf(STR1, "%stt", sizeheader);
      font_subs("\\tt", STR1, "tt10", magnification);
    }
  }
  sprintf(STR1, "%sobf", sizeheader);
  /* latex2e */
  /*END IF latex209*/
  font_subs("\\rm\\oul", STR1, "obx10", magnification);
 
}
 
 
/*---------------------------------------------------------------------------*/
/* output the correct LaTeX spacing size according to NUMVAL (unit=1/20 pt) */
/* stores it in spacingcode[bracelvl] ; uses the global variable "stdsize" */
 
Static Void outpsize(numval)
short numval;
{
  short ll;
  short selectsize = 0, best_diff = 30000;
  Char STR1[108];
  Char STR3[40];
 
  if (base_flag) {
    str_twips_pt(numval, worksa);
    sprintf(STR3, "baselineskip%spt", worksa);
    truncate24(spacingcode[bracelvl], STR3);
    return;
  }
  /* I select the nearest sizeval -- spacings in twips */
  /* big integer */
  strcpy(spacingcode[bracelvl], "tiny");
  for (ll = 0; ll <= numsizes - 1; ll++) {   /*END DO*/
    if (abs(sizeval[stdkz-1][ll] - numval) < best_diff) {   /*END IF*/
      strcpy(spacingcode[bracelvl], sizekey[ll]);
      selectsize = sizeval[stdkz-1][ll];
      best_diff = abs(sizeval[stdkz-1][ll] - numval);
    }
  }
 
  sign_str(numval, works);
  sign_str(selectsize, worksa);
  sprintf(STR1, "--> (\\par)numval=%s selectsize=%s pkey=%s",
	  works, worksa, spacingcode[bracelvl]);
  print_msg(2, STR1);
  /*END IF*/
}
 
 
/*---------------------------------------------------------------------------*/
/* remove $^ before, and remove math_mode if possible */
 
Static Void remove_mathat()
{
  if (math_mode[bracelvl] > 0) {   /*END IF math_mode*/
    if (auto_close[bracelvl]) {
      outrem("{");
      if (removed_ok)
	bracelvl--;
    }
    outrem("^");
    outrem("\\relax");
    if (math_mode[bracelvl] == 1) {
      outrem("$");
      if (removed_ok)
	math_mode[bracelvl] = 0;
    }
  }
  outrem("{}");
}
 
 
/* --------------------------------------------------------------------------*/
/* close brace and decrement  bracelvl */
 
Static Void close_brace()
{
  Char STR1[44];
  Char STR3[68];
 
  if (bracelvl <= 0) {
    sign_str(numl + 1, works);
    sprintf(STR1, "Too many } at line %s", works);
    println_msg(0, STR1);
    print_line(0);
    outstg("}%%%%% *****");
  } else {
    if (lvlcode[bracelvl] != 6) {
      if (tex_verbose > 1) {
	sign_str(bracelvl, worksa);
	sign_str(lvlcode[bracelvl], works);
	sprintf(STR3, "\\closebr{%s[%s]}\\relax", worksa, works);
	outstg(STR3);
	output_line();
      }
    }
  }
  bracelvl--;
  /* reset footnote cleaning */
  if (lvlcode[bracelvl] == 3)   /*END IF bracelvl*/
    lvlcode[bracelvl] = 0;
}
 
 
/*---------------------------------------------------------------------------*/
/* output \end(<arg>) */
 
Static Void end_env(environ)
short environ;
{
  output_line();
  outkeyw("end{");
  outstg(environ_type[environ]);
  outchr('}');
  close_brace();
  output_line();
}
 
 
/*---------------------------------------------------------------------------*/
/* stores a new couple of word font chars and number taken in
decl_font_num which is a global variable */
 
Static Void store_word_font(font_type)
Char *font_type;
{
  short k;
  Char new_fnt_name[256];
  short loc_brace_count = 0;
  short FORLIM;
  Char STR2[256], STR3[256];
 
  sign_str(decl_font_num, works);
  FORLIM = num_word_fonts;
  for (k = 0; k <= FORLIM - 1; k++) {   /*END/IF + END FOR*/
    if (word_font_num[k] == decl_font_num) {
      sprintf(STR2, "RTF font No. %s/%s already declared; this one ignored.",
	      works, font_type);
      println_msg(0, STR2);
      return;
    }
  }
  if (num_word_fonts >= maxfonts) {   /*END IF*/
    sprintf(STR3, "Too many RTF fonts: %s/%s; this one ignored.",
	    works, font_type);
    println_msg(0, STR3);
    return;
  }
  *new_fnt_name = '\0';
  while (kar != ';' && kar != '}' || loc_brace_count > 0) {
    /*  while (kar<>';') do */
    if (kar == '{')
      loc_brace_count++;
    if (kar == '}')
      loc_brace_count--;
    read_char();
    if (kar != ' ')
      sprintf(new_fnt_name + strlen(new_fnt_name), "%c", kar);
  }
  outrem_empty_braces();
  num_word_fonts++;
  word_font_num[num_word_fonts-1] = decl_font_num;
  truncate24(word_fonts[num_word_fonts-1], font_type);
  sign_str(num_word_fonts, worksa);
  if (strpos2(new_fnt_name, "Courier", 1) > 0)
    strcpy(equiv_fonts[num_word_fonts-1], "\\tt");
  else if (strpos2(new_fnt_name, "TTY", 1) > 0)
    strcpy(equiv_fonts[num_word_fonts-1], "\\tt");
  else if (strpos2(new_fnt_name, "Helvetica", 1) > 0)
    strcpy(equiv_fonts[num_word_fonts-1], "\\sf");
  else if (strpos2(new_fnt_name, "SansSerif", 1) > 0)
    strcpy(equiv_fonts[num_word_fonts-1], "\\sf");
  else
    *equiv_fonts[num_word_fonts-1] = '\0';
  sprintf(STR3, "%s Font %s stored: \"%s\" = %s",
	  worksa, works, font_type, new_fnt_name);
  /*END IF*/
  println_msg(2, STR3);
}
 
 
 
/*---------------------------------------------------------------------------*/
/* sets active_RTFf of current bracelvl at the alpha value recorded with kkk
as \F<number> in \fonttbl declaration */
 
Static Void set_active_RTFf(kkk)
short kkk;
{
  short k, FORLIM;
  Char STR1[40];
  Char STR2[100];
  Char STR3[38];
  Char STR4[62];
  Char STR5[82];
 
  FORLIM = num_word_fonts;
  for (k = 0; k <= FORLIM - 1; k++) {   /*END/IF + END FOR*/
    if (word_font_num[k] == kkk) {
      sign_str(kkk, works);
      sprintf(STR2, "RTF font No. %s of type %s \"%s\"",
	      works, word_fonts[k], equiv_fonts[k]);
      println_msg(2, STR2);
      add_to_bfsl(equiv_fonts[k]);
      ensure_sizebfsl();
      strcpy(active_RTFf[bracelvl], word_fonts[k]);
      return;
    }
  }
  if (lvlcode[bracelvl] != 6) {   /*END IF lvlcode*/
    print_line(2);
    sign_str(num_word_fonts, works);
    sprintf(STR1, "num_word_fonts=%s", works);
    println_msg(2, STR1);
    FORLIM = num_word_fonts;
    for (k = 0; k <= FORLIM - 1; k++) {
      sign_str(word_font_num[k], works);
      sprintf(STR4, "     %s --> \"%s\"", works, word_fonts[k]);
      println_msg(2, STR4);
    }
    sign_str(kkk, works);
    sprintf(STR3, "RTF font No. %s", works);
    print_msg(2, STR3);
    sign_str(lvlcode[bracelvl], works);
    sign_str(bracelvl, worksa);
    sprintf(STR5, " font of type unknown, lvlcode[%s]=%s", worksa, works);
    println_msg(2, STR5);
    sign_str(lvlcode[bracelvl-1], works);
    sign_str(bracelvl - 1, worksa);
    sprintf(STR5, " font of type unknown, lvlcode[%s]=%s", worksa, works);
    println_msg(2, STR5);
  }
  *active_RTFf[bracelvl] = '\0';
}
 
 
/* ------------------------------------------------------------------------- */
/* closing a \sum(...) ... possibly at a ) found !!!!!*/
 
Static Void close_sum()
{
  close_brace();
  close_math();
}
 
 
/* ------------------------------------------------------------------------- */
/* closing a \sum(...) ... possibly at a closing brace if no ) found !!!!!*/
 
Static Void close_sum_emergency(kode)
Char *kode;
{
  short k;
  Char STR1[256];
  Char STR3[42];
  short FORLIM;
 
  sign_str(input_line_number, works);
  sprintf(STR1, "Emergency close of \\|su or \\|i due to }%s at inp.line %s",
	  kode, works);
  println_msg(1, STR1);
  sign_str(next_rtf[0], works);
  sprintf(STR3, "pattern : \"%c%c\" %s", kar, next_rtf[0], works);
  print_msg(1, STR3);
  print_line(1);
  _SETIO(printf("kinp=%d prev_kinp=%d\n", kinp, prev_kinp) >= 0,
	 FileWriteError);
  FORLIM = prev_kinp;
  for (k = 0; k <= FORLIM - 1; k++) {
    sprintf(STR1, "%c", prev_line[k]);
    print_msg(1, STR1);
  }
  println_msg(1, " ");
  FORLIM = kinp;
  for (k = 0; k <= FORLIM - 1; k++) {
    sprintf(STR1, "%c", inpline[k]);
    print_msg(1, STR1);
  }
  println_msg(1, " ");
  outstg("\\emergcA ");
  close_sum();
}
 
 
/* --------------------------------------------------------------------------*/
Static Void perform_RTFcell()
{
  if (verbose > 0)
    _SETIO(printf("(found)%s[%d,%d,%d]\n",
		  inkeyw, lvlcode[bracelvl], tab_nb_ands[bracelvl],
		  bracelvl) >= 0, FileWriteError);
  if (lvlcode[bracelvl] == 15) {
    output_real_line();
    /* count the number of ampersands in the tabular line */
    tab_nb_ands[bracelvl]++;
    if (tab_nb_ands[bracelvl] < tab_nb_cellx[bracelvl]) {
      outstg(" & ");
      if (verbose > 1)
	_SETIO(printf("(after &)%s[%d,%d]\n",
		      inkeyw, lvlcode[bracelvl],
		      bracelvl) >= 0, FileWriteError);
      return;
    }
    outstg("\\\\");
    if (clbrdrb)
      outkeyw("hline ");
    if (verbose > 1)
      _SETIO(printf("(after &->\\\\)%s[%d,%d]\n",
		    inkeyw, lvlcode[bracelvl],
		    bracelvl) >= 0, FileWriteError);
    return;
  }
  if (verbose > 2)
    _SETIO(printf("%s[%d,%d]\n", inkeyw, lvlcode[bracelvl], bracelvl) >= 0,
	   FileWriteError);
  outkeyw("relax");
  output_line();   /* next line to ensure possible removal */
  outkeyw("RTFcell ");
  /*END IF lvlcode*/
 
}
 
 
/* --------------------------------------------------------------------------*/
/* procedure to close center and flushright environments */
 
Static Void close_envir()
{
  boolean RTF_cell_removed;
 
  envir_closed_ok = false;
  if (center_flag[bracelvl] == 2) {
    if (!no_space_conv)
      output_size(spacingcode[bracelvl]);
    outkrem("RTFcell ");
    RTF_cell_removed = removed_ok;
    center_flag[bracelvl] = 0;
    end_env(1);
    if (RTF_cell_removed)
      perform_RTFcell();
    output_line();
    envir_closed_ok = true;   /* output_line; */
    return;
  }
  if (flushright_flag[bracelvl] != 2)
    return;
  if (!no_space_conv)
    output_size(spacingcode[bracelvl]);
  outkrem("RTFcell ");
  RTF_cell_removed = removed_ok;
  flushright_flag[bracelvl] = 0;
  end_env(2);
  if (RTF_cell_removed)
    perform_RTFcell();
  output_line();
  envir_closed_ok = true;   /* output_line; */
  /*END IF center_flag*/
}
 
 
/* --------------------------------------------------------------------------*/
/* procedure to perform RTFsb/RTFsa */
 
Static Void make_RTFsab(numval)
short numval;
{
  Char STR1[48];
 
  if (numval > 300) {
    outkeyw("bigskip{}");
    return;
  }
  if (numval > 200) {
    outkeyw("medskip{}");
    return;
  }
  if (numval > 100) {
    outkeyw("smallskip{}");
    return;
  }
  if (numval > 0) {
    outkeyw("vspace 0.5\\smallskipamount{}");
    return;
  }
  if (numval < 0) {
    sign_str(numval, works);
    sprintf(STR1, "neg. spacing, NUMVAL:=%s", works);
    println_msg(1, STR1);
    /*END IF*/
  }
}
 
 
/* --------------------------------------------------------------------------*/
/* procedure to perform RTFpar (separate since it may be delayed after a } */
 
Static Void make_RTFpar(texcode)
Char *texcode;
{
  short k;
  short num_forced = 0;
  boolean was_underl;
  Char STR1[72];
  Char STR2[36];
  Char STR3[44];
 
  while (math_mode[bracelvl] > 1) {
    if (lvlcode[bracelvl] == 16)
      outstg("\\relax %%% ???");
    else
      outstg("}\\relax %%% !!!");
    output_line();
    close_brace();
    num_forced++;
  }
  close_math();
  if (num_forced > 0) {   /*END IF*/
    close_envir();
    output_size(spacingcode[bracelvl]);
    output_line();
    output_line();
    par_to_begin = true;
    num_indent = 0;
    if (space_after != 0)
      make_RTFsab(space_after);
    space_after = 0;
    sign_str(input_line_number, worksa);
    sign_str(bracelvl, works);
    sprintf(STR1, "input line %s, bracelvl=%s", worksa, works);
    println_msg(0, STR1);
    sign_str(num_forced, works);
    sprintf(STR2, "num_forced=%s", works);
    println_msg(0, STR2);
  }
 
  was_underl = underl_flag[bracelvl];
  outkrem(bfslcode[bracelvl]);
  if (was_underl)
    outchr('}');
  output_line();
  if (!no_space_conv)
    output_size(spacingcode[bracelvl]);
  close_envir();
  if (!(envir_closed_ok || no_space_conv))
    outkeyw("null ");
  outstg(texcode);
  if (space_after != 0)
    make_RTFsab(space_after);
  space_after = 0;
  par_to_begin = true;
  num_indent = 0;
 
  if (was_underl)
    outkeyw("underbar{");
 
  for (k = 1; k <= num_forced; k++) {   /*END DO*/
    outchr('{');
    bracelvl++;
    math_mode[bracelvl] = 0;   /*do not open ??? */
  }
 
  sign_str(bracelvl, works);
  if (num_forced > 0) {
    sprintf(STR3, "restored bracelvl=%s", works);
    println_msg(0, STR3);
  }
}
 
 
/* --------------------------------------------------------------------------*/
/* replace recent space with a ~ (before : ; ? ! in general */
Static Void insert_tilde(CHARAC)
Char CHARAC;
{
  if (math_mode[bracelvl] == 0) {   /*END IF*/
    outrem(" ");
    if (removed_ok)
      outchr('~');
  }
  begin_par();
  outchr(CHARAC);
  keyw = 0;
}
 
 
/* --------------------------------------------------------------------------*/
/* initiates "tabular" but does not reset parms to zero */
Static Void perform_RTFtrow()
{
  if (verbose > 0)
    _SETIO(printf("(init row)%s[%d,%d]\n",
		  inkeyw, lvlcode[bracelvl], bracelvl) >= 0, FileWriteError);
  open_brace();
  lvlcode[bracelvl] = 13;
  if (verbose > 1)
    _SETIO(printf("%s(after)[%d,%d]\n", inkeyw, lvlcode[bracelvl], bracelvl) >= 0,
	   FileWriteError);
  tab_nb_ands[bracelvl] = 0;
}
 
 
/* --------------------------------------------------------------------------*/
Static Void perform_RTFrow()
{
  if (lvlcode[bracelvl] == 15) {
    if (verbose > 0)
      _SETIO(printf("\\RTFrow[%d,%d,%d]\n",
		    lvlcode[bracelvl], tab_nb_cellx[bracelvl],
		    bracelvl) >= 0, FileWriteError);
    close_brace();
    outkeyw("end{tabular}\\par ");
    tab_nb_cellx[bracelvl] = tab_nb_cellx[bracelvl+1];
    return;
  }
  if (verbose > 1)
    _SETIO(printf("\\RTFrow[%d,%d]\n", lvlcode[bracelvl], bracelvl) >= 0,
	   FileWriteError);
  output_real_line();
  outkeyw("RTFrow ");
  /*END IF lvlcode*/
 
}
 
 
/* --------------------------------------------------------------------------*/
Static Void make_closing_brace()
{
  Char pict_byte;
  boolean already_closed = false;
  Char STR1[142];
  Char STR2[148];
  Char STR3[34];
 
  while (auto_close[bracelvl]) {   /*END WHILE auto_close*/
    if (math_mode[bracelvl] == 1)
      outchr('$');
    outchr('}');
    close_brace();
  }
  /* check "*/
  /*" within \|I(...) and similar : then ignore pair */
  if (lvlcode[bracelvl] >= 16 && next_rtf[0] == '{') {
    next_rtf[0] = '\0';
    return;
  }
  if (*form_code[bracelvl] != '\0' && next_rtf[0] == '{') {
    next_rtf[0] = '\0';
    return;
  }
  /* special case of \|su(...) closing */
  if (lvlcode[bracelvl] == 25)
    close_sum();
  else if (lvlcode[bracelvl] >= 16)
    close_sum_emergency("lvlc");
  /*END IF*/
  close_math();
 
  if (lvlcode[bracelvl] != 4) {
    if (lvlcode[bracelvl] == 5) {
      /* this is \RTFpict closing brace */
      if (pict_left_hexa) {   /*END IF pict_left_hexa*/
	/* look whether there is already one hexa digit stored*/
	pict_last_hexa *= 16;
	pict_byte = pict_last_hexa;
	_SETIO(putc(pict_byte, figurefile) >= 0, FileWriteError);
	pict_byte_number++;
	pict_last_hexa = 0;
	pict_left_hexa = false;
      }
 
      if (figurefile != NULL)
	fclose(figurefile);
      figurefile = NULL;
      sprintf(STR1, "closed file %s", figure_name);
      print_msg(1, STR1);
      sign_str((int)pict_byte_number, works);
      sprintf(STR3, "(%s bytes)", works);
      println_msg(1, STR3);
      outchr(kar);
    } else if (lvlcode[bracelvl] == 10) {
      sprintf(STR2, "closed dummy file %s", figure_name);
      /* this is \RTFobject closing brace */
      println_msg(1, STR2);
      outchr(kar);
    }
    /* if there was a \cell just before, put it outside the closing brace */
    else if (last_is("\\RTFcell ")) {
      if (verbose > 1)
	_SETIO(printf("closing}[%d,%d]\n", lvlcode[bracelvl], bracelvl) >= 0,
	       FileWriteError);
      outkrem("RTFcell ");
      if (!removed_ok)
	_SETIO(printf("*** \\RTFcell not removed before } ***\n") >= 0,
	       FileWriteError);
      outchr(kar);
      close_brace();
      already_closed = true;
      if (verbose > 0)
	_SETIO(printf("moved \\RTFcell [%d,%d]\n",
		      lvlcode[bracelvl], bracelvl) >= 0, FileWriteError);
      perform_RTFcell();
    }
    /* if there was a \row just before, put it outside the closing brace */
    else if (last_is("\\RTFrow ")) {
      if (verbose > 1)
	_SETIO(printf("closing}[%d,%d]\n", lvlcode[bracelvl], bracelvl) >= 0,
	       FileWriteError);
      outkrem("RTFrow ");
      outchr(kar);
      close_brace();
      already_closed = true;
      if (verbose > 0)
	_SETIO(printf("moved \\RTFrow [%d,%d]\n", lvlcode[bracelvl], bracelvl) >=
	       0, FileWriteError);
      perform_RTFrow();
    } else {
      /* if there was a \par just before, put it outside the closing brace */
      if (last_is("\\null \\par ")) {
	outkrem("null \\par ");
	outchr(kar);
	if (no_space_conv)
	  outkeyw("par ");
	else
	  outkeyw("null \\par ");
      } else if (last_is("\\par ")) {
	outkrem("par ");
	outchr(kar);
	outkeyw("par ");
      } else
	outchr(kar);
      /*ENF IF*/
 
      if (*form_code[bracelvl] != '\0') {   /*END IF*/
	if (*form_code[bracelvl-1] == '\0')
	  strcpy(form_code[bracelvl-1], form_code[bracelvl]);
	else {
	  close_sum_emergency("form");
	  /* this is an ordinary closing brace */
	}
      }
      /*END IF*/
    }
  }
  /* this is footnote first and dummy RTF argument closing brace */
 
  /*END IF*/
  if (!already_closed) {
    close_brace();
    /*END IF*/
  }
}
 
 
/* --------------------------------------------------------------------------*/
/* special output of single characters due to \TeX special codings */
 
Static Void special_TeX_chars()
{
  Char STR1[256];
 
  begin_par();
  if (kar == '$') {
    outstg("\\$");
    /*END IF*/
    return;
  }
  if (kar == '_') {
    outstg("\\_");
    return;
  }
  if (kar == '#') {
    outstg("\\#");
    return;
  }
  if ((kar == '>' || kar == '<') && math_mode[bracelvl] == 0) {
    sprintf(STR1, "%c", kar);
    out_math(STR1);
    return;
  }
  if (kar == '&') {
    outstg("\\&");
    return;
  }
  if (kar == '%') {
    outstg("\\%");
    return;
  }
  if (kar == '^') {
    outstg("\\^{ }");
    return;
  }
  if (kar == '~')
    out_math("\\sim{}");
  else
    outchr(kar);
}
 
 
/* --------------------------------------------------------------------------*/
/* **************** Beginning of RTF decoding procedures ******************* */
/*---------------------------------------------------------------------------*/
/* treats a character when KEYW is 0 */
/* no keyword decoding presently active */
 
Static Void keyw_is_0()
{
  short hexa_digit;
  Char pict_byte;
  string24 open_kar, RTFform, acc_converted, STR1;
  Char STR2[28];
  Char STR3[26];
  Char STR4[256];
  Char STR5[32];
  Char STR6[36];
  Char STR8[12];
 
  if (cat == 0) {   /* this is a backslash */
    if (lvlcode[bracelvl] == 3)
      return;
    /* ignore after \footnote until opening brace */
    if (lvlcode[bracelvl] == 4)
      return;
    /* ignore after \footnote { (first brace pair after) */
    if (lvlcode[bracelvl] == 9) {
      /*END IF active_RTF*/
      return;
    }
 
    keyw = 1;
    numval = 0;
    numsign = 1;
    strcpy(inkeyw, "\\RTF");
    return;
  }
  /*END IF*/
  if (cat == 1) {   /* this is an opening brace */
    if (no_RTFrtf)   /* ignore first opening brace before \rtf1 */
      return;
    if (lvlcode[bracelvl] == 3) {
      open_brace();
      return;
    }
    if (lvlcode[bracelvl] == 4) {
      open_brace();
      return;
    }
    if (lvlcode[bracelvl] == 6) {
      outchr(kar);
      open_brace();
      return;
    }
    if (par_to_begin)
      output_size(sizecode[bracelvl]);
    make_center();
    outchr(kar);
    open_brace();
    return;
  }
  /*END IF*/
  if (cat == 2) {   /* this is a closing brace */
    close_envir();
    if (bracelvl > 0)
      make_closing_brace();
    return;
  }
  if (cat == 3) {   /* this is an opening parenthesis '(' */
    if (*form_code[bracelvl] != '\0') {
      if (!strcmp(form_code[bracelvl], "\\RTFformulaB")) {
	sprintf(STR2, "%sBC(", form_code[bracelvl]);
	strcpy(form_code[bracelvl], truncate24(STR1, STR2));
      }
      if (!strcmp(form_code[bracelvl], "\\RTFformulaBLC")) {
	sprintf(STR3, "%s(", form_code[bracelvl]);
	strcpy(form_code[bracelvl], truncate24(STR1, STR3));
      }
      if (!strcmp(form_code[bracelvl], "\\RTFformulaBRC")) {
	sprintf(STR3, "%s(", form_code[bracelvl]);
	strcpy(form_code[bracelvl], truncate24(STR1, STR3));
      }
      if (!strcmp(form_code[bracelvl], "\\RTFformulaBBC")) {
	sprintf(STR3, "%s(", form_code[bracelvl]);
	strcpy(form_code[bracelvl], truncate24(STR1, STR3));
      }
      if (strpos2(form_code[bracelvl], "\\RTFformulaBBC", 1) > 0) {
	strcpy(RTFform, form_code[bracelvl]);
	sprintf(open_kar, "%c", RTFform[strlen(RTFform) - 1]);
	if (!strcmp(open_kar, "{"))
	  strcpy(open_kar, "\\{");
	out_math_leave("\\left");
	outstg(open_kar);
	outchr(' ');
	*form_code[bracelvl] = '\0';
	open_brace();
	lvlcode[bracelvl] = 16;   /* special code to close with ) */
	if (!strcmp(open_kar, "("))
	  strcpy(close_kar[bracelvl], ")");
	else if (!strcmp(open_kar, "["))
	  strcpy(close_kar[bracelvl], "]");
	else if (!strcmp(open_kar, "\\{"))
	  strcpy(close_kar[bracelvl], "\\}");
	else
	  strcpy(close_kar[bracelvl], open_kar);
	/*END IF open_kar*/
	kar = ' ';   /* to prevent do_it_again */
	return;
      }
      if (strpos2(form_code[bracelvl], "\\RTFformulaBLC", 1) > 0) {
	strcpy(RTFform, form_code[bracelvl]);
	sprintf(open_kar, "%c", RTFform[strlen(RTFform) - 1]);
	if (!strcmp(open_kar, "{"))
	  strcpy(open_kar, "\\{");
	out_math_leave("\\left");
	outstg(open_kar);
	outchr(' ');
	*form_code[bracelvl] = '\0';
	open_brace();
	lvlcode[bracelvl] = 16;   /* special code to close with ) */
	strcpy(close_kar[bracelvl], ".");
	kar = ' ';   /* to prevent do_it_again */
	return;
      }
      if (strpos2(form_code[bracelvl], "\\RTFformulaBRC", 1) > 0) {
	strcpy(RTFform, form_code[bracelvl]);
	sprintf(open_kar, "%c", RTFform[strlen(RTFform) - 1]);
	if (!strcmp(open_kar, "{"))
	  strcpy(open_kar, "\\{");
	out_math_leave("\\left. ");
	*form_code[bracelvl] = '\0';
	open_brace();
	lvlcode[bracelvl] = 16;   /* special code to close with ) */
	if (!strcmp(open_kar, "("))
	  strcpy(close_kar[bracelvl], ")");
	else if (!strcmp(open_kar, "["))
	  strcpy(close_kar[bracelvl], "]");
	else if (!strcmp(open_kar, "\\{"))
	  strcpy(close_kar[bracelvl], "\\}");
	else
	  strcpy(close_kar[bracelvl], open_kar);
	/*END IF open_kar*/
	kar = ' ';   /* to prevent do_it_again */
	return;
      }
      /* case of \|F( ... ; ... ) */
      if (!strcmp("\\RTFformulaF", form_code[bracelvl])) {
	*form_code[bracelvl] = '\0';
	out_math_leave("{\\displaystyle ");
	open_brace();
	lvlcode[bracelvl] = 17;
	kar = ' ';   /* to prevent do_it_again */
	return;
      }
      /* case of \|D\|BA() or \|D\|FO() */
      if (!strcmp("\\RTFformulaDFO", form_code[bracelvl])) {
	sign_str(displ_skip, worksa);
	*form_code[bracelvl] = '\0';
	sprintf(STR5, "kern %spt", worksa);
	outkeyw(STR5);
	open_brace();
	lvlcode[bracelvl] = 28;
	kar = ' ';   /* to prevent do_it_again */
	return;
      }
      /* case of \|D\|LI() */
      if (!strcmp("\\RTFformulaDLI", form_code[bracelvl])) {
	sign_str(displ_skip, worksa);
	*form_code[bracelvl] = '\0';
	sprintf(STR6, "RTFhrule %spt", worksa);
	outkeyw(STR6);
	open_brace();
	lvlcode[bracelvl] = 28;
	kar = ' ';   /* to prevent do_it_again */
	return;
      }
      /* case of \|O( ... ; ... ) */
      if (!strcmp("\\RTFformulaO", form_code[bracelvl])) {
	*form_code[bracelvl] = '\0';
	begin_par();
	outkeyw("hbox{\\ooalign{\\hfil{}");
	open_brace();
	lvlcode[bracelvl] = 26;
	math_mode[bracelvl] = 0;
	kar = ' ';   /* to prevent do_it_again */
	return;
      }
      /* case of \|L( ... ; ... ) */
      if (!strcmp("\\RTFformulaL", form_code[bracelvl])) {
	*form_code[bracelvl] = '\0';
	begin_par();
	outchr('{');
	open_brace();
	lvlcode[bracelvl] = 27;
	kar = ' ';   /* to prevent do_it_again */
	return;
      }
      /* case of \|R( ... ; ... ) */
      if (!strcmp("\\RTFformulaR", form_code[bracelvl])) {
	*form_code[bracelvl] = '\0';
	out_math_leave("\\sqrt{");
	open_brace();
	lvlcode[bracelvl] = 23;
	kar = ' ';   /* to prevent do_it_again */
	return;
      }
      /* case of \|X( ... ; ... ) */
      if (strpos2(form_code[bracelvl], "\\RTFformulaX", 1) > 0) {
	*form_code[bracelvl] = '\0';
	begin_par();
	sprintf(STR8, "\\boxed%s{", strsub(STR4, form_code[bracelvl], 11, 3));
	outstg(STR8);
	open_brace();
	lvlcode[bracelvl] = 7;
	kar = ' ';   /* to prevent do_it_again */
	return;
      }
      /* case of \|S( ... ; ... ) */
      if (!strcmp("\\RTFformulaS", form_code[bracelvl]) ||
	  !strcmp("\\RTFformulaSUP", form_code[bracelvl])) {
	*form_code[bracelvl] = '\0';
	out_math_leave("^{");
	open_brace();
	lvlcode[bracelvl] = 18;
	kar = ' ';   /* to prevent do_it_again */
	return;
      }
      /* case of \|SDO( ... ; ... ) */
      if (!strcmp("\\RTFformulaSDO", form_code[bracelvl])) {
	*form_code[bracelvl] = '\0';
	out_math_leave("_{");
	open_brace();
	lvlcode[bracelvl] = 19;
	kar = ' ';   /* to prevent do_it_again */
	return;
      }
      /* case of \|I( ... ; ... ) */
      if (!strcmp("\\RTFformulaI", form_code[bracelvl])) {
	*form_code[bracelvl] = '\0';
	out_math_leave("\\int_{");
	open_brace();
	lvlcode[bracelvl] = 20;
	kar = ' ';   /* to prevent do_it_again */
	return;
      }
      /* case of \|ISU( ... ; ... ) */
      if (!strcmp("\\RTFformulaISU", form_code[bracelvl])) {
	*form_code[bracelvl] = '\0';
	out_math_leave("\\displaystyle\\sum_{");
	open_brace();
	lvlcode[bracelvl] = 20;
	kar = ' ';   /* to prevent do_it_again */
	return;
      }
      /* case of \|IPR( ... ; ... ) */
      if (strcmp("\\RTFformulaIPR", form_code[bracelvl]))
	return;
      *form_code[bracelvl] = '\0';
      out_math_leave("\\displaystyle\\prod_{");
      open_brace();
      lvlcode[bracelvl] = 20;
      kar = ' ';   /* to prevent do_it_again */
      return;
    }
    /* if an opening parenthese is found inside a deep formula, set lvlcode at 25 */
    /*END IF*/
    if (abs(lvlcode[bracelvl]) < 17) {
      begin_par();
      outchr(kar);
      return;
    }
    outchr(kar);
    open_brace();
    lvlcode[bracelvl] = 25;
    return;
  }
  /*END IF form_code */
  if (cat == 4) {   /* this is a closing parenthesis ')' */
    /* test 23 sept */
    while (lvlcode[bracelvl] < 0 && auto_close[bracelvl])
    {   /*END WHILE auto_close*/
      if (math_mode[bracelvl] == 1)
	outchr('$');
      outchr('}');
      close_brace();
    }
    /* fin test 23 sept */
    /* special case of \|B..(...) closing */
    if (lvlcode[bracelvl] == 16) {
      outstg("\\right");
      outstg(close_kar[bracelvl]);
      close_sum();
      return;
    }
    /* special case of \|X..(...) closing */
    if (lvlcode[bracelvl] == 7) {
      outchr('}');
      close_sum();
      return;
    }
    /* closing parenthese found inside a formula, was opened with another ( 25 */
    if (lvlcode[bracelvl] == 25) {
      outchr(kar);
      close_brace();
      return;
    }
    /* closing parenthese found inside a formula \|O */
    if (lvlcode[bracelvl] == 26) {
      close_math();
      outstg("\\hfil}}");
      close_brace();
      return;
    }
    /* closing parenthese found inside a formula \|L */
    if (lvlcode[bracelvl] == 27) {
      outchr('}');
      close_brace();
      return;
    }
    /* closing parenthese found inside a formula \|D */
    if (lvlcode[bracelvl] == 28) {
      outstg("{}");
      close_brace();
      return;
    }
    /* special case of \|F(...) closing */
    /* special case of \|S(...) closing */
    /* special case of \|SDO(...) closing */
    /* special case of \|I(...) closing */
    /* special case of \|I(..;..) closing */
    /* special case of \|I(..;..;..) closing */
    /* special case of \|R(...) closing */
    if (lvlcode[bracelvl] >= 17) {
      close_subs();
      close_sum();
      return;
    }
    /* closing parenthese found inside a deep formula, make it 1 level lower */
    if (-lvlcode[bracelvl] >= 17)
      sprintf(next_rtf, "}){%s", strcpy(STR4, next_rtf));
    else {
      begin_par();
      outchr(kar);
    }
    return;
  }
  /* Ignore chars to be ignored */
  /*END IF lvlcode*/
  if (lvlcode[bracelvl] == 1)
    return;
 
  if (lvlcode[bracelvl] == 3)
    return;
 
  if (lvlcode[bracelvl] == 4)
    return;
 
  if (lvlcode[bracelvl] == 5) {   /* we are in the hexa part of a \RTFpict */
    /* ignore possible blanks and control characters within hexadecimal field */
    if (kar <= 32)   /*END IF*/
      return;
    hexa_digit = hx_to_i(kar);
    pict_char_number++;
    if (pict_left_hexa) {
      /* there is already one hexa digit stored*/
      pict_last_hexa = pict_last_hexa * 16 + hexa_digit;
      pict_byte = pict_last_hexa;
      _SETIO(putc(pict_byte, figurefile) >= 0, FileWriteError);
      pict_byte_number++;
      pict_last_hexa = 0;
      pict_left_hexa = false;
      return;
    }
    /* there is no hexa digit stored*/
    pict_last_hexa = hexa_digit;
    last_kar = kar;
    pict_left_hexa = true;
    return;
  }
  /*END IF pict-left_hexa*/
  if (abs(lvlcode[bracelvl]) == 10)   /* we are in \RTFobject */
    return;
 
  if (abs(lvlcode[bracelvl]) == 9)   /* ignore other than braces */
    return;
 
  if (cat == 11) {   /* this is a letter */
    begin_par();
    if (lvlcode[bracelvl] == 2) {   /* letters to be capitalized ? */
      kar = toupper(kar);
      ikar = kar;
    }
    /*END IF lvlcode=2*/
    if (!strcmp(active_RTFf[bracelvl], "ftech")) {
      strcpy(acc_converted, ftech_transl[ikar]);
      if (*acc_converted != '\0')
	out_math(acc_converted);
      else
	outchr(kar);
      return;
    }
    /*END IF acc_converted*/
    outrem("\\beginparagraph{}");
    if (removed_ok && kout > 0)
      outstg("{}");
    outchr(kar);
    return;
  }
  /*END IF active_RTF*/
  if (!strcmp(active_RTFf[bracelvl], "ftech")) {
    begin_par();
    strcpy(acc_converted, ftech_transl[ikar]);
    if (*acc_converted != '\0')
      out_math(acc_converted);
    else
      special_TeX_chars();
    return;
  }
  /*END IF acc_converted*/
  if (kar == '-') {
    if (last_is("\\beginparagraph{}")) {
      outrem("\\beginparagraph{}");
      outkeyw("plainitem{--}");
    } else
      outchr(kar);
    return;
  }
  /*END IF*/
  if (kar == '"') {
    begin_par();   /*  test march 94 */
    if (math_mode[bracelvl] == 0 && (kout == 0 || last_is(" ")))
      outstg("``");
    else
      outstg("''");
    return;
  }
  /*END IF*/
  if (kar != ';') {
    /*END IF*/
    special_TeX_chars();
    return;
  }
  /* ignore ; in colortbl section */
  if (lvlcode[bracelvl] == 9)
    return;
  /* special case of \|F(. ; .) intermediate semi-colon */
  if (lvlcode[bracelvl] == 17) {
    /* special case of \|S(. ; .) intermediate semi-colon */
    outstg(" \\over\\displaystyle ");
    return;
  }
  if (lvlcode[bracelvl] == 18) {
    close_subs();
    out_math_leave(" _{");
    return;
  }
  /* special case of \|SDO(. ; .) intermediate semi-colon */
  if (lvlcode[bracelvl] == 19) {
    close_subs();
    out_math_leave(" ^{");
    return;
  }
  /* special case of \|I(. ; .) intermediate semi-colon */
  if (lvlcode[bracelvl] == 20) {
    close_subs();
    outstg(" ^{");
    lvlcode[bracelvl] = 21;
    return;
  }
  /* special case of \|su(. ; .) second intermediate semi-colon */
  if (lvlcode[bracelvl] == 21) {
    close_subs();
    outchr('{');
    lvlcode[bracelvl] = 22;
    return;
  }
  /* special case of \|R(. ; .) intermediate semi-colon */
  if (lvlcode[bracelvl] == 23) {
    outsubstitute("\\sqrt{", "\\root{");
    outstg("}\\of{");
    lvlcode[bracelvl] = 24;
    output_line();   /* safety */
    return;
  }
  /* special case of \|O(. ; .) intermediate semi-colon */
  if (lvlcode[bracelvl] == 26) {
    /* special case of \|L(. ; .) intermediate semi-colon */
    outstg("\\hfil\\crcr\\hfil{}");
    return;
  }
  if (lvlcode[bracelvl] == 27)
    outchr(',');
  else
    outchr(kar);
}
 
 
/*---------------------------------------------------------------------------*/
/* treats a character when KEYW is 1 */
/* Keyword being decoded, we are just after the BACKSLASH */
 
Static Void keyw_is_1()
{
  Char STR1[256];
 
  if (cat == 11) {  /* letter : store and say KEYW:=2 */
    sprintf(inkeyw + strlen(inkeyw), "%c", kar);
    keyw = 2;
    return;
  }
  if (cat == 16) {  /* case of a digit : store \RTF */
    outrem_empty_braces();
    outstg(inkeyw);
    outchr(kar);
    keyw = 0;
    return;
  }
  /* turn \{ into \RTFaccol and... try to continue ! */
  if (kar == '{') {
    out_math("\\{");
    keyw = 0;
    /*  inkeyw:=inkeyw+'accol '; keyw:=2 ; */
    return;
  }
  /* turn \} into \RTFlocca and... try to continue ! */
  if (kar == '}') {
    out_math("\\}");
    keyw = 0;
    /* inkeyw:=inkeyw+'locca '; keyw:=2 ; */
    return;
  }
  if (kar == '(') {
    begin_par();
    outkeyw("RTFparen ");
    keyw = 0;
    return;
  }
  if (kar == '-') {
    /* case of a word cutting hyphen \- */
    begin_par();
    sprintf(STR1, "%c", kar);
    outkeyw(STR1);
    keyw = 0;
    return;
  }
  if (kar == '*') {
    if (abs(lvlcode[bracelvl]) < 10 || abs(lvlcode[bracelvl]) > 12) {
      begin_par();
      outchr(kar);
    }
    keyw = 0;   /*END IF*/
    return;
  }
  if (kar == '_') {
    /* case of a word non cutting hyphen \_ */
    begin_par();
    outchr('-');
    keyw = 0;
    return;
  }
  if (kar == '~') {
    /* case of a non breaking space */
    begin_par();
    outchr(kar);
    keyw = 0;
    return;
  }
  if (kar == '\'') {
    keyw = 4;
    num_hexa = 0;
    return;
  }
  if (kar == ':') {
    insert_tilde(kar);
    return;
  }
  if (kar == ';') {
    insert_tilde(kar);
    return;
  }
  if (kar == ')') {
    begin_par();
    outchr(kar);
    return;
  }
  if (kar == '(') {
    begin_par();
    outchr(kar);
    return;
  }
  if (kar == '\\') {
    if (next_rtf[0] == 'f' && lvlcode[bracelvl] == 12) {
      lvlcode[bracelvl] = 9;
      /*END IF*/
      return;
    }
    begin_par();
    outstg("{\\char92}");
    keyw = 0;
    return;
  }
  if (kar == '|') {
    if (next_rtf[0] != '}') {
      /* case of \| (in formulae) store as "formula" and expect letters */
      strcat(inkeyw, "formula");
      keyw = 2;
      return;
    }
    /* if \|} cancel \| and post it for later */
    *inkeyw = '\0';
    keyw = 0;
    strdelete((Anyptr)next_rtf, 1, 1);
    sprintf(next_rtf, "}\\|%s", strcpy(STR1, next_rtf));
    return;
  }
  /* store \RTF and try again */
  outkeyw("RTF{}");
  keyw = 0;
  do_it_again = true;
}
 
 
/*---------------------------------------------------------------------------*/
/* treats a character when KEYW is 2 */
/* We are in a letter keyword */
 
Static Void keyw_is_2()
{
  short poskeyw, k, posbsl, testio;
  string24 inkeywb;
  Char STR1[256], STR2[256];
  Char STR3[232];
  Char STR4[150];
  string24 STR5;
  Char STR6[188];
  Char STR7[28];
  Char STR8[26];
  short FORLIM;
 
  if (cat == 11) {
    /* letter : store and capitalize for formulas */
    if (strpos2(inkeyw, "\\RTFformula", 1) > 0)
      sprintf(inkeyw + strlen(inkeyw), "%c", toupper(kar));
    else
      sprintf(inkeyw + strlen(inkeyw), "%c", kar);
    return;
  }
  /*END IF*/
  if (cat == 16) {
    /* case of a digit : store with opening brace and say KEYW:=3 */
    sprintf(inkeyw + strlen(inkeyw), "{%c", kar);
    numval = kar - icharz;
    numsign = 1;
    keyw = 3;
    return;
  }
  if (kar == '-') {
    /* case of a - introduction : store opening brace and say KEYW:=3 */
    strcat(inkeyw, "{-");
    numval = 0;
    numsign = -1;
    keyw = 3;
    return;
  }
  /* delay \begin(center) to further opening \par */
  if (!strcmp(inkeyw, "\\RTFqc")) {
    if (lvlcode[bracelvl] != 9)
      center_flag[bracelvl] = 1;
  }
  /* delay \begin(flushright) to further opening \par */
  else if (!strcmp(inkeyw, "\\RTFqr")) {
    if (lvlcode[bracelvl] != 9)
      flushright_flag[bracelvl] = 1;
  }
  /* interpret some other keywords */
  else if (!strcmp(inkeyw, "\\RTFtab")) {
    if (par_to_begin)
      num_indent++;
    else
      outkeyw("indent ");
  } else if (!strcmp(inkeyw, "\\RTFchpgn")) {
    begin_par();
    outkeyw("the\\count0{}");
  } else if (!strcmp(inkeyw, "\\RTFb")) {
    add_to_bfsl("\\bf");
    ensure_sizebfsl();
  } else if (!strcmp(inkeyw, "\\RTFscaps")) {
    add_to_bfsl("\\sc");
    ensure_sizebfsl();
  } else if (!strcmp(inkeyw, "\\RTFoutl")) {
    add_to_bfsl("\\oul");
    ensure_sizebfsl();
  } else if (!strcmp(inkeyw, "\\RTFul")) {
    outrem("{");
    if (removed_ok) {
      if (math_mode[bracelvl] == 0) {
	begin_par();
	outkeyw("underbar{");
      } else {
	begin_par();
	outkeyw("underline{");
      }
    } else
      outkeyw("RTFul{}");
    /*END IF removed_OK*/
    underl_flag[bracelvl] = true;
  } else if (!strcmp(inkeyw, "\\RTFuldb")) {
    outrem("{");
    if (removed_ok) {
      if (math_mode[bracelvl] == 0) {
	begin_par();
	outkeyw("underbar{\\bf{}");
      } else {
	begin_par();
	outkeyw("underline{");
      }
    } else
      outkeyw("RTFuldb{}");
    /*END IF removed_OK*/
    underl_flag[bracelvl] = true;
  } else if (!strcmp(inkeyw, "\\RTFv")) {
    outrem("{");
    if (removed_ok) {
      begin_par();
      outkeyw("index{");
    } else
      outkeyw("RTFul{}");
    /*END IF removed_OK*/
    underl_flag[bracelvl] = true;
  } else if (strpos2(inkeyw, "\\RTFheader", 1) + strpos2(inkeyw,
	       "\\RTFfooter", 1) > 0) {
    outrem("{");
    if (removed_ok) {
      sprintf(STR1, "%s{", inkeyw + 1);
      outkeyw(STR1);
    } else {
      sprintf(STR2, "%s{\\relax}", inkeyw + 1);
      outkeyw(STR2);
    }
    /*END IF removed_OK*/
    lvlcode[bracelvl] = 9;
  } else if (!strcmp(inkeyw, "\\RTFi")) {
    if (use_sl)
      add_to_bfsl("\\sl");
    else
      add_to_bfsl("\\it");
    /*END IF*/
    ensure_sizebfsl();
  } else if (!strcmp(inkeyw, "\\RTFpard"))
  {  /* old center_flag[bracelvl]:=0; flushright_flag[bracelvl]:=0; */
    close_math();
    close_envir();
    center_flag[bracelvl] = 0;
    flushright_flag[bracelvl] = 0;
    strcpy(bfslcode[bracelvl], "\\rm");
 
    if (abs(lvlcode[bracelvl]) != 8 && abs(lvlcode[bracelvl]) != 9 &&
	lvlcode[bracelvl] != 13 && lvlcode[bracelvl] != 15)
    {   /*END IF*/
      leftskip = 0;
      rightskip = 0;
      num_indent = 0;
      par_to_begin = true;
      if (!last_is("\\end{tabular}\\par ")) {
	if (kout > 0)
	  output_line();
	outstg(" %\\check ");
	output_line();   /* for testing */
      }
    }
    /* never cut line+\check after \end{tabular} */
    if (lvlcode[bracelvl] == 2)
      lvlcode[bracelvl] = 0;
  } else if (!strcmp(inkeyw, "\\RTFpar")) {
    if (next_rtf[0] == '}') {
      *inkeyw = '\0';
      strdelete((Anyptr)next_rtf, 1, 1);
      sprintf(next_rtf, "}\\par %s", strcpy(STR2, next_rtf));
    } else
      make_RTFpar("\\par ");
  } else if (!strcmp(inkeyw, "\\RTFpagebb")) {
    /*END IF next_rtf[1]*/
    if (next_rtf[0] == '}') {
      *inkeyw = '\0';
      strdelete((Anyptr)next_rtf, 1, 1);
      sprintf(next_rtf, "}\\pagebb %s", strcpy(STR2, next_rtf));
    } else
      make_RTFpar("\\clearpage ");
  } else if (!strcmp(inkeyw, "\\RTFpage")) {
    /*END IF next_rtf[1]*/
    if (next_rtf[0] == '}') {
      *inkeyw = '\0';
      strdelete((Anyptr)next_rtf, 1, 1);
      sprintf(next_rtf, "}\\page %s", strcpy(STR2, next_rtf));
    } else {
      output_size(spacingcode[bracelvl]);
      outkeyw("break\\eject\\noindent ");
      output_size(sizecode[bracelvl]);
      output_bfsl();
    }
  } else if (!strcmp(inkeyw, "\\RTFsect")) {
    /*END IF next_rtf[1]*/
    if (next_rtf[0] == '}') {
      *inkeyw = '\0';
      strdelete((Anyptr)next_rtf, 1, 1);
      sprintf(next_rtf, "}\\par %s", strcpy(STR2, next_rtf));
    } else
      make_RTFpar("\\par  \\relax ");
  } else if (!strcmp(inkeyw, "\\RTFrquote")) {
    /*END IF next_rtf[1]*/
    outchr('\'');
  } else if (!strcmp(inkeyw, "\\RTFlquote"))
    outchr('`');
  else if (!strcmp(inkeyw, "\\RTFmac"))
    mac_init();
  else if (!strcmp(inkeyw, "\\RTFansi"))
    ansi_init();
  else if (!strcmp(inkeyw, "\\RTFline")) {
    /* flag to say future capitalized */
    outkeyw("break ");
  } else if (!strcmp(inkeyw, "\\RTFcaps")) {
    lvlcode[bracelvl] = 2;
    /* flag to say we are in \fonttbl block */
  } else if (!strcmp(inkeyw, "\\RTFfonttbl")) {
    lvlcode[bracelvl] = 6;
    outrem_empty_braces();
    outkrem(sizecode[bracelvl]);
    outrem("{");
    if (removed_ok)
      outkeyw("RTFfonttbl{");
    else
      outkeyw("RTFfonttbl{}{}{}\\relax ");
  } else if (!strcmp(inkeyw, "\\RTFcolortbl")) {
    /*END IF*/
    outrem_empty_braces();
    lvlcode[bracelvl] = 9;
    outkrem(sizecode[bracelvl]);
    outrem("{");
    if (removed_ok)
      outkeyw("RTFcolortbl{");
    else
      outkeyw("RTFcolortbl{}{}{}\\relax ");
  } else if (!strcmp(inkeyw, "\\RTFinfo")) {
    /*END IF*/
    outrem_empty_braces();
    outkrem(sizecode[bracelvl]);
    outrem("{");
    if (removed_ok)
      outkeyw("RTFinfo{");
    else
      outkeyw("RTFinfo{}{}{}\\relax ");
  } else if (!strcmp(inkeyw, "\\RTFstylesheet")) {
    /*END IF*/
    outrem_empty_braces();
    outkrem(sizecode[bracelvl]);
    outrem("{");
    if (removed_ok) {
      outkrem("RTFcolortbl{}");
      outkeyw("RTFstylesheet{");
    } else
      outkeyw("RTFstylesheet{}{}{}\\relax ");
    /*END IF*/
    lvlcode[bracelvl] = 8;
  } else if (!strcmp(inkeyw, "\\RTFfield"))
    lvlcode[bracelvl] = 11;
  else if (strcmp(inkeyw, "\\RTFflddirty")) {
 
    if (strpos2(inkeyw, "\\RTFfldinst", 1) > 0 && lvlcode[bracelvl-1] == 11) {
      lvlcode[bracelvl] = 12;
      return;   /* to avoid resetting keyw:=0 */
    }
    if (!strcmp(inkeyw, "\\RTFtrowd")) {
      perform_RTFtrow();
      outkeyw("begin{tabular}{");
      clbrdrr = false;
      clbrdrl = false;
      clbrdrt = false;
      clbrdrb = false;
      tab_nb_cellx[bracelvl] = 0;
      tab_cellx[bracelvl] = 0;
    } else if (strcmp(inkeyw, "\\RTFbrdrs") || lvlcode[bracelvl] != 13) {
      /* ignore */
      if (!strcmp(inkeyw, "\\RTFclbrdrl") && lvlcode[bracelvl] == 13) {
	outchr('|');
	if (verbose > 1)
	  _SETIO(printf("%s[%d,%d]\n", inkeyw, lvlcode[bracelvl], bracelvl) >=
		 0, FileWriteError);
	clbrdrl = false;
      } else if (!strcmp(inkeyw, "\\RTFclbrdrr") && lvlcode[bracelvl] == 13) {
	if (verbose > 1)
	  _SETIO(printf("%s[%d,%d]\n", inkeyw, lvlcode[bracelvl], bracelvl) >=
		 0, FileWriteError);
	clbrdrr = true;
      } else if (!strcmp(inkeyw, "\\RTFclbrdrt") && lvlcode[bracelvl] == 13) {
	if (verbose > 1)
	  _SETIO(printf("%s[%d,%d]\n", inkeyw, lvlcode[bracelvl], bracelvl) >=
		 0, FileWriteError);
	clbrdrt = true;
      } else if (!strcmp(inkeyw, "\\RTFclbrdrb") && lvlcode[bracelvl] == 13) {
	if (verbose > 1)
	  _SETIO(printf("%s[%d,%d]\n", inkeyw, lvlcode[bracelvl], bracelvl) >=
		 0, FileWriteError);
	clbrdrb = true;
      } else if (!strcmp(inkeyw, "\\RTFintbl")) {
	if (verbose > 0)
	  _SETIO(printf("(found)%s[%d,%d]\n",
			inkeyw, lvlcode[bracelvl],
			bracelvl) >= 0, FileWriteError);
	if (lvlcode[bracelvl] == 13) {
	  if (clbrdrr)
	    outchr('|');
	  clbrdrr = false;
	  outchr('}');
	  lvlcode[bracelvl] = 15;   /* second part of \RTFtrowd */
	  if (clbrdrt) {
	    outkeyw("hline");
	    output_line();
	  }
	  tab_nb_ands[bracelvl] = 0;
	  if (verbose > 1)
	    _SETIO(printf("(after)%s[%d,%d]\n",
			  inkeyw, lvlcode[bracelvl],
			  bracelvl) >= 0, FileWriteError);
	} else if (lvlcode[bracelvl] == 15) {
	  if (verbose > 1)
	    _SETIO(printf("(ignored)%s[%d,%d]\n",
			  inkeyw, lvlcode[bracelvl],
			  bracelvl) >= 0, FileWriteError);
	} else {
	  if (verbose > 0)
	    _SETIO(printf("forcing\\RTFtrowd%s[%d,%d]\n",
			  inkeyw, lvlcode[bracelvl],
			  bracelvl) >= 0, FileWriteError);
	  if (last_is("\\\\\\end{tabular}\\par "))
	    outkrem("end{tabular}\\par ");
	  else if (last_is("\\\\\\hline \\end{tabular}\\par "))
	    outkrem("end{tabular}\\par ");
	  else if (last_is("\\end{tabular}\\par ")) {
	    outkrem("end{tabular}\\par ");
	    outstg("\\\\");
	    if (clbrdrb)
	      outkeyw("hline ");
	  } else
	    outkeyw("begin{tabular}{ppppppppppppppp}");
	  /*END IF last_is(...)*/
	  perform_RTFtrow();
	  lvlcode[bracelvl] = 15;   /* second part of \RTFtrowd */
	  if (verbose > 1) {
	    _SETIO(printf("(<after)%s[%d,%d,%d]\n",
			  inkeyw, lvlcode[bracelvl], tab_nb_cellx[bracelvl],
			  bracelvl) >= 0, FileWriteError);
	    /* force \RTFtrowd if missing */
	    /*END IF verbose*/
	  }
	}
      } else if (!strcmp(inkeyw, "\\RTFrow"))
	perform_RTFrow();
      else if (!strcmp(inkeyw, "\\RTFcell"))
	perform_RTFcell();
      else if (!strcmp(inkeyw, "\\RTFobject")) {
	rtfpicw = 0;
	rtfpich = 0;   /* reset picture width and height to 0 */
	pict_char_number = 0;
	pict_byte_number = 0;
	pict_last_hexa = 0;   /* reset last hexa byte of the picture */
	pict_left_hexa = false;
	pict_number++;   /* count picture number */
	sign_str(pict_number, pict_name);
	sprintf(figure_name, "%s%s%s", figure_path, pict_name, figure_type);
	while (strpos2(figure_name, "\\", 1) > 0) {   /*END DO*/
	  posbsl = strpos2(figure_name, "\\", 1);
	  figure_name[posbsl-1] = '/';
	}
	begin_par();
	sprintf(STR3, "%s{%s}", strsub(STR1, inkeyw, 2, 99), figure_name);
	outkeyw(STR3);
	sprintf(figure_name, "%s%s%s", figure_path, pict_name, figure_type);
	output_line();
	sprintf(STR4, "Skipped object file %s", figure_name);
	println_msg(1, STR4);
	lvlcode[bracelvl] = 10;
      } else if (!strcmp(inkeyw, "\\RTFpict")) {
	rtfpicw = 0;
	rtfpich = 0;   /* reset picture width and height to 0 */
	pict_char_number = 0;
	pict_byte_number = 0;
	pict_last_hexa = 0;   /* reset last hexa byte of the picture */
	pict_left_hexa = false;
	pict_number++;   /* count picture number */
	sign_str(pict_number, pict_name);
	sprintf(figure_name, "%s%s%s", figure_path, pict_name, figure_type);
	while (strpos2(figure_name, "\\", 1) > 0) {   /*END DO*/
	  posbsl = strpos2(figure_name, "\\", 1);
	  figure_name[posbsl-1] = '/';
	}
	begin_par();
	sprintf(STR3, "%s{%s}", strsub(STR1, inkeyw, 2, 99), figure_name);
	outkeyw(STR3);
	sprintf(figure_name, "%s%s%s", figure_path, pict_name, figure_type);
	output_line();
	strcpy(figurefile_NAME, figure_name);
	if (figurefile != NULL)
	  figurefile = freopen(figurefile_NAME, "w", figurefile);
	else
	  figurefile = fopen(figurefile_NAME, "w");
	_SETIO(figurefile != NULL, FileNotFound);
	testio = P_ioresult;
	if (testio != 0) {   /*ENF IF testio*/
	  sign_str(testio, works);
	  sprintf(STR6, "Unable to open figure file %s ; code=%s",
		  figure_name, works);
	  println_msg(0, STR6);
	  close_files();
	  _Escape(0);
	}
	sprintf(STR4, "Opened picture file %s", figure_name);
	println_msg(1, STR4);
	lvlcode[bracelvl] = 5;
      } else if (!strcmp(inkeyw, "\\RTFfootnote")) {
	if (math_mode[bracelvl] == 0) {
	  lvlcode[bracelvl] = 3;
	  outrem("{");
	  if (removed_ok)
	    outkeyw("footnote{");
	  else
	    outkeyw("footnote ");
	} else if (math_mode[bracelvl] == 1) {
	  /*END IF removed*/
	  close_math();
	  sprintf(next_rtf, "\\footnote %s", strcpy(STR1, next_rtf));
	} else if (math_mode[bracelvl-1] == 1)
	  sprintf(next_rtf, "}{\\footnote %s", strcpy(STR1, next_rtf));
	else if (bracelvl >= 2 && math_mode[bracelvl-2] == 1)
	  sprintf(next_rtf, "}}{{\\footnote %s", strcpy(STR1, next_rtf));
	else if (bracelvl >= 3 && math_mode[bracelvl-3] == 1)
	  sprintf(next_rtf, "}}}{{{\\footnote %s", strcpy(STR1, next_rtf));
	else
	  outkeyw("footnote ");
      } else if (!strcmp(inkeyw, "\\RTFplain")) {
	/*END IF math_mode*/
	outpsize(stdsize * 20);
	strcpy(bfslcode[bracelvl], "\\rm");
	strcpy(sizecode[bracelvl], "normalsize");
      } else if (!strcmp(inkeyw, "\\RTFchftn"))
	remove_mathat();
      else if (!strcmp(inkeyw, "\\RTFendash")) {
	if (math_mode[bracelvl] > 0)
	  outchr('-');
	else
	  outstg("--");
      } else if (!strcmp(inkeyw, "\\RTFemdash")) {
	if (math_mode[bracelvl] > 0)
	  outchr('-');
	else
	  outstg("---");
      } else if (!strcmp(inkeyw, "\\RTFfnil"))
	    /* decl_font_num is a global variable */
	      store_word_font("fnil");
      else if (!strcmp(inkeyw, "\\RTFfroman"))
	store_word_font("froman");
      else if (!strcmp(inkeyw, "\\RTFfmodern"))
	store_word_font("fmodern");
      else if (!strcmp(inkeyw, "\\RTFfdecor"))
	store_word_font("fdecor");
      else if (!strcmp(inkeyw, "\\RTFfswiss"))
	store_word_font("fswiss");
      else if (!strcmp(inkeyw, "\\RTFfscript"))
	store_word_font("fscript");
      else if (!strcmp(inkeyw, "\\RTFftech"))
	store_word_font("ftech");
      else if (!strcmp(inkeyw, "\\RTFformulaB"))
	truncate24(form_code[bracelvl], inkeyw);
      else if (!strcmp(inkeyw, "\\RTFformulaO"))
	truncate24(form_code[bracelvl], inkeyw);
      else if (!strcmp(inkeyw, "\\RTFformulaLC")) {
	sprintf(STR7, "%sLC", form_code[bracelvl]);
	strcpy(form_code[bracelvl], truncate24(STR5, STR7));
      } else if (!strcmp(inkeyw, "\\RTFformulaRC")) {
	sprintf(STR7, "%sRC", form_code[bracelvl]);
	strcpy(form_code[bracelvl], truncate24(STR5, STR7));
      } else if (!strcmp(inkeyw, "\\RTFformulaBC")) {
	sprintf(STR7, "%sBC", form_code[bracelvl]);
	strcpy(form_code[bracelvl], truncate24(STR5, STR7));
      } else if (!strcmp(inkeyw, "\\RTFformulaF"))
	truncate24(form_code[bracelvl], inkeyw);
      else if (!strcmp(inkeyw, "\\RTFformulaR"))
	truncate24(form_code[bracelvl], inkeyw);
      else if (!strcmp(inkeyw, "\\RTFformulaS"))
	truncate24(form_code[bracelvl], inkeyw);
      else if (!strcmp(inkeyw, "\\RTFformulaD"))
	truncate24(form_code[bracelvl], inkeyw);
      else if (!strcmp(inkeyw, "\\RTFformulaX"))
	truncate24(form_code[bracelvl], inkeyw);
      else if (!strcmp(inkeyw, "\\RTFformulaI"))
	truncate24(form_code[bracelvl], inkeyw);
      else if (!strcmp(inkeyw, "\\RTFformulaSU")) {
	sprintf(STR7, "%sSU", form_code[bracelvl]);
	strcpy(form_code[bracelvl], truncate24(STR5, STR7));
      } else if (!strcmp(inkeyw, "\\RTFformulaPR")) {
	sprintf(STR7, "%sPR", form_code[bracelvl]);
	strcpy(form_code[bracelvl], truncate24(STR5, STR7));
      } else if (!strcmp(inkeyw, "\\RTFformulaIN")) {
	sprintf(STR7, "%sIN", form_code[bracelvl]);
	strcpy(form_code[bracelvl], truncate24(STR5, STR7));
      } else if (!strcmp(inkeyw, "\\RTFformulaRI")) {
	sprintf(STR7, "%sRI", form_code[bracelvl]);
	strcpy(form_code[bracelvl], truncate24(STR5, STR7));
      } else if (!strcmp(inkeyw, "\\RTFformulaBO")) {
	sprintf(STR7, "%sBO", form_code[bracelvl]);
	strcpy(form_code[bracelvl], truncate24(STR5, STR7));
      } else if (!strcmp(inkeyw, "\\RTFformulaLE")) {
	sprintf(STR7, "%sLE", form_code[bracelvl]);
	strcpy(form_code[bracelvl], truncate24(STR5, STR7));
      } else if (!strcmp(inkeyw, "\\RTFformulaTO")) {
	sprintf(STR7, "%sTO", form_code[bracelvl]);
	strcpy(form_code[bracelvl], truncate24(STR5, STR7));
	/* case of \|<non-alpha> */
      } else if (!strcmp(inkeyw, "\\RTFformula")) {
	if (cat == 0 && next_rtf[0] == '{') {
	  sprintf(STR8, "%s{", form_code[bracelvl]);
	  strcpy(form_code[bracelvl], truncate24(STR5, STR8));
	  kar = ' ';
	  next_rtf[0] = '\0';   /* to prevent do_it_again */
	} else if (cat == 0 && next_rtf[0] == '}') {
	  sprintf(STR8, "%s}", form_code[bracelvl]);
	  strcpy(form_code[bracelvl], truncate24(STR5, STR8));
	  kar = ' ';
	  next_rtf[0] = '\0';   /* to prevent do_it_again */
	} else {
	  sprintf(STR8, "%s%c", form_code[bracelvl], kar);
	  strcpy(form_code[bracelvl], truncate24(STR5, STR8));
	  kar = ' ';   /* to prevent do_it_again */
	}
      }
      /* case of \{ */
      else if (!strcmp(inkeyw, "\\RTFaccol ")) {
	/*END IF*/
	/* case of \} */
	out_math("\\{");
      } else if (!strcmp(inkeyw, "\\RTFlocca "))
	out_math("\\}");
      else {
	poskeyw = 0;
	sprintf(STR1, "%s ", inkeyw);
	truncate24(inkeywb, STR1);
	FORLIM = num_skip_strings;
	/* check whether this keyword should be skipped in output */
	for (k = 0; k <= FORLIM - 1; k++)   /*END DO*/
	  poskeyw += strpos2(skip_strings[k], inkeyw, 1);
	/* output other keywords with an additional space */
	if (poskeyw == 0) {   /*END IF poskeyw*/
	  outrem_empty_braces();
	  outstg(inkeyw);
	  /* do not put a space if following is a (, for TeX macros syntax */
	  if (kar != '(')
	    outchr(' ');
	}
      }
    }
  }
  /*END IF*/
  /* reset KEYW and try again */
  keyw = 0;
  if (kar != ' ') {
    do_it_again = true;
    /*END IF cat=11*/
  }
}
 
 
/*---------------------------------------------------------------------------*/
/* treats a character when KEYW is 3 */
/* Numeric arg of Keyword being decoded */
 
Static Void keyw_is_3()
{
  string24 sizeheader;   /* will be 'large', 'Large', 'footnotesize'... */
  short magnification;   /* will be 1000, 1095, 900... */
  short diff_cellx, style_ref, poskeyw, k;
  string24 acc_converted, inkeywb;
  string_RTFstyle test_RTFstyle;
  Char STR1[64];
  Char STR2[186];
  Char STR3[58];
  Char STR4[256];
  short FORLIM;
  string24 STR5;
  Char STR6[26];
  Char STR7[28];
 
  if (cat == 16) {
    /* case of a digit */
    sprintf(inkeyw + strlen(inkeyw), "%c", kar);
    numval = numval * 10 + numsign * (kar - icharz);
    return;
  }
  /* case of a non digit: terminate but ignore some keywords with brace pairs */
  if (strpos2(inkeyw, "RTFsl{", 1) > 0) {
    outpsize(numval);
    sign_str(numval, works);
    sprintf(STR1, "\\RTFsl{%s} -->  \\%s", works, spacingcode[bracelvl]);
    println_msg(2, STR1);
  } else if (strpos2(inkeyw, "RTFli{", 1) > 0 && center_flag[bracelvl] < 2) {
    if (lvlcode[bracelvl] != 8)   /*END IF*/
      leftskip = numval;
  } else if (strpos2(inkeyw, "RTFri{", 1) > 0 && center_flag[bracelvl] < 2) {
    if (lvlcode[bracelvl] != 8)   /*END IF*/
      rightskip = numval;
  } else if (strpos2(inkeyw, "RTFf{", 1) > 0) {
    decl_font_num = numval;   /* store numval for further use */
    set_active_RTFf(numval);
    outstg("{}");
  }
  /* use _ and ^ for sub/superscripts and put in math mode if needed */
  else if (strpos2(inkeyw, "RTFup{", 1) > 0) {
    out_math_leave("\\relax^{");
    open_brace();
    auto_close[bracelvl] = true;
  } else if (strpos2(inkeyw, "RTFdn{", 1) > 0) {
    out_math_leave("\\relax_{");
    open_brace();
    auto_close[bracelvl] = true;
  }
  /* ignore \RTFfi if option '-v' */
  else if (strpos2(inkeyw, "RTFfi{", 1) > 0) {
    num_indent = 1;
    if (!(no_space_conv && numval > 0)) {
      outkeyw("parindent=");
      output_num(numval);
      outkeyw("RTFtwips");
      output_line();
    }
  }
  /* style description */
  else if (strpos2(inkeyw, "RTFs{", 1) > 0) {
    sign_str(numval, works);
    if (abs(lvlcode[bracelvl]) == 8) {
      if (num_styles >= maxRTFstyles) {
	sprintf(STR3, "Too many styles, style %s ignored.", works);
	println_msg(0, STR3);
      } else if (numval > 255) {
	sprintf(STR1, "Illegal style number, style %s ignored.", works);
	println_msg(0, STR1);
      } else {
	num_styles++;
	ref_styles[numval] = num_styles;
	sprintf(test_RTFstyle, "%c", kar);
	while (kar != ';' && kar != '}') {   /*END while*/
	  read_char();
	  sprintf(test_RTFstyle + strlen(test_RTFstyle), "%c", kar);
	}
	/* clean style to the first blank after \snext */
	if (kar == ';')
	  kar = ' ';
	k = strpos2(test_RTFstyle, "\\snext", 1);
	m = strlen(test_RTFstyle);
	FORLIM = strlen(test_RTFstyle);
	for (l = k; l <= FORLIM; l++) {
	  if (test_RTFstyle[l-1] == ' ' && l < m)
	    m = l;
	}
	sign_str(num_styles, worksa);
	/* start at the first space in style text */
	n = strpos2(test_RTFstyle, " ", 1) + 1;
	strsub(RTFstyles[num_styles-1], test_RTFstyle, n, m - n + 1);
	sprintf(STR2, "%s --> %s \"%s\"",
		works, worksa, RTFstyles[num_styles-1]);
	println_msg(2, STR2);
      }
    } else {
      /*END IF*/
      style_ref = ref_styles[numval];
      if (style_ref <= 0 || style_ref > 255) {
	sprintf(STR1, "Illegal style number, style %s ignored.", works);
	println_msg(0, STR1);
      } else {
	if (kar != ' ')
	  sprintf(next_rtf, "%c%s", kar, strcpy(STR4, next_rtf));
	kar = ' ';
	sprintf(next_rtf, "%s%s",
		RTFstyles[style_ref-1], strcpy(STR4, next_rtf));
	/*END IF*/
      }
    }
  }
  /* font size description */
  else if (strpos2(inkeyw, "RTFfs{", 1) + strpos2(inkeyw, "RTFfldinstfs{", 1) > 0 &&
	   lvlcode[bracelvl] != 8) {
    /*END IF*/
    /* before putting \LARGE, \Huge etc., remove previous \bf, \rm, etc. */
    outrem_empty_braces();
    outrem(bfslcode[bracelvl]);
 
    /* output \large, \normalsize, \footnotesize according to NUMVAL */
    outfsize(numval, &magnification);
 
    sprintf(STR6, "\\%s", sizecode[bracelvl]);
    truncate24(sizeheader, STR6);
    if (!strcmp(sizeheader, "\\footnotesize"))
      strcpy(sizeheader, "\\footnsize");
 
    /* correct font names in bfslcode[bracelvl] according to latex209  or latex2e */
    font_clean(sizeheader, magnification);
 
    if (!par_to_begin) {   /*END IF*/
      output_size(sizecode[bracelvl]);
      output_bfsl();
      if (!last_is("}")) {
	if (!last_is("{"))
	  outstg("{}");
      }
    }
  } else if (strpos2(inkeyw, "RTFsb{", 1) > 0) {
    /*END IF*/
    outkrem("par");
    outkrem("par ");
    if (lvlcode[bracelvl] != 8 && lvlcode[bracelvl] != 9)
      outkeyw("par ");
    make_RTFsab(numval);
  } else if (strpos2(inkeyw, "RTFsa{", 1) > 0)
    save_skip = numval;
  else if (strpos2(inkeyw, "RTFtrleft{", 1) <= 0) {   /* en attente */
    if (strpos2(inkeyw, "\\RTFcellx{", 1) > 0 && lvlcode[bracelvl] == 13) {
      /* \RTCcellx gives absolutes abscissae, but tabular's p{} needs differences */
      diff_cellx = numval - tab_cellx[bracelvl];
      outstg("p{");
      output_num(diff_cellx);
      outstg("\\RTFtwips}");
      if (clbrdrl)
	outchr('|');
      clbrdrl = false;
      tab_nb_cellx[bracelvl]++;
      tab_cellx[bracelvl] = numval;
    } else if (strpos2(inkeyw, "RTFpicw{", 1) > 0) {
      strcat(inkeyw, "}");
      outrem_empty_braces();
      outstg(inkeyw);
      rtfpicw = numval;
    } else if (strpos2(inkeyw, "RTFpich{", 1) > 0) {
      strcat(inkeyw, "}");
      outrem_empty_braces();
      outstg(inkeyw);
      rtfpich = numval;
    } else if (strpos2(inkeyw, "RTFobjw{", 1) > 0) {
      strcat(inkeyw, "}");
      outrem_empty_braces();
      outstg(inkeyw);
      rtfpicw = numval;
    } else if (strpos2(inkeyw, "RTFobjh{", 1) > 0) {
      strcat(inkeyw, "}");
      outrem_empty_braces();
      outstg(inkeyw);
      rtfpich = numval;
    }
    /* case of \|DO( ... ) */
    else if (strpos2(inkeyw, "\\RTFformulaDO{", 1) > 0) {
      if (*form_code[bracelvl] == '\0')
	strcpy(form_code[bracelvl], "\\RTFformulaSDO");
      else {
	sprintf(STR7, "%sDO", form_code[bracelvl]);
	strcpy(form_code[bracelvl], truncate24(STR5, STR7));
	/* case of \|UP( ... ) */
      }
    } else if (strpos2(inkeyw, "\\RTFformulaUP{", 1) > 0) {
      if (*form_code[bracelvl] == '\0')
	strcpy(form_code[bracelvl], "\\RTFformulaSUP");
      else {
	sprintf(STR7, "%sUP", form_code[bracelvl]);
	strcpy(form_code[bracelvl], truncate24(STR5, STR7));
	/* case of \|FO( ... ) */
      }
    } else if (strpos2(inkeyw, "\\RTFformulaFO{", 1) > 0) {
      if (*form_code[bracelvl] == '\0')
	strcpy(form_code[bracelvl], "\\RTFformulaDFO");
      else {
	sprintf(STR7, "%sFO", form_code[bracelvl]);
	strcpy(form_code[bracelvl], truncate24(STR5, STR7));
      }
      displ_skip = numval;
    }
    /* case of \|UP( ... ) */
    else if (strpos2(inkeyw, "\\RTFformulaBA{", 1) > 0) {
      if (*form_code[bracelvl] == '\0')
	strcpy(form_code[bracelvl], "\\RTFformulaDFO");
      else {
	sprintf(STR7, "%sFO", form_code[bracelvl]);
	strcpy(form_code[bracelvl], truncate24(STR5, STR7));
      }
      displ_skip = -numval;
    }
    /* case of \|UP( ... ) */
    else if (strpos2(inkeyw, "\\RTFformulaLI{", 1) > 0) {
      if (*form_code[bracelvl] == '\0')
	strcpy(form_code[bracelvl], "\\RTFformulaDLI");
      else {
	sprintf(STR7, "%sLI", form_code[bracelvl]);
	strcpy(form_code[bracelvl], truncate24(STR5, STR7));
      }
      displ_skip = numval;
    }
    /* case of \|AI( ... ) */
    else if (strpos2(inkeyw, "\\RTFformulaAI{", 1) <= 0) {
      /* case of \|DI( ... ) */
      if (strpos2(inkeyw, "\\RTFformulaDI{", 1) <= 0) {
	if (strpos2(inkeyw, "RTFrtf{", 1) > 0) {
	  no_RTFrtf = false;
	  strcat(inkeyw, "}");
	  outrem_empty_braces();
	  outstg(inkeyw);
	}
	/* explicit references to symbol characters */
	else if (strpos2(inkeyw, "RTFfldinstsymbol", 1) + strpos2(inkeyw,
		   "RTFfldinstbsymbol",
		   1) + strpos2(inkeyw, "RTFfldinstbisymbol", 1) > 0) {
	  if (numval > 255)
	    numval = 0;
	  strcpy(acc_converted, ftech_transl[numval]);
	  if (*acc_converted != '\0')
	    out_math(acc_converted);
	  else
	    outchr('?');
	} else {
	  /*END IF acc_converted*/
	  poskeyw = 0;
	  k = strpos2(inkeyw, "{", 1);
	  if (k > 0) {
	    sprintf(inkeywb, "%.*s", k, inkeyw);
/* p2c: rtflatex.pas, line 1513:
 * Note: Possible faulty string assignment [145] */
/* p2c: rtflatex.pas, line 1513:
 * Note: string[24] := string[255] => unpredictable crashes */
	  } else {
	    sprintf(STR4, "%s}", inkeyw);
	    truncate24(inkeywb, STR4);
	  }
	  FORLIM = num_skip_strings;
	  /* check whether this keyword should be skipped in output */
	  for (k = 0; k <= FORLIM - 1; k++)   /*END DO*/
	    poskeyw += strpos2(skip_strings[k], inkeywb, 1);
	  if (poskeyw == 0) {   /*END IF poskeyw*/
	    strcat(inkeyw, "}");
	    outrem_empty_braces();
	    outstg(inkeyw);
	  }
	}
      }
      /* this test is eliminate first brace opened */
    }
  }
  /*END IF*/
  keyw = 0;
  if (kar != ' ') {
    do_it_again = true;
    /*END IF*/
  }
}
 
 
/*---------------------------------------------------------------------------*/
/* treats a character when KEYW is 4 */
/* Hexadecimal arg of RTFac */
 
Static Void keyw_is_4()
{
  string2 acchexa;
  string24 acc_converted;
  short posbrace;
  Char STR1[256];
  Char STR2[12];
  Char STR3[40];
 
  if (cat == 10)
    return;
 
  if (num_hexa == 0) {
    num_hexa = 1;
    hexaone = kar;
    return;
  }
  if (num_hexa != 1) {
    sign_str(num_hexa, works);
    sprintf(STR3, "Wrong num_hexa:%s", works);
    println_msg(0, STR3);
    /*END IF*/
 
    return;
  }
  hexatwo = kar;
  sprintf(acchexa, "%c%c", hexaone, hexatwo);
/* p2c: rtflatex.pas, line 1546:
 * Note: Possible faulty string assignment [145] */
/* p2c: rtflatex.pas, line 1546:
 * Note: string[2] := string[3] => unpredictable crashes */
  begin_par();
  if (!strcmp(active_RTFf[bracelvl], "ftech")) {
    strcpy(acc_converted, ftech_transl[hs_to_i(acchexa)]);
    if (*acc_converted != '\0')
      out_math(acc_converted);
    else {
      sprintf(STR2, "RTFac{%s}", acchexa);
      outkeyw(STR2);
    }
  } else {
    /*END IF acc_converted*/
    strcpy(acc_converted, acc_transl[hs_to_i(acchexa)]);
    if (*acc_converted != '\0') {
      if (acc_converted[0] == '\\')
	outrem_empty_braces();
      posbrace = strpos2(acc_converted, "{", 1);
      if (acc_converted[0] == '$') {
	outrem_empty_braces();
	out_math(strcpy(STR1, acc_converted + 1));
      } else if (posbrace <= 1)
	outstgc(acc_converted);
      else if (strpos2(acc_converted, "\\c{", 1) + strpos2(acc_converted,
		 "\\dag{",
		 1) + strpos2(acc_converted, "\\pound{", 1) + strpos2(
		 acc_converted, "\\copyright{",
		 1) + strpos2(acc_converted, "\\degree{", 1) > 0) {
	sprintf(STR1, "%.*s", posbrace - 1, acc_converted);
	outstg(STR1);
	outstgc(strcpy(STR1, acc_converted + posbrace - 1));
      } else
	outstgc(acc_converted);
    } else {
      /*END IF*/
      outkeyw("RTFac{");
      outstg(acchexa);
      outchr('}');
      /*END IF acc_converted*/
    }
  }
  /*END IF active_RTF*/
  num_hexa = 0;
  keyw = 0;
}
 
 
/*---------------------------------------------------------------------------*/
Static Void make_latex_header()
{
  short i;
  string24 strpts;
  Char STR1[28];
  Char STR2[26];
  short FORLIM;
  Char STR3[30];
 
  if (latex209)
    outkeyw("documentstyle[");
  else
    outkeyw("documentclass[");
  /*END IF*/
  if (stdsize != 10) {   /*END IF*/
    sign_str(stdsize, strpts);
    sprintf(STR1, "%spt,", strpts);
    outstg(STR1);
  }
  outstg("twoside");
 
  if (latex209) {
    FORLIM = num_latex_options;
    for (i = 0; i <= FORLIM; i++) {
      sprintf(STR2, ",%s", latex_options[i]);
      outstg(STR2);
    }
    sprintf(STR3, "]{%s}", latex_style);
    outstg(STR3);
    output_line();
  } else {
    sprintf(STR3, "]{%s}", latex_style);
    outstg(STR3);
    output_line();
    outkeyw("usepackage{");
    outstg(latex_options[0]);
    FORLIM = num_latex_options;
    for (i = 1; i <= FORLIM; i++) {
      sprintf(STR2, ",%s", latex_options[i]);
      outstg(STR2);
    }
    outstg("}");
    output_line();
  }
 
 
 
  outkeyw("begin{document}\\RTFsetfontheading");
  output_line();
}
 
 
/*---------------------------------------------------------------------------*/
/*                               MAIN                                        */
/*---------------------------------------------------------------------------*/
main(argc, argv)
int argc;
Char *argv[];
{
  short FORLIM;
  Char STR1[48];
  Char STR2[56];
  Char STR3[50];
  Char STR4[30];
  Char STR5[64];
 
  PASCAL_MAIN(argc, argv);
  skipfile = NULL;
  logfile = NULL;
  figurefile = NULL;
  outputfile = NULL;
  inputfile = NULL;
  clean_all();   /* for safety... */
 
  latex209 = false;
  write_log = false;
  use_sl = false;
  latex_header = true;
  simplify_ok = true;
  no_RTFrtf = true;
  base_flag = false;
  no_space_conv = false;
  last_percent = false;
  num_latex_options = 0;
  strcpy(latex_style, "report");
  strcpy(latex_options[0], "rtflatex");
  kar = '\0';
  save_skip = 0;
  space_after = 0;
  math_mode[0] = 0;
  auto_close[0] = false;
  bracelvl = 0;
  input_line_number = 1;
  /* envir_closed_ok:=FALSE; (test) */
  envir_closed_ok = true;
  num_styles = 0;
  displ_skip = 0;
  for (k = 0; k <= 255; k++)
    ref_styles[k] = 0;
 
  verbose = 1;   /* default moderate verbosity */
  tex_verbose = 0;   /* no insertion of flags within TeX output */
 
  title();
  charinit();
  sizeinit();
  open_files();
 
  /* "lvlcode" : say what to do of the contents of that block. 1=ignore
until end of  current block, 2=caps, 3=ignore footnote headings, 4=
ignore contents of first arg of \footnote, 5= \RTFpict text, 6= \fonttbl
declaration, 7= \RTFformulaX[xx], 8= within \stylesheet, 9= within
\header/\footer, 9= within \RTFcolortbl, 10= \RTFobject text, 11=
\RTFfield text, 12= inside \RTFfldinst, 13= inside \RTFtrowd/\RTFrow,
15= inside \RTFtrowd/RTFrow after \RTFintbl, 16=
within \RTFformulaB(...), 17= within \RTFformulaF(...), 18=
\RTFformulaSUP(...), 19= \RTFformulaSDO(...), 20= \RTFformulaI, 21= idem
after ";", 22= idem after second ";", 23= \RTFformulaR, 24= \RTFformulaR
after ";", 25= ordinary brace within a formula, 26=\RTFformulaO,
27=\RTFformulaL, 28=\RTFformulaD */
  lvlcode[0] = 0;
 
  /* bfslcode stores the recorded \bf, \sl, \it, \sf commands
   to repeat them AFTER \large, \Large */
  *bfslcode[0] = '\0';
  strcpy(sizecode[0], "normalsize");
  *active_RTFf[0] = '\0';
  strcpy(close_kar[0], " ");
  *form_code[0] = '\0';
  strcpy(spacingcode[0], "relax");
  *currsize[0] = '\0';
  *currbfsl[0] = '\0';
  leftskip = 0;
  rightskip = 0;
  leftcurskip = 0;
  rightcurskip = 0;
  tab_nb_cellx[0] = 0;
      /* the number of cells in a tabular line = #\RTFcellx */
  tab_nb_ands[0] = 0;   /* the number of &, must be < #\RTFcellx */
  tab_cellx[0] = 0;   /* current \RTFcellx value */
  clbrdrr = false;
  clbrdrl = false;
  clbrdrt = false;
  clbrdrb = false;
 
  *inkeyw = '\0';
  numl = 0;
  numval = 0;
  numsign = 1;
  num_hexa = 0;
  ikar = 0;
  kinp = 0;
  prev_kinp = 0;
  *next_rtf = '\0';
  num_indent = 0;
  num_word_fonts = 0;   /* number of RTF/Word defined fonts */
  numfonts = 0;   /* number of specially defined fonts */
  keyw = 0;   /* a flag to say whether we are decoding a keyword */
  pict_number = 0;   /* counts the pictures */
 
  center_flag[0] = 0;
  flushright_flag[0] = 0;
  do_it_again = false;
  underl_flag[0] = false;
  par_to_begin = true;
 
  cleanout();   /* clean EXFILE for safety */
 
  if (latex_header)
    make_latex_header();
 
  /* main loop to read input RTF file */
 
  read_next_char();
  while (ikar != 26) {
    /* read one character unless said to be retried */
    if (do_it_again)
      do_it_again = false;
    else
      read_char();
    /*END IF*/
    if (ikar < ' ')   /*END IF ikar*/
      continue;
 
    switch (keyw) {
 
    case 0:
      keyw_is_0();
      break;
 
    case 1:
      keyw_is_1();
      break;
 
    case 2:
      keyw_is_2();
      break;
 
    case 3:
      keyw_is_3();
      break;
 
    case 4:
      keyw_is_4();
      break;
    }/* case KEYW */
  }
  if (center_flag[bracelvl] > 0)
    outkeyw("end{center}");
  if (latex_header)
    outkeyw("end{document}");
  else
    outkeyw("bye");
  /*END IF latex_header*/
  output_line();
 
  println_msg(0, "RTFLaTeX terminated");
  sign_str(bracelvl, works);
  sprintf(STR1, "brace level finally is:%s", works);
  println_msg(0, STR1);
  sign_str(numl, works);
  if (numl > 0) {
    sprintf(STR2, "%s lines of code were generated.", works);
    println_msg(0, STR2);
  }
  sign_str(numfonts, works);
  if (numfonts > 0) {
    sprintf(STR3, "%s new fonts were declared:", works);
    println_msg(0, STR3);
  }
  FORLIM = numfonts;
  for (k = 1; k <= FORLIM; k++) {
    sprintf(STR4, "    %s", newfonts[k-1]);
    println_msg(0, STR4);
  }
  sign_str(pict_number, works);
  if (pict_number > 0) {
    sprintf(STR5, "%s pictures were stored in binary files.", works);
    println_msg(0, STR5);
  }
  close_files();
  if (inputfile != NULL)
    fclose(inputfile);
  if (outputfile != NULL)
    fclose(outputfile);
  if (figurefile != NULL)
    fclose(figurefile);
  if (logfile != NULL)
    fclose(logfile);
  if (skipfile != NULL)
    fclose(skipfile);
  exit(EXIT_SUCCESS);
}
 
 
 
 
 
/* End. */
/* end of file */
