unit GraphicsDlg;

interface

uses Windows, SysUtils, Classes, Graphics, Forms, Controls, StdCtrls,
  Buttons, ExtCtrls, Dialogs, IniFiles;

const
  LF: string = #13#10;

type
  TGraphicsDialog = class(TForm)
    OKBtn: TButton;
    CancelBtn: TButton;
    Label8: TLabel;
    EditFileName: TEdit;
    Button1: TButton;
    OpenDialog1: TOpenDialog;
    Label2: TLabel;
    EditxImage: TEdit;
    Label3: TLabel;
    EdityImage: TEdit;
    Label6: TLabel;
    EditTitle: TEdit;
    Label1: TLabel;
    posComboBox: TComboBox;
    HelpButton: TButton;
    procedure OKBtnClick(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure HelpButtonClick(Sender: TObject);
  private
    { Private declarations }
  public
    strGraphics: string;
    { Public declarations }
  end;

var
  GraphicsDialog: TGraphicsDialog;

implementation

uses Frame;

{$R *.DFM}

procedure TGraphicsDialog.OKBtnClick(Sender: TObject);
var strTitle: string;
    strPosition: string;
begin
  if EditTitle.Text <> '' then
  begin
    strTitle := '\caption{' + EditTitle.Text + '}' + LF;
  end;

  if posComboBox.Text <> '' then
  begin
    if posComboBox.Text = 'here' then
      strPosition := '[' + 'h!t' + ']'
    else if posComboBox.Text = 'top' then
      strPosition := '[' + 't' + ']'
    else if posComboBox.Text = 'bottom' then
      strPosition := '[' + 'b' + ']'
    else if posComboBox.Text = 'own page' then
      strPosition := '[' + 'p' + ']'
    else
      strPosition := '';
  end;

  strGraphics := '\begin{figure}' + strPosition + LF
               + '\center{'
               + '\includegraphics*'
               + '[' + EditxImage.Text + ', ' + EdityImage.Text + ']'
               + '{' + EditFileName.Text
               + '}}' + LF
               + strTitle
               + '\end{figure}' + LF;
end;

procedure TGraphicsDialog.Button1Click(Sender: TObject);
begin
if OpenDialog1.Execute then
  EditFileName.Text := ExtractFileName (OpenDialog1.FileName);
end;

procedure TGraphicsDialog.FormCreate(Sender: TObject);
var iniFile: TIniFile;
begin
  iniFile := TIniFile.Create (FrameForm.iniFileName);
  posComboBox.Text := iniFile.ReadString ('GraphicsDialog', 'Position', 'default');
  EditxImage.Text := iniFile.ReadString ('GraphicsDialog', 'xImageSize', '6cm');
  EdityImage.Text := iniFile.ReadString ('GraphicsDialog', 'yImageSize', '6cm');
  iniFile.Free;
end;

procedure TGraphicsDialog.FormDestroy(Sender: TObject);
var iniFile: TIniFile;
begin
  if FrameForm.lockIniFile = false then //*DS* ini file may be locked in network environment
  begin
    iniFile := TIniFile.Create (FrameForm.userIniFileName);

    iniFile.WriteString ('GraphicsDialog', 'Position', posComboBox.Text);
    iniFile.WriteString ('GraphicsDialog', 'xImageSize', EditxImage.Text);
    iniFile.WriteString ('GraphicsDialog', 'yImageSize', EdityImage.Text);

    iniFile.Free;
  end;

end;

procedure TGraphicsDialog.HelpButtonClick(Sender: TObject);
begin
  application.HelpJump ('InsertGraphicsDlg');
end;

end.
