/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.core.xml;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlTransient;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.Service;
import org.apache.camel.core.xml.AbstractCamelFactoryBean;
import org.apache.camel.impl.engine.DefaultProducerTemplate;
import org.apache.camel.spi.Metadata;
import org.apache.camel.support.service.ServiceHelper;

@XmlAccessorType(value=XmlAccessType.FIELD)
public abstract class AbstractCamelProducerTemplateFactoryBean
extends AbstractCamelFactoryBean<ProducerTemplate> {
    @XmlTransient
    private ProducerTemplate template;
    @XmlAttribute
    @Metadata(description="Sets the default endpoint URI used by default for sending message exchanges")
    private String defaultEndpoint;
    @XmlAttribute
    @Metadata(description="Sets a custom maximum cache size to use in the backing cache pools.")
    private Integer maximumCacheSize;

    @Override
    public ProducerTemplate getObject() throws Exception {
        CamelContext context = this.getCamelContext();
        if (this.defaultEndpoint != null) {
            Endpoint endpoint = context.getEndpoint(this.defaultEndpoint);
            if (endpoint == null) {
                throw new IllegalArgumentException("No endpoint found for URI: " + this.defaultEndpoint);
            }
            this.template = new DefaultProducerTemplate(context, endpoint);
        } else {
            this.template = new DefaultProducerTemplate(context);
        }
        if (this.maximumCacheSize != null) {
            this.template.setMaximumCacheSize(this.maximumCacheSize.intValue());
        }
        ServiceHelper.startService((Service)this.template);
        return this.template;
    }

    @Override
    public Class<DefaultProducerTemplate> getObjectType() {
        return DefaultProducerTemplate.class;
    }

    @Override
    public void destroy() throws Exception {
        ServiceHelper.stopService((Service)this.template);
    }

    public String getDefaultEndpoint() {
        return this.defaultEndpoint;
    }

    public void setDefaultEndpoint(String defaultEndpoint) {
        this.defaultEndpoint = defaultEndpoint;
    }

    public Integer getMaximumCacheSize() {
        return this.maximumCacheSize;
    }

    public void setMaximumCacheSize(Integer maximumCacheSize) {
        this.maximumCacheSize = maximumCacheSize;
    }
}

