/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.loadbalancer;

import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.camel.AsyncProcessor;
import org.apache.camel.Navigate;
import org.apache.camel.Processor;
import org.apache.camel.processor.BaseProcessorSupport;
import org.apache.camel.processor.loadbalancer.LoadBalancer;
import org.apache.camel.spi.IdAware;
import org.apache.camel.spi.RouteIdAware;
import org.apache.camel.support.service.ServiceHelper;

public abstract class LoadBalancerSupport
extends BaseProcessorSupport
implements LoadBalancer,
Navigate<Processor>,
IdAware,
RouteIdAware {
    private final AtomicReference<AsyncProcessor[]> processors = new AtomicReference<AsyncProcessor[]>(new AsyncProcessor[0]);
    private String id;
    private String routeId;

    @Override
    public void addProcessor(AsyncProcessor processor) {
        this.processors.updateAndGet(op -> this.doAdd(processor, (AsyncProcessor[])op));
    }

    @Override
    public void removeProcessor(AsyncProcessor processor) {
        this.processors.updateAndGet(op -> this.doRemove(processor, (AsyncProcessor[])op));
    }

    private AsyncProcessor[] doAdd(AsyncProcessor processor, AsyncProcessor[] op) {
        int len = op.length;
        AsyncProcessor[] np = (AsyncProcessor[])Arrays.copyOf(op, len + 1, op.getClass());
        np[len] = processor;
        return np;
    }

    private AsyncProcessor[] doRemove(AsyncProcessor processor, AsyncProcessor[] op) {
        int len = op.length;
        for (int index = 0; index < len; ++index) {
            if (!op[index].equals((Object)processor)) continue;
            AsyncProcessor[] np = (AsyncProcessor[])Array.newInstance(AsyncProcessor.class, len - 1);
            System.arraycopy(op, 0, np, 0, index);
            System.arraycopy(op, index + 1, np, index, len - index - 1);
            return np;
        }
        return op;
    }

    @Override
    public List<AsyncProcessor> getProcessors() {
        return Arrays.asList(this.processors.get());
    }

    protected AsyncProcessor[] doGetProcessors() {
        return this.processors.get();
    }

    public List<Processor> next() {
        if (!this.hasNext()) {
            return null;
        }
        return this.getProcessors();
    }

    public boolean hasNext() {
        return this.doGetProcessors().length > 0;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getRouteId() {
        return this.routeId;
    }

    public void setRouteId(String routeId) {
        this.routeId = routeId;
    }

    protected void doInit() throws Exception {
        ServiceHelper.initService((Object[])this.processors.get());
    }

    protected void doStart() throws Exception {
        ServiceHelper.startService((Object[])this.processors.get());
    }

    protected void doStop() throws Exception {
        ServiceHelper.stopService((Object[])this.processors.get());
    }

    protected void doShutdown() throws Exception {
        AsyncProcessor[] p = this.processors.get();
        ServiceHelper.stopAndShutdownServices((Object[])p);
        for (AsyncProcessor processor : p) {
            this.removeProcessor(processor);
        }
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

