/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.transaction;

import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.InvalidTransactionException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import javax.transaction.Transactional;
import org.apache.aries.transaction.TransactionToken;

public enum TransactionAttribute {
    MANDATORY{

        @Override
        public TransactionToken begin(TransactionManager man) throws SystemException {
            if (man.getStatus() == 6) {
                throw new IllegalStateException("No transaction present when calling method that mandates a transaction.");
            }
            return new TransactionToken(man.getTransaction(), null, MANDATORY, false, false);
        }
    }
    ,
    NEVER{

        @Override
        public TransactionToken begin(TransactionManager man) throws SystemException {
            if (man.getStatus() == 0) {
                throw new IllegalStateException("Transaction present when calling method that forbids a transaction.");
            }
            return new TransactionToken(null, null, NEVER, false, false);
        }
    }
    ,
    NOT_SUPPORTED{

        @Override
        public TransactionToken begin(TransactionManager man) throws SystemException {
            if (man.getStatus() == 0) {
                return new TransactionToken(null, man.suspend(), NOT_SUPPORTED, false, true);
            }
            return new TransactionToken(null, null, NOT_SUPPORTED, false, false);
        }

        @Override
        public void finish(TransactionManager man, TransactionToken tranToken) throws SystemException, InvalidTransactionException {
            Transaction tran = tranToken.getSuspendedTransaction();
            if (tran != null) {
                man.resume(tran);
            }
        }
    }
    ,
    REQUIRED{

        @Override
        public TransactionToken begin(TransactionManager man) throws SystemException, NotSupportedException {
            if (man.getStatus() == 6) {
                man.begin();
                return new TransactionToken(man.getTransaction(), null, REQUIRED, true, true);
            }
            return new TransactionToken(man.getTransaction(), null, REQUIRED, false, false);
        }

        @Override
        public void finish(TransactionManager man, TransactionToken tranToken) throws SystemException, InvalidTransactionException, RollbackException, HeuristicMixedException, HeuristicRollbackException {
            if (tranToken.isCompletionAllowed()) {
                if (man.getStatus() == 1) {
                    man.rollback();
                } else {
                    man.commit();
                }
            }
        }
    }
    ,
    REQUIRES_NEW{

        @Override
        public TransactionToken begin(TransactionManager man) throws SystemException, NotSupportedException, InvalidTransactionException {
            Transaction suspendedTransaction = man.getStatus() == 0 ? man.suspend() : null;
            try {
                man.begin();
            }
            catch (SystemException e) {
                man.resume(suspendedTransaction);
                throw e;
            }
            catch (NotSupportedException e) {
                man.resume(suspendedTransaction);
                throw e;
            }
            return new TransactionToken(man.getTransaction(), suspendedTransaction, REQUIRES_NEW, true, true);
        }

        @Override
        public void finish(TransactionManager man, TransactionToken tranToken) throws SystemException, InvalidTransactionException, RollbackException, HeuristicMixedException, HeuristicRollbackException {
            Transaction tran;
            if (tranToken.isCompletionAllowed()) {
                if (man.getStatus() == 1) {
                    man.rollback();
                } else {
                    man.commit();
                }
            }
            if ((tran = tranToken.getSuspendedTransaction()) != null) {
                man.resume(tran);
            }
        }
    }
    ,
    SUPPORTS{

        @Override
        public TransactionToken begin(TransactionManager man) throws SystemException, NotSupportedException, InvalidTransactionException {
            if (man.getStatus() == 0) {
                return new TransactionToken(man.getTransaction(), null, SUPPORTS, false, false);
            }
            return new TransactionToken(null, null, SUPPORTS, false, false);
        }
    };


    public static TransactionAttribute fromValue(Transactional.TxType type) {
        return TransactionAttribute.valueOf(type.name());
    }

    public TransactionToken begin(TransactionManager man) throws SystemException, NotSupportedException, InvalidTransactionException {
        return null;
    }

    public void finish(TransactionManager man, TransactionToken tranToken) throws SystemException, InvalidTransactionException, RollbackException, HeuristicMixedException, HeuristicRollbackException {
    }
}

