/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.geo.evaluators.functions;

import com.esri.core.geometry.ogc.OGCGeometry;
import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.asterix.dataflow.data.nontagged.serde.AGeometrySerializerDeserializer;
import org.apache.asterix.formats.nontagged.SerializerDeserializerProvider;
import org.apache.asterix.om.base.ABinary;
import org.apache.asterix.om.base.ABoolean;
import org.apache.asterix.om.base.AGeometry;
import org.apache.asterix.om.base.AMutableInt32;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.asterix.om.types.EnumDeserializer;
import org.apache.asterix.runtime.evaluators.base.AbstractScalarFunctionDynamicDescriptor;
import org.apache.asterix.runtime.exceptions.TypeMismatchException;
import org.apache.hyracks.algebricks.runtime.base.IEvaluatorContext;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluator;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluatorFactory;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.primitive.VoidPointable;
import org.apache.hyracks.data.std.util.ArrayBackedValueStorage;
import org.apache.hyracks.dataflow.common.data.accessors.IFrameTupleReference;
import org.apache.hyracks.util.string.UTF8StringUtil;

public abstract class AbstractSTSingleGeometryDescriptor
extends AbstractScalarFunctionDynamicDescriptor {
    protected abstract Object evaluateOGCGeometry(OGCGeometry var1) throws HyracksDataException;

    public IScalarEvaluatorFactory createEvaluatorFactory(final IScalarEvaluatorFactory[] args) {
        return new IScalarEvaluatorFactory(){
            private static final long serialVersionUID = 1L;

            public IScalarEvaluator createScalarEvaluator(IEvaluatorContext ctx) throws HyracksDataException {
                return new AbstractSTSingleGeometryEvaluator(args, ctx);
            }
        };
    }

    private class AbstractSTSingleGeometryEvaluator
    implements IScalarEvaluator {
        private final ArrayBackedValueStorage resultStorage = new ArrayBackedValueStorage();
        private final DataOutput out = this.resultStorage.getDataOutput();
        private final IPointable argPtr0 = new VoidPointable();
        private final IScalarEvaluator eval0;
        private final AMutableInt32 intRes;

        public AbstractSTSingleGeometryEvaluator(IScalarEvaluatorFactory[] args, IEvaluatorContext ctx) throws HyracksDataException {
            this.eval0 = args[0].createScalarEvaluator(ctx);
            this.intRes = new AMutableInt32(0);
        }

        public void evaluate(IFrameTupleReference tuple, IPointable result) throws HyracksDataException {
            this.resultStorage.reset();
            this.eval0.evaluate(tuple, this.argPtr0);
            try {
                byte[] bytes0 = this.argPtr0.getByteArray();
                int offset0 = this.argPtr0.getStartOffset();
                int len0 = this.argPtr0.getLength();
                ATypeTag tag = (ATypeTag)EnumDeserializer.ATYPETAGDESERIALIZER.deserialize(bytes0[offset0]);
                if (tag != ATypeTag.GEOMETRY) {
                    throw new TypeMismatchException(AbstractSTSingleGeometryDescriptor.this.sourceLoc, AbstractSTSingleGeometryDescriptor.this.getIdentifier(), Integer.valueOf(0), bytes0[offset0], new byte[]{ATypeTag.SERIALIZED_GEOMETRY_TYPE_TAG});
                }
                DataInputStream dataIn0 = new DataInputStream(new ByteArrayInputStream(bytes0, offset0 + 1, len0 - 1));
                OGCGeometry geometry0 = AGeometrySerializerDeserializer.INSTANCE.deserialize((DataInput)dataIn0).getGeometry();
                Object finalResult = AbstractSTSingleGeometryDescriptor.this.evaluateOGCGeometry(geometry0);
                if (finalResult == null) {
                    this.out.writeByte(ATypeTag.SERIALIZED_NULL_TYPE_TAG);
                } else if (finalResult instanceof Double) {
                    this.out.writeByte(ATypeTag.SERIALIZED_DOUBLE_TYPE_TAG);
                    this.out.writeDouble((Double)finalResult);
                } else if (finalResult instanceof Boolean) {
                    SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.ABOOLEAN).serialize((Object)((Boolean)finalResult != false ? ABoolean.TRUE : ABoolean.FALSE), this.out);
                } else if (finalResult instanceof Integer) {
                    this.intRes.setValue(((Integer)finalResult).intValue());
                    SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.AINT32).serialize((Object)this.intRes, this.out);
                } else if (finalResult instanceof String) {
                    this.out.write(ATypeTag.SERIALIZED_STRING_TYPE_TAG);
                    this.out.write(UTF8StringUtil.writeStringToBytes((String)((String)finalResult)));
                } else if (finalResult instanceof byte[]) {
                    SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.ABINARY).serialize((Object)new ABinary((byte[])finalResult), this.out);
                } else if (finalResult instanceof OGCGeometry) {
                    this.out.writeByte(ATypeTag.SERIALIZED_GEOMETRY_TYPE_TAG);
                    AGeometrySerializerDeserializer.INSTANCE.serialize(new AGeometry((OGCGeometry)finalResult), this.out);
                }
            }
            catch (IOException e) {
                throw HyracksDataException.create((Throwable)e);
            }
            result.set((IValueReference)this.resultStorage);
        }
    }
}

