/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.external.input.record.reader.twitter;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.asterix.common.dataflow.ICcApplicationContext;
import org.apache.asterix.common.exceptions.AsterixException;
import org.apache.asterix.external.api.IExternalDataSourceFactory;
import org.apache.asterix.external.api.IRecordReader;
import org.apache.asterix.external.api.IRecordReaderFactory;
import org.apache.asterix.external.input.record.reader.twitter.TwitterPullRecordReader;
import org.apache.asterix.external.input.record.reader.twitter.TwitterPushRecordReader;
import org.apache.asterix.external.util.TwitterUtil;
import org.apache.hyracks.algebricks.common.constraints.AlgebricksAbsolutePartitionConstraint;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.api.application.IServiceContext;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.exceptions.IWarningCollector;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import twitter4j.FilterQuery;

public class TwitterRecordReaderFactory
implements IRecordReaderFactory<char[]> {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = LogManager.getLogger();
    private static final String DEFAULT_INTERVAL = "10";
    private static final int INTAKE_CARDINALITY = 1;
    private Map<String, String> configuration;
    private transient AlgebricksAbsolutePartitionConstraint clusterLocations;
    private transient IServiceContext serviceCtx;
    private static final List<String> recordReaderNames = Collections.unmodifiableList(Arrays.asList("twitter_pull", "twitter_push", "push_twitter", "pull_twitter", "twitter_user_stream"));

    @Override
    public IExternalDataSourceFactory.DataSourceType getDataSourceType() {
        return IExternalDataSourceFactory.DataSourceType.RECORDS;
    }

    @Override
    public List<String> getRecordReaderNames() {
        return recordReaderNames;
    }

    @Override
    public AlgebricksAbsolutePartitionConstraint getPartitionConstraint() throws AlgebricksException {
        this.clusterLocations = IExternalDataSourceFactory.getPartitionConstraints((ICcApplicationContext)this.serviceCtx.getApplicationContext(), this.clusterLocations, 1);
        return this.clusterLocations;
    }

    @Override
    public void configure(IServiceContext serviceCtx, Map<String, String> configuration, IWarningCollector warningCollector) throws AsterixException {
        try {
            Class.forName("twitter4j.Twitter");
        }
        catch (ClassNotFoundException e) {
            throw new AsterixException(3007, (Throwable)e, new Serializable[0]);
        }
        this.configuration = configuration;
        this.serviceCtx = serviceCtx;
        TwitterUtil.initializeConfigurationWithAuthInfo(configuration);
        if (!this.validateConfiguration(configuration)) {
            StringBuilder builder = new StringBuilder();
            builder.append("One or more parameters are missing from adapter configuration\n");
            builder.append("consumer.key\n");
            builder.append("consumer.secret\n");
            builder.append("access.token\n");
            builder.append("access.token.secret");
            throw new AsterixException(builder.toString());
        }
        if (configuration.get("reader").equals("pull_twitter")) {
            if (configuration.get("query") == null) {
                throw new AsterixException("parameter query not specified as part of adaptor configuration");
            }
            String interval = configuration.get("interval");
            if (interval != null) {
                try {
                    Integer.parseInt(interval);
                }
                catch (NumberFormatException nfe) {
                    throw new IllegalArgumentException("parameter interval is defined incorrectly, expecting a number");
                }
            } else {
                configuration.put("interval", DEFAULT_INTERVAL);
                if (LOGGER.isWarnEnabled()) {
                    LOGGER.warn(" Parameter interval not defined, using default (10)");
                }
            }
        }
    }

    @Override
    public boolean isIndexible() {
        return false;
    }

    @Override
    public IRecordReader<? extends char[]> createRecordReader(IHyracksTaskContext ctx, int partition) throws HyracksDataException {
        IRecordReader<char[]> recordReader;
        switch (this.configuration.get("reader")) {
            case "pull_twitter": {
                recordReader = new TwitterPullRecordReader(TwitterUtil.getTwitterService(this.configuration), this.configuration.get("query"), Integer.parseInt(this.configuration.get("interval")));
                break;
            }
            case "push_twitter": {
                try {
                    FilterQuery query = TwitterUtil.getFilterQuery(this.configuration);
                    recordReader = query == null ? new TwitterPushRecordReader(TwitterUtil.getTwitterStream(this.configuration), TwitterUtil.getTweetListener()) : new TwitterPushRecordReader(TwitterUtil.getTwitterStream(this.configuration), TwitterUtil.getTweetListener(), query);
                    break;
                }
                catch (AsterixException e) {
                    throw HyracksDataException.create((Throwable)e);
                }
            }
            case "twitter_user_stream": {
                recordReader = new TwitterPushRecordReader(TwitterUtil.getTwitterStream(this.configuration), TwitterUtil.getUserTweetsListener());
                break;
            }
            default: {
                throw new HyracksDataException("No Record reader found!");
            }
        }
        return recordReader;
    }

    @Override
    public Class<? extends char[]> getRecordClass() {
        return char[].class;
    }

    private boolean validateConfiguration(Map<String, String> configuration) {
        String consumerKey = configuration.get("consumer.key");
        String consumerSecret = configuration.get("consumer.secret");
        String accessToken = configuration.get("access.token");
        String tokenSecret = configuration.get("access.token.secret");
        return consumerKey != null && consumerSecret != null && accessToken != null && tokenSecret != null;
    }
}

