/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.algebricks.rewriter.rules;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.commons.lang3.mutable.MutableObject;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.base.IOptimizationContext;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalOperatorTag;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalVariable;
import org.apache.hyracks.algebricks.core.algebra.expressions.ConstantExpression;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractLogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractOperatorWithNestedPlans;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.EmptyTupleSourceOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.InnerJoinOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.visitors.VariableUtilities;
import org.apache.hyracks.algebricks.core.rewriter.base.IAlgebraicRewriteRule;

public class ComplexUnnestToProductRule
implements IAlgebraicRewriteRule {
    public boolean rewritePre(Mutable<ILogicalOperator> opRef, IOptimizationContext context) {
        return false;
    }

    public boolean rewritePost(Mutable<ILogicalOperator> opRef, IOptimizationContext context) throws AlgebricksException {
        AbstractLogicalOperator op = (AbstractLogicalOperator)opRef.getValue();
        if (op.getOperatorTag() != LogicalOperatorTag.DATASOURCESCAN && op.getOperatorTag() != LogicalOperatorTag.UNNEST) {
            return false;
        }
        if (this.insideSubplan(opRef)) {
            return false;
        }
        ArrayList<ILogicalOperator> topSelects = new ArrayList<ILogicalOperator>();
        HashSet<LogicalVariable> innerUsedVars = new HashSet<LogicalVariable>();
        ArrayList<ILogicalOperator> innerOps = new ArrayList<ILogicalOperator>();
        HashSet<LogicalVariable> outerUsedVars = new HashSet<LogicalVariable>();
        ArrayList<ILogicalOperator> outerOps = new ArrayList<ILogicalOperator>();
        innerOps.add((ILogicalOperator)op);
        VariableUtilities.getUsedVariables((ILogicalOperator)op, innerUsedVars);
        Mutable opRef2 = (Mutable)op.getInputs().get(0);
        AbstractLogicalOperator op2 = (AbstractLogicalOperator)opRef2.getValue();
        if (!this.findPlanPartition(op2, innerUsedVars, outerUsedVars, innerOps, outerOps, topSelects, false)) {
            return false;
        }
        AbstractLogicalOperator unnestOrJoin = (AbstractLogicalOperator)outerOps.get(outerOps.size() - 1);
        ILogicalOperator outerRoot = null;
        ILogicalOperator innerRoot = null;
        EmptyTupleSourceOperator ets = new EmptyTupleSourceOperator();
        if (unnestOrJoin.getOperatorTag() != LogicalOperatorTag.INNERJOIN && unnestOrJoin.getOperatorTag() != LogicalOperatorTag.LEFTOUTERJOIN) {
            ArrayList liveVars = new ArrayList();
            VariableUtilities.getLiveVariables((ILogicalOperator)unnestOrJoin, liveVars);
            for (LogicalVariable liveVar : liveVars) {
                if (!innerUsedVars.contains(liveVar)) continue;
                return false;
            }
            VariableUtilities.getUsedVariables((ILogicalOperator)unnestOrJoin, outerUsedVars);
            AbstractLogicalOperator unnestChild = (AbstractLogicalOperator)((Mutable)unnestOrJoin.getInputs().get(0)).getValue();
            if (!this.findPlanPartition(unnestChild, innerUsedVars, outerUsedVars, innerOps, outerOps, topSelects, true)) {
                return false;
            }
        }
        innerRoot = this.buildOperatorChain(innerOps, (ILogicalOperator)ets, context);
        context.computeAndSetTypeEnvironmentForOperator(innerRoot);
        outerRoot = this.buildOperatorChain(outerOps, null, context);
        context.computeAndSetTypeEnvironmentForOperator(outerRoot);
        InnerJoinOperator product = new InnerJoinOperator((Mutable)new MutableObject((Object)ConstantExpression.TRUE));
        product.setSourceLocation(op.getSourceLocation());
        product.getInputs().add(new MutableObject((Object)outerRoot));
        product.getInputs().add(new MutableObject((Object)innerRoot));
        context.computeAndSetTypeEnvironmentForOperator((ILogicalOperator)product);
        InnerJoinOperator topOp = product;
        if (!topSelects.isEmpty()) {
            topOp = this.buildOperatorChain(topSelects, (ILogicalOperator)product, context);
        }
        opRef.setValue((Object)topOp);
        context.computeAndSetTypeEnvironmentForOperator((ILogicalOperator)topOp);
        return true;
    }

    private ILogicalOperator buildOperatorChain(List<ILogicalOperator> ops, ILogicalOperator bottomOp, IOptimizationContext context) throws AlgebricksException {
        ILogicalOperator root;
        ILogicalOperator prevOp = root = ops.get(0);
        for (int i = 1; i < ops.size(); ++i) {
            ILogicalOperator inputOp = ops.get(i);
            prevOp.getInputs().clear();
            prevOp.getInputs().add(new MutableObject((Object)inputOp));
            prevOp = inputOp;
        }
        if (bottomOp != null) {
            context.computeAndSetTypeEnvironmentForOperator(bottomOp);
            prevOp.getInputs().clear();
            prevOp.getInputs().add(new MutableObject((Object)bottomOp));
        }
        return root;
    }

    /*
     * Unable to fully structure code
     */
    private boolean findPlanPartition(AbstractLogicalOperator op, HashSet<LogicalVariable> innerUsedVars, HashSet<LogicalVariable> outerUsedVars, List<ILogicalOperator> innerOps, List<ILogicalOperator> outerOps, List<ILogicalOperator> topSelects, boolean belowSecondUnnest) throws AlgebricksException {
        if (belowSecondUnnest && innerUsedVars.isEmpty()) {
            return true;
        }
        if (!belowSecondUnnest) {
            switch (1.$SwitchMap$org$apache$hyracks$algebricks$core$algebra$base$LogicalOperatorTag[op.getOperatorTag().ordinal()]) {
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    return false;
                }
            }
        }
        switch (1.$SwitchMap$org$apache$hyracks$algebricks$core$algebra$base$LogicalOperatorTag[op.getOperatorTag().ordinal()]) {
            case 5: 
            case 6: {
                outerOps.add((ILogicalOperator)op);
                return true;
            }
            case 7: 
            case 8: {
                liveVars = new ArrayList<E>();
                VariableUtilities.getLiveVariables((ILogicalOperator)op, liveVars);
                for (LogicalVariable liveVar : liveVars) {
                    if (!innerUsedVars.contains(liveVar)) continue;
                    return false;
                }
                outerOps.add((ILogicalOperator)op);
                return true;
            }
            case 9: {
                if (innerUsedVars.isEmpty()) {
                    outerOps.add((ILogicalOperator)op);
                    break;
                }
                topSelects.add((ILogicalOperator)op);
                break;
            }
            case 10: {
                break;
            }
            case 11: 
            case 12: {
                return belowSecondUnnest != false;
            }
            default: {
                if (!belowSecondUnnest && innerUsedVars.isEmpty()) {
                    outerOps.add((ILogicalOperator)op);
                    break;
                }
                producedVars = new ArrayList<E>();
                VariableUtilities.getProducedVariables((ILogicalOperator)op, producedVars);
                outerMatches = 0;
                innerMatches = 0;
                for (LogicalVariable producedVar : producedVars) {
                    if (outerUsedVars.contains(producedVar)) {
                        ++outerMatches;
                    }
                    if (!innerUsedVars.contains(producedVar)) continue;
                    ++innerMatches;
                }
                targetUsedVars = null;
                if (outerMatches == producedVars.size() && !producedVars.isEmpty()) {
                    outerOps.add((ILogicalOperator)op);
                    targetUsedVars = outerUsedVars;
                }
                if (innerMatches == producedVars.size() && !producedVars.isEmpty()) {
                    innerOps.add((ILogicalOperator)op);
                    targetUsedVars = innerUsedVars;
                }
                if (innerMatches != 0 || outerMatches != 0) ** GOTO lbl75
                usedVars = new ArrayList<E>();
                VariableUtilities.getUsedVariables((ILogicalOperator)op, usedVars);
                for (LogicalVariable usedVar : usedVars) {
                    canBreak = false;
                    if (outerUsedVars.contains(usedVar)) {
                        outerOps.add((ILogicalOperator)op);
                        targetUsedVars = outerUsedVars;
                        canBreak = true;
                    }
                    if (innerUsedVars.contains(usedVar)) {
                        innerOps.add((ILogicalOperator)op);
                        targetUsedVars = innerUsedVars;
                        canBreak = true;
                    }
                    if (!canBreak) continue;
                    ** GOTO lbl77
                }
                ** GOTO lbl77
lbl75:
                // 1 sources

                if (innerMatches != 0 && outerMatches != 0) {
                    return false;
                }
lbl77:
                // 4 sources

                if (targetUsedVars == null) {
                    return false;
                }
                if (op.hasNestedPlans() && op.getOperatorTag() != LogicalOperatorTag.SUBPLAN) {
                    opWithNestedPlans = (AbstractOperatorWithNestedPlans)op;
                    opWithNestedPlans.getUsedVariablesExceptNestedPlans(targetUsedVars);
                    break;
                }
                VariableUtilities.getUsedVariables((ILogicalOperator)op, targetUsedVars);
                break;
            }
        }
        if (!op.hasInputs()) {
            return belowSecondUnnest != false;
        }
        return this.findPlanPartition((AbstractLogicalOperator)((Mutable)op.getInputs().get(0)).getValue(), innerUsedVars, outerUsedVars, innerOps, outerOps, topSelects, belowSecondUnnest);
    }

    private boolean insideSubplan(Mutable<ILogicalOperator> nestedRootRef) {
        AbstractLogicalOperator nestedRoot = (AbstractLogicalOperator)nestedRootRef.getValue();
        if (nestedRoot.getOperatorTag() == LogicalOperatorTag.NESTEDTUPLESOURCE) {
            return true;
        }
        List inputs = nestedRoot.getInputs();
        for (Mutable input : inputs) {
            if (!this.insideSubplan((Mutable<ILogicalOperator>)input)) continue;
            return true;
        }
        return false;
    }
}

