/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.hdfs.scheduler;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hyracks.api.client.NodeControllerInfo;
import org.apache.hyracks.hdfs.api.INcCollection;
import org.apache.hyracks.hdfs.api.INcCollectionBuilder;

public class IPProximityNcCollectionBuilder
implements INcCollectionBuilder {
    @Override
    public INcCollection build(Map<String, NodeControllerInfo> ncNameToNcInfos, final Map<String, List<String>> ipToNcMapping, final Map<String, Integer> ncNameToIndex, String[] NCs, final int[] workloads, final int slotLimit) {
        final TreeMap<BytesWritable, IntWritable> availableIpsToSlots = new TreeMap<BytesWritable, IntWritable>();
        for (int i = 0; i < workloads.length; ++i) {
            byte[] rawip;
            if (workloads[i] >= slotLimit) continue;
            try {
                rawip = ncNameToNcInfos.get(NCs[i]).getNetworkAddress().lookupIpAddress();
            }
            catch (UnknownHostException e) {
                throw new RuntimeException(e);
            }
            BytesWritable ip = new BytesWritable(rawip);
            IntWritable availableSlot = (IntWritable)availableIpsToSlots.get(ip);
            if (availableSlot == null) {
                availableSlot = new IntWritable(slotLimit - workloads[i]);
                availableIpsToSlots.put(ip, availableSlot);
                continue;
            }
            availableSlot.set(slotLimit - workloads[i] + availableSlot.get());
        }
        return new INcCollection(){

            @Override
            public String findNearestAvailableSlot(InputSplit split) {
                try {
                    String[] locs = split.getLocations();
                    int minDistance = Integer.MAX_VALUE;
                    BytesWritable currentCandidateIp = null;
                    if (locs == null || locs.length > 0) {
                        for (int j = 0; j < locs.length; ++j) {
                            InetAddress[] allIps = InetAddress.getAllByName(locs[j]);
                            for (InetAddress ip : allIps) {
                                byte[] splitIP;
                                int splitInt;
                                byte[] candidateIP;
                                int candidateInt;
                                int distance;
                                BytesWritable splitIp = new BytesWritable(ip.getAddress());
                                BytesWritable candidateNcIp = availableIpsToSlots.floorKey(splitIp);
                                if (candidateNcIp == null) {
                                    candidateNcIp = availableIpsToSlots.ceilingKey(splitIp);
                                }
                                if (candidateNcIp == null || ((IntWritable)availableIpsToSlots.get(candidateNcIp)).get() <= 0 || minDistance <= (distance = Math.abs((candidateInt = (candidateIP = candidateNcIp.getBytes())[0] << 24 | (candidateIP[1] & 0xFF) << 16 | (candidateIP[2] & 0xFF) << 8 | candidateIP[3] & 0xFF) - (splitInt = (splitIP = splitIp.getBytes())[0] << 24 | (splitIP[1] & 0xFF) << 16 | (splitIP[2] & 0xFF) << 8 | splitIP[3] & 0xFF)))) continue;
                                minDistance = distance;
                                currentCandidateIp = candidateNcIp;
                            }
                        }
                    } else {
                        for (Map.Entry entry : availableIpsToSlots.entrySet()) {
                            if (((IntWritable)entry.getValue()).get() <= 0) continue;
                            currentCandidateIp = (BytesWritable)entry.getKey();
                            break;
                        }
                    }
                    if (currentCandidateIp != null) {
                        IntWritable availableSlot = (IntWritable)availableIpsToSlots.get(currentCandidateIp);
                        availableSlot.set(availableSlot.get() - 1);
                        if (availableSlot.get() == 0) {
                            availableIpsToSlots.remove(currentCandidateIp);
                        }
                        List dataLocations = (List)ipToNcMapping.get(InetAddress.getByAddress(currentCandidateIp.getBytes()).getHostAddress());
                        for (String nc : dataLocations) {
                            int ncIndex = (Integer)ncNameToIndex.get(nc);
                            if (workloads[ncIndex] >= slotLimit) continue;
                            return nc;
                        }
                    }
                    return null;
                }
                catch (Exception e) {
                    throw new IllegalStateException(e);
                }
            }

            @Override
            public int numAvailableSlots() {
                return availableIpsToSlots.size();
            }
        };
    }
}

