/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.control.nc.heartbeat;

import java.net.InetSocketAddress;
import org.apache.hyracks.api.control.CcId;
import org.apache.hyracks.api.exceptions.ErrorCode;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.exceptions.IError;
import org.apache.hyracks.control.common.heartbeat.HeartbeatData;
import org.apache.hyracks.control.nc.CcConnection;
import org.apache.hyracks.control.nc.NodeControllerService;
import org.apache.hyracks.control.nc.heartbeat.HeartbeatTask;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;

public class HeartbeatManager {
    private static final Logger LOGGER = LogManager.getLogger();
    private final NodeControllerService ncs;
    private final CcConnection ccc;
    private final Thread hbThread;
    private final CcId ccId;

    private HeartbeatManager(NodeControllerService ncs, CcConnection ccc, HeartbeatData hbData, InetSocketAddress ncAddress) {
        this.ncs = ncs;
        this.ccc = ccc;
        this.hbThread = new Thread((Runnable)new HeartbeatTask(ncs.getId(), hbData, ccc.getClusterControllerService(), ccc.getNodeParameters().getHeartbeatPeriod(), ncAddress), ncs.getId() + "-Heartbeat");
        this.hbThread.setPriority(10);
        this.hbThread.setDaemon(true);
        this.ccId = ccc.getCcId();
    }

    public static HeartbeatManager init(NodeControllerService ncs, CcConnection ccc, HeartbeatData hbData, InetSocketAddress ncAddress) {
        HeartbeatManager hbMgr = new HeartbeatManager(ncs, ccc, hbData, ncAddress);
        hbMgr.start();
        return hbMgr;
    }

    public void shutdown() {
        this.hbThread.interrupt();
    }

    public void start() {
        this.hbThread.start();
    }

    public void notifyAck(HyracksDataException exception) {
        Supplier[] supplierArray = new Supplier[2];
        supplierArray[0] = () -> ((CcId)this.ccId).toString();
        supplierArray[1] = () -> String.valueOf((Object)exception);
        LOGGER.debug("ack rec'd from {} w/ exception: {}", supplierArray);
        if (exception != null && exception.matches((IError)ErrorCode.NO_SUCH_NODE)) {
            LOGGER.info("{} indicates it does not recognize us; force a reconnect", (Object)this.ccId);
            try {
                this.ccc.forceReregister(this.ncs);
            }
            catch (Exception e) {
                LOGGER.warn("ignoring exception attempting to re-register with {}", (Object)this.ccId, (Object)e);
            }
        }
    }
}

