/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.lsm.invertedindex.impls;

import java.util.ArrayList;
import java.util.List;
import org.apache.hyracks.api.dataflow.value.IBinaryComparatorFactory;
import org.apache.hyracks.api.dataflow.value.ITypeTraits;
import org.apache.hyracks.api.exceptions.ErrorCode;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.exceptions.IError;
import org.apache.hyracks.api.io.FileReference;
import org.apache.hyracks.api.io.IIOManager;
import org.apache.hyracks.data.std.primitive.IntegerPointable;
import org.apache.hyracks.dataflow.common.data.accessors.ITupleReference;
import org.apache.hyracks.dataflow.common.data.accessors.PermutingTupleReference;
import org.apache.hyracks.storage.am.btree.frames.BTreeLeafFrameType;
import org.apache.hyracks.storage.am.btree.impls.BTree;
import org.apache.hyracks.storage.am.btree.impls.BTreeRangeSearchCursor;
import org.apache.hyracks.storage.am.btree.impls.RangePredicate;
import org.apache.hyracks.storage.am.btree.util.BTreeUtils;
import org.apache.hyracks.storage.am.common.api.IExtendedModificationOperationCallback;
import org.apache.hyracks.storage.am.common.api.IIndexOperationContext;
import org.apache.hyracks.storage.am.common.api.IPageManager;
import org.apache.hyracks.storage.am.common.api.ITreeIndexCursor;
import org.apache.hyracks.storage.am.common.impls.NoOpIndexAccessParameters;
import org.apache.hyracks.storage.am.common.impls.NoOpOperationCallback;
import org.apache.hyracks.storage.am.lsm.common.api.IComponentFilterHelper;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMComponent;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMComponentFilterFrameFactory;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMDiskComponent;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMDiskComponentBulkLoader;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMDiskComponentFactory;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIOOperation;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIOOperationCallback;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIOOperationCallbackFactory;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIOOperationScheduler;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIndex;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIndexAccessor;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIndexFileManager;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIndexOperationContext;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMMergePolicy;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMOperationTracker;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMPageWriteCallbackFactory;
import org.apache.hyracks.storage.am.lsm.common.api.IVirtualBufferCache;
import org.apache.hyracks.storage.am.lsm.common.freepage.VirtualFreePageManager;
import org.apache.hyracks.storage.am.lsm.common.impls.AbstractLSMIndex;
import org.apache.hyracks.storage.am.lsm.common.impls.AbstractLSMIndexOperationContext;
import org.apache.hyracks.storage.am.lsm.common.impls.LSMComponentFileReferences;
import org.apache.hyracks.storage.am.lsm.common.impls.LSMComponentFilterManager;
import org.apache.hyracks.storage.am.lsm.invertedindex.api.IInvertedIndex;
import org.apache.hyracks.storage.am.lsm.invertedindex.fulltext.IFullTextConfigEvaluatorFactory;
import org.apache.hyracks.storage.am.lsm.invertedindex.impls.LSMInvertedIndexAccessor;
import org.apache.hyracks.storage.am.lsm.invertedindex.impls.LSMInvertedIndexDeletedKeysBTreeMergeCursor;
import org.apache.hyracks.storage.am.lsm.invertedindex.impls.LSMInvertedIndexDiskComponent;
import org.apache.hyracks.storage.am.lsm.invertedindex.impls.LSMInvertedIndexFlushOperation;
import org.apache.hyracks.storage.am.lsm.invertedindex.impls.LSMInvertedIndexMemoryComponent;
import org.apache.hyracks.storage.am.lsm.invertedindex.impls.LSMInvertedIndexMergeCursor;
import org.apache.hyracks.storage.am.lsm.invertedindex.impls.LSMInvertedIndexMergeOperation;
import org.apache.hyracks.storage.am.lsm.invertedindex.impls.LSMInvertedIndexOpContext;
import org.apache.hyracks.storage.am.lsm.invertedindex.impls.LSMInvertedIndexRangeSearchCursorInitialState;
import org.apache.hyracks.storage.am.lsm.invertedindex.impls.LSMInvertedIndexSearchCursorInitialState;
import org.apache.hyracks.storage.am.lsm.invertedindex.inmemory.InMemoryInvertedIndex;
import org.apache.hyracks.storage.am.lsm.invertedindex.inmemory.InMemoryInvertedIndexAccessor;
import org.apache.hyracks.storage.am.lsm.invertedindex.search.InvertedIndexSearchPredicate;
import org.apache.hyracks.storage.am.lsm.invertedindex.tokenizers.IBinaryTokenizerFactory;
import org.apache.hyracks.storage.am.lsm.invertedindex.util.InvertedIndexUtils;
import org.apache.hyracks.storage.common.ICursorInitialState;
import org.apache.hyracks.storage.common.IIndexAccessParameters;
import org.apache.hyracks.storage.common.IIndexCursor;
import org.apache.hyracks.storage.common.IIndexCursorStats;
import org.apache.hyracks.storage.common.ISearchPredicate;
import org.apache.hyracks.storage.common.IndexCursorStats;
import org.apache.hyracks.storage.common.MultiComparator;
import org.apache.hyracks.storage.common.buffercache.IBufferCache;
import org.apache.hyracks.util.trace.ITracer;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LSMInvertedIndex
extends AbstractLSMIndex
implements IInvertedIndex {
    private static final Logger LOGGER = LogManager.getLogger();
    protected final IBinaryTokenizerFactory tokenizerFactory;
    protected final IFullTextConfigEvaluatorFactory fullTextConfigEvaluatorFactory;
    protected final ITypeTraits[] invListTypeTraits;
    protected final IBinaryComparatorFactory[] invListCmpFactories;
    protected final ITypeTraits[] tokenTypeTraits;
    protected final IBinaryComparatorFactory[] tokenCmpFactories;
    private final int[] filterFieldsForNonBulkLoadOps;
    private final int[] invertedIndexFieldsForNonBulkLoadOps;

    public LSMInvertedIndex(IIOManager ioManager, List<IVirtualBufferCache> virtualBufferCaches, ILSMDiskComponentFactory componentFactory, IComponentFilterHelper filterHelper, ILSMComponentFilterFrameFactory filterFrameFactory, LSMComponentFilterManager filterManager, double bloomFilterFalsePositiveRate, IBufferCache diskBufferCache, ILSMIndexFileManager fileManager, ITypeTraits[] invListTypeTraits, IBinaryComparatorFactory[] invListCmpFactories, ITypeTraits[] tokenTypeTraits, IBinaryComparatorFactory[] tokenCmpFactories, IBinaryTokenizerFactory tokenizerFactory, IFullTextConfigEvaluatorFactory fullTextConfigEvaluatorFactory, ILSMMergePolicy mergePolicy, ILSMOperationTracker opTracker, ILSMIOOperationScheduler ioScheduler, ILSMIOOperationCallbackFactory ioOpCallbackFactory, ILSMPageWriteCallbackFactory pageWriteCallbackFactory, int[] invertedIndexFields, int[] filterFields, int[] filterFieldsForNonBulkLoadOps, int[] invertedIndexFieldsForNonBulkLoadOps, boolean durable, ITracer tracer) throws HyracksDataException {
        super(ioManager, virtualBufferCaches, diskBufferCache, fileManager, bloomFilterFalsePositiveRate, mergePolicy, opTracker, ioScheduler, ioOpCallbackFactory, pageWriteCallbackFactory, componentFactory, componentFactory, filterFrameFactory, filterManager, filterFields, durable, filterHelper, invertedIndexFields, tracer);
        this.tokenizerFactory = tokenizerFactory;
        this.fullTextConfigEvaluatorFactory = fullTextConfigEvaluatorFactory;
        this.invListTypeTraits = invListTypeTraits;
        this.invListCmpFactories = invListCmpFactories;
        this.tokenTypeTraits = tokenTypeTraits;
        this.tokenCmpFactories = tokenCmpFactories;
        this.filterFieldsForNonBulkLoadOps = filterFieldsForNonBulkLoadOps;
        this.invertedIndexFieldsForNonBulkLoadOps = invertedIndexFieldsForNonBulkLoadOps;
        int i = 0;
        for (IVirtualBufferCache virtualBufferCache : virtualBufferCaches) {
            InMemoryInvertedIndex memInvIndex = this.createInMemoryInvertedIndex(virtualBufferCache, new VirtualFreePageManager((IBufferCache)virtualBufferCache), i);
            BTree deleteKeysBTree = BTreeUtils.createBTree((IBufferCache)virtualBufferCache, (IPageManager)new VirtualFreePageManager((IBufferCache)virtualBufferCache), (ITypeTraits[])invListTypeTraits, (IBinaryComparatorFactory[])invListCmpFactories, (BTreeLeafFrameType)BTreeLeafFrameType.REGULAR_NSM, (FileReference)ioManager.resolveAbsolutePath(fileManager.getBaseDir() + "_virtual_del_" + i), (boolean)false);
            LSMInvertedIndexMemoryComponent mutableComponent = new LSMInvertedIndexMemoryComponent(this, memInvIndex, deleteKeysBTree, virtualBufferCache, filterHelper == null ? null : filterHelper.createFilter());
            this.memoryComponents.add(mutableComponent);
            ++i;
        }
    }

    public void modify(IIndexOperationContext ictx, ITupleReference tuple) throws HyracksDataException {
        ITupleReference indexTuple;
        LSMInvertedIndexOpContext ctx = (LSMInvertedIndexOpContext)ictx;
        if (ctx.getIndexTuple() != null) {
            ctx.getIndexTuple().reset(tuple);
            indexTuple = ctx.getIndexTuple();
        } else {
            indexTuple = tuple;
        }
        ctx.getModificationCallback().before(indexTuple);
        ctx.getModificationCallback().found(null, indexTuple);
        switch (ctx.getOperation()) {
            case INSERT: {
                ctx.getCurrentMutableInvIndexAccessors().insert(indexTuple);
                break;
            }
            case DELETE: {
                ctx.getCurrentMutableInvIndexAccessors().delete(indexTuple);
                ctx.getKeysOnlyTuple().reset(indexTuple);
                try {
                    ctx.getCurrentDeletedKeysBTreeAccessors().insert((ITupleReference)ctx.getKeysOnlyTuple());
                    break;
                }
                catch (HyracksDataException e) {
                    if (e.matches((IError)ErrorCode.DUPLICATE_KEY)) break;
                    LOGGER.log(Level.WARN, "Failure during index delete operation", (Throwable)e);
                    throw e;
                }
            }
            default: {
                throw new UnsupportedOperationException("Operation " + ctx.getOperation() + " not supported.");
            }
        }
        this.updateFilter((ILSMIndexOperationContext)ctx, tuple);
    }

    public void search(ILSMIndexOperationContext ictx, IIndexCursor cursor, ISearchPredicate pred) throws HyracksDataException {
        List operationalComponents = ictx.getComponentHolder();
        boolean includeMutableComponent = false;
        ICursorInitialState initState = this.createCursorInitialState(pred, (IIndexOperationContext)ictx, includeMutableComponent, operationalComponents);
        cursor.open(initState, pred);
    }

    private ICursorInitialState createCursorInitialState(ISearchPredicate pred, IIndexOperationContext ictx, boolean includeMutableComponent, List<ILSMComponent> operationalComponents) {
        Object initState;
        PermutingTupleReference keysOnlyTuple = this.createKeysOnlyTupleReference();
        MultiComparator keyCmp = MultiComparator.create((IBinaryComparatorFactory[])this.invListCmpFactories);
        if (pred instanceof InvertedIndexSearchPredicate) {
            initState = new LSMInvertedIndexSearchCursorInitialState(keyCmp, keysOnlyTuple, ((LSMInvertedIndexMemoryComponent)((Object)this.memoryComponents.get(this.currentMutableComponentId.get()))).getBuddyIndex().getLeafFrameFactory(), ictx, includeMutableComponent, this.getHarness(), operationalComponents);
        } else {
            LSMInvertedIndexMemoryComponent mutableComponent = (LSMInvertedIndexMemoryComponent)((Object)this.memoryComponents.get(this.currentMutableComponentId.get()));
            MultiComparator tokensAndKeysCmp = MultiComparator.create((IBinaryComparatorFactory[])mutableComponent.getIndex().getBTree().getComparatorFactories());
            initState = new LSMInvertedIndexRangeSearchCursorInitialState(tokensAndKeysCmp, keyCmp, keysOnlyTuple, ((LSMInvertedIndexMemoryComponent)((Object)this.memoryComponents.get(this.currentMutableComponentId.get()))).getBuddyIndex().getLeafFrameFactory(), includeMutableComponent, this.getHarness(), pred, operationalComponents);
        }
        return initState;
    }

    private PermutingTupleReference createKeysOnlyTupleReference() {
        int[] keyFieldPermutation = new int[this.invListTypeTraits.length];
        int numTokenFields = this.tokenTypeTraits.length;
        for (int i = 0; i < this.invListTypeTraits.length; ++i) {
            keyFieldPermutation[i] = numTokenFields + i;
        }
        return new PermutingTupleReference(keyFieldPermutation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ILSMDiskComponent doFlush(ILSMIOOperation operation) throws HyracksDataException {
        LSMInvertedIndexFlushOperation flushOp = (LSMInvertedIndexFlushOperation)operation;
        ILSMDiskComponent component = this.createDiskComponent(this.componentFactory, flushOp.getTarget(), flushOp.getDeletedKeysBTreeTarget(), flushOp.getBloomFilterTarget(), true);
        LSMInvertedIndexMemoryComponent flushingComponent = (LSMInvertedIndexMemoryComponent)flushOp.getFlushingComponent();
        RangePredicate nullPred = new RangePredicate(null, null, true, true, null, null);
        long numBTreeTuples = 0L;
        BTree.BTreeAccessor deletedKeysBTreeAccessor = flushingComponent.getBuddyIndex().createAccessor((IIndexAccessParameters)NoOpIndexAccessParameters.INSTANCE);
        ITreeIndexCursor btreeCountingCursor = deletedKeysBTreeAccessor.createCountingSearchCursor();
        try {
            deletedKeysBTreeAccessor.search((IIndexCursor)btreeCountingCursor, (ISearchPredicate)nullPred);
            try {
                while (btreeCountingCursor.hasNext()) {
                    btreeCountingCursor.next();
                    ITupleReference countTuple = btreeCountingCursor.getTuple();
                    numBTreeTuples = IntegerPointable.getInteger((byte[])countTuple.getFieldData(0), (int)countTuple.getFieldStart(0));
                }
            }
            finally {
                btreeCountingCursor.close();
            }
        }
        finally {
            btreeCountingCursor.destroy();
        }
        ILSMDiskComponentBulkLoader componentBulkLoader = component.createBulkLoader(operation, 1.0f, false, numBTreeTuples, false, false, false, this.pageWriteCallbackFactory.createPageWriteCallback());
        BTreeRangeSearchCursor deletedKeysScanCursor = deletedKeysBTreeAccessor.createSearchCursor(false);
        try {
            deletedKeysBTreeAccessor.search((IIndexCursor)deletedKeysScanCursor, (ISearchPredicate)nullPred);
            try {
                while (deletedKeysScanCursor.hasNext()) {
                    deletedKeysScanCursor.next();
                    componentBulkLoader.delete(deletedKeysScanCursor.getTuple());
                }
            }
            finally {
                deletedKeysScanCursor.close();
            }
        }
        finally {
            deletedKeysScanCursor.destroy();
        }
        InMemoryInvertedIndexAccessor memInvIndexAccessor = flushingComponent.getIndex().createAccessor((IIndexAccessParameters)NoOpIndexAccessParameters.INSTANCE);
        BTree.BTreeAccessor memBTreeAccessor = memInvIndexAccessor.getBTreeAccessor();
        BTreeRangeSearchCursor scanCursor = memBTreeAccessor.createSearchCursor(false);
        try {
            memBTreeAccessor.search((IIndexCursor)scanCursor, (ISearchPredicate)nullPred);
            try {
                while (scanCursor.hasNext()) {
                    scanCursor.next();
                    componentBulkLoader.add(scanCursor.getTuple());
                }
            }
            finally {
                scanCursor.close();
            }
        }
        finally {
            scanCursor.destroy();
        }
        if (component.getLSMComponentFilter() != null) {
            ArrayList<ITupleReference> filterTuples = new ArrayList<ITupleReference>();
            filterTuples.add(flushingComponent.getLSMComponentFilter().getMinTuple());
            filterTuples.add(flushingComponent.getLSMComponentFilter().getMaxTuple());
            this.filterManager.updateFilter(component.getLSMComponentFilter(), filterTuples, (IExtendedModificationOperationCallback)NoOpOperationCallback.INSTANCE);
            this.filterManager.writeFilter(component.getLSMComponentFilter(), component.getMetadataHolder());
        }
        flushingComponent.getMetadata().copy(component.getMetadata());
        componentBulkLoader.end();
        return component;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ILSMDiskComponent doMerge(ILSMIOOperation operation) throws HyracksDataException {
        ILSMDiskComponentBulkLoader componentBulkLoader;
        LSMInvertedIndexMergeOperation mergeOp = (LSMInvertedIndexMergeOperation)operation;
        RangePredicate mergePred = new RangePredicate(null, null, true, true, null, null);
        IIndexCursor cursor = mergeOp.getCursor();
        LSMInvertedIndexOpContext opCtx = ((LSMInvertedIndexMergeCursor)cursor).getOpCtx();
        ILSMDiskComponent component = this.createDiskComponent(this.componentFactory, mergeOp.getTarget(), mergeOp.getDeletedKeysBTreeTarget(), mergeOp.getBloomFilterTarget(), true);
        if (mergeOp.getMergingComponents().get(mergeOp.getMergingComponents().size() - 1) != this.diskComponents.get(this.diskComponents.size() - 1)) {
            LSMInvertedIndexDeletedKeysBTreeMergeCursor btreeCursor = new LSMInvertedIndexDeletedKeysBTreeMergeCursor((ILSMIndexOperationContext)opCtx, mergeOp.getCursorStats());
            try {
                long numElements = 0L;
                for (int i = 0; i < mergeOp.getMergingComponents().size(); ++i) {
                    numElements += ((LSMInvertedIndexDiskComponent)((Object)mergeOp.getMergingComponents().get(i))).getBloomFilter().getNumElements();
                }
                componentBulkLoader = component.createBulkLoader(operation, 1.0f, false, numElements, false, false, false, this.pageWriteCallbackFactory.createPageWriteCallback());
                this.loadDeleteTuples((ILSMIndexOperationContext)opCtx, btreeCursor, mergePred, componentBulkLoader);
            }
            finally {
                btreeCursor.destroy();
            }
        } else {
            componentBulkLoader = component.createBulkLoader(operation, 1.0f, false, 0L, false, false, false, this.pageWriteCallbackFactory.createPageWriteCallback());
        }
        this.search((ILSMIndexOperationContext)opCtx, cursor, (ISearchPredicate)mergePred);
        try {
            while (cursor.hasNext()) {
                cursor.next();
                componentBulkLoader.add(cursor.getTuple());
            }
        }
        finally {
            try {
                cursor.close();
            }
            finally {
                cursor.destroy();
            }
        }
        if (component.getLSMComponentFilter() != null) {
            ArrayList<ITupleReference> filterTuples = new ArrayList<ITupleReference>();
            for (int i = 0; i < mergeOp.getMergingComponents().size(); ++i) {
                ITupleReference min = ((ILSMComponent)mergeOp.getMergingComponents().get(i)).getLSMComponentFilter().getMinTuple();
                ITupleReference max = ((ILSMComponent)mergeOp.getMergingComponents().get(i)).getLSMComponentFilter().getMaxTuple();
                if (min != null) {
                    filterTuples.add(min);
                }
                if (max == null) continue;
                filterTuples.add(max);
            }
            this.getFilterManager().updateFilter(component.getLSMComponentFilter(), filterTuples, (IExtendedModificationOperationCallback)NoOpOperationCallback.INSTANCE);
            this.getFilterManager().writeFilter(component.getLSMComponentFilter(), component.getMetadataHolder());
        }
        componentBulkLoader.end();
        return component;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadDeleteTuples(ILSMIndexOperationContext opCtx, LSMInvertedIndexDeletedKeysBTreeMergeCursor btreeCursor, RangePredicate mergePred, ILSMDiskComponentBulkLoader componentBulkLoader) throws HyracksDataException {
        this.search(opCtx, (IIndexCursor)btreeCursor, (ISearchPredicate)mergePred);
        try {
            while (btreeCursor.hasNext()) {
                btreeCursor.next();
                ITupleReference tuple = btreeCursor.getTuple();
                componentBulkLoader.delete(tuple);
            }
        }
        finally {
            btreeCursor.close();
        }
    }

    protected InMemoryInvertedIndex createInMemoryInvertedIndex(IVirtualBufferCache virtualBufferCache, VirtualFreePageManager virtualFreePageManager, int id) throws HyracksDataException {
        return InvertedIndexUtils.createInMemoryBTreeInvertedindex((IBufferCache)virtualBufferCache, (IPageManager)virtualFreePageManager, this.invListTypeTraits, this.invListCmpFactories, this.tokenTypeTraits, this.tokenCmpFactories, this.tokenizerFactory, this.fullTextConfigEvaluatorFactory, this.ioManager.resolveAbsolutePath(this.fileManager.getBaseDir() + "_virtual_vocab_" + id));
    }

    public ILSMIndexAccessor createAccessor(IIndexAccessParameters iap) throws HyracksDataException {
        return new LSMInvertedIndexAccessor(this.getHarness(), (ILSMIndexOperationContext)this.createOpContext(iap));
    }

    protected LSMInvertedIndexOpContext createOpContext(IIndexAccessParameters iap) throws HyracksDataException {
        return new LSMInvertedIndexOpContext((ILSMIndex)this, this.memoryComponents, iap, this.invertedIndexFieldsForNonBulkLoadOps, this.filterFieldsForNonBulkLoadOps, this.getFilterCmpFactories(), this.tracer);
    }

    @Override
    public ITypeTraits[] getInvListTypeTraits() {
        return this.invListTypeTraits;
    }

    @Override
    public IBinaryComparatorFactory[] getInvListCmpFactories() {
        return this.invListCmpFactories;
    }

    @Override
    public ITypeTraits[] getTokenTypeTraits() {
        return this.tokenTypeTraits;
    }

    @Override
    public IBinaryComparatorFactory[] getTokenCmpFactories() {
        return this.tokenCmpFactories;
    }

    public IBinaryTokenizerFactory getTokenizerFactory() {
        return this.tokenizerFactory;
    }

    public boolean isPrimaryIndex() {
        return false;
    }

    protected LSMComponentFileReferences getMergeFileReferences(ILSMDiskComponent firstComponent, ILSMDiskComponent lastComponent) throws HyracksDataException {
        LSMInvertedIndexDiskComponent first = (LSMInvertedIndexDiskComponent)firstComponent;
        String firstFileName = first.getMetadataHolder().getFileReference().getFile().getName();
        LSMInvertedIndexDiskComponent last = (LSMInvertedIndexDiskComponent)lastComponent;
        String lastFileName = last.getMetadataHolder().getFileReference().getFile().getName();
        return this.fileManager.getRelMergeFileReference(firstFileName, lastFileName);
    }

    protected ILSMIOOperation createFlushOperation(AbstractLSMIndexOperationContext opCtx, LSMComponentFileReferences componentFileRefs, ILSMIOOperationCallback callback) throws HyracksDataException {
        return new LSMInvertedIndexFlushOperation(new LSMInvertedIndexAccessor(this.getHarness(), (ILSMIndexOperationContext)opCtx), componentFileRefs.getInsertIndexFileReference(), componentFileRefs.getDeleteIndexFileReference(), componentFileRefs.getBloomFilterFileReference(), callback, this.getIndexIdentifier());
    }

    protected ILSMIOOperation createMergeOperation(AbstractLSMIndexOperationContext opCtx, LSMComponentFileReferences mergeFileRefs, ILSMIOOperationCallback callback) throws HyracksDataException {
        LSMInvertedIndexAccessor accessor = new LSMInvertedIndexAccessor(this.getHarness(), (ILSMIndexOperationContext)opCtx);
        IndexCursorStats stats = new IndexCursorStats();
        LSMInvertedIndexMergeCursor cursor = new LSMInvertedIndexMergeCursor((ILSMIndexOperationContext)opCtx, (IIndexCursorStats)stats);
        return new LSMInvertedIndexMergeOperation(accessor, (IIndexCursor)cursor, (IIndexCursorStats)stats, mergeFileRefs.getInsertIndexFileReference(), mergeFileRefs.getDeleteIndexFileReference(), mergeFileRefs.getBloomFilterFileReference(), callback, this.getIndexIdentifier());
    }
}

