/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.formats.nontagged;

import java.io.Serializable;
import org.apache.asterix.common.exceptions.ErrorCode;
import org.apache.asterix.common.exceptions.RuntimeDataException;
import org.apache.asterix.dataflow.data.nontagged.comparators.ACirclePartialBinaryComparatorFactory;
import org.apache.asterix.dataflow.data.nontagged.comparators.ADurationPartialBinaryComparatorFactory;
import org.apache.asterix.dataflow.data.nontagged.comparators.AGenericAscBinaryComparatorFactory;
import org.apache.asterix.dataflow.data.nontagged.comparators.AGenericDescBinaryComparatorFactory;
import org.apache.asterix.dataflow.data.nontagged.comparators.AGeometryPartialBinaryComparatorFactory;
import org.apache.asterix.dataflow.data.nontagged.comparators.AIntervalAscPartialBinaryComparatorFactory;
import org.apache.asterix.dataflow.data.nontagged.comparators.AIntervalDescPartialBinaryComparatorFactory;
import org.apache.asterix.dataflow.data.nontagged.comparators.ALinePartialBinaryComparatorFactory;
import org.apache.asterix.dataflow.data.nontagged.comparators.APoint3DPartialBinaryComparatorFactory;
import org.apache.asterix.dataflow.data.nontagged.comparators.APointPartialBinaryComparatorFactory;
import org.apache.asterix.dataflow.data.nontagged.comparators.APolygonPartialBinaryComparatorFactory;
import org.apache.asterix.dataflow.data.nontagged.comparators.ARectanglePartialBinaryComparatorFactory;
import org.apache.asterix.dataflow.data.nontagged.comparators.AUUIDPartialBinaryComparatorFactory;
import org.apache.asterix.formats.nontagged.AnyBinaryComparatorFactory;
import org.apache.asterix.formats.nontagged.OrderedBinaryComparatorFactory;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.asterix.om.types.IAType;
import org.apache.hyracks.algebricks.data.IBinaryComparatorFactoryProvider;
import org.apache.hyracks.api.dataflow.value.IBinaryComparatorFactory;
import org.apache.hyracks.data.std.accessors.BooleanBinaryComparatorFactory;
import org.apache.hyracks.data.std.accessors.ByteArrayBinaryComparatorFactory;
import org.apache.hyracks.data.std.accessors.ByteBinaryComparatorFactory;
import org.apache.hyracks.data.std.accessors.DoubleBinaryComparatorFactory;
import org.apache.hyracks.data.std.accessors.FloatBinaryComparatorFactory;
import org.apache.hyracks.data.std.accessors.IntegerBinaryComparatorFactory;
import org.apache.hyracks.data.std.accessors.LongBinaryComparatorFactory;
import org.apache.hyracks.data.std.accessors.RawBinaryComparatorFactory;
import org.apache.hyracks.data.std.accessors.ShortBinaryComparatorFactory;
import org.apache.hyracks.data.std.accessors.UTF8StringBinaryComparatorFactory;
import org.apache.hyracks.data.std.accessors.UTF8StringLowercaseBinaryComparatorFactory;
import org.apache.hyracks.data.std.accessors.UTF8StringLowercaseTokenBinaryComparatorFactory;

public class BinaryComparatorFactoryProvider
implements IBinaryComparatorFactoryProvider,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final BinaryComparatorFactoryProvider INSTANCE = new BinaryComparatorFactoryProvider();
    public static final IBinaryComparatorFactory BYTE_POINTABLE_INSTANCE = ByteBinaryComparatorFactory.INSTANCE;
    public static final IBinaryComparatorFactory SHORT_POINTABLE_INSTANCE = ShortBinaryComparatorFactory.INSTANCE;
    public static final IBinaryComparatorFactory INTEGER_POINTABLE_INSTANCE = IntegerBinaryComparatorFactory.INSTANCE;
    public static final IBinaryComparatorFactory LONG_POINTABLE_INSTANCE = LongBinaryComparatorFactory.INSTANCE;
    public static final IBinaryComparatorFactory FLOAT_POINTABLE_INSTANCE = FloatBinaryComparatorFactory.INSTANCE;
    public static final IBinaryComparatorFactory DOUBLE_POINTABLE_INSTANCE = DoubleBinaryComparatorFactory.INSTANCE;
    public static final IBinaryComparatorFactory UTF8STRING_POINTABLE_INSTANCE = UTF8StringBinaryComparatorFactory.INSTANCE;
    public static final IBinaryComparatorFactory UTF8STRING_LOWERCASE_POINTABLE_INSTANCE = UTF8StringLowercaseBinaryComparatorFactory.INSTANCE;
    public static final IBinaryComparatorFactory UTF8STRING_LOWERCASE_TOKEN_POINTABLE_INSTANCE = UTF8StringLowercaseTokenBinaryComparatorFactory.INSTANCE;
    public static final IBinaryComparatorFactory BINARY_POINTABLE_INSTANCE = ByteArrayBinaryComparatorFactory.INSTANCE;

    private BinaryComparatorFactoryProvider() {
    }

    public IBinaryComparatorFactory getBinaryComparatorFactory(Object type, boolean ascending, boolean ignoreCase) {
        return this.getBinaryComparatorFactory(type, type, ascending, ignoreCase);
    }

    public IBinaryComparatorFactory getBinaryComparatorFactory(Object type, boolean ascending) {
        return this.getBinaryComparatorFactory(type, type, ascending);
    }

    public IBinaryComparatorFactory getBinaryComparatorFactory(Object leftType, Object rightType, boolean ascending, boolean ignoreCase) {
        IAType left = (IAType)leftType;
        IAType right = (IAType)rightType;
        if (left.getTypeTag() == ATypeTag.STRING && right.getTypeTag() == ATypeTag.STRING && ignoreCase) {
            return this.addOffset(UTF8STRING_LOWERCASE_POINTABLE_INSTANCE, ascending);
        }
        if (BinaryComparatorFactoryProvider.isShortWithoutTag(left, right)) {
            return SHORT_POINTABLE_INSTANCE;
        }
        return this.createGenericBinaryComparatorFactory(left, right, ascending);
    }

    public IBinaryComparatorFactory getBinaryComparatorFactory(Object leftType, Object rightType, boolean ascending) {
        if (BinaryComparatorFactoryProvider.isShortWithoutTag((IAType)leftType, (IAType)rightType)) {
            return SHORT_POINTABLE_INSTANCE;
        }
        return this.createGenericBinaryComparatorFactory((IAType)leftType, (IAType)rightType, ascending);
    }

    public IBinaryComparatorFactory getBinaryComparatorFactory(ATypeTag type, boolean ascending) throws RuntimeDataException {
        switch (type) {
            case ANY: {
                return this.createGenericBinaryComparatorFactory(BuiltinType.ANY, BuiltinType.ANY, ascending);
            }
            case UNION: {
                throw new RuntimeDataException(ErrorCode.TYPE_UNSUPPORTED, new Serializable[]{"Comparator", type});
            }
            case NULL: 
            case MISSING: {
                return new AnyBinaryComparatorFactory();
            }
            case BOOLEAN: {
                return this.addOffset((IBinaryComparatorFactory)BooleanBinaryComparatorFactory.INSTANCE, ascending);
            }
            case TINYINT: {
                return this.addOffset(BYTE_POINTABLE_INSTANCE, ascending);
            }
            case SMALLINT: {
                return this.addOffset(SHORT_POINTABLE_INSTANCE, ascending);
            }
            case DATE: 
            case TIME: 
            case YEARMONTHDURATION: 
            case INTEGER: {
                return this.addOffset(INTEGER_POINTABLE_INSTANCE, ascending);
            }
            case DATETIME: 
            case DAYTIMEDURATION: 
            case BIGINT: {
                return this.addOffset(LONG_POINTABLE_INSTANCE, ascending);
            }
            case FLOAT: {
                return this.addOffset(FLOAT_POINTABLE_INSTANCE, ascending);
            }
            case DOUBLE: {
                return this.addOffset(DOUBLE_POINTABLE_INSTANCE, ascending);
            }
            case STRING: {
                return this.addOffset(UTF8STRING_POINTABLE_INSTANCE, ascending);
            }
            case RECTANGLE: {
                return this.addOffset(ARectanglePartialBinaryComparatorFactory.INSTANCE, ascending);
            }
            case CIRCLE: {
                return this.addOffset(ACirclePartialBinaryComparatorFactory.INSTANCE, ascending);
            }
            case POINT: {
                return this.addOffset(APointPartialBinaryComparatorFactory.INSTANCE, ascending);
            }
            case POINT3D: {
                return this.addOffset(APoint3DPartialBinaryComparatorFactory.INSTANCE, ascending);
            }
            case LINE: {
                return this.addOffset(ALinePartialBinaryComparatorFactory.INSTANCE, ascending);
            }
            case POLYGON: {
                return this.addOffset(APolygonPartialBinaryComparatorFactory.INSTANCE, ascending);
            }
            case GEOMETRY: {
                return this.addOffset(AGeometryPartialBinaryComparatorFactory.INSTANCE, ascending);
            }
            case DURATION: {
                return this.addOffset(ADurationPartialBinaryComparatorFactory.INSTANCE, ascending);
            }
            case INTERVAL: {
                return this.addOffset(this.intervalBinaryComparatorFactory(ascending), ascending);
            }
            case UUID: {
                return this.addOffset(AUUIDPartialBinaryComparatorFactory.INSTANCE, ascending);
            }
            case BINARY: {
                return this.addOffset(BINARY_POINTABLE_INSTANCE, ascending);
            }
        }
        return this.addOffset(RawBinaryComparatorFactory.INSTANCE, ascending);
    }

    private IBinaryComparatorFactory addOffset(IBinaryComparatorFactory inst, boolean ascending) {
        return new OrderedBinaryComparatorFactory(inst, ascending);
    }

    private IBinaryComparatorFactory createGenericBinaryComparatorFactory(IAType leftType, IAType rightType, boolean ascending) {
        if (ascending) {
            return new AGenericAscBinaryComparatorFactory(leftType, rightType);
        }
        return new AGenericDescBinaryComparatorFactory(leftType, rightType);
    }

    private IBinaryComparatorFactory intervalBinaryComparatorFactory(boolean ascending) {
        if (ascending) {
            return AIntervalAscPartialBinaryComparatorFactory.INSTANCE;
        }
        return AIntervalDescPartialBinaryComparatorFactory.INSTANCE;
    }

    private static boolean isShortWithoutTag(IAType left, IAType right) {
        ATypeTag leftTag = left.getTypeTag();
        ATypeTag rightTag = right.getTypeTag();
        if (leftTag != ATypeTag.SHORTWITHOUTTYPEINFO && rightTag != ATypeTag.SHORTWITHOUTTYPEINFO) {
            return false;
        }
        if (leftTag != rightTag) {
            throw new IllegalStateException();
        }
        return true;
    }
}

