/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.evaluators.constructors;

import java.io.DataOutput;
import java.io.IOException;
import org.apache.asterix.common.annotations.MissingNullInOutFunction;
import org.apache.asterix.formats.nontagged.SerializerDeserializerProvider;
import org.apache.asterix.om.base.AMutablePoint;
import org.apache.asterix.om.base.APoint;
import org.apache.asterix.om.functions.BuiltinFunctions;
import org.apache.asterix.om.functions.IFunctionDescriptor;
import org.apache.asterix.om.functions.IFunctionDescriptorFactory;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.asterix.runtime.evaluators.base.AbstractScalarFunctionDynamicDescriptor;
import org.apache.asterix.runtime.evaluators.functions.PointableHelper;
import org.apache.asterix.runtime.exceptions.InvalidDataFormatException;
import org.apache.asterix.runtime.exceptions.TypeMismatchException;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;
import org.apache.hyracks.algebricks.runtime.base.IEvaluatorContext;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluator;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluatorFactory;
import org.apache.hyracks.api.dataflow.value.ISerializerDeserializer;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.primitive.UTF8StringPointable;
import org.apache.hyracks.data.std.primitive.VoidPointable;
import org.apache.hyracks.data.std.util.ArrayBackedValueStorage;
import org.apache.hyracks.dataflow.common.data.accessors.IFrameTupleReference;

@MissingNullInOutFunction
public class APointConstructorDescriptor
extends AbstractScalarFunctionDynamicDescriptor {
    private static final long serialVersionUID = 1L;
    public static final IFunctionDescriptorFactory FACTORY = new IFunctionDescriptorFactory(){

        public IFunctionDescriptor createFunctionDescriptor() {
            return new APointConstructorDescriptor();
        }
    };

    public IScalarEvaluatorFactory createEvaluatorFactory(final IScalarEvaluatorFactory[] args) {
        return new IScalarEvaluatorFactory(){
            private static final long serialVersionUID = 1L;

            public IScalarEvaluator createScalarEvaluator(final IEvaluatorContext ctx) throws HyracksDataException {
                return new IScalarEvaluator(){
                    private ArrayBackedValueStorage resultStorage = new ArrayBackedValueStorage();
                    private DataOutput out = this.resultStorage.getDataOutput();
                    private IPointable inputArg = new VoidPointable();
                    private IScalarEvaluator eval;
                    private AMutablePoint aPoint;
                    private ISerializerDeserializer<APoint> pointSerde;
                    private final UTF8StringPointable utf8Ptr;
                    {
                        this.eval = args[0].createScalarEvaluator(ctx);
                        this.aPoint = new AMutablePoint(0.0, 0.0);
                        this.pointSerde = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.APOINT);
                        this.utf8Ptr = new UTF8StringPointable();
                    }

                    public void evaluate(IFrameTupleReference tuple, IPointable result) throws HyracksDataException {
                        block5: {
                            try {
                                this.eval.evaluate(tuple, this.inputArg);
                                if (PointableHelper.checkAndSetMissingOrNull(result, this.inputArg)) {
                                    return;
                                }
                                byte[] serString = this.inputArg.getByteArray();
                                int offset = this.inputArg.getStartOffset();
                                int len = this.inputArg.getLength();
                                byte tt = serString[offset];
                                if (tt == ATypeTag.SERIALIZED_POINT_TYPE_TAG) {
                                    result.set((IValueReference)this.inputArg);
                                    break block5;
                                }
                                if (tt == ATypeTag.SERIALIZED_STRING_TYPE_TAG) {
                                    this.resultStorage.reset();
                                    this.utf8Ptr.set(serString, offset + 1, len - 1);
                                    String s = this.utf8Ptr.toString();
                                    this.aPoint.setValue(Double.parseDouble(s.substring(0, s.indexOf(44))), Double.parseDouble(s.substring(s.indexOf(44) + 1, s.length())));
                                    this.pointSerde.serialize((Object)this.aPoint, this.out);
                                    result.set((IValueReference)this.resultStorage);
                                    break block5;
                                }
                                throw new TypeMismatchException(APointConstructorDescriptor.this.sourceLoc, APointConstructorDescriptor.this.getIdentifier(), 0, tt, ATypeTag.SERIALIZED_STRING_TYPE_TAG);
                            }
                            catch (IOException e) {
                                throw new InvalidDataFormatException(APointConstructorDescriptor.this.sourceLoc, APointConstructorDescriptor.this.getIdentifier(), e, ATypeTag.SERIALIZED_POINT_TYPE_TAG);
                            }
                        }
                    }
                };
            }
        };
    }

    public FunctionIdentifier getIdentifier() {
        return BuiltinFunctions.POINT_CONSTRUCTOR;
    }
}

