/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.evaluators.functions.records;

import java.io.DataOutput;
import java.io.IOException;
import java.util.List;
import org.apache.asterix.builders.RecordBuilder;
import org.apache.asterix.om.pointables.ARecordVisitablePointable;
import org.apache.asterix.om.pointables.base.DefaultOpenFieldType;
import org.apache.asterix.om.pointables.base.IVisitablePointable;
import org.apache.asterix.om.pointables.cast.ACastVisitor;
import org.apache.asterix.om.pointables.visitor.IVisitablePointableVisitor;
import org.apache.asterix.om.types.ARecordType;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.IAType;
import org.apache.asterix.runtime.evaluators.functions.PointableHelper;
import org.apache.hyracks.algebricks.common.utils.Triple;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluator;
import org.apache.hyracks.api.dataflow.value.IBinaryComparator;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.accessors.UTF8StringBinaryComparatorFactory;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.primitive.UTF8StringPointable;
import org.apache.hyracks.data.std.primitive.VoidPointable;
import org.apache.hyracks.data.std.util.ArrayBackedValueStorage;
import org.apache.hyracks.dataflow.common.data.accessors.IFrameTupleReference;

class RecordRenameEvaluator
implements IScalarEvaluator {
    private final IPointable inputRecordPointable = new VoidPointable();
    private final UTF8StringPointable oldFieldNamePointable = new UTF8StringPointable();
    private final UTF8StringPointable newFieldNamePointable = new UTF8StringPointable();
    private final IBinaryComparator stringBinaryComparator = UTF8StringBinaryComparatorFactory.INSTANCE.createBinaryComparator();
    private final ArrayBackedValueStorage resultStorage = new ArrayBackedValueStorage();
    private final DataOutput resultOutput = this.resultStorage.getDataOutput();
    private final RecordBuilder outRecordBuilder = new RecordBuilder();
    private final IScalarEvaluator eval0;
    private final IScalarEvaluator eval1;
    private final IScalarEvaluator eval2;
    private final ARecordVisitablePointable openRecordPointable;
    private ARecordVisitablePointable inputRecordVisitable;
    private boolean requiresCast = false;
    private ACastVisitor castVisitor;
    private Triple<IVisitablePointable, IAType, Boolean> castVisitorArg;

    RecordRenameEvaluator(IScalarEvaluator eval0, IScalarEvaluator eval1, IScalarEvaluator eval2, ARecordType recordType) {
        this.eval0 = eval0;
        this.eval1 = eval1;
        this.eval2 = eval2;
        this.openRecordPointable = new ARecordVisitablePointable(DefaultOpenFieldType.NESTED_OPEN_RECORD_TYPE);
        if (recordType != null) {
            this.inputRecordVisitable = new ARecordVisitablePointable(recordType);
            if (this.hasDerivedType(recordType.getFieldTypes())) {
                this.requiresCast = true;
                this.castVisitor = new ACastVisitor();
                this.castVisitorArg = new Triple((Object)this.openRecordPointable, (Object)this.openRecordPointable.getInputRecordType(), (Object)Boolean.FALSE);
            }
        }
    }

    public void evaluate(IFrameTupleReference tuple, IPointable result) throws HyracksDataException {
        int offset;
        this.resultStorage.reset();
        boolean returnNull = false;
        this.eval0.evaluate(tuple, this.inputRecordPointable);
        this.eval1.evaluate(tuple, (IPointable)this.oldFieldNamePointable);
        this.eval2.evaluate(tuple, (IPointable)this.newFieldNamePointable);
        if (PointableHelper.checkAndSetMissingOrNull(result, this.inputRecordPointable, (IPointable)this.oldFieldNamePointable, (IPointable)this.newFieldNamePointable)) {
            return;
        }
        byte[] data = this.inputRecordPointable.getByteArray();
        byte typeTag = data[offset = this.inputRecordPointable.getStartOffset()];
        if (typeTag != ATypeTag.SERIALIZED_RECORD_TYPE_TAG) {
            returnNull = true;
        }
        if ((typeTag = (data = this.oldFieldNamePointable.getByteArray())[offset = this.oldFieldNamePointable.getStartOffset()]) != ATypeTag.SERIALIZED_STRING_TYPE_TAG) {
            returnNull = true;
        }
        if ((typeTag = (data = this.newFieldNamePointable.getByteArray())[offset = this.newFieldNamePointable.getStartOffset()]) != ATypeTag.SERIALIZED_STRING_TYPE_TAG) {
            returnNull = true;
        }
        if (returnNull) {
            PointableHelper.setNull(result);
            return;
        }
        this.evaluate();
        result.set((IValueReference)this.resultStorage);
    }

    private void evaluate() throws HyracksDataException {
        this.resultStorage.reset();
        try {
            ARecordVisitablePointable inputRecord = this.getInputRecordVisitablePointable();
            this.buildOutputRecord(inputRecord);
        }
        catch (IOException e) {
            throw HyracksDataException.create((Throwable)e);
        }
    }

    private void buildOutputRecord(ARecordVisitablePointable inputRecord) throws HyracksDataException {
        this.outRecordBuilder.reset(DefaultOpenFieldType.NESTED_OPEN_RECORD_TYPE);
        this.outRecordBuilder.init();
        List fieldNames = inputRecord.getFieldNames();
        List fieldValues = inputRecord.getFieldValues();
        int fieldCount = fieldNames.size();
        for (int i = 0; i < fieldCount; ++i) {
            IVisitablePointable fieldName = (IVisitablePointable)fieldNames.get(i);
            if (!PointableHelper.isEqual((IValueReference)fieldName, (IValueReference)this.oldFieldNamePointable, this.stringBinaryComparator)) {
                this.outRecordBuilder.addField((IValueReference)fieldName, (IValueReference)fieldValues.get(i));
                continue;
            }
            this.outRecordBuilder.addField((IValueReference)this.newFieldNamePointable, (IValueReference)fieldValues.get(i));
        }
        this.outRecordBuilder.write(this.resultOutput, true);
    }

    private ARecordVisitablePointable getInputRecordVisitablePointable() throws HyracksDataException {
        this.inputRecordVisitable.set((IValueReference)this.inputRecordPointable);
        if (this.requiresCast) {
            return this.castToOpenRecord();
        }
        return this.inputRecordVisitable;
    }

    private boolean hasDerivedType(IAType[] types) {
        for (IAType type : types) {
            if (!type.getTypeTag().isDerivedType()) continue;
            return true;
        }
        return false;
    }

    private ARecordVisitablePointable castToOpenRecord() throws HyracksDataException {
        this.inputRecordVisitable.accept((IVisitablePointableVisitor)this.castVisitor, this.castVisitorArg);
        return this.openRecordPointable;
    }
}

