/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.http.policy;

import com.azure.core.credential.AzureSasCredential;
import com.azure.core.http.HttpPipelineCallContext;
import com.azure.core.http.HttpPipelineNextPolicy;
import com.azure.core.http.HttpRequest;
import com.azure.core.http.HttpResponse;
import com.azure.core.http.policy.HttpPipelinePolicy;
import java.util.Objects;
import reactor.core.publisher.Mono;

public final class AzureSasCredentialPolicy
implements HttpPipelinePolicy {
    private final AzureSasCredential credential;
    private final boolean requireHttps;

    public AzureSasCredentialPolicy(AzureSasCredential credential) {
        this(credential, true);
    }

    public AzureSasCredentialPolicy(AzureSasCredential credential, boolean requireHttps) {
        Objects.requireNonNull(credential, "'credential' cannot be null.");
        this.credential = credential;
        this.requireHttps = requireHttps;
    }

    @Override
    public Mono<HttpResponse> process(HttpPipelineCallContext context, HttpPipelineNextPolicy next) {
        HttpRequest httpRequest = context.getHttpRequest();
        if (this.requireHttps && "http".equals(httpRequest.getUrl().getProtocol())) {
            return Mono.error((Throwable)new IllegalStateException("Shared access signature credentials require HTTPS to prevent leaking the shared access signature."));
        }
        String signature = this.credential.getSignature();
        if (signature.startsWith("?")) {
            signature = signature.substring(1);
        }
        String query = httpRequest.getUrl().getQuery();
        String url = httpRequest.getUrl().toString();
        url = query == null || query.isEmpty() ? (url.endsWith("?") ? url + signature : url + "?" + signature) : url + "&" + signature;
        httpRequest.setUrl(url);
        return next.process();
    }
}

