/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ha;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.InetSocketAddress;
import java.nio.charset.StandardCharsets;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.ha.BadFencingConfigurationException;
import org.apache.hadoop.ha.FenceMethod;
import org.apache.hadoop.ha.HAServiceTarget;
import org.apache.hadoop.ha.StreamPumper;
import org.apache.hadoop.util.StringUtils;

public class PowerShellFencer
extends Configured
implements FenceMethod {
    private static final Log LOG = LogFactory.getLog(PowerShellFencer.class);

    @Override
    public void checkArgs(String argStr) throws BadFencingConfigurationException {
        LOG.info((Object)("The parameter for the PowerShell fencer is " + argStr));
    }

    @Override
    public boolean tryFence(HAServiceTarget target, String argsStr) throws BadFencingConfigurationException {
        String processName = argsStr;
        InetSocketAddress serviceAddr = target.getAddress();
        String hostname = serviceAddr.getHostName();
        String ps1script = this.buildPSScript(processName, hostname);
        if (ps1script == null) {
            LOG.error((Object)"Cannot build PowerShell script");
            return false;
        }
        LOG.info((Object)("Executing " + ps1script));
        ProcessBuilder builder = new ProcessBuilder("powershell.exe", ps1script);
        Process p = null;
        try {
            p = builder.start();
            p.getOutputStream().close();
        }
        catch (IOException e) {
            LOG.warn((Object)("Unable to execute " + ps1script), (Throwable)e);
            return false;
        }
        StreamPumper errPumper = new StreamPumper(LOG, "fencer", p.getErrorStream(), StreamPumper.StreamType.STDERR);
        errPumper.start();
        StreamPumper outPumper = new StreamPumper(LOG, "fencer", p.getInputStream(), StreamPumper.StreamType.STDOUT);
        outPumper.start();
        int rc = 0;
        try {
            rc = p.waitFor();
            errPumper.join();
            outPumper.join();
        }
        catch (InterruptedException ie) {
            LOG.warn((Object)("Interrupted while waiting for fencing command: " + ps1script));
            return false;
        }
        return rc == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String buildPSScript(String processName, String host) {
        LOG.info((Object)("Building PowerShell script to kill " + processName + " at " + host));
        String ps1script = null;
        BufferedWriter writer = null;
        try {
            File file = File.createTempFile("temp-fence-command", ".ps1");
            file.deleteOnExit();
            FileOutputStream fos = new FileOutputStream(file, false);
            OutputStreamWriter osw = new OutputStreamWriter((OutputStream)fos, StandardCharsets.UTF_8);
            writer = new BufferedWriter(osw);
            String filter = StringUtils.join((CharSequence)" and ", new String[]{"Name LIKE '%java.exe%'", "CommandLine LIKE '%" + processName + "%'"});
            String cmd = "Get-WmiObject Win32_Process";
            cmd = cmd + " -Filter \"" + filter + "\"";
            cmd = cmd + " -Computer " + host;
            cmd = cmd + " |% { $_.Terminate() }";
            LOG.info((Object)("PowerShell command: " + cmd));
            writer.write(cmd);
            writer.flush();
            ps1script = file.getAbsolutePath();
        }
        catch (IOException ioe) {
            LOG.error((Object)"Cannot create PowerShell script", (Throwable)ioe);
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException ioe) {
                    LOG.error((Object)"Cannot close PowerShell script", (Throwable)ioe);
                }
            }
        }
        return ps1script;
    }
}

