/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.lsm.invertedindex.inmemory;

import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import org.apache.hyracks.api.dataflow.value.ISerializerDeserializer;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.primitive.IntegerPointable;
import org.apache.hyracks.dataflow.common.comm.io.ArrayTupleBuilder;
import org.apache.hyracks.dataflow.common.comm.io.ArrayTupleReference;
import org.apache.hyracks.dataflow.common.data.accessors.ITupleReference;
import org.apache.hyracks.dataflow.common.data.accessors.PermutingTupleReference;
import org.apache.hyracks.dataflow.common.utils.TupleUtils;
import org.apache.hyracks.storage.am.btree.impls.BTree;
import org.apache.hyracks.storage.am.btree.impls.RangePredicate;
import org.apache.hyracks.storage.am.common.tuples.ConcatenatingTupleReference;
import org.apache.hyracks.storage.am.lsm.invertedindex.api.IInvertedListCursor;
import org.apache.hyracks.storage.am.lsm.invertedindex.impls.AbstractInvertedListCursor;
import org.apache.hyracks.storage.common.IIndexCursor;
import org.apache.hyracks.storage.common.ISearchPredicate;
import org.apache.hyracks.storage.common.MultiComparator;

public class InMemoryInvertedListCursor
extends AbstractInvertedListCursor {
    private RangePredicate btreePred;
    private BTree.BTreeAccessor btreeAccessor;
    private IIndexCursor btreeCursor;
    private boolean cursorNeedsClose = false;
    private IIndexCursor countingCursor;
    private MultiComparator tokenFieldsCmp;
    private MultiComparator btreeCmp;
    private final PermutingTupleReference resultTuple;
    private final ConcatenatingTupleReference btreeSearchTuple;
    private final ArrayTupleBuilder tokenTupleBuilder;
    private final ArrayTupleReference tokenTuple = new ArrayTupleReference();
    private int numElements = -1;

    public InMemoryInvertedListCursor(int invListFieldCount, int tokenFieldCount) {
        int[] fieldPermutation = new int[invListFieldCount];
        for (int i = 0; i < invListFieldCount; ++i) {
            fieldPermutation[i] = tokenFieldCount + i;
        }
        this.resultTuple = new PermutingTupleReference(fieldPermutation);
        this.btreeSearchTuple = new ConcatenatingTupleReference(2);
        this.tokenTupleBuilder = new ArrayTupleBuilder(tokenFieldCount);
    }

    public void prepare(BTree.BTreeAccessor btreeAccessor, RangePredicate btreePred, MultiComparator tokenFieldsCmp, MultiComparator btreeCmp) throws HyracksDataException {
        if (this.btreeAccessor != btreeAccessor) {
            this.btreeAccessor = btreeAccessor;
            this.btreeCursor = btreeAccessor.createSearchCursor(false);
            this.countingCursor = btreeAccessor.createCountingSearchCursor();
            this.btreePred = btreePred;
            this.btreePred.setLowKeyComparator(tokenFieldsCmp);
            this.btreePred.setHighKeyComparator(tokenFieldsCmp);
            this.tokenFieldsCmp = tokenFieldsCmp;
            this.btreeCmp = btreeCmp;
        }
    }

    @Override
    public int compareTo(IInvertedListCursor cursor) {
        try {
            return this.size() - cursor.size();
        }
        catch (HyracksDataException hde) {
            throw new IllegalStateException(hde);
        }
    }

    public void reset(ITupleReference tuple) throws HyracksDataException {
        this.numElements = -1;
        TupleUtils.copyTuple((ArrayTupleBuilder)this.tokenTupleBuilder, (ITupleReference)tuple, (int)tuple.getFieldCount());
        this.tokenTuple.reset(this.tokenTupleBuilder.getFieldEndOffsets(), this.tokenTupleBuilder.getByteArray());
        this.btreeSearchTuple.reset();
        this.btreeSearchTuple.addTuple((ITupleReference)this.tokenTuple);
        this.btreeCursor.close();
        this.countingCursor.close();
    }

    @Override
    protected void setInvListInfo(int startPageId, int endPageId, int startOff, int numElements) throws HyracksDataException {
    }

    @Override
    public void loadPages() throws HyracksDataException {
        this.btreePred.setLowKeyComparator(this.tokenFieldsCmp);
        this.btreePred.setHighKeyComparator(this.tokenFieldsCmp);
        this.btreePred.setLowKey((ITupleReference)this.tokenTuple, true);
        this.btreePred.setHighKey((ITupleReference)this.tokenTuple, true);
        this.btreeAccessor.search(this.btreeCursor, (ISearchPredicate)this.btreePred);
        this.cursorNeedsClose = true;
    }

    @Override
    public void unloadPages() throws HyracksDataException {
        if (this.cursorNeedsClose) {
            this.btreeCursor.close();
            this.cursorNeedsClose = false;
        }
    }

    public boolean doHasNext() throws HyracksDataException {
        return this.btreeCursor.hasNext();
    }

    public void doNext() throws HyracksDataException {
        this.btreeCursor.next();
    }

    public ITupleReference doGetTuple() {
        this.resultTuple.reset(this.btreeCursor.getTuple());
        return this.resultTuple;
    }

    @Override
    public int size() throws HyracksDataException {
        if (this.numElements < 0) {
            this.btreePred.setLowKeyComparator(this.tokenFieldsCmp);
            this.btreePred.setHighKeyComparator(this.tokenFieldsCmp);
            this.btreePred.setLowKey((ITupleReference)this.tokenTuple, true);
            this.btreePred.setHighKey((ITupleReference)this.tokenTuple, true);
            this.btreeAccessor.search(this.countingCursor, (ISearchPredicate)this.btreePred);
            try {
                while (this.countingCursor.hasNext()) {
                    this.countingCursor.next();
                    ITupleReference countTuple = this.countingCursor.getTuple();
                    this.numElements = IntegerPointable.getInteger((byte[])countTuple.getFieldData(0), (int)countTuple.getFieldStart(0));
                }
            }
            finally {
                this.countingCursor.close();
            }
        }
        return this.numElements;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsKey(ITupleReference searchTuple, MultiComparator invListCmp) throws HyracksDataException {
        this.unloadPages();
        this.btreeSearchTuple.addTuple(searchTuple);
        this.btreePred.setLowKeyComparator(this.btreeCmp);
        this.btreePred.setHighKeyComparator(this.btreeCmp);
        this.btreePred.setLowKey((ITupleReference)this.btreeSearchTuple, true);
        this.btreePred.setHighKey((ITupleReference)this.btreeSearchTuple, true);
        try {
            this.btreeAccessor.search(this.btreeCursor, (ISearchPredicate)this.btreePred);
            this.cursorNeedsClose = true;
        }
        catch (Exception e) {
            this.btreeSearchTuple.removeLastTuple();
            throw HyracksDataException.create((Throwable)e);
        }
        boolean containsKey = false;
        try {
            containsKey = this.btreeCursor.hasNext();
        }
        finally {
            this.btreeCursor.close();
            this.btreeSearchTuple.removeLastTuple();
        }
        return containsKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String printInvList(ISerializerDeserializer[] serdes) throws HyracksDataException {
        StringBuilder strBuilder = new StringBuilder();
        try {
            while (this.btreeCursor.hasNext()) {
                this.btreeCursor.next();
                ITupleReference tuple = this.btreeCursor.getTuple();
                ByteArrayInputStream inStream = new ByteArrayInputStream(tuple.getFieldData(1), tuple.getFieldStart(1), tuple.getFieldLength(1));
                DataInputStream dataIn = new DataInputStream(inStream);
                Object o = serdes[0].deserialize((DataInput)dataIn);
                strBuilder.append(o.toString() + " ");
            }
        }
        finally {
            this.btreeCursor.close();
        }
        this.btreeAccessor.search(this.btreeCursor, (ISearchPredicate)this.btreePred);
        return strBuilder.toString();
    }

    @Override
    public String printCurrentElement(ISerializerDeserializer[] serdes) throws HyracksDataException {
        return null;
    }

    @Override
    public void prepareLoadPages() throws HyracksDataException {
    }

    public void doClose() throws HyracksDataException {
        this.btreeCursor.close();
    }

    public void doDestroy() throws HyracksDataException {
        this.btreeCursor.destroy();
    }
}

