/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.lsm.invertedindex.tokenizers;

import java.io.DataOutput;
import java.io.IOException;
import org.apache.hyracks.data.std.util.GrowableArray;
import org.apache.hyracks.data.std.util.UTF8StringBuilder;
import org.apache.hyracks.storage.am.lsm.invertedindex.tokenizers.IToken;
import org.apache.hyracks.util.string.UTF8StringUtil;

public abstract class AbstractUTF8Token
implements IToken {
    public static final int GOLDEN_RATIO_32 = -1640531527;
    protected byte[] data;
    protected int startOffset;
    protected int endOffset;
    protected int tokenLength;
    protected int tokenCount;
    protected final byte tokenTypeTag;
    protected final byte countTypeTag;

    public AbstractUTF8Token() {
        this.tokenTypeTag = (byte)-1;
        this.countTypeTag = (byte)-1;
    }

    public AbstractUTF8Token(byte tokenTypeTag, byte countTypeTag) {
        this.tokenTypeTag = tokenTypeTag;
        this.countTypeTag = countTypeTag;
    }

    @Override
    public byte[] getData() {
        return this.data;
    }

    @Override
    public int getEndOffset() {
        return this.endOffset;
    }

    public int getLowerCaseUTF8Len(int limit) {
        int lowerCaseUTF8Len = 0;
        int pos = this.startOffset;
        for (int i = 0; i < limit; ++i) {
            char c = Character.toLowerCase(UTF8StringUtil.charAt((byte[])this.data, (int)pos));
            lowerCaseUTF8Len += UTF8StringUtil.getModifiedUTF8Len((char)c);
            pos += UTF8StringUtil.charSize((byte[])this.data, (int)pos);
        }
        return lowerCaseUTF8Len;
    }

    @Override
    public int getStartOffset() {
        return this.startOffset;
    }

    @Override
    public int getTokenLength() {
        return this.tokenLength;
    }

    public void handleCountTypeTag(DataOutput dos) throws IOException {
        if (this.countTypeTag > 0) {
            dos.write(this.countTypeTag);
        }
    }

    public void handleTokenTypeTag(DataOutput dos) throws IOException {
        if (this.tokenTypeTag > 0) {
            dos.write(this.tokenTypeTag);
        }
    }

    @Override
    public void reset(byte[] data, int startOffset, int endOffset, int tokenLength, int tokenCount) {
        this.data = data;
        this.startOffset = startOffset;
        this.endOffset = endOffset;
        this.tokenLength = tokenLength;
        this.tokenCount = tokenCount;
    }

    @Override
    public void serializeTokenCount(GrowableArray out) throws IOException {
        this.handleCountTypeTag(out.getDataOutput());
        out.getDataOutput().writeInt(this.tokenCount);
    }

    protected void serializeToken(UTF8StringBuilder builder, GrowableArray out, int numPreChars, int numPostChars, char preChar, char postChar) throws IOException {
        int i;
        this.handleTokenTypeTag(out.getDataOutput());
        assert (UTF8StringUtil.getModifiedUTF8Len((char)preChar) == 1 && UTF8StringUtil.getModifiedUTF8Len((char)postChar) == 1);
        int actualUtfLen = this.endOffset - this.startOffset;
        builder.reset(out, actualUtfLen + numPreChars + numPostChars);
        for (int i2 = 0; i2 < numPreChars; ++i2) {
            builder.appendChar(preChar);
        }
        int numRegChars = this.tokenLength - numPreChars - numPostChars;
        int pos = this.startOffset;
        for (i = 0; i < numRegChars; ++i) {
            char c = Character.toLowerCase(UTF8StringUtil.charAt((byte[])this.data, (int)pos));
            builder.appendChar(c);
            pos += UTF8StringUtil.charSize((byte[])this.data, (int)pos);
        }
        for (i = 0; i < numPostChars; ++i) {
            builder.appendChar(postChar);
        }
        builder.finish();
    }
}

