/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.util;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.io.Writer;
import java.util.List;
import java.util.Map;
import java.util.stream.DoubleStream;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import java.util.stream.Stream;

public class JSONUtil {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private static final ObjectMapper SORTED_MAPPER = new ObjectMapper();

    private JSONUtil() {
    }

    public static String convertNode(JsonNode node) throws JsonProcessingException {
        return SORTED_MAPPER.writeValueAsString(SORTED_MAPPER.treeToValue((TreeNode)node, Object.class));
    }

    public static String convertNodeOrThrow(JsonNode node) {
        try {
            return JSONUtil.convertNode(node);
        }
        catch (JsonProcessingException e) {
            throw new IllegalStateException(e);
        }
    }

    public static void writeNode(Writer writer, JsonNode node) throws IOException {
        SORTED_MAPPER.writeValue(writer, SORTED_MAPPER.treeToValue((TreeNode)node, Object.class));
    }

    public static String quoteAndEscape(String str) {
        return JSONUtil.quoteAndEscape(new StringBuilder(), str).toString();
    }

    public static StringBuilder quoteAndEscape(StringBuilder sb, String str) {
        return JSONUtil.escape(sb.append('\"'), str).append('\"');
    }

    public static String escape(String str) {
        return JSONUtil.escape(new StringBuilder(), str).toString();
    }

    public static StringBuilder escape(StringBuilder sb, String str) {
        for (int i = 0; i < str.length(); ++i) {
            JSONUtil.appendEsc(sb, str.charAt(i));
        }
        return sb;
    }

    private static StringBuilder appendEsc(StringBuilder sb, char c) {
        CharSequence cs = JSONUtil.esc(c);
        return cs != null ? sb.append(cs) : sb.append(c);
    }

    public static CharSequence esc(char c) {
        switch (c) {
            case '\"': {
                return "\\\"";
            }
            case '\\': {
                return "\\\\";
            }
            case '/': {
                return "\\/";
            }
            case '\b': {
                return "\\b";
            }
            case '\n': {
                return "\\n";
            }
            case '\f': {
                return "\\f";
            }
            case '\r': {
                return "\\r";
            }
            case '\t': {
                return "\\t";
            }
        }
        return null;
    }

    public static String fromMap(Map<String, Object> map) {
        StringBuilder aString = new StringBuilder();
        aString.append("{ ");
        boolean first = true;
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            if (!first) {
                aString.append(", ");
            }
            aString.append("\"");
            aString.append(entry.getKey());
            aString.append("\"");
            aString.append(" : ");
            Object value = entry.getValue();
            if (value instanceof String) {
                String strValue = (String)value;
                if (strValue.startsWith("{") || strValue.startsWith("[")) {
                    aString.append(value);
                } else {
                    aString.append("\"");
                    aString.append(value);
                    aString.append("\"");
                }
            } else {
                aString.append(value);
            }
            first = false;
        }
        aString.append(" }");
        return aString.toString();
    }

    public static void put(ObjectNode o, String name, int value) {
        o.put(name, value);
    }

    public static void put(ObjectNode o, String name, String value) {
        o.put(name, value);
    }

    public static void put(ObjectNode o, String name, long value) {
        o.put(name, value);
    }

    public static void put(ObjectNode o, String name, double value) {
        o.put(name, value);
    }

    public static void put(ObjectNode o, String name, long[] elements) {
        LongStream.of(elements).forEachOrdered(arg_0 -> ((ArrayNode)o.putArray(name)).add(arg_0));
    }

    public static void put(ObjectNode o, String name, long[][] elements) {
        Stream.of(elements).forEachOrdered(arg_0 -> ((ArrayNode)o.putArray(name)).addPOJO(arg_0));
    }

    public static void put(ObjectNode o, String name, int[] elements) {
        IntStream.of(elements).forEachOrdered(arg_0 -> ((ArrayNode)o.putArray(name)).add(arg_0));
    }

    public static void put(ObjectNode o, String name, double[] elements) {
        DoubleStream.of(elements).forEachOrdered(arg_0 -> ((ArrayNode)o.putArray(name)).add(arg_0));
    }

    public static void put(ObjectNode o, String name, Map<String, String> map) {
        map.forEach((arg_0, arg_1) -> ((ObjectNode)o.putObject(name)).put(arg_0, arg_1));
    }

    public static void put(ObjectNode o, String name, String[] elements) {
        Stream.of(elements).forEachOrdered(arg_0 -> ((ArrayNode)o.putArray(name)).add(arg_0));
    }

    public static void put(ObjectNode o, String name, List<String> elements) {
        elements.forEach(arg_0 -> ((ArrayNode)o.putArray(name)).add(arg_0));
    }

    public static void putArrayOrScalar(ObjectNode o, String name, List<String> elements) {
        switch (elements.size()) {
            case 0: {
                o.putNull(name);
                break;
            }
            case 1: {
                o.put(name, elements.get(0));
                break;
            }
            default: {
                ArrayNode arrayNode = o.putArray(name);
                for (String item : elements) {
                    arrayNode.add(item);
                }
            }
        }
    }

    public static ObjectNode createObject() {
        return OBJECT_MAPPER.createObjectNode();
    }

    public static ArrayNode createArray() {
        return OBJECT_MAPPER.createArrayNode();
    }

    static {
        SORTED_MAPPER.configure(SerializationFeature.ORDER_MAP_ENTRIES_BY_KEYS, true);
        SORTED_MAPPER.configure(MapperFeature.SORT_PROPERTIES_ALPHABETICALLY, true);
    }
}

